// java wrapper for vtkObjectFactory object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkObjectFactory.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkObjectFactory_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkObjectFactory",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObjectFactory_CreateInstance_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  char * temp0;
  bool   temp1;
  vtkObject * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateInstance(temp0,temp1);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_CreateAllInstance_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkCollection * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, id1));

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateAllInstance(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_ReHash_12(JNIEnv* env, jobject obj)
{

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReHash();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_RegisterFactory_13(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObjectFactory * temp0;
  temp0 = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, id0));

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->RegisterFactory(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_UnRegisterFactory_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObjectFactory * temp0;
  temp0 = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, id0));

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegisterFactory(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_UnRegisterAllFactories_15(JNIEnv* env, jobject obj)
{

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegisterAllFactories();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObjectFactory_GetRegisteredFactories_16(JNIEnv* env, jobject obj)
{
  vtkObjectFactoryCollection * temp20;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegisteredFactories();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_HasOverrideAny_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasOverrideAny(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_GetOverrideInformation_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkOverrideInformationCollection * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkOverrideInformationCollection*>(vtkJavaGetPointerFromObject(env, id1));

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOverrideInformation(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_SetAllEnableFlags_19(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllEnableFlags(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_SetAllEnableFlags_110(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  int   temp0;
  char * temp1;
  char * temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllEnableFlags(temp0,temp1,temp2);
  delete[] temp1;
  delete[] temp2;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_IsTypeOf_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_IsA_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObjectFactory_GetNumberOfGenerationsFromBaseType_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObjectFactory_GetNumberOfGenerationsFromBase_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectFactory_GetVTKSourceVersion_115(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKSourceVersion();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectFactory_GetDescription_116(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescription();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_GetNumberOfOverrides_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfOverrides();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectFactory_GetClassOverrideName_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClassOverrideName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectFactory_GetClassOverrideWithName_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClassOverrideWithName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_GetEnableFlag_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableFlag(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectFactory_GetOverrideDescription_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOverrideDescription(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_SetEnableFlag_122(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  int   temp0;
  char * temp1;
  char * temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableFlag(temp0,temp1,temp2);
  delete[] temp1;
  delete[] temp2;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_GetEnableFlag_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableFlag(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_HasOverride_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasOverride(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectFactory_HasOverride_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasOverride(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectFactory_Disable_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  op->Disable(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectFactory_GetLibraryPath_127(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkObjectFactory* op = static_cast<vtkObjectFactory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLibraryPath();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}
