// java wrapper for vtkIntArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkIntArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkIntArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkIntArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jintArray JNICALL Java_vtk_vtkIntArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  int* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIntArray_SetJavaArray_10(JNIEnv* env, jobject obj, jintArray id0, jint len0)
{
  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  int* buffer = op->GetPointer(0);
  env->GetIntArrayRegion(id0, 0, len0, reinterpret_cast<jint*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIntArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIntArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIntArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIntArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIntArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkIntArray * temp20;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIntArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIntArray_GetValue_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkIntArray_GetValueRange_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int * temp20;
  temp0 = id0;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange(temp0);
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkIntArray_GetValueRange_18(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIntArray_SetValue_19(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIntArray_SetNumberOfValues_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIntArray_InsertValue_111(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIntArray_InsertNextValue_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIntArray_FastDownCast_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkIntArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIntArray_GetDataTypeValueMin_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIntArray_GetDataTypeValueMax_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIntArray* op = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkIntArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkIntArray::New());
}
