// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkCellGridShaderVertex.h"

const char *vtkCellGridShaderVertex =
"//VTK::System::Dec\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"//VTK::Camera::Dec\n"
"\n"
"// The parametric coordinates of each shape-attribute integration point.\n"
"uniform samplerBuffer cell_parametrics;\n"
"\n"
"// Tuples of (cell-id, side-id) to render.\n"
"uniform highp isamplerBuffer sides;\n"
"// Look up the offset at which local cell-side connectivity starts in \\a side_local.\n"
"uniform highp isamplerBuffer side_offsets;\n"
"// The subset of DOFs in shape_conn that correspond to each side in cells of this shape.\n"
"uniform highp isamplerBuffer side_local;\n"
"// The indices of all DOFs for all cells of this shape.\n"
"uniform highp isamplerBuffer shape_conn;\n"
"// The (x,y,z) points of each DOF in the entire mesh.\n"
"uniform samplerBuffer shape_vals;\n"
"\n"
"flat out int cellIdVSOutput;\n"
"flat out int sideIdVSOutput;\n"
"flat out int instanceIdVSOutput;\n"
"\n"
"{commonDefs}\n"
"{cellEval}\n"
"{cellUtil}\n"
"\n"
"/// Parametric coordinates of this vertex.\n"
"smooth out vec3 pcoordVSOutput;\n"
"\n"
"#if !{UsesTessellationShaders}\n"
"/// View coordinate normal for this vertex.\n"
"//VTK::Normal::Dec\n"
"\n"
"/// View coordinate position for this vertex.\n"
"//VTK::PositionVC::Dec\n"
"#endif\n"
"\n"
"void main()\n"
"{{\n"
"  // Identify the cell ID and side ID (if applicable) we are to render.\n"
"  ivec2 cellAndSide;\n"
"  if (DrawingCellsNotSides)\n"
"  {{\n"
"     cellAndSide = ivec2(gl_InstanceID, 0);\n"
"     // These two VS outputs are to be used for picking:\n"
"     cellIdVSOutput = cellAndSide.s;\n"
"     sideIdVSOutput = -1;\n"
"     // Note sideIdVSOutput != cellAndSide.t; this is so that we can properly\n"
"     // compute the cell connectivity (using the zero offset in cellAndSide.t)\n"
"     // while also computing the normal (using sideIdVSOutput).\n"
"  }}\n"
"  else\n"
"  {{\n"
"     cellAndSide = texelFetchBuffer(sides, gl_InstanceID).st;\n"
"     // These two VS outputs are to be used for picking:\n"
"     cellIdVSOutput = cellAndSide.s;\n"
"     sideIdVSOutput = cellAndSide.t;\n"
"  }}\n"
"  instanceIdVSOutput = gl_InstanceID;\n"
"\n"
"  // Fetch the offset into the (ragged) side_local table:\n"
"  int sideRaggedOffset = texelFetchBuffer(side_offsets, {ShapeIndex}).s;\n"
"\n"
"  // Now compute the location of the current vertex inside the current side or cell.\n"
"  // NB: {{SideOffset}} = {SideOffset} is the offset to apply to side IDs so we can\n"
"  // look up their connectivity offset from sideRaggedOffset (the start in side_local\n"
"  // for connectivity of sides of our type).\n"
"  int sideVertexIndex =\n"
"    texelFetchBuffer(side_local,\n"
"      sideRaggedOffset + (cellAndSide.t - {SideOffset}) * NumPtsPerSide + gl_VertexID).s;\n"
"  int vertexId = texelFetchBuffer(shape_conn, cellIdVSOutput * {ShapeNumBasisFun} + sideVertexIndex).s;\n"
"  // Parametric coordinate for this vertex.\n"
"  pcoordVSOutput = texelFetchBuffer(cell_parametrics, sideVertexIndex).xyz;\n"
"  // position for this vertex as defined in vtk data model.\n"
"  vec4 vertexMC = vec4(\n"
"      texelFetchBuffer(shape_vals, vertexId * 3).x,\n"
"      texelFetchBuffer(shape_vals, vertexId * 3 + 1).x,\n"
"      texelFetchBuffer(shape_vals, vertexId * 3 + 2).x,\n"
"      1.0f);\n"
"#if !{UsesTessellationShaders}\n"
"  float shapeValues[{ShapeCoeffPerCell}];\n"
"  shapeValuesForCell(cellIdVSOutput, shapeValues);\n"
"  // default eye direction in model coordinates.\n"
"  vec3 eyeNormalMC = vec3(0.0f, 0.0f, 1.0f);\n"
"  vec3 vertexNormalMC = normalToSideAt(sideIdVSOutput, shapeValues, pcoordVSOutput, -eyeNormalMC);\n"
"\n"
"  // Transform the vertex by the model-to-device coordinate matrix.\n"
"  // This matrix must be the result of the following multiplication:\n"
"  // MCDCMatrix = ModelToWorld X WorldToView X ViewToDisplay\n"
"  gl_Position = MCDCMatrix * vertexMC;\n"
"\n"
"  // Transform vertex posittion to view coordinate.\n"
"  // Some operations in fragment shader want it that way.\n"
"  vertexVCVSOutput = MCVCMatrix * vertexMC;\n"
"\n"
"  // Normal vectors are transformed in a different way than vertices.\n"
"  // Instead of pre-multiplying with MCDCMatrix, a different matrix is used.\n"
"  // This `normalMatrix` is computed on the CPU. It must be the result of the following:\n"
"  // normalMatrix = inverse(ModelToWorld X WorldToView)\n"
"  // Read more about normal matrix at http://www.songho.ca/opengl/gl_normaltransform.html\n"
"  if ((DrawingCellsNotSides && NumPtsPerCell <= 2) || (!DrawingCellsNotSides && NumPtsPerSide <= 2))\n"
"  {{\n"
"    // for lines or vertices, the normal will always face the camera.\n"
"    normalVCVSOutput = vec3(vertexNormalMC.xy, 1.0f);\n"
"  }}\n"
"  else\n"
"  {{\n"
"    normalVCVSOutput = normalMatrix * vertexNormalMC;\n"
"  }}\n"
"#else\n"
"  gl_Position = vertexMC;\n"
"#endif\n"
"}}\n"
"";
