// python wrapper for vtkOpenXRSceneObserver
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkOpenXRSceneObserver.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOpenXRSceneObserver(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOpenXRSceneObserver_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOpenXRSceneObserver_SceneConsistency_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingOpenXR.vtkOpenXRSceneObserver.SceneConsistency", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkOpenXRSceneObserver_SceneConsistency_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkOpenXRSceneObserver_SceneConsistency_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOpenXRSceneObserver_SceneFeature_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingOpenXR.vtkOpenXRSceneObserver.SceneFeature", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkOpenXRSceneObserver_SceneFeature_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkOpenXRSceneObserver_SceneFeature_Type, static_cast<int>(val));
}


static PyObject *
PyvtkOpenXRSceneObserver_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOpenXRSceneObserver::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOpenXRSceneObserver::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOpenXRSceneObserver *tempr = vtkOpenXRSceneObserver::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOpenXRSceneObserver *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOpenXRSceneObserver::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOpenXRSceneObserver::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOpenXRSceneObserver::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Initialize() :
      op->vtkOpenXRSceneObserver::Initialize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_UpdateSceneData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateSceneData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->UpdateSceneData() :
      op->vtkOpenXRSceneObserver::UpdateSceneData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_GetComputeConsistency(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeConsistency");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef vtkOpenXRSceneObserver::SceneConsistency tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetComputeConsistency() :
      op->vtkOpenXRSceneObserver::GetComputeConsistency());

    if (!ap.ErrorOccurred())
    {
      result = PyvtkOpenXRSceneObserver_SceneConsistency_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_SetComputeConsistency(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeConsistency");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  typedef vtkOpenXRSceneObserver::SceneConsistency temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkOpenXRSceneObserver.SceneConsistency"))
  {
    if (ap.IsBound())
    {
      op->SetComputeConsistency(temp0);
    }
    else
    {
      op->vtkOpenXRSceneObserver::SetComputeConsistency(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_GetClippingRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClippingRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetClippingRadius() :
      op->vtkOpenXRSceneObserver::GetClippingRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_SetClippingRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClippingRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetClippingRadius(temp0);
    }
    else
    {
      op->vtkOpenXRSceneObserver::SetClippingRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_GetClippingRadiusMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClippingRadiusMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetClippingRadiusMinValue() :
      op->vtkOpenXRSceneObserver::GetClippingRadiusMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_GetClippingRadiusMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClippingRadiusMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetClippingRadiusMaxValue() :
      op->vtkOpenXRSceneObserver::GetClippingRadiusMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_EnableComputeFeature(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableComputeFeature");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  typedef vtkOpenXRSceneObserver::SceneFeature temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkOpenXRSceneObserver.SceneFeature"))
  {
    bool tempr = (ap.IsBound() ?
      op->EnableComputeFeature(temp0) :
      op->vtkOpenXRSceneObserver::EnableComputeFeature(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_DisableComputeFeature(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableComputeFeature");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  typedef vtkOpenXRSceneObserver::SceneFeature temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkOpenXRSceneObserver.SceneFeature"))
  {
    if (ap.IsBound())
    {
      op->DisableComputeFeature(temp0);
    }
    else
    {
      op->vtkOpenXRSceneObserver::DisableComputeFeature(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_IsComputeFeatureEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsComputeFeatureEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  typedef vtkOpenXRSceneObserver::SceneFeature temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkOpenXRSceneObserver.SceneFeature"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsComputeFeatureEnabled(temp0) :
      op->vtkOpenXRSceneObserver::IsComputeFeatureEnabled(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_IsComputeFeatureSupported(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsComputeFeatureSupported");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  typedef vtkOpenXRSceneObserver::SceneFeature temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkOpenXRSceneObserver.SceneFeature"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsComputeFeatureSupported(temp0) :
      op->vtkOpenXRSceneObserver::IsComputeFeatureSupported(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_SetMinimumInterval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinimumInterval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinimumInterval(temp0);
    }
    else
    {
      op->vtkOpenXRSceneObserver::SetMinimumInterval(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenXRSceneObserver_GetMinimumInterval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinimumInterval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenXRSceneObserver *op = static_cast<vtkOpenXRSceneObserver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMinimumInterval() :
      op->vtkOpenXRSceneObserver::GetMinimumInterval());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOpenXRSceneObserver_Methods[] = {
  {"IsTypeOf", PyvtkOpenXRSceneObserver_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOpenXRSceneObserver_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOpenXRSceneObserver_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOpenXRSceneObserver\nC++: static vtkOpenXRSceneObserver *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOpenXRSceneObserver_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOpenXRSceneObserver\nC++: vtkOpenXRSceneObserver *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOpenXRSceneObserver_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOpenXRSceneObserver_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkOpenXRSceneObserver_Initialize, METH_VARARGS,
   "Initialize(self) -> bool\nC++: bool Initialize()\n\nCreates runtime scene observer.\n"},
  {"UpdateSceneData", PyvtkOpenXRSceneObserver_UpdateSceneData, METH_VARARGS,
   "UpdateSceneData(self) -> bool\nC++: bool UpdateSceneData()\n\nUpdate scene data by polling the runtime.\n\nThis function does nothing if less than MinimumInterval seconds\nelapsed since last call.\n"},
  {"GetComputeConsistency", PyvtkOpenXRSceneObserver_GetComputeConsistency, METH_VARARGS,
   "GetComputeConsistency(self) -> SceneConsistency\nC++: virtual SceneConsistency GetComputeConsistency()\n\n"},
  {"SetComputeConsistency", PyvtkOpenXRSceneObserver_SetComputeConsistency, METH_VARARGS,
   "SetComputeConsistency(self, _arg:SceneConsistency) -> None\nC++: virtual void SetComputeConsistency(SceneConsistency _arg)\n\n"},
  {"GetClippingRadius", PyvtkOpenXRSceneObserver_GetClippingRadius, METH_VARARGS,
   "GetClippingRadius(self) -> float\nC++: virtual double GetClippingRadius()\n\nFinite positive radius of the clipping sphere, expressed in\nmeters.\n\nSphere is centered on the left eye position.\n\nThis only filters what is retrieved from the runtime. It has no\neffect on runtime environment analysis.\n\nDefault: 2.0\n"},
  {"SetClippingRadius", PyvtkOpenXRSceneObserver_SetClippingRadius, METH_VARARGS,
   "SetClippingRadius(self, _arg:float) -> None\nC++: virtual void SetClippingRadius(double _arg)\n\n"},
  {"GetClippingRadiusMinValue", PyvtkOpenXRSceneObserver_GetClippingRadiusMinValue, METH_VARARGS,
   "GetClippingRadiusMinValue(self) -> float\nC++: virtual double GetClippingRadiusMinValue()\n\n"},
  {"GetClippingRadiusMaxValue", PyvtkOpenXRSceneObserver_GetClippingRadiusMaxValue, METH_VARARGS,
   "GetClippingRadiusMaxValue(self) -> float\nC++: virtual double GetClippingRadiusMaxValue()\n\n"},
  {"EnableComputeFeature", PyvtkOpenXRSceneObserver_EnableComputeFeature, METH_VARARGS,
   "EnableComputeFeature(self, feature:SceneFeature) -> bool\nC++: bool EnableComputeFeature(SceneFeature feature)\n\nEnable or disable or check availability of a scene feature.\n\n`EnableComputeFeature` returns `true` if the feature has been (or\nis already) enabled.\n\nBy default, all supported features are enabled.\n"},
  {"DisableComputeFeature", PyvtkOpenXRSceneObserver_DisableComputeFeature, METH_VARARGS,
   "DisableComputeFeature(self, feature:SceneFeature) -> None\nC++: void DisableComputeFeature(SceneFeature feature)\n\n"},
  {"IsComputeFeatureEnabled", PyvtkOpenXRSceneObserver_IsComputeFeatureEnabled, METH_VARARGS,
   "IsComputeFeatureEnabled(self, feature:SceneFeature) -> bool\nC++: bool IsComputeFeatureEnabled(SceneFeature feature)\n\n"},
  {"IsComputeFeatureSupported", PyvtkOpenXRSceneObserver_IsComputeFeatureSupported, METH_VARARGS,
   "IsComputeFeatureSupported(self, feature:SceneFeature) -> bool\nC++: bool IsComputeFeatureSupported(SceneFeature feature)\n\n"},
  {"SetMinimumInterval", PyvtkOpenXRSceneObserver_SetMinimumInterval, METH_VARARGS,
   "SetMinimumInterval(self, _arg:float) -> None\nC++: virtual void SetMinimumInterval(double _arg)\n\nSet the minimum interval between two runtime queries.\n\nExpressed in seconds.\n\nDefault: 2.0\n"},
  {"GetMinimumInterval", PyvtkOpenXRSceneObserver_GetMinimumInterval, METH_VARARGS,
   "GetMinimumInterval(self) -> float\nC++: virtual double GetMinimumInterval()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOpenXRSceneObserver_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("compute_consistency"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenXRSceneObserver_GetComputeConsistency(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenXRSceneObserver_SetComputeConsistency(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenXRSceneObserver_SetComputeConsistency(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeConsistency/SetComputeConsistency\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("clipping_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenXRSceneObserver_GetClippingRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenXRSceneObserver_SetClippingRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenXRSceneObserver_SetClippingRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetClippingRadius/SetClippingRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("minimum_interval"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenXRSceneObserver_GetMinimumInterval(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenXRSceneObserver_SetMinimumInterval(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenXRSceneObserver_SetMinimumInterval(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinimumInterval/SetMinimumInterval\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOpenXRSceneObserver_Doc =
  "vtkOpenXRSceneObserver - no description provided.\n\n"
  "Superclass: vtkObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOpenXRSceneObserver_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingOpenXR.vtkOpenXRSceneObserver", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOpenXRSceneObserver_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOpenXRSceneObserver_StaticNew()
{
  return vtkOpenXRSceneObserver::New();
}

PyObject *PyvtkOpenXRSceneObserver_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOpenXRSceneObserver_Type, PyvtkOpenXRSceneObserver_Methods,
    "vtkOpenXRSceneObserver",
 &PyvtkOpenXRSceneObserver_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkOpenXRSceneObserver_SceneConsistency_Type);
  PyVTKEnum_Add(&PyvtkOpenXRSceneObserver_SceneConsistency_Type, "vtkOpenXRSceneObserver.SceneConsistency");

  o = (PyObject *)&PyvtkOpenXRSceneObserver_SceneConsistency_Type;
  if (PyDict_SetItemString(d, "SceneConsistency", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkOpenXRSceneObserver_SceneFeature_Type);
  PyVTKEnum_Add(&PyvtkOpenXRSceneObserver_SceneFeature_Type, "vtkOpenXRSceneObserver.SceneFeature");

  o = (PyObject *)&PyvtkOpenXRSceneObserver_SceneFeature_Type;
  if (PyDict_SetItemString(d, "SceneFeature", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkOpenXRSceneObserver::SceneConsistency cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "SnapshotComplete", vtkOpenXRSceneObserver::SnapshotComplete },
        { "SnapshotIncompleteFast", vtkOpenXRSceneObserver::SnapshotIncompleteFast },
        { "OcclusionOptimized", vtkOpenXRSceneObserver::OcclusionOptimized },
      };

    o = PyvtkOpenXRSceneObserver_SceneConsistency_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  o = PyvtkOpenXRSceneObserver_SceneFeature_FromEnum(vtkOpenXRSceneObserver::Markers);
  if (o)
  {
    PyDict_SetItemString(d, "Markers", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOpenXRSceneObserver_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOpenXRSceneObserver(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOpenXRSceneObserver_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOpenXRSceneObserver", o) != 0)
  {
    Py_DECREF(o);
  }

}

