/* TerminalWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TerminalWindow.vala, do not modify */

/*
 * TerminalWindow.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <vte/vte.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TERMINAL_WINDOW (terminal_window_get_type ())
#define TERMINAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TERMINAL_WINDOW, TerminalWindow))
#define TERMINAL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TERMINAL_WINDOW, TerminalWindowClass))
#define IS_TERMINAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TERMINAL_WINDOW))
#define IS_TERMINAL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TERMINAL_WINDOW))
#define TERMINAL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TERMINAL_WINDOW, TerminalWindowClass))

typedef struct _TerminalWindow TerminalWindow;
typedef struct _TerminalWindowClass TerminalWindowClass;
typedef struct _TerminalWindowPrivate TerminalWindowPrivate;
enum  {
	TERMINAL_WINDOW_0_PROPERTY,
	TERMINAL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* terminal_window_properties[TERMINAL_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TerminalWindow {
	GtkWindow parent_instance;
	TerminalWindowPrivate * priv;
	gboolean is_running;
};

struct _TerminalWindowClass {
	GtkWindowClass parent_class;
};

struct _TerminalWindowPrivate {
	GtkBox* vbox_main;
	VteTerminal* term;
	gint def_width;
	gint def_height;
	GPid child_pid;
	GtkWindow* parent_win;
};

static gint TerminalWindow_private_offset;
static gpointer terminal_window_parent_class = NULL;
VALA_EXTERN gchar* tee_jee_process_helper_TEMP_DIR;

VALA_EXTERN GType terminal_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalWindow, g_object_unref)
VALA_EXTERN TerminalWindow* terminal_window_new_with_parent (GtkWindow* parent);
VALA_EXTERN TerminalWindow* terminal_window_construct_with_parent (GType object_type,
                                                       GtkWindow* parent);
static gboolean __lambda22_ (TerminalWindow* self);
static gboolean ___lambda22__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
VALA_EXTERN void terminal_window_init_window (TerminalWindow* self);
VALA_EXTERN GdkPixbuf* icon_manager_lookup (const gchar* icon_name,
                                gint icon_size,
                                gboolean symbolic,
                                gboolean use_hardcoded,
                                gint scale);
VALA_EXTERN void terminal_window_start_shell (TerminalWindow* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void terminal_window_execute_script (TerminalWindow* self,
                                     const gchar* script_path,
                                     gboolean wait);
VALA_EXTERN void terminal_window_script_exit (TerminalWindow* self,
                                  gint status);
static void _terminal_window_script_exit_vte_terminal_child_exited (VteTerminal* _sender,
                                                             gint status,
                                                             gpointer self);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN TerminalWindow* terminal_window_new (void);
VALA_EXTERN TerminalWindow* terminal_window_construct (GType object_type);
static void terminal_window_finalize (GObject * obj);
static GType terminal_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
terminal_window_get_instance_private (TerminalWindow* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda22_ (TerminalWindow* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
___lambda22__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda22_ ((TerminalWindow*) self);
	return result;
}

TerminalWindow*
terminal_window_construct_with_parent (GType object_type,
                                       GtkWindow* parent)
{
	TerminalWindow * self = NULL;
	self = (TerminalWindow*) g_object_new (object_type, NULL);
	if (parent != NULL) {
		GtkWindow* _tmp0_;
		gtk_window_set_transient_for ((GtkWindow*) self, parent);
		_tmp0_ = _g_object_ref0 (parent);
		_g_object_unref0 (self->priv->parent_win);
		self->priv->parent_win = _tmp0_;
	}
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_fullscreen ((GtkWindow*) self);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda22__gtk_widget_delete_event, self, 0);
	terminal_window_init_window (self);
	return self;
}

TerminalWindow*
terminal_window_new_with_parent (GtkWindow* parent)
{
	return terminal_window_construct_with_parent (TYPE_TERMINAL_WINDOW, parent);
}

void
terminal_window_init_window (TerminalWindow* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	VteTerminal* _tmp5_;
	VteTerminal* _tmp6_;
	GtkBox* _tmp7_;
	VteTerminal* _tmp8_;
	VteTerminal* _tmp9_;
	VteTerminal* _tmp10_;
	VteTerminal* _tmp11_;
	VteTerminal* _tmp12_;
	VteTerminal* _tmp13_;
	VteTerminal* _tmp14_;
	GdkRGBA color = {0};
	VteTerminal* _tmp15_;
	GdkRGBA _tmp16_;
	VteTerminal* _tmp17_;
	GdkRGBA _tmp18_;
	VteTerminal* _tmp19_;
	g_return_if_fail (self != NULL);
	gtk_window_set_title ((GtkWindow*) self, "");
	_tmp0_ = icon_manager_lookup ("timeshift", 16, FALSE, FALSE, 1);
	_tmp1_ = _tmp0_;
	gtk_window_set_icon ((GtkWindow*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	gtk_window_set_resizable ((GtkWindow*) self, TRUE);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->vbox_main);
	self->priv->vbox_main = _tmp2_;
	_tmp3_ = self->priv->vbox_main;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, self->priv->def_width, self->priv->def_height);
	_tmp4_ = self->priv->vbox_main;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = (VteTerminal*) vte_terminal_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->term);
	self->priv->term = _tmp5_;
	_tmp6_ = self->priv->term;
	g_object_set ((GtkWidget*) _tmp6_, "expand", TRUE, NULL);
	_tmp7_ = self->priv->vbox_main;
	_tmp8_ = self->priv->term;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->term;
	vte_terminal_set_input_enabled (_tmp9_, TRUE);
	_tmp10_ = self->priv->term;
	g_object_set (_tmp10_, "backspace-binding", VTE_ERASE_AUTO, NULL);
	_tmp11_ = self->priv->term;
	vte_terminal_set_cursor_blink_mode (_tmp11_, VTE_CURSOR_BLINK_SYSTEM);
	_tmp12_ = self->priv->term;
	vte_terminal_set_cursor_shape (_tmp12_, VTE_CURSOR_SHAPE_UNDERLINE);
	_tmp13_ = self->priv->term;
	vte_terminal_set_scroll_on_keystroke (_tmp13_, TRUE);
	_tmp14_ = self->priv->term;
	vte_terminal_set_scroll_on_output (_tmp14_, TRUE);
	memset (&color, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&color, "#FFFFFF");
	_tmp15_ = self->priv->term;
	_tmp16_ = color;
	vte_terminal_set_color_foreground (_tmp15_, &_tmp16_);
	gdk_rgba_parse (&color, "#404040");
	_tmp17_ = self->priv->term;
	_tmp18_ = color;
	vte_terminal_set_color_background (_tmp17_, &_tmp18_);
	_tmp19_ = self->priv->term;
	gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
	gtk_widget_show_all ((GtkWidget*) self);
}

void
terminal_window_start_shell (TerminalWindow* self)
{
	gchar** argv = NULL;
	gchar** _tmp0_;
	gint argv_length1;
	gint _argv_size_;
	gchar* _tmp1_;
	gchar** env = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint env_length1;
	gint _env_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 1 + 1);
	argv = _tmp0_;
	argv_length1 = 1;
	_argv_size_ = argv_length1;
	_tmp1_ = g_strdup ("/bin/sh");
	_g_free0 (argv[0]);
	argv[0] = _tmp1_;
	_tmp3_ = _tmp2_ = g_get_environ ();
	env = _tmp3_;
	env_length1 = _vala_array_length (_tmp2_);
	_env_size_ = env_length1;
	{
		VteTerminal* _tmp4_;
		const gchar* _tmp5_;
		GPid _tmp6_ = 0;
		self->is_running = TRUE;
		_tmp4_ = self->priv->term;
		_tmp5_ = tee_jee_process_helper_TEMP_DIR;
		vte_terminal_spawn_sync (_tmp4_, VTE_PTY_DEFAULT, _tmp5_, argv, env, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp6_, NULL, &_inner_error0_);
		self->priv->child_pid = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		tee_jee_logging_log_error (_tmp8_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
}

static void
_terminal_window_script_exit_vte_terminal_child_exited (VteTerminal* _sender,
                                                        gint status,
                                                        gpointer self)
{
	terminal_window_script_exit ((TerminalWindow*) self, status);
}

void
terminal_window_execute_script (TerminalWindow* self,
                                const gchar* script_path,
                                gboolean wait)
{
	gchar** argv = NULL;
	gchar** _tmp0_;
	gint argv_length1;
	gint _argv_size_;
	gchar* _tmp1_;
	gchar** env = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint env_length1;
	gint _env_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (script_path != NULL);
	_tmp0_ = g_new0 (gchar*, 1 + 1);
	argv = _tmp0_;
	argv_length1 = 1;
	_argv_size_ = argv_length1;
	_tmp1_ = g_strdup (script_path);
	_g_free0 (argv[0]);
	argv[0] = _tmp1_;
	_tmp3_ = _tmp2_ = g_get_environ ();
	env = _tmp3_;
	env_length1 = _vala_array_length (_tmp2_);
	_env_size_ = env_length1;
	{
		VteTerminal* _tmp4_;
		const gchar* _tmp5_;
		GPid _tmp6_ = 0;
		VteTerminal* _tmp7_;
		VteTerminal* _tmp8_;
		self->is_running = TRUE;
		_tmp4_ = self->priv->term;
		_tmp5_ = tee_jee_process_helper_TEMP_DIR;
		vte_terminal_spawn_sync (_tmp4_, VTE_PTY_DEFAULT, _tmp5_, argv, env, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp6_, NULL, &_inner_error0_);
		self->priv->child_pid = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->term;
		vte_terminal_watch_child (_tmp7_, self->priv->child_pid);
		_tmp8_ = self->priv->term;
		g_signal_connect_object (_tmp8_, "child-exited", (GCallback) _terminal_window_script_exit_vte_terminal_child_exited, self, 0);
		if (wait) {
			while (TRUE) {
				if (!self->is_running) {
					break;
				}
				tee_jee_system_sleep (200);
				tee_jee_gtk_helper_gtk_do_events ();
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
}

void
terminal_window_script_exit (TerminalWindow* self,
                             gint status)
{
	GtkContainer* _tmp0_;
	GtkContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	self->is_running = FALSE;
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkWindow* _tmp2_;
		_tmp2_ = self->priv->parent_win;
		gtk_widget_destroy ((GtkWidget*) _tmp2_);
	}
}

TerminalWindow*
terminal_window_construct (GType object_type)
{
	TerminalWindow * self = NULL;
	self = (TerminalWindow*) g_object_new (object_type, NULL);
	return self;
}

TerminalWindow*
terminal_window_new (void)
{
	return terminal_window_construct (TYPE_TERMINAL_WINDOW);
}

static void
terminal_window_class_init (TerminalWindowClass * klass,
                            gpointer klass_data)
{
	terminal_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = terminal_window_finalize;
}

static void
terminal_window_instance_init (TerminalWindow * self,
                               gpointer klass)
{
	self->priv = terminal_window_get_instance_private (self);
	self->priv->def_width = 800;
	self->priv->def_height = 600;
	self->priv->parent_win = NULL;
	self->is_running = FALSE;
}

static void
terminal_window_finalize (GObject * obj)
{
	TerminalWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TERMINAL_WINDOW, TerminalWindow);
	_g_object_unref0 (self->priv->vbox_main);
	_g_object_unref0 (self->priv->term);
	_g_object_unref0 (self->priv->parent_win);
	G_OBJECT_CLASS (terminal_window_parent_class)->finalize (obj);
}

static GType
terminal_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalWindow), 0, (GInstanceInitFunc) terminal_window_instance_init, NULL };
	GType terminal_window_type_id;
	terminal_window_type_id = g_type_register_static (gtk_window_get_type (), "TerminalWindow", &g_define_type_info, 0);
	TerminalWindow_private_offset = g_type_add_instance_private (terminal_window_type_id, sizeof (TerminalWindowPrivate));
	return terminal_window_type_id;
}

GType
terminal_window_get_type (void)
{
	static volatile gsize terminal_window_type_id__once = 0;
	if (g_once_init_enter (&terminal_window_type_id__once)) {
		GType terminal_window_type_id;
		terminal_window_type_id = terminal_window_get_type_once ();
		g_once_init_leave (&terminal_window_type_id__once, terminal_window_type_id);
	}
	return terminal_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

