/* Subvolume.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Subvolume.vala, do not modify */

/*
 * Subvolume.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;
typedef struct _SubvolumePrivate SubvolumePrivate;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;
enum  {
	SUBVOLUME_0_PROPERTY,
	SUBVOLUME_TOTAL_FORMATTED_PROPERTY,
	SUBVOLUME_UNSHARED_FORMATTED_PROPERTY,
	SUBVOLUME_EXISTS_ON_DISK_PROPERTY,
	SUBVOLUME_IS_SYSTEM_SUBVOLUME_PROPERTY,
	SUBVOLUME_NUM_PROPERTIES
};
static GParamSpec* subvolume_properties[SUBVOLUME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;
typedef struct _DevicePrivate DevicePrivate;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;
typedef struct _FsTabEntryPrivate FsTabEntryPrivate;

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;

struct _Subvolume {
	GObject parent_instance;
	SubvolumePrivate * priv;
	gchar* device_uuid;
	gchar* name;
	gchar* path;
	glong id;
	gint64 total_bytes;
	gint64 unshared_bytes;
	gchar* mount_path;
	SnapshotRepo* repo;
};

struct _SubvolumeClass {
	GObjectClass parent_class;
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

struct _FsTabEntry {
	GObject parent_instance;
	FsTabEntryPrivate * priv;
	gboolean is_comment;
	gboolean is_empty_line;
	gchar* device_string;
	gchar* mount_point;
	gchar* type;
	gchar* options;
	gchar* dump;
	gchar* pass;
	gchar* line;
};

struct _FsTabEntryClass {
	GObjectClass parent_class;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_estimate_running;
	gboolean thread_estimate_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

static gpointer subvolume_parent_class = NULL;
VALA_EXTERN Main* App;
VALA_EXTERN gboolean main_btrfs_version__can_recursive_delete;

VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN Subvolume* subvolume_new (const gchar* name,
                          const gchar* path,
                          const gchar* parent_dev_uuid,
                          SnapshotRepo* parent_repo);
VALA_EXTERN Subvolume* subvolume_construct (GType object_type,
                                const gchar* name,
                                const gchar* path,
                                const gchar* parent_dev_uuid,
                                SnapshotRepo* parent_repo);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Device* subvolume_get_device (Subvolume* self);
VALA_EXTERN Device* device_get_device_by_uuid (const gchar* uuid);
VALA_EXTERN GeeHashMap* subvolume_detect_subvolumes_for_system_by_path (const gchar* system_path,
                                                            SnapshotRepo* repo,
                                                            GtkWindow* parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GeeArrayList* fs_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN GeeArrayList* crypt_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN gboolean fs_tab_entry_is_for_system_directory (FsTabEntry* self);
VALA_EXTERN gchar* fs_tab_entry_subvolume_name (FsTabEntry* self);
VALA_EXTERN Device* fs_tab_entry_resolve_device (FsTabEntry* self,
                                     GeeArrayList* crypttab,
                                     GtkWindow* parent_window);
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN void subvolume_print_info (Subvolume* self);
VALA_EXTERN gboolean subvolume_remove (Subvolume* self);
VALA_EXTERN gboolean subvolume_get_is_system_subvolume (Subvolume* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gint tee_jee_process_helper_exec_sync (const gchar* cmd,
                                       gchar** std_out,
                                       gchar** std_err);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN gboolean main_get_btrfs_qgroups_enabled (Main* self);
VALA_EXTERN gboolean subvolume_restore (Subvolume* self);
VALA_EXTERN gchar* subvolume_get_total_formatted (Subvolume* self);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
VALA_EXTERN gchar* subvolume_get_unshared_formatted (Subvolume* self);
VALA_EXTERN gboolean subvolume_get_exists_on_disk (Subvolume* self);
static void subvolume_finalize (GObject * obj);
static GType subvolume_get_type_once (void);
static void _vala_subvolume_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Subvolume*
subvolume_construct (GType object_type,
                     const gchar* name,
                     const gchar* path,
                     const gchar* parent_dev_uuid,
                     SnapshotRepo* parent_repo)
{
	Subvolume * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SnapshotRepo* _tmp3_;
	SnapshotRepo* _tmp4_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (parent_dev_uuid != NULL, NULL);
	self = (Subvolume*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (self->path);
	self->path = _tmp1_;
	_tmp2_ = g_strdup (parent_dev_uuid);
	_g_free0 (self->device_uuid);
	self->device_uuid = _tmp2_;
	_tmp3_ = _g_object_ref0 (parent_repo);
	_g_object_unref0 (self->repo);
	self->repo = _tmp3_;
	_tmp4_ = self->repo;
	if (_tmp4_ != NULL) {
		SnapshotRepo* _tmp5_;
		GeeHashMap* _tmp6_;
		gpointer _tmp7_;
		_tmp5_ = self->repo;
		_tmp6_ = _tmp5_->mount_paths;
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, name);
		_g_free0 (self->mount_path);
		self->mount_path = (gchar*) _tmp7_;
	}
	return self;
}

Subvolume*
subvolume_new (const gchar* name,
               const gchar* path,
               const gchar* parent_dev_uuid,
               SnapshotRepo* parent_repo)
{
	return subvolume_construct (TYPE_SUBVOLUME, name, path, parent_dev_uuid, parent_repo);
}

Device*
subvolume_get_device (Subvolume* self)
{
	const gchar* _tmp0_;
	Device* _tmp1_;
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->device_uuid;
	_tmp1_ = device_get_device_by_uuid (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeHashMap*
subvolume_detect_subvolumes_for_system_by_path (const gchar* system_path,
                                                SnapshotRepo* repo,
                                                GtkWindow* parent_window)
{
	GeeHashMap* map = NULL;
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeArrayList* fstab = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* crypttab = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeHashMap* result;
	g_return_val_if_fail (system_path != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_SUBVOLUME, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	_tmp1_ = g_strdup_printf ("Searching subvolume for system at path: %s", system_path);
	_tmp2_ = _tmp1_;
	tee_jee_logging_log_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = tee_jee_file_system_path_combine (system_path, "/etc/fstab");
	_tmp4_ = _tmp3_;
	_tmp5_ = fs_tab_entry_read_file (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	fstab = _tmp6_;
	_tmp7_ = tee_jee_file_system_path_combine (system_path, "/etc/crypttab");
	_tmp8_ = _tmp7_;
	_tmp9_ = crypt_tab_entry_read_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	crypttab = _tmp10_;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp11_;
		gint _item_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _item_index = 0;
		_tmp11_ = fstab;
		_item_list = _tmp11_;
		_tmp12_ = _item_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_item_size = _tmp14_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			FsTabEntry* item = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			FsTabEntry* _tmp19_;
			FsTabEntry* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gboolean _tmp25_;
			_item_index = _item_index + 1;
			_tmp15_ = _item_index;
			_tmp16_ = _item_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _item_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _item_index);
			item = (FsTabEntry*) _tmp18_;
			_tmp19_ = item;
			if (!fs_tab_entry_is_for_system_directory (_tmp19_)) {
				_g_object_unref0 (item);
				continue;
			}
			_tmp20_ = item;
			_tmp21_ = fs_tab_entry_subvolume_name (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = strlen (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = _tmp24_ > 0;
			_g_free0 (_tmp22_);
			if (_tmp25_) {
				Device* dev = NULL;
				FsTabEntry* _tmp26_;
				GeeArrayList* _tmp27_;
				Device* _tmp28_;
				const gchar* _tmp29_ = NULL;
				Device* _tmp30_;
				gchar* dev_name = NULL;
				gchar* _tmp33_;
				const gchar* _tmp34_ = NULL;
				Device* _tmp35_;
				gchar* dev_uuid = NULL;
				gchar* _tmp38_;
				FsTabEntry* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				Subvolume* subvol = NULL;
				FsTabEntry* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				FsTabEntry* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				Subvolume* _tmp51_;
				Subvolume* _tmp52_;
				GeeHashMap* _tmp53_;
				Subvolume* _tmp54_;
				const gchar* _tmp55_;
				Subvolume* _tmp56_;
				_tmp26_ = item;
				_tmp27_ = crypttab;
				_tmp28_ = fs_tab_entry_resolve_device (_tmp26_, _tmp27_, parent_window);
				dev = _tmp28_;
				_tmp30_ = dev;
				if (_tmp30_ == NULL) {
					_tmp29_ = "";
				} else {
					Device* _tmp31_;
					const gchar* _tmp32_;
					_tmp31_ = dev;
					_tmp32_ = _tmp31_->device;
					_tmp29_ = _tmp32_;
				}
				_tmp33_ = g_strdup (_tmp29_);
				dev_name = _tmp33_;
				_tmp35_ = dev;
				if (_tmp35_ == NULL) {
					_tmp34_ = "";
				} else {
					Device* _tmp36_;
					const gchar* _tmp37_;
					_tmp36_ = dev;
					_tmp37_ = _tmp36_->uuid;
					_tmp34_ = _tmp37_;
				}
				_tmp38_ = g_strdup (_tmp34_);
				dev_uuid = _tmp38_;
				_tmp39_ = item;
				_tmp40_ = fs_tab_entry_subvolume_name (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = dev_name;
				_tmp43_ = g_strdup_printf ("Found subvolume: %s, on device: %s", _tmp41_, _tmp42_);
				_tmp44_ = _tmp43_;
				tee_jee_logging_log_debug (_tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp41_);
				_tmp45_ = item;
				_tmp46_ = fs_tab_entry_subvolume_name (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = item;
				_tmp49_ = _tmp48_->mount_point;
				_tmp50_ = dev_uuid;
				_tmp51_ = subvolume_new (_tmp47_, _tmp49_, _tmp50_, repo);
				_tmp52_ = _tmp51_;
				_g_free0 (_tmp47_);
				subvol = _tmp52_;
				_tmp53_ = map;
				_tmp54_ = subvol;
				_tmp55_ = _tmp54_->name;
				_tmp56_ = subvol;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp53_, _tmp55_, _tmp56_);
				_g_object_unref0 (subvol);
				_g_free0 (dev_uuid);
				_g_free0 (dev_name);
				_g_object_unref0 (dev);
			}
			_g_object_unref0 (item);
		}
	}
	result = map;
	_g_object_unref0 (crypttab);
	_g_object_unref0 (fstab);
	return result;
}

void
subvolume_print_info (Subvolume* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->name;
	_tmp1_ = self->device_uuid;
	_tmp2_ = self->path;
	_tmp3_ = g_strdup_printf ("name=%s, uuid=%s, id=%ld, path=%s", _tmp0_, _tmp1_, self->id, _tmp2_);
	_tmp4_ = _tmp3_;
	tee_jee_logging_log_debug (_tmp4_);
	_g_free0 (_tmp4_);
}

gboolean
subvolume_remove (Subvolume* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* cmd = NULL;
	gchar* _tmp14_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gchar* subpath = NULL;
	gint ret_val = 0;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	Main* _tmp20_;
	gchar* options = NULL;
	gchar* _tmp21_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gint _tmp49_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	Main* _tmp69_;
	gboolean _tmp70_;
	gboolean _tmp71_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = subvolume_get_is_system_subvolume (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		const gchar* _tmp2_;
		_tmp2_ = self->name;
		if (g_strcmp0 (_tmp2_, "@") == 0) {
			Main* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = App;
			_tmp4_ = _tmp3_->mount_point_app;
			_tmp5_ = g_strconcat (_tmp4_, "/backup", NULL);
			_tmp6_ = _tmp5_;
			_tmp7_ = tee_jee_file_system_path_combine (_tmp6_, "@");
			_g_free0 (self->path);
			self->path = _tmp7_;
			_g_free0 (_tmp6_);
		} else {
			const gchar* _tmp8_;
			_tmp8_ = self->name;
			if (g_strcmp0 (_tmp8_, "@home") == 0) {
				Main* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp9_ = App;
				_tmp10_ = _tmp9_->mount_point_app;
				_tmp11_ = g_strconcat (_tmp10_, "/backup-home", NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = tee_jee_file_system_path_combine (_tmp12_, "@home");
				_g_free0 (self->path);
				self->path = _tmp13_;
				_g_free0 (_tmp12_);
			}
		}
	}
	_tmp14_ = g_strdup ("");
	cmd = _tmp14_;
	_tmp15_ = self->path;
	if (!tee_jee_file_system_dir_exists (_tmp15_)) {
		result = TRUE;
		_g_free0 (subpath);
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	}
	_tmp16_ = self->name;
	_tmp17_ = g_strdup_printf ("%s: %s (Id:%ld)", _ ("Deleting subvolume"), _tmp16_, self->id);
	_tmp18_ = _tmp17_;
	tee_jee_logging_log_msg (_tmp18_, FALSE);
	_g_free0 (_tmp18_);
	_tmp20_ = App;
	if (_tmp20_->use_option_raw) {
		_tmp19_ = "--commit-after";
	} else {
		_tmp19_ = "";
	}
	_tmp21_ = g_strdup (_tmp19_);
	options = _tmp21_;
	if (main_btrfs_version__can_recursive_delete) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = options;
		_tmp23_ = g_strconcat (_tmp22_, " --recursive", NULL);
		_g_free0 (options);
		options = _tmp23_;
	}
	_tmp24_ = self->path;
	_tmp25_ = self->name;
	_tmp26_ = tee_jee_file_system_path_combine (_tmp24_, _tmp25_);
	_g_free0 (subpath);
	subpath = _tmp26_;
	_tmp27_ = subpath;
	if (tee_jee_file_system_dir_exists (_tmp27_)) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gint _tmp35_;
		_tmp28_ = options;
		_tmp29_ = subpath;
		_tmp30_ = g_strdup_printf ("btrfs subvolume delete %s '%s'", _tmp28_, _tmp29_);
		_g_free0 (cmd);
		cmd = _tmp30_;
		tee_jee_logging_log_debug ("Deleting nested subvolume in snapshot");
		_tmp31_ = cmd;
		tee_jee_logging_log_debug (_tmp31_);
		_tmp32_ = cmd;
		_tmp35_ = tee_jee_process_helper_exec_sync (_tmp32_, &_tmp33_, &_tmp34_);
		_g_free0 (std_out);
		std_out = _tmp33_;
		_g_free0 (std_err);
		std_err = _tmp34_;
		ret_val = _tmp35_;
		if (ret_val != 0) {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp36_ = std_err;
			tee_jee_logging_log_error (_tmp36_, FALSE, FALSE);
			_tmp37_ = self->path;
			_tmp38_ = g_strdup_printf (": '%s'", _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_ ("Failed to delete snapshot nested subvolume"), _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			tee_jee_logging_log_error (_tmp41_, FALSE, FALSE);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			result = FALSE;
			_g_free0 (options);
			_g_free0 (subpath);
			_g_free0 (std_err);
			_g_free0 (std_out);
			_g_free0 (cmd);
			return result;
		}
	}
	_tmp42_ = options;
	_tmp43_ = self->path;
	_tmp44_ = g_strdup_printf ("btrfs subvolume delete %s '%s'", _tmp42_, _tmp43_);
	_g_free0 (cmd);
	cmd = _tmp44_;
	_tmp45_ = cmd;
	tee_jee_logging_log_debug (_tmp45_);
	_tmp46_ = cmd;
	_tmp49_ = tee_jee_process_helper_exec_sync (_tmp46_, &_tmp47_, &_tmp48_);
	_g_free0 (std_out);
	std_out = _tmp47_;
	_g_free0 (std_err);
	std_err = _tmp48_;
	ret_val = _tmp49_;
	if (ret_val != 0) {
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp50_ = std_err;
		tee_jee_logging_log_error (_tmp50_, FALSE, FALSE);
		_tmp51_ = self->path;
		_tmp52_ = g_strdup_printf (": '%s'", _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (_ ("Failed to delete snapshot subvolume"), _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		tee_jee_logging_log_error (_tmp55_, FALSE, FALSE);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		result = FALSE;
		_g_free0 (options);
		_g_free0 (subpath);
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	}
	tee_jee_logging_log_debug ("Waiting on btrfs to finish deleting...");
	while (TRUE) {
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gint _tmp61_;
		gboolean _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp56_ = self->mount_path;
		_tmp57_ = g_strdup_printf ("btrfs subvolume sync %s", _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp61_ = tee_jee_process_helper_exec_sync (_tmp58_, &_tmp59_, &_tmp60_);
		_g_free0 (std_out);
		std_out = _tmp59_;
		_g_free0 (std_err);
		std_err = _tmp60_;
		_tmp62_ = !(_tmp61_ != 0);
		_g_free0 (_tmp58_);
		if (_tmp62_) {
			break;
		}
		_tmp63_ = std_err;
		_tmp64_ = g_strdup_printf ("Still waiting for btrfs to finish deleting... %s", _tmp63_);
		_tmp65_ = _tmp64_;
		tee_jee_logging_log_debug (_tmp65_);
		_g_free0 (_tmp65_);
		tee_jee_system_sleep (1000);
	}
	_tmp66_ = self->name;
	_tmp67_ = g_strdup_printf ("%s: %s (Id:%ld)\n", _ ("Deleted subvolume"), _tmp66_, self->id);
	_tmp68_ = _tmp67_;
	tee_jee_logging_log_msg (_tmp68_, FALSE);
	_g_free0 (_tmp68_);
	_tmp69_ = App;
	_tmp70_ = main_get_btrfs_qgroups_enabled (_tmp69_);
	_tmp71_ = _tmp70_;
	if (_tmp71_) {
		gboolean _tmp72_ = FALSE;
		if (self->id > ((glong) 0)) {
			SnapshotRepo* _tmp73_;
			_tmp73_ = self->repo;
			_tmp72_ = _tmp73_ != NULL;
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			gchar* _tmp84_;
			gchar* _tmp85_;
			SnapshotRepo* _tmp86_;
			GeeHashMap* _tmp87_;
			const gchar* _tmp88_;
			gpointer _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			const gchar* _tmp92_;
			const gchar* _tmp93_;
			gchar* _tmp94_ = NULL;
			gchar* _tmp95_ = NULL;
			gint _tmp96_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			tee_jee_logging_log_debug ("Rescanning quotas...");
			while (TRUE) {
				const gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				gint _tmp79_;
				gboolean _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				_tmp74_ = self->mount_path;
				_tmp75_ = g_strdup_printf ("btrfs quota rescan %s", _tmp74_);
				_tmp76_ = _tmp75_;
				_tmp79_ = tee_jee_process_helper_exec_sync (_tmp76_, &_tmp77_, &_tmp78_);
				_g_free0 (std_out);
				std_out = _tmp77_;
				_g_free0 (std_err);
				std_err = _tmp78_;
				_tmp80_ = !(_tmp79_ != 0);
				_g_free0 (_tmp76_);
				if (_tmp80_) {
					break;
				}
				_tmp81_ = std_err;
				_tmp82_ = g_strdup_printf ("Still rescanning quotas... %s", _tmp81_);
				_tmp83_ = _tmp82_;
				tee_jee_logging_log_debug (_tmp83_);
				_g_free0 (_tmp83_);
				tee_jee_system_sleep (1000);
			}
			_tmp84_ = g_strdup_printf ("%s: 0/%ld", _ ("Destroying qgroup"), self->id);
			_tmp85_ = _tmp84_;
			tee_jee_logging_log_msg (_tmp85_, FALSE);
			_g_free0 (_tmp85_);
			_tmp86_ = self->repo;
			_tmp87_ = _tmp86_->mount_paths;
			_tmp88_ = self->name;
			_tmp89_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp87_, _tmp88_);
			_tmp90_ = (gchar*) _tmp89_;
			_tmp91_ = g_strdup_printf ("btrfs qgroup destroy 0/%ld '%s'", self->id, _tmp90_);
			_g_free0 (cmd);
			cmd = _tmp91_;
			_g_free0 (_tmp90_);
			_tmp92_ = cmd;
			tee_jee_logging_log_debug (_tmp92_);
			_tmp93_ = cmd;
			_tmp96_ = tee_jee_process_helper_exec_sync (_tmp93_, &_tmp94_, &_tmp95_);
			_g_free0 (std_out);
			std_out = _tmp94_;
			_g_free0 (std_err);
			std_err = _tmp95_;
			ret_val = _tmp96_;
			if (ret_val != 0) {
				gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				_tmp97_ = g_strdup_printf (": '0/%ld'", self->id);
				_tmp98_ = _tmp97_;
				_tmp99_ = g_strconcat (_ ("Failed to destroy qgroup"), _tmp98_, NULL);
				_tmp100_ = _tmp99_;
				tee_jee_logging_log_error (_tmp100_, FALSE, FALSE);
				_g_free0 (_tmp100_);
				_g_free0 (_tmp98_);
				result = FALSE;
				_g_free0 (options);
				_g_free0 (subpath);
				_g_free0 (std_err);
				_g_free0 (std_out);
				_g_free0 (cmd);
				return result;
			}
			_tmp101_ = g_strdup_printf ("%s: 0/%ld\n", _ ("Destroyed qgroup"), self->id);
			_tmp102_ = _tmp101_;
			tee_jee_logging_log_msg (_tmp102_, FALSE);
			_g_free0 (_tmp102_);
			tee_jee_logging_log_debug ("Rescanning quotas (post)...");
			while (TRUE) {
				const gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_ = NULL;
				gchar* _tmp107_ = NULL;
				gint _tmp108_;
				gboolean _tmp109_;
				const gchar* _tmp110_;
				gchar* _tmp111_;
				gchar* _tmp112_;
				_tmp103_ = self->mount_path;
				_tmp104_ = g_strdup_printf ("btrfs quota rescan %s", _tmp103_);
				_tmp105_ = _tmp104_;
				_tmp108_ = tee_jee_process_helper_exec_sync (_tmp105_, &_tmp106_, &_tmp107_);
				_g_free0 (std_out);
				std_out = _tmp106_;
				_g_free0 (std_err);
				std_err = _tmp107_;
				_tmp109_ = !(_tmp108_ != 0);
				_g_free0 (_tmp105_);
				if (_tmp109_) {
					break;
				}
				_tmp110_ = std_err;
				_tmp111_ = g_strdup_printf ("Still rescanning quotas (post)... %s", _tmp110_);
				_tmp112_ = _tmp111_;
				tee_jee_logging_log_debug (_tmp112_);
				_g_free0 (_tmp112_);
				tee_jee_system_sleep (1000);
			}
			tee_jee_logging_log_debug ("Final sync (post)...");
			while (TRUE) {
				const gchar* _tmp113_;
				gchar* _tmp114_;
				gchar* _tmp115_;
				gchar* _tmp116_ = NULL;
				gchar* _tmp117_ = NULL;
				gint _tmp118_;
				gboolean _tmp119_;
				const gchar* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				_tmp113_ = self->mount_path;
				_tmp114_ = g_strdup_printf ("btrfs subvolume sync %s", _tmp113_);
				_tmp115_ = _tmp114_;
				_tmp118_ = tee_jee_process_helper_exec_sync (_tmp115_, &_tmp116_, &_tmp117_);
				_g_free0 (std_out);
				std_out = _tmp116_;
				_g_free0 (std_err);
				std_err = _tmp117_;
				_tmp119_ = !(_tmp118_ != 0);
				_g_free0 (_tmp115_);
				if (_tmp119_) {
					break;
				}
				_tmp120_ = std_err;
				_tmp121_ = g_strdup_printf ("Still syncing (post)... %s", _tmp120_);
				_tmp122_ = _tmp121_;
				tee_jee_logging_log_debug (_tmp122_);
				_g_free0 (_tmp122_);
				tee_jee_system_sleep (1000);
			}
		}
	}
	result = TRUE;
	_g_free0 (options);
	_g_free0 (subpath);
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	return result;
}

gboolean
subvolume_restore (Subvolume* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* src_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dst_path = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp11_;
	gchar* cmd = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint status = 0;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gint _tmp22_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = subvolume_get_is_system_subvolume (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->path;
	_tmp3_ = g_strdup (_tmp2_);
	src_path = _tmp3_;
	_tmp4_ = self->mount_path;
	_tmp5_ = self->name;
	_tmp6_ = tee_jee_file_system_path_combine (_tmp4_, _tmp5_);
	dst_path = _tmp6_;
	_tmp7_ = src_path;
	if (!tee_jee_file_system_dir_exists (_tmp7_)) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = src_path;
		_tmp9_ = g_strdup_printf ("%s: %s", _ ("Not Found"), _tmp8_);
		_tmp10_ = _tmp9_;
		tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
		_g_free0 (_tmp10_);
		result = FALSE;
		_g_free0 (dst_path);
		_g_free0 (src_path);
		return result;
	}
	_tmp11_ = dst_path;
	if (tee_jee_file_system_dir_exists (_tmp11_)) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = dst_path;
		_tmp13_ = g_strdup_printf ("%s: %s", _ ("Subvolume exists at destination"), _tmp12_);
		_tmp14_ = _tmp13_;
		tee_jee_logging_log_error (_tmp14_, FALSE, FALSE);
		_g_free0 (_tmp14_);
		result = FALSE;
		_g_free0 (dst_path);
		_g_free0 (src_path);
		return result;
	}
	_tmp15_ = src_path;
	_tmp16_ = dst_path;
	_tmp17_ = g_strdup_printf ("btrfs subvolume snapshot '%s' '%s'", _tmp15_, _tmp16_);
	cmd = _tmp17_;
	_tmp18_ = cmd;
	tee_jee_logging_log_debug (_tmp18_);
	_tmp19_ = cmd;
	_tmp22_ = tee_jee_process_helper_exec_sync (_tmp19_, &_tmp20_, &_tmp21_);
	_g_free0 (std_out);
	std_out = _tmp20_;
	_g_free0 (std_err);
	std_err = _tmp21_;
	status = _tmp22_;
	if (status != 0) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp23_ = std_err;
		tee_jee_logging_log_error (_tmp23_, FALSE, FALSE);
		_tmp24_ = g_strdup_printf (": %d", status);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_ ("btrfs returned an error"), _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		tee_jee_logging_log_error (_tmp27_, FALSE, FALSE);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_tmp28_ = self->name;
		_tmp29_ = g_strdup_printf (": %s", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_ ("Failed to restore system subvolume"), _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		tee_jee_logging_log_error (_tmp32_, FALSE, FALSE);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		result = FALSE;
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		_g_free0 (dst_path);
		_g_free0 (src_path);
		return result;
	}
	_tmp33_ = self->name;
	_tmp34_ = g_strdup_printf (": %s", _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_ ("Restored system subvolume"), _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	tee_jee_logging_log_msg (_tmp37_, FALSE);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	result = TRUE;
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	_g_free0 (dst_path);
	_g_free0 (src_path);
	return result;
}

gchar*
subvolume_get_total_formatted (Subvolume* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tee_jee_file_system_format_file_size ((guint64) self->total_bytes, FALSE, "", TRUE, 1);
	result = _tmp0_;
	return result;
}

gchar*
subvolume_get_unshared_formatted (Subvolume* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tee_jee_file_system_format_file_size ((guint64) self->unshared_bytes, FALSE, "", TRUE, 1);
	result = _tmp0_;
	return result;
}

gboolean
subvolume_get_exists_on_disk (Subvolume* self)
{
	gboolean result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->path;
	result = tee_jee_file_system_dir_exists (_tmp0_);
	return result;
}

gboolean
subvolume_get_is_system_subvolume (Subvolume* self)
{
	gboolean result;
	SnapshotRepo* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->repo;
	result = _tmp0_ == NULL;
	return result;
}

static void
subvolume_class_init (SubvolumeClass * klass,
                      gpointer klass_data)
{
	subvolume_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_subvolume_get_property;
	G_OBJECT_CLASS (klass)->finalize = subvolume_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUBVOLUME_TOTAL_FORMATTED_PROPERTY, subvolume_properties[SUBVOLUME_TOTAL_FORMATTED_PROPERTY] = g_param_spec_string ("total-formatted", "total-formatted", "total-formatted", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUBVOLUME_UNSHARED_FORMATTED_PROPERTY, subvolume_properties[SUBVOLUME_UNSHARED_FORMATTED_PROPERTY] = g_param_spec_string ("unshared-formatted", "unshared-formatted", "unshared-formatted", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUBVOLUME_EXISTS_ON_DISK_PROPERTY, subvolume_properties[SUBVOLUME_EXISTS_ON_DISK_PROPERTY] = g_param_spec_boolean ("exists-on-disk", "exists-on-disk", "exists-on-disk", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUBVOLUME_IS_SYSTEM_SUBVOLUME_PROPERTY, subvolume_properties[SUBVOLUME_IS_SYSTEM_SUBVOLUME_PROPERTY] = g_param_spec_boolean ("is-system-subvolume", "is-system-subvolume", "is-system-subvolume", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
subvolume_instance_init (Subvolume * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = g_strdup ("");
	self->name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->path = _tmp1_;
	self->id = (glong) -1;
	self->total_bytes = (gint64) 0;
	self->unshared_bytes = (gint64) 0;
	_tmp2_ = g_strdup ("");
	self->mount_path = _tmp2_;
}

static void
subvolume_finalize (GObject * obj)
{
	Subvolume * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUBVOLUME, Subvolume);
	_g_free0 (self->device_uuid);
	_g_free0 (self->name);
	_g_free0 (self->path);
	_g_free0 (self->mount_path);
	_g_object_unref0 (self->repo);
	G_OBJECT_CLASS (subvolume_parent_class)->finalize (obj);
}

static GType
subvolume_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SubvolumeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) subvolume_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Subvolume), 0, (GInstanceInitFunc) subvolume_instance_init, NULL };
	GType subvolume_type_id;
	subvolume_type_id = g_type_register_static (G_TYPE_OBJECT, "Subvolume", &g_define_type_info, 0);
	return subvolume_type_id;
}

GType
subvolume_get_type (void)
{
	static volatile gsize subvolume_type_id__once = 0;
	if (g_once_init_enter (&subvolume_type_id__once)) {
		GType subvolume_type_id;
		subvolume_type_id = subvolume_get_type_once ();
		g_once_init_leave (&subvolume_type_id__once, subvolume_type_id);
	}
	return subvolume_type_id__once;
}

static void
_vala_subvolume_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Subvolume * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUBVOLUME, Subvolume);
	switch (property_id) {
		case SUBVOLUME_TOTAL_FORMATTED_PROPERTY:
		g_value_take_string (value, subvolume_get_total_formatted (self));
		break;
		case SUBVOLUME_UNSHARED_FORMATTED_PROPERTY:
		g_value_take_string (value, subvolume_get_unshared_formatted (self));
		break;
		case SUBVOLUME_EXISTS_ON_DISK_PROPERTY:
		g_value_set_boolean (value, subvolume_get_exists_on_disk (self));
		break;
		case SUBVOLUME_IS_SYSTEM_SUBVOLUME_PROPERTY:
		g_value_set_boolean (value, subvolume_get_is_system_subvolume (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

