// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) Go Code Generator. DO NOT EDIT.

package azcertificates

// CertificatePolicyAction - The type of the action.
type CertificatePolicyAction string

const (
	// CertificatePolicyActionAutoRenew - A certificate policy that will auto-renew a certificate.
	CertificatePolicyActionAutoRenew CertificatePolicyAction = "AutoRenew"
	// CertificatePolicyActionEmailContacts - A certificate policy that will email certificate contacts.
	CertificatePolicyActionEmailContacts CertificatePolicyAction = "EmailContacts"
)

// PossibleCertificatePolicyActionValues returns the possible values for the CertificatePolicyAction const type.
func PossibleCertificatePolicyActionValues() []CertificatePolicyAction {
	return []CertificatePolicyAction{
		CertificatePolicyActionAutoRenew,
		CertificatePolicyActionEmailContacts,
	}
}

// CurveName - Elliptic curve name.
type CurveName string

const (
	// CurveNameP256 - The NIST P-256 elliptic curve, AKA SECG curve SECP256R1.
	CurveNameP256 CurveName = "P-256"
	// CurveNameP256K - The SECG SECP256K1 elliptic curve.
	CurveNameP256K CurveName = "P-256K"
	// CurveNameP384 - The NIST P-384 elliptic curve, AKA SECG curve SECP384R1.
	CurveNameP384 CurveName = "P-384"
	// CurveNameP521 - The NIST P-521 elliptic curve, AKA SECG curve SECP521R1.
	CurveNameP521 CurveName = "P-521"
)

// PossibleCurveNameValues returns the possible values for the CurveName const type.
func PossibleCurveNameValues() []CurveName {
	return []CurveName{
		CurveNameP256,
		CurveNameP256K,
		CurveNameP384,
		CurveNameP521,
	}
}

// KeyType - The type of key pair to be used for the certificate.
type KeyType string

const (
	// KeyTypeEC - Elliptic Curve.
	KeyTypeEC KeyType = "EC"
	// KeyTypeECHSM - Elliptic Curve with a private key which is not exportable from the HSM.
	KeyTypeECHSM KeyType = "EC-HSM"
	// KeyTypeOct - Octet sequence (used to represent symmetric keys).
	KeyTypeOct KeyType = "oct"
	// KeyTypeOctHSM - Octet sequence with a private key which is not exportable from the HSM.
	KeyTypeOctHSM KeyType = "oct-HSM"
	// KeyTypeRSA - RSA (https://tools.ietf.org/html/rfc3447).
	KeyTypeRSA KeyType = "RSA"
	// KeyTypeRSAHSM - RSA with a private key which is not exportable from the HSM.
	KeyTypeRSAHSM KeyType = "RSA-HSM"
)

// PossibleKeyTypeValues returns the possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{
		KeyTypeEC,
		KeyTypeECHSM,
		KeyTypeOct,
		KeyTypeOctHSM,
		KeyTypeRSA,
		KeyTypeRSAHSM,
	}
}

// KeyUsageType - Supported usages of a certificate key.
type KeyUsageType string

const (
	// KeyUsageTypeCRLSign - Indicates that the certificate key can be used to sign a certificate revocation list.
	KeyUsageTypeCRLSign KeyUsageType = "cRLSign"
	// KeyUsageTypeDataEncipherment - Indicates that the certificate key can be used for data encryption.
	KeyUsageTypeDataEncipherment KeyUsageType = "dataEncipherment"
	// KeyUsageTypeDecipherOnly - Indicates that the certificate key can be used for decryption only.
	KeyUsageTypeDecipherOnly KeyUsageType = "decipherOnly"
	// KeyUsageTypeDigitalSignature - Indicates that the certificate key can be used as a digital signature.
	KeyUsageTypeDigitalSignature KeyUsageType = "digitalSignature"
	// KeyUsageTypeEncipherOnly - Indicates that the certificate key can be used for encryption only.
	KeyUsageTypeEncipherOnly KeyUsageType = "encipherOnly"
	// KeyUsageTypeKeyAgreement - Indicates that the certificate key can be used to determine key agreement, such as a key created
	// using the Diffie-Hellman key agreement algorithm.
	KeyUsageTypeKeyAgreement KeyUsageType = "keyAgreement"
	// KeyUsageTypeKeyCertSign - Indicates that the certificate key can be used to sign certificates.
	KeyUsageTypeKeyCertSign KeyUsageType = "keyCertSign"
	// KeyUsageTypeKeyEncipherment - Indicates that the certificate key can be used for key encryption.
	KeyUsageTypeKeyEncipherment KeyUsageType = "keyEncipherment"
	// KeyUsageTypeNonRepudiation - Indicates that the certificate key can be used for authentication.
	KeyUsageTypeNonRepudiation KeyUsageType = "nonRepudiation"
)

// PossibleKeyUsageTypeValues returns the possible values for the KeyUsageType const type.
func PossibleKeyUsageTypeValues() []KeyUsageType {
	return []KeyUsageType{
		KeyUsageTypeCRLSign,
		KeyUsageTypeDataEncipherment,
		KeyUsageTypeDecipherOnly,
		KeyUsageTypeDigitalSignature,
		KeyUsageTypeEncipherOnly,
		KeyUsageTypeKeyAgreement,
		KeyUsageTypeKeyCertSign,
		KeyUsageTypeKeyEncipherment,
		KeyUsageTypeNonRepudiation,
	}
}
