/* SetupView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SetupView.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <granite-7.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include "cups/cups.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_OPTIONS_PAGE_0_PROPERTY,
	PRINTERS_OPTIONS_PAGE_PRINTER_PROPERTY,
	PRINTERS_OPTIONS_PAGE_NUM_PROPERTIES
};
static GParamSpec* printers_options_page_properties[PRINTERS_OPTIONS_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
#define __vala_GtkPaperSize_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkPaperSize_free (var), NULL)))
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block15Data Block15Data;

struct _PrintersOptionsPagePrivate {
	PrintersPrinter* _printer;
	gint row_index;
};

struct _Block9Data {
	int _ref_count_;
	PrintersOptionsPage* self;
	GtkSwitch* two_switch;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	gint page;
};

struct _Block11Data {
	int _ref_count_;
	Block9Data * _data9_;
	GtkCheckButton* mode_long;
};

struct _Block12Data {
	int _ref_count_;
	Block9Data * _data9_;
	GtkComboBoxText* combobox;
};

struct _Block13Data {
	int _ref_count_;
	Block9Data * _data9_;
	GtkComboBoxText* combobox;
};

struct _Block14Data {
	int _ref_count_;
	Block9Data * _data9_;
	GtkComboBoxText* combobox;
};

struct _Block15Data {
	int _ref_count_;
	Block9Data * _data9_;
	GtkComboBoxText* combobox;
};

static gint PrintersOptionsPage_private_offset;
static gpointer printers_options_page_parent_class = NULL;

static GObject * printers_options_page_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void _printers_options_page_____lambda11_ (Block10Data* _data10_);
static void __printers_options_page_____lambda11__gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void _printers_options_page____lambda12_ (PrintersOptionsPage* self);
static void __printers_options_page____lambda12__gtk_check_button_activate (GtkCheckButton* _sender,
                                                                     gpointer self);
static void _printers_options_page____lambda13_ (PrintersOptionsPage* self);
static void __printers_options_page____lambda13__gtk_check_button_activate (GtkCheckButton* _sender,
                                                                     gpointer self);
static void _printers_options_page____lambda14_ (Block11Data* _data11_);
static void __printers_options_page____lambda14__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _printers_options_page____lambda15_ (Block9Data* _data9_);
static void __printers_options_page____lambda15__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void _printers_options_page____lambda16_ (Block12Data* _data12_);
static void __printers_options_page____lambda16__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void _vala_GtkPaperSize_free (GtkPaperSize* self);
static void _printers_options_page____lambda17_ (PrintersOptionsPage* self);
static void __printers_options_page____lambda17__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void _printers_options_page____lambda18_ (Block13Data* _data13_);
static void __printers_options_page____lambda18__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void _printers_options_page____lambda19_ (Block14Data* _data14_);
static void __printers_options_page____lambda19__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void _printers_options_page____lambda20_ (Block15Data* _data15_);
static void __printers_options_page____lambda20__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void printers_options_page_finalize (GObject * obj);
static GType printers_options_page_get_type_once (void);
static void _vala_printers_options_page_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_printers_options_page_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
printers_options_page_get_instance_private (PrintersOptionsPage* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersOptionsPage_private_offset);
}

PrintersOptionsPage*
printers_options_page_construct (GType object_type,
                                 PrintersPrinter* printer)
{
	PrintersOptionsPage * self = NULL;
	g_return_val_if_fail (printer != NULL, NULL);
	self = (PrintersOptionsPage*) g_object_new (object_type, "printer", printer, NULL);
	return self;
}

PrintersOptionsPage*
printers_options_page_new (PrintersPrinter* printer)
{
	return printers_options_page_construct (PRINTERS_TYPE_OPTIONS_PAGE, printer);
}

PrintersPrinter*
printers_options_page_get_printer (PrintersOptionsPage* self)
{
	PrintersPrinter* result;
	PrintersPrinter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_printer;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
printers_options_page_set_printer (PrintersOptionsPage* self,
                                   PrintersPrinter* value)
{
	PrintersPrinter* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_options_page_get_printer (self);
	if (old_value != value) {
		PrintersPrinter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_printer);
		self->priv->_printer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_options_page_properties[PRINTERS_OPTIONS_PAGE_PRINTER_PROPERTY]);
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		PrintersOptionsPage* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->two_switch);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		PrintersOptionsPage* self;
		self = _data10_->_data9_->self;
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}

static void
_printers_options_page_____lambda11_ (Block10Data* _data10_)
{
	Block9Data* _data9_;
	PrintersOptionsPage* self;
	PrintersPrinter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	_tmp0_ = self->priv->_printer;
	_tmp1_ = g_strdup_printf ("%d", _data10_->page);
	_tmp2_ = _tmp1_;
	printers_printer_set_default_pages (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__printers_options_page_____lambda11__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	_printers_options_page_____lambda11_ (self);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		PrintersOptionsPage* self;
		self = _data11_->_data9_->self;
		_g_object_unref0 (_data11_->mode_long);
		block9_data_unref (_data11_->_data9_);
		_data11_->_data9_ = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}

static void
_printers_options_page____lambda12_ (PrintersOptionsPage* self)
{
	PrintersPrinter* _tmp0_;
	_tmp0_ = self->priv->_printer;
	printers_printer_set_default_side (_tmp0_, CUPS_SIDES_TWO_SIDED_PORTRAIT);
}

static void
__printers_options_page____lambda12__gtk_check_button_activate (GtkCheckButton* _sender,
                                                                gpointer self)
{
	_printers_options_page____lambda12_ ((PrintersOptionsPage*) self);
}

static void
_printers_options_page____lambda13_ (PrintersOptionsPage* self)
{
	PrintersPrinter* _tmp0_;
	_tmp0_ = self->priv->_printer;
	printers_printer_set_default_side (_tmp0_, CUPS_SIDES_TWO_SIDED_LANDSCAPE);
}

static void
__printers_options_page____lambda13__gtk_check_button_activate (GtkCheckButton* _sender,
                                                                gpointer self)
{
	_printers_options_page____lambda13_ ((PrintersOptionsPage*) self);
}

static void
_printers_options_page____lambda14_ (Block11Data* _data11_)
{
	Block9Data* _data9_;
	PrintersOptionsPage* self;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_data9_ = _data11_->_data9_;
	self = _data9_->self;
	_tmp0_ = _data9_->two_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkCheckButton* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = _data11_->mode_long;
		_tmp4_ = gtk_check_button_get_active (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			PrintersPrinter* _tmp6_;
			_tmp6_ = self->priv->_printer;
			printers_printer_set_default_side (_tmp6_, CUPS_SIDES_TWO_SIDED_PORTRAIT);
		} else {
			PrintersPrinter* _tmp7_;
			_tmp7_ = self->priv->_printer;
			printers_printer_set_default_side (_tmp7_, CUPS_SIDES_TWO_SIDED_LANDSCAPE);
		}
	} else {
		PrintersPrinter* _tmp8_;
		_tmp8_ = self->priv->_printer;
		printers_printer_set_default_side (_tmp8_, CUPS_SIDES_ONE_SIDED);
	}
}

static void
__printers_options_page____lambda14__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_printers_options_page____lambda14_ (self);
}

static void
_printers_options_page____lambda15_ (Block9Data* _data9_)
{
	PrintersOptionsPage* self;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data9_->self;
	_tmp0_ = _data9_->two_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PrintersPrinter* _tmp3_;
		_tmp3_ = self->priv->_printer;
		printers_printer_set_default_side (_tmp3_, CUPS_SIDES_TWO_SIDED_PORTRAIT);
	} else {
		PrintersPrinter* _tmp4_;
		_tmp4_ = self->priv->_printer;
		printers_printer_set_default_side (_tmp4_, CUPS_SIDES_ONE_SIDED);
	}
}

static void
__printers_options_page____lambda15__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_printers_options_page____lambda15_ (self);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		PrintersOptionsPage* self;
		self = _data12_->_data9_->self;
		_g_object_unref0 (_data12_->combobox);
		block9_data_unref (_data12_->_data9_);
		_data12_->_data9_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}

static void
_printers_options_page____lambda16_ (Block12Data* _data12_)
{
	Block9Data* _data9_;
	PrintersOptionsPage* self;
	PrintersPrinter* _tmp0_;
	GtkComboBoxText* _tmp1_;
	const gchar* _tmp2_;
	_data9_ = _data12_->_data9_;
	self = _data9_->self;
	_tmp0_ = self->priv->_printer;
	_tmp1_ = _data12_->combobox;
	_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
	printers_printer_set_default_orientation (_tmp0_, _tmp2_);
}

static void
__printers_options_page____lambda16__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_printers_options_page____lambda16_ (self);
}

static void
_vala_GtkPaperSize_free (GtkPaperSize* self)
{
	g_boxed_free (gtk_paper_size_get_type (), self);
}

static void
_printers_options_page____lambda17_ (PrintersOptionsPage* self)
{
}

static void
__printers_options_page____lambda17__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_printers_options_page____lambda17_ ((PrintersOptionsPage*) self);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		PrintersOptionsPage* self;
		self = _data13_->_data9_->self;
		_g_object_unref0 (_data13_->combobox);
		block9_data_unref (_data13_->_data9_);
		_data13_->_data9_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static void
_printers_options_page____lambda18_ (Block13Data* _data13_)
{
	Block9Data* _data9_;
	PrintersOptionsPage* self;
	PrintersPrinter* _tmp0_;
	GtkComboBoxText* _tmp1_;
	const gchar* _tmp2_;
	_data9_ = _data13_->_data9_;
	self = _data9_->self;
	_tmp0_ = self->priv->_printer;
	_tmp1_ = _data13_->combobox;
	_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
	printers_printer_set_default_print_color_mode (_tmp0_, _tmp2_);
}

static void
__printers_options_page____lambda18__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_printers_options_page____lambda18_ (self);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		PrintersOptionsPage* self;
		self = _data14_->_data9_->self;
		_g_object_unref0 (_data14_->combobox);
		block9_data_unref (_data14_->_data9_);
		_data14_->_data9_ = NULL;
		g_slice_free (Block14Data, _data14_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_printers_options_page____lambda19_ (Block14Data* _data14_)
{
	Block9Data* _data9_;
	PrintersOptionsPage* self;
	PrintersPrinter* _tmp0_;
	GtkComboBoxText* _tmp1_;
	const gchar* _tmp2_;
	_data9_ = _data14_->_data9_;
	self = _data9_->self;
	_tmp0_ = self->priv->_printer;
	_tmp1_ = _data14_->combobox;
	_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
	printers_printer_set_default_output_bin (_tmp0_, _tmp2_);
}

static void
__printers_options_page____lambda19__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_printers_options_page____lambda19_ (self);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		PrintersOptionsPage* self;
		self = _data15_->_data9_->self;
		_g_object_unref0 (_data15_->combobox);
		block9_data_unref (_data15_->_data9_);
		_data15_->_data9_ = NULL;
		g_slice_free (Block15Data, _data15_);
	}
}

static void
_printers_options_page____lambda20_ (Block15Data* _data15_)
{
	Block9Data* _data9_;
	PrintersOptionsPage* self;
	PrintersPrinter* _tmp0_;
	GtkComboBoxText* _tmp1_;
	const gchar* _tmp2_;
	_data9_ = _data15_->_data9_;
	self = _data9_->self;
	_tmp0_ = self->priv->_printer;
	_tmp1_ = _data15_->combobox;
	_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
	printers_printer_set_default_media_source (_tmp0_, _tmp2_);
}

static void
__printers_options_page____lambda20__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_printers_options_page____lambda20_ (self);
}

static GObject *
printers_options_page_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersOptionsPage * self;
	Block9Data* _data9_;
	GeeTreeSet* pages_per_sheet = NULL;
	GeeTreeSet* _tmp0_;
	gint default_page = 0;
	PrintersPrinter* _tmp1_;
	GeeTreeSet* _tmp2_;
	GtkBox* pages_box = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GeeTreeSet* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkLabel* pages_label = NULL;
	GtkLabel* _tmp27_ = NULL;
	GeeTreeSet* sides = NULL;
	GeeTreeSet* _tmp28_;
	gchar* default_side = NULL;
	PrintersPrinter* _tmp29_;
	GeeTreeSet* _tmp30_;
	gchar* _tmp31_;
	GtkSwitch* _tmp32_ = NULL;
	GeeTreeSet* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GtkBox* switch_box = NULL;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkSwitch* _tmp39_;
	GeeTreeSet* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GtkLabel* two_side_label = NULL;
	GtkLabel* _tmp69_ = NULL;
	GtkLabel* _tmp70_;
	GtkBox* _tmp71_;
	GtkLabel* _tmp72_;
	GtkBox* _tmp73_;
	GeeTreeSet* orientations = NULL;
	GeeTreeSet* _tmp74_;
	gint default_orientation = 0;
	PrintersPrinter* _tmp75_;
	GeeTreeSet* _tmp76_;
	GeeTreeSet* _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	GeeTreeSet* media_sizes = NULL;
	GeeTreeSet* _tmp106_;
	gchar* default_media_sizes = NULL;
	PrintersPrinter* _tmp107_;
	GeeTreeSet* _tmp108_;
	gchar* _tmp109_;
	GeeTreeSet* _tmp110_;
	gint _tmp111_;
	gint _tmp112_;
	GeeTreeSet* print_color_modes = NULL;
	GeeTreeSet* _tmp133_;
	gchar* default_color_mode = NULL;
	PrintersPrinter* _tmp134_;
	GeeTreeSet* _tmp135_;
	gchar* _tmp136_;
	GeeTreeSet* _tmp137_;
	gint _tmp138_;
	gint _tmp139_;
	GeeTreeSet* output_bins = NULL;
	GeeTreeSet* _tmp171_;
	gchar* default_output_bin = NULL;
	PrintersPrinter* _tmp172_;
	GeeTreeSet* _tmp173_;
	gchar* _tmp174_;
	GeeTreeSet* _tmp175_;
	gint _tmp176_;
	gint _tmp177_;
	GeeTreeSet* print_qualities = NULL;
	GeeTreeSet* _tmp249_;
	gint default_print_quality = 0;
	PrintersPrinter* _tmp250_;
	GeeTreeSet* _tmp251_;
	GeeTreeSet* _tmp252_;
	gint _tmp253_;
	gint _tmp254_;
	GeeTreeSet* media_sources = NULL;
	GeeTreeSet* _tmp277_;
	gchar* default_media_source = NULL;
	PrintersPrinter* _tmp278_;
	GeeTreeSet* _tmp279_;
	gchar* _tmp280_;
	GeeTreeSet* _tmp281_;
	gint _tmp282_;
	gint _tmp283_;
	PrintersPrinter* _tmp366_;
	parent_class = G_OBJECT_CLASS (printers_options_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_OPTIONS_PAGE, PrintersOptionsPage);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = gee_tree_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	pages_per_sheet = _tmp0_;
	_tmp1_ = self->priv->_printer;
	_tmp2_ = pages_per_sheet;
	default_page = printers_printer_get_pages_per_sheet (_tmp1_, _tmp2_);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	pages_box = _tmp3_;
	_tmp4_ = pages_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_LINKED);
	_tmp5_ = pages_per_sheet;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 1) {
		GtkBox* _tmp8_;
		_tmp8_ = pages_box;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
	}
	{
		GeeIterator* _page_it = NULL;
		GeeTreeSet* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp9_ = pages_per_sheet;
		_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
		_page_it = _tmp10_;
		while (TRUE) {
			Block10Data* _data10_;
			GeeIterator* _tmp11_;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			GtkToggleButton* toggle = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			GtkToggleButton* _tmp16_;
			GtkToggleButton* _tmp17_;
			GtkBox* _tmp18_;
			GtkWidget* _tmp19_;
			GtkBox* _tmp23_;
			GtkToggleButton* _tmp24_;
			GtkToggleButton* _tmp26_;
			_data10_ = g_slice_new0 (Block10Data);
			_data10_->_ref_count_ = 1;
			_data10_->_data9_ = block9_data_ref (_data9_);
			_tmp11_ = _page_it;
			if (!gee_iterator_next (_tmp11_)) {
				block10_data_unref (_data10_);
				_data10_ = NULL;
				break;
			}
			_tmp12_ = _page_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			_data10_->page = (gint) ((gintptr) _tmp13_);
			_tmp14_ = g_strdup_printf ("%d", _data10_->page);
			_tmp15_ = _tmp14_;
			_tmp16_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_tmp15_);
			g_object_ref_sink (_tmp16_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			toggle = _tmp17_;
			_tmp18_ = pages_box;
			_tmp19_ = gtk_widget_get_first_child ((GtkWidget*) _tmp18_);
			if (_tmp19_ != NULL) {
				GtkToggleButton* _tmp20_;
				GtkBox* _tmp21_;
				GtkWidget* _tmp22_;
				_tmp20_ = toggle;
				_tmp21_ = pages_box;
				_tmp22_ = gtk_widget_get_first_child ((GtkWidget*) _tmp21_);
				gtk_toggle_button_set_group (_tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_toggle_button_get_type (), GtkToggleButton));
			}
			_tmp23_ = pages_box;
			_tmp24_ = toggle;
			gtk_box_append (_tmp23_, (GtkWidget*) _tmp24_);
			if (_data10_->page == default_page) {
				GtkToggleButton* _tmp25_;
				_tmp25_ = toggle;
				gtk_toggle_button_set_active (_tmp25_, TRUE);
			}
			_tmp26_ = toggle;
			g_signal_connect_data ((GtkButton*) _tmp26_, "clicked", (GCallback) __printers_options_page_____lambda11__gtk_button_clicked, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
			_g_object_unref0 (toggle);
			block10_data_unref (_data10_);
			_data10_ = NULL;
		}
		_g_object_unref0 (_page_it);
	}
	_tmp27_ = (GtkLabel*) gtk_label_new (_ ("Pages per side:"));
	gtk_label_set_xalign (_tmp27_, (gfloat) 1);
	g_object_ref_sink (_tmp27_);
	pages_label = _tmp27_;
	_tmp28_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	sides = _tmp28_;
	_tmp29_ = self->priv->_printer;
	_tmp30_ = sides;
	_tmp31_ = printers_printer_get_sides (_tmp29_, _tmp30_);
	default_side = _tmp31_;
	_tmp32_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp32_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp32_);
	_data9_->two_switch = _tmp32_;
	_tmp33_ = sides;
	_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ == 1) {
		GtkSwitch* _tmp36_;
		_tmp36_ = _data9_->two_switch;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, FALSE);
	}
	_tmp37_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp37_);
	switch_box = _tmp37_;
	_tmp38_ = switch_box;
	_tmp39_ = _data9_->two_switch;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = sides;
	_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ > 2) {
		Block11Data* _data11_;
		GtkCheckButton* _tmp43_;
		GtkCheckButton* mode_short = NULL;
		GtkCheckButton* _tmp44_;
		GtkCheckButton* _tmp45_;
		GtkCheckButton* _tmp46_ = NULL;
		GtkSwitch* _tmp47_;
		GtkCheckButton* _tmp48_;
		GtkSwitch* _tmp49_;
		GtkCheckButton* _tmp50_;
		GtkBox* _tmp51_;
		GtkCheckButton* _tmp52_;
		GtkBox* _tmp53_;
		GtkCheckButton* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		GQuark _tmp58_ = 0U;
		static GQuark _tmp57_label0 = 0;
		static GQuark _tmp57_label1 = 0;
		static GQuark _tmp57_label2 = 0;
		GtkCheckButton* _tmp65_;
		GtkCheckButton* _tmp66_;
		GtkSwitch* _tmp67_;
		_data11_ = g_slice_new0 (Block11Data);
		_data11_->_ref_count_ = 1;
		_data11_->_data9_ = block9_data_ref (_data9_);
		_tmp43_ = (GtkCheckButton*) gtk_check_button_new_with_label (g_dpgettext2 ("gtk40", "printing option value", "Long Edge (Standard)"));
		g_object_ref_sink (_tmp43_);
		_data11_->mode_long = _tmp43_;
		_tmp44_ = _data11_->mode_long;
		_tmp45_ = _g_object_ref0 (_tmp44_);
		_tmp46_ = (GtkCheckButton*) gtk_check_button_new_with_label (g_dpgettext2 ("gtk40", "printing option value", "Short Edge (Flip)"));
		gtk_check_button_set_group (_tmp46_, _tmp45_);
		_g_object_unref0 (_tmp45_);
		g_object_ref_sink (_tmp46_);
		mode_short = _tmp46_;
		_tmp47_ = _data9_->two_switch;
		_tmp48_ = _data11_->mode_long;
		g_object_bind_property_with_closures ((GObject*) _tmp47_, "active", (GObject*) _tmp48_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp49_ = _data9_->two_switch;
		_tmp50_ = mode_short;
		g_object_bind_property_with_closures ((GObject*) _tmp49_, "active", (GObject*) _tmp50_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp51_ = switch_box;
		_tmp52_ = _data11_->mode_long;
		gtk_box_append (_tmp51_, (GtkWidget*) _tmp52_);
		_tmp53_ = switch_box;
		_tmp54_ = mode_short;
		gtk_box_append (_tmp53_, (GtkWidget*) _tmp54_);
		_tmp55_ = default_side;
		_tmp56_ = _tmp55_;
		_tmp58_ = (NULL == _tmp56_) ? 0 : g_quark_from_string (_tmp56_);
		if (_tmp58_ == ((0 != _tmp57_label0) ? _tmp57_label0 : (_tmp57_label0 = g_quark_from_static_string (CUPS_SIDES_TWO_SIDED_PORTRAIT)))) {
			switch (0) {
				default:
				{
					GtkCheckButton* _tmp59_;
					GtkSwitch* _tmp60_;
					_tmp59_ = _data11_->mode_long;
					gtk_check_button_set_active (_tmp59_, TRUE);
					_tmp60_ = _data9_->two_switch;
					gtk_switch_set_active (_tmp60_, TRUE);
					break;
				}
			}
		} else if (_tmp58_ == ((0 != _tmp57_label1) ? _tmp57_label1 : (_tmp57_label1 = g_quark_from_static_string (CUPS_SIDES_TWO_SIDED_LANDSCAPE)))) {
			switch (0) {
				default:
				{
					GtkCheckButton* _tmp61_;
					GtkSwitch* _tmp62_;
					_tmp61_ = mode_short;
					gtk_check_button_set_active (_tmp61_, TRUE);
					_tmp62_ = _data9_->two_switch;
					gtk_switch_set_active (_tmp62_, TRUE);
					break;
				}
			}
		} else if (_tmp58_ == ((0 != _tmp57_label2) ? _tmp57_label2 : (_tmp57_label2 = g_quark_from_static_string (CUPS_SIDES_ONE_SIDED)))) {
			switch (0) {
				default:
				{
					GtkCheckButton* _tmp63_;
					GtkSwitch* _tmp64_;
					_tmp63_ = _data11_->mode_long;
					gtk_check_button_set_active (_tmp63_, TRUE);
					_tmp64_ = _data9_->two_switch;
					gtk_switch_set_active (_tmp64_, FALSE);
					break;
				}
			}
		}
		_tmp65_ = _data11_->mode_long;
		g_signal_connect_object (_tmp65_, "activate", (GCallback) __printers_options_page____lambda12__gtk_check_button_activate, self, 0);
		_tmp66_ = mode_short;
		g_signal_connect_object (_tmp66_, "activate", (GCallback) __printers_options_page____lambda13__gtk_check_button_activate, self, 0);
		_tmp67_ = _data9_->two_switch;
		g_signal_connect_data ((GObject*) _tmp67_, "notify::active", (GCallback) __printers_options_page____lambda14__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
		_g_object_unref0 (mode_short);
		block11_data_unref (_data11_);
		_data11_ = NULL;
	} else {
		GtkSwitch* _tmp68_;
		_tmp68_ = _data9_->two_switch;
		g_signal_connect_data ((GObject*) _tmp68_, "notify::active", (GCallback) __printers_options_page____lambda15__g_object_notify, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	}
	_tmp69_ = (GtkLabel*) gtk_label_new (_ ("Two-sided:"));
	gtk_label_set_xalign (_tmp69_, (gfloat) 1);
	g_object_ref_sink (_tmp69_);
	two_side_label = _tmp69_;
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 12);
	_tmp70_ = pages_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp70_, 1, 0, 1, 1);
	_tmp71_ = pages_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp71_, 2, 0, 1, 1);
	_tmp72_ = two_side_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp72_, 1, 1, 1, 1);
	_tmp73_ = switch_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp73_, 2, 1, 1, 1);
	_tmp74_ = gee_tree_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	orientations = _tmp74_;
	_tmp75_ = self->priv->_printer;
	_tmp76_ = orientations;
	default_orientation = printers_printer_get_orientations (_tmp75_, _tmp76_);
	_tmp77_ = orientations;
	_tmp78_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp77_);
	_tmp79_ = _tmp78_;
	if (_tmp79_ > 1) {
		Block12Data* _data12_;
		GtkComboBoxText* _tmp80_;
		GtkComboBoxText* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		GtkComboBoxText* _tmp101_;
		GtkLabel* label = NULL;
		GtkLabel* _tmp102_ = NULL;
		GtkLabel* _tmp103_;
		GtkComboBoxText* _tmp104_;
		gint _tmp105_;
		_data12_ = g_slice_new0 (Block12Data);
		_data12_->_ref_count_ = 1;
		_data12_->_data9_ = block9_data_ref (_data9_);
		_tmp80_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp80_);
		_data12_->combobox = _tmp80_;
		{
			GeeIterator* _orientation_it = NULL;
			GeeTreeSet* _tmp81_;
			GeeIterator* _tmp82_;
			_tmp81_ = orientations;
			_tmp82_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp81_);
			_orientation_it = _tmp82_;
			while (TRUE) {
				GeeIterator* _tmp83_;
				gint orientation = 0;
				GeeIterator* _tmp84_;
				gpointer _tmp85_;
				_tmp83_ = _orientation_it;
				if (!gee_iterator_next (_tmp83_)) {
					break;
				}
				_tmp84_ = _orientation_it;
				_tmp85_ = gee_iterator_get (_tmp84_);
				orientation = (gint) ((gintptr) _tmp85_);
				switch (orientation) {
					case 3:
					{
						GtkComboBoxText* _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp88_;
						_tmp86_ = _data12_->combobox;
						_tmp87_ = g_strdup_printf ("%d", 3);
						_tmp88_ = _tmp87_;
						gtk_combo_box_text_append (_tmp86_, _tmp88_, g_dgettext ("gtk40", "Portrait"));
						_g_free0 (_tmp88_);
						break;
					}
					case 4:
					{
						GtkComboBoxText* _tmp89_;
						gchar* _tmp90_;
						gchar* _tmp91_;
						_tmp89_ = _data12_->combobox;
						_tmp90_ = g_strdup_printf ("%d", 4);
						_tmp91_ = _tmp90_;
						gtk_combo_box_text_append (_tmp89_, _tmp91_, g_dgettext ("gtk40", "Landscape"));
						_g_free0 (_tmp91_);
						break;
					}
					case 5:
					{
						GtkComboBoxText* _tmp92_;
						gchar* _tmp93_;
						gchar* _tmp94_;
						_tmp92_ = _data12_->combobox;
						_tmp93_ = g_strdup_printf ("%d", 5);
						_tmp94_ = _tmp93_;
						gtk_combo_box_text_append (_tmp92_, _tmp94_, g_dgettext ("gtk40", "Reverse portrait"));
						_g_free0 (_tmp94_);
						break;
					}
					case 6:
					{
						GtkComboBoxText* _tmp95_;
						gchar* _tmp96_;
						gchar* _tmp97_;
						_tmp95_ = _data12_->combobox;
						_tmp96_ = g_strdup_printf ("%d", 6);
						_tmp97_ = _tmp96_;
						gtk_combo_box_text_append (_tmp95_, _tmp97_, g_dgettext ("gtk40", "Reverse landscape"));
						_g_free0 (_tmp97_);
						break;
					}
					default:
					break;
				}
			}
			_g_object_unref0 (_orientation_it);
		}
		_tmp98_ = _data12_->combobox;
		_tmp99_ = g_strdup_printf ("%d", default_orientation);
		_tmp100_ = _tmp99_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp98_, _tmp100_);
		_g_free0 (_tmp100_);
		_tmp101_ = _data12_->combobox;
		g_signal_connect_data ((GtkComboBox*) _tmp101_, "changed", (GCallback) __printers_options_page____lambda16__gtk_combo_box_changed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
		_tmp102_ = (GtkLabel*) gtk_label_new (_ ("Orientation:"));
		gtk_label_set_xalign (_tmp102_, (gfloat) 1);
		g_object_ref_sink (_tmp102_);
		label = _tmp102_;
		_tmp103_ = label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp103_, 1, self->priv->row_index, 1, 1);
		_tmp104_ = _data12_->combobox;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp104_, 2, self->priv->row_index, 1, 1);
		_tmp105_ = self->priv->row_index;
		self->priv->row_index = _tmp105_ + 1;
		_g_object_unref0 (label);
		block12_data_unref (_data12_);
		_data12_ = NULL;
	}
	_tmp106_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	media_sizes = _tmp106_;
	_tmp107_ = self->priv->_printer;
	_tmp108_ = media_sizes;
	_tmp109_ = printers_printer_get_media_sizes (_tmp107_, _tmp108_);
	default_media_sizes = _tmp109_;
	_tmp110_ = media_sizes;
	_tmp111_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp110_);
	_tmp112_ = _tmp111_;
	if (_tmp112_ > 1) {
		GtkComboBoxText* combobox = NULL;
		GtkComboBoxText* _tmp113_;
		GtkComboBoxText* _tmp126_;
		const gchar* _tmp127_;
		GtkComboBoxText* _tmp128_;
		GtkLabel* label = NULL;
		GtkLabel* _tmp129_ = NULL;
		GtkLabel* _tmp130_;
		GtkComboBoxText* _tmp131_;
		gint _tmp132_;
		_tmp113_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp113_);
		combobox = _tmp113_;
		{
			GeeIterator* _media_size_it = NULL;
			GeeTreeSet* _tmp114_;
			GeeIterator* _tmp115_;
			_tmp114_ = media_sizes;
			_tmp115_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp114_);
			_media_size_it = _tmp115_;
			while (TRUE) {
				GeeIterator* _tmp116_;
				gchar* media_size = NULL;
				GeeIterator* _tmp117_;
				gpointer _tmp118_;
				GtkPaperSize* papersize = NULL;
				const gchar* _tmp119_;
				GtkPaperSize* _tmp120_;
				GtkComboBoxText* _tmp121_;
				GtkPaperSize* _tmp122_;
				const gchar* _tmp123_;
				GtkPaperSize* _tmp124_;
				const gchar* _tmp125_;
				_tmp116_ = _media_size_it;
				if (!gee_iterator_next (_tmp116_)) {
					break;
				}
				_tmp117_ = _media_size_it;
				_tmp118_ = gee_iterator_get (_tmp117_);
				media_size = (gchar*) _tmp118_;
				_tmp119_ = media_size;
				_tmp120_ = gtk_paper_size_new (_tmp119_);
				papersize = _tmp120_;
				_tmp121_ = combobox;
				_tmp122_ = papersize;
				_tmp123_ = gtk_paper_size_get_name (_tmp122_);
				_tmp124_ = papersize;
				_tmp125_ = gtk_paper_size_get_display_name (_tmp124_);
				gtk_combo_box_text_append (_tmp121_, _tmp123_, _tmp125_);
				__vala_GtkPaperSize_free0 (papersize);
				_g_free0 (media_size);
			}
			_g_object_unref0 (_media_size_it);
		}
		_tmp126_ = combobox;
		_tmp127_ = default_media_sizes;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp126_, _tmp127_);
		_tmp128_ = combobox;
		g_signal_connect_object ((GtkComboBox*) _tmp128_, "changed", (GCallback) __printers_options_page____lambda17__gtk_combo_box_changed, self, 0);
		_tmp129_ = (GtkLabel*) gtk_label_new (_ ("Media Size:"));
		gtk_label_set_xalign (_tmp129_, (gfloat) 1);
		g_object_ref_sink (_tmp129_);
		label = _tmp129_;
		_tmp130_ = label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp130_, 1, self->priv->row_index, 1, 1);
		_tmp131_ = combobox;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp131_, 2, self->priv->row_index, 1, 1);
		_tmp132_ = self->priv->row_index;
		self->priv->row_index = _tmp132_ + 1;
		_g_object_unref0 (label);
		_g_object_unref0 (combobox);
	}
	_tmp133_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	print_color_modes = _tmp133_;
	_tmp134_ = self->priv->_printer;
	_tmp135_ = print_color_modes;
	_tmp136_ = printers_printer_get_print_color_modes (_tmp134_, _tmp135_);
	default_color_mode = _tmp136_;
	_tmp137_ = print_color_modes;
	_tmp138_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp137_);
	_tmp139_ = _tmp138_;
	if (_tmp139_ > 1) {
		Block13Data* _data13_;
		GtkComboBoxText* _tmp140_;
		GtkComboBoxText* _tmp164_;
		const gchar* _tmp165_;
		GtkComboBoxText* _tmp166_;
		GtkLabel* label = NULL;
		GtkLabel* _tmp167_ = NULL;
		GtkLabel* _tmp168_;
		GtkComboBoxText* _tmp169_;
		gint _tmp170_;
		_data13_ = g_slice_new0 (Block13Data);
		_data13_->_ref_count_ = 1;
		_data13_->_data9_ = block9_data_ref (_data9_);
		_tmp140_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp140_);
		_data13_->combobox = _tmp140_;
		{
			GeeIterator* _print_color_mode_it = NULL;
			GeeTreeSet* _tmp141_;
			GeeIterator* _tmp142_;
			_tmp141_ = print_color_modes;
			_tmp142_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp141_);
			_print_color_mode_it = _tmp142_;
			while (TRUE) {
				GeeIterator* _tmp143_;
				gchar* print_color_mode = NULL;
				GeeIterator* _tmp144_;
				gpointer _tmp145_;
				const gchar* _tmp146_;
				const gchar* _tmp147_;
				GQuark _tmp149_ = 0U;
				static GQuark _tmp148_label0 = 0;
				static GQuark _tmp148_label1 = 0;
				static GQuark _tmp148_label2 = 0;
				static GQuark _tmp148_label3 = 0;
				static GQuark _tmp148_label4 = 0;
				static GQuark _tmp148_label5 = 0;
				static GQuark _tmp148_label6 = 0;
				_tmp143_ = _print_color_mode_it;
				if (!gee_iterator_next (_tmp143_)) {
					break;
				}
				_tmp144_ = _print_color_mode_it;
				_tmp145_ = gee_iterator_get (_tmp144_);
				print_color_mode = (gchar*) _tmp145_;
				_tmp146_ = print_color_mode;
				_tmp147_ = _tmp146_;
				_tmp149_ = (NULL == _tmp147_) ? 0 : g_quark_from_string (_tmp147_);
				if (_tmp149_ == ((0 != _tmp148_label0) ? _tmp148_label0 : (_tmp148_label0 = g_quark_from_static_string ("auto")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp150_;
							const gchar* _tmp151_;
							_tmp150_ = _data13_->combobox;
							_tmp151_ = print_color_mode;
							gtk_combo_box_text_append (_tmp150_, _tmp151_, _ ("Automatic"));
							break;
						}
					}
				} else if (_tmp149_ == ((0 != _tmp148_label1) ? _tmp148_label1 : (_tmp148_label1 = g_quark_from_static_string ("bi-level")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp152_;
							const gchar* _tmp153_;
							_tmp152_ = _data13_->combobox;
							_tmp153_ = print_color_mode;
							gtk_combo_box_text_append (_tmp152_, _tmp153_, _ ("One Color"));
							break;
						}
					}
				} else if (_tmp149_ == ((0 != _tmp148_label2) ? _tmp148_label2 : (_tmp148_label2 = g_quark_from_static_string ("color")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp154_;
							const gchar* _tmp155_;
							_tmp154_ = _data13_->combobox;
							_tmp155_ = print_color_mode;
							gtk_combo_box_text_append (_tmp154_, _tmp155_, _ ("Color"));
							break;
						}
					}
				} else if (_tmp149_ == ((0 != _tmp148_label3) ? _tmp148_label3 : (_tmp148_label3 = g_quark_from_static_string ("highlight")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp156_;
							const gchar* _tmp157_;
							_tmp156_ = _data13_->combobox;
							_tmp157_ = print_color_mode;
							gtk_combo_box_text_append (_tmp156_, _tmp157_, _ ("One Color + Black"));
							break;
						}
					}
				} else if (_tmp149_ == ((0 != _tmp148_label4) ? _tmp148_label4 : (_tmp148_label4 = g_quark_from_static_string ("monochrome")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp158_;
							const gchar* _tmp159_;
							_tmp158_ = _data13_->combobox;
							_tmp159_ = print_color_mode;
							gtk_combo_box_text_append (_tmp158_, _tmp159_, _ ("Greyscale"));
							break;
						}
					}
				} else if (_tmp149_ == ((0 != _tmp148_label5) ? _tmp148_label5 : (_tmp148_label5 = g_quark_from_static_string ("process-bi-level")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp160_;
							const gchar* _tmp161_;
							_tmp160_ = _data13_->combobox;
							_tmp161_ = print_color_mode;
							gtk_combo_box_text_append (_tmp160_, _tmp161_, _ ("Processed Color"));
							break;
						}
					}
				} else if (_tmp149_ == ((0 != _tmp148_label6) ? _tmp148_label6 : (_tmp148_label6 = g_quark_from_static_string ("process-monochrome")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp162_;
							const gchar* _tmp163_;
							_tmp162_ = _data13_->combobox;
							_tmp163_ = print_color_mode;
							gtk_combo_box_text_append (_tmp162_, _tmp163_, _ ("Processed Greyscale"));
							break;
						}
					}
				}
				_g_free0 (print_color_mode);
			}
			_g_object_unref0 (_print_color_mode_it);
		}
		_tmp164_ = _data13_->combobox;
		_tmp165_ = default_color_mode;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp164_, _tmp165_);
		_tmp166_ = _data13_->combobox;
		g_signal_connect_data ((GtkComboBox*) _tmp166_, "changed", (GCallback) __printers_options_page____lambda18__gtk_combo_box_changed, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		_tmp167_ = (GtkLabel*) gtk_label_new (_ ("Color mode:"));
		gtk_label_set_xalign (_tmp167_, (gfloat) 1);
		g_object_ref_sink (_tmp167_);
		label = _tmp167_;
		_tmp168_ = label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp168_, 1, self->priv->row_index, 1, 1);
		_tmp169_ = _data13_->combobox;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp169_, 2, self->priv->row_index, 1, 1);
		_tmp170_ = self->priv->row_index;
		self->priv->row_index = _tmp170_ + 1;
		_g_object_unref0 (label);
		block13_data_unref (_data13_);
		_data13_ = NULL;
	}
	_tmp171_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	output_bins = _tmp171_;
	_tmp172_ = self->priv->_printer;
	_tmp173_ = output_bins;
	_tmp174_ = printers_printer_get_output_bins (_tmp172_, _tmp173_);
	default_output_bin = _tmp174_;
	_tmp175_ = output_bins;
	_tmp176_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp175_);
	_tmp177_ = _tmp176_;
	if (_tmp177_ > 1) {
		Block14Data* _data14_;
		GtkComboBoxText* _tmp178_;
		GtkComboBoxText* _tmp242_;
		const gchar* _tmp243_;
		GtkComboBoxText* _tmp244_;
		GtkLabel* label = NULL;
		GtkLabel* _tmp245_ = NULL;
		GtkLabel* _tmp246_;
		GtkComboBoxText* _tmp247_;
		gint _tmp248_;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->_data9_ = block9_data_ref (_data9_);
		_tmp178_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp178_);
		_data14_->combobox = _tmp178_;
		{
			GeeIterator* _output_bin_it = NULL;
			GeeTreeSet* _tmp179_;
			GeeIterator* _tmp180_;
			_tmp179_ = output_bins;
			_tmp180_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp179_);
			_output_bin_it = _tmp180_;
			while (TRUE) {
				GeeIterator* _tmp181_;
				gchar* output_bin = NULL;
				GeeIterator* _tmp182_;
				gpointer _tmp183_;
				const gchar* _tmp184_;
				const gchar* _tmp185_;
				GQuark _tmp187_ = 0U;
				static GQuark _tmp186_label0 = 0;
				static GQuark _tmp186_label1 = 0;
				static GQuark _tmp186_label2 = 0;
				static GQuark _tmp186_label3 = 0;
				static GQuark _tmp186_label4 = 0;
				static GQuark _tmp186_label5 = 0;
				static GQuark _tmp186_label6 = 0;
				static GQuark _tmp186_label7 = 0;
				static GQuark _tmp186_label8 = 0;
				static GQuark _tmp186_label9 = 0;
				static GQuark _tmp186_label10 = 0;
				static GQuark _tmp186_label11 = 0;
				_tmp181_ = _output_bin_it;
				if (!gee_iterator_next (_tmp181_)) {
					break;
				}
				_tmp182_ = _output_bin_it;
				_tmp183_ = gee_iterator_get (_tmp182_);
				output_bin = (gchar*) _tmp183_;
				_tmp184_ = output_bin;
				_tmp185_ = _tmp184_;
				_tmp187_ = (NULL == _tmp185_) ? 0 : g_quark_from_string (_tmp185_);
				if (_tmp187_ == ((0 != _tmp186_label0) ? _tmp186_label0 : (_tmp186_label0 = g_quark_from_static_string ("top")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp188_;
							const gchar* _tmp189_;
							_tmp188_ = _data14_->combobox;
							_tmp189_ = output_bin;
							gtk_combo_box_text_append (_tmp188_, _tmp189_, g_dgettext ("gtk40", "Top Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label1) ? _tmp186_label1 : (_tmp186_label1 = g_quark_from_static_string ("middle")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp190_;
							const gchar* _tmp191_;
							_tmp190_ = _data14_->combobox;
							_tmp191_ = output_bin;
							gtk_combo_box_text_append (_tmp190_, _tmp191_, g_dgettext ("gtk40", "Middle Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label2) ? _tmp186_label2 : (_tmp186_label2 = g_quark_from_static_string ("bottom")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp192_;
							const gchar* _tmp193_;
							_tmp192_ = _data14_->combobox;
							_tmp193_ = output_bin;
							gtk_combo_box_text_append (_tmp192_, _tmp193_, g_dgettext ("gtk40", "Bottom Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label3) ? _tmp186_label3 : (_tmp186_label3 = g_quark_from_static_string ("side")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp194_;
							const gchar* _tmp195_;
							_tmp194_ = _data14_->combobox;
							_tmp195_ = output_bin;
							gtk_combo_box_text_append (_tmp194_, _tmp195_, g_dgettext ("gtk40", "Side Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label4) ? _tmp186_label4 : (_tmp186_label4 = g_quark_from_static_string ("left")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp196_;
							const gchar* _tmp197_;
							_tmp196_ = _data14_->combobox;
							_tmp197_ = output_bin;
							gtk_combo_box_text_append (_tmp196_, _tmp197_, g_dgettext ("gtk40", "Left Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label5) ? _tmp186_label5 : (_tmp186_label5 = g_quark_from_static_string ("right")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp198_;
							const gchar* _tmp199_;
							_tmp198_ = _data14_->combobox;
							_tmp199_ = output_bin;
							gtk_combo_box_text_append (_tmp198_, _tmp199_, g_dgettext ("gtk40", "Right Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label6) ? _tmp186_label6 : (_tmp186_label6 = g_quark_from_static_string ("center")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp200_;
							const gchar* _tmp201_;
							_tmp200_ = _data14_->combobox;
							_tmp201_ = output_bin;
							gtk_combo_box_text_append (_tmp200_, _tmp201_, g_dgettext ("gtk40", "Center Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label7) ? _tmp186_label7 : (_tmp186_label7 = g_quark_from_static_string ("rear")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp202_;
							const gchar* _tmp203_;
							_tmp202_ = _data14_->combobox;
							_tmp203_ = output_bin;
							gtk_combo_box_text_append (_tmp202_, _tmp203_, g_dgettext ("gtk40", "Rear Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label8) ? _tmp186_label8 : (_tmp186_label8 = g_quark_from_static_string ("face-up")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp204_;
							const gchar* _tmp205_;
							_tmp204_ = _data14_->combobox;
							_tmp205_ = output_bin;
							gtk_combo_box_text_append (_tmp204_, _tmp205_, g_dgettext ("gtk40", "Face Up Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label9) ? _tmp186_label9 : (_tmp186_label9 = g_quark_from_static_string ("face-down")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp206_;
							const gchar* _tmp207_;
							_tmp206_ = _data14_->combobox;
							_tmp207_ = output_bin;
							gtk_combo_box_text_append (_tmp206_, _tmp207_, g_dgettext ("gtk40", "Face Down Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label10) ? _tmp186_label10 : (_tmp186_label10 = g_quark_from_static_string ("large-capacity")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp208_;
							const gchar* _tmp209_;
							_tmp208_ = _data14_->combobox;
							_tmp209_ = output_bin;
							gtk_combo_box_text_append (_tmp208_, _tmp209_, g_dgettext ("gtk40", "Large Capacity Bin"));
							break;
						}
					}
				} else if (_tmp187_ == ((0 != _tmp186_label11) ? _tmp186_label11 : (_tmp186_label11 = g_quark_from_static_string ("my-mailbox")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp210_;
							const gchar* _tmp211_;
							_tmp210_ = _data14_->combobox;
							_tmp211_ = output_bin;
							gtk_combo_box_text_append (_tmp210_, _tmp211_, g_dgettext ("gtk40", "My Mailbox"));
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp212_;
							_tmp212_ = output_bin;
							if (string_contains (_tmp212_, "stacker-")) {
								gint number = 0;
								const gchar* _tmp213_;
								gchar* _tmp214_;
								gchar* _tmp215_;
								gint _tmp216_;
								GtkComboBoxText* _tmp217_;
								const gchar* _tmp218_;
								gchar* _tmp219_;
								gchar* _tmp220_;
								_tmp213_ = output_bin;
								_tmp214_ = string_replace (_tmp213_, "stacker-", "");
								_tmp215_ = _tmp214_;
								_tmp216_ = atoi (_tmp215_);
								_g_free0 (_tmp215_);
								number = _tmp216_;
								_tmp217_ = _data14_->combobox;
								_tmp218_ = output_bin;
								_tmp219_ = g_strdup_printf (g_dgettext ("gtk40", "Stacker %d"), number);
								_tmp220_ = _tmp219_;
								gtk_combo_box_text_append (_tmp217_, _tmp218_, _tmp220_);
								_g_free0 (_tmp220_);
							} else {
								const gchar* _tmp221_;
								_tmp221_ = output_bin;
								if (string_contains (_tmp221_, "mailbox-")) {
									gint number = 0;
									const gchar* _tmp222_;
									gchar* _tmp223_;
									gchar* _tmp224_;
									gint _tmp225_;
									GtkComboBoxText* _tmp226_;
									const gchar* _tmp227_;
									gchar* _tmp228_;
									gchar* _tmp229_;
									_tmp222_ = output_bin;
									_tmp223_ = string_replace (_tmp222_, "mailbox-", "");
									_tmp224_ = _tmp223_;
									_tmp225_ = atoi (_tmp224_);
									_g_free0 (_tmp224_);
									number = _tmp225_;
									_tmp226_ = _data14_->combobox;
									_tmp227_ = output_bin;
									_tmp228_ = g_strdup_printf (g_dgettext ("gtk40", "Mailbox %d"), number);
									_tmp229_ = _tmp228_;
									gtk_combo_box_text_append (_tmp226_, _tmp227_, _tmp229_);
									_g_free0 (_tmp229_);
								} else {
									const gchar* _tmp230_;
									_tmp230_ = output_bin;
									if (string_contains (_tmp230_, "tray-")) {
										gint number = 0;
										const gchar* _tmp231_;
										gchar* _tmp232_;
										gchar* _tmp233_;
										gint _tmp234_;
										GtkComboBoxText* _tmp235_;
										const gchar* _tmp236_;
										gchar* _tmp237_;
										gchar* _tmp238_;
										_tmp231_ = output_bin;
										_tmp232_ = string_replace (_tmp231_, "tray-", "");
										_tmp233_ = _tmp232_;
										_tmp234_ = atoi (_tmp233_);
										_g_free0 (_tmp233_);
										number = _tmp234_;
										_tmp235_ = _data14_->combobox;
										_tmp236_ = output_bin;
										_tmp237_ = g_strdup_printf (g_dgettext ("gtk40", "Tray %d"), number);
										_tmp238_ = _tmp237_;
										gtk_combo_box_text_append (_tmp235_, _tmp236_, _tmp238_);
										_g_free0 (_tmp238_);
									} else {
										GtkComboBoxText* _tmp239_;
										const gchar* _tmp240_;
										const gchar* _tmp241_;
										_tmp239_ = _data14_->combobox;
										_tmp240_ = output_bin;
										_tmp241_ = output_bin;
										gtk_combo_box_text_append (_tmp239_, _tmp240_, _tmp241_);
									}
								}
							}
							break;
						}
					}
				}
				_g_free0 (output_bin);
			}
			_g_object_unref0 (_output_bin_it);
		}
		_tmp242_ = _data14_->combobox;
		_tmp243_ = default_output_bin;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp242_, _tmp243_);
		_tmp244_ = _data14_->combobox;
		g_signal_connect_data ((GtkComboBox*) _tmp244_, "changed", (GCallback) __printers_options_page____lambda19__gtk_combo_box_changed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
		_tmp245_ = (GtkLabel*) gtk_label_new (_ ("Output Tray:"));
		gtk_label_set_xalign (_tmp245_, (gfloat) 1);
		g_object_ref_sink (_tmp245_);
		label = _tmp245_;
		_tmp246_ = label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp246_, 1, self->priv->row_index, 1, 1);
		_tmp247_ = _data14_->combobox;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp247_, 2, self->priv->row_index, 1, 1);
		_tmp248_ = self->priv->row_index;
		self->priv->row_index = _tmp248_ + 1;
		_g_object_unref0 (label);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
	_tmp249_ = gee_tree_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	print_qualities = _tmp249_;
	_tmp250_ = self->priv->_printer;
	_tmp251_ = print_qualities;
	default_print_quality = printers_printer_get_print_qualities (_tmp250_, _tmp251_);
	_tmp252_ = print_qualities;
	_tmp253_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp252_);
	_tmp254_ = _tmp253_;
	if (_tmp254_ > 1) {
		GtkComboBoxText* combobox = NULL;
		GtkComboBoxText* _tmp255_;
		GtkComboBoxText* _tmp270_;
		gchar* _tmp271_;
		gchar* _tmp272_;
		GtkLabel* label = NULL;
		GtkLabel* _tmp273_ = NULL;
		GtkLabel* _tmp274_;
		GtkComboBoxText* _tmp275_;
		gint _tmp276_;
		_tmp255_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp255_);
		combobox = _tmp255_;
		{
			GeeIterator* _print_quality_it = NULL;
			GeeTreeSet* _tmp256_;
			GeeIterator* _tmp257_;
			_tmp256_ = print_qualities;
			_tmp257_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp256_);
			_print_quality_it = _tmp257_;
			while (TRUE) {
				GeeIterator* _tmp258_;
				gint print_quality = 0;
				GeeIterator* _tmp259_;
				gpointer _tmp260_;
				_tmp258_ = _print_quality_it;
				if (!gee_iterator_next (_tmp258_)) {
					break;
				}
				_tmp259_ = _print_quality_it;
				_tmp260_ = gee_iterator_get (_tmp259_);
				print_quality = (gint) ((gintptr) _tmp260_);
				switch (print_quality) {
					case 3:
					{
						GtkComboBoxText* _tmp261_;
						gchar* _tmp262_;
						gchar* _tmp263_;
						_tmp261_ = combobox;
						_tmp262_ = g_strdup_printf ("%d", print_quality);
						_tmp263_ = _tmp262_;
						gtk_combo_box_text_append (_tmp261_, _tmp263_, _ ("Draft"));
						_g_free0 (_tmp263_);
						break;
					}
					case 4:
					{
						GtkComboBoxText* _tmp264_;
						gchar* _tmp265_;
						gchar* _tmp266_;
						_tmp264_ = combobox;
						_tmp265_ = g_strdup_printf ("%d", print_quality);
						_tmp266_ = _tmp265_;
						gtk_combo_box_text_append (_tmp264_, _tmp266_, _ ("Normal"));
						_g_free0 (_tmp266_);
						break;
					}
					case 5:
					{
						GtkComboBoxText* _tmp267_;
						gchar* _tmp268_;
						gchar* _tmp269_;
						_tmp267_ = combobox;
						_tmp268_ = g_strdup_printf ("%d", print_quality);
						_tmp269_ = _tmp268_;
						gtk_combo_box_text_append (_tmp267_, _tmp269_, _ ("High"));
						_g_free0 (_tmp269_);
						break;
					}
					default:
					break;
				}
			}
			_g_object_unref0 (_print_quality_it);
		}
		_tmp270_ = combobox;
		_tmp271_ = g_strdup_printf ("%d", default_print_quality);
		_tmp272_ = _tmp271_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp270_, _tmp272_);
		_g_free0 (_tmp272_);
		_tmp273_ = (GtkLabel*) gtk_label_new (_ ("Quality:"));
		gtk_label_set_xalign (_tmp273_, (gfloat) 1);
		g_object_ref_sink (_tmp273_);
		label = _tmp273_;
		_tmp274_ = label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp274_, 1, self->priv->row_index, 1, 1);
		_tmp275_ = combobox;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp275_, 2, self->priv->row_index, 1, 1);
		_tmp276_ = self->priv->row_index;
		self->priv->row_index = _tmp276_ + 1;
		_g_object_unref0 (label);
		_g_object_unref0 (combobox);
	}
	_tmp277_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	media_sources = _tmp277_;
	_tmp278_ = self->priv->_printer;
	_tmp279_ = media_sources;
	_tmp280_ = printers_printer_get_media_sources (_tmp278_, _tmp279_);
	default_media_source = _tmp280_;
	_tmp281_ = media_sources;
	_tmp282_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp281_);
	_tmp283_ = _tmp282_;
	if (_tmp283_ > 1) {
		Block15Data* _data15_;
		GtkComboBoxText* _tmp284_;
		GtkComboBoxText* _tmp359_;
		const gchar* _tmp360_;
		GtkComboBoxText* _tmp361_;
		GtkLabel* label = NULL;
		GtkLabel* _tmp362_ = NULL;
		GtkLabel* _tmp363_;
		GtkComboBoxText* _tmp364_;
		gint _tmp365_;
		_data15_ = g_slice_new0 (Block15Data);
		_data15_->_ref_count_ = 1;
		_data15_->_data9_ = block9_data_ref (_data9_);
		_tmp284_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp284_);
		_data15_->combobox = _tmp284_;
		{
			GeeIterator* _media_source_it = NULL;
			GeeTreeSet* _tmp285_;
			GeeIterator* _tmp286_;
			_tmp285_ = media_sources;
			_tmp286_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp285_);
			_media_source_it = _tmp286_;
			while (TRUE) {
				GeeIterator* _tmp287_;
				gchar* media_source = NULL;
				GeeIterator* _tmp288_;
				gpointer _tmp289_;
				const gchar* _tmp290_;
				const gchar* _tmp291_;
				GQuark _tmp293_ = 0U;
				static GQuark _tmp292_label0 = 0;
				static GQuark _tmp292_label1 = 0;
				static GQuark _tmp292_label2 = 0;
				static GQuark _tmp292_label3 = 0;
				static GQuark _tmp292_label4 = 0;
				static GQuark _tmp292_label5 = 0;
				static GQuark _tmp292_label6 = 0;
				static GQuark _tmp292_label7 = 0;
				static GQuark _tmp292_label8 = 0;
				static GQuark _tmp292_label9 = 0;
				static GQuark _tmp292_label10 = 0;
				static GQuark _tmp292_label11 = 0;
				static GQuark _tmp292_label12 = 0;
				static GQuark _tmp292_label13 = 0;
				static GQuark _tmp292_label14 = 0;
				static GQuark _tmp292_label15 = 0;
				static GQuark _tmp292_label16 = 0;
				static GQuark _tmp292_label17 = 0;
				static GQuark _tmp292_label18 = 0;
				static GQuark _tmp292_label19 = 0;
				static GQuark _tmp292_label20 = 0;
				static GQuark _tmp292_label21 = 0;
				static GQuark _tmp292_label22 = 0;
				static GQuark _tmp292_label23 = 0;
				_tmp287_ = _media_source_it;
				if (!gee_iterator_next (_tmp287_)) {
					break;
				}
				_tmp288_ = _media_source_it;
				_tmp289_ = gee_iterator_get (_tmp288_);
				media_source = (gchar*) _tmp289_;
				_tmp290_ = media_source;
				_tmp291_ = _tmp290_;
				_tmp293_ = (NULL == _tmp291_) ? 0 : g_quark_from_string (_tmp291_);
				if (_tmp293_ == ((0 != _tmp292_label0) ? _tmp292_label0 : (_tmp292_label0 = g_quark_from_static_string ("alloc-paper")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp294_;
							const gchar* _tmp295_;
							_tmp294_ = _data15_->combobox;
							_tmp295_ = media_source;
							gtk_combo_box_text_append (_tmp294_, _tmp295_, _ ("Paper Allocation"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label1) ? _tmp292_label1 : (_tmp292_label1 = g_quark_from_static_string ("alternate")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp296_;
							const gchar* _tmp297_;
							_tmp296_ = _data15_->combobox;
							_tmp297_ = media_source;
							gtk_combo_box_text_append (_tmp296_, _tmp297_, _ ("Alternate Tray"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label2) ? _tmp292_label2 : (_tmp292_label2 = g_quark_from_static_string ("alternate-roll")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp298_;
							const gchar* _tmp299_;
							_tmp298_ = _data15_->combobox;
							_tmp299_ = media_source;
							gtk_combo_box_text_append (_tmp298_, _tmp299_, _ ("Alternate Roll"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label3) ? _tmp292_label3 : (_tmp292_label3 = g_quark_from_static_string ("auto")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp300_;
							const gchar* _tmp301_;
							_tmp300_ = _data15_->combobox;
							_tmp301_ = media_source;
							gtk_combo_box_text_append (_tmp300_, _tmp301_, _ ("Automatic"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label4) ? _tmp292_label4 : (_tmp292_label4 = g_quark_from_static_string ("bottom")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp302_;
							const gchar* _tmp303_;
							_tmp302_ = _data15_->combobox;
							_tmp303_ = media_source;
							gtk_combo_box_text_append (_tmp302_, _tmp303_, _ ("Bottom"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label5) ? _tmp292_label5 : (_tmp292_label5 = g_quark_from_static_string ("by-pass-tray")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp304_;
							const gchar* _tmp305_;
							_tmp304_ = _data15_->combobox;
							_tmp305_ = media_source;
							gtk_combo_box_text_append (_tmp304_, _tmp305_, _ ("By-pass Tray"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label6) ? _tmp292_label6 : (_tmp292_label6 = g_quark_from_static_string ("center")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp306_;
							const gchar* _tmp307_;
							_tmp306_ = _data15_->combobox;
							_tmp307_ = media_source;
							gtk_combo_box_text_append (_tmp306_, _tmp307_, _ ("Center"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label7) ? _tmp292_label7 : (_tmp292_label7 = g_quark_from_static_string ("continuous")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp308_;
							const gchar* _tmp309_;
							_tmp308_ = _data15_->combobox;
							_tmp309_ = media_source;
							gtk_combo_box_text_append (_tmp308_, _tmp309_, _ ("Continuous Autofeed"));
							break;
						}
					}
				} else if ((_tmp293_ == ((0 != _tmp292_label8) ? _tmp292_label8 : (_tmp292_label8 = g_quark_from_static_string ("cd")))) || (_tmp293_ == ((0 != _tmp292_label9) ? _tmp292_label9 : (_tmp292_label9 = g_quark_from_static_string ("disk"))))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp310_;
							const gchar* _tmp311_;
							_tmp310_ = _data15_->combobox;
							_tmp311_ = media_source;
							gtk_combo_box_text_append (_tmp310_, _tmp311_, _ ("Disk"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label10) ? _tmp292_label10 : (_tmp292_label10 = g_quark_from_static_string ("envelope")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp312_;
							const gchar* _tmp313_;
							_tmp312_ = _data15_->combobox;
							_tmp313_ = media_source;
							gtk_combo_box_text_append (_tmp312_, _tmp313_, _ ("Envelope"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label11) ? _tmp292_label11 : (_tmp292_label11 = g_quark_from_static_string ("hagaki")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp314_;
							const gchar* _tmp315_;
							_tmp314_ = _data15_->combobox;
							_tmp315_ = media_source;
							gtk_combo_box_text_append (_tmp314_, _tmp315_, _ ("Hagaki"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label12) ? _tmp292_label12 : (_tmp292_label12 = g_quark_from_static_string ("large-capacity")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp316_;
							const gchar* _tmp317_;
							_tmp316_ = _data15_->combobox;
							_tmp317_ = media_source;
							gtk_combo_box_text_append (_tmp316_, _tmp317_, _ ("Large Capacity"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label13) ? _tmp292_label13 : (_tmp292_label13 = g_quark_from_static_string ("left")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp318_;
							const gchar* _tmp319_;
							_tmp318_ = _data15_->combobox;
							_tmp319_ = media_source;
							gtk_combo_box_text_append (_tmp318_, _tmp319_, _ ("Left"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label14) ? _tmp292_label14 : (_tmp292_label14 = g_quark_from_static_string ("main")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp320_;
							const gchar* _tmp321_;
							_tmp320_ = _data15_->combobox;
							_tmp321_ = media_source;
							gtk_combo_box_text_append (_tmp320_, _tmp321_, _ ("Main Tray"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label15) ? _tmp292_label15 : (_tmp292_label15 = g_quark_from_static_string ("main-roll")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp322_;
							const gchar* _tmp323_;
							_tmp322_ = _data15_->combobox;
							_tmp323_ = media_source;
							gtk_combo_box_text_append (_tmp322_, _tmp323_, _ ("Main Roll"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label16) ? _tmp292_label16 : (_tmp292_label16 = g_quark_from_static_string ("manual")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp324_;
							const gchar* _tmp325_;
							_tmp324_ = _data15_->combobox;
							_tmp325_ = media_source;
							gtk_combo_box_text_append (_tmp324_, _tmp325_, _ ("Manual"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label17) ? _tmp292_label17 : (_tmp292_label17 = g_quark_from_static_string ("middle")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp326_;
							const gchar* _tmp327_;
							_tmp326_ = _data15_->combobox;
							_tmp327_ = media_source;
							gtk_combo_box_text_append (_tmp326_, _tmp327_, _ ("Middle"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label18) ? _tmp292_label18 : (_tmp292_label18 = g_quark_from_static_string ("photo")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp328_;
							const gchar* _tmp329_;
							_tmp328_ = _data15_->combobox;
							_tmp329_ = media_source;
							gtk_combo_box_text_append (_tmp328_, _tmp329_, _ ("Photo"));
							break;
						}
					}
				} else if ((_tmp293_ == ((0 != _tmp292_label19) ? _tmp292_label19 : (_tmp292_label19 = g_quark_from_static_string ("asf")))) || (_tmp293_ == ((0 != _tmp292_label20) ? _tmp292_label20 : (_tmp292_label20 = g_quark_from_static_string ("rear"))))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp330_;
							const gchar* _tmp331_;
							_tmp330_ = _data15_->combobox;
							_tmp331_ = media_source;
							gtk_combo_box_text_append (_tmp330_, _tmp331_, _ ("Rear"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label21) ? _tmp292_label21 : (_tmp292_label21 = g_quark_from_static_string ("right")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp332_;
							const gchar* _tmp333_;
							_tmp332_ = _data15_->combobox;
							_tmp333_ = media_source;
							gtk_combo_box_text_append (_tmp332_, _tmp333_, _ ("Right"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label22) ? _tmp292_label22 : (_tmp292_label22 = g_quark_from_static_string ("side")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp334_;
							const gchar* _tmp335_;
							_tmp334_ = _data15_->combobox;
							_tmp335_ = media_source;
							gtk_combo_box_text_append (_tmp334_, _tmp335_, _ ("Side"));
							break;
						}
					}
				} else if (_tmp293_ == ((0 != _tmp292_label23) ? _tmp292_label23 : (_tmp292_label23 = g_quark_from_static_string ("top")))) {
					switch (0) {
						default:
						{
							GtkComboBoxText* _tmp336_;
							const gchar* _tmp337_;
							_tmp336_ = _data15_->combobox;
							_tmp337_ = media_source;
							gtk_combo_box_text_append (_tmp336_, _tmp337_, _ ("Top"));
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp338_;
							_tmp338_ = media_source;
							if (string_contains (_tmp338_, "roll-")) {
								gint number = 0;
								const gchar* _tmp339_;
								gchar* _tmp340_;
								gchar* _tmp341_;
								gint _tmp342_;
								GtkComboBoxText* _tmp343_;
								const gchar* _tmp344_;
								gchar* _tmp345_;
								gchar* _tmp346_;
								_tmp339_ = media_source;
								_tmp340_ = string_replace (_tmp339_, "roll-", "");
								_tmp341_ = _tmp340_;
								_tmp342_ = atoi (_tmp341_);
								_g_free0 (_tmp341_);
								number = _tmp342_;
								_tmp343_ = _data15_->combobox;
								_tmp344_ = media_source;
								_tmp345_ = g_strdup_printf (_ ("Roll %d"), number);
								_tmp346_ = _tmp345_;
								gtk_combo_box_text_append (_tmp343_, _tmp344_, _tmp346_);
								_g_free0 (_tmp346_);
							} else {
								const gchar* _tmp347_;
								_tmp347_ = media_source;
								if (string_contains (_tmp347_, "tray-")) {
									gint number = 0;
									const gchar* _tmp348_;
									gchar* _tmp349_;
									gchar* _tmp350_;
									gint _tmp351_;
									GtkComboBoxText* _tmp352_;
									const gchar* _tmp353_;
									gchar* _tmp354_;
									gchar* _tmp355_;
									_tmp348_ = media_source;
									_tmp349_ = string_replace (_tmp348_, "tray-", "");
									_tmp350_ = _tmp349_;
									_tmp351_ = atoi (_tmp350_);
									_g_free0 (_tmp350_);
									number = _tmp351_;
									_tmp352_ = _data15_->combobox;
									_tmp353_ = media_source;
									_tmp354_ = g_strdup_printf (_ ("Tray %d"), number);
									_tmp355_ = _tmp354_;
									gtk_combo_box_text_append (_tmp352_, _tmp353_, _tmp355_);
									_g_free0 (_tmp355_);
								} else {
									GtkComboBoxText* _tmp356_;
									const gchar* _tmp357_;
									const gchar* _tmp358_;
									_tmp356_ = _data15_->combobox;
									_tmp357_ = media_source;
									_tmp358_ = media_source;
									gtk_combo_box_text_append (_tmp356_, _tmp357_, _tmp358_);
								}
							}
							break;
						}
					}
				}
				_g_free0 (media_source);
			}
			_g_object_unref0 (_media_source_it);
		}
		_tmp359_ = _data15_->combobox;
		_tmp360_ = default_media_source;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp359_, _tmp360_);
		_tmp361_ = _data15_->combobox;
		g_signal_connect_data ((GtkComboBox*) _tmp361_, "changed", (GCallback) __printers_options_page____lambda20__gtk_combo_box_changed, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
		_tmp362_ = (GtkLabel*) gtk_label_new (_ ("Paper Source:"));
		gtk_label_set_xalign (_tmp362_, (gfloat) 1);
		g_object_ref_sink (_tmp362_);
		label = _tmp362_;
		_tmp363_ = label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp363_, 1, self->priv->row_index, 1, 1);
		_tmp364_ = _data15_->combobox;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp364_, 2, self->priv->row_index, 1, 1);
		_tmp365_ = self->priv->row_index;
		self->priv->row_index = _tmp365_ + 1;
		_g_object_unref0 (label);
		block15_data_unref (_data15_);
		_data15_ = NULL;
	}
	_tmp366_ = self->priv->_printer;
	printers_printer_get_all (_tmp366_);
	_g_free0 (default_media_source);
	_g_object_unref0 (media_sources);
	_g_object_unref0 (print_qualities);
	_g_free0 (default_output_bin);
	_g_object_unref0 (output_bins);
	_g_free0 (default_color_mode);
	_g_object_unref0 (print_color_modes);
	_g_free0 (default_media_sizes);
	_g_object_unref0 (media_sizes);
	_g_object_unref0 (orientations);
	_g_object_unref0 (two_side_label);
	_g_object_unref0 (switch_box);
	_g_free0 (default_side);
	_g_object_unref0 (sides);
	_g_object_unref0 (pages_label);
	_g_object_unref0 (pages_box);
	_g_object_unref0 (pages_per_sheet);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return obj;
}

static void
printers_options_page_class_init (PrintersOptionsPageClass * klass,
                                  gpointer klass_data)
{
	printers_options_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersOptionsPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_options_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_options_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = printers_options_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_options_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_OPTIONS_PAGE_PRINTER_PROPERTY, printers_options_page_properties[PRINTERS_OPTIONS_PAGE_PRINTER_PROPERTY] = g_param_spec_object ("printer", "printer", "printer", PRINTERS_TYPE_PRINTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
printers_options_page_instance_init (PrintersOptionsPage * self,
                                     gpointer klass)
{
	self->priv = printers_options_page_get_instance_private (self);
	self->priv->row_index = 2;
}

static void
printers_options_page_finalize (GObject * obj)
{
	PrintersOptionsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_OPTIONS_PAGE, PrintersOptionsPage);
	_g_object_unref0 (self->priv->_printer);
	G_OBJECT_CLASS (printers_options_page_parent_class)->finalize (obj);
}

static GType
printers_options_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersOptionsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_options_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersOptionsPage), 0, (GInstanceInitFunc) printers_options_page_instance_init, NULL };
	GType printers_options_page_type_id;
	printers_options_page_type_id = g_type_register_static (gtk_grid_get_type (), "PrintersOptionsPage", &g_define_type_info, 0);
	PrintersOptionsPage_private_offset = g_type_add_instance_private (printers_options_page_type_id, sizeof (PrintersOptionsPagePrivate));
	return printers_options_page_type_id;
}

GType
printers_options_page_get_type (void)
{
	static volatile gsize printers_options_page_type_id__once = 0;
	if (g_once_init_enter (&printers_options_page_type_id__once)) {
		GType printers_options_page_type_id;
		printers_options_page_type_id = printers_options_page_get_type_once ();
		g_once_init_leave (&printers_options_page_type_id__once, printers_options_page_type_id);
	}
	return printers_options_page_type_id__once;
}

static void
_vala_printers_options_page_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PrintersOptionsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_OPTIONS_PAGE, PrintersOptionsPage);
	switch (property_id) {
		case PRINTERS_OPTIONS_PAGE_PRINTER_PROPERTY:
		g_value_set_object (value, printers_options_page_get_printer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_options_page_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PrintersOptionsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_OPTIONS_PAGE, PrintersOptionsPage);
	switch (property_id) {
		case PRINTERS_OPTIONS_PAGE_PRINTER_PROPERTY:
		printers_options_page_set_printer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

