/* App.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from App.vala, do not modify */

/*
 * Copyright (c) 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "notifications.h"
#include <gio/gdesktopappinfo.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BACKEND_APP_0_PROPERTY,
	BACKEND_APP_APP_INFO_PROPERTY,
	BACKEND_APP_APP_ID_PROPERTY,
	BACKEND_APP_SETTINGS_PROPERTY,
	BACKEND_APP_NUM_PROPERTIES
};
static GParamSpec* backend_app_properties[BACKEND_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _BackendAppPrivate {
	GDesktopAppInfo* _app_info;
	gchar* _app_id;
	GSettings* _settings;
};

static gint BackendApp_private_offset;
static gpointer backend_app_parent_class = NULL;

static void backend_app_set_app_id (BackendApp* self,
                             const gchar* value);
static void backend_app_set_settings (BackendApp* self,
                               GSettings* value);
static GObject * backend_app_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void backend_app_finalize (GObject * obj);
static GType backend_app_get_type_once (void);
static void _vala_backend_app_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_backend_app_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
backend_app_get_instance_private (BackendApp* self)
{
	return G_STRUCT_MEMBER_P (self, BackendApp_private_offset);
}

BackendApp*
backend_app_construct (GType object_type,
                       GDesktopAppInfo* app_info)
{
	BackendApp * self = NULL;
	g_return_val_if_fail (app_info != NULL, NULL);
	self = (BackendApp*) g_object_new (object_type, "app-info", app_info, NULL);
	return self;
}

BackendApp*
backend_app_new (GDesktopAppInfo* app_info)
{
	return backend_app_construct (BACKEND_TYPE_APP, app_info);
}

GDesktopAppInfo*
backend_app_get_app_info (BackendApp* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
backend_app_set_app_info (BackendApp* self,
                          GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = backend_app_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, backend_app_properties[BACKEND_APP_APP_INFO_PROPERTY]);
	}
}

const gchar*
backend_app_get_app_id (BackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_id;
	result = _tmp0_;
	return result;
}

static void
backend_app_set_app_id (BackendApp* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = backend_app_get_app_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, backend_app_properties[BACKEND_APP_APP_ID_PROPERTY]);
	}
}

GSettings*
backend_app_get_settings (BackendApp* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
backend_app_set_settings (BackendApp* self,
                          GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = backend_app_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, backend_app_properties[BACKEND_APP_SETTINGS_PROPERTY]);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GObject *
backend_app_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BackendApp * self;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* child_schema_id = NULL;
	gchar* _tmp4_;
	gchar* child_path = NULL;
	gchar* _tmp5_;
	GSettingsSchemaSource* _tmp6_;
	const gchar* _tmp7_;
	GSettingsSchema* _tmp8_;
	GSettingsSchema* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	parent_class = G_OBJECT_CLASS (backend_app_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BACKEND_TYPE_APP, BackendApp);
	_tmp0_ = self->priv->_app_info;
	_tmp1_ = g_app_info_get_id ((GAppInfo*) _tmp0_);
	_tmp2_ = string_replace (_tmp1_, ".desktop", "");
	_tmp3_ = _tmp2_;
	backend_app_set_app_id (self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_strdup ("io.elementary.notifications.applications");
	child_schema_id = _tmp4_;
	_tmp5_ = g_strdup ("/io/elementary/notifications/applications/%s/");
	child_path = _tmp5_;
	_tmp6_ = g_settings_schema_source_get_default ();
	_tmp7_ = child_schema_id;
	_tmp8_ = g_settings_schema_source_lookup (_tmp6_, _tmp7_, TRUE);
	_tmp9_ = _tmp8_;
	_tmp10_ = child_path;
	_tmp11_ = self->priv->_app_id;
	_tmp12_ = g_strdup_printf (_tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_settings_new_full (_tmp9_, NULL, _tmp13_);
	_tmp15_ = _tmp14_;
	backend_app_set_settings (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_settings_schema_unref0 (_tmp9_);
	_g_free0 (child_path);
	_g_free0 (child_schema_id);
	return obj;
}

static void
backend_app_class_init (BackendAppClass * klass,
                        gpointer klass_data)
{
	backend_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BackendApp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_backend_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_backend_app_set_property;
	G_OBJECT_CLASS (klass)->constructor = backend_app_constructor;
	G_OBJECT_CLASS (klass)->finalize = backend_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKEND_APP_APP_INFO_PROPERTY, backend_app_properties[BACKEND_APP_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKEND_APP_APP_ID_PROPERTY, backend_app_properties[BACKEND_APP_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKEND_APP_SETTINGS_PROPERTY, backend_app_properties[BACKEND_APP_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
backend_app_instance_init (BackendApp * self,
                           gpointer klass)
{
	self->priv = backend_app_get_instance_private (self);
}

static void
backend_app_finalize (GObject * obj)
{
	BackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BACKEND_TYPE_APP, BackendApp);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_app_id);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (backend_app_parent_class)->finalize (obj);
}

static GType
backend_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackendAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backend_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackendApp), 0, (GInstanceInitFunc) backend_app_instance_init, NULL };
	GType backend_app_type_id;
	backend_app_type_id = g_type_register_static (G_TYPE_OBJECT, "BackendApp", &g_define_type_info, 0);
	BackendApp_private_offset = g_type_add_instance_private (backend_app_type_id, sizeof (BackendAppPrivate));
	return backend_app_type_id;
}

GType
backend_app_get_type (void)
{
	static volatile gsize backend_app_type_id__once = 0;
	if (g_once_init_enter (&backend_app_type_id__once)) {
		GType backend_app_type_id;
		backend_app_type_id = backend_app_get_type_once ();
		g_once_init_leave (&backend_app_type_id__once, backend_app_type_id);
	}
	return backend_app_type_id__once;
}

static void
_vala_backend_app_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	BackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BACKEND_TYPE_APP, BackendApp);
	switch (property_id) {
		case BACKEND_APP_APP_INFO_PROPERTY:
		g_value_set_object (value, backend_app_get_app_info (self));
		break;
		case BACKEND_APP_APP_ID_PROPERTY:
		g_value_set_string (value, backend_app_get_app_id (self));
		break;
		case BACKEND_APP_SETTINGS_PROPERTY:
		g_value_set_object (value, backend_app_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_backend_app_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	BackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BACKEND_TYPE_APP, BackendApp);
	switch (property_id) {
		case BACKEND_APP_APP_INFO_PROPERTY:
		backend_app_set_app_info (self, g_value_get_object (value));
		break;
		case BACKEND_APP_APP_ID_PROPERTY:
		backend_app_set_app_id (self, g_value_get_string (value));
		break;
		case BACKEND_APP_SETTINGS_PROPERTY:
		backend_app_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

