// ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_BLINK_H_
#define UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-blink.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ax::mojom::blink {






class  AXScrollChange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXScrollChange, T>::value>;
  using DataView = AXScrollChangeDataView;
  using Data_ = internal::AXScrollChange_Data;

  template <typename... Args>
  static AXScrollChangePtr New(Args&&... args) {
    return AXScrollChangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXScrollChangePtr From(const U& u) {
    return mojo::TypeConverter<AXScrollChangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXScrollChange>::Convert(*this);
  }


  AXScrollChange();

  AXScrollChange(
      int32_t id,
      int32_t scroll_x,
      int32_t scroll_y);


  ~AXScrollChange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXScrollChangePtr>
  AXScrollChangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXScrollChange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXScrollChange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXScrollChange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXScrollChange::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXScrollChange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXScrollChange_UnserializedMessageContext<
            UserType, AXScrollChange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXScrollChange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXScrollChange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXScrollChange_UnserializedMessageContext<
            UserType, AXScrollChange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXScrollChange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t scroll_x;
  
  int32_t scroll_y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXScrollChange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXScrollChange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXScrollChange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXScrollChange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  AXLocationChange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXLocationChange, T>::value>;
  using DataView = AXLocationChangeDataView;
  using Data_ = internal::AXLocationChange_Data;

  template <typename... Args>
  static AXLocationChangePtr New(Args&&... args) {
    return AXLocationChangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXLocationChangePtr From(const U& u) {
    return mojo::TypeConverter<AXLocationChangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXLocationChange>::Convert(*this);
  }


  AXLocationChange();

  AXLocationChange(
      int32_t id,
      const ::ui::AXRelativeBounds& new_location);


  ~AXLocationChange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXLocationChangePtr>
  AXLocationChangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXLocationChange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXLocationChange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXLocationChange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXLocationChange::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXLocationChange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXLocationChange_UnserializedMessageContext<
            UserType, AXLocationChange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXLocationChange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXLocationChange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXLocationChange_UnserializedMessageContext<
            UserType, AXLocationChange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXLocationChange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  ::ui::AXRelativeBounds new_location;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXLocationChange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXLocationChange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXLocationChange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXLocationChange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  AXLocationAndScrollUpdates {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXLocationAndScrollUpdates, T>::value>;
  using DataView = AXLocationAndScrollUpdatesDataView;
  using Data_ = internal::AXLocationAndScrollUpdates_Data;

  template <typename... Args>
  static AXLocationAndScrollUpdatesPtr New(Args&&... args) {
    return AXLocationAndScrollUpdatesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXLocationAndScrollUpdatesPtr From(const U& u) {
    return mojo::TypeConverter<AXLocationAndScrollUpdatesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXLocationAndScrollUpdates>::Convert(*this);
  }


  AXLocationAndScrollUpdates();

  AXLocationAndScrollUpdates(
      WTF::Vector<AXLocationChangePtr> location_changes,
      WTF::Vector<AXScrollChangePtr> scroll_changes);

AXLocationAndScrollUpdates(const AXLocationAndScrollUpdates&) = delete;
AXLocationAndScrollUpdates& operator=(const AXLocationAndScrollUpdates&) = delete;

  ~AXLocationAndScrollUpdates();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXLocationAndScrollUpdatesPtr>
  AXLocationAndScrollUpdatesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXLocationAndScrollUpdates::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXLocationAndScrollUpdates::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXLocationAndScrollUpdates_UnserializedMessageContext<
            UserType, AXLocationAndScrollUpdates::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXLocationAndScrollUpdates::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXLocationAndScrollUpdates::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXLocationAndScrollUpdates_UnserializedMessageContext<
            UserType, AXLocationAndScrollUpdates::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXLocationAndScrollUpdates::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<AXLocationChangePtr> location_changes;
  
  WTF::Vector<AXScrollChangePtr> scroll_changes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXLocationChangePtr AXLocationChange::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(new_location)
  );
}

template <typename T, AXLocationChange::EnableIfSame<T>*>
bool AXLocationChange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->new_location, other_struct.new_location))
    return false;
  return true;
}

template <typename T, AXLocationChange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.new_location < rhs.new_location)
    return true;
  if (rhs.new_location < lhs.new_location)
    return false;
  return false;
}
template <typename StructPtrType>
AXScrollChangePtr AXScrollChange::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(scroll_x),
      mojo::Clone(scroll_y)
  );
}

template <typename T, AXScrollChange::EnableIfSame<T>*>
bool AXScrollChange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->scroll_x, other_struct.scroll_x))
    return false;
  if (!mojo::Equals(this->scroll_y, other_struct.scroll_y))
    return false;
  return true;
}

template <typename T, AXScrollChange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.scroll_x < rhs.scroll_x)
    return true;
  if (rhs.scroll_x < lhs.scroll_x)
    return false;
  if (lhs.scroll_y < rhs.scroll_y)
    return true;
  if (rhs.scroll_y < lhs.scroll_y)
    return false;
  return false;
}
template <typename StructPtrType>
AXLocationAndScrollUpdatesPtr AXLocationAndScrollUpdates::Clone() const {
  return New(
      mojo::Clone(location_changes),
      mojo::Clone(scroll_changes)
  );
}

template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>*>
bool AXLocationAndScrollUpdates::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location_changes, other_struct.location_changes))
    return false;
  if (!mojo::Equals(this->scroll_changes, other_struct.scroll_changes))
    return false;
  return true;
}

template <typename T, AXLocationAndScrollUpdates::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.location_changes < rhs.location_changes)
    return true;
  if (rhs.location_changes < lhs.location_changes)
    return false;
  if (lhs.scroll_changes < rhs.scroll_changes)
    return true;
  if (rhs.scroll_changes < lhs.scroll_changes)
    return false;
  return false;
}


}  // ax::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::blink::AXLocationChange::DataView,
                                         ::ax::mojom::blink::AXLocationChangePtr> {
  static bool IsNull(const ::ax::mojom::blink::AXLocationChangePtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXLocationChangePtr* output) { output->reset(); }

  static decltype(::ax::mojom::blink::AXLocationChange::id) id(
      const ::ax::mojom::blink::AXLocationChangePtr& input) {
    return input->id;
  }

  static const decltype(::ax::mojom::blink::AXLocationChange::new_location)& new_location(
      const ::ax::mojom::blink::AXLocationChangePtr& input) {
    return input->new_location;
  }

  static bool Read(::ax::mojom::blink::AXLocationChange::DataView input, ::ax::mojom::blink::AXLocationChangePtr* output);
};


template <>
struct  StructTraits<::ax::mojom::blink::AXScrollChange::DataView,
                                         ::ax::mojom::blink::AXScrollChangePtr> {
  static bool IsNull(const ::ax::mojom::blink::AXScrollChangePtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXScrollChangePtr* output) { output->reset(); }

  static decltype(::ax::mojom::blink::AXScrollChange::id) id(
      const ::ax::mojom::blink::AXScrollChangePtr& input) {
    return input->id;
  }

  static decltype(::ax::mojom::blink::AXScrollChange::scroll_x) scroll_x(
      const ::ax::mojom::blink::AXScrollChangePtr& input) {
    return input->scroll_x;
  }

  static decltype(::ax::mojom::blink::AXScrollChange::scroll_y) scroll_y(
      const ::ax::mojom::blink::AXScrollChangePtr& input) {
    return input->scroll_y;
  }

  static bool Read(::ax::mojom::blink::AXScrollChange::DataView input, ::ax::mojom::blink::AXScrollChangePtr* output);
};


template <>
struct  StructTraits<::ax::mojom::blink::AXLocationAndScrollUpdates::DataView,
                                         ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr> {
  static bool IsNull(const ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXLocationAndScrollUpdatesPtr* output) { output->reset(); }

  static const decltype(::ax::mojom::blink::AXLocationAndScrollUpdates::location_changes)& location_changes(
      const ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr& input) {
    return input->location_changes;
  }

  static const decltype(::ax::mojom::blink::AXLocationAndScrollUpdates::scroll_changes)& scroll_changes(
      const ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr& input) {
    return input->scroll_changes;
  }

  static bool Read(::ax::mojom::blink::AXLocationAndScrollUpdates::DataView input, ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_BLINK_H_