// services/viz/public/mojom/compositing/layer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/layer.mojom-shared-internal.h"
#include "cc/mojom/element_id.mojom-shared.h"
#include "cc/mojom/layer_type.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"







namespace viz::mojom {
class LayerDataView;

class AnchorPositionScrollDataDataView;

class StickyPositionNodeDataDataView;

class TransformTreeUpdateDataView;

class TransformNodeDataView;

class ClipNodeDataView;

class EffectNodeDataView;

class ScrollNodeDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::LayerDataView> {
  using Data = ::viz::mojom::internal::Layer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnchorPositionScrollDataDataView> {
  using Data = ::viz::mojom::internal::AnchorPositionScrollData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::StickyPositionNodeDataDataView> {
  using Data = ::viz::mojom::internal::StickyPositionNodeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TransformTreeUpdateDataView> {
  using Data = ::viz::mojom::internal::TransformTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TransformNodeDataView> {
  using Data = ::viz::mojom::internal::TransformNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::ClipNodeDataView> {
  using Data = ::viz::mojom::internal::ClipNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::EffectNodeDataView> {
  using Data = ::viz::mojom::internal::EffectNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::ScrollNodeDataView> {
  using Data = ::viz::mojom::internal::ScrollNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class LayerDataView {
 public:
  LayerDataView() = default;

  LayerDataView(
      internal::Layer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::cc::mojom::LayerType>(
        data_value, output);
  }
  ::cc::mojom::LayerType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::LayerType>(data_->type));
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool contents_opaque() const {
    return data_->contents_opaque;
  }
  bool contents_opaque_for_text() const {
    return data_->contents_opaque_for_text;
  }
  bool is_drawable() const {
    return data_->is_drawable;
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetSafeOpaqueBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSafeOpaqueBackgroundColor(UserType* output) {
    
    auto* pointer = data_->safe_opaque_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::ElementIdDataView, UserType>(),
    "Attempting to read the optional `element_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadElementId` instead "
    "of `ReadElementId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateRect(UserType* output) {
    
    auto* pointer = data_->update_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetOffsetToTransformParentDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsetToTransformParent(UserType* output) {
    
    auto* pointer = data_->offset_to_transform_parent.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  int32_t transform_tree_index() const {
    return data_->transform_tree_index;
  }
  int32_t clip_tree_index() const {
    return data_->clip_tree_index;
  }
  int32_t effect_tree_index() const {
    return data_->effect_tree_index;
  }
  int32_t scroll_tree_index() const {
    return data_->scroll_tree_index;
  }
 private:
  internal::Layer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorPositionScrollDataDataView {
 public:
  AnchorPositionScrollDataDataView() = default;

  AnchorPositionScrollDataDataView(
      internal::AnchorPositionScrollData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAdjustmentContainerIdsDataView(
      mojo::ArrayDataView<::cc::mojom::ElementIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdjustmentContainerIds(UserType* output) {
    
    auto* pointer = data_->adjustment_container_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cc::mojom::ElementIdDataView>>(
        pointer, output, message_);
  }
  inline void GetAccumulatedScrollOriginDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccumulatedScrollOrigin(UserType* output) {
    
    auto* pointer = data_->accumulated_scroll_origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  bool needs_scroll_adjustment_in_x() const {
    return data_->needs_scroll_adjustment_in_x;
  }
  bool needs_scroll_adjustment_in_y() const {
    return data_->needs_scroll_adjustment_in_y;
  }
 private:
  internal::AnchorPositionScrollData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StickyPositionNodeDataDataView {
 public:
  StickyPositionNodeDataDataView() = default;

  StickyPositionNodeDataDataView(
      internal::StickyPositionNodeData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t scroll_ancestor() const {
    return data_->scroll_ancestor;
  }
  bool is_anchored_left() const {
    return data_->is_anchored_left;
  }
  bool is_anchored_right() const {
    return data_->is_anchored_right;
  }
  bool is_anchored_top() const {
    return data_->is_anchored_top;
  }
  bool is_anchored_bottom() const {
    return data_->is_anchored_bottom;
  }
  float left_offset() const {
    return data_->left_offset;
  }
  float right_offset() const {
    return data_->right_offset;
  }
  float top_offset() const {
    return data_->top_offset;
  }
  float bottom_offset() const {
    return data_->bottom_offset;
  }
  inline void GetConstraintBoxRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConstraintBoxRect(UserType* output) {
    
    auto* pointer = data_->constraint_box_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetScrollContainerRelativeStickyBoxRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollContainerRelativeStickyBoxRect(UserType* output) {
    
    auto* pointer = data_->scroll_container_relative_sticky_box_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetScrollContainerRelativeContainingBlockRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollContainerRelativeContainingBlockRect(UserType* output) {
    
    auto* pointer = data_->scroll_container_relative_containing_block_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  int32_t nearest_node_shifting_sticky_box() const {
    return data_->nearest_node_shifting_sticky_box;
  }
  int32_t nearest_node_shifting_containing_block() const {
    return data_->nearest_node_shifting_containing_block;
  }
  inline void GetTotalStickyBoxStickyOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotalStickyBoxStickyOffset(UserType* output) {
    
    auto* pointer = data_->total_sticky_box_sticky_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetTotalContainingBlockStickyOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotalContainingBlockStickyOffset(UserType* output) {
    
    auto* pointer = data_->total_containing_block_sticky_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::StickyPositionNodeData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TransformTreeUpdateDataView {
 public:
  TransformTreeUpdateDataView() = default;

  TransformTreeUpdateDataView(
      internal::TransformTreeUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  float device_transform_scale_factor() const {
    return data_->device_transform_scale_factor;
  }
  inline void GetNodesAffectedByOuterViewportBoundsDeltaDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodesAffectedByOuterViewportBoundsDelta(UserType* output) {
    
    auto* pointer = data_->nodes_affected_by_outer_viewport_bounds_delta.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetStickyPositionDataDataView(
      mojo::ArrayDataView<StickyPositionNodeDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStickyPositionData(UserType* output) {
    
    auto* pointer = data_->sticky_position_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::StickyPositionNodeDataDataView>>(
        pointer, output, message_);
  }
  inline void GetAnchorPositionScrollDataDataView(
      mojo::ArrayDataView<AnchorPositionScrollDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorPositionScrollData(UserType* output) {
    
    auto* pointer = data_->anchor_position_scroll_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnchorPositionScrollDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TransformTreeUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TransformNodeDataView {
 public:
  TransformNodeDataView() = default;

  TransformNodeDataView(
      internal::TransformNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t parent_frame_id() const {
    return data_->parent_frame_id;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::ElementIdDataView, UserType>(),
    "Attempting to read the optional `element_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadElementId` instead "
    "of `ReadElementId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetLocalDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocal(UserType* output) {
    
    auto* pointer = data_->local.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
  inline void GetScrollOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollOffset(UserType* output) {
    
    auto* pointer = data_->scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetSnapAmountDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSnapAmount(UserType* output) {
    
    auto* pointer = data_->snap_amount.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  std::optional<uint32_t> sticky_position_constraint_id() const {

    return data_->sticky_position_constraint_id_$flag
        ? std::make_optional(data_->sticky_position_constraint_id_$value)
        : std::nullopt;
  }
  std::optional<uint32_t> anchor_position_scroll_data_id() const {

    return data_->anchor_position_scroll_data_id_$flag
        ? std::make_optional(data_->anchor_position_scroll_data_id_$value)
        : std::nullopt;
  }
  int32_t sorting_context_id() const {
    return data_->sorting_context_id;
  }
  bool has_potential_animation() const {
    return data_->has_potential_animation;
  }
  bool is_currently_animating() const {
    return data_->is_currently_animating;
  }
  bool flattens_inherited_transform() const {
    return data_->flattens_inherited_transform;
  }
  bool scrolls() const {
    return data_->scrolls;
  }
  bool should_undo_overscroll() const {
    return data_->should_undo_overscroll;
  }
  bool should_be_snapped() const {
    return data_->should_be_snapped;
  }
  bool moved_by_outer_viewport_bounds_delta_y() const {
    return data_->moved_by_outer_viewport_bounds_delta_y;
  }
  bool in_subtree_of_page_scale_layer() const {
    return data_->in_subtree_of_page_scale_layer;
  }
  bool transform_changed() const {
    return data_->transform_changed;
  }
  bool delegates_to_parent_for_backface() const {
    return data_->delegates_to_parent_for_backface;
  }
  bool will_change_transform() const {
    return data_->will_change_transform;
  }
  inline void GetVisibleFrameElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleFrameElementId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::ElementIdDataView, UserType>(),
    "Attempting to read the optional `visible_frame_element_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVisibleFrameElementId` instead "
    "of `ReadVisibleFrameElementId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->visible_frame_element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::TransformNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClipNodeDataView {
 public:
  ClipNodeDataView() = default;

  ClipNodeDataView(
      internal::ClipNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t transform_id() const {
    return data_->transform_id;
  }
  inline void GetClipDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClip(UserType* output) {
    
    auto* pointer = data_->clip.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  int32_t pixel_moving_filter_id() const {
    return data_->pixel_moving_filter_id;
  }
 private:
  internal::ClipNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EffectNodeDataView {
 public:
  EffectNodeDataView() = default;

  EffectNodeDataView(
      internal::EffectNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t transform_id() const {
    return data_->transform_id;
  }
  int32_t clip_id() const {
    return data_->clip_id;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::ElementIdDataView, UserType>(),
    "Attempting to read the optional `element_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadElementId` instead "
    "of `ReadElementId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  float opacity() const {
    return data_->opacity;
  }
  bool has_render_surface() const {
    return data_->has_render_surface;
  }
  inline void GetSurfaceContentsScaleDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceContentsScale(UserType* output) {
    
    auto* pointer = data_->surface_contents_scale.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  uint32_t blend_mode() const {
    return data_->blend_mode;
  }
  int32_t target_id() const {
    return data_->target_id;
  }
 private:
  internal::EffectNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollNodeDataView {
 public:
  ScrollNodeDataView() = default;

  ScrollNodeDataView(
      internal::ScrollNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t parent_id() const {
    return data_->parent_id;
  }
  int32_t transform_id() const {
    return data_->transform_id;
  }
  inline void GetContainerBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerBounds(UserType* output) {
    
    auto* pointer = data_->container_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::ElementIdDataView, UserType>(),
    "Attempting to read the optional `element_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadElementId` instead "
    "of `ReadElementId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  bool max_scroll_offset_affected_by_page_scale() const {
    return data_->max_scroll_offset_affected_by_page_scale;
  }
  bool scrolls_inner_viewport() const {
    return data_->scrolls_inner_viewport;
  }
  bool scrolls_outer_viewport() const {
    return data_->scrolls_outer_viewport;
  }
  bool prevent_viewport_scrolling_from_inner() const {
    return data_->prevent_viewport_scrolling_from_inner;
  }
  bool user_scrollable_horizontal() const {
    return data_->user_scrollable_horizontal;
  }
  bool user_scrollable_vertical() const {
    return data_->user_scrollable_vertical;
  }
  bool is_composited() const {
    return data_->is_composited;
  }
 private:
  internal::ScrollNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::LayerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::LayerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Layer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    mojo::internal::Serialize<::cc::mojom::LayerType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_bounds, bounds_fragment);
    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in Layer struct");
    fragment->contents_opaque = Traits::contents_opaque(input);
    fragment->contents_opaque_for_text = Traits::contents_opaque_for_text(input);
    fragment->is_drawable = Traits::is_drawable(input);
    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
        in_background_color, background_color_fragment);
    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->background_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null background_color in Layer struct");
    decltype(Traits::safe_opaque_background_color(input)) in_safe_opaque_background_color = Traits::safe_opaque_background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->safe_opaque_background_color)::BaseType> safe_opaque_background_color_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
        in_safe_opaque_background_color, safe_opaque_background_color_fragment);
    fragment->safe_opaque_background_color.Set(
        safe_opaque_background_color_fragment.is_null() ? nullptr : safe_opaque_background_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->safe_opaque_background_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null safe_opaque_background_color in Layer struct");
    decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_id)::BaseType> element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::ElementIdDataView>(
        in_element_id, element_id_fragment);
    fragment->element_id.Set(
        element_id_fragment.is_null() ? nullptr : element_id_fragment.data());
    decltype(Traits::update_rect(input)) in_update_rect = Traits::update_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->update_rect)::BaseType> update_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_update_rect, update_rect_fragment);
    fragment->update_rect.Set(
        update_rect_fragment.is_null() ? nullptr : update_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->update_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null update_rect in Layer struct");
    decltype(Traits::offset_to_transform_parent(input)) in_offset_to_transform_parent = Traits::offset_to_transform_parent(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset_to_transform_parent)::BaseType> offset_to_transform_parent_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_offset_to_transform_parent, offset_to_transform_parent_fragment);
    fragment->offset_to_transform_parent.Set(
        offset_to_transform_parent_fragment.is_null() ? nullptr : offset_to_transform_parent_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->offset_to_transform_parent.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offset_to_transform_parent in Layer struct");
    fragment->transform_tree_index = Traits::transform_tree_index(input);
    fragment->clip_tree_index = Traits::clip_tree_index(input);
    fragment->effect_tree_index = Traits::effect_tree_index(input);
    fragment->scroll_tree_index = Traits::scroll_tree_index(input);
  }

  static bool Deserialize(::viz::mojom::internal::Layer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::LayerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnchorPositionScrollDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnchorPositionScrollDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnchorPositionScrollData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::adjustment_container_ids(input)) in_adjustment_container_ids = Traits::adjustment_container_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->adjustment_container_ids)::BaseType>
        adjustment_container_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& adjustment_container_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::cc::mojom::ElementIdDataView>>(
        in_adjustment_container_ids, adjustment_container_ids_fragment, &adjustment_container_ids_validate_params);
    fragment->adjustment_container_ids.Set(
        adjustment_container_ids_fragment.is_null() ? nullptr : adjustment_container_ids_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->adjustment_container_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null adjustment_container_ids in AnchorPositionScrollData struct");
    decltype(Traits::accumulated_scroll_origin(input)) in_accumulated_scroll_origin = Traits::accumulated_scroll_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accumulated_scroll_origin)::BaseType> accumulated_scroll_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
        in_accumulated_scroll_origin, accumulated_scroll_origin_fragment);
    fragment->accumulated_scroll_origin.Set(
        accumulated_scroll_origin_fragment.is_null() ? nullptr : accumulated_scroll_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->accumulated_scroll_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accumulated_scroll_origin in AnchorPositionScrollData struct");
    fragment->needs_scroll_adjustment_in_x = Traits::needs_scroll_adjustment_in_x(input);
    fragment->needs_scroll_adjustment_in_y = Traits::needs_scroll_adjustment_in_y(input);
  }

  static bool Deserialize(::viz::mojom::internal::AnchorPositionScrollData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AnchorPositionScrollDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::StickyPositionNodeDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::StickyPositionNodeDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::StickyPositionNodeData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->scroll_ancestor = Traits::scroll_ancestor(input);
    fragment->is_anchored_left = Traits::is_anchored_left(input);
    fragment->is_anchored_right = Traits::is_anchored_right(input);
    fragment->is_anchored_top = Traits::is_anchored_top(input);
    fragment->is_anchored_bottom = Traits::is_anchored_bottom(input);
    fragment->left_offset = Traits::left_offset(input);
    fragment->right_offset = Traits::right_offset(input);
    fragment->top_offset = Traits::top_offset(input);
    fragment->bottom_offset = Traits::bottom_offset(input);
    decltype(Traits::constraint_box_rect(input)) in_constraint_box_rect = Traits::constraint_box_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->constraint_box_rect)::BaseType> constraint_box_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_constraint_box_rect, constraint_box_rect_fragment);
    fragment->constraint_box_rect.Set(
        constraint_box_rect_fragment.is_null() ? nullptr : constraint_box_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->constraint_box_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null constraint_box_rect in StickyPositionNodeData struct");
    decltype(Traits::scroll_container_relative_sticky_box_rect(input)) in_scroll_container_relative_sticky_box_rect = Traits::scroll_container_relative_sticky_box_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_container_relative_sticky_box_rect)::BaseType> scroll_container_relative_sticky_box_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_scroll_container_relative_sticky_box_rect, scroll_container_relative_sticky_box_rect_fragment);
    fragment->scroll_container_relative_sticky_box_rect.Set(
        scroll_container_relative_sticky_box_rect_fragment.is_null() ? nullptr : scroll_container_relative_sticky_box_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scroll_container_relative_sticky_box_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_container_relative_sticky_box_rect in StickyPositionNodeData struct");
    decltype(Traits::scroll_container_relative_containing_block_rect(input)) in_scroll_container_relative_containing_block_rect = Traits::scroll_container_relative_containing_block_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_container_relative_containing_block_rect)::BaseType> scroll_container_relative_containing_block_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_scroll_container_relative_containing_block_rect, scroll_container_relative_containing_block_rect_fragment);
    fragment->scroll_container_relative_containing_block_rect.Set(
        scroll_container_relative_containing_block_rect_fragment.is_null() ? nullptr : scroll_container_relative_containing_block_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scroll_container_relative_containing_block_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_container_relative_containing_block_rect in StickyPositionNodeData struct");
    fragment->nearest_node_shifting_sticky_box = Traits::nearest_node_shifting_sticky_box(input);
    fragment->nearest_node_shifting_containing_block = Traits::nearest_node_shifting_containing_block(input);
    decltype(Traits::total_sticky_box_sticky_offset(input)) in_total_sticky_box_sticky_offset = Traits::total_sticky_box_sticky_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total_sticky_box_sticky_offset)::BaseType> total_sticky_box_sticky_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_total_sticky_box_sticky_offset, total_sticky_box_sticky_offset_fragment);
    fragment->total_sticky_box_sticky_offset.Set(
        total_sticky_box_sticky_offset_fragment.is_null() ? nullptr : total_sticky_box_sticky_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->total_sticky_box_sticky_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_sticky_box_sticky_offset in StickyPositionNodeData struct");
    decltype(Traits::total_containing_block_sticky_offset(input)) in_total_containing_block_sticky_offset = Traits::total_containing_block_sticky_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total_containing_block_sticky_offset)::BaseType> total_containing_block_sticky_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_total_containing_block_sticky_offset, total_containing_block_sticky_offset_fragment);
    fragment->total_containing_block_sticky_offset.Set(
        total_containing_block_sticky_offset_fragment.is_null() ? nullptr : total_containing_block_sticky_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->total_containing_block_sticky_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_containing_block_sticky_offset in StickyPositionNodeData struct");
  }

  static bool Deserialize(::viz::mojom::internal::StickyPositionNodeData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::StickyPositionNodeDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TransformTreeUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TransformTreeUpdateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TransformTreeUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->page_scale_factor = Traits::page_scale_factor(input);
    fragment->device_scale_factor = Traits::device_scale_factor(input);
    fragment->device_transform_scale_factor = Traits::device_transform_scale_factor(input);
    decltype(Traits::nodes_affected_by_outer_viewport_bounds_delta(input)) in_nodes_affected_by_outer_viewport_bounds_delta = Traits::nodes_affected_by_outer_viewport_bounds_delta(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nodes_affected_by_outer_viewport_bounds_delta)::BaseType>
        nodes_affected_by_outer_viewport_bounds_delta_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& nodes_affected_by_outer_viewport_bounds_delta_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_nodes_affected_by_outer_viewport_bounds_delta, nodes_affected_by_outer_viewport_bounds_delta_fragment, &nodes_affected_by_outer_viewport_bounds_delta_validate_params);
    fragment->nodes_affected_by_outer_viewport_bounds_delta.Set(
        nodes_affected_by_outer_viewport_bounds_delta_fragment.is_null() ? nullptr : nodes_affected_by_outer_viewport_bounds_delta_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->nodes_affected_by_outer_viewport_bounds_delta.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nodes_affected_by_outer_viewport_bounds_delta in TransformTreeUpdate struct");
    decltype(Traits::sticky_position_data(input)) in_sticky_position_data = Traits::sticky_position_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sticky_position_data)::BaseType>
        sticky_position_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sticky_position_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::StickyPositionNodeDataDataView>>(
        in_sticky_position_data, sticky_position_data_fragment, &sticky_position_data_validate_params);
    fragment->sticky_position_data.Set(
        sticky_position_data_fragment.is_null() ? nullptr : sticky_position_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sticky_position_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sticky_position_data in TransformTreeUpdate struct");
    decltype(Traits::anchor_position_scroll_data(input)) in_anchor_position_scroll_data = Traits::anchor_position_scroll_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->anchor_position_scroll_data)::BaseType>
        anchor_position_scroll_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& anchor_position_scroll_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnchorPositionScrollDataDataView>>(
        in_anchor_position_scroll_data, anchor_position_scroll_data_fragment, &anchor_position_scroll_data_validate_params);
    fragment->anchor_position_scroll_data.Set(
        anchor_position_scroll_data_fragment.is_null() ? nullptr : anchor_position_scroll_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->anchor_position_scroll_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null anchor_position_scroll_data in TransformTreeUpdate struct");
  }

  static bool Deserialize(::viz::mojom::internal::TransformTreeUpdate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TransformTreeUpdateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TransformNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TransformNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TransformNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->parent_id = Traits::parent_id(input);
    fragment->parent_frame_id = Traits::parent_frame_id(input);
    decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_id)::BaseType> element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::ElementIdDataView>(
        in_element_id, element_id_fragment);
    fragment->element_id.Set(
        element_id_fragment.is_null() ? nullptr : element_id_fragment.data());
    decltype(Traits::local(input)) in_local = Traits::local(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local)::BaseType> local_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_local, local_fragment);
    fragment->local.Set(
        local_fragment.is_null() ? nullptr : local_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->local.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null local in TransformNode struct");
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Point3FDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TransformNode struct");
    decltype(Traits::scroll_offset(input)) in_scroll_offset = Traits::scroll_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_offset)::BaseType> scroll_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_scroll_offset, scroll_offset_fragment);
    fragment->scroll_offset.Set(
        scroll_offset_fragment.is_null() ? nullptr : scroll_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scroll_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_offset in TransformNode struct");
    decltype(Traits::snap_amount(input)) in_snap_amount = Traits::snap_amount(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->snap_amount)::BaseType> snap_amount_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_snap_amount, snap_amount_fragment);
    fragment->snap_amount.Set(
        snap_amount_fragment.is_null() ? nullptr : snap_amount_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->snap_amount.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null snap_amount in TransformNode struct");
    fragment->sticky_position_constraint_id_$flag = Traits::sticky_position_constraint_id(input).has_value();
    if (Traits::sticky_position_constraint_id(input).has_value()) {
      fragment->sticky_position_constraint_id_$value = Traits::sticky_position_constraint_id(input).value();
    }
    fragment->anchor_position_scroll_data_id_$flag = Traits::anchor_position_scroll_data_id(input).has_value();
    if (Traits::anchor_position_scroll_data_id(input).has_value()) {
      fragment->anchor_position_scroll_data_id_$value = Traits::anchor_position_scroll_data_id(input).value();
    }
    fragment->sorting_context_id = Traits::sorting_context_id(input);
    fragment->has_potential_animation = Traits::has_potential_animation(input);
    fragment->is_currently_animating = Traits::is_currently_animating(input);
    fragment->flattens_inherited_transform = Traits::flattens_inherited_transform(input);
    fragment->scrolls = Traits::scrolls(input);
    fragment->should_undo_overscroll = Traits::should_undo_overscroll(input);
    fragment->should_be_snapped = Traits::should_be_snapped(input);
    fragment->moved_by_outer_viewport_bounds_delta_y = Traits::moved_by_outer_viewport_bounds_delta_y(input);
    fragment->in_subtree_of_page_scale_layer = Traits::in_subtree_of_page_scale_layer(input);
    fragment->transform_changed = Traits::transform_changed(input);
    fragment->delegates_to_parent_for_backface = Traits::delegates_to_parent_for_backface(input);
    fragment->will_change_transform = Traits::will_change_transform(input);
    decltype(Traits::visible_frame_element_id(input)) in_visible_frame_element_id = Traits::visible_frame_element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_frame_element_id)::BaseType> visible_frame_element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::ElementIdDataView>(
        in_visible_frame_element_id, visible_frame_element_id_fragment);
    fragment->visible_frame_element_id.Set(
        visible_frame_element_id_fragment.is_null() ? nullptr : visible_frame_element_id_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::TransformNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TransformNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ClipNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ClipNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ClipNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->parent_id = Traits::parent_id(input);
    fragment->transform_id = Traits::transform_id(input);
    decltype(Traits::clip(input)) in_clip = Traits::clip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clip)::BaseType> clip_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_clip, clip_fragment);
    fragment->clip.Set(
        clip_fragment.is_null() ? nullptr : clip_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->clip.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clip in ClipNode struct");
    fragment->pixel_moving_filter_id = Traits::pixel_moving_filter_id(input);
  }

  static bool Deserialize(::viz::mojom::internal::ClipNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::ClipNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::EffectNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::EffectNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::EffectNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->parent_id = Traits::parent_id(input);
    fragment->transform_id = Traits::transform_id(input);
    fragment->clip_id = Traits::clip_id(input);
    decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_id)::BaseType> element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::ElementIdDataView>(
        in_element_id, element_id_fragment);
    fragment->element_id.Set(
        element_id_fragment.is_null() ? nullptr : element_id_fragment.data());
    fragment->opacity = Traits::opacity(input);
    fragment->has_render_surface = Traits::has_render_surface(input);
    decltype(Traits::surface_contents_scale(input)) in_surface_contents_scale = Traits::surface_contents_scale(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->surface_contents_scale)::BaseType> surface_contents_scale_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_surface_contents_scale, surface_contents_scale_fragment);
    fragment->surface_contents_scale.Set(
        surface_contents_scale_fragment.is_null() ? nullptr : surface_contents_scale_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->surface_contents_scale.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null surface_contents_scale in EffectNode struct");
    fragment->blend_mode = Traits::blend_mode(input);
    fragment->target_id = Traits::target_id(input);
  }

  static bool Deserialize(::viz::mojom::internal::EffectNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::EffectNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ScrollNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ScrollNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ScrollNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->parent_id = Traits::parent_id(input);
    fragment->transform_id = Traits::transform_id(input);
    decltype(Traits::container_bounds(input)) in_container_bounds = Traits::container_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->container_bounds)::BaseType> container_bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_container_bounds, container_bounds_fragment);
    fragment->container_bounds.Set(
        container_bounds_fragment.is_null() ? nullptr : container_bounds_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->container_bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null container_bounds in ScrollNode struct");
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_bounds, bounds_fragment);
    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in ScrollNode struct");
    decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_id)::BaseType> element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::ElementIdDataView>(
        in_element_id, element_id_fragment);
    fragment->element_id.Set(
        element_id_fragment.is_null() ? nullptr : element_id_fragment.data());
    fragment->max_scroll_offset_affected_by_page_scale = Traits::max_scroll_offset_affected_by_page_scale(input);
    fragment->scrolls_inner_viewport = Traits::scrolls_inner_viewport(input);
    fragment->scrolls_outer_viewport = Traits::scrolls_outer_viewport(input);
    fragment->prevent_viewport_scrolling_from_inner = Traits::prevent_viewport_scrolling_from_inner(input);
    fragment->user_scrollable_horizontal = Traits::user_scrollable_horizontal(input);
    fragment->user_scrollable_vertical = Traits::user_scrollable_vertical(input);
    fragment->is_composited = Traits::is_composited(input);
  }

  static bool Deserialize(::viz::mojom::internal::ScrollNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::ScrollNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void LayerDataView::GetBoundsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void LayerDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void LayerDataView::GetSafeOpaqueBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->safe_opaque_background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void LayerDataView::GetElementIdDataView(
    ::cc::mojom::ElementIdDataView* output) {
  auto pointer = data_->element_id.Get();
  *output = ::cc::mojom::ElementIdDataView(pointer, message_);
}
inline void LayerDataView::GetUpdateRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->update_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void LayerDataView::GetOffsetToTransformParentDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->offset_to_transform_parent.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}


inline void AnchorPositionScrollDataDataView::GetAdjustmentContainerIdsDataView(
    mojo::ArrayDataView<::cc::mojom::ElementIdDataView>* output) {
  auto pointer = data_->adjustment_container_ids.Get();
  *output = mojo::ArrayDataView<::cc::mojom::ElementIdDataView>(pointer, message_);
}
inline void AnchorPositionScrollDataDataView::GetAccumulatedScrollOriginDataView(
    ::gfx::mojom::Vector2dDataView* output) {
  auto pointer = data_->accumulated_scroll_origin.Get();
  *output = ::gfx::mojom::Vector2dDataView(pointer, message_);
}


inline void StickyPositionNodeDataDataView::GetConstraintBoxRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->constraint_box_rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void StickyPositionNodeDataDataView::GetScrollContainerRelativeStickyBoxRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->scroll_container_relative_sticky_box_rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void StickyPositionNodeDataDataView::GetScrollContainerRelativeContainingBlockRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->scroll_container_relative_containing_block_rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void StickyPositionNodeDataDataView::GetTotalStickyBoxStickyOffsetDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->total_sticky_box_sticky_offset.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void StickyPositionNodeDataDataView::GetTotalContainingBlockStickyOffsetDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->total_containing_block_sticky_offset.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}


inline void TransformTreeUpdateDataView::GetNodesAffectedByOuterViewportBoundsDeltaDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->nodes_affected_by_outer_viewport_bounds_delta.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void TransformTreeUpdateDataView::GetStickyPositionDataDataView(
    mojo::ArrayDataView<StickyPositionNodeDataDataView>* output) {
  auto pointer = data_->sticky_position_data.Get();
  *output = mojo::ArrayDataView<StickyPositionNodeDataDataView>(pointer, message_);
}
inline void TransformTreeUpdateDataView::GetAnchorPositionScrollDataDataView(
    mojo::ArrayDataView<AnchorPositionScrollDataDataView>* output) {
  auto pointer = data_->anchor_position_scroll_data.Get();
  *output = mojo::ArrayDataView<AnchorPositionScrollDataDataView>(pointer, message_);
}


inline void TransformNodeDataView::GetElementIdDataView(
    ::cc::mojom::ElementIdDataView* output) {
  auto pointer = data_->element_id.Get();
  *output = ::cc::mojom::ElementIdDataView(pointer, message_);
}
inline void TransformNodeDataView::GetLocalDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->local.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void TransformNodeDataView::GetOriginDataView(
    ::gfx::mojom::Point3FDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::gfx::mojom::Point3FDataView(pointer, message_);
}
inline void TransformNodeDataView::GetScrollOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->scroll_offset.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void TransformNodeDataView::GetSnapAmountDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->snap_amount.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void TransformNodeDataView::GetVisibleFrameElementIdDataView(
    ::cc::mojom::ElementIdDataView* output) {
  auto pointer = data_->visible_frame_element_id.Get();
  *output = ::cc::mojom::ElementIdDataView(pointer, message_);
}


inline void ClipNodeDataView::GetClipDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->clip.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}


inline void EffectNodeDataView::GetElementIdDataView(
    ::cc::mojom::ElementIdDataView* output) {
  auto pointer = data_->element_id.Get();
  *output = ::cc::mojom::ElementIdDataView(pointer, message_);
}
inline void EffectNodeDataView::GetSurfaceContentsScaleDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->surface_contents_scale.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}


inline void ScrollNodeDataView::GetContainerBoundsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->container_bounds.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void ScrollNodeDataView::GetBoundsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void ScrollNodeDataView::GetElementIdDataView(
    ::cc::mojom::ElementIdDataView* output) {
  auto pointer = data_->element_id.Get();
  *output = ::cc::mojom::ElementIdDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SHARED_H_