// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool CompositorFrameMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 168, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CompositorFrameMetadata_Data* object =
      static_cast<const CompositorFrameMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_scroll_offset, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_scroll_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scrollable_viewport_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scrollable_viewport_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_viewport_size, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_viewport_size, validation_context))
    return false;


  if (!::gfx::mojom::internal::ContentColorUsage_Data
        ::Validate(object->content_color_usage, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_background_color, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->latency_info, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& latency_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->latency_info, validation_context,
                                         &latency_info_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referenced_surfaces, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& referenced_surfaces_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->referenced_surfaces, validation_context,
                                         &referenced_surfaces_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deadline, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->deadline, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activation_dependencies, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& activation_dependencies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->activation_dependencies, validation_context,
                                         &activation_dependencies_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->begin_frame_ack, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->begin_frame_ack, validation_context))
    return false;


  if (!::gfx::mojom::internal::OverlayTransform_Data
        ::Validate(object->display_transform_hint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->delegated_ink_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transition_directives, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transition_directives_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transition_directives, validation_context,
                                         &transition_directives_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capture_bounds, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capture_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->screenshot_destination, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->offset_tag_definitions, 29, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& offset_tag_definitions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->offset_tag_definitions, validation_context,
                                         &offset_tag_definitions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->offset_tag_values, 30, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& offset_tag_values_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->offset_tag_values, validation_context,
                                         &offset_tag_values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_interval_inputs, 31, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_interval_inputs, validation_context))
    return false;

  return true;
}

CompositorFrameMetadata_Data::CompositorFrameMetadata_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz