// services/tracing/public/mojom/tracing_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_TRACING_SERVICE_MOJOM_SHARED_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_TRACING_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/tracing_service.mojom-shared-internal.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/tracing/public/mojom/traced_process.mojom-shared.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace tracing::mojom {
class ClientInfoDataView;



}  // tracing::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tracing::mojom::ClientInfoDataView> {
  using Data = ::tracing::mojom::internal::ClientInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tracing::mojom {
// Interface base classes. They are used for type safety check.
class TracingServiceInterfaceBase {};

using TracingServicePtrDataView =
    mojo::InterfacePtrDataView<TracingServiceInterfaceBase>;
using TracingServiceRequestDataView =
    mojo::InterfaceRequestDataView<TracingServiceInterfaceBase>;
using TracingServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TracingServiceInterfaceBase>;
using TracingServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TracingServiceInterfaceBase>;


class ClientInfoDataView {
 public:
  ClientInfoDataView() = default;

  ClientInfoDataView(
      internal::ClientInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t pid() const {
    return data_->pid;
  }
  template <typename UserType>
  UserType TakeProcess() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::tracing::mojom::TracedProcessInterfaceBase>>(
            &data_->process, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ClientInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tracing::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ClientInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ClientInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ClientInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->pid = Traits::pid(input);
    decltype(Traits::process(input)) in_process = Traits::process(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::TracedProcessInterfaceBase>>(
        in_process, &fragment->process, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->process),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid process in ClientInfo struct");
  }

  static bool Deserialize(::tracing::mojom::internal::ClientInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::ClientInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tracing::mojom {




}  // tracing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_TRACING_SERVICE_MOJOM_SHARED_H_