// services/device/public/mojom/usb_device.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/usb_device.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/usb_device.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* UsbOpenDeviceSuccessToStringHelper(UsbOpenDeviceSuccess value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbOpenDeviceSuccess::OK:
      return "OK";
    default:
      return nullptr;
  }
}

std::string UsbOpenDeviceSuccessToString(UsbOpenDeviceSuccess value) {
  const char *str = UsbOpenDeviceSuccessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbOpenDeviceSuccess value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbOpenDeviceSuccess value) {
  return os << UsbOpenDeviceSuccessToString(value);
}

NOINLINE static const char* UsbOpenDeviceErrorToStringHelper(UsbOpenDeviceError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbOpenDeviceError::ACCESS_DENIED:
      return "ACCESS_DENIED";
    case UsbOpenDeviceError::ALREADY_OPEN:
      return "ALREADY_OPEN";
    default:
      return nullptr;
  }
}

std::string UsbOpenDeviceErrorToString(UsbOpenDeviceError value) {
  const char *str = UsbOpenDeviceErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbOpenDeviceError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbOpenDeviceError value) {
  return os << UsbOpenDeviceErrorToString(value);
}

NOINLINE static const char* UsbClaimInterfaceResultToStringHelper(UsbClaimInterfaceResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbClaimInterfaceResult::kSuccess:
      return "kSuccess";
    case UsbClaimInterfaceResult::kProtectedClass:
      return "kProtectedClass";
    case UsbClaimInterfaceResult::kFailure:
      return "kFailure";
    default:
      return nullptr;
  }
}

std::string UsbClaimInterfaceResultToString(UsbClaimInterfaceResult value) {
  const char *str = UsbClaimInterfaceResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbClaimInterfaceResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbClaimInterfaceResult value) {
  return os << UsbClaimInterfaceResultToString(value);
}

NOINLINE static const char* UsbTransferDirectionToStringHelper(UsbTransferDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbTransferDirection::INBOUND:
      return "INBOUND";
    case UsbTransferDirection::OUTBOUND:
      return "OUTBOUND";
    default:
      return nullptr;
  }
}

std::string UsbTransferDirectionToString(UsbTransferDirection value) {
  const char *str = UsbTransferDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbTransferDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbTransferDirection value) {
  return os << UsbTransferDirectionToString(value);
}

NOINLINE static const char* UsbControlTransferTypeToStringHelper(UsbControlTransferType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbControlTransferType::STANDARD:
      return "STANDARD";
    case UsbControlTransferType::CLASS:
      return "CLASS";
    case UsbControlTransferType::VENDOR:
      return "VENDOR";
    case UsbControlTransferType::RESERVED:
      return "RESERVED";
    default:
      return nullptr;
  }
}

std::string UsbControlTransferTypeToString(UsbControlTransferType value) {
  const char *str = UsbControlTransferTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbControlTransferType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbControlTransferType value) {
  return os << UsbControlTransferTypeToString(value);
}

NOINLINE static const char* UsbControlTransferRecipientToStringHelper(UsbControlTransferRecipient value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbControlTransferRecipient::DEVICE:
      return "DEVICE";
    case UsbControlTransferRecipient::INTERFACE:
      return "INTERFACE";
    case UsbControlTransferRecipient::ENDPOINT:
      return "ENDPOINT";
    case UsbControlTransferRecipient::OTHER:
      return "OTHER";
    default:
      return nullptr;
  }
}

std::string UsbControlTransferRecipientToString(UsbControlTransferRecipient value) {
  const char *str = UsbControlTransferRecipientToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbControlTransferRecipient value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbControlTransferRecipient value) {
  return os << UsbControlTransferRecipientToString(value);
}

NOINLINE static const char* UsbTransferTypeToStringHelper(UsbTransferType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbTransferType::CONTROL:
      return "CONTROL";
    case UsbTransferType::ISOCHRONOUS:
      return "ISOCHRONOUS";
    case UsbTransferType::BULK:
      return "BULK";
    case UsbTransferType::INTERRUPT:
      return "INTERRUPT";
    default:
      return nullptr;
  }
}

std::string UsbTransferTypeToString(UsbTransferType value) {
  const char *str = UsbTransferTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbTransferType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbTransferType value) {
  return os << UsbTransferTypeToString(value);
}

NOINLINE static const char* UsbSynchronizationTypeToStringHelper(UsbSynchronizationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbSynchronizationType::NONE:
      return "NONE";
    case UsbSynchronizationType::ASYNCHRONOUS:
      return "ASYNCHRONOUS";
    case UsbSynchronizationType::ADAPTIVE:
      return "ADAPTIVE";
    case UsbSynchronizationType::SYNCHRONOUS:
      return "SYNCHRONOUS";
    default:
      return nullptr;
  }
}

std::string UsbSynchronizationTypeToString(UsbSynchronizationType value) {
  const char *str = UsbSynchronizationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbSynchronizationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbSynchronizationType value) {
  return os << UsbSynchronizationTypeToString(value);
}

NOINLINE static const char* UsbUsageTypeToStringHelper(UsbUsageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbUsageType::DATA:
      return "DATA";
    case UsbUsageType::FEEDBACK:
      return "FEEDBACK";
    case UsbUsageType::EXPLICIT_FEEDBACK:
      return "EXPLICIT_FEEDBACK";
    case UsbUsageType::PERIODIC:
      return "PERIODIC";
    case UsbUsageType::NOTIFICATION:
      return "NOTIFICATION";
    case UsbUsageType::RESERVED:
      return "RESERVED";
    default:
      return nullptr;
  }
}

std::string UsbUsageTypeToString(UsbUsageType value) {
  const char *str = UsbUsageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbUsageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbUsageType value) {
  return os << UsbUsageTypeToString(value);
}

NOINLINE static const char* UsbTransferStatusToStringHelper(UsbTransferStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UsbTransferStatus::COMPLETED:
      return "COMPLETED";
    case UsbTransferStatus::TRANSFER_ERROR:
      return "TRANSFER_ERROR";
    case UsbTransferStatus::TIMEOUT:
      return "TIMEOUT";
    case UsbTransferStatus::CANCELLED:
      return "CANCELLED";
    case UsbTransferStatus::STALLED:
      return "STALLED";
    case UsbTransferStatus::DISCONNECT:
      return "DISCONNECT";
    case UsbTransferStatus::BABBLE:
      return "BABBLE";
    case UsbTransferStatus::SHORT_PACKET:
      return "SHORT_PACKET";
    case UsbTransferStatus::PERMISSION_DENIED:
      return "PERMISSION_DENIED";
    default:
      return nullptr;
  }
}

std::string UsbTransferStatusToString(UsbTransferStatus value) {
  const char *str = UsbTransferStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UsbTransferStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UsbTransferStatus value) {
  return os << UsbTransferStatusToString(value);
}

namespace internal {
// static
bool UsbOpenDeviceResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UsbOpenDeviceResult_Data* object = static_cast<const UsbOpenDeviceResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UsbOpenDeviceResult_Tag::kSuccess: {


      if (!::device::mojom::internal::UsbOpenDeviceSuccess_Data
            ::Validate(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case UsbOpenDeviceResult_Tag::kError: {


      if (!::device::mojom::internal::UsbOpenDeviceError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UsbOpenDeviceResult");
      return false;
    }
  }
}


// static
bool UsbEndpointInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbEndpointInfo_Data* object =
      static_cast<const UsbEndpointInfo_Data*>(data);


  if (!::device::mojom::internal::UsbTransferDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::device::mojom::internal::UsbTransferType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::device::mojom::internal::UsbSynchronizationType_Data
        ::Validate(object->synchronization_type, validation_context))
    return false;


  if (!::device::mojom::internal::UsbUsageType_Data
        ::Validate(object->usage_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }

  return true;
}

UsbEndpointInfo_Data::UsbEndpointInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbAlternateInterfaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbAlternateInterfaceInfo_Data* object =
      static_cast<const UsbAlternateInterfaceInfo_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->interface_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoints, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->endpoints, validation_context,
                                         &endpoints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }

  return true;
}

UsbAlternateInterfaceInfo_Data::UsbAlternateInterfaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbInterfaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbInterfaceInfo_Data* object =
      static_cast<const UsbInterfaceInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alternates, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alternates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alternates, validation_context,
                                         &alternates_validate_params)) {
    return false;
  }

  return true;
}

UsbInterfaceInfo_Data::UsbInterfaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbConfigurationInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbConfigurationInfo_Data* object =
      static_cast<const UsbConfigurationInfo_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->configuration_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interfaces, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& interfaces_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->interfaces, validation_context,
                                         &interfaces_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }

  return true;
}

UsbConfigurationInfo_Data::UsbConfigurationInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDeviceInfo_Data* object =
      static_cast<const UsbDeviceInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& guid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->manufacturer_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->product_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->serial_number, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->webusb_landing_page, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configurations, 20, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& configurations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->configurations, validation_context,
                                         &configurations_validate_params)) {
    return false;
  }

  return true;
}

UsbDeviceInfo_Data::UsbDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbControlTransferParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbControlTransferParams_Data* object =
      static_cast<const UsbControlTransferParams_Data*>(data);


  if (!::device::mojom::internal::UsbControlTransferType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::device::mojom::internal::UsbControlTransferRecipient_Data
        ::Validate(object->recipient, validation_context))
    return false;

  return true;
}

UsbControlTransferParams_Data::UsbControlTransferParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbIsochronousPacket_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbIsochronousPacket_Data* object =
      static_cast<const UsbIsochronousPacket_Data*>(data);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

UsbIsochronousPacket_Data::UsbIsochronousPacket_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_Open_Params_Data* object =
      static_cast<const UsbDevice_Open_Params_Data*>(data);

  return true;
}

UsbDevice_Open_Params_Data::UsbDevice_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Open_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_Open_ResponseParams_Data* object =
      static_cast<const UsbDevice_Open_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

UsbDevice_Open_ResponseParams_Data::UsbDevice_Open_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_Close_Params_Data* object =
      static_cast<const UsbDevice_Close_Params_Data*>(data);

  return true;
}

UsbDevice_Close_Params_Data::UsbDevice_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_Close_ResponseParams_Data* object =
      static_cast<const UsbDevice_Close_ResponseParams_Data*>(data);

  return true;
}

UsbDevice_Close_ResponseParams_Data::UsbDevice_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_SetConfiguration_Params_Data* object =
      static_cast<const UsbDevice_SetConfiguration_Params_Data*>(data);

  return true;
}

UsbDevice_SetConfiguration_Params_Data::UsbDevice_SetConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_SetConfiguration_ResponseParams_Data* object =
      static_cast<const UsbDevice_SetConfiguration_ResponseParams_Data*>(data);

  return true;
}

UsbDevice_SetConfiguration_ResponseParams_Data::UsbDevice_SetConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClaimInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ClaimInterface_Params_Data* object =
      static_cast<const UsbDevice_ClaimInterface_Params_Data*>(data);

  return true;
}

UsbDevice_ClaimInterface_Params_Data::UsbDevice_ClaimInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClaimInterface_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ClaimInterface_ResponseParams_Data* object =
      static_cast<const UsbDevice_ClaimInterface_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::UsbClaimInterfaceResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

UsbDevice_ClaimInterface_ResponseParams_Data::UsbDevice_ClaimInterface_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ReleaseInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ReleaseInterface_Params_Data* object =
      static_cast<const UsbDevice_ReleaseInterface_Params_Data*>(data);

  return true;
}

UsbDevice_ReleaseInterface_Params_Data::UsbDevice_ReleaseInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ReleaseInterface_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ReleaseInterface_ResponseParams_Data* object =
      static_cast<const UsbDevice_ReleaseInterface_ResponseParams_Data*>(data);

  return true;
}

UsbDevice_ReleaseInterface_ResponseParams_Data::UsbDevice_ReleaseInterface_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetInterfaceAlternateSetting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_SetInterfaceAlternateSetting_Params_Data* object =
      static_cast<const UsbDevice_SetInterfaceAlternateSetting_Params_Data*>(data);

  return true;
}

UsbDevice_SetInterfaceAlternateSetting_Params_Data::UsbDevice_SetInterfaceAlternateSetting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data* object =
      static_cast<const UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data*>(data);

  return true;
}

UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data::UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Reset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_Reset_Params_Data* object =
      static_cast<const UsbDevice_Reset_Params_Data*>(data);

  return true;
}

UsbDevice_Reset_Params_Data::UsbDevice_Reset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Reset_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_Reset_ResponseParams_Data* object =
      static_cast<const UsbDevice_Reset_ResponseParams_Data*>(data);

  return true;
}

UsbDevice_Reset_ResponseParams_Data::UsbDevice_Reset_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClearHalt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ClearHalt_Params_Data* object =
      static_cast<const UsbDevice_ClearHalt_Params_Data*>(data);


  if (!::device::mojom::internal::UsbTransferDirection_Data
        ::Validate(object->direction, validation_context))
    return false;

  return true;
}

UsbDevice_ClearHalt_Params_Data::UsbDevice_ClearHalt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClearHalt_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ClearHalt_ResponseParams_Data* object =
      static_cast<const UsbDevice_ClearHalt_ResponseParams_Data*>(data);

  return true;
}

UsbDevice_ClearHalt_ResponseParams_Data::UsbDevice_ClearHalt_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ControlTransferIn_Params_Data* object =
      static_cast<const UsbDevice_ControlTransferIn_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

UsbDevice_ControlTransferIn_Params_Data::UsbDevice_ControlTransferIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferIn_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ControlTransferIn_ResponseParams_Data* object =
      static_cast<const UsbDevice_ControlTransferIn_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UsbDevice_ControlTransferIn_ResponseParams_Data::UsbDevice_ControlTransferIn_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ControlTransferOut_Params_Data* object =
      static_cast<const UsbDevice_ControlTransferOut_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UsbDevice_ControlTransferOut_Params_Data::UsbDevice_ControlTransferOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferOut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_ControlTransferOut_ResponseParams_Data* object =
      static_cast<const UsbDevice_ControlTransferOut_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

UsbDevice_ControlTransferOut_ResponseParams_Data::UsbDevice_ControlTransferOut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_GenericTransferIn_Params_Data* object =
      static_cast<const UsbDevice_GenericTransferIn_Params_Data*>(data);

  return true;
}

UsbDevice_GenericTransferIn_Params_Data::UsbDevice_GenericTransferIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferIn_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_GenericTransferIn_ResponseParams_Data* object =
      static_cast<const UsbDevice_GenericTransferIn_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UsbDevice_GenericTransferIn_ResponseParams_Data::UsbDevice_GenericTransferIn_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_GenericTransferOut_Params_Data* object =
      static_cast<const UsbDevice_GenericTransferOut_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UsbDevice_GenericTransferOut_Params_Data::UsbDevice_GenericTransferOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferOut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_GenericTransferOut_ResponseParams_Data* object =
      static_cast<const UsbDevice_GenericTransferOut_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

UsbDevice_GenericTransferOut_ResponseParams_Data::UsbDevice_GenericTransferOut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_IsochronousTransferIn_Params_Data* object =
      static_cast<const UsbDevice_IsochronousTransferIn_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packet_lengths, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& packet_lengths_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->packet_lengths, validation_context,
                                         &packet_lengths_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferIn_Params_Data::UsbDevice_IsochronousTransferIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferIn_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_IsochronousTransferIn_ResponseParams_Data* object =
      static_cast<const UsbDevice_IsochronousTransferIn_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packets, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& packets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->packets, validation_context,
                                         &packets_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferIn_ResponseParams_Data::UsbDevice_IsochronousTransferIn_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_IsochronousTransferOut_Params_Data* object =
      static_cast<const UsbDevice_IsochronousTransferOut_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packet_lengths, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& packet_lengths_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->packet_lengths, validation_context,
                                         &packet_lengths_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferOut_Params_Data::UsbDevice_IsochronousTransferOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferOut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDevice_IsochronousTransferOut_ResponseParams_Data* object =
      static_cast<const UsbDevice_IsochronousTransferOut_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packets, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& packets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->packets, validation_context,
                                         &packets_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferOut_ResponseParams_Data::UsbDevice_IsochronousTransferOut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceClient_OnDeviceOpened_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDeviceClient_OnDeviceOpened_Params_Data* object =
      static_cast<const UsbDeviceClient_OnDeviceOpened_Params_Data*>(data);

  return true;
}

UsbDeviceClient_OnDeviceOpened_Params_Data::UsbDeviceClient_OnDeviceOpened_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceClient_OnDeviceClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UsbDeviceClient_OnDeviceClosed_Params_Data* object =
      static_cast<const UsbDeviceClient_OnDeviceClosed_Params_Data*>(data);

  return true;
}

UsbDeviceClient_OnDeviceClosed_Params_Data::UsbDeviceClient_OnDeviceClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbOpenDeviceSuccess>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbOpenDeviceSuccess value) {
  return std::move(context).WriteString(::device::mojom::UsbOpenDeviceSuccessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbOpenDeviceError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbOpenDeviceError value) {
  return std::move(context).WriteString(::device::mojom::UsbOpenDeviceErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbClaimInterfaceResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbClaimInterfaceResult value) {
  return std::move(context).WriteString(::device::mojom::UsbClaimInterfaceResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbTransferDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbTransferDirection value) {
  return std::move(context).WriteString(::device::mojom::UsbTransferDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbControlTransferType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbControlTransferType value) {
  return std::move(context).WriteString(::device::mojom::UsbControlTransferTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbControlTransferRecipient>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbControlTransferRecipient value) {
  return std::move(context).WriteString(::device::mojom::UsbControlTransferRecipientToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbTransferType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbTransferType value) {
  return std::move(context).WriteString(::device::mojom::UsbTransferTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbSynchronizationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbSynchronizationType value) {
  return std::move(context).WriteString(::device::mojom::UsbSynchronizationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbUsageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbUsageType value) {
  return std::move(context).WriteString(::device::mojom::UsbUsageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbTransferStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UsbTransferStatus value) {
  return std::move(context).WriteString(::device::mojom::UsbTransferStatusToString(value));
}

} // namespace perfetto