// services/device/public/mojom/nfc_provider.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_PROVIDER_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_PROVIDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/nfc_provider.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/nfc_provider.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/nfc_provider.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/nfc.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class NFCProviderProxy;

template <typename ImplRefTraits>
class NFCProviderStub;

class NFCProviderRequestValidator;


class BLINK_PLATFORM_EXPORT NFCProvider
    : public NFCProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NFCProviderInterfaceBase;
  using Proxy_ = NFCProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = NFCProviderStub<ImplRefTraits>;

  using RequestValidator_ = NFCProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetNFCForHostMinVersion = 0,
    kSuspendNFCOperationsMinVersion = 0,
    kResumeNFCOperationsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetNFCForHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuspendNFCOperations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResumeNFCOperations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NFCProvider() = default;

  
  virtual void GetNFCForHost(int32_t host_id, ::mojo::PendingReceiver<::device::mojom::blink::NFC> receiver) = 0;

  
  virtual void SuspendNFCOperations() = 0;

  
  virtual void ResumeNFCOperations() = 0;
};



class BLINK_PLATFORM_EXPORT NFCProviderProxy
    : public NFCProvider {
 public:
  using InterfaceType = NFCProvider;

  explicit NFCProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetNFCForHost(int32_t host_id, ::mojo::PendingReceiver<::device::mojom::blink::NFC> receiver) final;
  
  void SuspendNFCOperations() final;
  
  void ResumeNFCOperations() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT NFCProviderStubDispatch {
 public:
  static bool Accept(NFCProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NFCProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NFCProvider>>
class NFCProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NFCProviderStub() = default;
  ~NFCProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT NFCProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // device::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_NFC_PROVIDER_MOJOM_BLINK_H_