// media/mojo/mojom/stable/stable_video_decoder_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-params-data.h"
namespace media {
namespace stable {
namespace mojom {

NOINLINE static const char* VideoCodecToStringHelper(VideoCodec value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCodec::kUnknown:
      return "kUnknown";
    case VideoCodec::kH264:
      return "kH264";
    case VideoCodec::kVC1:
      return "kVC1";
    case VideoCodec::kMPEG2:
      return "kMPEG2";
    case VideoCodec::kMPEG4:
      return "kMPEG4";
    case VideoCodec::kTheora:
      return "kTheora";
    case VideoCodec::kVP8:
      return "kVP8";
    case VideoCodec::kVP9:
      return "kVP9";
    case VideoCodec::kHEVC:
      return "kHEVC";
    case VideoCodec::kDolbyVision:
      return "kDolbyVision";
    case VideoCodec::kAV1:
      return "kAV1";
    default:
      return nullptr;
  }
}

std::string VideoCodecToString(VideoCodec value) {
  const char *str = VideoCodecToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCodec value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCodec value) {
  return os << VideoCodecToString(value);
}

NOINLINE static const char* VideoCodecProfileToStringHelper(VideoCodecProfile value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCodecProfile::kVideoCodecProfileUnknown:
      return "kVideoCodecProfileUnknown";
    case VideoCodecProfile::kH264ProfileMin:
      return "{kH264ProfileMin, kH264ProfileBaseline}";
    case VideoCodecProfile::kH264ProfileMain:
      return "kH264ProfileMain";
    case VideoCodecProfile::kH264ProfileExtended:
      return "kH264ProfileExtended";
    case VideoCodecProfile::kH264ProfileHigh:
      return "kH264ProfileHigh";
    case VideoCodecProfile::kH264ProfileHigh10:
      return "kH264ProfileHigh10";
    case VideoCodecProfile::kH264ProfileHigh422:
      return "kH264ProfileHigh422";
    case VideoCodecProfile::kH264ProfileHigh444Predictive:
      return "kH264ProfileHigh444Predictive";
    case VideoCodecProfile::kH264ProfileScalableBaseline:
      return "kH264ProfileScalableBaseline";
    case VideoCodecProfile::kH264ProfileScalableHigh:
      return "kH264ProfileScalableHigh";
    case VideoCodecProfile::kH264ProfileStereoHigh:
      return "kH264ProfileStereoHigh";
    case VideoCodecProfile::kH264ProfileMultiviewHigh:
      return "{kH264ProfileMultiviewHigh, kH264ProfileMax}";
    case VideoCodecProfile::kVP8ProfileMin:
      return "{kVP8ProfileMin, kVP8ProfileAny, kVP8ProfileMax}";
    case VideoCodecProfile::kVP9ProfileMin:
      return "{kVP9ProfileMin, kVP9Profile0}";
    case VideoCodecProfile::kVP9Profile1:
      return "kVP9Profile1";
    case VideoCodecProfile::kVP9Profile2:
      return "kVP9Profile2";
    case VideoCodecProfile::kVP9Profile3:
      return "{kVP9Profile3, kVP9ProfileMax}";
    case VideoCodecProfile::kHEVCProfileMin:
      return "{kHEVCProfileMin, kHEVCProfileMain}";
    case VideoCodecProfile::kHEVCProfileMain10:
      return "kHEVCProfileMain10";
    case VideoCodecProfile::kHEVCProfileMainStillPicture:
      return "{kHEVCProfileMainStillPicture, kHEVCProfileMax}";
    case VideoCodecProfile::kDolbyVisionProfile0:
      return "kDolbyVisionProfile0";
    case VideoCodecProfile::kDeprecatedDolbyVisionProfile4:
      return "kDeprecatedDolbyVisionProfile4";
    case VideoCodecProfile::kDolbyVisionProfile5:
      return "kDolbyVisionProfile5";
    case VideoCodecProfile::kDolbyVisionProfile7:
      return "kDolbyVisionProfile7";
    case VideoCodecProfile::kTheoraProfileMin:
      return "{kTheoraProfileMin, kTheoraProfileAny, kTheoraProfileMax}";
    case VideoCodecProfile::kAV1ProfileMin:
      return "{kAV1ProfileMin, kAV1ProfileMain}";
    case VideoCodecProfile::kAV1ProfileHigh:
      return "kAV1ProfileHigh";
    case VideoCodecProfile::kAV1ProfilePro:
      return "{kAV1ProfilePro, kAV1ProfileMax}";
    case VideoCodecProfile::kDolbyVisionProfile8:
      return "kDolbyVisionProfile8";
    case VideoCodecProfile::kDolbyVisionProfile9:
      return "kDolbyVisionProfile9";
    case VideoCodecProfile::kHEVCProfileExtMin:
      return "{kHEVCProfileExtMin, kHEVCProfileRext}";
    case VideoCodecProfile::kHEVCProfileHighThroughput:
      return "kHEVCProfileHighThroughput";
    case VideoCodecProfile::kHEVCProfileMultiviewMain:
      return "kHEVCProfileMultiviewMain";
    case VideoCodecProfile::kHEVCProfileScalableMain:
      return "kHEVCProfileScalableMain";
    case VideoCodecProfile::kHEVCProfile3dMain:
      return "kHEVCProfile3dMain";
    case VideoCodecProfile::kHEVCProfileScreenExtended:
      return "kHEVCProfileScreenExtended";
    case VideoCodecProfile::kHEVCProfileScalableRext:
      return "kHEVCProfileScalableRext";
    case VideoCodecProfile::kHEVCProfileHighThroughputScreenExtended:
      return "{kHEVCProfileHighThroughputScreenExtended, kHEVCProfileExtMax}";
    case VideoCodecProfile::kVVCProfileMin:
      return "{kVVCProfileMin, kVVCProfileMain10}";
    case VideoCodecProfile::kVVCProfileMain12:
      return "kVVCProfileMain12";
    case VideoCodecProfile::kVVCProfileMain12Intra:
      return "kVVCProfileMain12Intra";
    case VideoCodecProfile::kVVCProfileMultilayerMain10:
      return "kVVCProfileMultilayerMain10";
    case VideoCodecProfile::kVVCProfileMain10444:
      return "kVVCProfileMain10444";
    case VideoCodecProfile::kVVCProfileMain12444:
      return "kVVCProfileMain12444";
    case VideoCodecProfile::kVVCProfileMain16444:
      return "kVVCProfileMain16444";
    case VideoCodecProfile::kVVCProfileMain12444Intra:
      return "kVVCProfileMain12444Intra";
    case VideoCodecProfile::kVVCProfileMain16444Intra:
      return "kVVCProfileMain16444Intra";
    case VideoCodecProfile::kVVCProfileMultilayerMain10444:
      return "kVVCProfileMultilayerMain10444";
    case VideoCodecProfile::kVVCProfileMain10Still:
      return "kVVCProfileMain10Still";
    case VideoCodecProfile::kVVCProfileMain12Still:
      return "kVVCProfileMain12Still";
    case VideoCodecProfile::kVVCProfileMain10444Still:
      return "kVVCProfileMain10444Still";
    case VideoCodecProfile::kVVCProfileMain12444Still:
      return "kVVCProfileMain12444Still";
    case VideoCodecProfile::kVVCProfileMain16444Still:
      return "{kVVCProfileMain16444Still, kVVCProileMax}";
    default:
      return nullptr;
  }
}

std::string VideoCodecProfileToString(VideoCodecProfile value) {
  const char *str = VideoCodecProfileToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCodecProfile value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCodecProfile value) {
  return os << VideoCodecProfileToString(value);
}

NOINLINE static const char* EncryptionSchemeToStringHelper(EncryptionScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EncryptionScheme::kUnencrypted:
      return "kUnencrypted";
    case EncryptionScheme::kCenc:
      return "kCenc";
    case EncryptionScheme::kCbcs:
      return "kCbcs";
    default:
      return nullptr;
  }
}

std::string EncryptionSchemeToString(EncryptionScheme value) {
  const char *str = EncryptionSchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EncryptionScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EncryptionScheme value) {
  return os << EncryptionSchemeToString(value);
}

NOINLINE static const char* StatusCodeToStringHelper(StatusCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StatusCode::kOk_DEPRECATED:
      return "kOk_DEPRECATED";
    case StatusCode::kAborted:
      return "kAborted";
    case StatusCode::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string StatusCodeToString(StatusCode value) {
  const char *str = StatusCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StatusCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StatusCode value) {
  return os << StatusCodeToString(value);
}

NOINLINE static const char* VideoDecoderTypeToStringHelper(VideoDecoderType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoDecoderType::kUnknown:
      return "kUnknown";
    case VideoDecoderType::kVaapi:
      return "kVaapi";
    case VideoDecoderType::kVda:
      return "kVda";
    case VideoDecoderType::kV4L2:
      return "kV4L2";
    case VideoDecoderType::kTesting:
      return "kTesting";
    default:
      return nullptr;
  }
}

std::string VideoDecoderTypeToString(VideoDecoderType value) {
  const char *str = VideoDecoderTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoDecoderType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoDecoderType value) {
  return os << VideoDecoderTypeToString(value);
}

NOINLINE static const char* ColorSpacePrimaryIDToStringHelper(ColorSpacePrimaryID value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ColorSpacePrimaryID::kInvalid:
      return "kInvalid";
    case ColorSpacePrimaryID::kBT709:
      return "kBT709";
    case ColorSpacePrimaryID::kBT470M:
      return "kBT470M";
    case ColorSpacePrimaryID::kBT470BG:
      return "kBT470BG";
    case ColorSpacePrimaryID::kSMPTE170M:
      return "kSMPTE170M";
    case ColorSpacePrimaryID::kSMPTE240M:
      return "kSMPTE240M";
    case ColorSpacePrimaryID::kFilm:
      return "kFilm";
    case ColorSpacePrimaryID::kBT2020:
      return "kBT2020";
    case ColorSpacePrimaryID::kSMPTEST428_1:
      return "kSMPTEST428_1";
    case ColorSpacePrimaryID::kSMPTEST431_2:
      return "kSMPTEST431_2";
    case ColorSpacePrimaryID::kSMPTEST432_1:
      return "kSMPTEST432_1";
    case ColorSpacePrimaryID::kXYZ_D50:
      return "kXYZ_D50";
    case ColorSpacePrimaryID::kAdobeRGB:
      return "kAdobeRGB";
    case ColorSpacePrimaryID::kAppleGenericRGB:
      return "kAppleGenericRGB";
    case ColorSpacePrimaryID::kWideGamutColorSpin:
      return "kWideGamutColorSpin";
    case ColorSpacePrimaryID::kCustom:
      return "kCustom";
    case ColorSpacePrimaryID::kEBU_3213_E:
      return "kEBU_3213_E";
    default:
      return nullptr;
  }
}

std::string ColorSpacePrimaryIDToString(ColorSpacePrimaryID value) {
  const char *str = ColorSpacePrimaryIDToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ColorSpacePrimaryID value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ColorSpacePrimaryID value) {
  return os << ColorSpacePrimaryIDToString(value);
}

NOINLINE static const char* ColorSpaceTransferIDToStringHelper(ColorSpaceTransferID value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ColorSpaceTransferID::kInvalid:
      return "kInvalid";
    case ColorSpaceTransferID::kBT709:
      return "kBT709";
    case ColorSpaceTransferID::kBT709Apple:
      return "kBT709Apple";
    case ColorSpaceTransferID::kGamma18:
      return "kGamma18";
    case ColorSpaceTransferID::kGamma22:
      return "kGamma22";
    case ColorSpaceTransferID::kGamma24:
      return "kGamma24";
    case ColorSpaceTransferID::kGamma28:
      return "kGamma28";
    case ColorSpaceTransferID::kSMPTE170M:
      return "kSMPTE170M";
    case ColorSpaceTransferID::kSMPTE240M:
      return "kSMPTE240M";
    case ColorSpaceTransferID::kLinear:
      return "kLinear";
    case ColorSpaceTransferID::kLog:
      return "kLog";
    case ColorSpaceTransferID::kLogSqrt:
      return "kLogSqrt";
    case ColorSpaceTransferID::kIEC61966_2_4:
      return "kIEC61966_2_4";
    case ColorSpaceTransferID::kBT1361_ECG:
      return "kBT1361_ECG";
    case ColorSpaceTransferID::kIEC61966_2_1:
      return "kIEC61966_2_1";
    case ColorSpaceTransferID::kBT2020_10:
      return "kBT2020_10";
    case ColorSpaceTransferID::kBT2020_12:
      return "kBT2020_12";
    case ColorSpaceTransferID::kSMPTEST2084:
      return "kSMPTEST2084";
    case ColorSpaceTransferID::kSMPTEST428_1:
      return "kSMPTEST428_1";
    case ColorSpaceTransferID::kARIB_STD_B67:
      return "kARIB_STD_B67";
    case ColorSpaceTransferID::kIEC61966_2_1_HDR:
      return "kIEC61966_2_1_HDR";
    case ColorSpaceTransferID::kLinearHDR:
      return "kLinearHDR";
    case ColorSpaceTransferID::kCustom:
      return "kCustom";
    case ColorSpaceTransferID::kCustomHDR:
      return "kCustomHDR";
    case ColorSpaceTransferID::kPiecewiseHDR:
      return "kPiecewiseHDR";
    case ColorSpaceTransferID::kScrgbLinear80Nits:
      return "kScrgbLinear80Nits";
    default:
      return nullptr;
  }
}

std::string ColorSpaceTransferIDToString(ColorSpaceTransferID value) {
  const char *str = ColorSpaceTransferIDToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ColorSpaceTransferID value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ColorSpaceTransferID value) {
  return os << ColorSpaceTransferIDToString(value);
}

NOINLINE static const char* ColorSpaceMatrixIDToStringHelper(ColorSpaceMatrixID value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ColorSpaceMatrixID::kInvalid:
      return "kInvalid";
    case ColorSpaceMatrixID::kRGB:
      return "kRGB";
    case ColorSpaceMatrixID::kBT709:
      return "kBT709";
    case ColorSpaceMatrixID::kFCC:
      return "kFCC";
    case ColorSpaceMatrixID::kBT470BG:
      return "kBT470BG";
    case ColorSpaceMatrixID::kSMPTE170M:
      return "kSMPTE170M";
    case ColorSpaceMatrixID::kSMPTE240M:
      return "kSMPTE240M";
    case ColorSpaceMatrixID::kYCOCG:
      return "kYCOCG";
    case ColorSpaceMatrixID::kBT2020_NCL:
      return "kBT2020_NCL";
    case ColorSpaceMatrixID::kBT2020_CL:
      return "kBT2020_CL";
    case ColorSpaceMatrixID::kYDZDX:
      return "kYDZDX";
    case ColorSpaceMatrixID::kGBR:
      return "kGBR";
    default:
      return nullptr;
  }
}

std::string ColorSpaceMatrixIDToString(ColorSpaceMatrixID value) {
  const char *str = ColorSpaceMatrixIDToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ColorSpaceMatrixID value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ColorSpaceMatrixID value) {
  return os << ColorSpaceMatrixIDToString(value);
}

NOINLINE static const char* ColorSpaceRangeIDToStringHelper(ColorSpaceRangeID value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ColorSpaceRangeID::kInvalid:
      return "kInvalid";
    case ColorSpaceRangeID::kLimited:
      return "kLimited";
    case ColorSpaceRangeID::kFull:
      return "kFull";
    case ColorSpaceRangeID::kDerived:
      return "kDerived";
    default:
      return nullptr;
  }
}

std::string ColorSpaceRangeIDToString(ColorSpaceRangeID value) {
  const char *str = ColorSpaceRangeIDToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ColorSpaceRangeID value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ColorSpaceRangeID value) {
  return os << ColorSpaceRangeIDToString(value);
}

NOINLINE static const char* VideoPixelFormatToStringHelper(VideoPixelFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoPixelFormat::kPixelFormatUnknown:
      return "kPixelFormatUnknown";
    case VideoPixelFormat::kPixelFormatI420:
      return "kPixelFormatI420";
    case VideoPixelFormat::kPixelFormatYV12:
      return "kPixelFormatYV12";
    case VideoPixelFormat::kPixelFormatI422:
      return "kPixelFormatI422";
    case VideoPixelFormat::kPixelFormatI420A:
      return "kPixelFormatI420A";
    case VideoPixelFormat::kPixelFormatI444:
      return "kPixelFormatI444";
    case VideoPixelFormat::kPixelFormatNV12:
      return "kPixelFormatNV12";
    case VideoPixelFormat::kPixelFormatNV21:
      return "kPixelFormatNV21";
    case VideoPixelFormat::kPixelFormatUYVY:
      return "kPixelFormatUYVY";
    case VideoPixelFormat::kPixelFormatYUY2:
      return "kPixelFormatYUY2";
    case VideoPixelFormat::kPixelFormatARGB:
      return "kPixelFormatARGB";
    case VideoPixelFormat::kPixelFormatXRGB:
      return "kPixelFormatXRGB";
    case VideoPixelFormat::kPixelFormatRGB24:
      return "kPixelFormatRGB24";
    case VideoPixelFormat::kPixelFormatMJPEG:
      return "kPixelFormatMJPEG";
    case VideoPixelFormat::kPixelFormatYUV420P9:
      return "kPixelFormatYUV420P9";
    case VideoPixelFormat::kPixelFormatYUV420P10:
      return "kPixelFormatYUV420P10";
    case VideoPixelFormat::kPixelFormatYUV422P9:
      return "kPixelFormatYUV422P9";
    case VideoPixelFormat::kPixelFormatYUV422P10:
      return "kPixelFormatYUV422P10";
    case VideoPixelFormat::kPixelFormatYUV444P9:
      return "kPixelFormatYUV444P9";
    case VideoPixelFormat::kPixelFormatYUV444P10:
      return "kPixelFormatYUV444P10";
    case VideoPixelFormat::kPixelFormatYUV420P12:
      return "kPixelFormatYUV420P12";
    case VideoPixelFormat::kPixelFormatYUV422P12:
      return "kPixelFormatYUV422P12";
    case VideoPixelFormat::kPixelFormatYUV444P12:
      return "kPixelFormatYUV444P12";
    case VideoPixelFormat::kPixelFormatY16:
      return "kPixelFormatY16";
    case VideoPixelFormat::kPixelFormatABGR:
      return "kPixelFormatABGR";
    case VideoPixelFormat::kPixelFormatXBGR:
      return "kPixelFormatXBGR";
    case VideoPixelFormat::kPixelFormatP010LE:
      return "kPixelFormatP010LE";
    case VideoPixelFormat::kPixelFormatXR30:
      return "kPixelFormatXR30";
    case VideoPixelFormat::kPixelFormatXB30:
      return "kPixelFormatXB30";
    case VideoPixelFormat::kPixelFormatBGRA:
      return "kPixelFormatBGRA";
    case VideoPixelFormat::kPixelFormatRGBAF16:
      return "kPixelFormatRGBAF16";
    case VideoPixelFormat::kPixelFormatI422A:
      return "kPixelFormatI422A";
    case VideoPixelFormat::kPixelFormatI444A:
      return "kPixelFormatI444A";
    case VideoPixelFormat::kPixelFormatYUV420AP10:
      return "kPixelFormatYUV420AP10";
    case VideoPixelFormat::kPixelFormatYUV422AP10:
      return "kPixelFormatYUV422AP10";
    case VideoPixelFormat::kPixelFormatYUV444AP10:
      return "kPixelFormatYUV444AP10";
    case VideoPixelFormat::kPixelFormatNV12A:
      return "kPixelFormatNV12A";
    case VideoPixelFormat::kPixelFormatNV16:
      return "kPixelFormatNV16";
    case VideoPixelFormat::kPixelFormatNV24:
      return "kPixelFormatNV24";
    case VideoPixelFormat::kPixelFormatP210LE:
      return "kPixelFormatP210LE";
    case VideoPixelFormat::kPixelFormatP410LE:
      return "kPixelFormatP410LE";
    default:
      return nullptr;
  }
}

std::string VideoPixelFormatToString(VideoPixelFormat value) {
  const char *str = VideoPixelFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoPixelFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoPixelFormat value) {
  return os << VideoPixelFormatToString(value);
}

NOINLINE static const char* WaitingReasonToStringHelper(WaitingReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WaitingReason::kNoCdm:
      return "kNoCdm";
    case WaitingReason::kNoDecryptionKey:
      return "kNoDecryptionKey";
    case WaitingReason::kDecoderStateLost:
      return "kDecoderStateLost";
    case WaitingReason::kSecureSurfaceLost:
      return "kSecureSurfaceLost";
    default:
      return nullptr;
  }
}

std::string WaitingReasonToString(WaitingReason value) {
  const char *str = WaitingReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WaitingReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WaitingReason value) {
  return os << WaitingReasonToString(value);
}

NOINLINE static const char* DecryptStatusToStringHelper(DecryptStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DecryptStatus::kSuccess:
      return "kSuccess";
    case DecryptStatus::kNoKey:
      return "kNoKey";
    case DecryptStatus::kFailure:
      return "kFailure";
    default:
      return nullptr;
  }
}

std::string DecryptStatusToString(DecryptStatus value) {
  const char *str = DecryptStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DecryptStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DecryptStatus value) {
  return os << DecryptStatusToString(value);
}

NOINLINE static const char* CdmContextEventToStringHelper(CdmContextEvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CdmContextEvent::kHasAdditionalUsableKey:
      return "kHasAdditionalUsableKey";
    case CdmContextEvent::kHardwareContextReset:
      return "kHardwareContextReset";
    default:
      return nullptr;
  }
}

std::string CdmContextEventToString(CdmContextEvent value) {
  const char *str = CdmContextEventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CdmContextEvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CdmContextEvent value) {
  return os << CdmContextEventToString(value);
}

NOINLINE static const char* MediaLogRecord_TypeToStringHelper(MediaLogRecord_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaLogRecord_Type::kMessage:
      return "kMessage";
    case MediaLogRecord_Type::kMediaPropertyChange:
      return "kMediaPropertyChange";
    case MediaLogRecord_Type::kMediaEventTriggered:
      return "kMediaEventTriggered";
    case MediaLogRecord_Type::kMediaStatus:
      return "kMediaStatus";
    default:
      return nullptr;
  }
}

std::string MediaLogRecord_TypeToString(MediaLogRecord_Type value) {
  const char *str = MediaLogRecord_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaLogRecord_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaLogRecord_Type value) {
  return os << MediaLogRecord_TypeToString(value);
}

namespace internal {


// static
bool SubsampleEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SubsampleEntry_Data* object =
      static_cast<const SubsampleEntry_Data*>(data);

  return true;
}

SubsampleEntry_Data::SubsampleEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DecryptConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DecryptConfig_Data* object =
      static_cast<const DecryptConfig_Data*>(data);


  if (!::media::stable::mojom::internal::EncryptionScheme_Data
        ::Validate(object->encryption_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_id, validation_context,
                                         &key_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->iv, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& iv_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->iv, validation_context,
                                         &iv_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subsamples, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subsamples_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subsamples, validation_context,
                                         &subsamples_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->encryption_pattern, validation_context))
    return false;

  return true;
}

DecryptConfig_Data::DecryptConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ColorVolumeMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ColorVolumeMetadata_Data* object =
      static_cast<const ColorVolumeMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_r, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary_r, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_g, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary_g, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_b, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary_b, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->white_point, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->white_point, validation_context))
    return false;

  return true;
}

ColorVolumeMetadata_Data::ColorVolumeMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HDRMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HDRMetadata_Data* object =
      static_cast<const HDRMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_volume_metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_volume_metadata, validation_context))
    return false;

  return true;
}

HDRMetadata_Data::HDRMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoDecoderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoDecoderConfig_Data* object =
      static_cast<const VideoDecoderConfig_Data*>(data);


  if (!::media::stable::mojom::internal::VideoCodec_Data
        ::Validate(object->codec, validation_context))
    return false;


  if (!::media::stable::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_rect, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->natural_size, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->natural_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }


  if (!::media::stable::mojom::internal::EncryptionScheme_Data
        ::Validate(object->encryption_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space_info, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hdr_metadata, validation_context))
    return false;

  return true;
}

VideoDecoderConfig_Data::VideoDecoderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SupportedVideoDecoderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupportedVideoDecoderConfig_Data* object =
      static_cast<const SupportedVideoDecoderConfig_Data*>(data);


  if (!::media::stable::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile_min, validation_context))
    return false;


  if (!::media::stable::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile_max, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size_min, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size_min, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size_max, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size_max, validation_context))
    return false;

  return true;
}

SupportedVideoDecoderConfig_Data::SupportedVideoDecoderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StatusData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StatusData_Data* object =
      static_cast<const StatusData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group, validation_context,
                                         &group_validate_params)) {
    return false;
  }


  if (!::media::stable::mojom::internal::StatusCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frames, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& frames_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->frames, validation_context,
                                         &frames_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->cause, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

StatusData_Data::StatusData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Status_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Status_Data* object =
      static_cast<const Status_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->internal, validation_context))
    return false;

  return true;
}

Status_Data::Status_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DecoderBufferSideData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DecoderBufferSideData_Data* object =
      static_cast<const DecoderBufferSideData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spatial_layers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& spatial_layers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->spatial_layers, validation_context,
                                         &spatial_layers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpha_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alpha_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alpha_data, validation_context,
                                         &alpha_data_validate_params)) {
    return false;
  }

  return true;
}

DecoderBufferSideData_Data::DecoderBufferSideData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DecoderBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 64 },
    { 1, 72 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DecoderBuffer_Data* object =
      static_cast<const DecoderBuffer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_side_data, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_side_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_side_data, validation_context,
                                         &raw_side_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->decrypt_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->front_discard, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->front_discard, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->back_discard, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->back_discard, validation_context))
    return false;
  if (object->header_.version < 1)
    return true;

  if (!mojo::internal::ValidateStruct(object->side_data, validation_context))
    return false;

  return true;
}

DecoderBuffer_Data::DecoderBuffer_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool ColorSpace_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ColorSpace_Data* object =
      static_cast<const ColorSpace_Data*>(data);


  if (!::media::stable::mojom::internal::ColorSpacePrimaryID_Data
        ::Validate(object->primaries, validation_context))
    return false;


  if (!::media::stable::mojom::internal::ColorSpaceTransferID_Data
        ::Validate(object->transfer, validation_context))
    return false;


  if (!::media::stable::mojom::internal::ColorSpaceMatrixID_Data
        ::Validate(object->matrix, validation_context))
    return false;


  if (!::media::stable::mojom::internal::ColorSpaceRangeID_Data
        ::Validate(object->range, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->custom_primary_matrix, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& custom_primary_matrix_validate_params =
      mojo::internal::GetArrayValidator<9, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->custom_primary_matrix, validation_context,
                                         &custom_primary_matrix_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transfer_params, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transfer_params_validate_params =
      mojo::internal::GetArrayValidator<7, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transfer_params, validation_context,
                                         &transfer_params_validate_params)) {
    return false;
  }

  return true;
}

ColorSpace_Data::ColorSpace_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeGpuMemoryBufferHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeGpuMemoryBufferHandle_Data* object =
      static_cast<const NativeGpuMemoryBufferHandle_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->platform_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->platform_handle, validation_context))
    return false;

  return true;
}

NativeGpuMemoryBufferHandle_Data::NativeGpuMemoryBufferHandle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 16 },
    { 1, 16 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameMetadata_Data* object =
      static_cast<const VideoFrameMetadata_Data*>(data);

  return true;
}

VideoFrameMetadata_Data::VideoFrameMetadata_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool VideoFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrame_Data* object =
      static_cast<const VideoFrame_Data*>(data);


  if (!::media::stable::mojom::internal::VideoPixelFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->natural_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->natural_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_memory_buffer_handle, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_memory_buffer_handle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hdr_metadata, validation_context))
    return false;

  return true;
}

VideoFrame_Data::VideoFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaLogRecord_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaLogRecord_Data* object =
      static_cast<const MediaLogRecord_Data*>(data);


  if (!::media::stable::mojom::internal::MediaLogRecord_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  return true;
}

MediaLogRecord_Data::MediaLogRecord_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace stable
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::VideoCodec>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::VideoCodec value) {
  return std::move(context).WriteString(::media::stable::mojom::VideoCodecToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::VideoCodecProfile>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::VideoCodecProfile value) {
  return std::move(context).WriteString(::media::stable::mojom::VideoCodecProfileToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::EncryptionScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::EncryptionScheme value) {
  return std::move(context).WriteString(::media::stable::mojom::EncryptionSchemeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::StatusCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::StatusCode value) {
  return std::move(context).WriteString(::media::stable::mojom::StatusCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::VideoDecoderType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::VideoDecoderType value) {
  return std::move(context).WriteString(::media::stable::mojom::VideoDecoderTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::ColorSpacePrimaryID>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::ColorSpacePrimaryID value) {
  return std::move(context).WriteString(::media::stable::mojom::ColorSpacePrimaryIDToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::ColorSpaceTransferID>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::ColorSpaceTransferID value) {
  return std::move(context).WriteString(::media::stable::mojom::ColorSpaceTransferIDToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::ColorSpaceMatrixID>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::ColorSpaceMatrixID value) {
  return std::move(context).WriteString(::media::stable::mojom::ColorSpaceMatrixIDToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::ColorSpaceRangeID>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::ColorSpaceRangeID value) {
  return std::move(context).WriteString(::media::stable::mojom::ColorSpaceRangeIDToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::VideoPixelFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::VideoPixelFormat value) {
  return std::move(context).WriteString(::media::stable::mojom::VideoPixelFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::WaitingReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::WaitingReason value) {
  return std::move(context).WriteString(::media::stable::mojom::WaitingReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::DecryptStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::DecryptStatus value) {
  return std::move(context).WriteString(::media::stable::mojom::DecryptStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::CdmContextEvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::CdmContextEvent value) {
  return std::move(context).WriteString(::media::stable::mojom::CdmContextEventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::stable::mojom::MediaLogRecord_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::stable::mojom::MediaLogRecord_Type value) {
  return std::move(context).WriteString(::media::stable::mojom::MediaLogRecord_TypeToString(value));
}

} // namespace perfetto