// gpu/ipc/common/exported_shared_image.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/exported_shared_image.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"



#include "base/component_export.h"




namespace gpu::mojom {
class ExportedSharedImageDataView;



}  // gpu::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::ExportedSharedImageDataView> {
  using Data = ::gpu::mojom::internal::ExportedSharedImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


class ExportedSharedImageDataView {
 public:
  ExportedSharedImageDataView() = default;

  ExportedSharedImageDataView(
      internal::ExportedSharedImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      ::gpu::mojom::SharedImageMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetCreationSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationSyncToken(UserType* output) {
    
    auto* pointer = data_->creation_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  uint32_t texture_target() const {
    return data_->texture_target;
  }
 private:
  internal::ExportedSharedImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ExportedSharedImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ExportedSharedImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::ExportedSharedImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in ExportedSharedImage struct");
    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImageMetadataDataView>(
        in_metadata, metadata_fragment);
    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in ExportedSharedImage struct");
    decltype(Traits::creation_sync_token(input)) in_creation_sync_token = Traits::creation_sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_sync_token)::BaseType> creation_sync_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
        in_creation_sync_token, creation_sync_token_fragment);
    fragment->creation_sync_token.Set(
        creation_sync_token_fragment.is_null() ? nullptr : creation_sync_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->creation_sync_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null creation_sync_token in ExportedSharedImage struct");
    fragment->texture_target = Traits::texture_target(input);
  }

  static bool Deserialize(::gpu::mojom::internal::ExportedSharedImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::ExportedSharedImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void ExportedSharedImageDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void ExportedSharedImageDataView::GetMetadataDataView(
    ::gpu::mojom::SharedImageMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::gpu::mojom::SharedImageMetadataDataView(pointer, message_);
}
inline void ExportedSharedImageDataView::GetCreationSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->creation_sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SHARED_H_