// gpu/ipc/common/client_gmb_interface.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/client_gmb_interface.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/client_gmb_interface.mojom-params-data.h"
namespace gpu {
namespace mojom {

namespace internal {


// static
bool ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data* object =
      static_cast<const ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;


  if (!::gfx::mojom::internal::BufferFormat_Data
        ::Validate(object->format, validation_context))
    return false;


  if (!::gfx::mojom::internal::BufferUsage_Data
        ::Validate(object->usage, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_handle, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_handle, validation_context))
    return false;

  return true;
}

ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data::ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data* object =
      static_cast<const ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer_handle, validation_context))
    return false;

  return true;
}

ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data::ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data* object =
      static_cast<const ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data::ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data* object =
      static_cast<const ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer_handle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_memory, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_memory, validation_context))
    return false;

  return true;
}

ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data::ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data* object =
      static_cast<const ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data*>(data);

  return true;
}

ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data::ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu