// extensions/common/mojom/context_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/context_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/context_type.mojom-params-data.h"
namespace extensions {
namespace mojom {

NOINLINE static const char* ContextTypeToStringHelper(ContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContextType::kPrivilegedExtension:
      return "kPrivilegedExtension";
    case ContextType::kUnprivilegedExtension:
      return "kUnprivilegedExtension";
    case ContextType::kContentScript:
      return "kContentScript";
    case ContextType::kWebPage:
      return "kWebPage";
    case ContextType::kPrivilegedWebPage:
      return "kPrivilegedWebPage";
    case ContextType::kWebUi:
      return "kWebUi";
    case ContextType::kUntrustedWebUi:
      return "kUntrustedWebUi";
    case ContextType::kOffscreenExtension:
      return "kOffscreenExtension";
    case ContextType::kUserScript:
      return "kUserScript";
    case ContextType::kUnspecified:
      return "kUnspecified";
    default:
      return nullptr;
  }
}

std::string ContextTypeToString(ContextType value) {
  const char *str = ContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContextType value) {
  return os << ContextTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::ContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::ContextType value) {
  return std::move(context).WriteString(::extensions::mojom::ContextTypeToString(value));
}

} // namespace perfetto