// content/common/render_message_filter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/render_message_filter.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/render_message_filter.mojom-params-data.h"
namespace content {
namespace mojom {

namespace internal {


// static
bool FrameRoutingInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameRoutingInfo_Data* object =
      static_cast<const FrameRoutingInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_token, validation_context))
    return false;

  return true;
}

FrameRoutingInfo_Data::FrameRoutingInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderMessageFilter_GenerateSingleFrameRoutingInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderMessageFilter_GenerateSingleFrameRoutingInfo_Params_Data* object =
      static_cast<const RenderMessageFilter_GenerateSingleFrameRoutingInfo_Params_Data*>(data);

  return true;
}

RenderMessageFilter_GenerateSingleFrameRoutingInfo_Params_Data::RenderMessageFilter_GenerateSingleFrameRoutingInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderMessageFilter_GenerateSingleFrameRoutingInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderMessageFilter_GenerateSingleFrameRoutingInfo_ResponseParams_Data* object =
      static_cast<const RenderMessageFilter_GenerateSingleFrameRoutingInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

RenderMessageFilter_GenerateSingleFrameRoutingInfo_ResponseParams_Data::RenderMessageFilter_GenerateSingleFrameRoutingInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderMessageFilter_GenerateFrameRoutingInfos_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderMessageFilter_GenerateFrameRoutingInfos_Params_Data* object =
      static_cast<const RenderMessageFilter_GenerateFrameRoutingInfos_Params_Data*>(data);

  return true;
}

RenderMessageFilter_GenerateFrameRoutingInfos_Params_Data::RenderMessageFilter_GenerateFrameRoutingInfos_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderMessageFilter_GenerateFrameRoutingInfos_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderMessageFilter_GenerateFrameRoutingInfos_ResponseParams_Data* object =
      static_cast<const RenderMessageFilter_GenerateFrameRoutingInfos_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info_array, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& info_array_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->info_array, validation_context,
                                         &info_array_validate_params)) {
    return false;
  }

  return true;
}

RenderMessageFilter_GenerateFrameRoutingInfos_ResponseParams_Data::RenderMessageFilter_GenerateFrameRoutingInfos_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content