// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_DOM_h
#define content_protocol_DOM_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/runtime.h"

namespace content {
namespace protocol {
namespace DOM {
using NodeId = int;
using BackendNodeId = int;
class RGBA;

// ------------- Forward and enum declarations.

namespace Enable {
namespace IncludeWhitespaceEnum {
CONTENT_EXPORT extern const char* None;
CONTENT_EXPORT extern const char* All;
} // IncludeWhitespaceEnum
} // Enable

namespace GetElementByRelation {
namespace RelationEnum {
CONTENT_EXPORT extern const char* PopoverTarget;
} // RelationEnum
} // GetElementByRelation

// ------------- Type and builder declarations.

class CONTENT_EXPORT RGBA : public ::crdtp::ProtocolObject<RGBA> {
public:
    ~RGBA() override { }

    int GetR() { return m_r; }
    void SetR(int value) { m_r = value; }

    int GetG() { return m_g; }
    void SetG(int value) { m_g = value; }

    int GetB() { return m_b; }
    void SetB(int value) { m_b = value; }

    bool HasA() { return !!m_a; }
    double GetA(double defaultValue) const {
       return m_a.value_or(defaultValue);
    }
    const std::optional<double>& GetA() const {
       return m_a;
    }
    void SetA(double value) { m_a = value; }

    template<int STATE>
    class RGBABuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RSet = 1 << 1,
            GSet = 1 << 2,
            BSet = 1 << 3,
            AllFieldsSet = (RSet | GSet | BSet | 0)};


        RGBABuilder<STATE | RSet>& SetR(int value)
        {
            static_assert(!(STATE & RSet), "property r should not be set yet");
            m_result->SetR(value);
            return castState<RSet>();
        }

        RGBABuilder<STATE | GSet>& SetG(int value)
        {
            static_assert(!(STATE & GSet), "property g should not be set yet");
            m_result->SetG(value);
            return castState<GSet>();
        }

        RGBABuilder<STATE | BSet>& SetB(int value)
        {
            static_assert(!(STATE & BSet), "property b should not be set yet");
            m_result->SetB(value);
            return castState<BSet>();
        }

        RGBABuilder<STATE>& SetA(double value)
        {
            m_result->SetA(value);
            return *this;
        }

        std::unique_ptr<RGBA> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RGBA;
        RGBABuilder() : m_result(new RGBA()) { }

        template<int STEP> RGBABuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RGBABuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::RGBA> m_result;
    };

    static RGBABuilder<0> Create()
    {
        return RGBABuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RGBA()
    {
          m_r = 0;
          m_g = 0;
          m_b = 0;
    }

    int m_r;
    int m_g;
    int m_b;
    std::optional<double> m_a;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse SetFileInputFiles(std::unique_ptr<protocol::Array<String>> in_files, std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace DOM
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_DOM_h)
