// components/metrics/public/mojom/call_stack_profile_collector.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_PUBLIC_MOJOM_CALL_STACK_PROFILE_COLLECTOR_MOJOM_H_
#define COMPONENTS_METRICS_PUBLIC_MOJOM_CALL_STACK_PROFILE_COLLECTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/metrics/public/mojom/call_stack_profile_collector.mojom-features.h"  // IWYU pragma: export
#include "components/metrics/public/mojom/call_stack_profile_collector.mojom-shared.h"  // IWYU pragma: export
#include "components/metrics/public/mojom/call_stack_profile_collector.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/proto_wrapper.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace metrics::mojom {

class CallStackProfileCollectorProxy;

template <typename ImplRefTraits>
class CallStackProfileCollectorStub;

class CallStackProfileCollectorRequestValidator;


class CallStackProfileCollector
    : public CallStackProfileCollectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CallStackProfileCollectorInterfaceBase;
  using Proxy_ = CallStackProfileCollectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = CallStackProfileCollectorStub<ImplRefTraits>;

  using RequestValidator_ = CallStackProfileCollectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCollectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Collect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CallStackProfileCollector() = default;

  
  virtual void Collect(::base::TimeTicks start_timestamp, ProfileType profile_type, SampledProfilePtr profile) = 0;
};



class  CallStackProfileCollectorProxy
    : public CallStackProfileCollector {
 public:
  using InterfaceType = CallStackProfileCollector;

  explicit CallStackProfileCollectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Collect(::base::TimeTicks start_timestamp, ProfileType profile_type, SampledProfilePtr profile) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CallStackProfileCollectorStubDispatch {
 public:
  static bool Accept(CallStackProfileCollector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CallStackProfileCollector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CallStackProfileCollector>>
class CallStackProfileCollectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CallStackProfileCollectorStub() = default;
  ~CallStackProfileCollectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CallStackProfileCollectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CallStackProfileCollectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CallStackProfileCollectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SampledProfile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SampledProfile, T>::value>;
  using DataView = SampledProfileDataView;
  using Data_ = internal::SampledProfile_Data;

  template <typename... Args>
  static SampledProfilePtr New(Args&&... args) {
    return SampledProfilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SampledProfilePtr From(const U& u) {
    return mojo::TypeConverter<SampledProfilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SampledProfile>::Convert(*this);
  }


  SampledProfile();

  explicit SampledProfile(
      ::mojo_base::ProtoWrapper contents);

SampledProfile(const SampledProfile&) = delete;
SampledProfile& operator=(const SampledProfile&) = delete;

  ~SampledProfile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SampledProfilePtr>
  SampledProfilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SampledProfile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SampledProfile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SampledProfile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SampledProfile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SampledProfile_UnserializedMessageContext<
            UserType, SampledProfile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SampledProfile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SampledProfile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SampledProfile_UnserializedMessageContext<
            UserType, SampledProfile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SampledProfile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::ProtoWrapper contents;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SampledProfile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SampledProfile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SampledProfile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SampledProfile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SampledProfilePtr SampledProfile::Clone() const {
  return New(
      mojo::Clone(contents)
  );
}

template <typename T, SampledProfile::EnableIfSame<T>*>
bool SampledProfile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->contents, other_struct.contents))
    return false;
  return true;
}

template <typename T, SampledProfile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.contents < rhs.contents)
    return true;
  if (rhs.contents < lhs.contents)
    return false;
  return false;
}


}  // metrics::mojom

namespace mojo {


template <>
struct  StructTraits<::metrics::mojom::SampledProfile::DataView,
                                         ::metrics::mojom::SampledProfilePtr> {
  static bool IsNull(const ::metrics::mojom::SampledProfilePtr& input) { return !input; }
  static void SetToNull(::metrics::mojom::SampledProfilePtr* output) { output->reset(); }

  static  decltype(::metrics::mojom::SampledProfile::contents)& contents(
       ::metrics::mojom::SampledProfilePtr& input) {
    return input->contents;
  }

  static bool Read(::metrics::mojom::SampledProfile::DataView input, ::metrics::mojom::SampledProfilePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_METRICS_PUBLIC_MOJOM_CALL_STACK_PROFILE_COLLECTOR_MOJOM_H_