// third_party/blink/public/mojom/prerender/prerender.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-params-data.h"
#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
PrerenderAttributes::PrerenderAttributes()
    : url(),
      rel_type(),
      referrer(),
      view_size() {}

PrerenderAttributes::PrerenderAttributes(
    const ::blink::KURL& url_in,
    PrerenderRelType rel_type_in,
    ::blink::mojom::blink::ReferrerPtr referrer_in,
    const ::gfx::Size& view_size_in)
    : url(std::move(url_in)),
      rel_type(std::move(rel_type_in)),
      referrer(std::move(referrer_in)),
      view_size(std::move(view_size_in)) {}

PrerenderAttributes::~PrerenderAttributes() = default;

void PrerenderAttributes::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::blink::KURL&>"));
  value->SetString("rel_type", base::trace_event::ValueToString(this->rel_type));
  if (this->referrer.is_null()) {
    value->SetString("referrer", "nullptr");
  } else {
    value->BeginDictionary("referrer");
    this->referrer->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("view_size", base::trace_event::ValueToString(this->view_size, "<value of type const ::gfx::Size&>"));
}

bool PrerenderAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PrerenderProcessorClient::Name_[] = "blink.mojom.PrerenderProcessorClient";

PrerenderProcessorClientProxy::PrerenderProcessorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrerenderProcessorClientProxy::OnPrerenderStart(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PrerenderProcessorClient::OnPrerenderStart");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessorClient_OnPrerenderStart_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PrerenderProcessorClient_OnPrerenderStart_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessorClient::Name_);
  message.set_method_name("OnPrerenderStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrerenderProcessorClientProxy::OnPrerenderStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PrerenderProcessorClient::OnPrerenderStopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessorClient_OnPrerenderStopLoading_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PrerenderProcessorClient_OnPrerenderStopLoading_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessorClient::Name_);
  message.set_method_name("OnPrerenderStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrerenderProcessorClientProxy::OnPrerenderDomContentLoaded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PrerenderProcessorClient::OnPrerenderDomContentLoaded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessorClient_OnPrerenderDomContentLoaded_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PrerenderProcessorClient_OnPrerenderDomContentLoaded_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessorClient::Name_);
  message.set_method_name("OnPrerenderDomContentLoaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrerenderProcessorClientProxy::OnPrerenderStop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PrerenderProcessorClient::OnPrerenderStop");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessorClient_OnPrerenderStop_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PrerenderProcessorClient_OnPrerenderStop_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessorClient::Name_);
  message.set_method_name("OnPrerenderStop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PrerenderProcessorClientStubDispatch::Accept(
    PrerenderProcessorClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPrerenderProcessorClient_OnPrerenderStart_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderStart",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderStart");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessorClient_OnPrerenderStart_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessorClient_OnPrerenderStart_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderProcessorClient_OnPrerenderStart_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrerenderStart();
      return true;
    }
    case internal::kPrerenderProcessorClient_OnPrerenderStopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderStopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderStopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessorClient_OnPrerenderStopLoading_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessorClient_OnPrerenderStopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderProcessorClient_OnPrerenderStopLoading_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessorClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrerenderStopLoading();
      return true;
    }
    case internal::kPrerenderProcessorClient_OnPrerenderDomContentLoaded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderDomContentLoaded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderDomContentLoaded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessorClient_OnPrerenderDomContentLoaded_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessorClient_OnPrerenderDomContentLoaded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderProcessorClient_OnPrerenderDomContentLoaded_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessorClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrerenderDomContentLoaded();
      return true;
    }
    case internal::kPrerenderProcessorClient_OnPrerenderStop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderStop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessorClient::OnPrerenderStop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessorClient_OnPrerenderStop_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessorClient_OnPrerenderStop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderProcessorClient_OnPrerenderStop_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessorClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrerenderStop();
      return true;
    }
  }
  return false;
}

// static
bool PrerenderProcessorClientStubDispatch::AcceptWithResponder(
    PrerenderProcessorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrerenderProcessorClient_OnPrerenderStart_Name: {
      break;
    }
    case internal::kPrerenderProcessorClient_OnPrerenderStopLoading_Name: {
      break;
    }
    case internal::kPrerenderProcessorClient_OnPrerenderDomContentLoaded_Name: {
      break;
    }
    case internal::kPrerenderProcessorClient_OnPrerenderStop_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPrerenderProcessorClientValidationInfo[] = {
    {&internal::PrerenderProcessorClient_OnPrerenderStart_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PrerenderProcessorClient_OnPrerenderStopLoading_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PrerenderProcessorClient_OnPrerenderDomContentLoaded_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PrerenderProcessorClient_OnPrerenderStop_Params_Data::Validate,
     nullptr /* no response */},
};

bool PrerenderProcessorClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PrerenderProcessorClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPrerenderProcessorClientValidationInfo);
}

const char PrerenderProcessor::Name_[] = "blink.mojom.PrerenderProcessor";

PrerenderProcessorProxy::PrerenderProcessorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrerenderProcessorProxy::Start(
    PrerenderAttributesPtr in_prerender_attribute, ::mojo::PendingRemote<PrerenderProcessorClient> in_prerender_processor_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PrerenderProcessor::Start", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_prerender_attribute.is_null()) {
        raw_value->SetString("prerender_attribute", "nullptr");
      } else {
        raw_value->BeginDictionary("prerender_attribute");
        in_prerender_attribute->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("prerender_processor_client", in_prerender_processor_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessor_Start_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PrerenderProcessor_Start_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->prerender_attribute)::BaseType::BufferWriter
      prerender_attribute_writer;
  mojo::internal::Serialize<::blink::mojom::PrerenderAttributesDataView>(
      in_prerender_attribute, buffer, &prerender_attribute_writer, &serialization_context);
  params->prerender_attribute.Set(
      prerender_attribute_writer.is_null() ? nullptr : prerender_attribute_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->prerender_attribute.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prerender_attribute in PrerenderProcessor.Start request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PrerenderProcessorClientInterfaceBase>>(
      in_prerender_processor_client, &params->prerender_processor_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->prerender_processor_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid prerender_processor_client in PrerenderProcessor.Start request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessor::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrerenderProcessorProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PrerenderProcessor::Cancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessor_Cancel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PrerenderProcessor_Cancel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessor::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PrerenderProcessorProxy::Abandon(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PrerenderProcessor::Abandon");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPrerenderProcessor_Abandon_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PrerenderProcessor_Abandon_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrerenderProcessor::Name_);
  message.set_method_name("Abandon");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PrerenderProcessorStubDispatch::Accept(
    PrerenderProcessor* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPrerenderProcessor_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessor::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessor::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessor_Start_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessor_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderAttributesPtr p_prerender_attribute{};
      ::mojo::PendingRemote<PrerenderProcessorClient> p_prerender_processor_client{};
      PrerenderProcessor_Start_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPrerenderAttribute(&p_prerender_attribute))
        success = false;
      if (success) {
        p_prerender_processor_client =
            input_data_view.TakePrerenderProcessorClient<decltype(p_prerender_processor_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_prerender_attribute), 
std::move(p_prerender_processor_client));
      return true;
    }
    case internal::kPrerenderProcessor_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessor::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessor::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessor_Cancel_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessor_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderProcessor_Cancel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel();
      return true;
    }
    case internal::kPrerenderProcessor_Abandon_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PrerenderProcessor::Abandon",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PrerenderProcessor::Abandon");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PrerenderProcessor_Abandon_Params_Data* params =
          reinterpret_cast<internal::PrerenderProcessor_Abandon_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PrerenderProcessor_Abandon_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrerenderProcessor::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abandon();
      return true;
    }
  }
  return false;
}

// static
bool PrerenderProcessorStubDispatch::AcceptWithResponder(
    PrerenderProcessor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPrerenderProcessor_Start_Name: {
      break;
    }
    case internal::kPrerenderProcessor_Cancel_Name: {
      break;
    }
    case internal::kPrerenderProcessor_Abandon_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPrerenderProcessorValidationInfo[] = {
    {&internal::PrerenderProcessor_Start_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PrerenderProcessor_Cancel_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PrerenderProcessor_Abandon_Params_Data::Validate,
     nullptr /* no response */},
};

bool PrerenderProcessorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PrerenderProcessor::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPrerenderProcessorValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PrerenderAttributes::DataView, ::blink::mojom::blink::PrerenderAttributesPtr>::Read(
    ::blink::mojom::blink::PrerenderAttributes::DataView input,
    ::blink::mojom::blink::PrerenderAttributesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PrerenderAttributesPtr result(::blink::mojom::blink::PrerenderAttributes::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadRelType(&result->rel_type))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadViewSize(&result->view_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif