// third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class CommonNetworkInfoDataView;

class RedirectInfoDataView;

class ResourceLoadInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CommonNetworkInfoDataView> {
  using Data = ::blink::mojom::internal::CommonNetworkInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RedirectInfoDataView> {
  using Data = ::blink::mojom::internal::RedirectInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ResourceLoadInfoDataView> {
  using Data = ::blink::mojom::internal::ResourceLoadInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class ResourceType : int32_t {
  
  kMainFrame = 0,
  
  kSubFrame = 1,
  
  kStylesheet = 2,
  
  kScript = 3,
  
  kImage = 4,
  
  kFontResource = 5,
  
  kSubResource = 6,
  
  kObject = 7,
  
  kMedia = 8,
  
  kWorker = 9,
  
  kSharedWorker = 10,
  
  kPrefetch = 11,
  
  kFavicon = 12,
  
  kXhr = 13,
  
  kPing = 14,
  
  kServiceWorker = 15,
  
  kCspReport = 16,
  
  kPluginResource = 17,
  
  kNavigationPreloadMainFrame = 19,
  
  kNavigationPreloadSubFrame = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ResourceType value);
inline bool IsKnownEnumValue(ResourceType value) {
  return internal::ResourceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CommonNetworkInfoDataView {
 public:
  CommonNetworkInfoDataView() {}

  CommonNetworkInfoDataView(
      internal::CommonNetworkInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool network_accessed() const {
    return data_->network_accessed;
  }
  bool always_access_network() const {
    return data_->always_access_network;
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRemoteEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::IPEndPointDataView, UserType>(),
    "Attempting to read the optional `remote_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemoteEndpoint` instead "
    "of `ReadRemoteEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, context_);
  }
 private:
  internal::CommonNetworkInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RedirectInfoDataView {
 public:
  RedirectInfoDataView() {}

  RedirectInfoDataView(
      internal::RedirectInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginOfNewUrlDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginOfNewUrl(UserType* output) {
    
    auto* pointer = data_->origin_of_new_url.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetNetworkInfoDataView(
      CommonNetworkInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNetworkInfo(UserType* output) {
    
    auto* pointer = data_->network_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonNetworkInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::RedirectInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ResourceLoadInfoDataView {
 public:
  ResourceLoadInfoDataView() {}

  ResourceLoadInfoDataView(
      internal::ResourceLoadInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int64_t request_id() const {
    return data_->request_id;
  }
  inline void GetFinalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFinalUrl(UserType* output) {
    
    auto* pointer = data_->final_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetReferrerDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetOriginalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestDestination(UserType* output) const {
    auto data_value = data_->request_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }

  ::network::mojom::RequestDestination request_destination() const {
    return static_cast<::network::mojom::RequestDestination>(data_->request_destination);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestPriority(UserType* output) const {
    auto data_value = data_->request_priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }

  ::network::mojom::RequestPriority request_priority() const {
    return static_cast<::network::mojom::RequestPriority>(data_->request_priority);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool was_cached() const {
    return data_->was_cached;
  }
  inline void GetNetworkInfoDataView(
      CommonNetworkInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNetworkInfo(UserType* output) {
    
    auto* pointer = data_->network_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonNetworkInfoDataView>(
        pointer, output, context_);
  }
  int32_t net_error() const {
    return data_->net_error;
  }
  inline void GetLoadTimingInfoDataView(
      ::network::mojom::LoadTimingInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLoadTimingInfo(UserType* output) {
    
    auto* pointer = data_->load_timing_info.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoDataView>(
        pointer, output, context_);
  }
  int64_t raw_body_bytes() const {
    return data_->raw_body_bytes;
  }
  int64_t total_received_bytes() const {
    return data_->total_received_bytes;
  }
  inline void GetRedirectInfoChainDataView(
      mojo::ArrayDataView<RedirectInfoDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirectInfoChain(UserType* output) {
    
    auto* pointer = data_->redirect_info_chain.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::RedirectInfoDataView>>(
        pointer, output, context_);
  }
 private:
  internal::ResourceLoadInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::ResourceType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ResourceType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::ResourceType, ::blink::mojom::ResourceType> {
  static ::blink::mojom::ResourceType ToMojom(::blink::mojom::ResourceType input) { return input; }
  static bool FromMojom(::blink::mojom::ResourceType input, ::blink::mojom::ResourceType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ResourceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ResourceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ResourceType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CommonNetworkInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CommonNetworkInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::CommonNetworkInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->network_accessed = Traits::network_accessed(input);
    (*output)->always_access_network = Traits::always_access_network(input);
    decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
    typename decltype((*output)->remote_endpoint)::BaseType::BufferWriter
        remote_endpoint_writer;
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
        in_remote_endpoint, buffer, &remote_endpoint_writer, context);
    (*output)->remote_endpoint.Set(
        remote_endpoint_writer.is_null() ? nullptr : remote_endpoint_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::CommonNetworkInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CommonNetworkInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RedirectInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RedirectInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::RedirectInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin_of_new_url(input)) in_origin_of_new_url = Traits::origin_of_new_url(input);
    typename decltype((*output)->origin_of_new_url)::BaseType::BufferWriter
        origin_of_new_url_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin_of_new_url, buffer, &origin_of_new_url_writer, context);
    (*output)->origin_of_new_url.Set(
        origin_of_new_url_writer.is_null() ? nullptr : origin_of_new_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin_of_new_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin_of_new_url in RedirectInfo struct");
    decltype(Traits::network_info(input)) in_network_info = Traits::network_info(input);
    typename decltype((*output)->network_info)::BaseType::BufferWriter
        network_info_writer;
    mojo::internal::Serialize<::blink::mojom::CommonNetworkInfoDataView>(
        in_network_info, buffer, &network_info_writer, context);
    (*output)->network_info.Set(
        network_info_writer.is_null() ? nullptr : network_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->network_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null network_info in RedirectInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::RedirectInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RedirectInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ResourceLoadInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ResourceLoadInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ResourceLoadInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->request_id = Traits::request_id(input);
    decltype(Traits::final_url(input)) in_final_url = Traits::final_url(input);
    typename decltype((*output)->final_url)::BaseType::BufferWriter
        final_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_final_url, buffer, &final_url_writer, context);
    (*output)->final_url.Set(
        final_url_writer.is_null() ? nullptr : final_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->final_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null final_url in ResourceLoadInfo struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in ResourceLoadInfo struct");
    decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
    typename decltype((*output)->original_url)::BaseType::BufferWriter
        original_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_original_url, buffer, &original_url_writer, context);
    (*output)->original_url.Set(
        original_url_writer.is_null() ? nullptr : original_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->original_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_url in ResourceLoadInfo struct");
    decltype(Traits::method(input)) in_method = Traits::method(input);
    typename decltype((*output)->method)::BaseType::BufferWriter
        method_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, buffer, &method_writer, context);
    (*output)->method.Set(
        method_writer.is_null() ? nullptr : method_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in ResourceLoadInfo struct");
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::request_destination(input), &(*output)->request_destination);
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::request_priority(input), &(*output)->request_priority);
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    typename decltype((*output)->mime_type)::BaseType::BufferWriter
        mime_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, buffer, &mime_type_writer, context);
    (*output)->mime_type.Set(
        mime_type_writer.is_null() ? nullptr : mime_type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mime_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in ResourceLoadInfo struct");
    (*output)->was_cached = Traits::was_cached(input);
    decltype(Traits::network_info(input)) in_network_info = Traits::network_info(input);
    typename decltype((*output)->network_info)::BaseType::BufferWriter
        network_info_writer;
    mojo::internal::Serialize<::blink::mojom::CommonNetworkInfoDataView>(
        in_network_info, buffer, &network_info_writer, context);
    (*output)->network_info.Set(
        network_info_writer.is_null() ? nullptr : network_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->network_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null network_info in ResourceLoadInfo struct");
    (*output)->net_error = Traits::net_error(input);
    decltype(Traits::load_timing_info(input)) in_load_timing_info = Traits::load_timing_info(input);
    typename decltype((*output)->load_timing_info)::BaseType::BufferWriter
        load_timing_info_writer;
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
        in_load_timing_info, buffer, &load_timing_info_writer, context);
    (*output)->load_timing_info.Set(
        load_timing_info_writer.is_null() ? nullptr : load_timing_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->load_timing_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null load_timing_info in ResourceLoadInfo struct");
    (*output)->raw_body_bytes = Traits::raw_body_bytes(input);
    (*output)->total_received_bytes = Traits::total_received_bytes(input);
    decltype(Traits::redirect_info_chain(input)) in_redirect_info_chain = Traits::redirect_info_chain(input);
    typename decltype((*output)->redirect_info_chain)::BaseType::BufferWriter
        redirect_info_chain_writer;
    const mojo::internal::ContainerValidateParams redirect_info_chain_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::RedirectInfoDataView>>(
        in_redirect_info_chain, buffer, &redirect_info_chain_writer, &redirect_info_chain_validate_params,
        context);
    (*output)->redirect_info_chain.Set(
        redirect_info_chain_writer.is_null() ? nullptr : redirect_info_chain_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->redirect_info_chain.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_info_chain in ResourceLoadInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ResourceLoadInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ResourceLoadInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void CommonNetworkInfoDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, context_);
}


inline void RedirectInfoDataView::GetOriginOfNewUrlDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin_of_new_url.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void RedirectInfoDataView::GetNetworkInfoDataView(
    CommonNetworkInfoDataView* output) {
  auto pointer = data_->network_info.Get();
  *output = CommonNetworkInfoDataView(pointer, context_);
}


inline void ResourceLoadInfoDataView::GetFinalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->final_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void ResourceLoadInfoDataView::GetReferrerDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void ResourceLoadInfoDataView::GetOriginalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->original_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void ResourceLoadInfoDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ResourceLoadInfoDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ResourceLoadInfoDataView::GetNetworkInfoDataView(
    CommonNetworkInfoDataView* output) {
  auto pointer = data_->network_info.Get();
  *output = CommonNetworkInfoDataView(pointer, context_);
}
inline void ResourceLoadInfoDataView::GetLoadTimingInfoDataView(
    ::network::mojom::LoadTimingInfoDataView* output) {
  auto pointer = data_->load_timing_info.Get();
  *output = ::network::mojom::LoadTimingInfoDataView(pointer, context_);
}
inline void ResourceLoadInfoDataView::GetRedirectInfoChainDataView(
    mojo::ArrayDataView<RedirectInfoDataView>* output) {
  auto pointer = data_->redirect_info_chain.Get();
  *output = mojo::ArrayDataView<RedirectInfoDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_H_