// cc/mojom/render_frame_metadata.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_INTERNAL_H_
#define CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/selection.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/vertical_scroll_direction.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace cc {
namespace mojom {
namespace internal {
class RenderFrameMetadata_Data;

#pragma pack(push, 1)
class  RenderFrameMetadata_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderFrameMetadata_Data));
      new (data()) RenderFrameMetadata_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderFrameMetadata_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderFrameMetadata_Data>(index_);
    }
    RenderFrameMetadata_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t root_background_color;
  uint8_t is_scroll_offset_at_top : 1;
  uint8_t is_mobile_optimized : 1;
  uint8_t has_delegated_ink_metadata : 1;
  uint8_t root_overflow_y_hidden : 1;
  uint8_t has_transparent_background : 1;
  uint8_t pad5_[3];
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> root_scroll_offset;
  mojo::internal::Pointer<::viz::mojom::internal::Selection_Data> selection;
  float device_scale_factor;
  float page_scale_factor;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> viewport_size_in_pixels;
  mojo::internal::Pointer<::viz::mojom::internal::LocalSurfaceId_Data> local_surface_id;
  float external_page_scale_factor;
  float top_controls_height;
  float top_controls_shown_ratio;
  int32_t new_vertical_scroll_direction;
  float bottom_controls_height;
  float bottom_controls_shown_ratio;
  float top_controls_min_height_offset;
  float bottom_controls_min_height_offset;
  float min_page_scale_factor;
  float max_page_scale_factor;
  mojo::internal::Pointer<::gfx::mojom::internal::SizeF_Data> scrollable_viewport_size;
  mojo::internal::Pointer<::gfx::mojom::internal::SizeF_Data> root_layer_size;

 private:
  RenderFrameMetadata_Data();
  ~RenderFrameMetadata_Data() = delete;
};
static_assert(sizeof(RenderFrameMetadata_Data) == 112,
              "Bad sizeof(RenderFrameMetadata_Data)");
// Used by RenderFrameMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RenderFrameMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RenderFrameMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RenderFrameMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    RenderFrameMetadata_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RenderFrameMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace cc

#endif  // CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_INTERNAL_H_