// python wrapper for vtkPVTransferFunction2DBox
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVTransferFunction2DBox.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVTransferFunction2DBox(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVTransferFunction2DBox_ClassNew(); }


static PyObject *
PyvtkPVTransferFunction2DBox_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVTransferFunction2DBox::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVTransferFunction2DBox::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVTransferFunction2DBox *tempr = vtkPVTransferFunction2DBox::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVTransferFunction2DBox *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVTransferFunction2DBox::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVTransferFunction2DBox::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVTransferFunction2DBox::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_GetBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const vtkRectd *tempr = (ap.IsBound() ?
      &op->GetBox() :
      &op->vtkPVTransferFunction2DBox::GetBox());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkRectd");
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_SetBox_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetBox(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVTransferFunction2DBox::SetBox(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2DBox_SetBox_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  vtkRectd *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkRectd"))
  {
    if (ap.IsBound())
    {
      op->SetBox(*temp0);
    }
    else
    {
      op->vtkPVTransferFunction2DBox::SetBox(*temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkPVTransferFunction2DBox_SetBox(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkPVTransferFunction2DBox_SetBox_s1(self, args);
    case 1:
      return PyvtkPVTransferFunction2DBox_SetBox_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBox");
  return nullptr;
}


static PyObject *
PyvtkPVTransferFunction2DBox_SetColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVTransferFunction2DBox::SetColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2DBox_SetColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetColor(temp0);
    }
    else
    {
      op->vtkPVTransferFunction2DBox::SetColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2DBox_SetColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkPVTransferFunction2DBox_SetColor_s1(self, args);
    case 1:
      return PyvtkPVTransferFunction2DBox_SetColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetColor");
  return nullptr;
}


static PyObject *
PyvtkPVTransferFunction2DBox_GetColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  size_t sizer = 4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetColor() :
      op->vtkPVTransferFunction2DBox::GetColor());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_GetTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageData *tempr = (ap.IsBound() ?
      op->GetTexture() :
      op->vtkPVTransferFunction2DBox::GetTexture());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_SetTextureSize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTextureSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTextureSize(temp0, temp1);
    }
    else
    {
      op->vtkPVTransferFunction2DBox::SetTextureSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2DBox_SetTextureSize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTextureSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTextureSize(temp0);
    }
    else
    {
      op->vtkPVTransferFunction2DBox::SetTextureSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2DBox_SetTextureSize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVTransferFunction2DBox_SetTextureSize_s1(self, args);
    case 1:
      return PyvtkPVTransferFunction2DBox_SetTextureSize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTextureSize");
  return nullptr;
}


static PyObject *
PyvtkPVTransferFunction2DBox_GetTextureSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTextureSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTextureSize() :
      op->vtkPVTransferFunction2DBox::GetTextureSize());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_SetGaussianSigmaFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGaussianSigmaFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGaussianSigmaFactor(temp0);
    }
    else
    {
      op->vtkPVTransferFunction2DBox::SetGaussianSigmaFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2DBox_GetGaussianSigmaFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGaussianSigmaFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2DBox *op = static_cast<vtkPVTransferFunction2DBox *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetGaussianSigmaFactor() :
      op->vtkPVTransferFunction2DBox::GetGaussianSigmaFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVTransferFunction2DBox_Methods[] = {
  {"IsTypeOf", PyvtkPVTransferFunction2DBox_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVTransferFunction2DBox_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVTransferFunction2DBox_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVTransferFunction2DBox\nC++: static vtkPVTransferFunction2DBox *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVTransferFunction2DBox_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVTransferFunction2DBox\nC++: vtkPVTransferFunction2DBox *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVTransferFunction2DBox_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVTransferFunction2DBox_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetBox", PyvtkPVTransferFunction2DBox_GetBox, METH_VARARGS,
   "GetBox(self) -> vtkRectd\nC++: virtual const vtkRectd &GetBox()\n\nReturns the current box as [x0, y0, width, height].\n"},
  {"SetBox", PyvtkPVTransferFunction2DBox_SetBox, METH_VARARGS,
   "SetBox(self, x:float, y:float, width:float, height:float) -> None\nC++: virtual void SetBox(double x, double y, double width,\n    double height)\nSetBox(self, b:vtkRectd) -> None\nC++: virtual void SetBox(const vtkRectd &b)\n\nSet position and width with respect to origin i.e. bottom left\ncorner.\n"},
  {"SetColor", PyvtkPVTransferFunction2DBox_SetColor, METH_VARARGS,
   "SetColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float)\n     -> None\nC++: virtual void SetColor(double _arg1, double _arg2,\n    double _arg3, double _arg4)\nSetColor(self, _arg:(float, float, float, float)) -> None\nC++: virtual void SetColor(const double _arg[4])\n\nSet/Get the color (r,g,b,a) to be used for this box. Defaults to\nopaque white (1, 1, 1, 1).\n"},
  {"GetColor", PyvtkPVTransferFunction2DBox_GetColor, METH_VARARGS,
   "GetColor(self) -> (float, float, float, float)\nC++: virtual double *GetColor()\n\n"},
  {"GetTexture", PyvtkPVTransferFunction2DBox_GetTexture, METH_VARARGS,
   "GetTexture(self) -> vtkImageData\nC++: virtual vtkImageData *GetTexture()\n\nGet the texture for this box item. The texture will be computed,\nif needed.\n"},
  {"SetTextureSize", PyvtkPVTransferFunction2DBox_SetTextureSize, METH_VARARGS,
   "SetTextureSize(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTextureSize(int _arg1, int _arg2)\nSetTextureSize(self, _arg:(int, int)) -> None\nC++: void SetTextureSize(const int _arg[2])\n\nSet/Get the texture size of the box. Defaults to (128, 128).\n"},
  {"GetTextureSize", PyvtkPVTransferFunction2DBox_GetTextureSize, METH_VARARGS,
   "GetTextureSize(self) -> (int, int)\nC++: virtual int *GetTextureSize()\n\n"},
  {"SetGaussianSigmaFactor", PyvtkPVTransferFunction2DBox_SetGaussianSigmaFactor, METH_VARARGS,
   "SetGaussianSigmaFactor(self, _arg:float) -> None\nC++: virtual void SetGaussianSigmaFactor(double _arg)\n\nSet/Get the standard deviation for the gaussian function.\nDefaults to 30.\n"},
  {"GetGaussianSigmaFactor", PyvtkPVTransferFunction2DBox_GetGaussianSigmaFactor, METH_VARARGS,
   "GetGaussianSigmaFactor(self) -> float\nC++: virtual double GetGaussianSigmaFactor()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVTransferFunction2DBox_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("box"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransferFunction2DBox_SetBox(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransferFunction2DBox_SetBox(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("box"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransferFunction2DBox_SetBox(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransferFunction2DBox_SetBox(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2DBox_GetColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransferFunction2DBox_SetColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransferFunction2DBox_SetColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColor/SetColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("texture_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2DBox_GetTextureSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransferFunction2DBox_SetTextureSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransferFunction2DBox_SetTextureSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTextureSize/SetTextureSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gaussian_sigma_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2DBox_GetGaussianSigmaFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransferFunction2DBox_SetGaussianSigmaFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransferFunction2DBox_SetGaussianSigmaFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGaussianSigmaFactor/SetGaussianSigmaFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("box"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2DBox_GetBox(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("texture"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2DBox_GetTexture(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTexture\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVTransferFunction2DBox_Doc =
  "vtkPVTransferFunction2DBox - Shape that represents an individual\ncontrol node in a 2D transfer function\n\n"
  "Superclass: vtkObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVTransferFunction2DBox_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVTransferFunction2DBox", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVTransferFunction2DBox_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVTransferFunction2DBox_StaticNew()
{
  return vtkPVTransferFunction2DBox::New();
}

PyObject *PyvtkPVTransferFunction2DBox_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVTransferFunction2DBox_Type, PyvtkPVTransferFunction2DBox_Methods,
    "vtkPVTransferFunction2DBox",
 &PyvtkPVTransferFunction2DBox_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVTransferFunction2DBox_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVTransferFunction2DBox(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVTransferFunction2DBox_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVTransferFunction2DBox", o) != 0)
  {
    Py_DECREF(o);
  }

}

