// python wrapper for vtkPVPluginLoader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVPluginLoader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPluginLoader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPluginLoader_ClassNew(); }


static PyObject *
PyvtkPVPluginLoader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPluginLoader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVPluginLoader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVPluginLoader *tempr = vtkPVPluginLoader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVPluginLoader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVPluginLoader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVPluginLoader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVPluginLoader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadPluginByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadPluginByName(temp0, temp1) :
      op->vtkPVPluginLoader::LoadPluginByName(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadPlugin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPlugin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadPlugin(temp0) :
      op->vtkPVPluginLoader::LoadPlugin(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadPluginSilently(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginSilently");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadPluginSilently(temp0) :
      op->vtkPVPluginLoader::LoadPluginSilently(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadDelayedLoadPlugin_s1(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method LoadDelayedLoadPlugin."
    " (" "Use the overload with versions and description instead" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(self, args, "LoadDelayedLoadPlugin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  std::string temp0;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  std::string temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadDelayedLoadPlugin(temp0, temp1, temp2) :
      op->vtkPVPluginLoader::LoadDelayedLoadPlugin(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVPluginLoader_LoadDelayedLoadPlugin_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadDelayedLoadPlugin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  std::string temp0;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  std::string temp2;
  std::string temp3;
  std::string temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadDelayedLoadPlugin(temp0, temp1, temp2, temp3, temp4) :
      op->vtkPVPluginLoader::LoadDelayedLoadPlugin(temp0, temp1, temp2, temp3, temp4));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVPluginLoader_LoadDelayedLoadPlugin(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVPluginLoader_LoadDelayedLoadPlugin_s1(self, args);
    case 5:
      return PyvtkPVPluginLoader_LoadDelayedLoadPlugin_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "LoadDelayedLoadPlugin");
  return nullptr;
}


static PyObject *
PyvtkPVPluginLoader_LoadPluginConfigurationXMLFromString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXMLFromString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXMLFromString(temp0);
    }
    else
    {
      op->vtkPVPluginLoader::LoadPluginConfigurationXMLFromString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadPluginConfigurationXML(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXML(temp0);
    }
    else
    {
      op->vtkPVPluginLoader::LoadPluginConfigurationXML(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadPluginsFromPluginSearchPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginsFromPluginSearchPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginsFromPluginSearchPath();
    }
    else
    {
      op->vtkPVPluginLoader::LoadPluginsFromPluginSearchPath();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadPluginsFromPluginConfigFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginsFromPluginConfigFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginsFromPluginConfigFile();
    }
    else
    {
      op->vtkPVPluginLoader::LoadPluginsFromPluginConfigFile();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_LoadPluginsFromPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginsFromPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginsFromPath(temp0);
    }
    else
    {
      op->vtkPVPluginLoader::LoadPluginsFromPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkPVPluginLoader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetPluginName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPluginName() :
      op->vtkPVPluginLoader::GetPluginName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetPluginVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPluginVersion() :
      op->vtkPVPluginLoader::GetPluginVersion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetErrorString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetErrorString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetErrorString() :
      op->vtkPVPluginLoader::GetErrorString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetSearchPaths(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSearchPaths");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSearchPaths() :
      op->vtkPVPluginLoader::GetSearchPaths());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_GetLoaded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLoaded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPluginLoader *op = static_cast<vtkPVPluginLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLoaded() :
      op->vtkPVPluginLoader::GetLoaded());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_UnregisterLoadPluginCallback(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "UnregisterLoadPluginCallback");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVPluginLoader::UnregisterLoadPluginCallback(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPluginLoader_PluginLibraryUnloaded(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "PluginLibraryUnloaded");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVPluginLoader::PluginLibraryUnloaded(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPluginLoader_Methods[] = {
  {"IsTypeOf", PyvtkPVPluginLoader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVPluginLoader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVPluginLoader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVPluginLoader\nC++: static vtkPVPluginLoader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVPluginLoader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVPluginLoader\nC++: vtkPVPluginLoader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVPluginLoader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVPluginLoader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"LoadPluginByName", PyvtkPVPluginLoader_LoadPluginByName, METH_VARARGS,
   "LoadPluginByName(self, name:str, acceptDelayed:bool=True) -> bool\nC++: bool LoadPluginByName(const char *name,\n    bool acceptDelayed=true)\n\nTries to the load the plugin by name using tracked plugins.\n"},
  {"LoadPlugin", PyvtkPVPluginLoader_LoadPlugin, METH_VARARGS,
   "LoadPlugin(self, filename:str) -> bool\nC++: bool LoadPlugin(const char *filename)\n\nTries to the load the plugin given the path to the plugin file.\n"},
  {"LoadPluginSilently", PyvtkPVPluginLoader_LoadPluginSilently, METH_VARARGS,
   "LoadPluginSilently(self, filename:str) -> bool\nC++: bool LoadPluginSilently(const char *filename)\n\n"},
  {"LoadDelayedLoadPlugin", PyvtkPVPluginLoader_LoadDelayedLoadPlugin, METH_VARARGS,
   "LoadDelayedLoadPlugin(self, name:str, xmls:(str, ...),\n    filename:str) -> bool\nC++: bool LoadDelayedLoadPlugin(const std::string &name,\n    const std::vector<std::string> &xmls,\n    const std::string &filename)\nLoadDelayedLoadPlugin(self, name:str, xmls:(str, ...),\n    filename:str, version:str, description:str) -> bool\nC++: bool LoadDelayedLoadPlugin(const std::string &name,\n    const std::vector<std::string> &xmls,\n    const std::string &filename, const std::string &version,\n    const std::string &description)\n\nLoad a delayed load plugin with provided name, XMLs and an actual\nplugin filename The actual loading will take place the first time\na VTK object for a XML proxy needs to be created.\n"},
  {"LoadPluginConfigurationXMLFromString", PyvtkPVPluginLoader_LoadPluginConfigurationXMLFromString, METH_VARARGS,
   "LoadPluginConfigurationXMLFromString(self, xmlcontents:str)\n    -> None\nC++: void LoadPluginConfigurationXMLFromString(\n    const char *xmlcontents)\n\nSimply forwards the call to vtkPVPluginTracker to load\nconfiguration xml.\n"},
  {"LoadPluginConfigurationXML", PyvtkPVPluginLoader_LoadPluginConfigurationXML, METH_VARARGS,
   "LoadPluginConfigurationXML(self, configurationFile:str) -> None\nC++: void LoadPluginConfigurationXML(\n    const char *configurationFile)\n\n"},
  {"LoadPluginsFromPluginSearchPath", PyvtkPVPluginLoader_LoadPluginsFromPluginSearchPath, METH_VARARGS,
   "LoadPluginsFromPluginSearchPath(self) -> None\nC++: void LoadPluginsFromPluginSearchPath()\n\nLoads all plugins under the directories mentioned in the\nSearchPaths.\n"},
  {"LoadPluginsFromPluginConfigFile", PyvtkPVPluginLoader_LoadPluginsFromPluginConfigFile, METH_VARARGS,
   "LoadPluginsFromPluginConfigFile(self) -> None\nC++: void LoadPluginsFromPluginConfigFile()\n\nUse PV_PLUGIN_CONFILE_FILE xml file to load specified plugins It\ncan contain path to multiples xml pluginc config files sperated\nby env separator. It allow user to fine pick which plugins to\nload, instead of using PV_PLUGIN_PATH the format a xml plugin\nfile should be the following :\n\n{.xml}\n<?xml version=\"1.0\"?>\n\n\n<Plugin name=\"MyPlugin\"\nfilename=\"absolute/path/to/libMyPlugin.so\"/>\n...\n"},
  {"LoadPluginsFromPath", PyvtkPVPluginLoader_LoadPluginsFromPath, METH_VARARGS,
   "LoadPluginsFromPath(self, path:str) -> None\nC++: void LoadPluginsFromPath(const char *path)\n\nLoads all plugin libraries at a path.\n"},
  {"GetFileName", PyvtkPVPluginLoader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\nReturns the full filename for the plugin attempted to load most\nrecently using LoadPlugin().\n"},
  {"GetPluginName", PyvtkPVPluginLoader_GetPluginName, METH_VARARGS,
   "GetPluginName(self) -> str\nC++: virtual char *GetPluginName()\n\nGet the plugin name. This returns a valid name only after the\nplugin has been loaded.\n"},
  {"GetPluginVersion", PyvtkPVPluginLoader_GetPluginVersion, METH_VARARGS,
   "GetPluginVersion(self) -> str\nC++: virtual char *GetPluginVersion()\n\nGet the plugin version string. This returns a valid version\nstring only after the plugin has been loaded.\n"},
  {"GetErrorString", PyvtkPVPluginLoader_GetErrorString, METH_VARARGS,
   "GetErrorString(self) -> str\nC++: virtual char *GetErrorString()\n\nGet the error string if the plugin failed to load. Returns\nnullptr if the plugin was loaded successfully.\n"},
  {"GetSearchPaths", PyvtkPVPluginLoader_GetSearchPaths, METH_VARARGS,
   "GetSearchPaths(self) -> str\nC++: virtual char *GetSearchPaths()\n\nGet a string of standard search paths (path1;path2;path3) search\npaths are based on PV_PLUGIN_PATH, plugin dir relative to\nexecutable.\n"},
  {"GetLoaded", PyvtkPVPluginLoader_GetLoaded, METH_VARARGS,
   "GetLoaded(self) -> bool\nC++: virtual bool GetLoaded()\n\nReturns the status of most recent LoadPlugin call.\n"},
  {"UnregisterLoadPluginCallback", PyvtkPVPluginLoader_UnregisterLoadPluginCallback, METH_VARARGS,
   "UnregisterLoadPluginCallback(id:int) -> None\nC++: static void UnregisterLoadPluginCallback(int id)\n\n"},
  {"PluginLibraryUnloaded", PyvtkPVPluginLoader_PluginLibraryUnloaded, METH_VARARGS,
   "PluginLibraryUnloaded(pluginname:str) -> None\nC++: static void PluginLibraryUnloaded(const char *pluginname)\n\nInternal method used in pqParaViewPlugin.cxx.in to tell the\nvtkPVPluginLoader that a library was unloaded so it doesn't try\nto unload it again.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPluginLoader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("error_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginLoader_GetErrorString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetErrorString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugin_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginLoader_GetPluginName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPluginName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugin_version"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginLoader_GetPluginVersion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPluginVersion\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginLoader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("search_paths"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginLoader_GetSearchPaths(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSearchPaths\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("loaded"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPluginLoader_GetLoaded(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLoaded\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVPluginLoader_Doc =
  "vtkPVPluginLoader - Used to load ParaView plugins.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVPluginLoader can be used to load plugins for ParaView.\n"
  "vtkPVPluginLoader loads the plugin on the local process.\n\n"
  "vtkPVPluginLoader logs plugin related messages using at\n"
  "`PARAVIEW_LOG_PLUGIN_VERBOSITY` level. See\n"
  "`vtkPVLogger::SetPluginVerbosity` for information on using\n"
  "environment variables to override or elevate the verbosity level.\n\n"
  "This class only needed when loading plugins from shared libraries\n"
  "dynamically. For statically importing plugins, one directly uses\n"
  "PV_PLUGIN_IMPORT() macro defined in vtkPVPlugin.h.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPluginLoader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVPluginLoader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVPluginLoader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVPluginLoader_StaticNew()
{
  return vtkPVPluginLoader::New();
}

PyObject *PyvtkPVPluginLoader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVPluginLoader_Type, PyvtkPVPluginLoader_Methods,
    "vtkPVPluginLoader",
 &PyvtkPVPluginLoader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVPluginLoader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

static PyMethodDef PyvtkPVPluginLoaderCleanerInitializer_Methods[] = {
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPluginLoaderCleanerInitializer_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVPluginLoaderCleanerInitializer");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVPluginLoaderCleanerInitializer *op = new vtkPVPluginLoaderCleanerInitializer();

    result = PyVTKSpecialObject_New("vtkPVPluginLoaderCleanerInitializer", op);
  }

  return result;
}

static PyObject *
PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVPluginLoaderCleanerInitializer");

  vtkPVPluginLoaderCleanerInitializer *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkPVPluginLoaderCleanerInitializer"))
  {
    vtkPVPluginLoaderCleanerInitializer *op = new vtkPVPluginLoaderCleanerInitializer(*temp0);

    result = PyVTKSpecialObject_New("vtkPVPluginLoaderCleanerInitializer", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer_Methods[] = {
  {"vtkPVPluginLoaderCleanerInitializer", PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer_s2, METH_VARARGS,
   "@W vtkPVPluginLoaderCleanerInitializer"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer_s1(self, args);
    case 1:
      return PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkPVPluginLoaderCleanerInitializer");
  return nullptr;
}


static const char *PyvtkPVPluginLoaderCleanerInitializer_Doc =

  "vtkPVPluginLoaderCleanerInitializer()\n    -> vtkPVPluginLoaderCleanerInitializer\nC++: vtkPVPluginLoaderCleanerInitializer()\nvtkPVPluginLoaderCleanerInitializer(\n    __a:vtkPVPluginLoaderCleanerInitializer)\n    -> vtkPVPluginLoaderCleanerInitializer\nC++: vtkPVPluginLoaderCleanerInitializer(\n    const &vtkPVPluginLoaderCleanerInitializer)\n""\n"
  "vtkPVPluginLoaderCleanerInitializer - no description provided.\n\n"
;

static PyObject *
PyvtkPVPluginLoaderCleanerInitializer_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer(nullptr, args);
}

static void PyvtkPVPluginLoaderCleanerInitializer_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVPluginLoaderCleanerInitializer *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVPluginLoaderCleanerInitializer_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPluginLoaderCleanerInitializer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVPluginLoaderCleanerInitializer", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVPluginLoaderCleanerInitializer_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVPluginLoaderCleanerInitializer_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVPluginLoaderCleanerInitializer_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVPluginLoaderCleanerInitializer_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkPVPluginLoaderCleanerInitializer_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkPVPluginLoaderCleanerInitializer(*static_cast<const vtkPVPluginLoaderCleanerInitializer*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkPVPluginLoaderCleanerInitializer_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPluginLoaderCleanerInitializer_TypeNew(); }
#define DECLARED_PyvtkPVPluginLoaderCleanerInitializer_TypeNew
#endif

PyObject *PyvtkPVPluginLoaderCleanerInitializer_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVPluginLoaderCleanerInitializer_Type,
    PyvtkPVPluginLoaderCleanerInitializer_Methods,
    PyvtkPVPluginLoaderCleanerInitializer_GetSets,
    PyvtkPVPluginLoaderCleanerInitializer_vtkPVPluginLoaderCleanerInitializer_Methods,
    &PyvtkPVPluginLoaderCleanerInitializer_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPluginLoader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPluginLoader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPluginLoader", o) != 0)
  {
    Py_DECREF(o);
  }

  o = PyvtkPVPluginLoaderCleanerInitializer_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPluginLoaderCleanerInitializer", o) != 0)
  {
    Py_DECREF(o);
  }

}

