use gio::{ActionEntry, prelude::*};

use crate::article_list::ArticleList;
use crate::article_view::ArticleView;
use crate::content_page::{ArticleListColumn, ArticleListMode, ContentPage};
use crate::main_window::MainWindow;
use crate::sidebar::SideBar;

pub struct NavigationActions;

impl NavigationActions {
    pub fn setup() {
        // ---------------------------
        // next article
        // ---------------------------
        let next_article = ActionEntry::builder("next-article")
            .activate(|_window, _action, _parameter| ArticleList::instance().select_next_article())
            .build();

        // ---------------------------
        // prev article
        // ---------------------------
        let prev_article = ActionEntry::builder("prev-article")
            .activate(|_window, _action, _parameter| ArticleList::instance().select_prev_article())
            .build();

        // ---------------------------
        // sidebar next
        // ---------------------------
        let next_sidebar = ActionEntry::builder("sidebar-next")
            .activate(|_window, _action, _parameter| SideBar::instance().select_next_item())
            .build();

        // ---------------------------
        // sidebar prev
        // ---------------------------
        let prev_sidebar = ActionEntry::builder("sidebar-prev")
            .activate(|_window, _action, _parameter| SideBar::instance().select_prev_item())
            .build();

        // ---------------------------
        // scroll down
        // ---------------------------
        let scroll_down = ActionEntry::builder("scroll-down")
            .activate(|_window, _action, _parameter| ArticleView::instance().scroll_diff(150.0))
            .build();

        // ---------------------------
        // scroll up
        // ---------------------------
        let scroll_up = ActionEntry::builder("scroll-up")
            .activate(|_window, _action, _parameter| ArticleView::instance().scroll_diff(-150.0))
            .build();

        // ---------------------------
        // show all articles
        // ---------------------------
        let all_articles = ActionEntry::builder("all-articles")
            .activate(|_window, _action, _parameter| ArticleListColumn::instance().set_mode(ArticleListMode::All))
            .build();

        // ---------------------------
        // show only unread
        // ---------------------------
        let unread_articles = ActionEntry::builder("only-unread")
            .activate(|_window, _action, _parameter| ArticleListColumn::instance().set_mode(ArticleListMode::Unread))
            .build();

        // ---------------------------
        // show only starred
        // ---------------------------
        let starred_articles = ActionEntry::builder("only-starred")
            .activate(|_window, _action, _parameter| ArticleListColumn::instance().set_mode(ArticleListMode::Marked))
            .build();

        // ---------------------------
        // show article view
        // ---------------------------
        let show_article_view = ActionEntry::builder("show-article-view")
            .activate(|_window, _action, _parameter| ContentPage::instance().inner().set_show_content(true))
            .build();

        MainWindow::instance().add_action_entries([
            next_article,
            prev_article,
            next_sidebar,
            prev_sidebar,
            scroll_down,
            scroll_up,
            all_articles,
            unread_articles,
            starred_articles,
            show_article_view,
        ]);
    }
}
