#include "libnewsboat-ffi/src/filepath.rs.h"
#include <cstdint>
#include <string>

#ifdef __clang__
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__

namespace newsboat {
  namespace logger {
    enum class Level : ::std::uint8_t;
  }
}

namespace newsboat {
namespace logger {
#ifndef CXXBRIDGE1_ENUM_newsboat$logger$Level
#define CXXBRIDGE1_ENUM_newsboat$logger$Level
enum class Level : ::std::uint8_t {
  USERERROR = 1,
  CRITICAL = 2,
  ERROR = 3,
  WARN = 4,
  INFO = 5,
  DEBUG = 6,
};
#endif // CXXBRIDGE1_ENUM_newsboat$logger$Level

extern "C" {
void newsboat$logger$cxxbridge1$unset_loglevel() noexcept;

void newsboat$logger$cxxbridge1$set_logfile(::newsboat::filepath::bridged::PathBuf const &logfile) noexcept;

::std::int64_t newsboat$logger$cxxbridge1$get_loglevel() noexcept;

void newsboat$logger$cxxbridge1$set_loglevel(::newsboat::logger::Level level) noexcept;

void newsboat$logger$cxxbridge1$log_internal(::newsboat::logger::Level level, ::std::string const &message) noexcept;

void newsboat$logger$cxxbridge1$set_user_error_logfile(::newsboat::filepath::bridged::PathBuf const &user_error_logfile) noexcept;
} // extern "C"

void unset_loglevel() noexcept {
  newsboat$logger$cxxbridge1$unset_loglevel();
}

void set_logfile(::newsboat::filepath::bridged::PathBuf const &logfile) noexcept {
  newsboat$logger$cxxbridge1$set_logfile(logfile);
}

::std::int64_t get_loglevel() noexcept {
  return newsboat$logger$cxxbridge1$get_loglevel();
}

void set_loglevel(::newsboat::logger::Level level) noexcept {
  newsboat$logger$cxxbridge1$set_loglevel(level);
}

void log_internal(::newsboat::logger::Level level, ::std::string const &message) noexcept {
  newsboat$logger$cxxbridge1$log_internal(level, message);
}

void set_user_error_logfile(::newsboat::filepath::bridged::PathBuf const &user_error_logfile) noexcept {
  newsboat$logger$cxxbridge1$set_user_error_logfile(user_error_logfile);
}
} // namespace logger
} // namespace newsboat
