// WARNING: this file was generated by ../scripts/gen-tag-table.py

use read_fonts::types::Tag;

pub(crate) struct LangTag {
    pub language: &'static str,
    pub tag: Tag,
}

#[rustfmt::skip]
pub(crate) static OPEN_TYPE_LANGUAGES: &[LangTag] = &[
    LangTag { language: "aa", 	tag: Tag::new(b"AFR ") }, // Afar
    LangTag { language: "aae", 	tag: Tag::new(b"SQI ") }, // Arbëreshë Albanian -> Albanian
    LangTag { language: "aao", 	tag: Tag::new(b"ARA ") }, // Algerian Saharan Arabic -> Arabic
//  LangTag { language: "aaq", 	tag: Tag::new(b"AAQ ") }, // Eastern Abnaki -> Eastern Abenaki
    LangTag { language: "aat", 	tag: Tag::new(b"SQI ") }, // Arvanitika Albanian -> Albanian
    LangTag { language: "ab", 	tag: Tag::new(b"ABK ") }, // Abkhazian
    LangTag { language: "aba", 	tag: Tag::new(&[0; 4]) }, // Abé != Abaza
    LangTag { language: "abh", 	tag: Tag::new(b"ARA ") }, // Tajiki Arabic -> Arabic
    LangTag { language: "abq", 	tag: Tag::new(b"ABA ") }, // Abaza
    LangTag { language: "abs", 	tag: Tag::new(b"CPP ") }, // Ambonese Malay -> Creoles
    LangTag { language: "abv", 	tag: Tag::new(b"ARA ") }, // Baharna Arabic -> Arabic
    LangTag { language: "acf", 	tag: Tag::new(b"FAN ") }, // Saint Lucian Creole French -> French Antillean
    LangTag { language: "acf", 	tag: Tag::new(b"CPP ") }, // Saint Lucian Creole French -> Creoles
//  LangTag { language: "ach", 	tag: Tag::new(b"ACH ") }, // Acoli -> Acholi
    LangTag { language: "acm", 	tag: Tag::new(b"ARA ") }, // Mesopotamian Arabic -> Arabic
    LangTag { language: "acq", 	tag: Tag::new(b"ARA ") }, // Ta'izzi-Adeni Arabic -> Arabic
    LangTag { language: "acr", 	tag: Tag::new(b"ACR ") }, // Achi
    LangTag { language: "acr", 	tag: Tag::new(b"MYN ") }, // Achi -> Mayan
    LangTag { language: "acw", 	tag: Tag::new(b"ARA ") }, // Hijazi Arabic -> Arabic
    LangTag { language: "acx", 	tag: Tag::new(b"ARA ") }, // Omani Arabic -> Arabic
    LangTag { language: "acy", 	tag: Tag::new(b"ACY ") }, // Cypriot Arabic
    LangTag { language: "acy", 	tag: Tag::new(b"ARA ") }, // Cypriot Arabic -> Arabic
    LangTag { language: "ada", 	tag: Tag::new(b"DNG ") }, // Adangme -> Dangme
    LangTag { language: "adf", 	tag: Tag::new(b"ARA ") }, // Dhofari Arabic -> Arabic
    LangTag { language: "adp", 	tag: Tag::new(b"DZN ") }, // Adap(retired code) -> Dzongkha
//  LangTag { language: "ady", 	tag: Tag::new(b"ADY ") }, // Adyghe
    LangTag { language: "aeb", 	tag: Tag::new(b"ARA ") }, // Tunisian Arabic -> Arabic
    LangTag { language: "aec", 	tag: Tag::new(b"ARA ") }, // Saidi Arabic -> Arabic
    LangTag { language: "af", 	tag: Tag::new(b"AFK ") }, // Afrikaans
    LangTag { language: "afb", 	tag: Tag::new(b"ARA ") }, // Gulf Arabic -> Arabic
    LangTag { language: "afk", 	tag: Tag::new(&[0; 4]) }, // Nanubae != Afrikaans
    LangTag { language: "afs", 	tag: Tag::new(b"CPP ") }, // Afro-Seminole Creole -> Creoles
    LangTag { language: "agu", 	tag: Tag::new(b"MYN ") }, // Aguacateco -> Mayan
    LangTag { language: "agw", 	tag: Tag::new(&[0; 4]) }, // Kahua != Agaw
    LangTag { language: "ahg", 	tag: Tag::new(b"AGW ") }, // Qimant -> Agaw
    LangTag { language: "aht", 	tag: Tag::new(b"ATH ") }, // Ahtena -> Athapaskan
    LangTag { language: "aig", 	tag: Tag::new(b"CPP ") }, // Antigua and Barbuda Creole English -> Creoles
    LangTag { language: "aii", 	tag: Tag::new(b"SWA ") }, // Assyrian Neo-Aramaic -> Swadaya Aramaic
    LangTag { language: "aii", 	tag: Tag::new(b"SYR ") }, // Assyrian Neo-Aramaic -> Syriac
//  LangTag { language: "aio", 	tag: Tag::new(b"AIO ") }, // Aiton
    LangTag { language: "aiw", 	tag: Tag::new(b"ARI ") }, // Aari
    LangTag { language: "ajp", 	tag: Tag::new(b"ARA ") }, // South Levantine Arabic(retired code) -> Arabic
    LangTag { language: "ajt", 	tag: Tag::new(b"ARA ") }, // Judeo-Tunisian Arabic(retired code) -> Arabic
    LangTag { language: "ak", 	tag: Tag::new(b"AKA ") }, // Akan [macrolanguage]
    LangTag { language: "akb", 	tag: Tag::new(b"AKB ") }, // Batak Angkola
    LangTag { language: "akb", 	tag: Tag::new(b"BTK ") }, // Batak Angkola -> Batak
    LangTag { language: "aln", 	tag: Tag::new(b"SQI ") }, // Gheg Albanian -> Albanian
    LangTag { language: "als", 	tag: Tag::new(b"SQI ") }, // Tosk Albanian -> Albanian
//  LangTag { language: "alt", 	tag: Tag::new(b"ALT ") }, // Southern Altai -> Altai
    LangTag { language: "am", 	tag: Tag::new(b"AMH ") }, // Amharic
    LangTag { language: "amf", 	tag: Tag::new(b"HBN ") }, // Hamer-Banna -> Hammer-Banna
    LangTag { language: "amw", 	tag: Tag::new(b"SYR ") }, // Western Neo-Aramaic -> Syriac
    LangTag { language: "an", 	tag: Tag::new(b"ARG ") }, // Aragonese
//  LangTag { language: "ang", 	tag: Tag::new(b"ANG ") }, // Old English (ca. 450-1100) -> Anglo-Saxon
    LangTag { language: "aoa", 	tag: Tag::new(b"CPP ") }, // Angolar -> Creoles
    LangTag { language: "apa", 	tag: Tag::new(b"ATH ") }, // Apache  [collection] -> Athapaskan
    LangTag { language: "apc", 	tag: Tag::new(b"ARA ") }, // Levantine Arabic -> Arabic
    LangTag { language: "apd", 	tag: Tag::new(b"ARA ") }, // Sudanese Arabic -> Arabic
    LangTag { language: "apj", 	tag: Tag::new(b"ATH ") }, // Jicarilla Apache -> Athapaskan
    LangTag { language: "apk", 	tag: Tag::new(b"ATH ") }, // Kiowa Apache -> Athapaskan
    LangTag { language: "apl", 	tag: Tag::new(b"ATH ") }, // Lipan Apache -> Athapaskan
    LangTag { language: "apm", 	tag: Tag::new(b"ATH ") }, // Mescalero-Chiricahua Apache -> Athapaskan
    LangTag { language: "apw", 	tag: Tag::new(b"ATH ") }, // Western Apache -> Athapaskan
    LangTag { language: "ar", 	tag: Tag::new(b"ARA ") }, // Arabic [macrolanguage]
    LangTag { language: "arb", 	tag: Tag::new(b"ARA ") }, // Standard Arabic -> Arabic
    LangTag { language: "ari", 	tag: Tag::new(&[0; 4]) }, // Arikara != Aari
    LangTag { language: "ark", 	tag: Tag::new(&[0; 4]) }, // Arikapú != Rakhine
    LangTag { language: "arn", 	tag: Tag::new(b"MAP ") }, // Mapudungun
    LangTag { language: "arq", 	tag: Tag::new(b"ARA ") }, // Algerian Arabic -> Arabic
    LangTag { language: "ars", 	tag: Tag::new(b"ARA ") }, // Najdi Arabic -> Arabic
    LangTag { language: "ary", 	tag: Tag::new(b"MOR ") }, // Moroccan Arabic -> Moroccan
    LangTag { language: "ary", 	tag: Tag::new(b"ARA ") }, // Moroccan Arabic -> Arabic
    LangTag { language: "arz", 	tag: Tag::new(b"ARA ") }, // Egyptian Arabic -> Arabic
    LangTag { language: "as", 	tag: Tag::new(b"ASM ") }, // Assamese
//  LangTag { language: "ast", 	tag: Tag::new(b"AST ") }, // Asturian
//  LangTag { language: "ath", 	tag: Tag::new(b"ATH ") }, // Athapascan  [collection] -> Athapaskan
    LangTag { language: "atj", 	tag: Tag::new(b"RCR ") }, // Atikamekw -> R-Cree
//  LangTag { language: "ats", 	tag: Tag::new(b"ATS ") }, // Gros Ventre (Atsina)
    LangTag { language: "atv", 	tag: Tag::new(b"ALT ") }, // Northern Altai -> Altai
    LangTag { language: "auj", 	tag: Tag::new(b"BBR ") }, // Awjilah -> Berber
    LangTag { language: "auz", 	tag: Tag::new(b"ARA ") }, // Uzbeki Arabic -> Arabic
    LangTag { language: "av", 	tag: Tag::new(b"AVR ") }, // Avaric -> Avar
    LangTag { language: "avl", 	tag: Tag::new(b"ARA ") }, // Eastern Egyptian Bedawi Arabic -> Arabic
//  LangTag { language: "avn", 	tag: Tag::new(b"AVN ") }, // Avatime
//  LangTag { language: "awa", 	tag: Tag::new(b"AWA ") }, // Awadhi
    LangTag { language: "ay", 	tag: Tag::new(b"AYM ") }, // Aymara [macrolanguage]
    LangTag { language: "ayc", 	tag: Tag::new(b"AYM ") }, // Southern Aymara -> Aymara
    LangTag { language: "ayh", 	tag: Tag::new(b"ARA ") }, // Hadrami Arabic -> Arabic
    LangTag { language: "ayl", 	tag: Tag::new(b"ARA ") }, // Libyan Arabic -> Arabic
    LangTag { language: "ayn", 	tag: Tag::new(b"ARA ") }, // Sanaani Arabic -> Arabic
    LangTag { language: "ayp", 	tag: Tag::new(b"ARA ") }, // North Mesopotamian Arabic -> Arabic
    LangTag { language: "ayr", 	tag: Tag::new(b"AYM ") }, // Central Aymara -> Aymara
    LangTag { language: "az", 	tag: Tag::new(b"AZE ") }, // Azerbaijani [macrolanguage]
    LangTag { language: "azb", 	tag: Tag::new(b"AZB ") }, // South Azerbaijani -> Torki
    LangTag { language: "azb", 	tag: Tag::new(b"AZE ") }, // South Azerbaijani -> Azerbaijani
    LangTag { language: "azd", 	tag: Tag::new(b"NAH ") }, // Eastern Durango Nahuatl -> Nahuatl
    LangTag { language: "azj", 	tag: Tag::new(b"AZE ") }, // North Azerbaijani -> Azerbaijani
    LangTag { language: "azn", 	tag: Tag::new(b"NAH ") }, // Western Durango Nahuatl -> Nahuatl
    LangTag { language: "azz", 	tag: Tag::new(b"NAH ") }, // Highland Puebla Nahuatl -> Nahuatl
    LangTag { language: "ba", 	tag: Tag::new(b"BSH ") }, // Bashkir
    LangTag { language: "bad", 	tag: Tag::new(b"BAD0") }, // Banda  [collection]
    LangTag { language: "bag", 	tag: Tag::new(&[0; 4]) }, // Tuki != Baghelkhandi
    LangTag { language: "bah", 	tag: Tag::new(b"CPP ") }, // Bahamas Creole English -> Creoles
    LangTag { language: "bai", 	tag: Tag::new(b"BML ") }, // Bamileke  [collection]
    LangTag { language: "bal", 	tag: Tag::new(b"BLI ") }, // Baluchi [macrolanguage]
//  LangTag { language: "ban", 	tag: Tag::new(b"BAN ") }, // Balinese
//  LangTag { language: "bar", 	tag: Tag::new(b"BAR ") }, // Bavarian
    LangTag { language: "bau", 	tag: Tag::new(&[0; 4]) }, // Bada (Nigeria) != Baulé
    LangTag { language: "bbc", 	tag: Tag::new(b"BBC ") }, // Batak Toba
    LangTag { language: "bbc", 	tag: Tag::new(b"BTK ") }, // Batak Toba -> Batak
    LangTag { language: "bbj", 	tag: Tag::new(b"BML ") }, // Ghomálá' -> Bamileke
    LangTag { language: "bbp", 	tag: Tag::new(b"BAD0") }, // West Central Banda -> Banda
    LangTag { language: "bbr", 	tag: Tag::new(&[0; 4]) }, // Girawa != Berber
    LangTag { language: "bbz", 	tag: Tag::new(b"ARA ") }, // Babalia Creole Arabic(retired code) -> Arabic
    LangTag { language: "bcc", 	tag: Tag::new(b"BLI ") }, // Southern Balochi -> Baluchi
    LangTag { language: "bch", 	tag: Tag::new(&[0; 4]) }, // Bariai != Bench
    LangTag { language: "bci", 	tag: Tag::new(b"BAU ") }, // Baoulé -> Baulé
    LangTag { language: "bcl", 	tag: Tag::new(b"BIK ") }, // Central Bikol -> Bikol
    LangTag { language: "bcq", 	tag: Tag::new(b"BCH ") }, // Bench
    LangTag { language: "bcr", 	tag: Tag::new(b"ATH ") }, // Babine -> Athapaskan
//  LangTag { language: "bdc", 	tag: Tag::new(b"BDC ") }, // Emberá-Baudó
//  LangTag { language: "bdy", 	tag: Tag::new(b"BDY ") }, // Bandjalang
    LangTag { language: "be", 	tag: Tag::new(b"BEL ") }, // Belarusian
    LangTag { language: "bea", 	tag: Tag::new(b"ATH ") }, // Beaver -> Athapaskan
    LangTag { language: "beb", 	tag: Tag::new(b"BTI ") }, // Bebele -> Beti
//  LangTag { language: "bem", 	tag: Tag::new(b"BEM ") }, // Bemba (Zambia)
    LangTag { language: "ber", 	tag: Tag::new(b"BBR ") }, // Berber  [collection]
    LangTag { language: "bew", 	tag: Tag::new(b"CPP ") }, // Betawi -> Creoles
    LangTag { language: "bfl", 	tag: Tag::new(b"BAD0") }, // Banda-Ndélé -> Banda
    LangTag { language: "bfq", 	tag: Tag::new(b"BAD ") }, // Badaga
    LangTag { language: "bft", 	tag: Tag::new(b"BLT ") }, // Balti
    LangTag { language: "bfu", 	tag: Tag::new(b"LAH ") }, // Gahri -> Lahuli
    LangTag { language: "bfy", 	tag: Tag::new(b"BAG ") }, // Bagheli -> Baghelkhandi
    LangTag { language: "bg", 	tag: Tag::new(b"BGR ") }, // Bulgarian
//  LangTag { language: "bgc", 	tag: Tag::new(b"BGC ") }, // Haryanvi
    LangTag { language: "bgn", 	tag: Tag::new(b"BLI ") }, // Western Balochi -> Baluchi
    LangTag { language: "bgp", 	tag: Tag::new(b"BLI ") }, // Eastern Balochi -> Baluchi
    LangTag { language: "bgq", 	tag: Tag::new(b"BGQ ") }, // Bagri
    LangTag { language: "bgq", 	tag: Tag::new(b"RAJ ") }, // Bagri -> Rajasthani
    LangTag { language: "bgr", 	tag: Tag::new(b"QIN ") }, // Bawm Chin -> Chin
    LangTag { language: "bhb", 	tag: Tag::new(b"BHI ") }, // Bhili
//  LangTag { language: "bhi", 	tag: Tag::new(b"BHI ") }, // Bhilali -> Bhili
    LangTag { language: "bhk", 	tag: Tag::new(b"BIK ") }, // Albay Bicolano(retired code) -> Bikol
//  LangTag { language: "bho", 	tag: Tag::new(b"BHO ") }, // Bhojpuri
    LangTag { language: "bhr", 	tag: Tag::new(b"MLG ") }, // Bara Malagasy -> Malagasy
    LangTag { language: "bi", 	tag: Tag::new(b"BIS ") }, // Bislama
    LangTag { language: "bi", 	tag: Tag::new(b"CPP ") }, // Bislama -> Creoles
//  LangTag { language: "bik", 	tag: Tag::new(b"BIK ") }, // Bikol [macrolanguage]
    LangTag { language: "bil", 	tag: Tag::new(&[0; 4]) }, // Bile != Bilen
    LangTag { language: "bin", 	tag: Tag::new(b"EDO ") }, // Edo
    LangTag { language: "biu", 	tag: Tag::new(b"QIN ") }, // Biete -> Chin
//  LangTag { language: "bjj", 	tag: Tag::new(b"BJJ ") }, // Kanauji
    LangTag { language: "bjn", 	tag: Tag::new(b"MLY ") }, // Banjar -> Malay
    LangTag { language: "bjo", 	tag: Tag::new(b"BAD0") }, // Mid-Southern Banda -> Banda
    LangTag { language: "bjq", 	tag: Tag::new(b"MLG ") }, // Southern Betsimisaraka Malagasy(retired code) -> Malagasy
    LangTag { language: "bjs", 	tag: Tag::new(b"CPP ") }, // Bajan -> Creoles
    LangTag { language: "bjt", 	tag: Tag::new(b"BLN ") }, // Balanta-Ganja -> Balante
    LangTag { language: "bkf", 	tag: Tag::new(&[0; 4]) }, // Beeke != Blackfoot
    LangTag { language: "bko", 	tag: Tag::new(b"BML ") }, // Kwa' -> Bamileke
    LangTag { language: "bla", 	tag: Tag::new(b"BKF ") }, // Siksika -> Blackfoot
    LangTag { language: "ble", 	tag: Tag::new(b"BLN ") }, // Balanta-Kentohe -> Balante
    LangTag { language: "blg", 	tag: Tag::new(b"IBA ") }, // Balau(retired code) -> Iban
    LangTag { language: "bli", 	tag: Tag::new(&[0; 4]) }, // Bolia != Baluchi
    LangTag { language: "blk", 	tag: Tag::new(b"BLK ") }, // Pa’o Karen
    LangTag { language: "blk", 	tag: Tag::new(b"KRN ") }, // Pa'o Karen -> Karen
    LangTag { language: "bln", 	tag: Tag::new(b"BIK ") }, // Southern Catanduanes Bikol -> Bikol
    LangTag { language: "blt", 	tag: Tag::new(&[0; 4]) }, // Tai Dam != Balti
    LangTag { language: "bm", 	tag: Tag::new(b"BMB ") }, // Bambara (Bamanankan)
    LangTag { language: "bmb", 	tag: Tag::new(&[0; 4]) }, // Bembe != Bambara (Bamanankan)
    LangTag { language: "bml", 	tag: Tag::new(&[0; 4]) }, // Bomboli != Bamileke
    LangTag { language: "bmm", 	tag: Tag::new(b"MLG ") }, // Northern Betsimisaraka Malagasy -> Malagasy
    LangTag { language: "bn", 	tag: Tag::new(b"BEN ") }, // Bangla
    LangTag { language: "bo", 	tag: Tag::new(b"TIB ") }, // Tibetan
    LangTag { language: "bpd", 	tag: Tag::new(b"BAD0") }, // Banda-Banda -> Banda
    LangTag { language: "bpl", 	tag: Tag::new(b"CPP ") }, // Broome Pearling Lugger Pidgin -> Creoles
    LangTag { language: "bpq", 	tag: Tag::new(b"CPP ") }, // Banda Malay -> Creoles
//  LangTag { language: "bpy", 	tag: Tag::new(b"BPY ") }, // Bishnupriya -> Bishnupriya Manipuri
    LangTag { language: "bqi", 	tag: Tag::new(b"LRC ") }, // Bakhtiari -> Luri
    LangTag { language: "bqk", 	tag: Tag::new(b"BAD0") }, // Banda-Mbrès -> Banda
    LangTag { language: "br", 	tag: Tag::new(b"BRE ") }, // Breton
    LangTag { language: "bra", 	tag: Tag::new(b"BRI ") }, // Braj -> Braj Bhasha
    LangTag { language: "brc", 	tag: Tag::new(b"CPP ") }, // Berbice Creole Dutch -> Creoles
//  LangTag { language: "brh", 	tag: Tag::new(b"BRH ") }, // Brahui
    LangTag { language: "bri", 	tag: Tag::new(&[0; 4]) }, // Mokpwe != Braj Bhasha
    LangTag { language: "brm", 	tag: Tag::new(&[0; 4]) }, // Barambu != Burmese
//  LangTag { language: "brx", 	tag: Tag::new(b"BRX ") }, // Bodo (India)
    LangTag { language: "bs", 	tag: Tag::new(b"BOS ") }, // Bosnian
    LangTag { language: "bsh", 	tag: Tag::new(&[0; 4]) }, // Kati != Bashkir
//  LangTag { language: "bsk", 	tag: Tag::new(b"BSK ") }, // Burushaski
    LangTag { language: "btb", 	tag: Tag::new(b"BTI ") }, // Beti (Cameroon)(retired code)
    LangTag { language: "btd", 	tag: Tag::new(b"BTD ") }, // Batak Dairi (Pakpak)
    LangTag { language: "btd", 	tag: Tag::new(b"BTK ") }, // Batak Dairi -> Batak
    LangTag { language: "bti", 	tag: Tag::new(&[0; 4]) }, // Burate != Beti
    LangTag { language: "btj", 	tag: Tag::new(b"MLY ") }, // Bacanese Malay -> Malay
//  LangTag { language: "btk", 	tag: Tag::new(b"BTK ") }, // Batak  [collection]
    LangTag { language: "btm", 	tag: Tag::new(b"BTM ") }, // Batak Mandailing
    LangTag { language: "btm", 	tag: Tag::new(b"BTK ") }, // Batak Mandailing -> Batak
    LangTag { language: "bto", 	tag: Tag::new(b"BIK ") }, // Rinconada Bikol -> Bikol
    LangTag { language: "bts", 	tag: Tag::new(b"BTS ") }, // Batak Simalungun
    LangTag { language: "bts", 	tag: Tag::new(b"BTK ") }, // Batak Simalungun -> Batak
    LangTag { language: "btx", 	tag: Tag::new(b"BTX ") }, // Batak Karo
    LangTag { language: "btx", 	tag: Tag::new(b"BTK ") }, // Batak Karo -> Batak
    LangTag { language: "btz", 	tag: Tag::new(b"BTZ ") }, // Batak Alas-Kluet
    LangTag { language: "btz", 	tag: Tag::new(b"BTK ") }, // Batak Alas-Kluet -> Batak
//  LangTag { language: "bug", 	tag: Tag::new(b"BUG ") }, // Buginese -> Bugis
    LangTag { language: "bum", 	tag: Tag::new(b"BTI ") }, // Bulu (Cameroon) -> Beti
    LangTag { language: "bve", 	tag: Tag::new(b"MLY ") }, // Berau Malay -> Malay
    LangTag { language: "bvu", 	tag: Tag::new(b"MLY ") }, // Bukit Malay -> Malay
    LangTag { language: "bwe", 	tag: Tag::new(b"KRN ") }, // Bwe Karen -> Karen
    LangTag { language: "bxk", 	tag: Tag::new(b"LUH ") }, // Bukusu -> Luyia
    LangTag { language: "bxo", 	tag: Tag::new(b"CPP ") }, // Barikanchi -> Creoles
    LangTag { language: "bxp", 	tag: Tag::new(b"BTI ") }, // Bebil -> Beti
    LangTag { language: "bxr", 	tag: Tag::new(b"RBU ") }, // Russia Buriat -> Russian Buriat
    LangTag { language: "byn", 	tag: Tag::new(b"BIL ") }, // Bilin -> Bilen
    LangTag { language: "byv", 	tag: Tag::new(b"BYV ") }, // Medumba
    LangTag { language: "byv", 	tag: Tag::new(b"BML ") }, // Medumba -> Bamileke
    LangTag { language: "bzc", 	tag: Tag::new(b"MLG ") }, // Southern Betsimisaraka Malagasy -> Malagasy
    LangTag { language: "bzj", 	tag: Tag::new(b"CPP ") }, // Belize Kriol English -> Creoles
    LangTag { language: "bzk", 	tag: Tag::new(b"CPP ") }, // Nicaragua Creole English -> Creoles
    LangTag { language: "ca", 	tag: Tag::new(b"CAT ") }, // Catalan
    LangTag { language: "caa", 	tag: Tag::new(b"MYN ") }, // Chortí -> Mayan
    LangTag { language: "cac", 	tag: Tag::new(b"MYN ") }, // Chuj -> Mayan
    LangTag { language: "caf", 	tag: Tag::new(b"CRR ") }, // Southern Carrier -> Carrier
    LangTag { language: "caf", 	tag: Tag::new(b"ATH ") }, // Southern Carrier -> Athapaskan
    LangTag { language: "cak", 	tag: Tag::new(b"CAK ") }, // Kaqchikel
    LangTag { language: "cak", 	tag: Tag::new(b"MYN ") }, // Kaqchikel -> Mayan
//  LangTag { language: "cay", 	tag: Tag::new(b"CAY ") }, // Cayuga
//  LangTag { language: "cbg", 	tag: Tag::new(b"CBG ") }, // Chimila
    LangTag { language: "cbk", 	tag: Tag::new(b"CBK ") }, // Chavacano -> Zamboanga Chavacano
    LangTag { language: "cbk", 	tag: Tag::new(b"CPP ") }, // Chavacano -> Creoles
    LangTag { language: "cbl", 	tag: Tag::new(b"QIN ") }, // Bualkhaw Chin -> Chin
    LangTag { language: "ccl", 	tag: Tag::new(b"CPP ") }, // Cutchi-Swahili -> Creoles
    LangTag { language: "ccm", 	tag: Tag::new(b"CPP ") }, // Malaccan Creole Malay -> Creoles
    LangTag { language: "cco", 	tag: Tag::new(b"CCHN") }, // Comaltepec Chinantec -> Chinantec
    LangTag { language: "ccq", 	tag: Tag::new(b"ARK ") }, // Chaungtha(retired code) -> Rakhine
    LangTag { language: "cdo", 	tag: Tag::new(b"ZHS ") }, // Min Dong Chinese -> Chinese, Simplified
    LangTag { language: "ce", 	tag: Tag::new(b"CHE ") }, // Chechen
//  LangTag { language: "ceb", 	tag: Tag::new(b"CEB ") }, // Cebuano
    LangTag { language: "cek", 	tag: Tag::new(b"QIN ") }, // Eastern Khumi Chin -> Chin
    LangTag { language: "cey", 	tag: Tag::new(b"QIN ") }, // Ekai Chin -> Chin
    LangTag { language: "cfm", 	tag: Tag::new(b"HAL ") }, // Halam (Falam Chin)
    LangTag { language: "cfm", 	tag: Tag::new(b"QIN ") }, // Falam Chin -> Chin
//  LangTag { language: "cgg", 	tag: Tag::new(b"CGG ") }, // Chiga
    LangTag { language: "ch", 	tag: Tag::new(b"CHA ") }, // Chamorro
    LangTag { language: "chf", 	tag: Tag::new(b"MYN ") }, // Tabasco Chontal -> Mayan
    LangTag { language: "chg", 	tag: Tag::new(&[0; 4]) }, // Chagatai != Chaha Gurage
    LangTag { language: "chh", 	tag: Tag::new(&[0; 4]) }, // Chinook != Chattisgarhi
    LangTag { language: "chj", 	tag: Tag::new(b"CCHN") }, // Ojitlán Chinantec -> Chinantec
    LangTag { language: "chk", 	tag: Tag::new(b"CHK0") }, // Chuukese
    LangTag { language: "chm", 	tag: Tag::new(b"HMA ") }, // Mari (Russia) [macrolanguage] -> High Mari
    LangTag { language: "chm", 	tag: Tag::new(b"LMA ") }, // Mari (Russia) [macrolanguage] -> Low Mari
    LangTag { language: "chn", 	tag: Tag::new(b"CPP ") }, // Chinook jargon -> Creoles
//  LangTag { language: "cho", 	tag: Tag::new(b"CHO ") }, // Choctaw
    LangTag { language: "chp", 	tag: Tag::new(b"CHP ") }, // Chipewyan
    LangTag { language: "chp", 	tag: Tag::new(b"SAY ") }, // Chipewyan -> Sayisi
    LangTag { language: "chp", 	tag: Tag::new(b"ATH ") }, // Chipewyan -> Athapaskan
    LangTag { language: "chq", 	tag: Tag::new(b"CCHN") }, // Quiotepec Chinantec -> Chinantec
//  LangTag { language: "chr", 	tag: Tag::new(b"CHR ") }, // Cherokee
//  LangTag { language: "chy", 	tag: Tag::new(b"CHY ") }, // Cheyenne
    LangTag { language: "chz", 	tag: Tag::new(b"CCHN") }, // Ozumacín Chinantec -> Chinantec
    LangTag { language: "ciw", 	tag: Tag::new(b"OJB ") }, // Chippewa -> Ojibway
//  LangTag { language: "cja", 	tag: Tag::new(b"CJA ") }, // Western Cham
//  LangTag { language: "cjm", 	tag: Tag::new(b"CJM ") }, // Eastern Cham
    LangTag { language: "cjy", 	tag: Tag::new(b"ZHS ") }, // Jinyu Chinese -> Chinese, Simplified
    LangTag { language: "cka", 	tag: Tag::new(b"QIN ") }, // Khumi Awa Chin(retired code) -> Chin
    LangTag { language: "ckb", 	tag: Tag::new(b"KUR ") }, // Central Kurdish -> Kurdish
    LangTag { language: "ckn", 	tag: Tag::new(b"QIN ") }, // Kaang Chin -> Chin
    LangTag { language: "cks", 	tag: Tag::new(b"CPP ") }, // Tayo -> Creoles
    LangTag { language: "ckt", 	tag: Tag::new(b"CHK ") }, // Chukot -> Chukchi
    LangTag { language: "ckz", 	tag: Tag::new(b"MYN ") }, // Cakchiquel-Quiché Mixed Language -> Mayan
    LangTag { language: "clc", 	tag: Tag::new(b"ATH ") }, // Chilcotin -> Athapaskan
    LangTag { language: "cld", 	tag: Tag::new(b"SYR ") }, // Chaldean Neo-Aramaic -> Syriac
    LangTag { language: "cle", 	tag: Tag::new(b"CCHN") }, // Lealao Chinantec -> Chinantec
    LangTag { language: "clj", 	tag: Tag::new(b"QIN ") }, // Laitu Chin -> Chin
    LangTag { language: "cls", 	tag: Tag::new(b"SAN ") }, // Classical Sanskrit -> Sanskrit
    LangTag { language: "clt", 	tag: Tag::new(b"QIN ") }, // Lautu Chin -> Chin
//  LangTag { language: "cmi", 	tag: Tag::new(b"CMI ") }, // Emberá-Chamí
    LangTag { language: "cmn", 	tag: Tag::new(b"ZHS ") }, // Mandarin Chinese -> Chinese, Simplified
    LangTag { language: "cmr", 	tag: Tag::new(b"QIN ") }, // Mro-Khimi Chin -> Chin
    LangTag { language: "cnb", 	tag: Tag::new(b"QIN ") }, // Chinbon Chin -> Chin
    LangTag { language: "cnh", 	tag: Tag::new(b"QIN ") }, // Hakha Chin -> Chin
    LangTag { language: "cnk", 	tag: Tag::new(b"QIN ") }, // Khumi Chin -> Chin
    LangTag { language: "cnl", 	tag: Tag::new(b"CCHN") }, // Lalana Chinantec -> Chinantec
    LangTag { language: "cnp", 	tag: Tag::new(b"ZHS ") }, // Northern Ping Chinese -> Chinese, Simplified
    LangTag { language: "cnr", 	tag: Tag::new(b"SRB ") }, // Montenegrin -> Serbian
    LangTag { language: "cnt", 	tag: Tag::new(b"CCHN") }, // Tepetotutla Chinantec -> Chinantec
    LangTag { language: "cnu", 	tag: Tag::new(b"BBR ") }, // Chenoua -> Berber
    LangTag { language: "cnw", 	tag: Tag::new(b"QIN ") }, // Ngawn Chin -> Chin
    LangTag { language: "co", 	tag: Tag::new(b"COS ") }, // Corsican
    LangTag { language: "coa", 	tag: Tag::new(b"MLY ") }, // Cocos Islands Malay -> Malay
    LangTag { language: "cob", 	tag: Tag::new(b"MYN ") }, // Chicomuceltec -> Mayan
//  LangTag { language: "coo", 	tag: Tag::new(b"COO ") }, // Comox
//  LangTag { language: "cop", 	tag: Tag::new(b"COP ") }, // Coptic
    LangTag { language: "coq", 	tag: Tag::new(b"ATH ") }, // Coquille -> Athapaskan
    LangTag { language: "cpa", 	tag: Tag::new(b"CCHN") }, // Palantla Chinantec -> Chinantec
    LangTag { language: "cpe", 	tag: Tag::new(b"CPP ") }, // English-based creoles and pidgins [collection] -> Creoles
    LangTag { language: "cpf", 	tag: Tag::new(b"CPP ") }, // French-based creoles and pidgins [collection] -> Creoles
    LangTag { language: "cpi", 	tag: Tag::new(b"CPP ") }, // Chinese Pidgin English -> Creoles
//  LangTag { language: "cpp", 	tag: Tag::new(b"CPP ") }, // Portuguese-based creoles and pidgins [collection] -> Creoles
    LangTag { language: "cpx", 	tag: Tag::new(b"ZHS ") }, // Pu-Xian Chinese -> Chinese, Simplified
    LangTag { language: "cqd", 	tag: Tag::new(b"HMN ") }, // Chuanqiandian Cluster Miao -> Hmong
    LangTag { language: "cqu", 	tag: Tag::new(b"QUH ") }, // Chilean Quechua(retired code) -> Quechua (Bolivia)
    LangTag { language: "cqu", 	tag: Tag::new(b"QUZ ") }, // Chilean Quechua(retired code) -> Quechua
    LangTag { language: "cr", 	tag: Tag::new(b"CRE ") }, // Cree [macrolanguage]
    LangTag { language: "crh", 	tag: Tag::new(b"CRT ") }, // Crimean Tatar
    LangTag { language: "cri", 	tag: Tag::new(b"CPP ") }, // Sãotomense -> Creoles
    LangTag { language: "crj", 	tag: Tag::new(b"ECR ") }, // Southern East Cree -> Eastern Cree
    LangTag { language: "crj", 	tag: Tag::new(b"YCR ") }, // Southern East Cree -> Y-Cree
    LangTag { language: "crj", 	tag: Tag::new(b"CRE ") }, // Southern East Cree -> Cree
    LangTag { language: "crk", 	tag: Tag::new(b"WCR ") }, // Plains Cree -> West-Cree
    LangTag { language: "crk", 	tag: Tag::new(b"YCR ") }, // Plains Cree -> Y-Cree
    LangTag { language: "crk", 	tag: Tag::new(b"CRE ") }, // Plains Cree -> Cree
    LangTag { language: "crl", 	tag: Tag::new(b"ECR ") }, // Northern East Cree -> Eastern Cree
    LangTag { language: "crl", 	tag: Tag::new(b"YCR ") }, // Northern East Cree -> Y-Cree
    LangTag { language: "crl", 	tag: Tag::new(b"CRE ") }, // Northern East Cree -> Cree
    LangTag { language: "crm", 	tag: Tag::new(b"MCR ") }, // Moose Cree
    LangTag { language: "crm", 	tag: Tag::new(b"LCR ") }, // Moose Cree -> L-Cree
    LangTag { language: "crm", 	tag: Tag::new(b"CRE ") }, // Moose Cree -> Cree
    LangTag { language: "crp", 	tag: Tag::new(b"CPP ") }, // Creoles and pidgins [collection] -> Creoles
    LangTag { language: "crr", 	tag: Tag::new(&[0; 4]) }, // Carolina Algonquian != Carrier
    LangTag { language: "crs", 	tag: Tag::new(b"CPP ") }, // Seselwa Creole French -> Creoles
    LangTag { language: "crt", 	tag: Tag::new(&[0; 4]) }, // Iyojwa'ja Chorote != Crimean Tatar
    LangTag { language: "crx", 	tag: Tag::new(b"CRR ") }, // Carrier
    LangTag { language: "crx", 	tag: Tag::new(b"ATH ") }, // Carrier -> Athapaskan
    LangTag { language: "cs", 	tag: Tag::new(b"CSY ") }, // Czech
    LangTag { language: "csa", 	tag: Tag::new(b"CCHN") }, // Chiltepec Chinantec -> Chinantec
//  LangTag { language: "csb", 	tag: Tag::new(b"CSB ") }, // Kashubian
    LangTag { language: "csh", 	tag: Tag::new(b"QIN ") }, // Asho Chin -> Chin
    LangTag { language: "csj", 	tag: Tag::new(b"QIN ") }, // Songlai Chin -> Chin
    LangTag { language: "csl", 	tag: Tag::new(&[0; 4]) }, // Chinese Sign Language != Church Slavonic
    LangTag { language: "cso", 	tag: Tag::new(b"CCHN") }, // Sochiapam Chinantec -> Chinantec
    LangTag { language: "csp", 	tag: Tag::new(b"ZHS ") }, // Southern Ping Chinese -> Chinese, Simplified
    LangTag { language: "csv", 	tag: Tag::new(b"QIN ") }, // Sumtu Chin -> Chin
    LangTag { language: "csw", 	tag: Tag::new(b"NCR ") }, // Swampy Cree -> N-Cree
    LangTag { language: "csw", 	tag: Tag::new(b"NHC ") }, // Swampy Cree -> Norway House Cree
    LangTag { language: "csw", 	tag: Tag::new(b"CRE ") }, // Swampy Cree -> Cree
    LangTag { language: "csy", 	tag: Tag::new(b"QIN ") }, // Siyin Chin -> Chin
    LangTag { language: "ctc", 	tag: Tag::new(b"ATH ") }, // Chetco -> Athapaskan
    LangTag { language: "ctd", 	tag: Tag::new(b"QIN ") }, // Tedim Chin -> Chin
    LangTag { language: "cte", 	tag: Tag::new(b"CCHN") }, // Tepinapa Chinantec -> Chinantec
//  LangTag { language: "ctg", 	tag: Tag::new(b"CTG ") }, // Chittagonian
    LangTag { language: "cth", 	tag: Tag::new(b"QIN ") }, // Thaiphum Chin -> Chin
    LangTag { language: "ctl", 	tag: Tag::new(b"CCHN") }, // Tlacoatzintepec Chinantec -> Chinantec
//  LangTag { language: "cto", 	tag: Tag::new(b"CTO ") }, // Emberá-Catío
    LangTag { language: "cts", 	tag: Tag::new(b"BIK ") }, // Northern Catanduanes Bikol -> Bikol
//  LangTag { language: "ctt", 	tag: Tag::new(b"CTT ") }, // Wayanad Chetti
    LangTag { language: "ctu", 	tag: Tag::new(b"MYN ") }, // Chol -> Mayan
    LangTag { language: "cu", 	tag: Tag::new(b"CSL ") }, // Church Slavonic
    LangTag { language: "cuc", 	tag: Tag::new(b"CCHN") }, // Usila Chinantec -> Chinantec
//  LangTag { language: "cuk", 	tag: Tag::new(b"CUK ") }, // San Blas Kuna
    LangTag { language: "cv", 	tag: Tag::new(b"CHU ") }, // Chuvash
    LangTag { language: "cvn", 	tag: Tag::new(b"CCHN") }, // Valle Nacional Chinantec -> Chinantec
    LangTag { language: "cwd", 	tag: Tag::new(b"DCR ") }, // Woods Cree
    LangTag { language: "cwd", 	tag: Tag::new(b"TCR ") }, // Woods Cree -> TH-Cree
    LangTag { language: "cwd", 	tag: Tag::new(b"CRE ") }, // Woods Cree -> Cree
    LangTag { language: "cy", 	tag: Tag::new(b"WEL ") }, // Welsh
    LangTag { language: "czh", 	tag: Tag::new(b"ZHS ") }, // Huizhou Chinese -> Chinese, Simplified
    LangTag { language: "czo", 	tag: Tag::new(b"ZHS ") }, // Min Zhong Chinese -> Chinese, Simplified
    LangTag { language: "czt", 	tag: Tag::new(b"QIN ") }, // Zotung Chin -> Chin
    LangTag { language: "da", 	tag: Tag::new(b"DAN ") }, // Danish
//  LangTag { language: "dag", 	tag: Tag::new(b"DAG ") }, // Dagbani
    LangTag { language: "dao", 	tag: Tag::new(b"QIN ") }, // Daai Chin -> Chin
    LangTag { language: "dap", 	tag: Tag::new(b"NIS ") }, // Nisi (India)(retired code)
//  LangTag { language: "dar", 	tag: Tag::new(b"DAR ") }, // Dargwa
//  LangTag { language: "dax", 	tag: Tag::new(b"DAX ") }, // Dayi
    LangTag { language: "dcr", 	tag: Tag::new(b"CPP ") }, // Negerhollands -> Creoles
    LangTag { language: "de", 	tag: Tag::new(b"DEU ") }, // German
    LangTag { language: "den", 	tag: Tag::new(b"SLA ") }, // Slave (Athapascan) [macrolanguage] -> Slavey
    LangTag { language: "den", 	tag: Tag::new(b"ATH ") }, // Slave (Athapascan) [macrolanguage] -> Athapaskan
    LangTag { language: "dep", 	tag: Tag::new(b"CPP ") }, // Pidgin Delaware -> Creoles
    LangTag { language: "dgo", 	tag: Tag::new(b"DGO ") }, // Dogri (individual language)
    LangTag { language: "dgo", 	tag: Tag::new(b"DGR ") }, // Dogri (macrolanguage)
    LangTag { language: "dgr", 	tag: Tag::new(b"ATH ") }, // Tlicho -> Athapaskan
    LangTag { language: "dhd", 	tag: Tag::new(b"MAW ") }, // Dhundari -> Marwari
//  LangTag { language: "dhg", 	tag: Tag::new(b"DHG ") }, // Dhangu
    LangTag { language: "dhv", 	tag: Tag::new(&[0; 4]) }, // Dehu != Divehi (Dhivehi, Maldivian) (deprecated)
    LangTag { language: "dib", 	tag: Tag::new(b"DNK ") }, // South Central Dinka -> Dinka
    LangTag { language: "dik", 	tag: Tag::new(b"DNK ") }, // Southwestern Dinka -> Dinka
    LangTag { language: "din", 	tag: Tag::new(b"DNK ") }, // Dinka [macrolanguage]
    LangTag { language: "dip", 	tag: Tag::new(b"DNK ") }, // Northeastern Dinka -> Dinka
    LangTag { language: "diq", 	tag: Tag::new(b"DIQ ") }, // Dimli 
    LangTag { language: "diq", 	tag: Tag::new(b"ZZA ") }, // Dimli  -> Zazaki
    LangTag { language: "diw", 	tag: Tag::new(b"DNK ") }, // Northwestern Dinka -> Dinka
    LangTag { language: "dje", 	tag: Tag::new(b"DJR ") }, // Zarma
    LangTag { language: "djk", 	tag: Tag::new(b"CPP ") }, // Eastern Maroon Creole -> Creoles
    LangTag { language: "djr", 	tag: Tag::new(b"DJR0") }, // Djambarrpuyngu
    LangTag { language: "dks", 	tag: Tag::new(b"DNK ") }, // Southeastern Dinka -> Dinka
    LangTag { language: "dng", 	tag: Tag::new(b"DUN ") }, // Dungan
//  LangTag { language: "dnj", 	tag: Tag::new(b"DNJ ") }, // Dan
    LangTag { language: "dnk", 	tag: Tag::new(&[0; 4]) }, // Dengka != Dinka
    LangTag { language: "doi", 	tag: Tag::new(b"DGR ") }, // Dogri (macrolanguage) [macrolanguage]
    LangTag { language: "drh", 	tag: Tag::new(b"MNG ") }, // Darkhat(retired code) -> Mongolian
    LangTag { language: "dri", 	tag: Tag::new(&[0; 4]) }, // C'Lela != Dari
    LangTag { language: "drw", 	tag: Tag::new(b"DRI ") }, // Darwazi(retired code) -> Dari
    LangTag { language: "drw", 	tag: Tag::new(b"FAR ") }, // Darwazi(retired code) -> Persian
    LangTag { language: "dsb", 	tag: Tag::new(b"LSB ") }, // Lower Sorbian
    LangTag { language: "dty", 	tag: Tag::new(b"NEP ") }, // Dotyali -> Nepali
//  LangTag { language: "duj", 	tag: Tag::new(b"DUJ ") }, // Dhuwal(retired code)
    LangTag { language: "dun", 	tag: Tag::new(&[0; 4]) }, // Dusun Deyah != Dungan
    LangTag { language: "dup", 	tag: Tag::new(b"MLY ") }, // Duano -> Malay
    LangTag { language: "dv", 	tag: Tag::new(b"DIV ") }, // Divehi (Dhivehi, Maldivian)
    LangTag { language: "dv", 	tag: Tag::new(b"DHV ") }, // Divehi (Dhivehi, Maldivian) (deprecated)
    LangTag { language: "dwk", 	tag: Tag::new(b"KUI ") }, // Dawik Kui -> Kui
    LangTag { language: "dwu", 	tag: Tag::new(b"DUJ ") }, // Dhuwal
    LangTag { language: "dwy", 	tag: Tag::new(b"DUJ ") }, // Dhuwaya -> Dhuwal
    LangTag { language: "dyu", 	tag: Tag::new(b"JUL ") }, // Dyula -> Jula
    LangTag { language: "dz", 	tag: Tag::new(b"DZN ") }, // Dzongkha
    LangTag { language: "dzn", 	tag: Tag::new(&[0; 4]) }, // Dzando != Dzongkha
    LangTag { language: "ecr", 	tag: Tag::new(&[0; 4]) }, // Eteocretan != Eastern Cree
    LangTag { language: "ee", 	tag: Tag::new(b"EWE ") }, // Ewe
//  LangTag { language: "efi", 	tag: Tag::new(b"EFI ") }, // Efik
    LangTag { language: "ekk", 	tag: Tag::new(b"ETI ") }, // Standard Estonian -> Estonian
    LangTag { language: "eky", 	tag: Tag::new(b"KRN ") }, // Eastern Kayah -> Karen
    LangTag { language: "el", 	tag: Tag::new(b"ELL ") }, // Modern Greek (1453-) -> Greek
    LangTag { language: "emk", 	tag: Tag::new(b"EMK ") }, // Eastern Maninkakan
    LangTag { language: "emk", 	tag: Tag::new(b"MNK ") }, // Eastern Maninkakan -> Maninka
//  LangTag { language: "emp", 	tag: Tag::new(b"EMP ") }, // Northern Emberá
    LangTag { language: "emy", 	tag: Tag::new(b"MYN ") }, // Epigraphic Mayan -> Mayan
    LangTag { language: "en", 	tag: Tag::new(b"ENG ") }, // English
    LangTag { language: "enb", 	tag: Tag::new(b"KAL ") }, // Markweeta -> Kalenjin
    LangTag { language: "enf", 	tag: Tag::new(b"FNE ") }, // Forest Enets
    LangTag { language: "enh", 	tag: Tag::new(b"TNE ") }, // Tundra Enets
    LangTag { language: "eo", 	tag: Tag::new(b"NTO ") }, // Esperanto
    LangTag { language: "es", 	tag: Tag::new(b"ESP ") }, // Spanish
    LangTag { language: "esg", 	tag: Tag::new(b"GON ") }, // Aheri Gondi -> Gondi
    LangTag { language: "esi", 	tag: Tag::new(b"IPK ") }, // North Alaskan Inupiatun -> Inupiat
    LangTag { language: "esk", 	tag: Tag::new(b"IPK ") }, // Northwest Alaska Inupiatun -> Inupiat
//  LangTag { language: "esu", 	tag: Tag::new(b"ESU ") }, // Central Yupik
    LangTag { language: "et", 	tag: Tag::new(b"ETI ") }, // Estonian [macrolanguage]
    LangTag { language: "eto", 	tag: Tag::new(b"BTI ") }, // Eton (Cameroon) -> Beti
    LangTag { language: "eu", 	tag: Tag::new(b"EUQ ") }, // Basque
    LangTag { language: "euq", 	tag: Tag::new(&[0; 4]) }, // Basque  [collection] != Basque
    LangTag { language: "eve", 	tag: Tag::new(b"EVN ") }, // Even
    LangTag { language: "evn", 	tag: Tag::new(b"EVK ") }, // Evenki
    LangTag { language: "ewo", 	tag: Tag::new(b"BTI ") }, // Ewondo -> Beti
    LangTag { language: "eyo", 	tag: Tag::new(b"KAL ") }, // Keiyo -> Kalenjin
    LangTag { language: "fa", 	tag: Tag::new(b"FAR ") }, // Persian [macrolanguage]
    LangTag { language: "fab", 	tag: Tag::new(b"CPP ") }, // Fa d'Ambu -> Creoles
    LangTag { language: "fan", 	tag: Tag::new(b"FAN0") }, // Fang (Equatorial Guinea)
    LangTag { language: "fan", 	tag: Tag::new(b"BTI ") }, // Fang (Equatorial Guinea) -> Beti
    LangTag { language: "far", 	tag: Tag::new(&[0; 4]) }, // Fataleka != Persian
    LangTag { language: "fat", 	tag: Tag::new(b"FAT ") }, // Fanti
    LangTag { language: "fat", 	tag: Tag::new(b"AKA ") }, // Fanti -> Akan
    LangTag { language: "fbl", 	tag: Tag::new(b"BIK ") }, // West Albay Bikol -> Bikol
    LangTag { language: "ff", 	tag: Tag::new(b"FUL ") }, // Fulah [macrolanguage]
    LangTag { language: "ffm", 	tag: Tag::new(b"FUL ") }, // Maasina Fulfulde -> Fulah
    LangTag { language: "fi", 	tag: Tag::new(b"FIN ") }, // Finnish
    LangTag { language: "fil", 	tag: Tag::new(b"PIL ") }, // Filipino
    LangTag { language: "fj", 	tag: Tag::new(b"FJI ") }, // Fijian
    LangTag { language: "flm", 	tag: Tag::new(b"HAL ") }, // Halam (Falam Chin)(retired code)
    LangTag { language: "flm", 	tag: Tag::new(b"QIN ") }, // Falam Chin(retired code) -> Chin
    LangTag { language: "fmp", 	tag: Tag::new(b"FMP ") }, // Fe’fe’
    LangTag { language: "fmp", 	tag: Tag::new(b"BML ") }, // Fe'fe' -> Bamileke
    LangTag { language: "fng", 	tag: Tag::new(b"CPP ") }, // Fanagalo -> Creoles
    LangTag { language: "fo", 	tag: Tag::new(b"FOS ") }, // Faroese
//  LangTag { language: "fon", 	tag: Tag::new(b"FON ") }, // Fon
    LangTag { language: "fos", 	tag: Tag::new(&[0; 4]) }, // Siraya != Faroese
    LangTag { language: "fpe", 	tag: Tag::new(b"CPP ") }, // Fernando Po Creole English -> Creoles
    LangTag { language: "fr", 	tag: Tag::new(b"FRA ") }, // French
//  LangTag { language: "frc", 	tag: Tag::new(b"FRC ") }, // Cajun French
//  LangTag { language: "frp", 	tag: Tag::new(b"FRP ") }, // Arpitan
    LangTag { language: "fub", 	tag: Tag::new(b"FUL ") }, // Adamawa Fulfulde -> Fulah
    LangTag { language: "fuc", 	tag: Tag::new(b"FUL ") }, // Pulaar -> Fulah
    LangTag { language: "fue", 	tag: Tag::new(b"FUL ") }, // Borgu Fulfulde -> Fulah
    LangTag { language: "fuf", 	tag: Tag::new(b"FTA ") }, // Pular -> Futa
    LangTag { language: "fuf", 	tag: Tag::new(b"FUL ") }, // Pular -> Fulah
    LangTag { language: "fuh", 	tag: Tag::new(b"FUL ") }, // Western Niger Fulfulde -> Fulah
    LangTag { language: "fui", 	tag: Tag::new(b"FUL ") }, // Bagirmi Fulfulde -> Fulah
    LangTag { language: "fuq", 	tag: Tag::new(b"FUL ") }, // Central-Eastern Niger Fulfulde -> Fulah
    LangTag { language: "fur", 	tag: Tag::new(b"FRL ") }, // Friulian
    LangTag { language: "fuv", 	tag: Tag::new(b"FUV ") }, // Nigerian Fulfulde
    LangTag { language: "fuv", 	tag: Tag::new(b"FUL ") }, // Nigerian Fulfulde -> Fulah
    LangTag { language: "fy", 	tag: Tag::new(b"FRI ") }, // Western Frisian -> Frisian
    LangTag { language: "ga", 	tag: Tag::new(b"IRI ") }, // Irish
    LangTag { language: "ga", 	tag: Tag::new(b"IRT ") }, // Irish -> Irish Traditional
    LangTag { language: "gaa", 	tag: Tag::new(b"GAD ") }, // Ga
    LangTag { language: "gac", 	tag: Tag::new(b"CPP ") }, // Mixed Great Andamanese -> Creoles
    LangTag { language: "gad", 	tag: Tag::new(&[0; 4]) }, // Gaddang != Ga
    LangTag { language: "gae", 	tag: Tag::new(&[0; 4]) }, // Guarequena != Scottish Gaelic
//  LangTag { language: "gag", 	tag: Tag::new(b"GAG ") }, // Gagauz
    LangTag { language: "gal", 	tag: Tag::new(&[0; 4]) }, // Galolen != Galician
    LangTag { language: "gan", 	tag: Tag::new(b"ZHS ") }, // Gan Chinese -> Chinese, Simplified
    LangTag { language: "gar", 	tag: Tag::new(&[0; 4]) }, // Galeya != Garshuni
    LangTag { language: "gaw", 	tag: Tag::new(&[0; 4]) }, // Nobonob != Garhwali
    LangTag { language: "gax", 	tag: Tag::new(b"ORO ") }, // Borana-Arsi-Guji Oromo -> Oromo
    LangTag { language: "gaz", 	tag: Tag::new(b"ORO ") }, // West Central Oromo -> Oromo
    LangTag { language: "gbm", 	tag: Tag::new(b"GAW ") }, // Garhwali
    LangTag { language: "gce", 	tag: Tag::new(b"ATH ") }, // Galice -> Athapaskan
    LangTag { language: "gcf", 	tag: Tag::new(b"CPP ") }, // Guadeloupean Creole French -> Creoles
    LangTag { language: "gcl", 	tag: Tag::new(b"CPP ") }, // Grenadian Creole English -> Creoles
    LangTag { language: "gcr", 	tag: Tag::new(b"CPP ") }, // Guianese Creole French -> Creoles
    LangTag { language: "gd", 	tag: Tag::new(b"GAE ") }, // Scottish Gaelic
    LangTag { language: "gda", 	tag: Tag::new(b"RAJ ") }, // Gade Lohar -> Rajasthani
//  LangTag { language: "gez", 	tag: Tag::new(b"GEZ ") }, // Geez
    LangTag { language: "ggo", 	tag: Tag::new(b"GON ") }, // Southern Gondi(retired code) -> Gondi
    LangTag { language: "gha", 	tag: Tag::new(b"BBR ") }, // Ghadamès -> Berber
    LangTag { language: "ghc", 	tag: Tag::new(b"IRT ") }, // Hiberno-Scottish Gaelic -> Irish Traditional
    LangTag { language: "ghk", 	tag: Tag::new(b"KRN ") }, // Geko Karen -> Karen
    LangTag { language: "gho", 	tag: Tag::new(b"BBR ") }, // Ghomara -> Berber
    LangTag { language: "gib", 	tag: Tag::new(b"CPP ") }, // Gibanawa -> Creoles
//  LangTag { language: "gih", 	tag: Tag::new(b"GIH ") }, // Githabul
    LangTag { language: "gil", 	tag: Tag::new(b"GIL0") }, // Kiribati (Gilbertese)
    LangTag { language: "gju", 	tag: Tag::new(b"RAJ ") }, // Gujari -> Rajasthani
    LangTag { language: "gkp", 	tag: Tag::new(b"GKP ") }, // Guinea Kpelle -> Kpelle (Guinea)
    LangTag { language: "gkp", 	tag: Tag::new(b"KPL ") }, // Guinea Kpelle -> Kpelle
    LangTag { language: "gl", 	tag: Tag::new(b"GAL ") }, // Galician
    LangTag { language: "gld", 	tag: Tag::new(b"NAN ") }, // Nanai
//  LangTag { language: "glk", 	tag: Tag::new(b"GLK ") }, // Gilaki
    LangTag { language: "gmz", 	tag: Tag::new(&[0; 4]) }, // Mgbolizhia != Gumuz
    LangTag { language: "gn", 	tag: Tag::new(b"GUA ") }, // Guarani [macrolanguage]
    LangTag { language: "gnb", 	tag: Tag::new(b"QIN ") }, // Gangte -> Chin
//  LangTag { language: "gnn", 	tag: Tag::new(b"GNN ") }, // Gumatj
    LangTag { language: "gno", 	tag: Tag::new(b"GON ") }, // Northern Gondi -> Gondi
    LangTag { language: "gnw", 	tag: Tag::new(b"GUA ") }, // Western Bolivian Guaraní -> Guarani
//  LangTag { language: "gog", 	tag: Tag::new(b"GOG ") }, // Gogo
    LangTag { language: "gom", 	tag: Tag::new(b"KOK ") }, // Goan Konkani -> Konkani
//  LangTag { language: "gon", 	tag: Tag::new(b"GON ") }, // Gondi [macrolanguage]
    LangTag { language: "goq", 	tag: Tag::new(b"CPP ") }, // Gorap -> Creoles
    LangTag { language: "gox", 	tag: Tag::new(b"BAD0") }, // Gobu -> Banda
    LangTag { language: "gpe", 	tag: Tag::new(b"CPP ") }, // Ghanaian Pidgin English -> Creoles
    LangTag { language: "gro", 	tag: Tag::new(&[0; 4]) }, // Groma != Garo
    LangTag { language: "grr", 	tag: Tag::new(b"BBR ") }, // Taznatit -> Berber
    LangTag { language: "grt", 	tag: Tag::new(b"GRO ") }, // Garo
    LangTag { language: "gru", 	tag: Tag::new(b"SOG ") }, // Kistane -> Sodo Gurage
    LangTag { language: "gsw", 	tag: Tag::new(b"ALS ") }, // Alsatian
    LangTag { language: "gu", 	tag: Tag::new(b"GUJ ") }, // Gujarati
    LangTag { language: "gua", 	tag: Tag::new(&[0; 4]) }, // Shiki != Guarani
//  LangTag { language: "guc", 	tag: Tag::new(b"GUC ") }, // Wayuu
//  LangTag { language: "guf", 	tag: Tag::new(b"GUF ") }, // Gupapuyngu
    LangTag { language: "gug", 	tag: Tag::new(b"GUA ") }, // Paraguayan Guaraní -> Guarani
    LangTag { language: "gui", 	tag: Tag::new(b"GUA ") }, // Eastern Bolivian Guaraní -> Guarani
    LangTag { language: "guk", 	tag: Tag::new(b"GMZ ") }, // Gumuz
    LangTag { language: "gul", 	tag: Tag::new(b"CPP ") }, // Sea Island Creole English -> Creoles
    LangTag { language: "gun", 	tag: Tag::new(b"GUA ") }, // Mbyá Guaraní -> Guarani
//  LangTag { language: "guz", 	tag: Tag::new(b"GUZ ") }, // Gusii
    LangTag { language: "gv", 	tag: Tag::new(b"MNX ") }, // Manx
    LangTag { language: "gwi", 	tag: Tag::new(b"ATH ") }, // Gwichʼin -> Athapaskan
    LangTag { language: "gyn", 	tag: Tag::new(b"CPP ") }, // Guyanese Creole English -> Creoles
    LangTag { language: "ha", 	tag: Tag::new(b"HAU ") }, // Hausa
    LangTag { language: "haa", 	tag: Tag::new(b"ATH ") }, // Hän -> Athapaskan
    LangTag { language: "hae", 	tag: Tag::new(b"ORO ") }, // Eastern Oromo -> Oromo
    LangTag { language: "hai", 	tag: Tag::new(b"HAI0") }, // Haida [macrolanguage]
    LangTag { language: "hak", 	tag: Tag::new(b"ZHS ") }, // Hakka Chinese -> Chinese, Simplified
    LangTag { language: "hal", 	tag: Tag::new(&[0; 4]) }, // Halang != Halam (Falam Chin)
    LangTag { language: "har", 	tag: Tag::new(b"HRI ") }, // Harari
//  LangTag { language: "haw", 	tag: Tag::new(b"HAW ") }, // Hawaiian
    LangTag { language: "hax", 	tag: Tag::new(b"HAI0") }, // Southern Haida -> Haida
//  LangTag { language: "hay", 	tag: Tag::new(b"HAY ") }, // Haya
//  LangTag { language: "haz", 	tag: Tag::new(b"HAZ ") }, // Hazaragi
    LangTag { language: "hbn", 	tag: Tag::new(&[0; 4]) }, // Heiban != Hammer-Banna
    LangTag { language: "hca", 	tag: Tag::new(b"CPP ") }, // Andaman Creole Hindi -> Creoles
    LangTag { language: "hdn", 	tag: Tag::new(b"HAI0") }, // Northern Haida -> Haida
    LangTag { language: "he", 	tag: Tag::new(b"IWR ") }, // Hebrew
    LangTag { language: "hea", 	tag: Tag::new(b"HMN ") }, // Northern Qiandong Miao -> Hmong
//  LangTag { language: "hei", 	tag: Tag::new(b"HEI ") }, // Heiltsuk
    LangTag { language: "hi", 	tag: Tag::new(b"HIN ") }, // Hindi
//  LangTag { language: "hil", 	tag: Tag::new(b"HIL ") }, // Hiligaynon
    LangTag { language: "hji", 	tag: Tag::new(b"MLY ") }, // Haji -> Malay
    LangTag { language: "hlt", 	tag: Tag::new(b"QIN ") }, // Matu Chin -> Chin
    LangTag { language: "hma", 	tag: Tag::new(b"HMN ") }, // Southern Mashan Hmong -> Hmong
    LangTag { language: "hmc", 	tag: Tag::new(b"HMN ") }, // Central Huishui Hmong -> Hmong
    LangTag { language: "hmd", 	tag: Tag::new(b"HMD ") }, // Large Flowery Miao -> A-Hmao
    LangTag { language: "hmd", 	tag: Tag::new(b"HMN ") }, // Large Flowery Miao -> Hmong
    LangTag { language: "hme", 	tag: Tag::new(b"HMN ") }, // Eastern Huishui Hmong -> Hmong
    LangTag { language: "hmg", 	tag: Tag::new(b"HMN ") }, // Southwestern Guiyang Hmong -> Hmong
    LangTag { language: "hmh", 	tag: Tag::new(b"HMN ") }, // Southwestern Huishui Hmong -> Hmong
    LangTag { language: "hmi", 	tag: Tag::new(b"HMN ") }, // Northern Huishui Hmong -> Hmong
    LangTag { language: "hmj", 	tag: Tag::new(b"HMN ") }, // Ge -> Hmong
    LangTag { language: "hml", 	tag: Tag::new(b"HMN ") }, // Luopohe Hmong -> Hmong
    LangTag { language: "hmm", 	tag: Tag::new(b"HMN ") }, // Central Mashan Hmong -> Hmong
//  LangTag { language: "hmn", 	tag: Tag::new(b"HMN ") }, // Hmong [macrolanguage]
    LangTag { language: "hmp", 	tag: Tag::new(b"HMN ") }, // Northern Mashan Hmong -> Hmong
    LangTag { language: "hmq", 	tag: Tag::new(b"HMN ") }, // Eastern Qiandong Miao -> Hmong
    LangTag { language: "hmr", 	tag: Tag::new(b"QIN ") }, // Hmar -> Chin
    LangTag { language: "hms", 	tag: Tag::new(b"HMN ") }, // Southern Qiandong Miao -> Hmong
    LangTag { language: "hmw", 	tag: Tag::new(b"HMN ") }, // Western Mashan Hmong -> Hmong
    LangTag { language: "hmy", 	tag: Tag::new(b"HMN ") }, // Southern Guiyang Hmong -> Hmong
    LangTag { language: "hmz", 	tag: Tag::new(b"HMZ ") }, // Hmong Shua -> Hmong Shuat
    LangTag { language: "hmz", 	tag: Tag::new(b"HMN ") }, // Hmong Shua -> Hmong
//  LangTag { language: "hnd", 	tag: Tag::new(b"HND ") }, // Southern Hindko -> Hindko
    LangTag { language: "hne", 	tag: Tag::new(b"CHH ") }, // Chhattisgarhi -> Chattisgarhi
    LangTag { language: "hnj", 	tag: Tag::new(b"HMN ") }, // Hmong Njua -> Hmong
    LangTag { language: "hnm", 	tag: Tag::new(b"ZHS ") }, // Hainanese -> Chinese, Simplified
    LangTag { language: "hno", 	tag: Tag::new(b"HND ") }, // Northern Hindko -> Hindko
    LangTag { language: "ho", 	tag: Tag::new(b"HMO ") }, // Hiri Motu
    LangTag { language: "ho", 	tag: Tag::new(b"CPP ") }, // Hiri Motu -> Creoles
    LangTag { language: "hoc", 	tag: Tag::new(b"HO  ") }, // Ho
    LangTag { language: "hoi", 	tag: Tag::new(b"ATH ") }, // Holikachuk -> Athapaskan
    LangTag { language: "hoj", 	tag: Tag::new(b"HAR ") }, // Hadothi -> Harauti
    LangTag { language: "hoj", 	tag: Tag::new(b"RAJ ") }, // Hadothi -> Rajasthani
    LangTag { language: "hr", 	tag: Tag::new(b"HRV ") }, // Croatian
    LangTag { language: "hra", 	tag: Tag::new(b"QIN ") }, // Hrangkhol -> Chin
    LangTag { language: "hrm", 	tag: Tag::new(b"HMN ") }, // Horned Miao -> Hmong
    LangTag { language: "hsb", 	tag: Tag::new(b"USB ") }, // Upper Sorbian
    LangTag { language: "hsn", 	tag: Tag::new(b"ZHS ") }, // Xiang Chinese -> Chinese, Simplified
    LangTag { language: "ht", 	tag: Tag::new(b"HAI ") }, // Haitian (Haitian Creole)
    LangTag { language: "ht", 	tag: Tag::new(b"CPP ") }, // Haitian -> Creoles
    LangTag { language: "hu", 	tag: Tag::new(b"HUN ") }, // Hungarian
    LangTag { language: "huj", 	tag: Tag::new(b"HMN ") }, // Northern Guiyang Hmong -> Hmong
    LangTag { language: "hup", 	tag: Tag::new(b"ATH ") }, // Hupa -> Athapaskan
//  LangTag { language: "hur", 	tag: Tag::new(b"HUR ") }, // Halkomelem
    LangTag { language: "hus", 	tag: Tag::new(b"MYN ") }, // Huastec -> Mayan
    LangTag { language: "hwc", 	tag: Tag::new(b"CPP ") }, // Hawai'i Creole English -> Creoles
    LangTag { language: "hy", 	tag: Tag::new(b"HYE0") }, // Armenian -> Armenian East
    LangTag { language: "hy", 	tag: Tag::new(b"HYE ") }, // Armenian
    LangTag { language: "hyw", 	tag: Tag::new(b"HYE ") }, // Western Armenian -> Armenian
    LangTag { language: "hz", 	tag: Tag::new(b"HER ") }, // Herero
    LangTag { language: "ia", 	tag: Tag::new(b"INA ") }, // Interlingua (International Auxiliary Language Association)
//  LangTag { language: "iba", 	tag: Tag::new(b"IBA ") }, // Iban
//  LangTag { language: "ibb", 	tag: Tag::new(b"IBB ") }, // Ibibio
    LangTag { language: "iby", 	tag: Tag::new(b"IJO ") }, // Ibani -> Ijo
    LangTag { language: "icr", 	tag: Tag::new(b"CPP ") }, // Islander Creole English -> Creoles
    LangTag { language: "id", 	tag: Tag::new(b"IND ") }, // Indonesian
    LangTag { language: "id", 	tag: Tag::new(b"MLY ") }, // Indonesian -> Malay
    LangTag { language: "ida", 	tag: Tag::new(b"LUH ") }, // Idakho-Isukha-Tiriki -> Luyia
    LangTag { language: "idb", 	tag: Tag::new(b"CPP ") }, // Indo-Portuguese -> Creoles
    LangTag { language: "ie", 	tag: Tag::new(b"ILE ") }, // Interlingue
    LangTag { language: "ig", 	tag: Tag::new(b"IBO ") }, // Igbo
    LangTag { language: "igb", 	tag: Tag::new(b"EBI ") }, // Ebira
    LangTag { language: "ihb", 	tag: Tag::new(b"CPP ") }, // Iha Based Pidgin -> Creoles
    LangTag { language: "ii", 	tag: Tag::new(b"YIM ") }, // Sichuan Yi -> Yi Modern
    LangTag { language: "ijc", 	tag: Tag::new(b"IJO ") }, // Izon -> Ijo
    LangTag { language: "ije", 	tag: Tag::new(b"IJO ") }, // Biseni -> Ijo
    LangTag { language: "ijn", 	tag: Tag::new(b"IJO ") }, // Kalabari -> Ijo
//  LangTag { language: "ijo", 	tag: Tag::new(b"IJO ") }, // Ijo  [collection]
    LangTag { language: "ijs", 	tag: Tag::new(b"IJO ") }, // Southeast Ijo -> Ijo
    LangTag { language: "ik", 	tag: Tag::new(b"IPK ") }, // Inupiaq [macrolanguage] -> Inupiat
    LangTag { language: "ike", 	tag: Tag::new(b"INU ") }, // Eastern Canadian Inuktitut -> Inuktitut
    LangTag { language: "ike", 	tag: Tag::new(b"INUK") }, // Eastern Canadian Inuktitut -> Nunavik Inuktitut
    LangTag { language: "ikt", 	tag: Tag::new(b"INU ") }, // Inuinnaqtun -> Inuktitut
//  LangTag { language: "ilo", 	tag: Tag::new(b"ILO ") }, // Iloko -> Ilokano
    LangTag { language: "in", 	tag: Tag::new(b"IND ") }, // Indonesian(retired code)
    LangTag { language: "in", 	tag: Tag::new(b"MLY ") }, // Indonesian(retired code) -> Malay
    LangTag { language: "ing", 	tag: Tag::new(b"ATH ") }, // Degexit'an -> Athapaskan
    LangTag { language: "inh", 	tag: Tag::new(b"ING ") }, // Ingush
    LangTag { language: "io", 	tag: Tag::new(b"IDO ") }, // Ido
    LangTag { language: "iri", 	tag: Tag::new(&[0; 4]) }, // Rigwe != Irish
//  LangTag { language: "iru", 	tag: Tag::new(b"IRU ") }, // Irula
    LangTag { language: "is", 	tag: Tag::new(b"ISL ") }, // Icelandic
    LangTag { language: "ism", 	tag: Tag::new(&[0; 4]) }, // Masimasi != Inari Sami
    LangTag { language: "it", 	tag: Tag::new(b"ITA ") }, // Italian
    LangTag { language: "itz", 	tag: Tag::new(b"MYN ") }, // Itzá -> Mayan
    LangTag { language: "iu", 	tag: Tag::new(b"INU ") }, // Inuktitut [macrolanguage]
    LangTag { language: "iu", 	tag: Tag::new(b"INUK") }, // Inuktitut [macrolanguage] -> Nunavik Inuktitut
    LangTag { language: "iw", 	tag: Tag::new(b"IWR ") }, // Hebrew(retired code)
    LangTag { language: "ixl", 	tag: Tag::new(b"MYN ") }, // Ixil -> Mayan
    LangTag { language: "ja", 	tag: Tag::new(b"JAN ") }, // Japanese
    LangTag { language: "jac", 	tag: Tag::new(b"MYN ") }, // Popti' -> Mayan
    LangTag { language: "jak", 	tag: Tag::new(b"MLY ") }, // Jakun -> Malay
    LangTag { language: "jam", 	tag: Tag::new(b"JAM ") }, // Jamaican Creole English -> Jamaican Creole
    LangTag { language: "jam", 	tag: Tag::new(b"CPP ") }, // Jamaican Creole English -> Creoles
    LangTag { language: "jan", 	tag: Tag::new(&[0; 4]) }, // Jandai != Japanese
    LangTag { language: "jax", 	tag: Tag::new(b"MLY ") }, // Jambi Malay -> Malay
    LangTag { language: "jbe", 	tag: Tag::new(b"BBR ") }, // Judeo-Berber -> Berber
    LangTag { language: "jbn", 	tag: Tag::new(b"BBR ") }, // Nafusi -> Berber
//  LangTag { language: "jbo", 	tag: Tag::new(b"JBO ") }, // Lojban
//  LangTag { language: "jct", 	tag: Tag::new(b"JCT ") }, // Krymchak
//  LangTag { language: "jdt", 	tag: Tag::new(b"JDT ") }, // Judeo-Tat
    LangTag { language: "jgo", 	tag: Tag::new(b"BML ") }, // Ngomba -> Bamileke
    LangTag { language: "ji", 	tag: Tag::new(b"JII ") }, // Yiddish(retired code)
    LangTag { language: "jii", 	tag: Tag::new(&[0; 4]) }, // Jiiddu != Yiddish
    LangTag { language: "jkm", 	tag: Tag::new(b"KRN ") }, // Mobwa Karen -> Karen
    LangTag { language: "jkp", 	tag: Tag::new(b"KRN ") }, // Paku Karen -> Karen
    LangTag { language: "jud", 	tag: Tag::new(&[0; 4]) }, // Worodougou != Ladino
    LangTag { language: "jul", 	tag: Tag::new(&[0; 4]) }, // Jirel != Jula
    LangTag { language: "jv", 	tag: Tag::new(b"JAV ") }, // Javanese
    LangTag { language: "jvd", 	tag: Tag::new(b"CPP ") }, // Javindo -> Creoles
    LangTag { language: "jw", 	tag: Tag::new(b"JAV ") }, // Javanese(retired code)
    LangTag { language: "ka", 	tag: Tag::new(b"KAT ") }, // Georgian
    LangTag { language: "kaa", 	tag: Tag::new(b"KRK ") }, // Karakalpak
    LangTag { language: "kab", 	tag: Tag::new(b"KAB0") }, // Kabyle
    LangTag { language: "kab", 	tag: Tag::new(b"BBR ") }, // Kabyle -> Berber
    LangTag { language: "kac", 	tag: Tag::new(&[0; 4]) }, // Kachin != Kachchi
    LangTag { language: "kam", 	tag: Tag::new(b"KMB ") }, // Kamba (Kenya)
    LangTag { language: "kar", 	tag: Tag::new(b"KRN ") }, // Karen  [collection]
//  LangTag { language: "kaw", 	tag: Tag::new(b"KAW ") }, // Kawi (Old Javanese)
//  LangTag { language: "kbc", 	tag: Tag::new(b"KBC ") }, // Kadiwéu
    LangTag { language: "kbd", 	tag: Tag::new(b"KAB ") }, // Kabardian
    LangTag { language: "kby", 	tag: Tag::new(b"KNR ") }, // Manga Kanuri -> Kanuri
    LangTag { language: "kca", 	tag: Tag::new(b"KHK ") }, // Khanty -> Khanty-Kazim
    LangTag { language: "kca", 	tag: Tag::new(b"KHS ") }, // Khanty -> Khanty-Shurishkar
    LangTag { language: "kca", 	tag: Tag::new(b"KHV ") }, // Khanty -> Khanty-Vakhi
    LangTag { language: "kcn", 	tag: Tag::new(b"CPP ") }, // Nubi -> Creoles
//  LangTag { language: "kde", 	tag: Tag::new(b"KDE ") }, // Makonde
    LangTag { language: "kdr", 	tag: Tag::new(b"KRM ") }, // Karaim
    LangTag { language: "kdt", 	tag: Tag::new(b"KUY ") }, // Kuy
    LangTag { language: "kea", 	tag: Tag::new(b"KEA ") }, // Kabuverdianu (Crioulo)
    LangTag { language: "kea", 	tag: Tag::new(b"CPP ") }, // Kabuverdianu -> Creoles
    LangTag { language: "keb", 	tag: Tag::new(&[0; 4]) }, // Kélé != Kebena
    LangTag { language: "kek", 	tag: Tag::new(b"KEK ") }, // Kekchi
    LangTag { language: "kek", 	tag: Tag::new(b"MYN ") }, // Kekchí -> Mayan
    LangTag { language: "kex", 	tag: Tag::new(b"KKN ") }, // Kukna -> Kokni
    LangTag { language: "kfa", 	tag: Tag::new(b"KOD ") }, // Kodava -> Kodagu
    LangTag { language: "kfr", 	tag: Tag::new(b"KAC ") }, // Kachhi -> Kachchi
    LangTag { language: "kfx", 	tag: Tag::new(b"KUL ") }, // Kullu Pahari -> Kulvi
    LangTag { language: "kfy", 	tag: Tag::new(b"KMN ") }, // Kumaoni
    LangTag { language: "kg", 	tag: Tag::new(b"KON0") }, // Kongo [macrolanguage]
    LangTag { language: "kge", 	tag: Tag::new(&[0; 4]) }, // Komering != Khutsuri Georgian
//  LangTag { language: "kgf", 	tag: Tag::new(b"KGF ") }, // Kube
    LangTag { language: "kha", 	tag: Tag::new(b"KSI ") }, // Khasi
    LangTag { language: "khb", 	tag: Tag::new(b"XBD ") }, // Lü
    LangTag { language: "khk", 	tag: Tag::new(b"MNG ") }, // Halh Mongolian -> Mongolian
    LangTag { language: "khn", 	tag: Tag::new(&[0; 4]) }, // Khandesi != Khamti Shan(Microsoft fonts)
    LangTag { language: "khs", 	tag: Tag::new(&[0; 4]) }, // Kasua != Khanty-Shurishkar
    LangTag { language: "kht", 	tag: Tag::new(b"KHT ") }, // Khamti -> Khamti Shan
    LangTag { language: "kht", 	tag: Tag::new(b"KHN ") }, // Khamti -> Khamti Shan(Microsoft fonts)
    LangTag { language: "khv", 	tag: Tag::new(&[0; 4]) }, // Khvarshi != Khanty-Vakhi
//  LangTag { language: "khw", 	tag: Tag::new(b"KHW ") }, // Khowar
    LangTag { language: "ki", 	tag: Tag::new(b"KIK ") }, // Kikuyu (Gikuyu)
    LangTag { language: "kis", 	tag: Tag::new(&[0; 4]) }, // Kis != Kisii
    LangTag { language: "kiu", 	tag: Tag::new(b"KIU ") }, // Kirmanjki 
    LangTag { language: "kiu", 	tag: Tag::new(b"ZZA ") }, // Kirmanjki  -> Zazaki
    LangTag { language: "kj", 	tag: Tag::new(b"KUA ") }, // Kuanyama
    LangTag { language: "kjb", 	tag: Tag::new(b"MYN ") }, // Q'anjob'al -> Mayan
//  LangTag { language: "kjd", 	tag: Tag::new(b"KJD ") }, // Southern Kiwai
    LangTag { language: "kjh", 	tag: Tag::new(b"KHA ") }, // Khakas -> Khakass
//  LangTag { language: "kjj", 	tag: Tag::new(b"KJJ ") }, // Khinalugh -> Khinalug
    LangTag { language: "kjp", 	tag: Tag::new(b"KJP ") }, // Pwo Eastern Karen -> Eastern Pwo Karen
    LangTag { language: "kjp", 	tag: Tag::new(b"KRN ") }, // Pwo Eastern Karen -> Karen
    LangTag { language: "kjt", 	tag: Tag::new(b"KRN ") }, // Phrae Pwo Karen -> Karen
//  LangTag { language: "kjz", 	tag: Tag::new(b"KJZ ") }, // Bumthangkha
    LangTag { language: "kk", 	tag: Tag::new(b"KAZ ") }, // Kazakh
    LangTag { language: "kkn", 	tag: Tag::new(&[0; 4]) }, // Kon Keu != Kokni
    LangTag { language: "kkz", 	tag: Tag::new(b"ATH ") }, // Kaska -> Athapaskan
    LangTag { language: "kl", 	tag: Tag::new(b"GRN ") }, // Greenlandic
    LangTag { language: "klm", 	tag: Tag::new(&[0; 4]) }, // Migum != Kalmyk
    LangTag { language: "kln", 	tag: Tag::new(b"KAL ") }, // Kalenjin [macrolanguage]
    LangTag { language: "km", 	tag: Tag::new(b"KHM ") }, // Khmer
    LangTag { language: "kmb", 	tag: Tag::new(b"MBN ") }, // Kimbundu -> Mbundu
//  LangTag { language: "kmg", 	tag: Tag::new(b"KMG ") }, // Kâte
    LangTag { language: "kmn", 	tag: Tag::new(&[0; 4]) }, // Awtuw != Kumaoni
    LangTag { language: "kmo", 	tag: Tag::new(&[0; 4]) }, // Kwoma != Komo
    LangTag { language: "kmr", 	tag: Tag::new(b"KUR ") }, // Northern Kurdish -> Kurdish
    LangTag { language: "kms", 	tag: Tag::new(&[0; 4]) }, // Kamasau != Komso
    LangTag { language: "kmv", 	tag: Tag::new(b"CPP ") }, // Karipúna Creole French -> Creoles
    LangTag { language: "kmw", 	tag: Tag::new(b"KMO ") }, // Komo (Democratic Republic of Congo)
//  LangTag { language: "kmz", 	tag: Tag::new(b"KMZ ") }, // Khorasani Turkish -> Khorasani Turkic
    LangTag { language: "kn", 	tag: Tag::new(b"KAN ") }, // Kannada
    LangTag { language: "knc", 	tag: Tag::new(b"KNR ") }, // Central Kanuri -> Kanuri
    LangTag { language: "kng", 	tag: Tag::new(b"KON0") }, // Koongo -> Kongo
    LangTag { language: "knj", 	tag: Tag::new(b"MYN ") }, // Western Kanjobal -> Mayan
    LangTag { language: "knn", 	tag: Tag::new(b"KOK ") }, // Konkani 
    LangTag { language: "knr", 	tag: Tag::new(&[0; 4]) }, // Kaningra != Kanuri
    LangTag { language: "ko", 	tag: Tag::new(b"KOR ") }, // Korean
    LangTag { language: "ko", 	tag: Tag::new(b"KOH ") }, // Korean -> Korean Old Hangul
    LangTag { language: "kod", 	tag: Tag::new(&[0; 4]) }, // Kodi != Kodagu
    LangTag { language: "koh", 	tag: Tag::new(&[0; 4]) }, // Koyo != Korean Old Hangul
    LangTag { language: "koi", 	tag: Tag::new(b"KOP ") }, // Komi-Permyak
    LangTag { language: "koi", 	tag: Tag::new(b"KOM ") }, // Komi-Permyak -> Komi
//  LangTag { language: "kok", 	tag: Tag::new(b"KOK ") }, // Konkani  [macrolanguage]
    LangTag { language: "kop", 	tag: Tag::new(&[0; 4]) }, // Waube != Komi-Permyak
//  LangTag { language: "kos", 	tag: Tag::new(b"KOS ") }, // Kosraean
    LangTag { language: "koy", 	tag: Tag::new(b"ATH ") }, // Koyukon -> Athapaskan
    LangTag { language: "koz", 	tag: Tag::new(&[0; 4]) }, // Korak != Komi-Zyrian
    LangTag { language: "kpe", 	tag: Tag::new(b"KPL ") }, // Kpelle [macrolanguage]
    LangTag { language: "kpl", 	tag: Tag::new(&[0; 4]) }, // Kpala != Kpelle
    LangTag { language: "kpp", 	tag: Tag::new(b"KRN ") }, // Paku Karen(retired code) -> Karen
    LangTag { language: "kpv", 	tag: Tag::new(b"KOZ ") }, // Komi-Zyrian
    LangTag { language: "kpv", 	tag: Tag::new(b"KOM ") }, // Komi-Zyrian -> Komi
    LangTag { language: "kpy", 	tag: Tag::new(b"KYK ") }, // Koryak
    LangTag { language: "kqs", 	tag: Tag::new(b"KIS ") }, // Northern Kissi -> Kisii
    LangTag { language: "kqy", 	tag: Tag::new(b"KRT ") }, // Koorete
    LangTag { language: "kr", 	tag: Tag::new(b"KNR ") }, // Kanuri [macrolanguage]
    LangTag { language: "krc", 	tag: Tag::new(b"KAR ") }, // Karachay-Balkar -> Karachay
    LangTag { language: "krc", 	tag: Tag::new(b"BAL ") }, // Karachay-Balkar -> Balkar
    LangTag { language: "kri", 	tag: Tag::new(b"KRI ") }, // Krio
    LangTag { language: "kri", 	tag: Tag::new(b"CPP ") }, // Krio -> Creoles
    LangTag { language: "krk", 	tag: Tag::new(&[0; 4]) }, // Kerek != Karakalpak
//  LangTag { language: "krl", 	tag: Tag::new(b"KRL ") }, // Karelian
    LangTag { language: "krm", 	tag: Tag::new(&[0; 4]) }, // Krim(retired code) != Karaim
    LangTag { language: "krn", 	tag: Tag::new(&[0; 4]) }, // Sapo != Karen
    LangTag { language: "krt", 	tag: Tag::new(b"KNR ") }, // Tumari Kanuri -> Kanuri
    LangTag { language: "kru", 	tag: Tag::new(b"KUU ") }, // Kurukh
    LangTag { language: "ks", 	tag: Tag::new(b"KSH ") }, // Kashmiri
    LangTag { language: "ksh", 	tag: Tag::new(b"KSH0") }, // Kölsch -> Ripuarian
    LangTag { language: "ksi", 	tag: Tag::new(&[0; 4]) }, // Krisa != Khasi
    LangTag { language: "ksm", 	tag: Tag::new(&[0; 4]) }, // Kumba != Kildin Sami
    LangTag { language: "kss", 	tag: Tag::new(b"KIS ") }, // Southern Kisi -> Kisii
//  LangTag { language: "ksu", 	tag: Tag::new(b"KSU ") }, // Khamyang
    LangTag { language: "ksw", 	tag: Tag::new(b"KSW ") }, // S’gaw Karen
    LangTag { language: "ksw", 	tag: Tag::new(b"KRN ") }, // S'gaw Karen -> Karen
    LangTag { language: "ktb", 	tag: Tag::new(b"KEB ") }, // Kambaata -> Kebena
    LangTag { language: "ktu", 	tag: Tag::new(b"KON ") }, // Kituba (Democratic Republic of Congo) -> Kikongo
    LangTag { language: "ktw", 	tag: Tag::new(b"ATH ") }, // Kato -> Athapaskan
    LangTag { language: "ku", 	tag: Tag::new(b"KUR ") }, // Kurdish [macrolanguage]
    LangTag { language: "kui", 	tag: Tag::new(&[0; 4]) }, // Kuikúro-Kalapálo != Kui
    LangTag { language: "kul", 	tag: Tag::new(&[0; 4]) }, // Kulere != Kulvi
//  LangTag { language: "kum", 	tag: Tag::new(b"KUM ") }, // Kumyk
    LangTag { language: "kuu", 	tag: Tag::new(b"ATH ") }, // Upper Kuskokwim -> Athapaskan
    LangTag { language: "kuw", 	tag: Tag::new(b"BAD0") }, // Kpagua -> Banda
    LangTag { language: "kuy", 	tag: Tag::new(&[0; 4]) }, // Kuuku-Ya'u != Kuy
    LangTag { language: "kv", 	tag: Tag::new(b"KOM ") }, // Komi [macrolanguage]
    LangTag { language: "kvb", 	tag: Tag::new(b"MLY ") }, // Kubu -> Malay
    LangTag { language: "kvl", 	tag: Tag::new(b"KRN ") }, // Kayaw -> Karen
    LangTag { language: "kvq", 	tag: Tag::new(b"KVQ ") }, // Geba Karen
    LangTag { language: "kvq", 	tag: Tag::new(b"KRN ") }, // Geba Karen -> Karen
    LangTag { language: "kvr", 	tag: Tag::new(b"MLY ") }, // Kerinci -> Malay
    LangTag { language: "kvt", 	tag: Tag::new(b"KRN ") }, // Lahta Karen -> Karen
    LangTag { language: "kvu", 	tag: Tag::new(b"KRN ") }, // Yinbaw Karen -> Karen
    LangTag { language: "kvy", 	tag: Tag::new(b"KRN ") }, // Yintale Karen -> Karen
    LangTag { language: "kw", 	tag: Tag::new(b"COR ") }, // Cornish
//  LangTag { language: "kwk", 	tag: Tag::new(b"KWK ") }, // Kwak'wala -> Kwakʼwala
    LangTag { language: "kww", 	tag: Tag::new(b"CPP ") }, // Kwinti -> Creoles
    LangTag { language: "kwy", 	tag: Tag::new(b"KON0") }, // San Salvador Kongo -> Kongo
    LangTag { language: "kxc", 	tag: Tag::new(b"KMS ") }, // Konso -> Komso
    LangTag { language: "kxd", 	tag: Tag::new(b"MLY ") }, // Brunei -> Malay
    LangTag { language: "kxf", 	tag: Tag::new(b"KRN ") }, // Manumanaw Karen -> Karen
    LangTag { language: "kxk", 	tag: Tag::new(b"KRN ") }, // Zayein Karen -> Karen
    LangTag { language: "kxl", 	tag: Tag::new(b"KUU ") }, // Nepali Kurux(retired code) -> Kurukh
    LangTag { language: "kxu", 	tag: Tag::new(b"KUI ") }, // Kui (India)(retired code)
    LangTag { language: "ky", 	tag: Tag::new(b"KIR ") }, // Kirghiz (Kyrgyz)
    LangTag { language: "kyk", 	tag: Tag::new(&[0; 4]) }, // Kamayo != Koryak
    LangTag { language: "kyu", 	tag: Tag::new(b"KYU ") }, // Western Kayah
    LangTag { language: "kyu", 	tag: Tag::new(b"KRN ") }, // Western Kayah -> Karen
    LangTag { language: "la", 	tag: Tag::new(b"LAT ") }, // Latin
    LangTag { language: "lac", 	tag: Tag::new(b"MYN ") }, // Lacandon -> Mayan
    LangTag { language: "lad", 	tag: Tag::new(b"JUD ") }, // Ladino
    LangTag { language: "lah", 	tag: Tag::new(&[0; 4]) }, // Lahnda [macrolanguage] != Lahuli
    LangTag { language: "lak", 	tag: Tag::new(&[0; 4]) }, // Laka (Nigeria)(retired code) != Lak
    LangTag { language: "lam", 	tag: Tag::new(&[0; 4]) }, // Lamba != Lambani
    LangTag { language: "laz", 	tag: Tag::new(&[0; 4]) }, // Aribwatsa != Laz
    LangTag { language: "lb", 	tag: Tag::new(b"LTZ ") }, // Luxembourgish
    LangTag { language: "lbe", 	tag: Tag::new(b"LAK ") }, // Lak
    LangTag { language: "lbj", 	tag: Tag::new(b"LDK ") }, // Ladakhi
    LangTag { language: "lbl", 	tag: Tag::new(b"BIK ") }, // Libon Bikol -> Bikol
    LangTag { language: "lce", 	tag: Tag::new(b"MLY ") }, // Loncong -> Malay
    LangTag { language: "lcf", 	tag: Tag::new(b"MLY ") }, // Lubu -> Malay
    LangTag { language: "ldi", 	tag: Tag::new(b"KON0") }, // Laari -> Kongo
    LangTag { language: "ldk", 	tag: Tag::new(&[0; 4]) }, // Leelau != Ladakhi
//  LangTag { language: "lef", 	tag: Tag::new(b"LEF ") }, // Lelemi
//  LangTag { language: "lez", 	tag: Tag::new(b"LEZ ") }, // Lezghian -> Lezgi
    LangTag { language: "lg", 	tag: Tag::new(b"LUG ") }, // Ganda
    LangTag { language: "li", 	tag: Tag::new(b"LIM ") }, // Limburgish
    LangTag { language: "lif", 	tag: Tag::new(b"LMB ") }, // Limbu
//  LangTag { language: "lij", 	tag: Tag::new(b"LIJ ") }, // Ligurian
    LangTag { language: "lir", 	tag: Tag::new(b"CPP ") }, // Liberian English -> Creoles
//  LangTag { language: "lis", 	tag: Tag::new(b"LIS ") }, // Lisu
//  LangTag { language: "liv", 	tag: Tag::new(b"LIV ") }, // Liv
    LangTag { language: "liw", 	tag: Tag::new(b"MLY ") }, // Col -> Malay
    LangTag { language: "liy", 	tag: Tag::new(b"BAD0") }, // Banda-Bambari -> Banda
//  LangTag { language: "ljp", 	tag: Tag::new(b"LJP ") }, // Lampung Api -> Lampung
    LangTag { language: "lkb", 	tag: Tag::new(b"LUH ") }, // Kabras -> Luyia
//  LangTag { language: "lki", 	tag: Tag::new(b"LKI ") }, // Laki
    LangTag { language: "lko", 	tag: Tag::new(b"LUH ") }, // Khayo -> Luyia
    LangTag { language: "lks", 	tag: Tag::new(b"LUH ") }, // Kisa -> Luyia
    LangTag { language: "lld", 	tag: Tag::new(b"LAD ") }, // Ladin
    LangTag { language: "lma", 	tag: Tag::new(&[0; 4]) }, // East Limba != Low Mari
    LangTag { language: "lmb", 	tag: Tag::new(&[0; 4]) }, // Merei != Limbu
    LangTag { language: "lmn", 	tag: Tag::new(b"LAM ") }, // Lambadi -> Lambani
//  LangTag { language: "lmo", 	tag: Tag::new(b"LMO ") }, // Lombard
    LangTag { language: "lmw", 	tag: Tag::new(&[0; 4]) }, // Lake Miwok != Lomwe
    LangTag { language: "ln", 	tag: Tag::new(b"LIN ") }, // Lingala
    LangTag { language: "lna", 	tag: Tag::new(b"BAD0") }, // Langbashe -> Banda
    LangTag { language: "lnl", 	tag: Tag::new(b"BAD0") }, // South Central Banda -> Banda
    LangTag { language: "lo", 	tag: Tag::new(b"LAO ") }, // Lao
//  LangTag { language: "lom", 	tag: Tag::new(b"LOM ") }, // Loma (Liberia)
    LangTag { language: "lou", 	tag: Tag::new(b"CPP ") }, // Louisiana Creole -> Creoles
//  LangTag { language: "lpo", 	tag: Tag::new(b"LPO ") }, // Lipo
//  LangTag { language: "lrc", 	tag: Tag::new(b"LRC ") }, // Northern Luri -> Luri
    LangTag { language: "lri", 	tag: Tag::new(b"LUH ") }, // Marachi -> Luyia
    LangTag { language: "lrm", 	tag: Tag::new(b"LUH ") }, // Marama -> Luyia
    LangTag { language: "lrt", 	tag: Tag::new(b"CPP ") }, // Larantuka Malay -> Creoles
    LangTag { language: "lsb", 	tag: Tag::new(&[0; 4]) }, // Burundian Sign Language != Lower Sorbian
    LangTag { language: "lsm", 	tag: Tag::new(b"LUH ") }, // Saamia -> Luyia
    LangTag { language: "lt", 	tag: Tag::new(b"LTH ") }, // Lithuanian
    LangTag { language: "ltg", 	tag: Tag::new(b"LVI ") }, // Latgalian -> Latvian
    LangTag { language: "lth", 	tag: Tag::new(&[0; 4]) }, // Thur != Lithuanian
    LangTag { language: "lto", 	tag: Tag::new(b"LUH ") }, // Tsotso -> Luyia
    LangTag { language: "lts", 	tag: Tag::new(b"LUH ") }, // Tachoni -> Luyia
    LangTag { language: "lu", 	tag: Tag::new(b"LUB ") }, // Luba-Katanga
//  LangTag { language: "lua", 	tag: Tag::new(b"LUA ") }, // Luba-Lulua
    LangTag { language: "luh", 	tag: Tag::new(b"ZHS ") }, // Leizhou Chinese -> Chinese, Simplified
//  LangTag { language: "luo", 	tag: Tag::new(b"LUO ") }, // Luo (Kenya and Tanzania)
    LangTag { language: "lus", 	tag: Tag::new(b"MIZ ") }, // Lushai -> Mizo
    LangTag { language: "lus", 	tag: Tag::new(b"QIN ") }, // Lushai -> Chin
//  LangTag { language: "lut", 	tag: Tag::new(b"LUT ") }, // Lushootseed
    LangTag { language: "luy", 	tag: Tag::new(b"LUH ") }, // Luyia [macrolanguage]
    LangTag { language: "luz", 	tag: Tag::new(b"LRC ") }, // Southern Luri -> Luri
    LangTag { language: "lv", 	tag: Tag::new(b"LVI ") }, // Latvian [macrolanguage]
    LangTag { language: "lvi", 	tag: Tag::new(&[0; 4]) }, // Lavi != Latvian
    LangTag { language: "lvs", 	tag: Tag::new(b"LVI ") }, // Standard Latvian -> Latvian
    LangTag { language: "lwg", 	tag: Tag::new(b"LUH ") }, // Wanga -> Luyia
    LangTag { language: "lzh", 	tag: Tag::new(b"ZHT ") }, // Literary Chinese -> Chinese, Traditional
    LangTag { language: "lzz", 	tag: Tag::new(b"LAZ ") }, // Laz
//  LangTag { language: "mad", 	tag: Tag::new(b"MAD ") }, // Madurese -> Madura
//  LangTag { language: "mag", 	tag: Tag::new(b"MAG ") }, // Magahi
    LangTag { language: "mai", 	tag: Tag::new(b"MTH ") }, // Maithili
    LangTag { language: "maj", 	tag: Tag::new(&[0; 4]) }, // Jalapa De Díaz Mazatec != Majang
    LangTag { language: "mak", 	tag: Tag::new(b"MKR ") }, // Makasar
    LangTag { language: "mam", 	tag: Tag::new(b"MAM ") }, // Mam
    LangTag { language: "mam", 	tag: Tag::new(b"MYN ") }, // Mam -> Mayan
    LangTag { language: "man", 	tag: Tag::new(b"MNK ") }, // Mandingo [macrolanguage] -> Maninka
    LangTag { language: "map", 	tag: Tag::new(&[0; 4]) }, // Austronesian  [collection] != Mapudungun
    LangTag { language: "maw", 	tag: Tag::new(&[0; 4]) }, // Mampruli != Marwari
    LangTag { language: "max", 	tag: Tag::new(b"MLY ") }, // North Moluccan Malay -> Malay
    LangTag { language: "max", 	tag: Tag::new(b"CPP ") }, // North Moluccan Malay -> Creoles
    LangTag { language: "mbf", 	tag: Tag::new(b"CPP ") }, // Baba Malay -> Creoles
    LangTag { language: "mbn", 	tag: Tag::new(&[0; 4]) }, // Macaguán != Mbundu
//  LangTag { language: "mbo", 	tag: Tag::new(b"MBO ") }, // Mbo (Cameroon)
    LangTag { language: "mch", 	tag: Tag::new(&[0; 4]) }, // Maquiritari != Manchu
    LangTag { language: "mcm", 	tag: Tag::new(b"CPP ") }, // Malaccan Creole Portuguese -> Creoles
    LangTag { language: "mcr", 	tag: Tag::new(&[0; 4]) }, // Menya != Moose Cree
    LangTag { language: "mct", 	tag: Tag::new(b"BTI ") }, // Mengisa -> Beti
    LangTag { language: "mde", 	tag: Tag::new(&[0; 4]) }, // Maba (Chad) != Mende
    LangTag { language: "mdf", 	tag: Tag::new(b"MOK ") }, // Moksha
//  LangTag { language: "mdr", 	tag: Tag::new(b"MDR ") }, // Mandar
    LangTag { language: "mdy", 	tag: Tag::new(b"MLE ") }, // Male (Ethiopia)
    LangTag { language: "men", 	tag: Tag::new(b"MDE ") }, // Mende (Sierra Leone)
    LangTag { language: "meo", 	tag: Tag::new(b"MLY ") }, // Kedah Malay -> Malay
//  LangTag { language: "mer", 	tag: Tag::new(b"MER ") }, // Meru
//  LangTag { language: "mev", 	tag: Tag::new(b"MEV ") }, // Mano
    LangTag { language: "mfa", 	tag: Tag::new(b"MFA ") }, // Pattani Malay
    LangTag { language: "mfa", 	tag: Tag::new(b"MLY ") }, // Pattani Malay -> Malay
    LangTag { language: "mfb", 	tag: Tag::new(b"MLY ") }, // Bangka -> Malay
    LangTag { language: "mfe", 	tag: Tag::new(b"MFE ") }, // Morisyen
    LangTag { language: "mfe", 	tag: Tag::new(b"CPP ") }, // Morisyen -> Creoles
    LangTag { language: "mfp", 	tag: Tag::new(b"CPP ") }, // Makassar Malay -> Creoles
    LangTag { language: "mg", 	tag: Tag::new(b"MLG ") }, // Malagasy [macrolanguage]
    LangTag { language: "mga", 	tag: Tag::new(b"SGA ") }, // Middle Irish (900-1200) -> Old Irish
    LangTag { language: "mh", 	tag: Tag::new(b"MAH ") }, // Marshallese
    LangTag { language: "mhc", 	tag: Tag::new(b"MYN ") }, // Mocho -> Mayan
    LangTag { language: "mhr", 	tag: Tag::new(b"LMA ") }, // Eastern Mari -> Low Mari
    LangTag { language: "mhv", 	tag: Tag::new(b"ARK ") }, // Arakanese(retired code) -> Rakhine
    LangTag { language: "mi", 	tag: Tag::new(b"MRI ") }, // Maori
    LangTag { language: "min", 	tag: Tag::new(b"MIN ") }, // Minangkabau
    LangTag { language: "min", 	tag: Tag::new(b"MLY ") }, // Minangkabau -> Malay
    LangTag { language: "miz", 	tag: Tag::new(&[0; 4]) }, // Coatzospan Mixtec != Mizo
    LangTag { language: "mk", 	tag: Tag::new(b"MKD ") }, // Macedonian
    LangTag { language: "mkn", 	tag: Tag::new(b"CPP ") }, // Kupang Malay -> Creoles
    LangTag { language: "mkr", 	tag: Tag::new(&[0; 4]) }, // Malas != Makasar
    LangTag { language: "mku", 	tag: Tag::new(b"MNK ") }, // Konyanka Maninka -> Maninka
//  LangTag { language: "mkw", 	tag: Tag::new(b"MKW ") }, // Kituba (Congo)
    LangTag { language: "ml", 	tag: Tag::new(b"MAL ") }, // Malayalam -> Malayalam Traditional
    LangTag { language: "ml", 	tag: Tag::new(b"MLR ") }, // Malayalam -> Malayalam Reformed
    LangTag { language: "mle", 	tag: Tag::new(&[0; 4]) }, // Manambu != Male
    LangTag { language: "mln", 	tag: Tag::new(&[0; 4]) }, // Malango != Malinke
    LangTag { language: "mlq", 	tag: Tag::new(b"MLN ") }, // Western Maninkakan -> Malinke
    LangTag { language: "mlq", 	tag: Tag::new(b"MNK ") }, // Western Maninkakan -> Maninka
    LangTag { language: "mlr", 	tag: Tag::new(&[0; 4]) }, // Vame != Malayalam Reformed
    LangTag { language: "mmr", 	tag: Tag::new(b"HMN ") }, // Western Xiangxi Miao -> Hmong
    LangTag { language: "mn", 	tag: Tag::new(b"MNG ") }, // Mongolian [macrolanguage]
    LangTag { language: "mnc", 	tag: Tag::new(b"MCH ") }, // Manchu
    LangTag { language: "mnd", 	tag: Tag::new(&[0; 4]) }, // Mondé != Mandinka
    LangTag { language: "mng", 	tag: Tag::new(&[0; 4]) }, // Eastern Mnong != Mongolian
    LangTag { language: "mnh", 	tag: Tag::new(b"BAD0") }, // Mono (Democratic Republic of Congo) -> Banda
//  LangTag { language: "mni", 	tag: Tag::new(b"MNI ") }, // Manipuri
    LangTag { language: "mnk", 	tag: Tag::new(b"MND ") }, // Mandinka
    LangTag { language: "mnk", 	tag: Tag::new(b"MNK ") }, // Mandinka -> Maninka
    LangTag { language: "mnp", 	tag: Tag::new(b"ZHS ") }, // Min Bei Chinese -> Chinese, Simplified
    LangTag { language: "mns", 	tag: Tag::new(b"MAN ") }, // Mansi
    LangTag { language: "mnw", 	tag: Tag::new(b"MON ") }, // Mon
    LangTag { language: "mnw", 	tag: Tag::new(b"MONT") }, // Mon -> Thailand Mon
    LangTag { language: "mnx", 	tag: Tag::new(&[0; 4]) }, // Manikion != Manx
    LangTag { language: "mo", 	tag: Tag::new(b"MOL ") }, // Moldavian(retired code)
    LangTag { language: "mo", 	tag: Tag::new(b"ROM ") }, // Moldavian(retired code) -> Romanian
    LangTag { language: "mod", 	tag: Tag::new(b"CPP ") }, // Mobilian -> Creoles
//  LangTag { language: "moh", 	tag: Tag::new(b"MOH ") }, // Mohawk
    LangTag { language: "mok", 	tag: Tag::new(&[0; 4]) }, // Morori != Moksha
    LangTag { language: "mop", 	tag: Tag::new(b"MYN ") }, // Mopán Maya -> Mayan
    LangTag { language: "mor", 	tag: Tag::new(&[0; 4]) }, // Moro != Moroccan
//  LangTag { language: "mos", 	tag: Tag::new(b"MOS ") }, // Mossi
    LangTag { language: "mpe", 	tag: Tag::new(b"MAJ ") }, // Majang
    LangTag { language: "mqg", 	tag: Tag::new(b"MLY ") }, // Kota Bangun Kutai Malay -> Malay
    LangTag { language: "mr", 	tag: Tag::new(b"MAR ") }, // Marathi
    LangTag { language: "mrh", 	tag: Tag::new(b"QIN ") }, // Mara Chin -> Chin
    LangTag { language: "mrj", 	tag: Tag::new(b"HMA ") }, // Western Mari -> High Mari
    LangTag { language: "ms", 	tag: Tag::new(b"MLY ") }, // Malay  [macrolanguage]
    LangTag { language: "msc", 	tag: Tag::new(b"MNK ") }, // Sankaran Maninka -> Maninka
    LangTag { language: "msh", 	tag: Tag::new(b"MLG ") }, // Masikoro Malagasy -> Malagasy
    LangTag { language: "msi", 	tag: Tag::new(b"MLY ") }, // Sabah Malay -> Malay
    LangTag { language: "msi", 	tag: Tag::new(b"CPP ") }, // Sabah Malay -> Creoles
    LangTag { language: "mt", 	tag: Tag::new(b"MTS ") }, // Maltese
    LangTag { language: "mth", 	tag: Tag::new(&[0; 4]) }, // Munggui != Maithili
    LangTag { language: "mtr", 	tag: Tag::new(b"MAW ") }, // Mewari -> Marwari
    LangTag { language: "mts", 	tag: Tag::new(&[0; 4]) }, // Yora != Maltese
    LangTag { language: "mud", 	tag: Tag::new(b"CPP ") }, // Mednyj Aleut -> Creoles
    LangTag { language: "mui", 	tag: Tag::new(b"MLY ") }, // Musi -> Malay
    LangTag { language: "mun", 	tag: Tag::new(&[0; 4]) }, // Munda  [collection] != Mundari
    LangTag { language: "mup", 	tag: Tag::new(b"RAJ ") }, // Malvi -> Rajasthani
    LangTag { language: "muq", 	tag: Tag::new(b"HMN ") }, // Eastern Xiangxi Miao -> Hmong
//  LangTag { language: "mus", 	tag: Tag::new(b"MUS ") }, // Creek -> Muscogee
    LangTag { language: "mvb", 	tag: Tag::new(b"ATH ") }, // Mattole -> Athapaskan
    LangTag { language: "mve", 	tag: Tag::new(b"MAW ") }, // Marwari (Pakistan)
    LangTag { language: "mvf", 	tag: Tag::new(b"MNG ") }, // Peripheral Mongolian -> Mongolian
    LangTag { language: "mwk", 	tag: Tag::new(b"MNK ") }, // Kita Maninkakan -> Maninka
//  LangTag { language: "mwl", 	tag: Tag::new(b"MWL ") }, // Mirandese
    LangTag { language: "mwq", 	tag: Tag::new(b"QIN ") }, // Mün Chin -> Chin
    LangTag { language: "mwr", 	tag: Tag::new(b"MAW ") }, // Marwari [macrolanguage]
    LangTag { language: "mww", 	tag: Tag::new(b"MWW ") }, // Hmong Daw
    LangTag { language: "mww", 	tag: Tag::new(b"HMN ") }, // Hmong Daw -> Hmong
    LangTag { language: "my", 	tag: Tag::new(b"BRM ") }, // Burmese
    LangTag { language: "mym", 	tag: Tag::new(b"MEN ") }, // Me’en
//  LangTag { language: "myn", 	tag: Tag::new(b"MYN ") }, // Mayan  [collection]
    LangTag { language: "myq", 	tag: Tag::new(b"MNK ") }, // Forest Maninka(retired code) -> Maninka
    LangTag { language: "myv", 	tag: Tag::new(b"ERZ ") }, // Erzya
    LangTag { language: "mzb", 	tag: Tag::new(b"BBR ") }, // Tumzabt -> Berber
//  LangTag { language: "mzn", 	tag: Tag::new(b"MZN ") }, // Mazanderani
    LangTag { language: "mzs", 	tag: Tag::new(b"CPP ") }, // Macanese -> Creoles
    LangTag { language: "na", 	tag: Tag::new(b"NAU ") }, // Nauru -> Nauruan
    LangTag { language: "nag", 	tag: Tag::new(b"NAG ") }, // Naga Pidgin -> Naga-Assamese
    LangTag { language: "nag", 	tag: Tag::new(b"CPP ") }, // Naga Pidgin -> Creoles
//  LangTag { language: "nah", 	tag: Tag::new(b"NAH ") }, // Nahuatl  [collection]
    LangTag { language: "nan", 	tag: Tag::new(b"ZHS ") }, // Min Nan Chinese -> Chinese, Simplified
//  LangTag { language: "nap", 	tag: Tag::new(b"NAP ") }, // Neapolitan
    LangTag { language: "nas", 	tag: Tag::new(&[0; 4]) }, // Naasioi != Naskapi
    LangTag { language: "naz", 	tag: Tag::new(b"NAH ") }, // Coatepec Nahuatl -> Nahuatl
    LangTag { language: "nb", 	tag: Tag::new(b"NOR ") }, // Norwegian Bokmål -> Norwegian
    LangTag { language: "nch", 	tag: Tag::new(b"NAH ") }, // Central Huasteca Nahuatl -> Nahuatl
    LangTag { language: "nci", 	tag: Tag::new(b"NAH ") }, // Classical Nahuatl -> Nahuatl
    LangTag { language: "ncj", 	tag: Tag::new(b"NAH ") }, // Northern Puebla Nahuatl -> Nahuatl
    LangTag { language: "ncl", 	tag: Tag::new(b"NAH ") }, // Michoacán Nahuatl -> Nahuatl
    LangTag { language: "ncr", 	tag: Tag::new(&[0; 4]) }, // Ncane != N-Cree
    LangTag { language: "ncx", 	tag: Tag::new(b"NAH ") }, // Central Puebla Nahuatl -> Nahuatl
    LangTag { language: "nd", 	tag: Tag::new(b"NDB ") }, // North Ndebele -> Ndebele
    LangTag { language: "ndb", 	tag: Tag::new(&[0; 4]) }, // Kenswei Nsei != Ndebele
//  LangTag { language: "ndc", 	tag: Tag::new(b"NDC ") }, // Ndau
    LangTag { language: "ndg", 	tag: Tag::new(&[0; 4]) }, // Ndengereko != Ndonga
//  LangTag { language: "nds", 	tag: Tag::new(b"NDS ") }, // Low Saxon
    LangTag { language: "ne", 	tag: Tag::new(b"NEP ") }, // Nepali  [macrolanguage]
    LangTag { language: "nef", 	tag: Tag::new(b"CPP ") }, // Nefamese -> Creoles
//  LangTag { language: "new", 	tag: Tag::new(b"NEW ") }, // Newari
    LangTag { language: "ng", 	tag: Tag::new(b"NDG ") }, // Ndonga
//  LangTag { language: "nga", 	tag: Tag::new(b"NGA ") }, // Ngbaka
    LangTag { language: "ngl", 	tag: Tag::new(b"LMW ") }, // Lomwe
    LangTag { language: "ngm", 	tag: Tag::new(b"CPP ") }, // Ngatik Men's Creole -> Creoles
    LangTag { language: "ngo", 	tag: Tag::new(b"SXT ") }, // Ngoni(retired code) -> Sutu
    LangTag { language: "ngr", 	tag: Tag::new(&[0; 4]) }, // Engdewu != Nagari
    LangTag { language: "ngu", 	tag: Tag::new(b"NAH ") }, // Guerrero Nahuatl -> Nahuatl
    LangTag { language: "nhc", 	tag: Tag::new(b"NAH ") }, // Tabasco Nahuatl -> Nahuatl
    LangTag { language: "nhd", 	tag: Tag::new(b"GUA ") }, // Chiripá -> Guarani
    LangTag { language: "nhe", 	tag: Tag::new(b"NAH ") }, // Eastern Huasteca Nahuatl -> Nahuatl
    LangTag { language: "nhg", 	tag: Tag::new(b"NAH ") }, // Tetelcingo Nahuatl -> Nahuatl
    LangTag { language: "nhi", 	tag: Tag::new(b"NAH ") }, // Zacatlán-Ahuacatlán-Tepetzintla Nahuatl -> Nahuatl
    LangTag { language: "nhk", 	tag: Tag::new(b"NAH ") }, // Isthmus-Cosoleacaque Nahuatl -> Nahuatl
    LangTag { language: "nhm", 	tag: Tag::new(b"NAH ") }, // Morelos Nahuatl -> Nahuatl
    LangTag { language: "nhn", 	tag: Tag::new(b"NAH ") }, // Central Nahuatl -> Nahuatl
    LangTag { language: "nhp", 	tag: Tag::new(b"NAH ") }, // Isthmus-Pajapan Nahuatl -> Nahuatl
    LangTag { language: "nhq", 	tag: Tag::new(b"NAH ") }, // Huaxcaleca Nahuatl -> Nahuatl
    LangTag { language: "nht", 	tag: Tag::new(b"NAH ") }, // Ometepec Nahuatl -> Nahuatl
    LangTag { language: "nhv", 	tag: Tag::new(b"NAH ") }, // Temascaltepec Nahuatl -> Nahuatl
    LangTag { language: "nhw", 	tag: Tag::new(b"NAH ") }, // Western Huasteca Nahuatl -> Nahuatl
    LangTag { language: "nhx", 	tag: Tag::new(b"NAH ") }, // Isthmus-Mecayapan Nahuatl -> Nahuatl
    LangTag { language: "nhy", 	tag: Tag::new(b"NAH ") }, // Northern Oaxaca Nahuatl -> Nahuatl
    LangTag { language: "nhz", 	tag: Tag::new(b"NAH ") }, // Santa María La Alta Nahuatl -> Nahuatl
    LangTag { language: "niq", 	tag: Tag::new(b"KAL ") }, // Nandi -> Kalenjin
    LangTag { language: "nis", 	tag: Tag::new(&[0; 4]) }, // Nimi != Nisi
//  LangTag { language: "niu", 	tag: Tag::new(b"NIU ") }, // Niuean
    LangTag { language: "niv", 	tag: Tag::new(b"GIL ") }, // Gilyak
    LangTag { language: "njt", 	tag: Tag::new(b"CPP ") }, // Ndyuka-Trio Pidgin -> Creoles
    LangTag { language: "njz", 	tag: Tag::new(b"NIS ") }, // Nyishi -> Nisi
    LangTag { language: "nko", 	tag: Tag::new(&[0; 4]) }, // Nkonya != N’Ko
    LangTag { language: "nkx", 	tag: Tag::new(b"IJO ") }, // Nkoroo -> Ijo
    LangTag { language: "nl", 	tag: Tag::new(b"NLD ") }, // Dutch
    LangTag { language: "nla", 	tag: Tag::new(b"BML ") }, // Ngombale -> Bamileke
    LangTag { language: "nle", 	tag: Tag::new(b"LUH ") }, // East Nyala -> Luyia
    LangTag { language: "nln", 	tag: Tag::new(b"NAH ") }, // Durango Nahuatl(retired code) -> Nahuatl
    LangTag { language: "nlv", 	tag: Tag::new(b"NAH ") }, // Orizaba Nahuatl -> Nahuatl
    LangTag { language: "nn", 	tag: Tag::new(b"NYN ") }, // Norwegian Nynorsk (Nynorsk, Norwegian)
    LangTag { language: "nnh", 	tag: Tag::new(b"BML ") }, // Ngiemboon -> Bamileke
    LangTag { language: "nnz", 	tag: Tag::new(b"BML ") }, // Nda'nda' -> Bamileke
    LangTag { language: "no", 	tag: Tag::new(b"NOR ") }, // Norwegian [macrolanguage]
    LangTag { language: "nod", 	tag: Tag::new(b"NTA ") }, // Northern Thai -> Northern Tai
//  LangTag { language: "noe", 	tag: Tag::new(b"NOE ") }, // Nimadi
//  LangTag { language: "nog", 	tag: Tag::new(b"NOG ") }, // Nogai
//  LangTag { language: "nop", 	tag: Tag::new(b"NOP ") }, // Numanggang
//  LangTag { language: "nov", 	tag: Tag::new(b"NOV ") }, // Novial
    LangTag { language: "npi", 	tag: Tag::new(b"NEP ") }, // Nepali 
    LangTag { language: "npl", 	tag: Tag::new(b"NAH ") }, // Southeastern Puebla Nahuatl -> Nahuatl
    LangTag { language: "nqo", 	tag: Tag::new(b"NKO ") }, // N’Ko
    LangTag { language: "nr", 	tag: Tag::new(b"NDB ") }, // South Ndebele -> Ndebele
    LangTag { language: "nsk", 	tag: Tag::new(b"NAS ") }, // Naskapi
    LangTag { language: "nsm", 	tag: Tag::new(&[0; 4]) }, // Sumi Naga != Northern Sami
//  LangTag { language: "nso", 	tag: Tag::new(b"NSO ") }, // Northern Sotho
    LangTag { language: "nsu", 	tag: Tag::new(b"NAH ") }, // Sierra Negra Nahuatl -> Nahuatl
    LangTag { language: "nto", 	tag: Tag::new(&[0; 4]) }, // Ntomba != Esperanto
    LangTag { language: "nue", 	tag: Tag::new(b"BAD0") }, // Ngundu -> Banda
//  LangTag { language: "nuk", 	tag: Tag::new(b"NUK ") }, // Nuu-chah-nulth
    LangTag { language: "nuu", 	tag: Tag::new(b"BAD0") }, // Ngbundu -> Banda
    LangTag { language: "nuz", 	tag: Tag::new(b"NAH ") }, // Tlamacazapa Nahuatl -> Nahuatl
    LangTag { language: "nv", 	tag: Tag::new(b"NAV ") }, // Navajo
    LangTag { language: "nv", 	tag: Tag::new(b"ATH ") }, // Navajo -> Athapaskan
    LangTag { language: "nwe", 	tag: Tag::new(b"BML ") }, // Ngwe -> Bamileke
    LangTag { language: "ny", 	tag: Tag::new(b"CHI ") }, // Chichewa (Chewa, Nyanja)
    LangTag { language: "nyd", 	tag: Tag::new(b"LUH ") }, // Nyore -> Luyia
//  LangTag { language: "nym", 	tag: Tag::new(b"NYM ") }, // Nyamwezi
    LangTag { language: "nyn", 	tag: Tag::new(b"NKL ") }, // Nyankole
//  LangTag { language: "nza", 	tag: Tag::new(b"NZA ") }, // Tigon Mbembe -> Mbembe Tigon
    LangTag { language: "oc", 	tag: Tag::new(b"OCI ") }, // Occitan (post 1500)
    LangTag { language: "oj", 	tag: Tag::new(b"OJB ") }, // Ojibwa [macrolanguage] -> Ojibway
//  LangTag { language: "ojb", 	tag: Tag::new(b"OJB ") }, // Northwestern Ojibwa -> Ojibway
    LangTag { language: "ojc", 	tag: Tag::new(b"OJB ") }, // Central Ojibwa -> Ojibway
    LangTag { language: "ojg", 	tag: Tag::new(b"OJB ") }, // Eastern Ojibwa -> Ojibway
    LangTag { language: "ojs", 	tag: Tag::new(b"OCR ") }, // Severn Ojibwa -> Oji-Cree
    LangTag { language: "ojs", 	tag: Tag::new(b"OJB ") }, // Severn Ojibwa -> Ojibway
    LangTag { language: "ojw", 	tag: Tag::new(b"OJB ") }, // Western Ojibwa -> Ojibway
    LangTag { language: "okd", 	tag: Tag::new(b"IJO ") }, // Okodia -> Ijo
    LangTag { language: "oki", 	tag: Tag::new(b"KAL ") }, // Okiek -> Kalenjin
    LangTag { language: "okm", 	tag: Tag::new(b"KOH ") }, // Middle Korean (10th-16th cent.) -> Korean Old Hangul
    LangTag { language: "okr", 	tag: Tag::new(b"IJO ") }, // Kirike -> Ijo
    LangTag { language: "om", 	tag: Tag::new(b"ORO ") }, // Oromo [macrolanguage]
//  LangTag { language: "one", 	tag: Tag::new(b"ONE ") }, // Oneida
//  LangTag { language: "ono", 	tag: Tag::new(b"ONO ") }, // Onondaga
    LangTag { language: "onx", 	tag: Tag::new(b"CPP ") }, // Onin Based Pidgin -> Creoles
    LangTag { language: "oor", 	tag: Tag::new(b"CPP ") }, // Oorlams -> Creoles
    LangTag { language: "or", 	tag: Tag::new(b"ORI ") }, // Odia  [macrolanguage]
    LangTag { language: "orc", 	tag: Tag::new(b"ORO ") }, // Orma -> Oromo
    LangTag { language: "orn", 	tag: Tag::new(b"MLY ") }, // Orang Kanaq -> Malay
    LangTag { language: "oro", 	tag: Tag::new(&[0; 4]) }, // Orokolo != Oromo
    LangTag { language: "orr", 	tag: Tag::new(b"IJO ") }, // Oruma -> Ijo
    LangTag { language: "ors", 	tag: Tag::new(b"MLY ") }, // Orang Seletar -> Malay
    LangTag { language: "ory", 	tag: Tag::new(b"ORI ") }, // Odia 
    LangTag { language: "os", 	tag: Tag::new(b"OSS ") }, // Ossetian
    LangTag { language: "otw", 	tag: Tag::new(b"OJB ") }, // Ottawa -> Ojibway
    LangTag { language: "oua", 	tag: Tag::new(b"BBR ") }, // Tagargrent -> Berber
    LangTag { language: "pa", 	tag: Tag::new(b"PAN ") }, // Punjabi
    LangTag { language: "paa", 	tag: Tag::new(&[0; 4]) }, // Papuan  [collection] != Palestinian Aramaic
//  LangTag { language: "pag", 	tag: Tag::new(b"PAG ") }, // Pangasinan
    LangTag { language: "pal", 	tag: Tag::new(&[0; 4]) }, // Pahlavi != Pali
//  LangTag { language: "pam", 	tag: Tag::new(b"PAM ") }, // Pampanga -> Pampangan
    LangTag { language: "pap", 	tag: Tag::new(b"PAP0") }, // Papiamento -> Papiamentu
    LangTag { language: "pap", 	tag: Tag::new(b"CPP ") }, // Papiamento -> Creoles
    LangTag { language: "pas", 	tag: Tag::new(&[0; 4]) }, // Papasena != Pashto
//  LangTag { language: "pau", 	tag: Tag::new(b"PAU ") }, // Palauan
    LangTag { language: "pbt", 	tag: Tag::new(b"PAS ") }, // Southern Pashto -> Pashto
    LangTag { language: "pbu", 	tag: Tag::new(b"PAS ") }, // Northern Pashto -> Pashto
//  LangTag { language: "pcc", 	tag: Tag::new(b"PCC ") }, // Bouyei
//  LangTag { language: "pcd", 	tag: Tag::new(b"PCD ") }, // Picard
    LangTag { language: "pce", 	tag: Tag::new(b"PLG ") }, // Ruching Palaung -> Palaung
    LangTag { language: "pck", 	tag: Tag::new(b"QIN ") }, // Paite Chin -> Chin
    LangTag { language: "pcm", 	tag: Tag::new(b"CPP ") }, // Nigerian Pidgin -> Creoles
//  LangTag { language: "pdc", 	tag: Tag::new(b"PDC ") }, // Pennsylvania German
    LangTag { language: "pdu", 	tag: Tag::new(b"KRN ") }, // Kayan -> Karen
    LangTag { language: "pea", 	tag: Tag::new(b"CPP ") }, // Peranakan Indonesian -> Creoles
    LangTag { language: "pel", 	tag: Tag::new(b"MLY ") }, // Pekal -> Malay
    LangTag { language: "pes", 	tag: Tag::new(b"FAR ") }, // Iranian Persian -> Persian
    LangTag { language: "pey", 	tag: Tag::new(b"CPP ") }, // Petjo -> Creoles
    LangTag { language: "pga", 	tag: Tag::new(b"ARA ") }, // Sudanese Creole Arabic -> Arabic
    LangTag { language: "pga", 	tag: Tag::new(b"CPP ") }, // Sudanese Creole Arabic -> Creoles
//  LangTag { language: "phk", 	tag: Tag::new(b"PHK ") }, // Phake
    LangTag { language: "pi", 	tag: Tag::new(b"PAL ") }, // Pali
    LangTag { language: "pih", 	tag: Tag::new(b"PIH ") }, // Pitcairn-Norfolk -> Norfolk
    LangTag { language: "pih", 	tag: Tag::new(b"CPP ") }, // Pitcairn-Norfolk -> Creoles
    LangTag { language: "pil", 	tag: Tag::new(&[0; 4]) }, // Yom != Filipino
    LangTag { language: "pis", 	tag: Tag::new(b"CPP ") }, // Pijin -> Creoles
    LangTag { language: "pkh", 	tag: Tag::new(b"QIN ") }, // Pankhu -> Chin
    LangTag { language: "pko", 	tag: Tag::new(b"KAL ") }, // Pökoot -> Kalenjin
    LangTag { language: "pl", 	tag: Tag::new(b"PLK ") }, // Polish
    LangTag { language: "plg", 	tag: Tag::new(b"PLG0") }, // Pilagá
    LangTag { language: "plk", 	tag: Tag::new(&[0; 4]) }, // Kohistani Shina != Polish
    LangTag { language: "pll", 	tag: Tag::new(b"PLG ") }, // Shwe Palaung -> Palaung
    LangTag { language: "pln", 	tag: Tag::new(b"CPP ") }, // Palenquero -> Creoles
    LangTag { language: "plp", 	tag: Tag::new(b"PAP ") }, // Palpa(retired code)
    LangTag { language: "plt", 	tag: Tag::new(b"MLG ") }, // Plateau Malagasy -> Malagasy
    LangTag { language: "pml", 	tag: Tag::new(b"CPP ") }, // Lingua Franca -> Creoles
//  LangTag { language: "pms", 	tag: Tag::new(b"PMS ") }, // Piemontese
    LangTag { language: "pmy", 	tag: Tag::new(b"CPP ") }, // Papuan Malay -> Creoles
//  LangTag { language: "pnb", 	tag: Tag::new(b"PNB ") }, // Western Panjabi
    LangTag { language: "poc", 	tag: Tag::new(b"MYN ") }, // Poqomam -> Mayan
    LangTag { language: "poh", 	tag: Tag::new(b"POH ") }, // Poqomchi' -> Pocomchi
    LangTag { language: "poh", 	tag: Tag::new(b"MYN ") }, // Poqomchi' -> Mayan
//  LangTag { language: "pon", 	tag: Tag::new(b"PON ") }, // Pohnpeian
    LangTag { language: "pov", 	tag: Tag::new(b"CPP ") }, // Upper Guinea Crioulo -> Creoles
    LangTag { language: "ppa", 	tag: Tag::new(b"BAG ") }, // Pao(retired code) -> Baghelkhandi
    LangTag { language: "pre", 	tag: Tag::new(b"CPP ") }, // Principense -> Creoles
//  LangTag { language: "pro", 	tag: Tag::new(b"PRO ") }, // Old Provençal (to 1500) -> Provençal / Old Provençal
    LangTag { language: "prp", 	tag: Tag::new(b"GUJ ") }, // Parsi(retired code) -> Gujarati
    LangTag { language: "prs", 	tag: Tag::new(b"DRI ") }, // Dari
    LangTag { language: "prs", 	tag: Tag::new(b"FAR ") }, // Dari -> Persian
    LangTag { language: "ps", 	tag: Tag::new(b"PAS ") }, // Pashto [macrolanguage]
    LangTag { language: "pse", 	tag: Tag::new(b"MLY ") }, // Central Malay -> Malay
    LangTag { language: "pst", 	tag: Tag::new(b"PAS ") }, // Central Pashto -> Pashto
    LangTag { language: "pt", 	tag: Tag::new(b"PTG ") }, // Portuguese
    LangTag { language: "pub", 	tag: Tag::new(b"QIN ") }, // Purum -> Chin
    LangTag { language: "puz", 	tag: Tag::new(b"QIN ") }, // Purum Naga(retired code) -> Chin
    LangTag { language: "pwo", 	tag: Tag::new(b"PWO ") }, // Pwo Western Karen -> Western Pwo Karen
    LangTag { language: "pwo", 	tag: Tag::new(b"KRN ") }, // Pwo Western Karen -> Karen
    LangTag { language: "pww", 	tag: Tag::new(b"KRN ") }, // Pwo Northern Karen -> Karen
    LangTag { language: "qu", 	tag: Tag::new(b"QUZ ") }, // Quechua [macrolanguage]
    LangTag { language: "qub", 	tag: Tag::new(b"QWH ") }, // Huallaga Huánuco Quechua -> Quechua (Peru)
    LangTag { language: "qub", 	tag: Tag::new(b"QUZ ") }, // Huallaga Huánuco Quechua -> Quechua
    LangTag { language: "quc", 	tag: Tag::new(b"QUC ") }, // K’iche’
    LangTag { language: "quc", 	tag: Tag::new(b"MYN ") }, // K'iche' -> Mayan
    LangTag { language: "qud", 	tag: Tag::new(b"QVI ") }, // Calderón Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qud", 	tag: Tag::new(b"QUZ ") }, // Calderón Highland Quichua -> Quechua
    LangTag { language: "quf", 	tag: Tag::new(b"QUZ ") }, // Lambayeque Quechua -> Quechua
    LangTag { language: "qug", 	tag: Tag::new(b"QVI ") }, // Chimborazo Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qug", 	tag: Tag::new(b"QUZ ") }, // Chimborazo Highland Quichua -> Quechua
    LangTag { language: "quh", 	tag: Tag::new(b"QUH ") }, // South Bolivian Quechua -> Quechua (Bolivia)
    LangTag { language: "quh", 	tag: Tag::new(b"QUZ ") }, // South Bolivian Quechua -> Quechua
    LangTag { language: "quk", 	tag: Tag::new(b"QUZ ") }, // Chachapoyas Quechua -> Quechua
    LangTag { language: "qul", 	tag: Tag::new(b"QUH ") }, // North Bolivian Quechua -> Quechua (Bolivia)
    LangTag { language: "qul", 	tag: Tag::new(b"QUZ ") }, // North Bolivian Quechua -> Quechua
    LangTag { language: "qum", 	tag: Tag::new(b"MYN ") }, // Sipacapense -> Mayan
    LangTag { language: "qup", 	tag: Tag::new(b"QVI ") }, // Southern Pastaza Quechua -> Quechua (Ecuador)
    LangTag { language: "qup", 	tag: Tag::new(b"QUZ ") }, // Southern Pastaza Quechua -> Quechua
    LangTag { language: "qur", 	tag: Tag::new(b"QWH ") }, // Yanahuanca Pasco Quechua -> Quechua (Peru)
    LangTag { language: "qur", 	tag: Tag::new(b"QUZ ") }, // Yanahuanca Pasco Quechua -> Quechua
    LangTag { language: "qus", 	tag: Tag::new(b"QUH ") }, // Santiago del Estero Quichua -> Quechua (Bolivia)
    LangTag { language: "qus", 	tag: Tag::new(b"QUZ ") }, // Santiago del Estero Quichua -> Quechua
    LangTag { language: "quv", 	tag: Tag::new(b"MYN ") }, // Sacapulteco -> Mayan
    LangTag { language: "quw", 	tag: Tag::new(b"QVI ") }, // Tena Lowland Quichua -> Quechua (Ecuador)
    LangTag { language: "quw", 	tag: Tag::new(b"QUZ ") }, // Tena Lowland Quichua -> Quechua
    LangTag { language: "qux", 	tag: Tag::new(b"QWH ") }, // Yauyos Quechua -> Quechua (Peru)
    LangTag { language: "qux", 	tag: Tag::new(b"QUZ ") }, // Yauyos Quechua -> Quechua
    LangTag { language: "quy", 	tag: Tag::new(b"QUZ ") }, // Ayacucho Quechua -> Quechua
//  LangTag { language: "quz", 	tag: Tag::new(b"QUZ ") }, // Cusco Quechua -> Quechua
    LangTag { language: "qva", 	tag: Tag::new(b"QWH ") }, // Ambo-Pasco Quechua -> Quechua (Peru)
    LangTag { language: "qva", 	tag: Tag::new(b"QUZ ") }, // Ambo-Pasco Quechua -> Quechua
    LangTag { language: "qvc", 	tag: Tag::new(b"QUZ ") }, // Cajamarca Quechua -> Quechua
    LangTag { language: "qve", 	tag: Tag::new(b"QUZ ") }, // Eastern Apurímac Quechua -> Quechua
    LangTag { language: "qvh", 	tag: Tag::new(b"QWH ") }, // Huamalíes-Dos de Mayo Huánuco Quechua -> Quechua (Peru)
    LangTag { language: "qvh", 	tag: Tag::new(b"QUZ ") }, // Huamalíes-Dos de Mayo Huánuco Quechua -> Quechua
    LangTag { language: "qvi", 	tag: Tag::new(b"QVI ") }, // Imbabura Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qvi", 	tag: Tag::new(b"QUZ ") }, // Imbabura Highland Quichua -> Quechua
    LangTag { language: "qvj", 	tag: Tag::new(b"QVI ") }, // Loja Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qvj", 	tag: Tag::new(b"QUZ ") }, // Loja Highland Quichua -> Quechua
    LangTag { language: "qvl", 	tag: Tag::new(b"QWH ") }, // Cajatambo North Lima Quechua -> Quechua (Peru)
    LangTag { language: "qvl", 	tag: Tag::new(b"QUZ ") }, // Cajatambo North Lima Quechua -> Quechua
    LangTag { language: "qvm", 	tag: Tag::new(b"QWH ") }, // Margos-Yarowilca-Lauricocha Quechua -> Quechua (Peru)
    LangTag { language: "qvm", 	tag: Tag::new(b"QUZ ") }, // Margos-Yarowilca-Lauricocha Quechua -> Quechua
    LangTag { language: "qvn", 	tag: Tag::new(b"QWH ") }, // North Junín Quechua -> Quechua (Peru)
    LangTag { language: "qvn", 	tag: Tag::new(b"QUZ ") }, // North Junín Quechua -> Quechua
    LangTag { language: "qvo", 	tag: Tag::new(b"QVI ") }, // Napo Lowland Quechua -> Quechua (Ecuador)
    LangTag { language: "qvo", 	tag: Tag::new(b"QUZ ") }, // Napo Lowland Quechua -> Quechua
    LangTag { language: "qvp", 	tag: Tag::new(b"QWH ") }, // Pacaraos Quechua -> Quechua (Peru)
    LangTag { language: "qvp", 	tag: Tag::new(b"QUZ ") }, // Pacaraos Quechua -> Quechua
    LangTag { language: "qvs", 	tag: Tag::new(b"QUZ ") }, // San Martín Quechua -> Quechua
    LangTag { language: "qvw", 	tag: Tag::new(b"QWH ") }, // Huaylla Wanca Quechua -> Quechua (Peru)
    LangTag { language: "qvw", 	tag: Tag::new(b"QUZ ") }, // Huaylla Wanca Quechua -> Quechua
    LangTag { language: "qvz", 	tag: Tag::new(b"QVI ") }, // Northern Pastaza Quichua -> Quechua (Ecuador)
    LangTag { language: "qvz", 	tag: Tag::new(b"QUZ ") }, // Northern Pastaza Quichua -> Quechua
    LangTag { language: "qwa", 	tag: Tag::new(b"QWH ") }, // Corongo Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qwa", 	tag: Tag::new(b"QUZ ") }, // Corongo Ancash Quechua -> Quechua
    LangTag { language: "qwc", 	tag: Tag::new(b"QUZ ") }, // Classical Quechua -> Quechua
    LangTag { language: "qwh", 	tag: Tag::new(b"QWH ") }, // Huaylas Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qwh", 	tag: Tag::new(b"QUZ ") }, // Huaylas Ancash Quechua -> Quechua
    LangTag { language: "qws", 	tag: Tag::new(b"QWH ") }, // Sihuas Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qws", 	tag: Tag::new(b"QUZ ") }, // Sihuas Ancash Quechua -> Quechua
    LangTag { language: "qwt", 	tag: Tag::new(b"ATH ") }, // Kwalhioqua-Tlatskanai -> Athapaskan
    LangTag { language: "qxa", 	tag: Tag::new(b"QWH ") }, // Chiquián Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qxa", 	tag: Tag::new(b"QUZ ") }, // Chiquián Ancash Quechua -> Quechua
    LangTag { language: "qxc", 	tag: Tag::new(b"QWH ") }, // Chincha Quechua -> Quechua (Peru)
    LangTag { language: "qxc", 	tag: Tag::new(b"QUZ ") }, // Chincha Quechua -> Quechua
    LangTag { language: "qxh", 	tag: Tag::new(b"QWH ") }, // Panao Huánuco Quechua -> Quechua (Peru)
    LangTag { language: "qxh", 	tag: Tag::new(b"QUZ ") }, // Panao Huánuco Quechua -> Quechua
    LangTag { language: "qxl", 	tag: Tag::new(b"QVI ") }, // Salasaca Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qxl", 	tag: Tag::new(b"QUZ ") }, // Salasaca Highland Quichua -> Quechua
    LangTag { language: "qxn", 	tag: Tag::new(b"QWH ") }, // Northern Conchucos Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qxn", 	tag: Tag::new(b"QUZ ") }, // Northern Conchucos Ancash Quechua -> Quechua
    LangTag { language: "qxo", 	tag: Tag::new(b"QWH ") }, // Southern Conchucos Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qxo", 	tag: Tag::new(b"QUZ ") }, // Southern Conchucos Ancash Quechua -> Quechua
    LangTag { language: "qxp", 	tag: Tag::new(b"QUZ ") }, // Puno Quechua -> Quechua
    LangTag { language: "qxr", 	tag: Tag::new(b"QVI ") }, // Cañar Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qxr", 	tag: Tag::new(b"QUZ ") }, // Cañar Highland Quichua -> Quechua
    LangTag { language: "qxt", 	tag: Tag::new(b"QWH ") }, // Santa Ana de Tusi Pasco Quechua -> Quechua (Peru)
    LangTag { language: "qxt", 	tag: Tag::new(b"QUZ ") }, // Santa Ana de Tusi Pasco Quechua -> Quechua
    LangTag { language: "qxu", 	tag: Tag::new(b"QUZ ") }, // Arequipa-La Unión Quechua -> Quechua
    LangTag { language: "qxw", 	tag: Tag::new(b"QWH ") }, // Jauja Wanca Quechua -> Quechua (Peru)
    LangTag { language: "qxw", 	tag: Tag::new(b"QUZ ") }, // Jauja Wanca Quechua -> Quechua
    LangTag { language: "rag", 	tag: Tag::new(b"LUH ") }, // Logooli -> Luyia
//  LangTag { language: "raj", 	tag: Tag::new(b"RAJ ") }, // Rajasthani [macrolanguage]
    LangTag { language: "ral", 	tag: Tag::new(b"QIN ") }, // Ralte -> Chin
//  LangTag { language: "rar", 	tag: Tag::new(b"RAR ") }, // Rarotongan
    LangTag { language: "rbb", 	tag: Tag::new(b"PLG ") }, // Rumai Palaung -> Palaung
    LangTag { language: "rbl", 	tag: Tag::new(b"BIK ") }, // Miraya Bikol -> Bikol
    LangTag { language: "rcf", 	tag: Tag::new(b"CPP ") }, // Réunion Creole French -> Creoles
//  LangTag { language: "rej", 	tag: Tag::new(b"REJ ") }, // Rejang
//  LangTag { language: "rhg", 	tag: Tag::new(b"RHG ") }, // Rohingya
//  LangTag { language: "ria", 	tag: Tag::new(b"RIA ") }, // Riang (India)
    LangTag { language: "rif", 	tag: Tag::new(b"RIF ") }, // Tarifit
    LangTag { language: "rif", 	tag: Tag::new(b"BBR ") }, // Tarifit -> Berber
//  LangTag { language: "rit", 	tag: Tag::new(b"RIT ") }, // Ritharrngu -> Ritarungo
    LangTag { language: "rki", 	tag: Tag::new(b"ARK ") }, // Rakhine
//  LangTag { language: "rkw", 	tag: Tag::new(b"RKW ") }, // Arakwal
    LangTag { language: "rm", 	tag: Tag::new(b"RMS ") }, // Romansh
    LangTag { language: "rmc", 	tag: Tag::new(b"ROY ") }, // Carpathian Romani -> Romany
    LangTag { language: "rmf", 	tag: Tag::new(b"ROY ") }, // Kalo Finnish Romani -> Romany
    LangTag { language: "rml", 	tag: Tag::new(b"ROY ") }, // Baltic Romani -> Romany
    LangTag { language: "rmn", 	tag: Tag::new(b"ROY ") }, // Balkan Romani -> Romany
    LangTag { language: "rmo", 	tag: Tag::new(b"ROY ") }, // Sinte Romani -> Romany
    LangTag { language: "rms", 	tag: Tag::new(&[0; 4]) }, // Romanian Sign Language != Romansh
    LangTag { language: "rmw", 	tag: Tag::new(b"ROY ") }, // Welsh Romani -> Romany
    LangTag { language: "rmy", 	tag: Tag::new(b"RMY ") }, // Vlax Romani
    LangTag { language: "rmy", 	tag: Tag::new(b"ROY ") }, // Vlax Romani -> Romany
    LangTag { language: "rmz", 	tag: Tag::new(b"ARK ") }, // Marma -> Rakhine
    LangTag { language: "rn", 	tag: Tag::new(b"RUN ") }, // Rundi
    LangTag { language: "ro", 	tag: Tag::new(b"ROM ") }, // Romanian
    LangTag { language: "rom", 	tag: Tag::new(b"ROY ") }, // Romany [macrolanguage]
    LangTag { language: "rop", 	tag: Tag::new(b"CPP ") }, // Kriol -> Creoles
    LangTag { language: "rtc", 	tag: Tag::new(b"QIN ") }, // Rungtu Chin -> Chin
//  LangTag { language: "rtm", 	tag: Tag::new(b"RTM ") }, // Rotuman
    LangTag { language: "ru", 	tag: Tag::new(b"RUS ") }, // Russian
    LangTag { language: "rue", 	tag: Tag::new(b"RSY ") }, // Rusyn
//  LangTag { language: "rup", 	tag: Tag::new(b"RUP ") }, // Aromanian
    LangTag { language: "rw", 	tag: Tag::new(b"RUA ") }, // Kinyarwanda
    LangTag { language: "rwr", 	tag: Tag::new(b"MAW ") }, // Marwari (India)
    LangTag { language: "sa", 	tag: Tag::new(b"SAN ") }, // Sanskrit [macrolanguage]
    LangTag { language: "sad", 	tag: Tag::new(&[0; 4]) }, // Sandawe != Sadri
    LangTag { language: "sah", 	tag: Tag::new(b"YAK ") }, // Yakut -> Sakha
    LangTag { language: "sam", 	tag: Tag::new(b"PAA ") }, // Samaritan Aramaic -> Palestinian Aramaic
//  LangTag { language: "sas", 	tag: Tag::new(b"SAS ") }, // Sasak
//  LangTag { language: "sat", 	tag: Tag::new(b"SAT ") }, // Santali
    LangTag { language: "say", 	tag: Tag::new(&[0; 4]) }, // Saya != Sayisi
    LangTag { language: "sc", 	tag: Tag::new(b"SRD ") }, // Sardinian [macrolanguage]
    LangTag { language: "scf", 	tag: Tag::new(b"CPP ") }, // San Miguel Creole French -> Creoles
    LangTag { language: "sch", 	tag: Tag::new(b"QIN ") }, // Sakachep -> Chin
    LangTag { language: "sci", 	tag: Tag::new(b"CPP ") }, // Sri Lankan Creole Malay -> Creoles
    LangTag { language: "sck", 	tag: Tag::new(b"SAD ") }, // Sadri
//  LangTag { language: "scn", 	tag: Tag::new(b"SCN ") }, // Sicilian
//  LangTag { language: "sco", 	tag: Tag::new(b"SCO ") }, // Scots
    LangTag { language: "scs", 	tag: Tag::new(b"SCS ") }, // North Slavey
    LangTag { language: "scs", 	tag: Tag::new(b"SLA ") }, // North Slavey -> Slavey
    LangTag { language: "scs", 	tag: Tag::new(b"ATH ") }, // North Slavey -> Athapaskan
    LangTag { language: "sd", 	tag: Tag::new(b"SND ") }, // Sindhi
    LangTag { language: "sdc", 	tag: Tag::new(b"SRD ") }, // Sassarese Sardinian -> Sardinian
    LangTag { language: "sdh", 	tag: Tag::new(b"KUR ") }, // Southern Kurdish -> Kurdish
    LangTag { language: "sdn", 	tag: Tag::new(b"SRD ") }, // Gallurese Sardinian -> Sardinian
    LangTag { language: "sds", 	tag: Tag::new(b"BBR ") }, // Sened -> Berber
    LangTag { language: "se", 	tag: Tag::new(b"NSM ") }, // Northern Sami
//  LangTag { language: "see", 	tag: Tag::new(b"SEE ") }, // Seneca
    LangTag { language: "seh", 	tag: Tag::new(b"SNA ") }, // Sena
    LangTag { language: "sek", 	tag: Tag::new(b"ATH ") }, // Sekani -> Athapaskan
//  LangTag { language: "sel", 	tag: Tag::new(b"SEL ") }, // Selkup
    LangTag { language: "sez", 	tag: Tag::new(b"QIN ") }, // Senthang Chin -> Chin
    LangTag { language: "sfm", 	tag: Tag::new(b"SFM ") }, // Small Flowery Miao
    LangTag { language: "sfm", 	tag: Tag::new(b"HMN ") }, // Small Flowery Miao -> Hmong
    LangTag { language: "sg", 	tag: Tag::new(b"SGO ") }, // Sango
//  LangTag { language: "sga", 	tag: Tag::new(b"SGA ") }, // Old Irish (to 900)
    LangTag { language: "sgc", 	tag: Tag::new(b"KAL ") }, // Kipsigis -> Kalenjin
    LangTag { language: "sgo", 	tag: Tag::new(&[0; 4]) }, // Songa(retired code) != Sango
//  LangTag { language: "sgs", 	tag: Tag::new(b"SGS ") }, // Samogitian
    LangTag { language: "sgw", 	tag: Tag::new(b"CHG ") }, // Sebat Bet Gurage -> Chaha Gurage
    LangTag { language: "sh", 	tag: Tag::new(b"BOS ") }, // Serbo-Croatian [macrolanguage] -> Bosnian
    LangTag { language: "sh", 	tag: Tag::new(b"HRV ") }, // Serbo-Croatian [macrolanguage] -> Croatian
    LangTag { language: "sh", 	tag: Tag::new(b"SRB ") }, // Serbo-Croatian [macrolanguage] -> Serbian
    LangTag { language: "shi", 	tag: Tag::new(b"SHI ") }, // Tachelhit
    LangTag { language: "shi", 	tag: Tag::new(b"BBR ") }, // Tachelhit -> Berber
    LangTag { language: "shl", 	tag: Tag::new(b"QIN ") }, // Shendu -> Chin
//  LangTag { language: "shn", 	tag: Tag::new(b"SHN ") }, // Shan
    LangTag { language: "shu", 	tag: Tag::new(b"ARA ") }, // Chadian Arabic -> Arabic
    LangTag { language: "shy", 	tag: Tag::new(b"BBR ") }, // Tachawit -> Berber
    LangTag { language: "si", 	tag: Tag::new(b"SNH ") }, // Sinhala (Sinhalese)
    LangTag { language: "sib", 	tag: Tag::new(&[0; 4]) }, // Sebop != Sibe
//  LangTag { language: "sid", 	tag: Tag::new(b"SID ") }, // Sidamo
    LangTag { language: "sig", 	tag: Tag::new(&[0; 4]) }, // Paasaal != Silte Gurage
    LangTag { language: "siz", 	tag: Tag::new(b"BBR ") }, // Siwi -> Berber
//  LangTag { language: "sja", 	tag: Tag::new(b"SJA ") }, // Epena
    LangTag { language: "sjc", 	tag: Tag::new(b"ZHS ") }, // Shaojiang Chinese -> Chinese, Simplified
    LangTag { language: "sjd", 	tag: Tag::new(b"KSM ") }, // Kildin Sami
//  LangTag { language: "sje", 	tag: Tag::new(b"SJE ") }, // Pite Sami
    LangTag { language: "sjo", 	tag: Tag::new(b"SIB ") }, // Xibe -> Sibe
    LangTag { language: "sjs", 	tag: Tag::new(b"BBR ") }, // Senhaja De Srair -> Berber
//  LangTag { language: "sju", 	tag: Tag::new(b"SJU ") }, // Ume Sami
    LangTag { language: "sk", 	tag: Tag::new(b"SKY ") }, // Slovak
    LangTag { language: "skg", 	tag: Tag::new(b"MLG ") }, // Sakalava Malagasy -> Malagasy
    LangTag { language: "skr", 	tag: Tag::new(b"SRK ") }, // Saraiki
    LangTag { language: "sks", 	tag: Tag::new(&[0; 4]) }, // Maia != Skolt Sami
    LangTag { language: "skw", 	tag: Tag::new(b"CPP ") }, // Skepi Creole Dutch -> Creoles
    LangTag { language: "sky", 	tag: Tag::new(&[0; 4]) }, // Sikaiana != Slovak
    LangTag { language: "sl", 	tag: Tag::new(b"SLV ") }, // Slovenian
    LangTag { language: "sla", 	tag: Tag::new(&[0; 4]) }, // Slavic  [collection] != Slavey
    LangTag { language: "sm", 	tag: Tag::new(b"SMO ") }, // Samoan
    LangTag { language: "sma", 	tag: Tag::new(b"SSM ") }, // Southern Sami
    LangTag { language: "smd", 	tag: Tag::new(b"MBN ") }, // Sama(retired code) -> Mbundu
    LangTag { language: "smj", 	tag: Tag::new(b"LSM ") }, // Lule Sami
    LangTag { language: "sml", 	tag: Tag::new(&[0; 4]) }, // Central Sama != Somali
    LangTag { language: "smn", 	tag: Tag::new(b"ISM ") }, // Inari Sami
    LangTag { language: "sms", 	tag: Tag::new(b"SKS ") }, // Skolt Sami
    LangTag { language: "smt", 	tag: Tag::new(b"QIN ") }, // Simte -> Chin
    LangTag { language: "sn", 	tag: Tag::new(b"SNA0") }, // Shona
    LangTag { language: "snb", 	tag: Tag::new(b"IBA ") }, // Sebuyau(retired code) -> Iban
    LangTag { language: "snh", 	tag: Tag::new(&[0; 4]) }, // Shinabo(retired code) != Sinhala (Sinhalese)
//  LangTag { language: "snk", 	tag: Tag::new(b"SNK ") }, // Soninke
    LangTag { language: "so", 	tag: Tag::new(b"SML ") }, // Somali
    LangTag { language: "sog", 	tag: Tag::new(&[0; 4]) }, // Sogdian != Sodo Gurage
//  LangTag { language: "sop", 	tag: Tag::new(b"SOP ") }, // Songe
    LangTag { language: "spv", 	tag: Tag::new(b"ORI ") }, // Sambalpuri -> Odia
    LangTag { language: "spy", 	tag: Tag::new(b"KAL ") }, // Sabaot -> Kalenjin
    LangTag { language: "sq", 	tag: Tag::new(b"SQI ") }, // Albanian [macrolanguage]
    LangTag { language: "sr", 	tag: Tag::new(b"SRB ") }, // Serbian
    LangTag { language: "srb", 	tag: Tag::new(&[0; 4]) }, // Sora != Serbian
    LangTag { language: "src", 	tag: Tag::new(b"SRD ") }, // Logudorese Sardinian -> Sardinian
    LangTag { language: "srk", 	tag: Tag::new(&[0; 4]) }, // Serudung Murut != Saraiki
    LangTag { language: "srm", 	tag: Tag::new(b"CPP ") }, // Saramaccan -> Creoles
    LangTag { language: "srn", 	tag: Tag::new(b"CPP ") }, // Sranan Tongo -> Creoles
    LangTag { language: "sro", 	tag: Tag::new(b"SRD ") }, // Campidanese Sardinian -> Sardinian
//  LangTag { language: "srr", 	tag: Tag::new(b"SRR ") }, // Serer
    LangTag { language: "srs", 	tag: Tag::new(b"ATH ") }, // Sarsi -> Athapaskan
    LangTag { language: "ss", 	tag: Tag::new(b"SWZ ") }, // Swati
    LangTag { language: "ssh", 	tag: Tag::new(b"ARA ") }, // Shihhi Arabic -> Arabic
    LangTag { language: "ssl", 	tag: Tag::new(&[0; 4]) }, // Western Sisaala != South Slavey
    LangTag { language: "ssm", 	tag: Tag::new(&[0; 4]) }, // Semnam != Southern Sami
    LangTag { language: "st", 	tag: Tag::new(b"SOT ") }, // Southern Sotho
    LangTag { language: "sta", 	tag: Tag::new(b"CPP ") }, // Settla -> Creoles
//  LangTag { language: "stq", 	tag: Tag::new(b"STQ ") }, // Saterfriesisch -> Saterland Frisian
//  LangTag { language: "str", 	tag: Tag::new(b"STR ") }, // Straits Salish
    LangTag { language: "stv", 	tag: Tag::new(b"SIG ") }, // Silt'e -> Silte Gurage
    LangTag { language: "su", 	tag: Tag::new(b"SUN ") }, // Sundanese
//  LangTag { language: "suk", 	tag: Tag::new(b"SUK ") }, // Sukuma
    LangTag { language: "suq", 	tag: Tag::new(b"SUR ") }, // Suri
    LangTag { language: "sur", 	tag: Tag::new(&[0; 4]) }, // Mwaghavul != Suri
    LangTag { language: "sv", 	tag: Tag::new(b"SVE ") }, // Swedish
//  LangTag { language: "sva", 	tag: Tag::new(b"SVA ") }, // Svan
    LangTag { language: "svc", 	tag: Tag::new(b"CPP ") }, // Vincentian Creole English -> Creoles
    LangTag { language: "sve", 	tag: Tag::new(&[0; 4]) }, // Serili != Swedish
    LangTag { language: "sw", 	tag: Tag::new(b"SWK ") }, // Swahili  [macrolanguage]
    LangTag { language: "swb", 	tag: Tag::new(b"CMR ") }, // Maore Comorian -> Comorian
    LangTag { language: "swc", 	tag: Tag::new(b"SWK ") }, // Congo Swahili -> Swahili
    LangTag { language: "swh", 	tag: Tag::new(b"SWK ") }, // Swahili 
    LangTag { language: "swk", 	tag: Tag::new(&[0; 4]) }, // Malawi Sena != Swahili
    LangTag { language: "swn", 	tag: Tag::new(b"BBR ") }, // Sawknah -> Berber
    LangTag { language: "swv", 	tag: Tag::new(b"MAW ") }, // Shekhawati -> Marwari
//  LangTag { language: "sxu", 	tag: Tag::new(b"SXU ") }, // Upper Saxon
    LangTag { language: "syc", 	tag: Tag::new(b"SYR ") }, // Classical Syriac -> Syriac
//  LangTag { language: "syl", 	tag: Tag::new(b"SYL ") }, // Sylheti
//  LangTag { language: "syr", 	tag: Tag::new(b"SYR ") }, // Syriac [macrolanguage]
//  LangTag { language: "szl", 	tag: Tag::new(b"SZL ") }, // Silesian
    LangTag { language: "ta", 	tag: Tag::new(b"TAM ") }, // Tamil
    LangTag { language: "taa", 	tag: Tag::new(b"ATH ") }, // Lower Tanana -> Athapaskan
//  LangTag { language: "tab", 	tag: Tag::new(b"TAB ") }, // Tabassaran -> Tabasaran
    LangTag { language: "taj", 	tag: Tag::new(&[0; 4]) }, // Eastern Tamang != Tajiki
    LangTag { language: "taq", 	tag: Tag::new(b"TAQ ") }, // Tamasheq
    LangTag { language: "taq", 	tag: Tag::new(b"TMH ") }, // Tamasheq -> Tamashek
    LangTag { language: "taq", 	tag: Tag::new(b"BBR ") }, // Tamasheq -> Berber
    LangTag { language: "tas", 	tag: Tag::new(b"CPP ") }, // Tay Boi -> Creoles
    LangTag { language: "tau", 	tag: Tag::new(b"ATH ") }, // Upper Tanana -> Athapaskan
//  LangTag { language: "tbv", 	tag: Tag::new(b"TBV ") }, // Tobo
    LangTag { language: "tcb", 	tag: Tag::new(b"ATH ") }, // Tanacross -> Athapaskan
    LangTag { language: "tce", 	tag: Tag::new(b"ATH ") }, // Southern Tutchone -> Athapaskan
    LangTag { language: "tch", 	tag: Tag::new(b"CPP ") }, // Turks And Caicos Creole English -> Creoles
    LangTag { language: "tcp", 	tag: Tag::new(b"QIN ") }, // Tawr Chin -> Chin
    LangTag { language: "tcs", 	tag: Tag::new(b"CPP ") }, // Torres Strait Creole -> Creoles
    LangTag { language: "tcy", 	tag: Tag::new(b"TUL ") }, // Tulu
    LangTag { language: "tcz", 	tag: Tag::new(b"QIN ") }, // Thado Chin -> Chin
//  LangTag { language: "tdc", 	tag: Tag::new(b"TDC ") }, // Emberá-Tadó
//  LangTag { language: "tdd", 	tag: Tag::new(b"TDD ") }, // Tai Nüa -> Dehong Dai
    LangTag { language: "tdx", 	tag: Tag::new(b"MLG ") }, // Tandroy-Mahafaly Malagasy -> Malagasy
    LangTag { language: "te", 	tag: Tag::new(b"TEL ") }, // Telugu
    LangTag { language: "tec", 	tag: Tag::new(b"KAL ") }, // Terik -> Kalenjin
    LangTag { language: "tem", 	tag: Tag::new(b"TMN ") }, // Timne -> Temne
//  LangTag { language: "tet", 	tag: Tag::new(b"TET ") }, // Tetum
    LangTag { language: "tez", 	tag: Tag::new(b"BBR ") }, // Tetserret -> Berber
    LangTag { language: "tfn", 	tag: Tag::new(b"ATH ") }, // Tanaina -> Athapaskan
    LangTag { language: "tg", 	tag: Tag::new(b"TAJ ") }, // Tajik -> Tajiki
    LangTag { language: "tgh", 	tag: Tag::new(b"CPP ") }, // Tobagonian Creole English -> Creoles
    LangTag { language: "tgj", 	tag: Tag::new(b"NIS ") }, // Tagin -> Nisi
    LangTag { language: "tgn", 	tag: Tag::new(&[0; 4]) }, // Tandaganon != Tongan
    LangTag { language: "tgr", 	tag: Tag::new(&[0; 4]) }, // Tareng != Tigre
    LangTag { language: "tgx", 	tag: Tag::new(b"ATH ") }, // Tagish -> Athapaskan
    LangTag { language: "tgy", 	tag: Tag::new(&[0; 4]) }, // Togoyo != Tigrinya
    LangTag { language: "th", 	tag: Tag::new(b"THA ") }, // Thai
//  LangTag { language: "thp", 	tag: Tag::new(b"THP ") }, // Thompson
    LangTag { language: "tht", 	tag: Tag::new(b"ATH ") }, // Tahltan -> Athapaskan
    LangTag { language: "thv", 	tag: Tag::new(b"THV ") }, // Tahaggart Tamahaq
    LangTag { language: "thv", 	tag: Tag::new(b"TMH ") }, // Tahaggart Tamahaq -> Tamashek
    LangTag { language: "thv", 	tag: Tag::new(b"BBR ") }, // Tahaggart Tamahaq -> Berber
    LangTag { language: "thz", 	tag: Tag::new(b"THZ ") }, // Tayart Tamajeq
    LangTag { language: "thz", 	tag: Tag::new(b"TMH ") }, // Tayart Tamajeq -> Tamashek
    LangTag { language: "thz", 	tag: Tag::new(b"BBR ") }, // Tayart Tamajeq -> Berber
    LangTag { language: "ti", 	tag: Tag::new(b"TGY ") }, // Tigrinya
    LangTag { language: "tia", 	tag: Tag::new(b"BBR ") }, // Tidikelt Tamazight -> Berber
    LangTag { language: "tig", 	tag: Tag::new(b"TGR ") }, // Tigre
//  LangTag { language: "tiv", 	tag: Tag::new(b"TIV ") }, // Tiv
//  LangTag { language: "tjl", 	tag: Tag::new(b"TJL ") }, // Tai Laing
    LangTag { language: "tjo", 	tag: Tag::new(b"BBR ") }, // Temacine Tamazight -> Berber
    LangTag { language: "tk", 	tag: Tag::new(b"TKM ") }, // Turkmen
    LangTag { language: "tkg", 	tag: Tag::new(b"MLG ") }, // Tesaka Malagasy -> Malagasy
    LangTag { language: "tkm", 	tag: Tag::new(&[0; 4]) }, // Takelma != Turkmen
    LangTag { language: "tl", 	tag: Tag::new(b"TGL ") }, // Tagalog
//  LangTag { language: "tli", 	tag: Tag::new(b"TLI ") }, // Tlingit
//  LangTag { language: "tly", 	tag: Tag::new(b"TLY ") }, // Talysh
    LangTag { language: "tmg", 	tag: Tag::new(b"CPP ") }, // Ternateño -> Creoles
    LangTag { language: "tmh", 	tag: Tag::new(b"TMH ") }, // Tamashek [macrolanguage]
    LangTag { language: "tmh", 	tag: Tag::new(b"BBR ") }, // Tamashek [macrolanguage] -> Berber
    LangTag { language: "tmn", 	tag: Tag::new(&[0; 4]) }, // Taman (Indonesia) != Temne
    LangTag { language: "tmw", 	tag: Tag::new(b"MLY ") }, // Temuan -> Malay
    LangTag { language: "tn", 	tag: Tag::new(b"TNA ") }, // Tswana
    LangTag { language: "tna", 	tag: Tag::new(&[0; 4]) }, // Tacana != Tswana
    LangTag { language: "tne", 	tag: Tag::new(&[0; 4]) }, // Tinoc Kallahan(retired code) != Tundra Enets
    LangTag { language: "tnf", 	tag: Tag::new(b"DRI ") }, // Tangshewi(retired code) -> Dari
    LangTag { language: "tnf", 	tag: Tag::new(b"FAR ") }, // Tangshewi(retired code) -> Persian
    LangTag { language: "tng", 	tag: Tag::new(&[0; 4]) }, // Tobanga != Tonga
    LangTag { language: "to", 	tag: Tag::new(b"TGN ") }, // Tonga (Tonga Islands) -> Tongan
    LangTag { language: "tod", 	tag: Tag::new(b"TOD0") }, // Toma
    LangTag { language: "toi", 	tag: Tag::new(b"TNG ") }, // Tonga (Zambia)
    LangTag { language: "toj", 	tag: Tag::new(b"MYN ") }, // Tojolabal -> Mayan
    LangTag { language: "tol", 	tag: Tag::new(b"ATH ") }, // Tolowa -> Athapaskan
    LangTag { language: "tor", 	tag: Tag::new(b"BAD0") }, // Togbo-Vara Banda -> Banda
    LangTag { language: "tpi", 	tag: Tag::new(b"TPI ") }, // Tok Pisin
    LangTag { language: "tpi", 	tag: Tag::new(b"CPP ") }, // Tok Pisin -> Creoles
    LangTag { language: "tr", 	tag: Tag::new(b"TRK ") }, // Turkish
    LangTag { language: "trf", 	tag: Tag::new(b"CPP ") }, // Trinidadian Creole English -> Creoles
    LangTag { language: "trk", 	tag: Tag::new(&[0; 4]) }, // Turkic  [collection] != Turkish
    LangTag { language: "tru", 	tag: Tag::new(b"TUA ") }, // Turoyo -> Turoyo Aramaic
    LangTag { language: "tru", 	tag: Tag::new(b"SYR ") }, // Turoyo -> Syriac
    LangTag { language: "ts", 	tag: Tag::new(b"TSG ") }, // Tsonga
    LangTag { language: "tsg", 	tag: Tag::new(&[0; 4]) }, // Tausug != Tsonga
//  LangTag { language: "tsj", 	tag: Tag::new(b"TSJ ") }, // Tshangla
    LangTag { language: "tt", 	tag: Tag::new(b"TAT ") }, // Tatar
    LangTag { language: "ttc", 	tag: Tag::new(b"MYN ") }, // Tektiteko -> Mayan
    LangTag { language: "ttm", 	tag: Tag::new(b"ATH ") }, // Northern Tutchone -> Athapaskan
    LangTag { language: "ttq", 	tag: Tag::new(b"TTQ ") }, // Tawallammat Tamajaq
    LangTag { language: "ttq", 	tag: Tag::new(b"TMH ") }, // Tawallammat Tamajaq -> Tamashek
    LangTag { language: "ttq", 	tag: Tag::new(b"BBR ") }, // Tawallammat Tamajaq -> Berber
    LangTag { language: "tua", 	tag: Tag::new(&[0; 4]) }, // Wiarumus != Turoyo Aramaic
    LangTag { language: "tul", 	tag: Tag::new(&[0; 4]) }, // Tula != Tulu
//  LangTag { language: "tum", 	tag: Tag::new(b"TUM ") }, // Tumbuka
//  LangTag { language: "tus", 	tag: Tag::new(b"TUS ") }, // Tuscarora
    LangTag { language: "tuu", 	tag: Tag::new(b"ATH ") }, // Tututni -> Athapaskan
    LangTag { language: "tuv", 	tag: Tag::new(&[0; 4]) }, // Turkana != Tuvin
    LangTag { language: "tuy", 	tag: Tag::new(b"KAL ") }, // Tugen -> Kalenjin
//  LangTag { language: "tvl", 	tag: Tag::new(b"TVL ") }, // Tuvalu
    LangTag { language: "tvy", 	tag: Tag::new(b"CPP ") }, // Timor Pidgin -> Creoles
    LangTag { language: "tw", 	tag: Tag::new(b"TWI ") }, // Twi
    LangTag { language: "tw", 	tag: Tag::new(b"AKA ") }, // Twi -> Akan
    LangTag { language: "txc", 	tag: Tag::new(b"ATH ") }, // Tsetsaut -> Athapaskan
    LangTag { language: "txy", 	tag: Tag::new(b"MLG ") }, // Tanosy Malagasy -> Malagasy
    LangTag { language: "ty", 	tag: Tag::new(b"THT ") }, // Tahitian
    LangTag { language: "tyv", 	tag: Tag::new(b"TUV ") }, // Tuvinian -> Tuvin
//  LangTag { language: "tyz", 	tag: Tag::new(b"TYZ ") }, // Tày
    LangTag { language: "tzh", 	tag: Tag::new(b"MYN ") }, // Tzeltal -> Mayan
    LangTag { language: "tzj", 	tag: Tag::new(b"MYN ") }, // Tz'utujil -> Mayan
    LangTag { language: "tzm", 	tag: Tag::new(b"TZM ") }, // Central Atlas Tamazight -> Tamazight
    LangTag { language: "tzm", 	tag: Tag::new(b"BBR ") }, // Central Atlas Tamazight -> Berber
    LangTag { language: "tzo", 	tag: Tag::new(b"TZO ") }, // Tzotzil
    LangTag { language: "tzo", 	tag: Tag::new(b"MYN ") }, // Tzotzil -> Mayan
    LangTag { language: "ubl", 	tag: Tag::new(b"BIK ") }, // Buhi'non Bikol -> Bikol
//  LangTag { language: "udi", 	tag: Tag::new(b"UDI ") }, // Udi
//  LangTag { language: "udm", 	tag: Tag::new(b"UDM ") }, // Udmurt
    LangTag { language: "ug", 	tag: Tag::new(b"UYG ") }, // Uyghur
    LangTag { language: "uk", 	tag: Tag::new(b"UKR ") }, // Ukrainian
    LangTag { language: "uki", 	tag: Tag::new(b"KUI ") }, // Kui (India)
    LangTag { language: "uln", 	tag: Tag::new(b"CPP ") }, // Unserdeutsch -> Creoles
//  LangTag { language: "umb", 	tag: Tag::new(b"UMB ") }, // Umbundu
    LangTag { language: "unr", 	tag: Tag::new(b"MUN ") }, // Mundari
    LangTag { language: "ur", 	tag: Tag::new(b"URD ") }, // Urdu
    LangTag { language: "urk", 	tag: Tag::new(b"MLY ") }, // Urak Lawoi' -> Malay
    LangTag { language: "usp", 	tag: Tag::new(b"MYN ") }, // Uspanteco -> Mayan
    LangTag { language: "uz", 	tag: Tag::new(b"UZB ") }, // Uzbek [macrolanguage]
    LangTag { language: "uzn", 	tag: Tag::new(b"UZB ") }, // Northern Uzbek -> Uzbek
    LangTag { language: "uzs", 	tag: Tag::new(b"UZB ") }, // Southern Uzbek -> Uzbek
    LangTag { language: "vap", 	tag: Tag::new(b"QIN ") }, // Vaiphei -> Chin
    LangTag { language: "ve", 	tag: Tag::new(b"VEN ") }, // Venda
//  LangTag { language: "vec", 	tag: Tag::new(b"VEC ") }, // Venetian
    LangTag { language: "vi", 	tag: Tag::new(b"VIT ") }, // Vietnamese
    LangTag { language: "vic", 	tag: Tag::new(b"CPP ") }, // Virgin Islands Creole English -> Creoles
    LangTag { language: "vit", 	tag: Tag::new(&[0; 4]) }, // Viti != Vietnamese
    LangTag { language: "vkk", 	tag: Tag::new(b"MLY ") }, // Kaur -> Malay
    LangTag { language: "vkp", 	tag: Tag::new(b"CPP ") }, // Korlai Creole Portuguese -> Creoles
    LangTag { language: "vkt", 	tag: Tag::new(b"MLY ") }, // Tenggarong Kutai Malay -> Malay
    LangTag { language: "vls", 	tag: Tag::new(b"FLE ") }, // Vlaams -> Dutch (Flemish)
    LangTag { language: "vmw", 	tag: Tag::new(b"MAK ") }, // Makhuwa
    LangTag { language: "vo", 	tag: Tag::new(b"VOL ") }, // Volapük
    LangTag { language: "vro", 	tag: Tag::new(b"VRO ") }, // Võro
    LangTag { language: "vro", 	tag: Tag::new(b"ETI ") }, // Võro -> Estonian
    LangTag { language: "vsn", 	tag: Tag::new(b"SAN ") }, // Vedic Sanskrit -> Sanskrit
    LangTag { language: "wa", 	tag: Tag::new(b"WLN ") }, // Walloon
    LangTag { language: "wag", 	tag: Tag::new(&[0; 4]) }, // Wa'ema != Wagdi
//  LangTag { language: "war", 	tag: Tag::new(b"WAR ") }, // Waray (Philippines) -> Waray-Waray
//  LangTag { language: "wbl", 	tag: Tag::new(b"WBL ") }, // Wakhi
    LangTag { language: "wbm", 	tag: Tag::new(b"WA  ") }, // Wa
    LangTag { language: "wbr", 	tag: Tag::new(b"WAG ") }, // Wagdi
    LangTag { language: "wbr", 	tag: Tag::new(b"RAJ ") }, // Wagdi -> Rajasthani
//  LangTag { language: "wci", 	tag: Tag::new(b"WCI ") }, // Waci Gbe
//  LangTag { language: "wdt", 	tag: Tag::new(b"WDT ") }, // Wendat
    LangTag { language: "wea", 	tag: Tag::new(b"KRN ") }, // Wewaw -> Karen
    LangTag { language: "wes", 	tag: Tag::new(b"CPP ") }, // Cameroon Pidgin -> Creoles
    LangTag { language: "weu", 	tag: Tag::new(b"QIN ") }, // Rawngtu Chin -> Chin
    LangTag { language: "wlc", 	tag: Tag::new(b"CMR ") }, // Mwali Comorian -> Comorian
    LangTag { language: "wle", 	tag: Tag::new(b"SIG ") }, // Wolane -> Silte Gurage
    LangTag { language: "wlk", 	tag: Tag::new(b"ATH ") }, // Wailaki -> Athapaskan
    LangTag { language: "wni", 	tag: Tag::new(b"CMR ") }, // Ndzwani Comorian -> Comorian
    LangTag { language: "wo", 	tag: Tag::new(b"WLF ") }, // Wolof
    LangTag { language: "wry", 	tag: Tag::new(b"MAW ") }, // Merwari -> Marwari
    LangTag { language: "wsg", 	tag: Tag::new(b"GON ") }, // Adilabad Gondi -> Gondi
//  LangTag { language: "wtm", 	tag: Tag::new(b"WTM ") }, // Mewati
    LangTag { language: "wuu", 	tag: Tag::new(b"ZHS ") }, // Wu Chinese -> Chinese, Simplified
    LangTag { language: "wya", 	tag: Tag::new(b"WDT ") }, // Wyandot(retired code) -> Wendat
    LangTag { language: "wya", 	tag: Tag::new(b"WYN ") }, // Wyandot(retired code)
//  LangTag { language: "wyn", 	tag: Tag::new(b"WYN ") }, // Wyandot
    LangTag { language: "xal", 	tag: Tag::new(b"KLM ") }, // Kalmyk
    LangTag { language: "xal", 	tag: Tag::new(b"TOD ") }, // Kalmyk -> Todo
    LangTag { language: "xan", 	tag: Tag::new(b"SEK ") }, // Xamtanga -> Sekota
    LangTag { language: "xbd", 	tag: Tag::new(&[0; 4]) }, // Bindal != Lü
    LangTag { language: "xh", 	tag: Tag::new(b"XHS ") }, // Xhosa
//  LangTag { language: "xjb", 	tag: Tag::new(b"XJB ") }, // Minjungbal -> Minjangbal
//  LangTag { language: "xkf", 	tag: Tag::new(b"XKF ") }, // Khengkha
    LangTag { language: "xmg", 	tag: Tag::new(b"BML ") }, // Mengaka -> Bamileke
    LangTag { language: "xmm", 	tag: Tag::new(b"MLY ") }, // Manado Malay -> Malay
    LangTag { language: "xmm", 	tag: Tag::new(b"CPP ") }, // Manado Malay -> Creoles
    LangTag { language: "xmv", 	tag: Tag::new(b"MLG ") }, // Antankarana Malagasy -> Malagasy
    LangTag { language: "xmw", 	tag: Tag::new(b"MLG ") }, // Tsimihety Malagasy -> Malagasy
    LangTag { language: "xnj", 	tag: Tag::new(b"SXT ") }, // Ngoni (Tanzania) -> Sutu
    LangTag { language: "xnq", 	tag: Tag::new(b"SXT ") }, // Ngoni (Mozambique) -> Sutu
    LangTag { language: "xnr", 	tag: Tag::new(b"DGR ") }, // Kangri -> Dogri (macrolanguage)
//  LangTag { language: "xog", 	tag: Tag::new(b"XOG ") }, // Soga
    LangTag { language: "xpe", 	tag: Tag::new(b"XPE ") }, // Liberia Kpelle -> Kpelle (Liberia)
    LangTag { language: "xpe", 	tag: Tag::new(b"KPL ") }, // Liberia Kpelle -> Kpelle
    LangTag { language: "xsl", 	tag: Tag::new(b"SSL ") }, // South Slavey
    LangTag { language: "xsl", 	tag: Tag::new(b"SLA ") }, // South Slavey -> Slavey
    LangTag { language: "xsl", 	tag: Tag::new(b"ATH ") }, // South Slavey -> Athapaskan
    LangTag { language: "xst", 	tag: Tag::new(b"SIG ") }, // Silt'e(retired code) -> Silte Gurage
//  LangTag { language: "xub", 	tag: Tag::new(b"XUB ") }, // Betta Kurumba -> Bette Kuruma
//  LangTag { language: "xuj", 	tag: Tag::new(b"XUJ ") }, // Jennu Kurumba -> Jennu Kuruma
    LangTag { language: "xup", 	tag: Tag::new(b"ATH ") }, // Upper Umpqua -> Athapaskan
    LangTag { language: "xwo", 	tag: Tag::new(b"TOD ") }, // Written Oirat -> Todo
    LangTag { language: "yaj", 	tag: Tag::new(b"BAD0") }, // Banda-Yangere -> Banda
    LangTag { language: "yak", 	tag: Tag::new(&[0; 4]) }, // Yakama != Sakha
//  LangTag { language: "yao", 	tag: Tag::new(b"YAO ") }, // Yao
//  LangTag { language: "yap", 	tag: Tag::new(b"YAP ") }, // Yapese
    LangTag { language: "yba", 	tag: Tag::new(&[0; 4]) }, // Yala != Yoruba
    LangTag { language: "ybb", 	tag: Tag::new(b"BML ") }, // Yemba -> Bamileke
    LangTag { language: "ybd", 	tag: Tag::new(b"ARK ") }, // Yangbye(retired code) -> Rakhine
    LangTag { language: "ycr", 	tag: Tag::new(b"CPP ") }, // Yilan Creole -> Creoles
    LangTag { language: "ydd", 	tag: Tag::new(b"JII ") }, // Eastern Yiddish -> Yiddish
//  LangTag { language: "ygp", 	tag: Tag::new(b"YGP ") }, // Gepo
    LangTag { language: "yi", 	tag: Tag::new(b"JII ") }, // Yiddish [macrolanguage]
    LangTag { language: "yih", 	tag: Tag::new(b"JII ") }, // Western Yiddish -> Yiddish
    LangTag { language: "yim", 	tag: Tag::new(&[0; 4]) }, // Yimchungru Naga != Yi Modern
//  LangTag { language: "yna", 	tag: Tag::new(b"YNA ") }, // Aluo
    LangTag { language: "yo", 	tag: Tag::new(b"YBA ") }, // Yoruba
    LangTag { language: "yos", 	tag: Tag::new(b"QIN ") }, // Yos(retired code) -> Chin
    LangTag { language: "yua", 	tag: Tag::new(b"MYN ") }, // Yucateco -> Mayan
    LangTag { language: "yue", 	tag: Tag::new(b"ZHH ") }, // Yue Chinese -> Chinese, Traditional, Hong Kong SAR
//  LangTag { language: "yuf", 	tag: Tag::new(b"YUF ") }, // Havasupai-Walapai-Yavapai
//  LangTag { language: "ywq", 	tag: Tag::new(b"YWQ ") }, // Wuding-Luquan Yi
    LangTag { language: "za", 	tag: Tag::new(b"ZHA ") }, // Zhuang [macrolanguage]
    LangTag { language: "zch", 	tag: Tag::new(b"ZHA ") }, // Central Hongshuihe Zhuang -> Zhuang
    LangTag { language: "zdj", 	tag: Tag::new(b"CMR ") }, // Ngazidja Comorian -> Comorian
//  LangTag { language: "zea", 	tag: Tag::new(b"ZEA ") }, // Zeeuws -> Zealandic
    LangTag { language: "zeh", 	tag: Tag::new(b"ZHA ") }, // Eastern Hongshuihe Zhuang -> Zhuang
    LangTag { language: "zen", 	tag: Tag::new(b"BBR ") }, // Zenaga -> Berber
    LangTag { language: "zgb", 	tag: Tag::new(b"ZHA ") }, // Guibei Zhuang -> Zhuang
    LangTag { language: "zgh", 	tag: Tag::new(b"ZGH ") }, // Standard Moroccan Tamazight
    LangTag { language: "zgh", 	tag: Tag::new(b"BBR ") }, // Standard Moroccan Tamazight -> Berber
    LangTag { language: "zgm", 	tag: Tag::new(b"ZHA ") }, // Minz Zhuang -> Zhuang
    LangTag { language: "zgn", 	tag: Tag::new(b"ZHA ") }, // Guibian Zhuang -> Zhuang
    LangTag { language: "zh", 	tag: Tag::new(b"ZHS ") }, // Chinese, Simplified [macrolanguage]
    LangTag { language: "zhd", 	tag: Tag::new(b"ZHA ") }, // Dai Zhuang -> Zhuang
    LangTag { language: "zhn", 	tag: Tag::new(b"ZHA ") }, // Nong Zhuang -> Zhuang
    LangTag { language: "zkb", 	tag: Tag::new(b"KHA ") }, // Koibal(retired code) -> Khakass
    LangTag { language: "zlj", 	tag: Tag::new(b"ZHA ") }, // Liujiang Zhuang -> Zhuang
    LangTag { language: "zlm", 	tag: Tag::new(b"MLY ") }, // Malay 
    LangTag { language: "zln", 	tag: Tag::new(b"ZHA ") }, // Lianshan Zhuang -> Zhuang
    LangTag { language: "zlq", 	tag: Tag::new(b"ZHA ") }, // Liuqian Zhuang -> Zhuang
    LangTag { language: "zmi", 	tag: Tag::new(b"MLY ") }, // Negeri Sembilan Malay -> Malay
    LangTag { language: "zmz", 	tag: Tag::new(b"BAD0") }, // Mbandja -> Banda
    LangTag { language: "znd", 	tag: Tag::new(&[0; 4]) }, // Zande  [collection] != Zande
    LangTag { language: "zne", 	tag: Tag::new(b"ZND ") }, // Zande 
    LangTag { language: "zom", 	tag: Tag::new(b"QIN ") }, // Zou -> Chin
    LangTag { language: "zqe", 	tag: Tag::new(b"ZHA ") }, // Qiubei Zhuang -> Zhuang
    LangTag { language: "zsm", 	tag: Tag::new(b"MLY ") }, // Standard Malay -> Malay
    LangTag { language: "zu", 	tag: Tag::new(b"ZUL ") }, // Zulu
    LangTag { language: "zum", 	tag: Tag::new(b"LRC ") }, // Kumzari -> Luri
    LangTag { language: "zyb", 	tag: Tag::new(b"ZHA ") }, // Yongbei Zhuang -> Zhuang
    LangTag { language: "zyg", 	tag: Tag::new(b"ZHA ") }, // Yang Zhuang -> Zhuang
    LangTag { language: "zyj", 	tag: Tag::new(b"ZHA ") }, // Youjiang Zhuang -> Zhuang
    LangTag { language: "zyn", 	tag: Tag::new(b"ZHA ") }, // Yongnan Zhuang -> Zhuang
    LangTag { language: "zyp", 	tag: Tag::new(b"QIN ") }, // Zyphe Chin -> Chin
//  LangTag { language: "zza", 	tag: Tag::new(b"ZZA ") }, // Zazaki [macrolanguage]
    LangTag { language: "zzj", 	tag: Tag::new(b"ZHA ") }, // Zuojiang Zhuang -> Zhuang
];

fn subtag_matches(language: &str, subtag: &str) -> bool {
    for (i, _) in language.match_indices(subtag) {
        if let Some(c) = language.as_bytes().get(i + subtag.len()) {
            if !c.is_ascii_alphanumeric() {
                return true;
            }
        } else {
            return true;
        }
    }

    false
}

fn lang_matches(language: &str, spec: &str) -> bool {
    if language.starts_with(spec) {
        return language.len() == spec.len() || language.as_bytes().get(spec.len()) == Some(&b'-');
    }

    false
}

fn strncmp(s1: &str, s2: &str, n: usize) -> bool {
    let n1 = core::cmp::min(n, s1.len());
    let n2 = core::cmp::min(n, s2.len());
    s1[..n1] == s2[..n2]
}

/// Converts a multi-subtag BCP 47 language tag to language tags.
pub fn tags_from_complex_language(language: &str, tags: &mut smallvec::SmallVec<[Tag; 3]>) -> bool {
    if subtag_matches(language, "-fonnapa") {
        // Undetermined; North American Phonetic Alphabet
        tags.push(Tag::new(b"APPH")); // Phonetic transcription—Americanist conventions
        return true;
    }
    if subtag_matches(language, "-polyton") {
        // Modern Greek (1453-); Polytonic Greek
        tags.push(Tag::new(b"PGR ")); // Polytonic Greek
        return true;
    }
    if subtag_matches(language, "-arevmda") {
        // Armenian; Western Armenian (retired code)
        tags.push(Tag::new(b"HYE ")); // Armenian
        return true;
    }
    if subtag_matches(language, "-provenc") {
        // Occitan (post 1500); Provençal
        tags.push(Tag::new(b"PRO ")); // Provençal / Old Provençal
        return true;
    }
    if subtag_matches(language, "-fonipa") {
        // Undetermined; International Phonetic Alphabet
        tags.push(Tag::new(b"IPPH")); // Phonetic transcription—IPA conventions
        return true;
    }
    if subtag_matches(language, "-geok") {
        // Undetermined; Khutsuri (Asomtavruli and Nuskhuri)
        tags.push(Tag::new(b"KGE ")); // Khutsuri Georgian
        return true;
    }
    if subtag_matches(language, "-syre") {
        // Undetermined; Syriac (Estrangelo variant)
        tags.push(Tag::new(b"SYRE")); // Syriac, Estrangela script-variant (equivalent to ISO 15924 'Syre')
        return true;
    }
    if subtag_matches(language, "-syrj") {
        // Undetermined; Syriac (Western variant)
        tags.push(Tag::new(b"SYRJ")); // Syriac, Western script-variant (equivalent to ISO 15924 'Syrj')
        return true;
    }
    if subtag_matches(language, "-syrn") {
        // Undetermined; Syriac (Eastern variant)
        tags.push(Tag::new(b"SYRN")); // Syriac, Eastern script-variant (equivalent to ISO 15924 'Syrn')
        return true;
    }
    match language.as_bytes()[0] {
        b'a' => {
            if &language[1..] == "rt-lojban" {
                // Lojban(retired code)
                tags.push(Tag::new(b"JBO ")); // Lojban
                return true;
            }
        }
        b'c' => {
            if lang_matches(&language[1..], "do-hant-hk") {
                // Min Dong Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "do-hant-mo") {
                // Min Dong Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "jy-hant-hk") {
                // Jinyu Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "jy-hant-mo") {
                // Jinyu Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "mn-hant-hk") {
                // Mandarin Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "mn-hant-mo") {
                // Mandarin Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "np-hant-hk") {
                // Northern Ping Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "np-hant-mo") {
                // Northern Ping Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "px-hant-hk") {
                // Pu-Xian Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "px-hant-mo") {
                // Pu-Xian Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "sp-hant-hk") {
                // Southern Ping Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "sp-hant-mo") {
                // Southern Ping Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "zh-hant-hk") {
                // Huizhou Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "zh-hant-mo") {
                // Huizhou Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "zo-hant-hk") {
                // Min Zhong Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "zo-hant-mo") {
                // Min Zhong Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "do-hans") {
                // Min Dong Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "do-hant") {
                // Min Dong Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "jy-hans") {
                // Jinyu Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "jy-hant") {
                // Jinyu Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "mn-hans") {
                // Mandarin Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "mn-hant") {
                // Mandarin Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "np-hans") {
                // Northern Ping Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "np-hant") {
                // Northern Ping Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "px-hans") {
                // Pu-Xian Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "px-hant") {
                // Pu-Xian Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "sp-hans") {
                // Southern Ping Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "sp-hant") {
                // Southern Ping Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "zh-hans") {
                // Huizhou Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "zh-hant") {
                // Huizhou Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "zo-hans") {
                // Min Zhong Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "zo-hant") {
                // Min Zhong Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "do-", 3) && subtag_matches(language, "-hk") {
                // Min Dong Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "do-", 3) && subtag_matches(language, "-mo") {
                // Min Dong Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "do-", 3) && subtag_matches(language, "-tw") {
                // Min Dong Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "jy-", 3) && subtag_matches(language, "-hk") {
                // Jinyu Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "jy-", 3) && subtag_matches(language, "-mo") {
                // Jinyu Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "jy-", 3) && subtag_matches(language, "-tw") {
                // Jinyu Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "mn-", 3) && subtag_matches(language, "-hk") {
                // Mandarin Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "mn-", 3) && subtag_matches(language, "-mo") {
                // Mandarin Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "mn-", 3) && subtag_matches(language, "-tw") {
                // Mandarin Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-hk") {
                // Northern Ping Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-mo") {
                // Northern Ping Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-tw") {
                // Northern Ping Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "px-", 3) && subtag_matches(language, "-hk") {
                // Pu-Xian Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "px-", 3) && subtag_matches(language, "-mo") {
                // Pu-Xian Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "px-", 3) && subtag_matches(language, "-tw") {
                // Pu-Xian Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "sp-", 3) && subtag_matches(language, "-hk") {
                // Southern Ping Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "sp-", 3) && subtag_matches(language, "-mo") {
                // Southern Ping Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "sp-", 3) && subtag_matches(language, "-tw") {
                // Southern Ping Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "zh-", 3) && subtag_matches(language, "-hk") {
                // Huizhou Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "zh-", 3) && subtag_matches(language, "-mo") {
                // Huizhou Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "zh-", 3) && subtag_matches(language, "-tw") {
                // Huizhou Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "zo-", 3) && subtag_matches(language, "-hk") {
                // Min Zhong Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "zo-", 3) && subtag_matches(language, "-mo") {
                // Min Zhong Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "zo-", 3) && subtag_matches(language, "-tw") {
                // Min Zhong Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
        }
        b'g' => {
            if lang_matches(&language[1..], "an-hant-hk") {
                // Gan Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "an-hant-mo") {
                // Gan Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "an-hans") {
                // Gan Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "an-hant") {
                // Gan Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "a-latg") {
                // Irish; Latin (Gaelic variant)
                tags.push(Tag::new(b"IRT ")); // Irish Traditional
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-hk") {
                // Gan Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-mo") {
                // Gan Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-tw") {
                // Gan Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
        }
        b'h' => {
            if lang_matches(&language[1..], "ak-hant-hk") {
                // Hakka Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "ak-hant-mo") {
                // Hakka Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "nm-hant-hk") {
                // Hainanese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "nm-hant-mo") {
                // Hainanese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "sn-hant-hk") {
                // Xiang Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "sn-hant-mo") {
                // Xiang Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "ak-hans") {
                // Hakka Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "ak-hant") {
                // Hakka Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "nm-hans") {
                // Hainanese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "nm-hant") {
                // Hainanese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "sn-hans") {
                // Xiang Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "sn-hant") {
                // Xiang Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "ak-", 3) && subtag_matches(language, "-hk") {
                // Hakka Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "ak-", 3) && subtag_matches(language, "-mo") {
                // Hakka Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "ak-", 3) && subtag_matches(language, "-tw") {
                // Hakka Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "nm-", 3) && subtag_matches(language, "-hk") {
                // Hainanese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "nm-", 3) && subtag_matches(language, "-mo") {
                // Hainanese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "nm-", 3) && subtag_matches(language, "-tw") {
                // Hainanese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "sn-", 3) && subtag_matches(language, "-hk") {
                // Xiang Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "sn-", 3) && subtag_matches(language, "-mo") {
                // Xiang Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "sn-", 3) && subtag_matches(language, "-tw") {
                // Xiang Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
        }
        b'i' => {
            if &language[1..] == "-navajo" {
                // Navajo(retired code)
                let possible_tags = &[
                    Tag::new(b"NAV "), // Navajo
                    Tag::new(b"ATH "), // Athapaskan
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if &language[1..] == "-hak" {
                // Hakka(retired code)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if &language[1..] == "-lux" {
                // Luxembourgish(retired code)
                tags.push(Tag::new(b"LTZ ")); // Luxembourgish
                return true;
            }
        }
        b'l' => {
            if lang_matches(&language[1..], "uh-hant-hk") {
                // Leizhou Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "uh-hant-mo") {
                // Leizhou Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "uh-hans") {
                // Leizhou Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "uh-hant") {
                // Leizhou Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if lang_matches(&language[1..], "zh-hans") {
                // Literary Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if strncmp(&language[1..], "uh-", 3) && subtag_matches(language, "-hk") {
                // Leizhou Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "uh-", 3) && subtag_matches(language, "-mo") {
                // Leizhou Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "uh-", 3) && subtag_matches(language, "-tw") {
                // Leizhou Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
        }
        b'm' => {
            if lang_matches(&language[1..], "np-hant-hk") {
                // Min Bei Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "np-hant-mo") {
                // Min Bei Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "np-hans") {
                // Min Bei Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "np-hant") {
                // Min Bei Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-hk") {
                // Min Bei Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-mo") {
                // Min Bei Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-tw") {
                // Min Bei Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "nw-", 3) && subtag_matches(language, "-th") {
                // Mon; Thailand
                tags.push(Tag::new(b"MONT")); // Thailand Mon
                return true;
            }
        }
        b'n' => {
            if lang_matches(&language[1..], "an-hant-hk") {
                // Min Nan Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "an-hant-mo") {
                // Min Nan Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "an-hans") {
                // Min Nan Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "an-hant") {
                // Min Nan Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-hk") {
                // Min Nan Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-mo") {
                // Min Nan Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-tw") {
                // Min Nan Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if &language[1..] == "o-bok" {
                // Norwegian Bokmal(retired code)
                tags.push(Tag::new(b"NOR ")); // Norwegian
                return true;
            }
            if &language[1..] == "o-nyn" {
                // Norwegian Nynorsk(retired code)
                tags.push(Tag::new(b"NYN ")); // Norwegian Nynorsk (Nynorsk, Norwegian)
                return true;
            }
        }
        b'r' => {
            if strncmp(&language[1..], "o-", 2) && subtag_matches(language, "-md") {
                // Romanian; Moldova
                let possible_tags = &[
                    Tag::new(b"MOL "), // Moldavian
                    Tag::new(b"ROM "), // Romanian
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
        }
        b's' => {
            if lang_matches(&language[1..], "jc-hant-hk") {
                // Shaojiang Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "jc-hant-mo") {
                // Shaojiang Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "jc-hans") {
                // Shaojiang Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "jc-hant") {
                // Shaojiang Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "jc-", 3) && subtag_matches(language, "-hk") {
                // Shaojiang Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "jc-", 3) && subtag_matches(language, "-mo") {
                // Shaojiang Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "jc-", 3) && subtag_matches(language, "-tw") {
                // Shaojiang Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
        }
        b'w' => {
            if lang_matches(&language[1..], "uu-hant-hk") {
                // Wu Chinese; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "uu-hant-mo") {
                // Wu Chinese; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if lang_matches(&language[1..], "uu-hans") {
                // Wu Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "uu-hant") {
                // Wu Chinese; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if strncmp(&language[1..], "uu-", 3) && subtag_matches(language, "-hk") {
                // Wu Chinese; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "uu-", 3) && subtag_matches(language, "-mo") {
                // Wu Chinese; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "uu-", 3) && subtag_matches(language, "-tw") {
                // Wu Chinese; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
        }
        b'y' => {
            if lang_matches(&language[1..], "ue-hans") {
                // Yue Chinese; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
        }
        b'z' => {
            if lang_matches(&language[1..], "h-hant-hk") {
                // Chinese [macrolanguage]; Han (Traditional variant); Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "h-hant-mo") {
                // Chinese [macrolanguage]; Han (Traditional variant); Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if &language[1..] == "h-min-nan" {
                // Minnan, Hokkien, Amoy, Taiwanese, Southern Min, Southern Fujian, Hoklo, Southern Fukien, Ho-lo(retired code)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "h-hans") {
                // Chinese [macrolanguage]; Han (Simplified variant)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if lang_matches(&language[1..], "h-hant") {
                // Chinese [macrolanguage]; Han (Traditional variant)
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
            if &language[1..] == "h-min" {
                // Min, Fuzhou, Hokkien, Amoy, or Taiwanese(retired code)
                tags.push(Tag::new(b"ZHS ")); // Chinese, Simplified
                return true;
            }
            if strncmp(&language[1..], "h-", 2) && subtag_matches(language, "-hk") {
                // Chinese [macrolanguage]; Hong Kong
                tags.push(Tag::new(b"ZHH ")); // Chinese, Traditional, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "h-", 2) && subtag_matches(language, "-mo") {
                // Chinese [macrolanguage]; Macao
                let possible_tags = &[
                    Tag::new(b"ZHTM"), // Chinese, Traditional, Macao SAR
                    Tag::new(b"ZHH "), // Chinese, Traditional, Hong Kong SAR
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if strncmp(&language[1..], "h-", 2) && subtag_matches(language, "-tw") {
                // Chinese [macrolanguage]; Taiwan, Province of China
                tags.push(Tag::new(b"ZHT ")); // Chinese, Traditional
                return true;
            }
        }
        _ => {}
    }
    false
}
