/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#pragma once

#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdint.h>

G_BEGIN_DECLS

/**
 * MctUserType:
 * @MCT_USER_TYPE_UNKNOWN: Unknown user account
 * @MCT_USER_TYPE_SYSTEM: System user (such as for running a daemon)
 * @MCT_USER_TYPE_CHILD: Child user (i.e. a non-administrator)
 * @MCT_USER_TYPE_PARENT: Parent user (i.e. an administrator)
 *
 * Type of a user account.
 *
 * Since: 0.14.0
 */
typedef enum
{
  MCT_USER_TYPE_UNKNOWN = 0,
  MCT_USER_TYPE_SYSTEM,
  MCT_USER_TYPE_CHILD,
  MCT_USER_TYPE_PARENT,
} MctUserType;

#define MCT_TYPE_USER mct_user_get_type ()
G_DECLARE_FINAL_TYPE (MctUser, mct_user, MCT, USER, GObject)

uid_t mct_user_get_uid (MctUser *self);
const char *mct_user_get_username (MctUser *self);
const char *mct_user_get_real_name (MctUser *self);
const char *mct_user_get_display_name (MctUser *self);
MctUserType mct_user_get_user_type (MctUser *self);
const char *mct_user_get_icon_path (MctUser *self);
uint64_t mct_user_get_login_time (MctUser *self);
const char *mct_user_get_locale (MctUser *self);

gboolean mct_user_equal (MctUser *a,
                         MctUser *b);

gboolean mct_user_is_in_same_family (MctUser *self,
                                     MctUser *other);

gboolean mct_user_is_parent_of (MctUser *self,
                                MctUser *other);

G_END_DECLS
