#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0061\x0072";
static constexpr OUStringLiteral langDefaultName = u"\x0041\x0072\x0061\x0062\x0069\x0063";
static constexpr OUStringLiteral countryID = u"\x0053\x0041";
static constexpr OUStringLiteral countryDefaultName = u"\x0053\x0061\x0075\x0064\x0069\x0020\x0041\x0072\x0061\x0062\x0069\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_ar_SA(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}


static constexpr OUStringLiteral LC_CTYPE_Unoid = u"";
static constexpr OUStringLiteral dateSeparator = u"\x002f";
static constexpr OUStringLiteral thousandSeparator = u"\x066c";
static constexpr OUStringLiteral decimalSeparator = u"\x066b";
static constexpr OUStringLiteral decimalSeparatorAlternative = u"\x002e";
static constexpr OUStringLiteral timeSeparator = u"\x003a";
static constexpr OUStringLiteral time100SecSeparator = u"\x002e";
static constexpr OUStringLiteral listSeparator = u"\x003b";
static constexpr OUStringLiteral LongDateDayOfWeekSeparator = u"\x060c\x0020";
static constexpr OUStringLiteral LongDateDaySeparator = u"\x060c\x0020";
static constexpr OUStringLiteral LongDateMonthSeparator = u"\x060c\x0020";
static constexpr OUStringLiteral LongDateYearSeparator = u"\x0020";
static constexpr OUStringLiteral quotationStart = u"\x2018";
static constexpr OUStringLiteral quotationEnd = u"\x2019";
static constexpr OUStringLiteral doubleQuotationStart = u"\x0022";
static constexpr OUStringLiteral doubleQuotationEnd = u"\x0022";
static constexpr OUStringLiteral timeAM = u"\x0635";
static constexpr OUStringLiteral timePM = u"\x0645";
static constexpr OUStringLiteral measurementSystem = u"\x006d\x0065\x0074\x0072\x0069\x0063";

static constexpr OUString LCType[] = {
	LC_CTYPE_Unoid,
	dateSeparator,
	thousandSeparator,
	decimalSeparator,
	timeSeparator,
	time100SecSeparator,
	listSeparator,
	quotationStart,
	quotationEnd,
	doubleQuotationStart,
	doubleQuotationEnd,
	timeAM,
	timePM,
	measurementSystem,
	LongDateDayOfWeekSeparator,
	LongDateDaySeparator,
	LongDateMonthSeparator,
	LongDateYearSeparator,
	decimalSeparatorAlternative
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLocaleItem_ar_SA(sal_Int16& count)
{
	count = std::size(LCType);
	return (OUString const *)LCType;
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x631, 0x2e, 0x633, 0x2e, 0x200f, 0x2d, 0x34, 0x30, 0x31, 0x5d, 0x0};
extern OUString const * getAllFormats0_ar_EG(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_ar_SA(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_ar_EG(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_ar_SA(sal_Int16& count)
{
	return getDateAcceptancePatterns_ar_EG(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_ar_SA(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_ar_SA(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_ar_SA(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_ar_SA(sal_Int16& count)
{
	return getIndexAlgorithm_ar_EG(count);
}
extern const OUString *  getUnicodeScripts_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_ar_SA(sal_Int16& count)
{
	return getUnicodeScripts_ar_EG(count);
}
extern const OUString *  getFollowPageWords_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_ar_SA(sal_Int16& count)
{
	return getFollowPageWords_ar_EG(count);
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayID00 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName00 = u"\x0627\x0644\x0623\x062d\x062f";
static constexpr OUStringLiteral dayDefaultFullName00 = u"\x0627\x0644\x0623\x062d\x062f";
static constexpr OUStringLiteral dayDefaultNarrowName00 = u"\x0627";
static constexpr OUStringLiteral dayID01 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName01 = u"\x0627\x0644\x0627\x062b\x0646\x064a\x0646";
static constexpr OUStringLiteral dayDefaultFullName01 = u"\x0627\x0644\x0627\x062b\x0646\x064a\x0646";
static constexpr OUStringLiteral dayDefaultNarrowName01 = u"\x0627";
static constexpr OUStringLiteral dayID02 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName02 = u"\x0627\x0644\x062b\x0644\x0627\x062b\x0627\x0621";
static constexpr OUStringLiteral dayDefaultFullName02 = u"\x0627\x0644\x062b\x0644\x0627\x062b\x0627\x0621";
static constexpr OUStringLiteral dayDefaultNarrowName02 = u"\x0627";
static constexpr OUStringLiteral dayID03 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName03 = u"\x0627\x0644\x0623\x0631\x0628\x0639\x0627\x0621";
static constexpr OUStringLiteral dayDefaultFullName03 = u"\x0627\x0644\x0623\x0631\x0628\x0639\x0627\x0621";
static constexpr OUStringLiteral dayDefaultNarrowName03 = u"\x0627";
static constexpr OUStringLiteral dayID04 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName04 = u"\x0627\x0644\x062e\x0645\x064a\x0633";
static constexpr OUStringLiteral dayDefaultFullName04 = u"\x0627\x0644\x062e\x0645\x064a\x0633";
static constexpr OUStringLiteral dayDefaultNarrowName04 = u"\x0627";
static constexpr OUStringLiteral dayID05 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName05 = u"\x0627\x0644\x062c\x0645\x0639\x0629";
static constexpr OUStringLiteral dayDefaultFullName05 = u"\x0627\x0644\x062c\x0645\x0639\x0629";
static constexpr OUStringLiteral dayDefaultNarrowName05 = u"\x0627";
static constexpr OUStringLiteral dayID06 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName06 = u"\x0627\x0644\x0633\x0628\x062a";
static constexpr OUStringLiteral dayDefaultFullName06 = u"\x0627\x0644\x0633\x0628\x062a";
static constexpr OUStringLiteral dayDefaultNarrowName06 = u"\x0627";
static constexpr OUStringLiteral monthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName00 = u"\x064a\x0646\x0627\x064a\x0631";
static constexpr OUStringLiteral monthDefaultFullName00 = u"\x064a\x0646\x0627\x064a\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName00 = u"\x064a";
static constexpr OUStringLiteral monthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral monthDefaultAbbrvName01 = u"\x0641\x0628\x0631\x0627\x064a\x0631";
static constexpr OUStringLiteral monthDefaultFullName01 = u"\x0641\x0628\x0631\x0627\x064a\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName01 = u"\x0641";
static constexpr OUStringLiteral monthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName02 = u"\x0645\x0627\x0631\x0633";
static constexpr OUStringLiteral monthDefaultFullName02 = u"\x0645\x0627\x0631\x0633";
static constexpr OUStringLiteral monthDefaultNarrowName02 = u"\x0645";
static constexpr OUStringLiteral monthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName03 = u"\x0623\x0628\x0631\x064a\x0644";
static constexpr OUStringLiteral monthDefaultFullName03 = u"\x0623\x0628\x0631\x064a\x0644";
static constexpr OUStringLiteral monthDefaultNarrowName03 = u"\x0623";
static constexpr OUStringLiteral monthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral monthDefaultAbbrvName04 = u"\x0645\x0627\x064a\x0648";
static constexpr OUStringLiteral monthDefaultFullName04 = u"\x0645\x0627\x064a\x0648";
static constexpr OUStringLiteral monthDefaultNarrowName04 = u"\x0645";
static constexpr OUStringLiteral monthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName05 = u"\x064a\x0648\x0646\x064a\x0648";
static constexpr OUStringLiteral monthDefaultFullName05 = u"\x064a\x0648\x0646\x064a\x0648";
static constexpr OUStringLiteral monthDefaultNarrowName05 = u"\x064a";
static constexpr OUStringLiteral monthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral monthDefaultAbbrvName06 = u"\x064a\x0648\x0644\x064a\x0648";
static constexpr OUStringLiteral monthDefaultFullName06 = u"\x064a\x0648\x0644\x064a\x0648";
static constexpr OUStringLiteral monthDefaultNarrowName06 = u"\x064a";
static constexpr OUStringLiteral monthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral monthDefaultAbbrvName07 = u"\x0623\x063a\x0633\x0637\x0633";
static constexpr OUStringLiteral monthDefaultFullName07 = u"\x0623\x063a\x0633\x0637\x0633";
static constexpr OUStringLiteral monthDefaultNarrowName07 = u"\x0623";
static constexpr OUStringLiteral monthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral monthDefaultAbbrvName08 = u"\x0633\x0628\x062a\x0645\x0628\x0631";
static constexpr OUStringLiteral monthDefaultFullName08 = u"\x0633\x0628\x062a\x0645\x0628\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName08 = u"\x0633";
static constexpr OUStringLiteral monthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral monthDefaultAbbrvName09 = u"\x0623\x0643\x062a\x0648\x0628\x0631";
static constexpr OUStringLiteral monthDefaultFullName09 = u"\x0623\x0643\x062a\x0648\x0628\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName09 = u"\x0623";
static constexpr OUStringLiteral monthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral monthDefaultAbbrvName010 = u"\x0646\x0648\x0641\x0645\x0628\x0631";
static constexpr OUStringLiteral monthDefaultFullName010 = u"\x0646\x0648\x0641\x0645\x0628\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName010 = u"\x0646";
static constexpr OUStringLiteral monthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral monthDefaultAbbrvName011 = u"\x062f\x064a\x0633\x0645\x0628\x0631";
static constexpr OUStringLiteral monthDefaultFullName011 = u"\x062f\x064a\x0633\x0645\x0628\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName011 = u"\x062f";
static constexpr OUStringLiteral genitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName00 = u"\x064a\x0646\x0627\x064a\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName00 = u"\x064a\x0646\x0627\x064a\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName00 = u"\x064a";
static constexpr OUStringLiteral genitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName01 = u"\x0641\x0628\x0631\x0627\x064a\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName01 = u"\x0641\x0628\x0631\x0627\x064a\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName01 = u"\x0641";
static constexpr OUStringLiteral genitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName02 = u"\x0645\x0627\x0631\x0633";
static constexpr OUStringLiteral genitiveMonthDefaultFullName02 = u"\x0645\x0627\x0631\x0633";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName02 = u"\x0645";
static constexpr OUStringLiteral genitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName03 = u"\x0623\x0628\x0631\x064a\x0644";
static constexpr OUStringLiteral genitiveMonthDefaultFullName03 = u"\x0623\x0628\x0631\x064a\x0644";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName03 = u"\x0623";
static constexpr OUStringLiteral genitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName04 = u"\x0645\x0627\x064a\x0648";
static constexpr OUStringLiteral genitiveMonthDefaultFullName04 = u"\x0645\x0627\x064a\x0648";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName04 = u"\x0645";
static constexpr OUStringLiteral genitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName05 = u"\x064a\x0648\x0646\x064a\x0648";
static constexpr OUStringLiteral genitiveMonthDefaultFullName05 = u"\x064a\x0648\x0646\x064a\x0648";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName05 = u"\x064a";
static constexpr OUStringLiteral genitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName06 = u"\x064a\x0648\x0644\x064a\x0648";
static constexpr OUStringLiteral genitiveMonthDefaultFullName06 = u"\x064a\x0648\x0644\x064a\x0648";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName06 = u"\x064a";
static constexpr OUStringLiteral genitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName07 = u"\x0623\x063a\x0633\x0637\x0633";
static constexpr OUStringLiteral genitiveMonthDefaultFullName07 = u"\x0623\x063a\x0633\x0637\x0633";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName07 = u"\x0623";
static constexpr OUStringLiteral genitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName08 = u"\x0633\x0628\x062a\x0645\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName08 = u"\x0633\x0628\x062a\x0645\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName08 = u"\x0633";
static constexpr OUStringLiteral genitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName09 = u"\x0623\x0643\x062a\x0648\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName09 = u"\x0623\x0643\x062a\x0648\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName09 = u"\x0623";
static constexpr OUStringLiteral genitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName010 = u"\x0646\x0648\x0641\x0645\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName010 = u"\x0646\x0648\x0641\x0645\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName010 = u"\x0646";
static constexpr OUStringLiteral genitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName011 = u"\x062f\x064a\x0633\x0645\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName011 = u"\x062f\x064a\x0633\x0645\x0628\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName011 = u"\x062f";
static constexpr OUStringLiteral partitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName00 = u"\x064a\x0646\x0627\x064a\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName00 = u"\x064a\x0646\x0627\x064a\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName00 = u"\x064a";
static constexpr OUStringLiteral partitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName01 = u"\x0641\x0628\x0631\x0627\x064a\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName01 = u"\x0641\x0628\x0631\x0627\x064a\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName01 = u"\x0641";
static constexpr OUStringLiteral partitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName02 = u"\x0645\x0627\x0631\x0633";
static constexpr OUStringLiteral partitiveMonthDefaultFullName02 = u"\x0645\x0627\x0631\x0633";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName02 = u"\x0645";
static constexpr OUStringLiteral partitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName03 = u"\x0623\x0628\x0631\x064a\x0644";
static constexpr OUStringLiteral partitiveMonthDefaultFullName03 = u"\x0623\x0628\x0631\x064a\x0644";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName03 = u"\x0623";
static constexpr OUStringLiteral partitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName04 = u"\x0645\x0627\x064a\x0648";
static constexpr OUStringLiteral partitiveMonthDefaultFullName04 = u"\x0645\x0627\x064a\x0648";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName04 = u"\x0645";
static constexpr OUStringLiteral partitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName05 = u"\x064a\x0648\x0646\x064a\x0648";
static constexpr OUStringLiteral partitiveMonthDefaultFullName05 = u"\x064a\x0648\x0646\x064a\x0648";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName05 = u"\x064a";
static constexpr OUStringLiteral partitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName06 = u"\x064a\x0648\x0644\x064a\x0648";
static constexpr OUStringLiteral partitiveMonthDefaultFullName06 = u"\x064a\x0648\x0644\x064a\x0648";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName06 = u"\x064a";
static constexpr OUStringLiteral partitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName07 = u"\x0623\x063a\x0633\x0637\x0633";
static constexpr OUStringLiteral partitiveMonthDefaultFullName07 = u"\x0623\x063a\x0633\x0637\x0633";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName07 = u"\x0623";
static constexpr OUStringLiteral partitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName08 = u"\x0633\x0628\x062a\x0645\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName08 = u"\x0633\x0628\x062a\x0645\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName08 = u"\x0633";
static constexpr OUStringLiteral partitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName09 = u"\x0623\x0643\x062a\x0648\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName09 = u"\x0623\x0643\x062a\x0648\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName09 = u"\x0623";
static constexpr OUStringLiteral partitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName010 = u"\x0646\x0648\x0641\x0645\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName010 = u"\x0646\x0648\x0641\x0645\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName010 = u"\x0646";
static constexpr OUStringLiteral partitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName011 = u"\x062f\x064a\x0633\x0645\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName011 = u"\x062f\x064a\x0633\x0645\x0628\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName011 = u"\x062f";
static constexpr OUStringLiteral eraID00 = u"\x0062\x0063";

static constexpr OUStringLiteral eraDefaultAbbrvName00 = u"\x0642\x002e\x0645";
static constexpr OUStringLiteral eraDefaultFullName00 = u"\x0642\x0628\x0644\x0020\x0627\x0644\x0645\x064a\x0644\x0627\x062f";
static constexpr OUStringLiteral eraID01 = u"\x0061\x0064";

static constexpr OUStringLiteral eraDefaultAbbrvName01 = u"\x0645";
static constexpr OUStringLiteral eraDefaultFullName01 = u"\x0645\x064a\x0644\x0627\x062f\x064a";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x1";
static constexpr OUStringLiteral calendarID1 = u"\x0068\x0069\x006a\x0072\x0069";
static constexpr OUStringLiteral defaultCalendar1 = u"\x0";
static constexpr OUStringLiteral dayID10 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName10 = u"\x0627\x0644\x0623\x062d\x062f";
static constexpr OUStringLiteral dayDefaultFullName10 = u"\x0627\x0644\x0623\x062d\x062f";
static constexpr OUStringLiteral dayDefaultNarrowName10 = u"\x0627";
static constexpr OUStringLiteral dayID11 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName11 = u"\x0627\x0644\x0627\x062b\x0646\x064a\x0646";
static constexpr OUStringLiteral dayDefaultFullName11 = u"\x0627\x0644\x0627\x062b\x0646\x064a\x0646";
static constexpr OUStringLiteral dayDefaultNarrowName11 = u"\x0627";
static constexpr OUStringLiteral dayID12 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName12 = u"\x0627\x0644\x062b\x0644\x0627\x062b\x0627\x0621";
static constexpr OUStringLiteral dayDefaultFullName12 = u"\x0627\x0644\x062b\x0644\x0627\x062b\x0627\x0621";
static constexpr OUStringLiteral dayDefaultNarrowName12 = u"\x0627";
static constexpr OUStringLiteral dayID13 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName13 = u"\x0627\x0644\x0623\x0631\x0628\x0639\x0627\x0621";
static constexpr OUStringLiteral dayDefaultFullName13 = u"\x0627\x0644\x0623\x0631\x0628\x0639\x0627\x0621";
static constexpr OUStringLiteral dayDefaultNarrowName13 = u"\x0627";
static constexpr OUStringLiteral dayID14 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName14 = u"\x0627\x0644\x062e\x0645\x064a\x0633";
static constexpr OUStringLiteral dayDefaultFullName14 = u"\x0627\x0644\x062e\x0645\x064a\x0633";
static constexpr OUStringLiteral dayDefaultNarrowName14 = u"\x0627";
static constexpr OUStringLiteral dayID15 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName15 = u"\x0627\x0644\x062c\x0645\x0639\x0629";
static constexpr OUStringLiteral dayDefaultFullName15 = u"\x0627\x0644\x062c\x0645\x0639\x0629";
static constexpr OUStringLiteral dayDefaultNarrowName15 = u"\x0627";
static constexpr OUStringLiteral dayID16 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName16 = u"\x0627\x0644\x0633\x0628\x062a";
static constexpr OUStringLiteral dayDefaultFullName16 = u"\x0627\x0644\x0633\x0628\x062a";
static constexpr OUStringLiteral dayDefaultNarrowName16 = u"\x0627";
static constexpr OUStringLiteral monthID10 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName10 = u"\x0645\x062d\x0631\x0645";
static constexpr OUStringLiteral monthDefaultFullName10 = u"\x0645\x062d\x0631\x0645";
static constexpr OUStringLiteral monthDefaultNarrowName10 = u"\x0645";
static constexpr OUStringLiteral monthID11 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral monthDefaultAbbrvName11 = u"\x0635\x0641\x0631";
static constexpr OUStringLiteral monthDefaultFullName11 = u"\x0635\x0641\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName11 = u"\x0635";
static constexpr OUStringLiteral monthID12 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName12 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0623\x0648\x0644";
static constexpr OUStringLiteral monthDefaultFullName12 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0623\x0648\x0644";
static constexpr OUStringLiteral monthDefaultNarrowName12 = u"\x0631";
static constexpr OUStringLiteral monthID13 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName13 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0622\x062e\x0631";
static constexpr OUStringLiteral monthDefaultFullName13 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0622\x062e\x0631";
static constexpr OUStringLiteral monthDefaultNarrowName13 = u"\x0631";
static constexpr OUStringLiteral monthID14 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral monthDefaultAbbrvName14 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0623\x0648\x0644\x0649";
static constexpr OUStringLiteral monthDefaultFullName14 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0623\x0648\x0644\x0649";
static constexpr OUStringLiteral monthDefaultNarrowName14 = u"\x062c";
static constexpr OUStringLiteral monthID15 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName15 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0622\x062e\x0631\x0629";
static constexpr OUStringLiteral monthDefaultFullName15 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0622\x062e\x0631\x0629";
static constexpr OUStringLiteral monthDefaultNarrowName15 = u"\x062c";
static constexpr OUStringLiteral monthID16 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral monthDefaultAbbrvName16 = u"\x0631\x062c\x0628";
static constexpr OUStringLiteral monthDefaultFullName16 = u"\x0631\x062c\x0628";
static constexpr OUStringLiteral monthDefaultNarrowName16 = u"\x0631";
static constexpr OUStringLiteral monthID17 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral monthDefaultAbbrvName17 = u"\x0634\x0639\x0628\x0627\x0646";
static constexpr OUStringLiteral monthDefaultFullName17 = u"\x0634\x0639\x0628\x0627\x0646";
static constexpr OUStringLiteral monthDefaultNarrowName17 = u"\x0634";
static constexpr OUStringLiteral monthID18 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral monthDefaultAbbrvName18 = u"\x0631\x0645\x0636\x0627\x0646";
static constexpr OUStringLiteral monthDefaultFullName18 = u"\x0631\x0645\x0636\x0627\x0646";
static constexpr OUStringLiteral monthDefaultNarrowName18 = u"\x0631";
static constexpr OUStringLiteral monthID19 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral monthDefaultAbbrvName19 = u"\x0634\x0648\x0627\x0644";
static constexpr OUStringLiteral monthDefaultFullName19 = u"\x0634\x0648\x0627\x0644";
static constexpr OUStringLiteral monthDefaultNarrowName19 = u"\x0634";
static constexpr OUStringLiteral monthID110 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral monthDefaultAbbrvName110 = u"\x0630\x0648\x0020\x0627\x0644\x0642\x0639\x062f\x0629";
static constexpr OUStringLiteral monthDefaultFullName110 = u"\x0630\x0648\x0020\x0627\x0644\x0642\x0639\x062f\x0629";
static constexpr OUStringLiteral monthDefaultNarrowName110 = u"\x0630";
static constexpr OUStringLiteral monthID111 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral monthDefaultAbbrvName111 = u"\x0630\x0648\x0020\x0627\x0644\x062d\x062c\x0629";
static constexpr OUStringLiteral monthDefaultFullName111 = u"\x0630\x0648\x0020\x0627\x0644\x062d\x062c\x0629";
static constexpr OUStringLiteral monthDefaultNarrowName111 = u"\x0630";
static constexpr OUStringLiteral genitiveMonthID10 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName10 = u"\x0645\x062d\x0631\x0645";
static constexpr OUStringLiteral genitiveMonthDefaultFullName10 = u"\x0645\x062d\x0631\x0645";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName10 = u"\x0645";
static constexpr OUStringLiteral genitiveMonthID11 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName11 = u"\x0635\x0641\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName11 = u"\x0635\x0641\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName11 = u"\x0635";
static constexpr OUStringLiteral genitiveMonthID12 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName12 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0623\x0648\x0644";
static constexpr OUStringLiteral genitiveMonthDefaultFullName12 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0623\x0648\x0644";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName12 = u"\x0631";
static constexpr OUStringLiteral genitiveMonthID13 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName13 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0622\x062e\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultFullName13 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0622\x062e\x0631";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName13 = u"\x0631";
static constexpr OUStringLiteral genitiveMonthID14 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName14 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0623\x0648\x0644\x0649";
static constexpr OUStringLiteral genitiveMonthDefaultFullName14 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0623\x0648\x0644\x0649";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName14 = u"\x062c";
static constexpr OUStringLiteral genitiveMonthID15 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName15 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0622\x062e\x0631\x0629";
static constexpr OUStringLiteral genitiveMonthDefaultFullName15 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0622\x062e\x0631\x0629";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName15 = u"\x062c";
static constexpr OUStringLiteral genitiveMonthID16 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName16 = u"\x0631\x062c\x0628";
static constexpr OUStringLiteral genitiveMonthDefaultFullName16 = u"\x0631\x062c\x0628";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName16 = u"\x0631";
static constexpr OUStringLiteral genitiveMonthID17 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName17 = u"\x0634\x0639\x0628\x0627\x0646";
static constexpr OUStringLiteral genitiveMonthDefaultFullName17 = u"\x0634\x0639\x0628\x0627\x0646";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName17 = u"\x0634";
static constexpr OUStringLiteral genitiveMonthID18 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName18 = u"\x0631\x0645\x0636\x0627\x0646";
static constexpr OUStringLiteral genitiveMonthDefaultFullName18 = u"\x0631\x0645\x0636\x0627\x0646";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName18 = u"\x0631";
static constexpr OUStringLiteral genitiveMonthID19 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName19 = u"\x0634\x0648\x0627\x0644";
static constexpr OUStringLiteral genitiveMonthDefaultFullName19 = u"\x0634\x0648\x0627\x0644";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName19 = u"\x0634";
static constexpr OUStringLiteral genitiveMonthID110 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName110 = u"\x0630\x0648\x0020\x0627\x0644\x0642\x0639\x062f\x0629";
static constexpr OUStringLiteral genitiveMonthDefaultFullName110 = u"\x0630\x0648\x0020\x0627\x0644\x0642\x0639\x062f\x0629";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName110 = u"\x0630";
static constexpr OUStringLiteral genitiveMonthID111 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName111 = u"\x0630\x0648\x0020\x0627\x0644\x062d\x062c\x0629";
static constexpr OUStringLiteral genitiveMonthDefaultFullName111 = u"\x0630\x0648\x0020\x0627\x0644\x062d\x062c\x0629";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName111 = u"\x0630";
static constexpr OUStringLiteral partitiveMonthID10 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName10 = u"\x0645\x062d\x0631\x0645";
static constexpr OUStringLiteral partitiveMonthDefaultFullName10 = u"\x0645\x062d\x0631\x0645";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName10 = u"\x0645";
static constexpr OUStringLiteral partitiveMonthID11 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName11 = u"\x0635\x0641\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName11 = u"\x0635\x0641\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName11 = u"\x0635";
static constexpr OUStringLiteral partitiveMonthID12 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName12 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0623\x0648\x0644";
static constexpr OUStringLiteral partitiveMonthDefaultFullName12 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0623\x0648\x0644";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName12 = u"\x0631";
static constexpr OUStringLiteral partitiveMonthID13 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName13 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0622\x062e\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultFullName13 = u"\x0631\x0628\x064a\x0639\x0020\x0627\x0644\x0622\x062e\x0631";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName13 = u"\x0631";
static constexpr OUStringLiteral partitiveMonthID14 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName14 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0623\x0648\x0644\x0649";
static constexpr OUStringLiteral partitiveMonthDefaultFullName14 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0623\x0648\x0644\x0649";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName14 = u"\x062c";
static constexpr OUStringLiteral partitiveMonthID15 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName15 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0622\x062e\x0631\x0629";
static constexpr OUStringLiteral partitiveMonthDefaultFullName15 = u"\x062c\x0645\x0627\x062f\x0649\x0020\x0627\x0644\x0622\x062e\x0631\x0629";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName15 = u"\x062c";
static constexpr OUStringLiteral partitiveMonthID16 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName16 = u"\x0631\x062c\x0628";
static constexpr OUStringLiteral partitiveMonthDefaultFullName16 = u"\x0631\x062c\x0628";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName16 = u"\x0631";
static constexpr OUStringLiteral partitiveMonthID17 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName17 = u"\x0634\x0639\x0628\x0627\x0646";
static constexpr OUStringLiteral partitiveMonthDefaultFullName17 = u"\x0634\x0639\x0628\x0627\x0646";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName17 = u"\x0634";
static constexpr OUStringLiteral partitiveMonthID18 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName18 = u"\x0631\x0645\x0636\x0627\x0646";
static constexpr OUStringLiteral partitiveMonthDefaultFullName18 = u"\x0631\x0645\x0636\x0627\x0646";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName18 = u"\x0631";
static constexpr OUStringLiteral partitiveMonthID19 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName19 = u"\x0634\x0648\x0627\x0644";
static constexpr OUStringLiteral partitiveMonthDefaultFullName19 = u"\x0634\x0648\x0627\x0644";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName19 = u"\x0634";
static constexpr OUStringLiteral partitiveMonthID110 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName110 = u"\x0630\x0648\x0020\x0627\x0644\x0642\x0639\x062f\x0629";
static constexpr OUStringLiteral partitiveMonthDefaultFullName110 = u"\x0630\x0648\x0020\x0627\x0644\x0642\x0639\x062f\x0629";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName110 = u"\x0630";
static constexpr OUStringLiteral partitiveMonthID111 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName111 = u"\x0630\x0648\x0020\x0627\x0644\x062d\x062c\x0629";
static constexpr OUStringLiteral partitiveMonthDefaultFullName111 = u"\x0630\x0648\x0020\x0627\x0644\x062d\x062c\x0629";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName111 = u"\x0630";
static constexpr OUStringLiteral eraID10 = u"\x0042\x0065\x0066\x006f\x0072\x0065\x0048\x0069\x006a\x0072\x0061";

static constexpr OUStringLiteral eraDefaultAbbrvName10 = u"\x0647\x200d";
static constexpr OUStringLiteral eraDefaultFullName10 = u"\x0642\x0628\x0644\x0020\x0627\x0644\x0647\x062c\x0631\x0629";
static constexpr OUStringLiteral eraID11 = u"\x0041\x0066\x0074\x0065\x0072\x0048\x0069\x006a\x0072\x0061";

static constexpr OUStringLiteral eraDefaultAbbrvName11 = u"";
static constexpr OUStringLiteral eraDefaultFullName11 = u"\x0647\x062c\x0631\x064a";
static constexpr OUStringLiteral startDayOfWeek1 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral minimalDaysInFirstWeek1 = u"\x1";
static const sal_Int16 calendarsCount = 2;

static constexpr OUStringLiteral nbOfDays = u"\x7\x7";
static constexpr OUStringLiteral nbOfMonths = u"\xc\xc";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\xc\xc";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\xc\xc";
static constexpr OUStringLiteral nbOfEras = u"\x2\x2";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayID00,
	dayDefaultAbbrvName00,
	dayDefaultFullName00,
	dayDefaultNarrowName00,
	dayID01,
	dayDefaultAbbrvName01,
	dayDefaultFullName01,
	dayDefaultNarrowName01,
	dayID02,
	dayDefaultAbbrvName02,
	dayDefaultFullName02,
	dayDefaultNarrowName02,
	dayID03,
	dayDefaultAbbrvName03,
	dayDefaultFullName03,
	dayDefaultNarrowName03,
	dayID04,
	dayDefaultAbbrvName04,
	dayDefaultFullName04,
	dayDefaultNarrowName04,
	dayID05,
	dayDefaultAbbrvName05,
	dayDefaultFullName05,
	dayDefaultNarrowName05,
	dayID06,
	dayDefaultAbbrvName06,
	dayDefaultFullName06,
	dayDefaultNarrowName06,
	monthID00,
	monthDefaultAbbrvName00,
	monthDefaultFullName00,
	monthDefaultNarrowName00,
	monthID01,
	monthDefaultAbbrvName01,
	monthDefaultFullName01,
	monthDefaultNarrowName01,
	monthID02,
	monthDefaultAbbrvName02,
	monthDefaultFullName02,
	monthDefaultNarrowName02,
	monthID03,
	monthDefaultAbbrvName03,
	monthDefaultFullName03,
	monthDefaultNarrowName03,
	monthID04,
	monthDefaultAbbrvName04,
	monthDefaultFullName04,
	monthDefaultNarrowName04,
	monthID05,
	monthDefaultAbbrvName05,
	monthDefaultFullName05,
	monthDefaultNarrowName05,
	monthID06,
	monthDefaultAbbrvName06,
	monthDefaultFullName06,
	monthDefaultNarrowName06,
	monthID07,
	monthDefaultAbbrvName07,
	monthDefaultFullName07,
	monthDefaultNarrowName07,
	monthID08,
	monthDefaultAbbrvName08,
	monthDefaultFullName08,
	monthDefaultNarrowName08,
	monthID09,
	monthDefaultAbbrvName09,
	monthDefaultFullName09,
	monthDefaultNarrowName09,
	monthID010,
	monthDefaultAbbrvName010,
	monthDefaultFullName010,
	monthDefaultNarrowName010,
	monthID011,
	monthDefaultAbbrvName011,
	monthDefaultFullName011,
	monthDefaultNarrowName011,
	genitiveMonthID00,
	genitiveMonthDefaultAbbrvName00,
	genitiveMonthDefaultFullName00,
	genitiveMonthDefaultNarrowName00,
	genitiveMonthID01,
	genitiveMonthDefaultAbbrvName01,
	genitiveMonthDefaultFullName01,
	genitiveMonthDefaultNarrowName01,
	genitiveMonthID02,
	genitiveMonthDefaultAbbrvName02,
	genitiveMonthDefaultFullName02,
	genitiveMonthDefaultNarrowName02,
	genitiveMonthID03,
	genitiveMonthDefaultAbbrvName03,
	genitiveMonthDefaultFullName03,
	genitiveMonthDefaultNarrowName03,
	genitiveMonthID04,
	genitiveMonthDefaultAbbrvName04,
	genitiveMonthDefaultFullName04,
	genitiveMonthDefaultNarrowName04,
	genitiveMonthID05,
	genitiveMonthDefaultAbbrvName05,
	genitiveMonthDefaultFullName05,
	genitiveMonthDefaultNarrowName05,
	genitiveMonthID06,
	genitiveMonthDefaultAbbrvName06,
	genitiveMonthDefaultFullName06,
	genitiveMonthDefaultNarrowName06,
	genitiveMonthID07,
	genitiveMonthDefaultAbbrvName07,
	genitiveMonthDefaultFullName07,
	genitiveMonthDefaultNarrowName07,
	genitiveMonthID08,
	genitiveMonthDefaultAbbrvName08,
	genitiveMonthDefaultFullName08,
	genitiveMonthDefaultNarrowName08,
	genitiveMonthID09,
	genitiveMonthDefaultAbbrvName09,
	genitiveMonthDefaultFullName09,
	genitiveMonthDefaultNarrowName09,
	genitiveMonthID010,
	genitiveMonthDefaultAbbrvName010,
	genitiveMonthDefaultFullName010,
	genitiveMonthDefaultNarrowName010,
	genitiveMonthID011,
	genitiveMonthDefaultAbbrvName011,
	genitiveMonthDefaultFullName011,
	genitiveMonthDefaultNarrowName011,
	partitiveMonthID00,
	partitiveMonthDefaultAbbrvName00,
	partitiveMonthDefaultFullName00,
	partitiveMonthDefaultNarrowName00,
	partitiveMonthID01,
	partitiveMonthDefaultAbbrvName01,
	partitiveMonthDefaultFullName01,
	partitiveMonthDefaultNarrowName01,
	partitiveMonthID02,
	partitiveMonthDefaultAbbrvName02,
	partitiveMonthDefaultFullName02,
	partitiveMonthDefaultNarrowName02,
	partitiveMonthID03,
	partitiveMonthDefaultAbbrvName03,
	partitiveMonthDefaultFullName03,
	partitiveMonthDefaultNarrowName03,
	partitiveMonthID04,
	partitiveMonthDefaultAbbrvName04,
	partitiveMonthDefaultFullName04,
	partitiveMonthDefaultNarrowName04,
	partitiveMonthID05,
	partitiveMonthDefaultAbbrvName05,
	partitiveMonthDefaultFullName05,
	partitiveMonthDefaultNarrowName05,
	partitiveMonthID06,
	partitiveMonthDefaultAbbrvName06,
	partitiveMonthDefaultFullName06,
	partitiveMonthDefaultNarrowName06,
	partitiveMonthID07,
	partitiveMonthDefaultAbbrvName07,
	partitiveMonthDefaultFullName07,
	partitiveMonthDefaultNarrowName07,
	partitiveMonthID08,
	partitiveMonthDefaultAbbrvName08,
	partitiveMonthDefaultFullName08,
	partitiveMonthDefaultNarrowName08,
	partitiveMonthID09,
	partitiveMonthDefaultAbbrvName09,
	partitiveMonthDefaultFullName09,
	partitiveMonthDefaultNarrowName09,
	partitiveMonthID010,
	partitiveMonthDefaultAbbrvName010,
	partitiveMonthDefaultFullName010,
	partitiveMonthDefaultNarrowName010,
	partitiveMonthID011,
	partitiveMonthDefaultAbbrvName011,
	partitiveMonthDefaultFullName011,
	partitiveMonthDefaultNarrowName011,
	eraID00,
	eraDefaultAbbrvName00,
	eraDefaultFullName00,
	eraID01,
	eraDefaultAbbrvName01,
	eraDefaultFullName01,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
	calendarID1,
	defaultCalendar1,
	dayID10,
	dayDefaultAbbrvName10,
	dayDefaultFullName10,
	dayDefaultNarrowName10,
	dayID11,
	dayDefaultAbbrvName11,
	dayDefaultFullName11,
	dayDefaultNarrowName11,
	dayID12,
	dayDefaultAbbrvName12,
	dayDefaultFullName12,
	dayDefaultNarrowName12,
	dayID13,
	dayDefaultAbbrvName13,
	dayDefaultFullName13,
	dayDefaultNarrowName13,
	dayID14,
	dayDefaultAbbrvName14,
	dayDefaultFullName14,
	dayDefaultNarrowName14,
	dayID15,
	dayDefaultAbbrvName15,
	dayDefaultFullName15,
	dayDefaultNarrowName15,
	dayID16,
	dayDefaultAbbrvName16,
	dayDefaultFullName16,
	dayDefaultNarrowName16,
	monthID10,
	monthDefaultAbbrvName10,
	monthDefaultFullName10,
	monthDefaultNarrowName10,
	monthID11,
	monthDefaultAbbrvName11,
	monthDefaultFullName11,
	monthDefaultNarrowName11,
	monthID12,
	monthDefaultAbbrvName12,
	monthDefaultFullName12,
	monthDefaultNarrowName12,
	monthID13,
	monthDefaultAbbrvName13,
	monthDefaultFullName13,
	monthDefaultNarrowName13,
	monthID14,
	monthDefaultAbbrvName14,
	monthDefaultFullName14,
	monthDefaultNarrowName14,
	monthID15,
	monthDefaultAbbrvName15,
	monthDefaultFullName15,
	monthDefaultNarrowName15,
	monthID16,
	monthDefaultAbbrvName16,
	monthDefaultFullName16,
	monthDefaultNarrowName16,
	monthID17,
	monthDefaultAbbrvName17,
	monthDefaultFullName17,
	monthDefaultNarrowName17,
	monthID18,
	monthDefaultAbbrvName18,
	monthDefaultFullName18,
	monthDefaultNarrowName18,
	monthID19,
	monthDefaultAbbrvName19,
	monthDefaultFullName19,
	monthDefaultNarrowName19,
	monthID110,
	monthDefaultAbbrvName110,
	monthDefaultFullName110,
	monthDefaultNarrowName110,
	monthID111,
	monthDefaultAbbrvName111,
	monthDefaultFullName111,
	monthDefaultNarrowName111,
	genitiveMonthID10,
	genitiveMonthDefaultAbbrvName10,
	genitiveMonthDefaultFullName10,
	genitiveMonthDefaultNarrowName10,
	genitiveMonthID11,
	genitiveMonthDefaultAbbrvName11,
	genitiveMonthDefaultFullName11,
	genitiveMonthDefaultNarrowName11,
	genitiveMonthID12,
	genitiveMonthDefaultAbbrvName12,
	genitiveMonthDefaultFullName12,
	genitiveMonthDefaultNarrowName12,
	genitiveMonthID13,
	genitiveMonthDefaultAbbrvName13,
	genitiveMonthDefaultFullName13,
	genitiveMonthDefaultNarrowName13,
	genitiveMonthID14,
	genitiveMonthDefaultAbbrvName14,
	genitiveMonthDefaultFullName14,
	genitiveMonthDefaultNarrowName14,
	genitiveMonthID15,
	genitiveMonthDefaultAbbrvName15,
	genitiveMonthDefaultFullName15,
	genitiveMonthDefaultNarrowName15,
	genitiveMonthID16,
	genitiveMonthDefaultAbbrvName16,
	genitiveMonthDefaultFullName16,
	genitiveMonthDefaultNarrowName16,
	genitiveMonthID17,
	genitiveMonthDefaultAbbrvName17,
	genitiveMonthDefaultFullName17,
	genitiveMonthDefaultNarrowName17,
	genitiveMonthID18,
	genitiveMonthDefaultAbbrvName18,
	genitiveMonthDefaultFullName18,
	genitiveMonthDefaultNarrowName18,
	genitiveMonthID19,
	genitiveMonthDefaultAbbrvName19,
	genitiveMonthDefaultFullName19,
	genitiveMonthDefaultNarrowName19,
	genitiveMonthID110,
	genitiveMonthDefaultAbbrvName110,
	genitiveMonthDefaultFullName110,
	genitiveMonthDefaultNarrowName110,
	genitiveMonthID111,
	genitiveMonthDefaultAbbrvName111,
	genitiveMonthDefaultFullName111,
	genitiveMonthDefaultNarrowName111,
	partitiveMonthID10,
	partitiveMonthDefaultAbbrvName10,
	partitiveMonthDefaultFullName10,
	partitiveMonthDefaultNarrowName10,
	partitiveMonthID11,
	partitiveMonthDefaultAbbrvName11,
	partitiveMonthDefaultFullName11,
	partitiveMonthDefaultNarrowName11,
	partitiveMonthID12,
	partitiveMonthDefaultAbbrvName12,
	partitiveMonthDefaultFullName12,
	partitiveMonthDefaultNarrowName12,
	partitiveMonthID13,
	partitiveMonthDefaultAbbrvName13,
	partitiveMonthDefaultFullName13,
	partitiveMonthDefaultNarrowName13,
	partitiveMonthID14,
	partitiveMonthDefaultAbbrvName14,
	partitiveMonthDefaultFullName14,
	partitiveMonthDefaultNarrowName14,
	partitiveMonthID15,
	partitiveMonthDefaultAbbrvName15,
	partitiveMonthDefaultFullName15,
	partitiveMonthDefaultNarrowName15,
	partitiveMonthID16,
	partitiveMonthDefaultAbbrvName16,
	partitiveMonthDefaultFullName16,
	partitiveMonthDefaultNarrowName16,
	partitiveMonthID17,
	partitiveMonthDefaultAbbrvName17,
	partitiveMonthDefaultFullName17,
	partitiveMonthDefaultNarrowName17,
	partitiveMonthID18,
	partitiveMonthDefaultAbbrvName18,
	partitiveMonthDefaultFullName18,
	partitiveMonthDefaultNarrowName18,
	partitiveMonthID19,
	partitiveMonthDefaultAbbrvName19,
	partitiveMonthDefaultFullName19,
	partitiveMonthDefaultNarrowName19,
	partitiveMonthID110,
	partitiveMonthDefaultAbbrvName110,
	partitiveMonthDefaultFullName110,
	partitiveMonthDefaultNarrowName110,
	partitiveMonthID111,
	partitiveMonthDefaultAbbrvName111,
	partitiveMonthDefaultFullName111,
	partitiveMonthDefaultNarrowName111,
	eraID10,
	eraDefaultAbbrvName10,
	eraDefaultFullName10,
	eraID11,
	eraDefaultAbbrvName11,
	eraDefaultFullName11,
	startDayOfWeek1,
	minimalDaysInFirstWeek1,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_ar_SA(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0053\x0041\x0052";
static constexpr OUStringLiteral currencySymbol0 = u"\x0631\x002e\x0633\x002e\x200f";
static constexpr OUStringLiteral bankSymbol0 = u"\x0053\x0041\x0052";
static constexpr OUStringLiteral currencyName0 = u"\x0053\x0041\x0052";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_ar_SA(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_ar_SA(sal_Int16& count)
{
	return getTransliterations_ar_EG(count);
}
extern const OUString *  getForbiddenCharacters_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_ar_SA(sal_Int16& count)
{
	return getForbiddenCharacters_ar_EG(count);
}
extern const OUString *  getBreakIteratorRules_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_ar_SA(sal_Int16& count)
{
	return getBreakIteratorRules_ar_EG(count);
}
extern const OUString *  getReservedWords_ar_EG(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_ar_SA(sal_Int16& count)
{
	return getReservedWords_ar_EG(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_ar_EG(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_ar_SA(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_ar_EG(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_ar_EG(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_ar_SA(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_ar_EG(nStyles, nLevels, nAttributes);
}
} // extern "C"

