#ifndef INCLUDED_OFFICECFG_OFFICE_MATH_HXX
#define INCLUDED_OFFICECFG_OFFICE_MATH_HXX

#include "sal/config.h"

#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Math {

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Print"_ustr); return PATH; }

struct Title: public comphelper::ConfigurationProperty<Title, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Print/Title"_ustr); return PATH; }
private:
    Title(); // not defined
    ~Title(); // not defined
};

struct FormulaText: public comphelper::ConfigurationProperty<FormulaText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Print/FormulaText"_ustr); return PATH; }
private:
    FormulaText(); // not defined
    ~FormulaText(); // not defined
};

struct Frame: public comphelper::ConfigurationProperty<Frame, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Print/Frame"_ustr); return PATH; }
private:
    Frame(); // not defined
    ~Frame(); // not defined
};

struct Size: public comphelper::ConfigurationProperty<Size, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Print/Size"_ustr); return PATH; }
private:
    Size(); // not defined
    ~Size(); // not defined
};

struct ZoomFactor: public comphelper::ConfigurationProperty<ZoomFactor, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Print/ZoomFactor"_ustr); return PATH; }
private:
    ZoomFactor(); // not defined
    ~ZoomFactor(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

struct LoadSave: public comphelper::ConfigurationGroup< LoadSave> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/LoadSave"_ustr); return PATH; }

struct IsSaveOnlyUsedSymbols: public comphelper::ConfigurationProperty<IsSaveOnlyUsedSymbols, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/LoadSave/IsSaveOnlyUsedSymbols"_ustr); return PATH; }
private:
    IsSaveOnlyUsedSymbols(); // not defined
    ~IsSaveOnlyUsedSymbols(); // not defined
};

private:
    LoadSave(); // not defined
    ~LoadSave(); // not defined
};

struct Misc: public comphelper::ConfigurationGroup< Misc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Misc"_ustr); return PATH; }

struct InlineEditEnable: public comphelper::ConfigurationProperty<InlineEditEnable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Misc/InlineEditEnable"_ustr); return PATH; }
private:
    InlineEditEnable(); // not defined
    ~InlineEditEnable(); // not defined
};

struct IgnoreSpacesRight: public comphelper::ConfigurationProperty<IgnoreSpacesRight, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Misc/IgnoreSpacesRight"_ustr); return PATH; }
private:
    IgnoreSpacesRight(); // not defined
    ~IgnoreSpacesRight(); // not defined
};

struct AutoCloseBrackets: public comphelper::ConfigurationProperty<AutoCloseBrackets, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Misc/AutoCloseBrackets"_ustr); return PATH; }
private:
    AutoCloseBrackets(); // not defined
    ~AutoCloseBrackets(); // not defined
};

struct SmEditWindowZoomFactor: public comphelper::ConfigurationProperty<SmEditWindowZoomFactor, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Misc/SmEditWindowZoomFactor"_ustr); return PATH; }
private:
    SmEditWindowZoomFactor(); // not defined
    ~SmEditWindowZoomFactor(); // not defined
};

struct DefaultSmSyntaxVersion: public comphelper::ConfigurationProperty<DefaultSmSyntaxVersion, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/Misc/DefaultSmSyntaxVersion"_ustr); return PATH; }
private:
    DefaultSmSyntaxVersion(); // not defined
    ~DefaultSmSyntaxVersion(); // not defined
};

private:
    Misc(); // not defined
    ~Misc(); // not defined
};

struct View: public comphelper::ConfigurationGroup< View> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/View"_ustr); return PATH; }

struct ToolboxVisible: public comphelper::ConfigurationProperty<ToolboxVisible, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/View/ToolboxVisible"_ustr); return PATH; }
private:
    ToolboxVisible(); // not defined
    ~ToolboxVisible(); // not defined
};

struct AutoRedraw: public comphelper::ConfigurationProperty<AutoRedraw, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/View/AutoRedraw"_ustr); return PATH; }
private:
    AutoRedraw(); // not defined
    ~AutoRedraw(); // not defined
};

struct FormulaCursor: public comphelper::ConfigurationProperty<FormulaCursor, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/View/FormulaCursor"_ustr); return PATH; }
private:
    FormulaCursor(); // not defined
    ~FormulaCursor(); // not defined
};

private:
    View(); // not defined
    ~View(); // not defined
};

struct FontFormatList: public comphelper::ConfigurationSet< FontFormatList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/FontFormatList"_ustr); return PATH; }
private:
    FontFormatList(); // not defined
    ~FontFormatList(); // not defined
};

struct StandardFormat: public comphelper::ConfigurationGroup< StandardFormat> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat"_ustr); return PATH; }

struct Textmode: public comphelper::ConfigurationProperty<Textmode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Textmode"_ustr); return PATH; }
private:
    Textmode(); // not defined
    ~Textmode(); // not defined
};

struct RightToLeft: public comphelper::ConfigurationProperty<RightToLeft, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/RightToLeft"_ustr); return PATH; }
private:
    RightToLeft(); // not defined
    ~RightToLeft(); // not defined
};

struct GreekCharStyle: public comphelper::ConfigurationProperty<GreekCharStyle, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/GreekCharStyle"_ustr); return PATH; }
private:
    GreekCharStyle(); // not defined
    ~GreekCharStyle(); // not defined
};

struct ScaleNormalBracket: public comphelper::ConfigurationProperty<ScaleNormalBracket, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/ScaleNormalBracket"_ustr); return PATH; }
private:
    ScaleNormalBracket(); // not defined
    ~ScaleNormalBracket(); // not defined
};

struct HorizontalAlignment: public comphelper::ConfigurationProperty<HorizontalAlignment, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/HorizontalAlignment"_ustr); return PATH; }
private:
    HorizontalAlignment(); // not defined
    ~HorizontalAlignment(); // not defined
};

struct BaseSize: public comphelper::ConfigurationProperty<BaseSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/BaseSize"_ustr); return PATH; }
private:
    BaseSize(); // not defined
    ~BaseSize(); // not defined
};

struct TextSize: public comphelper::ConfigurationProperty<TextSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/TextSize"_ustr); return PATH; }
private:
    TextSize(); // not defined
    ~TextSize(); // not defined
};

struct IndexSize: public comphelper::ConfigurationProperty<IndexSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/IndexSize"_ustr); return PATH; }
private:
    IndexSize(); // not defined
    ~IndexSize(); // not defined
};

struct FunctionSize: public comphelper::ConfigurationProperty<FunctionSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/FunctionSize"_ustr); return PATH; }
private:
    FunctionSize(); // not defined
    ~FunctionSize(); // not defined
};

struct OperatorSize: public comphelper::ConfigurationProperty<OperatorSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/OperatorSize"_ustr); return PATH; }
private:
    OperatorSize(); // not defined
    ~OperatorSize(); // not defined
};

struct LimitsSize: public comphelper::ConfigurationProperty<LimitsSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/LimitsSize"_ustr); return PATH; }
private:
    LimitsSize(); // not defined
    ~LimitsSize(); // not defined
};

struct VariableFont: public comphelper::ConfigurationProperty<VariableFont, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/VariableFont"_ustr); return PATH; }
private:
    VariableFont(); // not defined
    ~VariableFont(); // not defined
};

struct FunctionFont: public comphelper::ConfigurationProperty<FunctionFont, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/FunctionFont"_ustr); return PATH; }
private:
    FunctionFont(); // not defined
    ~FunctionFont(); // not defined
};

struct NumberFont: public comphelper::ConfigurationProperty<NumberFont, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/NumberFont"_ustr); return PATH; }
private:
    NumberFont(); // not defined
    ~NumberFont(); // not defined
};

struct TextFont: public comphelper::ConfigurationProperty<TextFont, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/TextFont"_ustr); return PATH; }
private:
    TextFont(); // not defined
    ~TextFont(); // not defined
};

struct SansFont: public comphelper::ConfigurationProperty<SansFont, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/SansFont"_ustr); return PATH; }
private:
    SansFont(); // not defined
    ~SansFont(); // not defined
};

struct SerifFont: public comphelper::ConfigurationProperty<SerifFont, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/SerifFont"_ustr); return PATH; }
private:
    SerifFont(); // not defined
    ~SerifFont(); // not defined
};

struct FixedFont: public comphelper::ConfigurationProperty<FixedFont, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/FixedFont"_ustr); return PATH; }
private:
    FixedFont(); // not defined
    ~FixedFont(); // not defined
};

struct Distance: public comphelper::ConfigurationGroup< Distance> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance"_ustr); return PATH; }

struct Horizontal: public comphelper::ConfigurationProperty<Horizontal, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/Horizontal"_ustr); return PATH; }
private:
    Horizontal(); // not defined
    ~Horizontal(); // not defined
};

struct Vertical: public comphelper::ConfigurationProperty<Vertical, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/Vertical"_ustr); return PATH; }
private:
    Vertical(); // not defined
    ~Vertical(); // not defined
};

struct Root: public comphelper::ConfigurationProperty<Root, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/Root"_ustr); return PATH; }
private:
    Root(); // not defined
    ~Root(); // not defined
};

struct SubScript: public comphelper::ConfigurationProperty<SubScript, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/SubScript"_ustr); return PATH; }
private:
    SubScript(); // not defined
    ~SubScript(); // not defined
};

struct SuperScript: public comphelper::ConfigurationProperty<SuperScript, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/SuperScript"_ustr); return PATH; }
private:
    SuperScript(); // not defined
    ~SuperScript(); // not defined
};

struct LowerLimit: public comphelper::ConfigurationProperty<LowerLimit, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/LowerLimit"_ustr); return PATH; }
private:
    LowerLimit(); // not defined
    ~LowerLimit(); // not defined
};

struct UpperLimit: public comphelper::ConfigurationProperty<UpperLimit, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/UpperLimit"_ustr); return PATH; }
private:
    UpperLimit(); // not defined
    ~UpperLimit(); // not defined
};

struct OperatorSize: public comphelper::ConfigurationProperty<OperatorSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/OperatorSize"_ustr); return PATH; }
private:
    OperatorSize(); // not defined
    ~OperatorSize(); // not defined
};

struct OperatorSpace: public comphelper::ConfigurationProperty<OperatorSpace, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/OperatorSpace"_ustr); return PATH; }
private:
    OperatorSpace(); // not defined
    ~OperatorSpace(); // not defined
};

struct Numerator: public comphelper::ConfigurationProperty<Numerator, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/Numerator"_ustr); return PATH; }
private:
    Numerator(); // not defined
    ~Numerator(); // not defined
};

struct Denominator: public comphelper::ConfigurationProperty<Denominator, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/Denominator"_ustr); return PATH; }
private:
    Denominator(); // not defined
    ~Denominator(); // not defined
};

struct Fraction: public comphelper::ConfigurationProperty<Fraction, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/Fraction"_ustr); return PATH; }
private:
    Fraction(); // not defined
    ~Fraction(); // not defined
};

struct StrokeWidth: public comphelper::ConfigurationProperty<StrokeWidth, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/StrokeWidth"_ustr); return PATH; }
private:
    StrokeWidth(); // not defined
    ~StrokeWidth(); // not defined
};

struct BracketSize: public comphelper::ConfigurationProperty<BracketSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/BracketSize"_ustr); return PATH; }
private:
    BracketSize(); // not defined
    ~BracketSize(); // not defined
};

struct BracketSpace: public comphelper::ConfigurationProperty<BracketSpace, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/BracketSpace"_ustr); return PATH; }
private:
    BracketSpace(); // not defined
    ~BracketSpace(); // not defined
};

struct NormalBracketSize: public comphelper::ConfigurationProperty<NormalBracketSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/NormalBracketSize"_ustr); return PATH; }
private:
    NormalBracketSize(); // not defined
    ~NormalBracketSize(); // not defined
};

struct MatrixRow: public comphelper::ConfigurationProperty<MatrixRow, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/MatrixRow"_ustr); return PATH; }
private:
    MatrixRow(); // not defined
    ~MatrixRow(); // not defined
};

struct MatrixColumn: public comphelper::ConfigurationProperty<MatrixColumn, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/MatrixColumn"_ustr); return PATH; }
private:
    MatrixColumn(); // not defined
    ~MatrixColumn(); // not defined
};

struct OrnamentSize: public comphelper::ConfigurationProperty<OrnamentSize, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/OrnamentSize"_ustr); return PATH; }
private:
    OrnamentSize(); // not defined
    ~OrnamentSize(); // not defined
};

struct OrnamentSpace: public comphelper::ConfigurationProperty<OrnamentSpace, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/OrnamentSpace"_ustr); return PATH; }
private:
    OrnamentSpace(); // not defined
    ~OrnamentSpace(); // not defined
};

struct LeftSpace: public comphelper::ConfigurationProperty<LeftSpace, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/LeftSpace"_ustr); return PATH; }
private:
    LeftSpace(); // not defined
    ~LeftSpace(); // not defined
};

struct RightSpace: public comphelper::ConfigurationProperty<RightSpace, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/RightSpace"_ustr); return PATH; }
private:
    RightSpace(); // not defined
    ~RightSpace(); // not defined
};

struct TopSpace: public comphelper::ConfigurationProperty<TopSpace, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/TopSpace"_ustr); return PATH; }
private:
    TopSpace(); // not defined
    ~TopSpace(); // not defined
};

struct BottomSpace: public comphelper::ConfigurationProperty<BottomSpace, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/StandardFormat/Distance/BottomSpace"_ustr); return PATH; }
private:
    BottomSpace(); // not defined
    ~BottomSpace(); // not defined
};

private:
    Distance(); // not defined
    ~Distance(); // not defined
};

private:
    StandardFormat(); // not defined
    ~StandardFormat(); // not defined
};

struct SymbolList: public comphelper::ConfigurationSet< SymbolList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/SymbolList"_ustr); return PATH; }
private:
    SymbolList(); // not defined
    ~SymbolList(); // not defined
};

struct User_Defined: public comphelper::ConfigurationSet< User_Defined> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Math/User-Defined"_ustr); return PATH; }
private:
    User_Defined(); // not defined
    ~User_Defined(); // not defined
};

} } }

#endif
