// Code generated by sdkgen-v2. DO NOT EDIT.
package endpointsdk

import (
	"context"

	endpoint "github.com/yandex-cloud/go-genproto/yandex/cloud/endpoint"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/reflect/protoreflect"
)

// ApiEndpointClient provides methods for managing ApiEndpoint resources of Yandex.Cloud Endpoint.
type ApiEndpointClient interface {
	Get(context.Context, *endpoint.GetApiEndpointRequest, ...grpc.CallOption) (*endpoint.ApiEndpoint, error)
	List(context.Context, *endpoint.ListApiEndpointsRequest, ...grpc.CallOption) (*endpoint.ListApiEndpointsResponse, error)
}

var _ ApiEndpointClient = apiEndpointClient{}

type apiEndpointClient struct {
	connector transport.Connector
}

// NewApiEndpointClient returns ApiEndpointClient implementation.
func NewApiEndpointClient(connector transport.Connector) ApiEndpointClient {
	return apiEndpointClient{connector}
}

// Get is an operation of Yandex.Cloud Endpoint ApiEndpoint service.
func (c apiEndpointClient) Get(ctx context.Context, in *endpoint.GetApiEndpointRequest, opts ...grpc.CallOption) (*endpoint.ApiEndpoint, error) {
	connection, err := c.connector.GetConnection(ctx, ApiEndpointGet, opts...)
	if err != nil {
		return nil, err
	}
	return endpoint.NewApiEndpointServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud Endpoint ApiEndpoint service.
func (c apiEndpointClient) List(ctx context.Context, in *endpoint.ListApiEndpointsRequest, opts ...grpc.CallOption) (*endpoint.ListApiEndpointsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, ApiEndpointList, opts...)
	if err != nil {
		return nil, err
	}
	return endpoint.NewApiEndpointServiceClient(connection).List(ctx, in, opts...)
}

var (
	ApiEndpointGet  = protoreflect.FullName("yandex.cloud.endpoint.ApiEndpointService.Get")
	ApiEndpointList = protoreflect.FullName("yandex.cloud.endpoint.ApiEndpointService.List")
)
