#ifndef SBK_KFONTACTIONWRAPPER_H
#define SBK_KFONTACTIONWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kfontaction.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KFontActionWrapper : public KFontAction
{
public:
    KFontActionWrapper(::QObject * parent);
    KFontActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent);
    KFontActionWrapper(const ::QString & text, ::QObject * parent);
    KFontActionWrapper(uint fontListCriteria, ::QObject * parent);
    KFontActionWrapper(const KFontActionWrapper &) = delete;
    KFontActionWrapper& operator=(const KFontActionWrapper &) = delete;
    KFontActionWrapper(KFontActionWrapper &&) = delete;
    KFontActionWrapper& operator=(KFontActionWrapper &&) = delete;
    ~KFontActionWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QWidget * createWidget(::QWidget * parent) override;
    void customEvent(::QEvent * event) override;
    void deleteWidget(::QWidget * widget) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void insertAction(::QAction * before, ::QAction * action) override;
    ::QAction * removeAction(::QAction * action) override;
    void slotActionTriggered(::QAction * action) override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 12> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KFONTACTIONWRAPPER_H
