{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A single-line text entry widget for entering passwords and other secrets.
-- 
-- \<picture>
--   \<source srcset=\"password-entry-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkPasswordEntry\" src=\"password-entry.png\">
-- \<\/picture>
-- 
-- It does not show its contents in clear text, does not allow to copy it
-- to the clipboard, and it shows a warning when Caps Lock is engaged. If
-- the underlying platform allows it, @GtkPasswordEntry@ will also place
-- the text in a non-pageable memory area, to avoid it being written out
-- to disk by the operating system.
-- 
-- Optionally, it can offer a way to reveal the contents in clear text.
-- 
-- @GtkPasswordEntry@ provides only minimal API and should be used with
-- the t'GI.Gtk.Interfaces.Editable.Editable' API.
-- 
-- = CSS Nodes
-- 
-- 
-- 	
-- >entry.password
-- >╰── text
-- >    ├── image.caps-lock-indicator
-- >    ┊
-- 
-- 
-- @GtkPasswordEntry@ has a single CSS node with name entry that carries
-- a .passwordstyle class. The text Css node below it has a child with
-- name image and style class .caps-lock-indicator for the Caps Lock
-- icon, and possibly other children.
-- 
-- = Accessibility
-- 
-- @GtkPasswordEntry@ uses the 'GI.Gtk.Enums.AccessibleRoleTextBox' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.PasswordEntry
    ( 

-- * Exported types
    PasswordEntry(..)                       ,
    IsPasswordEntry                         ,
    toPasswordEntry                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [delegateGetAccessiblePlatformState]("GI.Gtk.Interfaces.Editable#g:method:delegateGetAccessiblePlatformState"), [deleteSelection]("GI.Gtk.Interfaces.Editable#g:method:deleteSelection"), [deleteText]("GI.Gtk.Interfaces.Editable#g:method:deleteText"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [finishDelegate]("GI.Gtk.Interfaces.Editable#g:method:finishDelegate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initDelegate]("GI.Gtk.Interfaces.Editable#g:method:initDelegate"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertText]("GI.Gtk.Interfaces.Editable#g:method:insertText"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [selectRegion]("GI.Gtk.Interfaces.Editable#g:method:selectRegion"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAlignment]("GI.Gtk.Interfaces.Editable#g:method:getAlignment"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChars]("GI.Gtk.Interfaces.Editable#g:method:getChars"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDelegate]("GI.Gtk.Interfaces.Editable#g:method:getDelegate"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEditable]("GI.Gtk.Interfaces.Editable#g:method:getEditable"), [getEnableUndo]("GI.Gtk.Interfaces.Editable#g:method:getEnableUndo"), [getExtraMenu]("GI.Gtk.Objects.PasswordEntry#g:method:getExtraMenu"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMaxWidthChars]("GI.Gtk.Interfaces.Editable#g:method:getMaxWidthChars"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPosition]("GI.Gtk.Interfaces.Editable#g:method:getPosition"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSelectionBounds]("GI.Gtk.Interfaces.Editable#g:method:getSelectionBounds"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowPeekIcon]("GI.Gtk.Objects.PasswordEntry#g:method:getShowPeekIcon"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getText]("GI.Gtk.Interfaces.Editable#g:method:getText"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getWidthChars]("GI.Gtk.Interfaces.Editable#g:method:getWidthChars").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAlignment]("GI.Gtk.Interfaces.Editable#g:method:setAlignment"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEditable]("GI.Gtk.Interfaces.Editable#g:method:setEditable"), [setEnableUndo]("GI.Gtk.Interfaces.Editable#g:method:setEnableUndo"), [setExtraMenu]("GI.Gtk.Objects.PasswordEntry#g:method:setExtraMenu"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMaxWidthChars]("GI.Gtk.Interfaces.Editable#g:method:setMaxWidthChars"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPosition]("GI.Gtk.Interfaces.Editable#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowPeekIcon]("GI.Gtk.Objects.PasswordEntry#g:method:setShowPeekIcon"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setText]("GI.Gtk.Interfaces.Editable#g:method:setText"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setWidthChars]("GI.Gtk.Interfaces.Editable#g:method:setWidthChars").

#if defined(ENABLE_OVERLOADING)
    ResolvePasswordEntryMethod              ,
#endif

-- ** getExtraMenu #method:getExtraMenu#

#if defined(ENABLE_OVERLOADING)
    PasswordEntryGetExtraMenuMethodInfo     ,
#endif
    passwordEntryGetExtraMenu               ,


-- ** getShowPeekIcon #method:getShowPeekIcon#

#if defined(ENABLE_OVERLOADING)
    PasswordEntryGetShowPeekIconMethodInfo  ,
#endif
    passwordEntryGetShowPeekIcon            ,


-- ** new #method:new#

    passwordEntryNew                        ,


-- ** setExtraMenu #method:setExtraMenu#

#if defined(ENABLE_OVERLOADING)
    PasswordEntrySetExtraMenuMethodInfo     ,
#endif
    passwordEntrySetExtraMenu               ,


-- ** setShowPeekIcon #method:setShowPeekIcon#

#if defined(ENABLE_OVERLOADING)
    PasswordEntrySetShowPeekIconMethodInfo  ,
#endif
    passwordEntrySetShowPeekIcon            ,




 -- * Properties


-- ** activatesDefault #attr:activatesDefault#
-- | Whether to activate the default widget when Enter is pressed.

#if defined(ENABLE_OVERLOADING)
    PasswordEntryActivatesDefaultPropertyInfo,
#endif
    constructPasswordEntryActivatesDefault  ,
    getPasswordEntryActivatesDefault        ,
#if defined(ENABLE_OVERLOADING)
    passwordEntryActivatesDefault           ,
#endif
    setPasswordEntryActivatesDefault        ,


-- ** extraMenu #attr:extraMenu#
-- | A menu model whose contents will be appended to
-- the context menu.

#if defined(ENABLE_OVERLOADING)
    PasswordEntryExtraMenuPropertyInfo      ,
#endif
    clearPasswordEntryExtraMenu             ,
    constructPasswordEntryExtraMenu         ,
    getPasswordEntryExtraMenu               ,
#if defined(ENABLE_OVERLOADING)
    passwordEntryExtraMenu                  ,
#endif
    setPasswordEntryExtraMenu               ,


-- ** placeholderText #attr:placeholderText#
-- | The text that will be displayed in the @GtkPasswordEntry@
-- when it is empty and unfocused.

#if defined(ENABLE_OVERLOADING)
    PasswordEntryPlaceholderTextPropertyInfo,
#endif
    clearPasswordEntryPlaceholderText       ,
    constructPasswordEntryPlaceholderText   ,
    getPasswordEntryPlaceholderText         ,
#if defined(ENABLE_OVERLOADING)
    passwordEntryPlaceholderText            ,
#endif
    setPasswordEntryPlaceholderText         ,


-- ** showPeekIcon #attr:showPeekIcon#
-- | Whether to show an icon for revealing the content.

#if defined(ENABLE_OVERLOADING)
    PasswordEntryShowPeekIconPropertyInfo   ,
#endif
    constructPasswordEntryShowPeekIcon      ,
    getPasswordEntryShowPeekIcon            ,
#if defined(ENABLE_OVERLOADING)
    passwordEntryShowPeekIcon               ,
#endif
    setPasswordEntryShowPeekIcon            ,




 -- * Signals


-- ** activate #signal:activate#

    PasswordEntryActivateCallback           ,
#if defined(ENABLE_OVERLOADING)
    PasswordEntryActivateSignalInfo         ,
#endif
    afterPasswordEntryActivate              ,
    onPasswordEntryActivate                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ObjectClass as GObject.ObjectClass
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype PasswordEntry = PasswordEntry (SP.ManagedPtr PasswordEntry)
    deriving (Eq)

instance SP.ManagedPtrNewtype PasswordEntry where
    toManagedPtr (PasswordEntry p) = p

foreign import ccall "gtk_password_entry_get_type"
    c_gtk_password_entry_get_type :: IO B.Types.GType

instance B.Types.TypedObject PasswordEntry where
    glibType = c_gtk_password_entry_get_type

instance B.Types.GObject PasswordEntry

-- | Type class for types which can be safely cast to t'PasswordEntry', for instance with `toPasswordEntry`.
class (SP.GObject o, O.IsDescendantOf PasswordEntry o) => IsPasswordEntry o
instance (SP.GObject o, O.IsDescendantOf PasswordEntry o) => IsPasswordEntry o

instance O.HasParentTypes PasswordEntry
type instance O.ParentTypes PasswordEntry = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Editable.Editable]

-- | Cast to t'PasswordEntry', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPasswordEntry :: (MIO.MonadIO m, IsPasswordEntry o) => o -> m PasswordEntry
toPasswordEntry = MIO.liftIO . B.ManagedPtr.unsafeCastTo PasswordEntry

-- | Convert t'PasswordEntry' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PasswordEntry) where
    gvalueGType_ = c_gtk_password_entry_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PasswordEntry)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PasswordEntry)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PasswordEntry ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePasswordEntryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePasswordEntryMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolvePasswordEntryMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolvePasswordEntryMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolvePasswordEntryMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolvePasswordEntryMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolvePasswordEntryMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolvePasswordEntryMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolvePasswordEntryMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolvePasswordEntryMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolvePasswordEntryMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolvePasswordEntryMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePasswordEntryMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePasswordEntryMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolvePasswordEntryMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolvePasswordEntryMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolvePasswordEntryMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolvePasswordEntryMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolvePasswordEntryMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolvePasswordEntryMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolvePasswordEntryMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolvePasswordEntryMethod "delegateGetAccessiblePlatformState" o = Gtk.Editable.EditableDelegateGetAccessiblePlatformStateMethodInfo
    ResolvePasswordEntryMethod "deleteSelection" o = Gtk.Editable.EditableDeleteSelectionMethodInfo
    ResolvePasswordEntryMethod "deleteText" o = Gtk.Editable.EditableDeleteTextMethodInfo
    ResolvePasswordEntryMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolvePasswordEntryMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolvePasswordEntryMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolvePasswordEntryMethod "finishDelegate" o = Gtk.Editable.EditableFinishDelegateMethodInfo
    ResolvePasswordEntryMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePasswordEntryMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePasswordEntryMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePasswordEntryMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolvePasswordEntryMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolvePasswordEntryMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolvePasswordEntryMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolvePasswordEntryMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolvePasswordEntryMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolvePasswordEntryMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolvePasswordEntryMethod "initDelegate" o = Gtk.Editable.EditableInitDelegateMethodInfo
    ResolvePasswordEntryMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolvePasswordEntryMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolvePasswordEntryMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolvePasswordEntryMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolvePasswordEntryMethod "insertText" o = Gtk.Editable.EditableInsertTextMethodInfo
    ResolvePasswordEntryMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolvePasswordEntryMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolvePasswordEntryMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePasswordEntryMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolvePasswordEntryMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolvePasswordEntryMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolvePasswordEntryMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolvePasswordEntryMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolvePasswordEntryMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolvePasswordEntryMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolvePasswordEntryMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolvePasswordEntryMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePasswordEntryMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePasswordEntryMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolvePasswordEntryMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolvePasswordEntryMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolvePasswordEntryMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolvePasswordEntryMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolvePasswordEntryMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolvePasswordEntryMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolvePasswordEntryMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePasswordEntryMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePasswordEntryMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolvePasswordEntryMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolvePasswordEntryMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolvePasswordEntryMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolvePasswordEntryMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolvePasswordEntryMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolvePasswordEntryMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolvePasswordEntryMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePasswordEntryMethod "selectRegion" o = Gtk.Editable.EditableSelectRegionMethodInfo
    ResolvePasswordEntryMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolvePasswordEntryMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolvePasswordEntryMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolvePasswordEntryMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolvePasswordEntryMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePasswordEntryMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePasswordEntryMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePasswordEntryMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolvePasswordEntryMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolvePasswordEntryMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolvePasswordEntryMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolvePasswordEntryMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolvePasswordEntryMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePasswordEntryMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolvePasswordEntryMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolvePasswordEntryMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolvePasswordEntryMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolvePasswordEntryMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolvePasswordEntryMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolvePasswordEntryMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePasswordEntryMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolvePasswordEntryMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolvePasswordEntryMethod "getAlignment" o = Gtk.Editable.EditableGetAlignmentMethodInfo
    ResolvePasswordEntryMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolvePasswordEntryMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolvePasswordEntryMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolvePasswordEntryMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolvePasswordEntryMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolvePasswordEntryMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolvePasswordEntryMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolvePasswordEntryMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolvePasswordEntryMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolvePasswordEntryMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolvePasswordEntryMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolvePasswordEntryMethod "getChars" o = Gtk.Editable.EditableGetCharsMethodInfo
    ResolvePasswordEntryMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolvePasswordEntryMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolvePasswordEntryMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolvePasswordEntryMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolvePasswordEntryMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolvePasswordEntryMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolvePasswordEntryMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePasswordEntryMethod "getDelegate" o = Gtk.Editable.EditableGetDelegateMethodInfo
    ResolvePasswordEntryMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolvePasswordEntryMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolvePasswordEntryMethod "getEditable" o = Gtk.Editable.EditableGetEditableMethodInfo
    ResolvePasswordEntryMethod "getEnableUndo" o = Gtk.Editable.EditableGetEnableUndoMethodInfo
    ResolvePasswordEntryMethod "getExtraMenu" o = PasswordEntryGetExtraMenuMethodInfo
    ResolvePasswordEntryMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolvePasswordEntryMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolvePasswordEntryMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolvePasswordEntryMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolvePasswordEntryMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolvePasswordEntryMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolvePasswordEntryMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolvePasswordEntryMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolvePasswordEntryMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolvePasswordEntryMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolvePasswordEntryMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolvePasswordEntryMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolvePasswordEntryMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolvePasswordEntryMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolvePasswordEntryMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolvePasswordEntryMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolvePasswordEntryMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolvePasswordEntryMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolvePasswordEntryMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolvePasswordEntryMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolvePasswordEntryMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolvePasswordEntryMethod "getMaxWidthChars" o = Gtk.Editable.EditableGetMaxWidthCharsMethodInfo
    ResolvePasswordEntryMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolvePasswordEntryMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolvePasswordEntryMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolvePasswordEntryMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolvePasswordEntryMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolvePasswordEntryMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolvePasswordEntryMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolvePasswordEntryMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolvePasswordEntryMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolvePasswordEntryMethod "getPosition" o = Gtk.Editable.EditableGetPositionMethodInfo
    ResolvePasswordEntryMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolvePasswordEntryMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolvePasswordEntryMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolvePasswordEntryMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePasswordEntryMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePasswordEntryMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolvePasswordEntryMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolvePasswordEntryMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolvePasswordEntryMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolvePasswordEntryMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolvePasswordEntryMethod "getSelectionBounds" o = Gtk.Editable.EditableGetSelectionBoundsMethodInfo
    ResolvePasswordEntryMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolvePasswordEntryMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolvePasswordEntryMethod "getShowPeekIcon" o = PasswordEntryGetShowPeekIconMethodInfo
    ResolvePasswordEntryMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolvePasswordEntryMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolvePasswordEntryMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolvePasswordEntryMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolvePasswordEntryMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolvePasswordEntryMethod "getText" o = Gtk.Editable.EditableGetTextMethodInfo
    ResolvePasswordEntryMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolvePasswordEntryMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolvePasswordEntryMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolvePasswordEntryMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolvePasswordEntryMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolvePasswordEntryMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolvePasswordEntryMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolvePasswordEntryMethod "getWidthChars" o = Gtk.Editable.EditableGetWidthCharsMethodInfo
    ResolvePasswordEntryMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolvePasswordEntryMethod "setAlignment" o = Gtk.Editable.EditableSetAlignmentMethodInfo
    ResolvePasswordEntryMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolvePasswordEntryMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolvePasswordEntryMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolvePasswordEntryMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolvePasswordEntryMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolvePasswordEntryMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolvePasswordEntryMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePasswordEntryMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePasswordEntryMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolvePasswordEntryMethod "setEditable" o = Gtk.Editable.EditableSetEditableMethodInfo
    ResolvePasswordEntryMethod "setEnableUndo" o = Gtk.Editable.EditableSetEnableUndoMethodInfo
    ResolvePasswordEntryMethod "setExtraMenu" o = PasswordEntrySetExtraMenuMethodInfo
    ResolvePasswordEntryMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolvePasswordEntryMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolvePasswordEntryMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolvePasswordEntryMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolvePasswordEntryMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolvePasswordEntryMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolvePasswordEntryMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolvePasswordEntryMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolvePasswordEntryMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolvePasswordEntryMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolvePasswordEntryMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolvePasswordEntryMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolvePasswordEntryMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolvePasswordEntryMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolvePasswordEntryMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolvePasswordEntryMethod "setMaxWidthChars" o = Gtk.Editable.EditableSetMaxWidthCharsMethodInfo
    ResolvePasswordEntryMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolvePasswordEntryMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolvePasswordEntryMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolvePasswordEntryMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolvePasswordEntryMethod "setPosition" o = Gtk.Editable.EditableSetPositionMethodInfo
    ResolvePasswordEntryMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePasswordEntryMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolvePasswordEntryMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolvePasswordEntryMethod "setShowPeekIcon" o = PasswordEntrySetShowPeekIconMethodInfo
    ResolvePasswordEntryMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolvePasswordEntryMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolvePasswordEntryMethod "setText" o = Gtk.Editable.EditableSetTextMethodInfo
    ResolvePasswordEntryMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolvePasswordEntryMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolvePasswordEntryMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolvePasswordEntryMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolvePasswordEntryMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolvePasswordEntryMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolvePasswordEntryMethod "setWidthChars" o = Gtk.Editable.EditableSetWidthCharsMethodInfo
    ResolvePasswordEntryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePasswordEntryMethod t PasswordEntry, O.OverloadedMethod info PasswordEntry p) => OL.IsLabel t (PasswordEntry -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePasswordEntryMethod t PasswordEntry, O.OverloadedMethod info PasswordEntry p, R.HasField t PasswordEntry p) => R.HasField t PasswordEntry p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePasswordEntryMethod t PasswordEntry, O.OverloadedMethodInfo info PasswordEntry) => OL.IsLabel t (O.MethodProxy info PasswordEntry) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal PasswordEntry::activate
-- | Emitted when the entry is activated.
-- 
-- The keybindings for this signal are all forms of the Enter key.
type PasswordEntryActivateCallback =
    IO ()

type C_PasswordEntryActivateCallback =
    Ptr PasswordEntry ->                    -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_PasswordEntryActivateCallback`.
foreign import ccall "wrapper"
    mk_PasswordEntryActivateCallback :: C_PasswordEntryActivateCallback -> IO (FunPtr C_PasswordEntryActivateCallback)

wrap_PasswordEntryActivateCallback :: 
    GObject a => (a -> PasswordEntryActivateCallback) ->
    C_PasswordEntryActivateCallback
wrap_PasswordEntryActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' passwordEntry #activate callback
-- @
-- 
-- 
onPasswordEntryActivate :: (IsPasswordEntry a, MonadIO m) => a -> ((?self :: a) => PasswordEntryActivateCallback) -> m SignalHandlerId
onPasswordEntryActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PasswordEntryActivateCallback wrapped
    wrapped'' <- mk_PasswordEntryActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' passwordEntry #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPasswordEntryActivate :: (IsPasswordEntry a, MonadIO m) => a -> ((?self :: a) => PasswordEntryActivateCallback) -> m SignalHandlerId
afterPasswordEntryActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PasswordEntryActivateCallback wrapped
    wrapped'' <- mk_PasswordEntryActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PasswordEntryActivateSignalInfo
instance SignalInfo PasswordEntryActivateSignalInfo where
    type HaskellCallbackType PasswordEntryActivateSignalInfo = PasswordEntryActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PasswordEntryActivateCallback cb
        cb'' <- mk_PasswordEntryActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#g:signal:activate"})

#endif

-- VVV Prop "activates-default"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@activates-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' passwordEntry #activatesDefault
-- @
getPasswordEntryActivatesDefault :: (MonadIO m, IsPasswordEntry o) => o -> m Bool
getPasswordEntryActivatesDefault obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "activates-default"

-- | Set the value of the “@activates-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' passwordEntry [ #activatesDefault 'Data.GI.Base.Attributes.:=' value ]
-- @
setPasswordEntryActivatesDefault :: (MonadIO m, IsPasswordEntry o) => o -> Bool -> m ()
setPasswordEntryActivatesDefault obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "activates-default" val

-- | Construct a t'GValueConstruct' with valid value for the “@activates-default@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPasswordEntryActivatesDefault :: (IsPasswordEntry o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPasswordEntryActivatesDefault val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "activates-default" val

#if defined(ENABLE_OVERLOADING)
data PasswordEntryActivatesDefaultPropertyInfo
instance AttrInfo PasswordEntryActivatesDefaultPropertyInfo where
    type AttrAllowedOps PasswordEntryActivatesDefaultPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PasswordEntryActivatesDefaultPropertyInfo = IsPasswordEntry
    type AttrSetTypeConstraint PasswordEntryActivatesDefaultPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PasswordEntryActivatesDefaultPropertyInfo = (~) Bool
    type AttrTransferType PasswordEntryActivatesDefaultPropertyInfo = Bool
    type AttrGetType PasswordEntryActivatesDefaultPropertyInfo = Bool
    type AttrLabel PasswordEntryActivatesDefaultPropertyInfo = "activates-default"
    type AttrOrigin PasswordEntryActivatesDefaultPropertyInfo = PasswordEntry
    attrGet = getPasswordEntryActivatesDefault
    attrSet = setPasswordEntryActivatesDefault
    attrTransfer _ v = do
        return v
    attrConstruct = constructPasswordEntryActivatesDefault
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.activatesDefault"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#g:attr:activatesDefault"
        })
#endif

-- VVV Prop "extra-menu"
   -- Type: TInterface (Name {namespace = "Gio", name = "MenuModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@extra-menu@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' passwordEntry #extraMenu
-- @
getPasswordEntryExtraMenu :: (MonadIO m, IsPasswordEntry o) => o -> m (Maybe Gio.MenuModel.MenuModel)
getPasswordEntryExtraMenu obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "extra-menu" Gio.MenuModel.MenuModel

-- | Set the value of the “@extra-menu@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' passwordEntry [ #extraMenu 'Data.GI.Base.Attributes.:=' value ]
-- @
setPasswordEntryExtraMenu :: (MonadIO m, IsPasswordEntry o, Gio.MenuModel.IsMenuModel a) => o -> a -> m ()
setPasswordEntryExtraMenu obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "extra-menu" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@extra-menu@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPasswordEntryExtraMenu :: (IsPasswordEntry o, MIO.MonadIO m, Gio.MenuModel.IsMenuModel a) => a -> m (GValueConstruct o)
constructPasswordEntryExtraMenu val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "extra-menu" (P.Just val)

-- | Set the value of the “@extra-menu@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #extraMenu
-- @
clearPasswordEntryExtraMenu :: (MonadIO m, IsPasswordEntry o) => o -> m ()
clearPasswordEntryExtraMenu obj = liftIO $ B.Properties.setObjectPropertyObject obj "extra-menu" (Nothing :: Maybe Gio.MenuModel.MenuModel)

#if defined(ENABLE_OVERLOADING)
data PasswordEntryExtraMenuPropertyInfo
instance AttrInfo PasswordEntryExtraMenuPropertyInfo where
    type AttrAllowedOps PasswordEntryExtraMenuPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PasswordEntryExtraMenuPropertyInfo = IsPasswordEntry
    type AttrSetTypeConstraint PasswordEntryExtraMenuPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferTypeConstraint PasswordEntryExtraMenuPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferType PasswordEntryExtraMenuPropertyInfo = Gio.MenuModel.MenuModel
    type AttrGetType PasswordEntryExtraMenuPropertyInfo = (Maybe Gio.MenuModel.MenuModel)
    type AttrLabel PasswordEntryExtraMenuPropertyInfo = "extra-menu"
    type AttrOrigin PasswordEntryExtraMenuPropertyInfo = PasswordEntry
    attrGet = getPasswordEntryExtraMenu
    attrSet = setPasswordEntryExtraMenu
    attrTransfer _ v = do
        unsafeCastTo Gio.MenuModel.MenuModel v
    attrConstruct = constructPasswordEntryExtraMenu
    attrClear = clearPasswordEntryExtraMenu
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.extraMenu"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#g:attr:extraMenu"
        })
#endif

-- VVV Prop "placeholder-text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@placeholder-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' passwordEntry #placeholderText
-- @
getPasswordEntryPlaceholderText :: (MonadIO m, IsPasswordEntry o) => o -> m (Maybe T.Text)
getPasswordEntryPlaceholderText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "placeholder-text"

-- | Set the value of the “@placeholder-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' passwordEntry [ #placeholderText 'Data.GI.Base.Attributes.:=' value ]
-- @
setPasswordEntryPlaceholderText :: (MonadIO m, IsPasswordEntry o) => o -> T.Text -> m ()
setPasswordEntryPlaceholderText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "placeholder-text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@placeholder-text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPasswordEntryPlaceholderText :: (IsPasswordEntry o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructPasswordEntryPlaceholderText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "placeholder-text" (P.Just val)

-- | Set the value of the “@placeholder-text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #placeholderText
-- @
clearPasswordEntryPlaceholderText :: (MonadIO m, IsPasswordEntry o) => o -> m ()
clearPasswordEntryPlaceholderText obj = liftIO $ B.Properties.setObjectPropertyString obj "placeholder-text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data PasswordEntryPlaceholderTextPropertyInfo
instance AttrInfo PasswordEntryPlaceholderTextPropertyInfo where
    type AttrAllowedOps PasswordEntryPlaceholderTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PasswordEntryPlaceholderTextPropertyInfo = IsPasswordEntry
    type AttrSetTypeConstraint PasswordEntryPlaceholderTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint PasswordEntryPlaceholderTextPropertyInfo = (~) T.Text
    type AttrTransferType PasswordEntryPlaceholderTextPropertyInfo = T.Text
    type AttrGetType PasswordEntryPlaceholderTextPropertyInfo = (Maybe T.Text)
    type AttrLabel PasswordEntryPlaceholderTextPropertyInfo = "placeholder-text"
    type AttrOrigin PasswordEntryPlaceholderTextPropertyInfo = PasswordEntry
    attrGet = getPasswordEntryPlaceholderText
    attrSet = setPasswordEntryPlaceholderText
    attrTransfer _ v = do
        return v
    attrConstruct = constructPasswordEntryPlaceholderText
    attrClear = clearPasswordEntryPlaceholderText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.placeholderText"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#g:attr:placeholderText"
        })
#endif

-- VVV Prop "show-peek-icon"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-peek-icon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' passwordEntry #showPeekIcon
-- @
getPasswordEntryShowPeekIcon :: (MonadIO m, IsPasswordEntry o) => o -> m Bool
getPasswordEntryShowPeekIcon obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-peek-icon"

-- | Set the value of the “@show-peek-icon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' passwordEntry [ #showPeekIcon 'Data.GI.Base.Attributes.:=' value ]
-- @
setPasswordEntryShowPeekIcon :: (MonadIO m, IsPasswordEntry o) => o -> Bool -> m ()
setPasswordEntryShowPeekIcon obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-peek-icon" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-peek-icon@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPasswordEntryShowPeekIcon :: (IsPasswordEntry o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPasswordEntryShowPeekIcon val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-peek-icon" val

#if defined(ENABLE_OVERLOADING)
data PasswordEntryShowPeekIconPropertyInfo
instance AttrInfo PasswordEntryShowPeekIconPropertyInfo where
    type AttrAllowedOps PasswordEntryShowPeekIconPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PasswordEntryShowPeekIconPropertyInfo = IsPasswordEntry
    type AttrSetTypeConstraint PasswordEntryShowPeekIconPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PasswordEntryShowPeekIconPropertyInfo = (~) Bool
    type AttrTransferType PasswordEntryShowPeekIconPropertyInfo = Bool
    type AttrGetType PasswordEntryShowPeekIconPropertyInfo = Bool
    type AttrLabel PasswordEntryShowPeekIconPropertyInfo = "show-peek-icon"
    type AttrOrigin PasswordEntryShowPeekIconPropertyInfo = PasswordEntry
    attrGet = getPasswordEntryShowPeekIcon
    attrSet = setPasswordEntryShowPeekIcon
    attrTransfer _ v = do
        return v
    attrConstruct = constructPasswordEntryShowPeekIcon
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.showPeekIcon"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#g:attr:showPeekIcon"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PasswordEntry
type instance O.AttributeList PasswordEntry = PasswordEntryAttributeList
type PasswordEntryAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("activatesDefault", PasswordEntryActivatesDefaultPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("cursorPosition", Gtk.Editable.EditableCursorPositionPropertyInfo), '("editable", Gtk.Editable.EditableEditablePropertyInfo), '("enableUndo", Gtk.Editable.EditableEnableUndoPropertyInfo), '("extraMenu", PasswordEntryExtraMenuPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maxWidthChars", Gtk.Editable.EditableMaxWidthCharsPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("placeholderText", PasswordEntryPlaceholderTextPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("selectionBound", Gtk.Editable.EditableSelectionBoundPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showPeekIcon", PasswordEntryShowPeekIconPropertyInfo), '("text", Gtk.Editable.EditableTextPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthChars", Gtk.Editable.EditableWidthCharsPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("xalign", Gtk.Editable.EditableXalignPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
passwordEntryActivatesDefault :: AttrLabelProxy "activatesDefault"
passwordEntryActivatesDefault = AttrLabelProxy

passwordEntryExtraMenu :: AttrLabelProxy "extraMenu"
passwordEntryExtraMenu = AttrLabelProxy

passwordEntryPlaceholderText :: AttrLabelProxy "placeholderText"
passwordEntryPlaceholderText = AttrLabelProxy

passwordEntryShowPeekIcon :: AttrLabelProxy "showPeekIcon"
passwordEntryShowPeekIcon = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PasswordEntry = PasswordEntrySignalList
type PasswordEntrySignalList = ('[ '("activate", PasswordEntryActivateSignalInfo), '("changed", Gtk.Editable.EditableChangedSignalInfo), '("deleteText", Gtk.Editable.EditableDeleteTextSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("insertText", Gtk.Editable.EditableInsertTextSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PasswordEntry::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PasswordEntry" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_password_entry_new" gtk_password_entry_new :: 
    IO (Ptr PasswordEntry)

-- | Creates a @GtkPasswordEntry@.
passwordEntryNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m PasswordEntry
    -- ^ __Returns:__ a new @GtkPasswordEntry@
passwordEntryNew  = liftIO $ do
    result <- gtk_password_entry_new
    checkUnexpectedReturnNULL "passwordEntryNew" result
    result' <- (newObject PasswordEntry) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method PasswordEntry::get_extra_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PasswordEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPasswordEntry`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_password_entry_get_extra_menu" gtk_password_entry_get_extra_menu :: 
    Ptr PasswordEntry ->                    -- entry : TInterface (Name {namespace = "Gtk", name = "PasswordEntry"})
    IO (Ptr Gio.MenuModel.MenuModel)

-- | Gets the menu model set with 'GI.Gtk.Objects.PasswordEntry.passwordEntrySetExtraMenu'.
passwordEntryGetExtraMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsPasswordEntry a) =>
    a
    -- ^ /@entry@/: a @GtkPasswordEntry@
    -> m (Maybe Gio.MenuModel.MenuModel)
    -- ^ __Returns:__ the menu model
passwordEntryGetExtraMenu entry = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    result <- gtk_password_entry_get_extra_menu entry'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.MenuModel.MenuModel) result'
        return result''
    touchManagedPtr entry
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PasswordEntryGetExtraMenuMethodInfo
instance (signature ~ (m (Maybe Gio.MenuModel.MenuModel)), MonadIO m, IsPasswordEntry a) => O.OverloadedMethod PasswordEntryGetExtraMenuMethodInfo a signature where
    overloadedMethod = passwordEntryGetExtraMenu

instance O.OverloadedMethodInfo PasswordEntryGetExtraMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.passwordEntryGetExtraMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#v:passwordEntryGetExtraMenu"
        })


#endif

-- method PasswordEntry::get_show_peek_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PasswordEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPasswordEntry`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_password_entry_get_show_peek_icon" gtk_password_entry_get_show_peek_icon :: 
    Ptr PasswordEntry ->                    -- entry : TInterface (Name {namespace = "Gtk", name = "PasswordEntry"})
    IO CInt

-- | Returns whether the entry is showing an icon to
-- reveal the contents.
passwordEntryGetShowPeekIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsPasswordEntry a) =>
    a
    -- ^ /@entry@/: a @GtkPasswordEntry@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if an icon is shown
passwordEntryGetShowPeekIcon entry = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    result <- gtk_password_entry_get_show_peek_icon entry'
    let result' = (/= 0) result
    touchManagedPtr entry
    return result'

#if defined(ENABLE_OVERLOADING)
data PasswordEntryGetShowPeekIconMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPasswordEntry a) => O.OverloadedMethod PasswordEntryGetShowPeekIconMethodInfo a signature where
    overloadedMethod = passwordEntryGetShowPeekIcon

instance O.OverloadedMethodInfo PasswordEntryGetShowPeekIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.passwordEntryGetShowPeekIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#v:passwordEntryGetShowPeekIcon"
        })


#endif

-- method PasswordEntry::set_extra_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PasswordEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPasswordEntry`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GMenuModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_password_entry_set_extra_menu" gtk_password_entry_set_extra_menu :: 
    Ptr PasswordEntry ->                    -- entry : TInterface (Name {namespace = "Gtk", name = "PasswordEntry"})
    Ptr Gio.MenuModel.MenuModel ->          -- model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO ()

-- | Sets a menu model to add when constructing
-- the context menu for /@entry@/.
passwordEntrySetExtraMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsPasswordEntry a, Gio.MenuModel.IsMenuModel b) =>
    a
    -- ^ /@entry@/: a @GtkPasswordEntry@
    -> Maybe (b)
    -- ^ /@model@/: a @GMenuModel@
    -> m ()
passwordEntrySetExtraMenu entry model = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_password_entry_set_extra_menu entry' maybeModel
    touchManagedPtr entry
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PasswordEntrySetExtraMenuMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPasswordEntry a, Gio.MenuModel.IsMenuModel b) => O.OverloadedMethod PasswordEntrySetExtraMenuMethodInfo a signature where
    overloadedMethod = passwordEntrySetExtraMenu

instance O.OverloadedMethodInfo PasswordEntrySetExtraMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.passwordEntrySetExtraMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#v:passwordEntrySetExtraMenu"
        })


#endif

-- method PasswordEntry::set_show_peek_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PasswordEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPasswordEntry`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_peek_icon"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show the peek icon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_password_entry_set_show_peek_icon" gtk_password_entry_set_show_peek_icon :: 
    Ptr PasswordEntry ->                    -- entry : TInterface (Name {namespace = "Gtk", name = "PasswordEntry"})
    CInt ->                                 -- show_peek_icon : TBasicType TBoolean
    IO ()

-- | Sets whether the entry should have a clickable icon
-- to reveal the contents.
-- 
-- Setting this to 'P.False' also hides the text again.
passwordEntrySetShowPeekIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsPasswordEntry a) =>
    a
    -- ^ /@entry@/: a @GtkPasswordEntry@
    -> Bool
    -- ^ /@showPeekIcon@/: whether to show the peek icon
    -> m ()
passwordEntrySetShowPeekIcon entry showPeekIcon = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    let showPeekIcon' = (P.fromIntegral . P.fromEnum) showPeekIcon
    gtk_password_entry_set_show_peek_icon entry' showPeekIcon'
    touchManagedPtr entry
    return ()

#if defined(ENABLE_OVERLOADING)
data PasswordEntrySetShowPeekIconMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPasswordEntry a) => O.OverloadedMethod PasswordEntrySetShowPeekIconMethodInfo a signature where
    overloadedMethod = passwordEntrySetShowPeekIcon

instance O.OverloadedMethodInfo PasswordEntrySetShowPeekIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PasswordEntry.passwordEntrySetShowPeekIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PasswordEntry.html#v:passwordEntrySetShowPeekIcon"
        })


#endif


