{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkComboBox@ is a widget that allows the user to choose from a list of
-- valid choices.
-- 
-- \<picture>
--   \<source srcset=\"combo-box-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkComboBox\" src=\"combo-box.png\">
-- \<\/picture>
-- 
-- The @GtkComboBox@ displays the selected choice; when activated, the
-- @GtkComboBox@ displays a popup which allows the user to make a new choice.
-- 
-- The @GtkComboBox@ uses the model-view pattern; the list of valid choices
-- is specified in the form of a tree model, and the display of the choices
-- can be adapted to the data in the model by using cell renderers, as you
-- would in a tree view. This is possible since @GtkComboBox@ implements the
-- t'GI.Gtk.Interfaces.CellLayout.CellLayout' interface. The tree model holding the valid
-- choices is not restricted to a flat list, it can be a real tree, and the
-- popup will reflect the tree structure.
-- 
-- To allow the user to enter values not in the model, the
-- [ComboBox:hasEntry]("GI.Gtk.Objects.ComboBox#g:attr:hasEntry") property allows the @GtkComboBox@ to
-- contain a t'GI.Gtk.Objects.Entry.Entry'. This entry can be accessed by calling
-- 'GI.Gtk.Objects.ComboBox.comboBoxGetChild' on the combo box.
-- 
-- For a simple list of textual choices, the model-view API of @GtkComboBox@
-- can be a bit overwhelming. In this case, t'GI.Gtk.Objects.ComboBoxText.ComboBoxText' offers
-- a simple alternative. Both @GtkComboBox@ and @GtkComboBoxText@ can contain
-- an entry.
-- 
-- == CSS nodes
-- 
-- 
-- 	
-- >combobox
-- >├── box.linked
-- >│   ╰── button.combo
-- >│       ╰── box
-- >│           ├── cellview
-- >│           ╰── arrow
-- >╰── window.popup
-- 
-- 
-- A normal combobox contains a box with the .linked class, a button
-- with the .combo class and inside those buttons, there are a cellview and
-- an arrow.
-- 
-- 
-- 	
-- >combobox
-- >├── box.linked
-- >│   ├── entry.combo
-- >│   ╰── button.combo
-- >│       ╰── box
-- >│           ╰── arrow
-- >╰── window.popup
-- 
-- 
-- A @GtkComboBox@ with an entry has a single CSS node with name combobox.
-- It contains a box with the .linked class. That box contains an entry and
-- a button, both with the .combo class added. The button also contains another
-- node with name arrow.
-- 
-- == Accessibility
-- 
-- @GtkComboBox@ uses the 'GI.Gtk.Enums.AccessibleRoleComboBox' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ComboBox
    ( 

-- * Exported types
    ComboBox(..)                            ,
    IsComboBox                              ,
    toComboBox                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addAttribute]("GI.Gtk.Interfaces.CellLayout#g:method:addAttribute"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [clear]("GI.Gtk.Interfaces.CellLayout#g:method:clear"), [clearAttributes]("GI.Gtk.Interfaces.CellLayout#g:method:clearAttributes"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [editingDone]("GI.Gtk.Interfaces.CellEditable#g:method:editingDone"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [packEnd]("GI.Gtk.Interfaces.CellLayout#g:method:packEnd"), [packStart]("GI.Gtk.Interfaces.CellLayout#g:method:packStart"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [popdown]("GI.Gtk.Objects.ComboBox#g:method:popdown"), [popup]("GI.Gtk.Objects.ComboBox#g:method:popup"), [popupForDevice]("GI.Gtk.Objects.ComboBox#g:method:popupForDevice"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [removeWidget]("GI.Gtk.Interfaces.CellEditable#g:method:removeWidget"), [reorder]("GI.Gtk.Interfaces.CellLayout#g:method:reorder"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [startEditing]("GI.Gtk.Interfaces.CellEditable#g:method:startEditing"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActive]("GI.Gtk.Objects.ComboBox#g:method:getActive"), [getActiveId]("GI.Gtk.Objects.ComboBox#g:method:getActiveId"), [getActiveIter]("GI.Gtk.Objects.ComboBox#g:method:getActiveIter"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getArea]("GI.Gtk.Interfaces.CellLayout#g:method:getArea"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getButtonSensitivity]("GI.Gtk.Objects.ComboBox#g:method:getButtonSensitivity"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCells]("GI.Gtk.Interfaces.CellLayout#g:method:getCells"), [getChild]("GI.Gtk.Objects.ComboBox#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEntryTextColumn]("GI.Gtk.Objects.ComboBox#g:method:getEntryTextColumn"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasEntry]("GI.Gtk.Objects.ComboBox#g:method:getHasEntry"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getIdColumn]("GI.Gtk.Objects.ComboBox#g:method:getIdColumn"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getModel]("GI.Gtk.Objects.ComboBox#g:method:getModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPopupFixedWidth]("GI.Gtk.Objects.ComboBox#g:method:getPopupFixedWidth"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActive]("GI.Gtk.Objects.ComboBox#g:method:setActive"), [setActiveId]("GI.Gtk.Objects.ComboBox#g:method:setActiveId"), [setActiveIter]("GI.Gtk.Objects.ComboBox#g:method:setActiveIter"), [setButtonSensitivity]("GI.Gtk.Objects.ComboBox#g:method:setButtonSensitivity"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCellDataFunc]("GI.Gtk.Interfaces.CellLayout#g:method:setCellDataFunc"), [setChild]("GI.Gtk.Objects.ComboBox#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEntryTextColumn]("GI.Gtk.Objects.ComboBox#g:method:setEntryTextColumn"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIdColumn]("GI.Gtk.Objects.ComboBox#g:method:setIdColumn"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setModel]("GI.Gtk.Objects.ComboBox#g:method:setModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPopupFixedWidth]("GI.Gtk.Objects.ComboBox#g:method:setPopupFixedWidth"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRowSeparatorFunc]("GI.Gtk.Objects.ComboBox#g:method:setRowSeparatorFunc"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveComboBoxMethod                   ,
#endif

-- ** getActive #method:getActive#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetActiveMethodInfo             ,
#endif
    comboBoxGetActive                       ,


-- ** getActiveId #method:getActiveId#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetActiveIdMethodInfo           ,
#endif
    comboBoxGetActiveId                     ,


-- ** getActiveIter #method:getActiveIter#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetActiveIterMethodInfo         ,
#endif
    comboBoxGetActiveIter                   ,


-- ** getButtonSensitivity #method:getButtonSensitivity#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetButtonSensitivityMethodInfo  ,
#endif
    comboBoxGetButtonSensitivity            ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetChildMethodInfo              ,
#endif
    comboBoxGetChild                        ,


-- ** getEntryTextColumn #method:getEntryTextColumn#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetEntryTextColumnMethodInfo    ,
#endif
    comboBoxGetEntryTextColumn              ,


-- ** getHasEntry #method:getHasEntry#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetHasEntryMethodInfo           ,
#endif
    comboBoxGetHasEntry                     ,


-- ** getIdColumn #method:getIdColumn#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetIdColumnMethodInfo           ,
#endif
    comboBoxGetIdColumn                     ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetModelMethodInfo              ,
#endif
    comboBoxGetModel                        ,


-- ** getPopupFixedWidth #method:getPopupFixedWidth#

#if defined(ENABLE_OVERLOADING)
    ComboBoxGetPopupFixedWidthMethodInfo    ,
#endif
    comboBoxGetPopupFixedWidth              ,


-- ** new #method:new#

    comboBoxNew                             ,


-- ** newWithEntry #method:newWithEntry#

    comboBoxNewWithEntry                    ,


-- ** newWithModel #method:newWithModel#

    comboBoxNewWithModel                    ,


-- ** newWithModelAndEntry #method:newWithModelAndEntry#

    comboBoxNewWithModelAndEntry            ,


-- ** popdown #method:popdown#

#if defined(ENABLE_OVERLOADING)
    ComboBoxPopdownMethodInfo               ,
#endif
    comboBoxPopdown                         ,


-- ** popup #method:popup#

#if defined(ENABLE_OVERLOADING)
    ComboBoxPopupMethodInfo                 ,
#endif
    comboBoxPopup                           ,


-- ** popupForDevice #method:popupForDevice#

#if defined(ENABLE_OVERLOADING)
    ComboBoxPopupForDeviceMethodInfo        ,
#endif
    comboBoxPopupForDevice                  ,


-- ** setActive #method:setActive#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetActiveMethodInfo             ,
#endif
    comboBoxSetActive                       ,


-- ** setActiveId #method:setActiveId#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetActiveIdMethodInfo           ,
#endif
    comboBoxSetActiveId                     ,


-- ** setActiveIter #method:setActiveIter#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetActiveIterMethodInfo         ,
#endif
    comboBoxSetActiveIter                   ,


-- ** setButtonSensitivity #method:setButtonSensitivity#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetButtonSensitivityMethodInfo  ,
#endif
    comboBoxSetButtonSensitivity            ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetChildMethodInfo              ,
#endif
    comboBoxSetChild                        ,


-- ** setEntryTextColumn #method:setEntryTextColumn#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetEntryTextColumnMethodInfo    ,
#endif
    comboBoxSetEntryTextColumn              ,


-- ** setIdColumn #method:setIdColumn#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetIdColumnMethodInfo           ,
#endif
    comboBoxSetIdColumn                     ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetModelMethodInfo              ,
#endif
    comboBoxSetModel                        ,


-- ** setPopupFixedWidth #method:setPopupFixedWidth#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetPopupFixedWidthMethodInfo    ,
#endif
    comboBoxSetPopupFixedWidth              ,


-- ** setRowSeparatorFunc #method:setRowSeparatorFunc#

#if defined(ENABLE_OVERLOADING)
    ComboBoxSetRowSeparatorFuncMethodInfo   ,
#endif
    comboBoxSetRowSeparatorFunc             ,




 -- * Properties


-- ** active #attr:active#
-- | The item which is currently active.
-- 
-- If the model is a non-flat treemodel, and the active item is not an
-- immediate child of the root of the tree, this property has the value
-- @gtk_tree_path_get_indices (path)[0]@, where @path@ is the
-- t'GI.Gtk.Structs.TreePath.TreePath' of the active item.

#if defined(ENABLE_OVERLOADING)
    ComboBoxActivePropertyInfo              ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxActive                          ,
#endif
    constructComboBoxActive                 ,
    getComboBoxActive                       ,
    setComboBoxActive                       ,


-- ** activeId #attr:activeId#
-- | The value of the ID column of the active row.

#if defined(ENABLE_OVERLOADING)
    ComboBoxActiveIdPropertyInfo            ,
#endif
    clearComboBoxActiveId                   ,
#if defined(ENABLE_OVERLOADING)
    comboBoxActiveId                        ,
#endif
    constructComboBoxActiveId               ,
    getComboBoxActiveId                     ,
    setComboBoxActiveId                     ,


-- ** buttonSensitivity #attr:buttonSensitivity#
-- | Whether the dropdown button is sensitive when
-- the model is empty.

#if defined(ENABLE_OVERLOADING)
    ComboBoxButtonSensitivityPropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxButtonSensitivity               ,
#endif
    constructComboBoxButtonSensitivity      ,
    getComboBoxButtonSensitivity            ,
    setComboBoxButtonSensitivity            ,


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    ComboBoxChildPropertyInfo               ,
#endif
    clearComboBoxChild                      ,
#if defined(ENABLE_OVERLOADING)
    comboBoxChild                           ,
#endif
    constructComboBoxChild                  ,
    getComboBoxChild                        ,
    setComboBoxChild                        ,


-- ** entryTextColumn #attr:entryTextColumn#
-- | The model column to associate with strings from the entry.
-- 
-- This is property only relevant if the combo was created with
-- [ComboBox:hasEntry]("GI.Gtk.Objects.ComboBox#g:attr:hasEntry") is 'P.True'.

#if defined(ENABLE_OVERLOADING)
    ComboBoxEntryTextColumnPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxEntryTextColumn                 ,
#endif
    constructComboBoxEntryTextColumn        ,
    getComboBoxEntryTextColumn              ,
    setComboBoxEntryTextColumn              ,


-- ** hasEntry #attr:hasEntry#
-- | Whether the combo box has an entry.

#if defined(ENABLE_OVERLOADING)
    ComboBoxHasEntryPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxHasEntry                        ,
#endif
    constructComboBoxHasEntry               ,
    getComboBoxHasEntry                     ,


-- ** hasFrame #attr:hasFrame#
-- | The @has-frame@ property controls whether a frame is drawn around the entry.

#if defined(ENABLE_OVERLOADING)
    ComboBoxHasFramePropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxHasFrame                        ,
#endif
    constructComboBoxHasFrame               ,
    getComboBoxHasFrame                     ,
    setComboBoxHasFrame                     ,


-- ** idColumn #attr:idColumn#
-- | The model column that provides string IDs for the values
-- in the model, if != -1.

#if defined(ENABLE_OVERLOADING)
    ComboBoxIdColumnPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxIdColumn                        ,
#endif
    constructComboBoxIdColumn               ,
    getComboBoxIdColumn                     ,
    setComboBoxIdColumn                     ,


-- ** model #attr:model#
-- | The model from which the combo box takes its values.

#if defined(ENABLE_OVERLOADING)
    ComboBoxModelPropertyInfo               ,
#endif
    clearComboBoxModel                      ,
#if defined(ENABLE_OVERLOADING)
    comboBoxModel                           ,
#endif
    constructComboBoxModel                  ,
    getComboBoxModel                        ,
    setComboBoxModel                        ,


-- ** popupFixedWidth #attr:popupFixedWidth#
-- | Whether the popup\'s width should be a fixed width matching the
-- allocated width of the combo box.

#if defined(ENABLE_OVERLOADING)
    ComboBoxPopupFixedWidthPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxPopupFixedWidth                 ,
#endif
    constructComboBoxPopupFixedWidth        ,
    getComboBoxPopupFixedWidth              ,
    setComboBoxPopupFixedWidth              ,


-- ** popupShown #attr:popupShown#
-- | Whether the combo boxes dropdown is popped up.
-- 
-- Note that this property is mainly useful, because
-- it allows you to connect to notify[popupShown](#g:signal:popupShown).

#if defined(ENABLE_OVERLOADING)
    ComboBoxPopupShownPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    comboBoxPopupShown                      ,
#endif
    getComboBoxPopupShown                   ,




 -- * Signals


-- ** activate #signal:activate#

    ComboBoxActivateCallback                ,
#if defined(ENABLE_OVERLOADING)
    ComboBoxActivateSignalInfo              ,
#endif
    afterComboBoxActivate                   ,
    onComboBoxActivate                      ,


-- ** changed #signal:changed#

    ComboBoxChangedCallback                 ,
#if defined(ENABLE_OVERLOADING)
    ComboBoxChangedSignalInfo               ,
#endif
    afterComboBoxChanged                    ,
    onComboBoxChanged                       ,


-- ** formatEntryText #signal:formatEntryText#

    ComboBoxFormatEntryTextCallback         ,
#if defined(ENABLE_OVERLOADING)
    ComboBoxFormatEntryTextSignalInfo       ,
#endif
    afterComboBoxFormatEntryText            ,
    onComboBoxFormatEntryText               ,


-- ** moveActive #signal:moveActive#

    ComboBoxMoveActiveCallback              ,
#if defined(ENABLE_OVERLOADING)
    ComboBoxMoveActiveSignalInfo            ,
#endif
    afterComboBoxMoveActive                 ,
    onComboBoxMoveActive                    ,


-- ** popdown #signal:popdown#

    ComboBoxPopdownCallback                 ,
#if defined(ENABLE_OVERLOADING)
    ComboBoxPopdownSignalInfo               ,
#endif
    afterComboBoxPopdown                    ,
    onComboBoxPopdown                       ,


-- ** popup #signal:popup#

    ComboBoxPopupCallback                   ,
#if defined(ENABLE_OVERLOADING)
    ComboBoxPopupSignalInfo                 ,
#endif
    afterComboBoxPopup                      ,
    onComboBoxPopup                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellArea as Gtk.CellArea
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellAreaContext as Gtk.CellAreaContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter

#endif

-- | Memory-managed wrapper type.
newtype ComboBox = ComboBox (SP.ManagedPtr ComboBox)
    deriving (Eq)

instance SP.ManagedPtrNewtype ComboBox where
    toManagedPtr (ComboBox p) = p

foreign import ccall "gtk_combo_box_get_type"
    c_gtk_combo_box_get_type :: IO B.Types.GType

instance B.Types.TypedObject ComboBox where
    glibType = c_gtk_combo_box_get_type

instance B.Types.GObject ComboBox

-- | Type class for types which can be safely cast to t'ComboBox', for instance with `toComboBox`.
class (SP.GObject o, O.IsDescendantOf ComboBox o) => IsComboBox o
instance (SP.GObject o, O.IsDescendantOf ComboBox o) => IsComboBox o

instance O.HasParentTypes ComboBox
type instance O.ParentTypes ComboBox = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.CellEditable.CellEditable, Gtk.CellLayout.CellLayout, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'ComboBox', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toComboBox :: (MIO.MonadIO m, IsComboBox o) => o -> m ComboBox
toComboBox = MIO.liftIO . B.ManagedPtr.unsafeCastTo ComboBox

-- | Convert t'ComboBox' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ComboBox) where
    gvalueGType_ = c_gtk_combo_box_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ComboBox)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ComboBox)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ComboBox ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveComboBoxMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveComboBoxMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveComboBoxMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveComboBoxMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveComboBoxMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveComboBoxMethod "addAttribute" o = Gtk.CellLayout.CellLayoutAddAttributeMethodInfo
    ResolveComboBoxMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveComboBoxMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveComboBoxMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveComboBoxMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveComboBoxMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveComboBoxMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveComboBoxMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveComboBoxMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveComboBoxMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveComboBoxMethod "clear" o = Gtk.CellLayout.CellLayoutClearMethodInfo
    ResolveComboBoxMethod "clearAttributes" o = Gtk.CellLayout.CellLayoutClearAttributesMethodInfo
    ResolveComboBoxMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveComboBoxMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveComboBoxMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveComboBoxMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveComboBoxMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveComboBoxMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveComboBoxMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveComboBoxMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveComboBoxMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveComboBoxMethod "editingDone" o = Gtk.CellEditable.CellEditableEditingDoneMethodInfo
    ResolveComboBoxMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveComboBoxMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveComboBoxMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveComboBoxMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveComboBoxMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveComboBoxMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveComboBoxMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveComboBoxMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveComboBoxMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveComboBoxMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveComboBoxMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveComboBoxMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveComboBoxMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveComboBoxMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveComboBoxMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveComboBoxMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveComboBoxMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveComboBoxMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveComboBoxMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveComboBoxMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveComboBoxMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveComboBoxMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveComboBoxMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveComboBoxMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveComboBoxMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveComboBoxMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveComboBoxMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveComboBoxMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveComboBoxMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveComboBoxMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveComboBoxMethod "packEnd" o = Gtk.CellLayout.CellLayoutPackEndMethodInfo
    ResolveComboBoxMethod "packStart" o = Gtk.CellLayout.CellLayoutPackStartMethodInfo
    ResolveComboBoxMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveComboBoxMethod "popdown" o = ComboBoxPopdownMethodInfo
    ResolveComboBoxMethod "popup" o = ComboBoxPopupMethodInfo
    ResolveComboBoxMethod "popupForDevice" o = ComboBoxPopupForDeviceMethodInfo
    ResolveComboBoxMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveComboBoxMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveComboBoxMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveComboBoxMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveComboBoxMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveComboBoxMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveComboBoxMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveComboBoxMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveComboBoxMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveComboBoxMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveComboBoxMethod "removeWidget" o = Gtk.CellEditable.CellEditableRemoveWidgetMethodInfo
    ResolveComboBoxMethod "reorder" o = Gtk.CellLayout.CellLayoutReorderMethodInfo
    ResolveComboBoxMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveComboBoxMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveComboBoxMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveComboBoxMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveComboBoxMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveComboBoxMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveComboBoxMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveComboBoxMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveComboBoxMethod "startEditing" o = Gtk.CellEditable.CellEditableStartEditingMethodInfo
    ResolveComboBoxMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveComboBoxMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveComboBoxMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveComboBoxMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveComboBoxMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveComboBoxMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveComboBoxMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveComboBoxMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveComboBoxMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveComboBoxMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveComboBoxMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveComboBoxMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveComboBoxMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveComboBoxMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveComboBoxMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveComboBoxMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveComboBoxMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveComboBoxMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveComboBoxMethod "getActive" o = ComboBoxGetActiveMethodInfo
    ResolveComboBoxMethod "getActiveId" o = ComboBoxGetActiveIdMethodInfo
    ResolveComboBoxMethod "getActiveIter" o = ComboBoxGetActiveIterMethodInfo
    ResolveComboBoxMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveComboBoxMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveComboBoxMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveComboBoxMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveComboBoxMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveComboBoxMethod "getArea" o = Gtk.CellLayout.CellLayoutGetAreaMethodInfo
    ResolveComboBoxMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveComboBoxMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveComboBoxMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveComboBoxMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveComboBoxMethod "getButtonSensitivity" o = ComboBoxGetButtonSensitivityMethodInfo
    ResolveComboBoxMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveComboBoxMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveComboBoxMethod "getCells" o = Gtk.CellLayout.CellLayoutGetCellsMethodInfo
    ResolveComboBoxMethod "getChild" o = ComboBoxGetChildMethodInfo
    ResolveComboBoxMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveComboBoxMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveComboBoxMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveComboBoxMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveComboBoxMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveComboBoxMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveComboBoxMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveComboBoxMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveComboBoxMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveComboBoxMethod "getEntryTextColumn" o = ComboBoxGetEntryTextColumnMethodInfo
    ResolveComboBoxMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveComboBoxMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveComboBoxMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveComboBoxMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveComboBoxMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveComboBoxMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveComboBoxMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveComboBoxMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveComboBoxMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveComboBoxMethod "getHasEntry" o = ComboBoxGetHasEntryMethodInfo
    ResolveComboBoxMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveComboBoxMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveComboBoxMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveComboBoxMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveComboBoxMethod "getIdColumn" o = ComboBoxGetIdColumnMethodInfo
    ResolveComboBoxMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveComboBoxMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveComboBoxMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveComboBoxMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveComboBoxMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveComboBoxMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveComboBoxMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveComboBoxMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveComboBoxMethod "getModel" o = ComboBoxGetModelMethodInfo
    ResolveComboBoxMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveComboBoxMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveComboBoxMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveComboBoxMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveComboBoxMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveComboBoxMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveComboBoxMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveComboBoxMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveComboBoxMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveComboBoxMethod "getPopupFixedWidth" o = ComboBoxGetPopupFixedWidthMethodInfo
    ResolveComboBoxMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveComboBoxMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveComboBoxMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveComboBoxMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveComboBoxMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveComboBoxMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveComboBoxMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveComboBoxMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveComboBoxMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveComboBoxMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveComboBoxMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveComboBoxMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveComboBoxMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveComboBoxMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveComboBoxMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveComboBoxMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveComboBoxMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveComboBoxMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveComboBoxMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveComboBoxMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveComboBoxMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveComboBoxMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveComboBoxMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveComboBoxMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveComboBoxMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveComboBoxMethod "setActive" o = ComboBoxSetActiveMethodInfo
    ResolveComboBoxMethod "setActiveId" o = ComboBoxSetActiveIdMethodInfo
    ResolveComboBoxMethod "setActiveIter" o = ComboBoxSetActiveIterMethodInfo
    ResolveComboBoxMethod "setButtonSensitivity" o = ComboBoxSetButtonSensitivityMethodInfo
    ResolveComboBoxMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveComboBoxMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveComboBoxMethod "setCellDataFunc" o = Gtk.CellLayout.CellLayoutSetCellDataFuncMethodInfo
    ResolveComboBoxMethod "setChild" o = ComboBoxSetChildMethodInfo
    ResolveComboBoxMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveComboBoxMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveComboBoxMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveComboBoxMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveComboBoxMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveComboBoxMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveComboBoxMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveComboBoxMethod "setEntryTextColumn" o = ComboBoxSetEntryTextColumnMethodInfo
    ResolveComboBoxMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveComboBoxMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveComboBoxMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveComboBoxMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveComboBoxMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveComboBoxMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveComboBoxMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveComboBoxMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveComboBoxMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveComboBoxMethod "setIdColumn" o = ComboBoxSetIdColumnMethodInfo
    ResolveComboBoxMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveComboBoxMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveComboBoxMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveComboBoxMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveComboBoxMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveComboBoxMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveComboBoxMethod "setModel" o = ComboBoxSetModelMethodInfo
    ResolveComboBoxMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveComboBoxMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveComboBoxMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveComboBoxMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveComboBoxMethod "setPopupFixedWidth" o = ComboBoxSetPopupFixedWidthMethodInfo
    ResolveComboBoxMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveComboBoxMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveComboBoxMethod "setRowSeparatorFunc" o = ComboBoxSetRowSeparatorFuncMethodInfo
    ResolveComboBoxMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveComboBoxMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveComboBoxMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveComboBoxMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveComboBoxMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveComboBoxMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveComboBoxMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveComboBoxMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveComboBoxMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveComboBoxMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveComboBoxMethod t ComboBox, O.OverloadedMethod info ComboBox p) => OL.IsLabel t (ComboBox -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveComboBoxMethod t ComboBox, O.OverloadedMethod info ComboBox p, R.HasField t ComboBox p) => R.HasField t ComboBox p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveComboBoxMethod t ComboBox, O.OverloadedMethodInfo info ComboBox) => OL.IsLabel t (O.MethodProxy info ComboBox) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ComboBox::activate
-- | Emitted to when the combo box is activated.
-- 
-- The @::activate@ signal on @GtkComboBox@ is an action signal and
-- emitting it causes the combo box to pop up its dropdown.
-- 
-- /Since: 4.6/
type ComboBoxActivateCallback =
    IO ()

type C_ComboBoxActivateCallback =
    Ptr ComboBox ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ComboBoxActivateCallback`.
foreign import ccall "wrapper"
    mk_ComboBoxActivateCallback :: C_ComboBoxActivateCallback -> IO (FunPtr C_ComboBoxActivateCallback)

wrap_ComboBoxActivateCallback :: 
    GObject a => (a -> ComboBoxActivateCallback) ->
    C_ComboBoxActivateCallback
wrap_ComboBoxActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' comboBox #activate callback
-- @
-- 
-- 
onComboBoxActivate :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxActivateCallback) -> m SignalHandlerId
onComboBoxActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxActivateCallback wrapped
    wrapped'' <- mk_ComboBoxActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' comboBox #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterComboBoxActivate :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxActivateCallback) -> m SignalHandlerId
afterComboBoxActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxActivateCallback wrapped
    wrapped'' <- mk_ComboBoxActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ComboBoxActivateSignalInfo
instance SignalInfo ComboBoxActivateSignalInfo where
    type HaskellCallbackType ComboBoxActivateSignalInfo = ComboBoxActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ComboBoxActivateCallback cb
        cb'' <- mk_ComboBoxActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:signal:activate"})

#endif

-- signal ComboBox::changed
-- | Emitted when the active item is changed.
-- 
-- The can be due to the user selecting a different item from the list,
-- or due to a call to 'GI.Gtk.Objects.ComboBox.comboBoxSetActiveIter'. It will
-- also be emitted while typing into the entry of a combo box with an entry.
type ComboBoxChangedCallback =
    IO ()

type C_ComboBoxChangedCallback =
    Ptr ComboBox ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ComboBoxChangedCallback`.
foreign import ccall "wrapper"
    mk_ComboBoxChangedCallback :: C_ComboBoxChangedCallback -> IO (FunPtr C_ComboBoxChangedCallback)

wrap_ComboBoxChangedCallback :: 
    GObject a => (a -> ComboBoxChangedCallback) ->
    C_ComboBoxChangedCallback
wrap_ComboBoxChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' comboBox #changed callback
-- @
-- 
-- 
onComboBoxChanged :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxChangedCallback) -> m SignalHandlerId
onComboBoxChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxChangedCallback wrapped
    wrapped'' <- mk_ComboBoxChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' comboBox #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterComboBoxChanged :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxChangedCallback) -> m SignalHandlerId
afterComboBoxChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxChangedCallback wrapped
    wrapped'' <- mk_ComboBoxChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ComboBoxChangedSignalInfo
instance SignalInfo ComboBoxChangedSignalInfo where
    type HaskellCallbackType ComboBoxChangedSignalInfo = ComboBoxChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ComboBoxChangedCallback cb
        cb'' <- mk_ComboBoxChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:signal:changed"})

#endif

-- signal ComboBox::format-entry-text
-- | Emitted to allow changing how the text in a combo box\'s entry is displayed.
-- 
-- See [ComboBox:hasEntry]("GI.Gtk.Objects.ComboBox#g:attr:hasEntry").
-- 
-- Connect a signal handler which returns an allocated string representing
-- /@path@/. That string will then be used to set the text in the combo box\'s
-- entry. The default signal handler uses the text from the
-- [ComboBox:entryTextColumn]("GI.Gtk.Objects.ComboBox#g:attr:entryTextColumn") model column.
-- 
-- Here\'s an example signal handler which fetches data from the model and
-- displays it in the entry.
-- 
-- === /c code/
-- >static char *
-- >format_entry_text_callback (GtkComboBox *combo,
-- >                            const char *path,
-- >                            gpointer     user_data)
-- >{
-- >  GtkTreeIter iter;
-- >  GtkTreeModel model;
-- >  double       value;
-- >
-- >  model = gtk_combo_box_get_model (combo);
-- >
-- >  gtk_tree_model_get_iter_from_string (model, &iter, path);
-- >  gtk_tree_model_get (model, &iter,
-- >                      THE_DOUBLE_VALUE_COLUMN, &value,
-- >                      -1);
-- >
-- >  return g_strdup_printf ("%g", value);
-- >}
type ComboBoxFormatEntryTextCallback =
    T.Text
    -- ^ /@path@/: the t'GI.Gtk.Structs.TreePath.TreePath' string from the combo box\'s current model
    --   to format text for
    -> IO T.Text
    -- ^ __Returns:__ a newly allocated string representing /@path@/
    --   for the current @GtkComboBox@ model.

type C_ComboBoxFormatEntryTextCallback =
    Ptr ComboBox ->                         -- object
    CString ->
    Ptr () ->                               -- user_data
    IO CString

-- | Generate a function pointer callable from C code, from a `C_ComboBoxFormatEntryTextCallback`.
foreign import ccall "wrapper"
    mk_ComboBoxFormatEntryTextCallback :: C_ComboBoxFormatEntryTextCallback -> IO (FunPtr C_ComboBoxFormatEntryTextCallback)

wrap_ComboBoxFormatEntryTextCallback :: 
    GObject a => (a -> ComboBoxFormatEntryTextCallback) ->
    C_ComboBoxFormatEntryTextCallback
wrap_ComboBoxFormatEntryTextCallback gi'cb gi'selfPtr path _ = do
    path' <- cstringToText path
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  path'
    result' <- textToCString result
    return result'


-- | Connect a signal handler for the [formatEntryText](#signal:formatEntryText) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' comboBox #formatEntryText callback
-- @
-- 
-- 
onComboBoxFormatEntryText :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxFormatEntryTextCallback) -> m SignalHandlerId
onComboBoxFormatEntryText obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxFormatEntryTextCallback wrapped
    wrapped'' <- mk_ComboBoxFormatEntryTextCallback wrapped'
    connectSignalFunPtr obj "format-entry-text" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [formatEntryText](#signal:formatEntryText) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' comboBox #formatEntryText callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterComboBoxFormatEntryText :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxFormatEntryTextCallback) -> m SignalHandlerId
afterComboBoxFormatEntryText obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxFormatEntryTextCallback wrapped
    wrapped'' <- mk_ComboBoxFormatEntryTextCallback wrapped'
    connectSignalFunPtr obj "format-entry-text" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ComboBoxFormatEntryTextSignalInfo
instance SignalInfo ComboBoxFormatEntryTextSignalInfo where
    type HaskellCallbackType ComboBoxFormatEntryTextSignalInfo = ComboBoxFormatEntryTextCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ComboBoxFormatEntryTextCallback cb
        cb'' <- mk_ComboBoxFormatEntryTextCallback cb'
        connectSignalFunPtr obj "format-entry-text" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox::format-entry-text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:signal:formatEntryText"})

#endif

-- signal ComboBox::move-active
-- | Emitted to move the active selection.
-- 
-- This is an <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
type ComboBoxMoveActiveCallback =
    Gtk.Enums.ScrollType
    -- ^ /@scrollType@/: a @GtkScrollType@
    -> IO ()

type C_ComboBoxMoveActiveCallback =
    Ptr ComboBox ->                         -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ComboBoxMoveActiveCallback`.
foreign import ccall "wrapper"
    mk_ComboBoxMoveActiveCallback :: C_ComboBoxMoveActiveCallback -> IO (FunPtr C_ComboBoxMoveActiveCallback)

wrap_ComboBoxMoveActiveCallback :: 
    GObject a => (a -> ComboBoxMoveActiveCallback) ->
    C_ComboBoxMoveActiveCallback
wrap_ComboBoxMoveActiveCallback gi'cb gi'selfPtr scrollType _ = do
    let scrollType' = (toEnum . fromIntegral) scrollType
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  scrollType'


-- | Connect a signal handler for the [moveActive](#signal:moveActive) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' comboBox #moveActive callback
-- @
-- 
-- 
onComboBoxMoveActive :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxMoveActiveCallback) -> m SignalHandlerId
onComboBoxMoveActive obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxMoveActiveCallback wrapped
    wrapped'' <- mk_ComboBoxMoveActiveCallback wrapped'
    connectSignalFunPtr obj "move-active" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveActive](#signal:moveActive) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' comboBox #moveActive callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterComboBoxMoveActive :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxMoveActiveCallback) -> m SignalHandlerId
afterComboBoxMoveActive obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxMoveActiveCallback wrapped
    wrapped'' <- mk_ComboBoxMoveActiveCallback wrapped'
    connectSignalFunPtr obj "move-active" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ComboBoxMoveActiveSignalInfo
instance SignalInfo ComboBoxMoveActiveSignalInfo where
    type HaskellCallbackType ComboBoxMoveActiveSignalInfo = ComboBoxMoveActiveCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ComboBoxMoveActiveCallback cb
        cb'' <- mk_ComboBoxMoveActiveCallback cb'
        connectSignalFunPtr obj "move-active" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox::move-active"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:signal:moveActive"})

#endif

-- signal ComboBox::popdown
-- | Emitted to popdown the combo box list.
-- 
-- This is an <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are Alt+Up and Escape.
type ComboBoxPopdownCallback =
    IO Bool
    -- ^ __Returns:__ whether the combo box was popped down

type C_ComboBoxPopdownCallback =
    Ptr ComboBox ->                         -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_ComboBoxPopdownCallback`.
foreign import ccall "wrapper"
    mk_ComboBoxPopdownCallback :: C_ComboBoxPopdownCallback -> IO (FunPtr C_ComboBoxPopdownCallback)

wrap_ComboBoxPopdownCallback :: 
    GObject a => (a -> ComboBoxPopdownCallback) ->
    C_ComboBoxPopdownCallback
wrap_ComboBoxPopdownCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [popdown](#signal:popdown) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' comboBox #popdown callback
-- @
-- 
-- 
onComboBoxPopdown :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxPopdownCallback) -> m SignalHandlerId
onComboBoxPopdown obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxPopdownCallback wrapped
    wrapped'' <- mk_ComboBoxPopdownCallback wrapped'
    connectSignalFunPtr obj "popdown" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [popdown](#signal:popdown) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' comboBox #popdown callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterComboBoxPopdown :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxPopdownCallback) -> m SignalHandlerId
afterComboBoxPopdown obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxPopdownCallback wrapped
    wrapped'' <- mk_ComboBoxPopdownCallback wrapped'
    connectSignalFunPtr obj "popdown" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ComboBoxPopdownSignalInfo
instance SignalInfo ComboBoxPopdownSignalInfo where
    type HaskellCallbackType ComboBoxPopdownSignalInfo = ComboBoxPopdownCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ComboBoxPopdownCallback cb
        cb'' <- mk_ComboBoxPopdownCallback cb'
        connectSignalFunPtr obj "popdown" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox::popdown"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:signal:popdown"})

#endif

-- signal ComboBox::popup
-- | Emitted to popup the combo box list.
-- 
-- This is an <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is Alt+Down.
type ComboBoxPopupCallback =
    IO ()

type C_ComboBoxPopupCallback =
    Ptr ComboBox ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ComboBoxPopupCallback`.
foreign import ccall "wrapper"
    mk_ComboBoxPopupCallback :: C_ComboBoxPopupCallback -> IO (FunPtr C_ComboBoxPopupCallback)

wrap_ComboBoxPopupCallback :: 
    GObject a => (a -> ComboBoxPopupCallback) ->
    C_ComboBoxPopupCallback
wrap_ComboBoxPopupCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [popup](#signal:popup) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' comboBox #popup callback
-- @
-- 
-- 
onComboBoxPopup :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxPopupCallback) -> m SignalHandlerId
onComboBoxPopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxPopupCallback wrapped
    wrapped'' <- mk_ComboBoxPopupCallback wrapped'
    connectSignalFunPtr obj "popup" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [popup](#signal:popup) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' comboBox #popup callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterComboBoxPopup :: (IsComboBox a, MonadIO m) => a -> ((?self :: a) => ComboBoxPopupCallback) -> m SignalHandlerId
afterComboBoxPopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ComboBoxPopupCallback wrapped
    wrapped'' <- mk_ComboBoxPopupCallback wrapped'
    connectSignalFunPtr obj "popup" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ComboBoxPopupSignalInfo
instance SignalInfo ComboBoxPopupSignalInfo where
    type HaskellCallbackType ComboBoxPopupSignalInfo = ComboBoxPopupCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ComboBoxPopupCallback cb
        cb'' <- mk_ComboBoxPopupCallback cb'
        connectSignalFunPtr obj "popup" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox::popup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:signal:popup"})

#endif

-- VVV Prop "active"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #active
-- @
getComboBoxActive :: (MonadIO m, IsComboBox o) => o -> m Int32
getComboBoxActive obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "active"

-- | Set the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #active 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxActive :: (MonadIO m, IsComboBox o) => o -> Int32 -> m ()
setComboBoxActive obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "active" val

-- | Construct a t'GValueConstruct' with valid value for the “@active@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxActive :: (IsComboBox o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructComboBoxActive val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "active" val

#if defined(ENABLE_OVERLOADING)
data ComboBoxActivePropertyInfo
instance AttrInfo ComboBoxActivePropertyInfo where
    type AttrAllowedOps ComboBoxActivePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxActivePropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxActivePropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ComboBoxActivePropertyInfo = (~) Int32
    type AttrTransferType ComboBoxActivePropertyInfo = Int32
    type AttrGetType ComboBoxActivePropertyInfo = Int32
    type AttrLabel ComboBoxActivePropertyInfo = "active"
    type AttrOrigin ComboBoxActivePropertyInfo = ComboBox
    attrGet = getComboBoxActive
    attrSet = setComboBoxActive
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxActive
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.active"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:active"
        })
#endif

-- VVV Prop "active-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@active-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #activeId
-- @
getComboBoxActiveId :: (MonadIO m, IsComboBox o) => o -> m (Maybe T.Text)
getComboBoxActiveId obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "active-id"

-- | Set the value of the “@active-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #activeId 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxActiveId :: (MonadIO m, IsComboBox o) => o -> T.Text -> m ()
setComboBoxActiveId obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "active-id" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@active-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxActiveId :: (IsComboBox o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructComboBoxActiveId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "active-id" (P.Just val)

-- | Set the value of the “@active-id@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #activeId
-- @
clearComboBoxActiveId :: (MonadIO m, IsComboBox o) => o -> m ()
clearComboBoxActiveId obj = liftIO $ B.Properties.setObjectPropertyString obj "active-id" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ComboBoxActiveIdPropertyInfo
instance AttrInfo ComboBoxActiveIdPropertyInfo where
    type AttrAllowedOps ComboBoxActiveIdPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ComboBoxActiveIdPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxActiveIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ComboBoxActiveIdPropertyInfo = (~) T.Text
    type AttrTransferType ComboBoxActiveIdPropertyInfo = T.Text
    type AttrGetType ComboBoxActiveIdPropertyInfo = (Maybe T.Text)
    type AttrLabel ComboBoxActiveIdPropertyInfo = "active-id"
    type AttrOrigin ComboBoxActiveIdPropertyInfo = ComboBox
    attrGet = getComboBoxActiveId
    attrSet = setComboBoxActiveId
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxActiveId
    attrClear = clearComboBoxActiveId
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.activeId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:activeId"
        })
#endif

-- VVV Prop "button-sensitivity"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SensitivityType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@button-sensitivity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #buttonSensitivity
-- @
getComboBoxButtonSensitivity :: (MonadIO m, IsComboBox o) => o -> m Gtk.Enums.SensitivityType
getComboBoxButtonSensitivity obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "button-sensitivity"

-- | Set the value of the “@button-sensitivity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #buttonSensitivity 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxButtonSensitivity :: (MonadIO m, IsComboBox o) => o -> Gtk.Enums.SensitivityType -> m ()
setComboBoxButtonSensitivity obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "button-sensitivity" val

-- | Construct a t'GValueConstruct' with valid value for the “@button-sensitivity@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxButtonSensitivity :: (IsComboBox o, MIO.MonadIO m) => Gtk.Enums.SensitivityType -> m (GValueConstruct o)
constructComboBoxButtonSensitivity val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "button-sensitivity" val

#if defined(ENABLE_OVERLOADING)
data ComboBoxButtonSensitivityPropertyInfo
instance AttrInfo ComboBoxButtonSensitivityPropertyInfo where
    type AttrAllowedOps ComboBoxButtonSensitivityPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxButtonSensitivityPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxButtonSensitivityPropertyInfo = (~) Gtk.Enums.SensitivityType
    type AttrTransferTypeConstraint ComboBoxButtonSensitivityPropertyInfo = (~) Gtk.Enums.SensitivityType
    type AttrTransferType ComboBoxButtonSensitivityPropertyInfo = Gtk.Enums.SensitivityType
    type AttrGetType ComboBoxButtonSensitivityPropertyInfo = Gtk.Enums.SensitivityType
    type AttrLabel ComboBoxButtonSensitivityPropertyInfo = "button-sensitivity"
    type AttrOrigin ComboBoxButtonSensitivityPropertyInfo = ComboBox
    attrGet = getComboBoxButtonSensitivity
    attrSet = setComboBoxButtonSensitivity
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxButtonSensitivity
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.buttonSensitivity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:buttonSensitivity"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #child
-- @
getComboBoxChild :: (MonadIO m, IsComboBox o) => o -> m (Maybe Gtk.Widget.Widget)
getComboBoxChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxChild :: (MonadIO m, IsComboBox o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setComboBoxChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxChild :: (IsComboBox o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructComboBoxChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearComboBoxChild :: (MonadIO m, IsComboBox o) => o -> m ()
clearComboBoxChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data ComboBoxChildPropertyInfo
instance AttrInfo ComboBoxChildPropertyInfo where
    type AttrAllowedOps ComboBoxChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ComboBoxChildPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint ComboBoxChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType ComboBoxChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType ComboBoxChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel ComboBoxChildPropertyInfo = "child"
    type AttrOrigin ComboBoxChildPropertyInfo = ComboBox
    attrGet = getComboBoxChild
    attrSet = setComboBoxChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructComboBoxChild
    attrClear = clearComboBoxChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:child"
        })
#endif

-- VVV Prop "entry-text-column"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@entry-text-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #entryTextColumn
-- @
getComboBoxEntryTextColumn :: (MonadIO m, IsComboBox o) => o -> m Int32
getComboBoxEntryTextColumn obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "entry-text-column"

-- | Set the value of the “@entry-text-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #entryTextColumn 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxEntryTextColumn :: (MonadIO m, IsComboBox o) => o -> Int32 -> m ()
setComboBoxEntryTextColumn obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "entry-text-column" val

-- | Construct a t'GValueConstruct' with valid value for the “@entry-text-column@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxEntryTextColumn :: (IsComboBox o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructComboBoxEntryTextColumn val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "entry-text-column" val

#if defined(ENABLE_OVERLOADING)
data ComboBoxEntryTextColumnPropertyInfo
instance AttrInfo ComboBoxEntryTextColumnPropertyInfo where
    type AttrAllowedOps ComboBoxEntryTextColumnPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxEntryTextColumnPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxEntryTextColumnPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ComboBoxEntryTextColumnPropertyInfo = (~) Int32
    type AttrTransferType ComboBoxEntryTextColumnPropertyInfo = Int32
    type AttrGetType ComboBoxEntryTextColumnPropertyInfo = Int32
    type AttrLabel ComboBoxEntryTextColumnPropertyInfo = "entry-text-column"
    type AttrOrigin ComboBoxEntryTextColumnPropertyInfo = ComboBox
    attrGet = getComboBoxEntryTextColumn
    attrSet = setComboBoxEntryTextColumn
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxEntryTextColumn
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.entryTextColumn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:entryTextColumn"
        })
#endif

-- VVV Prop "has-entry"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@has-entry@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #hasEntry
-- @
getComboBoxHasEntry :: (MonadIO m, IsComboBox o) => o -> m Bool
getComboBoxHasEntry obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-entry"

-- | Construct a t'GValueConstruct' with valid value for the “@has-entry@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxHasEntry :: (IsComboBox o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructComboBoxHasEntry val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-entry" val

#if defined(ENABLE_OVERLOADING)
data ComboBoxHasEntryPropertyInfo
instance AttrInfo ComboBoxHasEntryPropertyInfo where
    type AttrAllowedOps ComboBoxHasEntryPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxHasEntryPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxHasEntryPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ComboBoxHasEntryPropertyInfo = (~) Bool
    type AttrTransferType ComboBoxHasEntryPropertyInfo = Bool
    type AttrGetType ComboBoxHasEntryPropertyInfo = Bool
    type AttrLabel ComboBoxHasEntryPropertyInfo = "has-entry"
    type AttrOrigin ComboBoxHasEntryPropertyInfo = ComboBox
    attrGet = getComboBoxHasEntry
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxHasEntry
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.hasEntry"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:hasEntry"
        })
#endif

-- VVV Prop "has-frame"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #hasFrame
-- @
getComboBoxHasFrame :: (MonadIO m, IsComboBox o) => o -> m Bool
getComboBoxHasFrame obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-frame"

-- | Set the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #hasFrame 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxHasFrame :: (MonadIO m, IsComboBox o) => o -> Bool -> m ()
setComboBoxHasFrame obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-frame" val

-- | Construct a t'GValueConstruct' with valid value for the “@has-frame@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxHasFrame :: (IsComboBox o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructComboBoxHasFrame val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-frame" val

#if defined(ENABLE_OVERLOADING)
data ComboBoxHasFramePropertyInfo
instance AttrInfo ComboBoxHasFramePropertyInfo where
    type AttrAllowedOps ComboBoxHasFramePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxHasFramePropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxHasFramePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ComboBoxHasFramePropertyInfo = (~) Bool
    type AttrTransferType ComboBoxHasFramePropertyInfo = Bool
    type AttrGetType ComboBoxHasFramePropertyInfo = Bool
    type AttrLabel ComboBoxHasFramePropertyInfo = "has-frame"
    type AttrOrigin ComboBoxHasFramePropertyInfo = ComboBox
    attrGet = getComboBoxHasFrame
    attrSet = setComboBoxHasFrame
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxHasFrame
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.hasFrame"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:hasFrame"
        })
#endif

-- VVV Prop "id-column"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@id-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #idColumn
-- @
getComboBoxIdColumn :: (MonadIO m, IsComboBox o) => o -> m Int32
getComboBoxIdColumn obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "id-column"

-- | Set the value of the “@id-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #idColumn 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxIdColumn :: (MonadIO m, IsComboBox o) => o -> Int32 -> m ()
setComboBoxIdColumn obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "id-column" val

-- | Construct a t'GValueConstruct' with valid value for the “@id-column@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxIdColumn :: (IsComboBox o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructComboBoxIdColumn val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "id-column" val

#if defined(ENABLE_OVERLOADING)
data ComboBoxIdColumnPropertyInfo
instance AttrInfo ComboBoxIdColumnPropertyInfo where
    type AttrAllowedOps ComboBoxIdColumnPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxIdColumnPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxIdColumnPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ComboBoxIdColumnPropertyInfo = (~) Int32
    type AttrTransferType ComboBoxIdColumnPropertyInfo = Int32
    type AttrGetType ComboBoxIdColumnPropertyInfo = Int32
    type AttrLabel ComboBoxIdColumnPropertyInfo = "id-column"
    type AttrOrigin ComboBoxIdColumnPropertyInfo = ComboBox
    attrGet = getComboBoxIdColumn
    attrSet = setComboBoxIdColumn
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxIdColumn
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.idColumn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:idColumn"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gtk", name = "TreeModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #model
-- @
getComboBoxModel :: (MonadIO m, IsComboBox o) => o -> m (Maybe Gtk.TreeModel.TreeModel)
getComboBoxModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gtk.TreeModel.TreeModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxModel :: (MonadIO m, IsComboBox o, Gtk.TreeModel.IsTreeModel a) => o -> a -> m ()
setComboBoxModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxModel :: (IsComboBox o, MIO.MonadIO m, Gtk.TreeModel.IsTreeModel a) => a -> m (GValueConstruct o)
constructComboBoxModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearComboBoxModel :: (MonadIO m, IsComboBox o) => o -> m ()
clearComboBoxModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gtk.TreeModel.TreeModel)

#if defined(ENABLE_OVERLOADING)
data ComboBoxModelPropertyInfo
instance AttrInfo ComboBoxModelPropertyInfo where
    type AttrAllowedOps ComboBoxModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ComboBoxModelPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxModelPropertyInfo = Gtk.TreeModel.IsTreeModel
    type AttrTransferTypeConstraint ComboBoxModelPropertyInfo = Gtk.TreeModel.IsTreeModel
    type AttrTransferType ComboBoxModelPropertyInfo = Gtk.TreeModel.TreeModel
    type AttrGetType ComboBoxModelPropertyInfo = (Maybe Gtk.TreeModel.TreeModel)
    type AttrLabel ComboBoxModelPropertyInfo = "model"
    type AttrOrigin ComboBoxModelPropertyInfo = ComboBox
    attrGet = getComboBoxModel
    attrSet = setComboBoxModel
    attrTransfer _ v = do
        unsafeCastTo Gtk.TreeModel.TreeModel v
    attrConstruct = constructComboBoxModel
    attrClear = clearComboBoxModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:model"
        })
#endif

-- VVV Prop "popup-fixed-width"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@popup-fixed-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #popupFixedWidth
-- @
getComboBoxPopupFixedWidth :: (MonadIO m, IsComboBox o) => o -> m Bool
getComboBoxPopupFixedWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "popup-fixed-width"

-- | Set the value of the “@popup-fixed-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' comboBox [ #popupFixedWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setComboBoxPopupFixedWidth :: (MonadIO m, IsComboBox o) => o -> Bool -> m ()
setComboBoxPopupFixedWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "popup-fixed-width" val

-- | Construct a t'GValueConstruct' with valid value for the “@popup-fixed-width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructComboBoxPopupFixedWidth :: (IsComboBox o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructComboBoxPopupFixedWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "popup-fixed-width" val

#if defined(ENABLE_OVERLOADING)
data ComboBoxPopupFixedWidthPropertyInfo
instance AttrInfo ComboBoxPopupFixedWidthPropertyInfo where
    type AttrAllowedOps ComboBoxPopupFixedWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxPopupFixedWidthPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxPopupFixedWidthPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ComboBoxPopupFixedWidthPropertyInfo = (~) Bool
    type AttrTransferType ComboBoxPopupFixedWidthPropertyInfo = Bool
    type AttrGetType ComboBoxPopupFixedWidthPropertyInfo = Bool
    type AttrLabel ComboBoxPopupFixedWidthPropertyInfo = "popup-fixed-width"
    type AttrOrigin ComboBoxPopupFixedWidthPropertyInfo = ComboBox
    attrGet = getComboBoxPopupFixedWidth
    attrSet = setComboBoxPopupFixedWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructComboBoxPopupFixedWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.popupFixedWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:popupFixedWidth"
        })
#endif

-- VVV Prop "popup-shown"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@popup-shown@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' comboBox #popupShown
-- @
getComboBoxPopupShown :: (MonadIO m, IsComboBox o) => o -> m Bool
getComboBoxPopupShown obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "popup-shown"

#if defined(ENABLE_OVERLOADING)
data ComboBoxPopupShownPropertyInfo
instance AttrInfo ComboBoxPopupShownPropertyInfo where
    type AttrAllowedOps ComboBoxPopupShownPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ComboBoxPopupShownPropertyInfo = IsComboBox
    type AttrSetTypeConstraint ComboBoxPopupShownPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ComboBoxPopupShownPropertyInfo = (~) ()
    type AttrTransferType ComboBoxPopupShownPropertyInfo = ()
    type AttrGetType ComboBoxPopupShownPropertyInfo = Bool
    type AttrLabel ComboBoxPopupShownPropertyInfo = "popup-shown"
    type AttrOrigin ComboBoxPopupShownPropertyInfo = ComboBox
    attrGet = getComboBoxPopupShown
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.popupShown"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#g:attr:popupShown"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ComboBox
type instance O.AttributeList ComboBox = ComboBoxAttributeList
type ComboBoxAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("active", ComboBoxActivePropertyInfo), '("activeId", ComboBoxActiveIdPropertyInfo), '("buttonSensitivity", ComboBoxButtonSensitivityPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", ComboBoxChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("editingCanceled", Gtk.CellEditable.CellEditableEditingCanceledPropertyInfo), '("entryTextColumn", ComboBoxEntryTextColumnPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasEntry", ComboBoxHasEntryPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasFrame", ComboBoxHasFramePropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("idColumn", ComboBoxIdColumnPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("model", ComboBoxModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("popupFixedWidth", ComboBoxPopupFixedWidthPropertyInfo), '("popupShown", ComboBoxPopupShownPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
comboBoxActive :: AttrLabelProxy "active"
comboBoxActive = AttrLabelProxy

comboBoxActiveId :: AttrLabelProxy "activeId"
comboBoxActiveId = AttrLabelProxy

comboBoxButtonSensitivity :: AttrLabelProxy "buttonSensitivity"
comboBoxButtonSensitivity = AttrLabelProxy

comboBoxChild :: AttrLabelProxy "child"
comboBoxChild = AttrLabelProxy

comboBoxEntryTextColumn :: AttrLabelProxy "entryTextColumn"
comboBoxEntryTextColumn = AttrLabelProxy

comboBoxHasEntry :: AttrLabelProxy "hasEntry"
comboBoxHasEntry = AttrLabelProxy

comboBoxHasFrame :: AttrLabelProxy "hasFrame"
comboBoxHasFrame = AttrLabelProxy

comboBoxIdColumn :: AttrLabelProxy "idColumn"
comboBoxIdColumn = AttrLabelProxy

comboBoxModel :: AttrLabelProxy "model"
comboBoxModel = AttrLabelProxy

comboBoxPopupFixedWidth :: AttrLabelProxy "popupFixedWidth"
comboBoxPopupFixedWidth = AttrLabelProxy

comboBoxPopupShown :: AttrLabelProxy "popupShown"
comboBoxPopupShown = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ComboBox = ComboBoxSignalList
type ComboBoxSignalList = ('[ '("activate", ComboBoxActivateSignalInfo), '("changed", ComboBoxChangedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("editingDone", Gtk.CellEditable.CellEditableEditingDoneSignalInfo), '("formatEntryText", ComboBoxFormatEntryTextSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveActive", ComboBoxMoveActiveSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("popdown", ComboBoxPopdownSignalInfo), '("popup", ComboBoxPopupSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("removeWidget", Gtk.CellEditable.CellEditableRemoveWidgetSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ComboBox::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ComboBox" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_new" gtk_combo_box_new :: 
    IO (Ptr ComboBox)

{-# DEPRECATED comboBoxNew ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Creates a new empty @GtkComboBox@.
comboBoxNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ComboBox
    -- ^ __Returns:__ A new @GtkComboBox@
comboBoxNew  = liftIO $ do
    result <- gtk_combo_box_new
    checkUnexpectedReturnNULL "comboBoxNew" result
    result' <- (newObject ComboBox) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ComboBox::new_with_entry
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ComboBox" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_new_with_entry" gtk_combo_box_new_with_entry :: 
    IO (Ptr ComboBox)

{-# DEPRECATED comboBoxNewWithEntry ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Creates a new empty @GtkComboBox@ with an entry.
-- 
-- In order to use a combo box with entry, you need to tell it
-- which column of the model contains the text for the entry
-- by calling 'GI.Gtk.Objects.ComboBox.comboBoxSetEntryTextColumn'.
comboBoxNewWithEntry ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ComboBox
    -- ^ __Returns:__ A new @GtkComboBox@
comboBoxNewWithEntry  = liftIO $ do
    result <- gtk_combo_box_new_with_entry
    checkUnexpectedReturnNULL "comboBoxNewWithEntry" result
    result' <- (newObject ComboBox) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ComboBox::new_with_model
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ComboBox" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_new_with_model" gtk_combo_box_new_with_model :: 
    Ptr Gtk.TreeModel.TreeModel ->          -- model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    IO (Ptr ComboBox)

{-# DEPRECATED comboBoxNewWithModel ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Creates a new @GtkComboBox@ with a model.
comboBoxNewWithModel ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    a
    -- ^ /@model@/: a @GtkTreeModel@
    -> m ComboBox
    -- ^ __Returns:__ A new @GtkComboBox@
comboBoxNewWithModel model = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    result <- gtk_combo_box_new_with_model model'
    checkUnexpectedReturnNULL "comboBoxNewWithModel" result
    result' <- (newObject ComboBox) result
    touchManagedPtr model
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ComboBox::new_with_model_and_entry
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ComboBox" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_new_with_model_and_entry" gtk_combo_box_new_with_model_and_entry :: 
    Ptr Gtk.TreeModel.TreeModel ->          -- model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    IO (Ptr ComboBox)

{-# DEPRECATED comboBoxNewWithModelAndEntry ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Creates a new empty @GtkComboBox@ with an entry and a model.
-- 
-- See also 'GI.Gtk.Objects.ComboBox.comboBoxNewWithEntry'.
comboBoxNewWithModelAndEntry ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    a
    -- ^ /@model@/: A @GtkTreeModel@
    -> m ComboBox
    -- ^ __Returns:__ A new @GtkComboBox@
comboBoxNewWithModelAndEntry model = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    result <- gtk_combo_box_new_with_model_and_entry model'
    checkUnexpectedReturnNULL "comboBoxNewWithModelAndEntry" result
    result' <- (newObject ComboBox) result
    touchManagedPtr model
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ComboBox::get_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_active" gtk_combo_box_get_active :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO Int32

{-# DEPRECATED comboBoxGetActive ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns the index of the currently active item.
-- 
-- If the model is a non-flat treemodel, and the active item is not
-- an immediate child of the root of the tree, this function returns
-- @gtk_tree_path_get_indices (path)[0]@, where @path@ is the
-- t'GI.Gtk.Structs.TreePath.TreePath' of the active item.
comboBoxGetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> m Int32
    -- ^ __Returns:__ An integer which is the index of the currently active item,
    --   or -1 if there’s no active item
comboBoxGetActive comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_active comboBox'
    touchManagedPtr comboBox
    return result

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetActiveMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetActiveMethodInfo a signature where
    overloadedMethod = comboBoxGetActive

instance O.OverloadedMethodInfo ComboBoxGetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetActive"
        })


#endif

-- method ComboBox::get_active_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_active_id" gtk_combo_box_get_active_id :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO CString

{-# DEPRECATED comboBoxGetActiveId ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns the ID of the active row of /@comboBox@/.
-- 
-- This value is taken from the active row and the column specified
-- by the [ComboBox:idColumn]("GI.Gtk.Objects.ComboBox#g:attr:idColumn") property of /@comboBox@/
-- (see 'GI.Gtk.Objects.ComboBox.comboBoxSetIdColumn').
-- 
-- The returned value is an interned string which means that you can
-- compare the pointer by value to other interned strings and that you
-- must not free it.
-- 
-- If the [ComboBox:idColumn]("GI.Gtk.Objects.ComboBox#g:attr:idColumn") property of /@comboBox@/ is
-- not set, or if no row is active, or if the active row has a 'P.Nothing'
-- ID value, then 'P.Nothing' is returned.
comboBoxGetActiveId ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the ID of the active row
comboBoxGetActiveId comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_active_id comboBox'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr comboBox
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetActiveIdMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetActiveIdMethodInfo a signature where
    overloadedMethod = comboBoxGetActiveId

instance O.OverloadedMethodInfo ComboBoxGetActiveIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetActiveId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetActiveId"
        })


#endif

-- method ComboBox::get_active_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_active_iter" gtk_combo_box_get_active_iter :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Ptr Gtk.TreeIter.TreeIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TreeIter"})
    IO CInt

{-# DEPRECATED comboBoxGetActiveIter ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets /@iter@/ to point to the currently active item.
-- 
-- If no item is active, /@iter@/ is left unchanged.
comboBoxGetActiveIter ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> m ((Bool, Gtk.TreeIter.TreeIter))
    -- ^ __Returns:__ 'P.True' if /@iter@/ was set, 'P.False' otherwise
comboBoxGetActiveIter comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    iter <- SP.callocBoxedBytes 32 :: IO (Ptr Gtk.TreeIter.TreeIter)
    result <- gtk_combo_box_get_active_iter comboBox' iter
    let result' = (/= 0) result
    iter' <- (wrapBoxed Gtk.TreeIter.TreeIter) iter
    touchManagedPtr comboBox
    return (result', iter')

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetActiveIterMethodInfo
instance (signature ~ (m ((Bool, Gtk.TreeIter.TreeIter))), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetActiveIterMethodInfo a signature where
    overloadedMethod = comboBoxGetActiveIter

instance O.OverloadedMethodInfo ComboBoxGetActiveIterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetActiveIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetActiveIter"
        })


#endif

-- method ComboBox::get_button_sensitivity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SensitivityType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_button_sensitivity" gtk_combo_box_get_button_sensitivity :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO CUInt

{-# DEPRECATED comboBoxGetButtonSensitivity ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns whether the combo box sets the dropdown button
-- sensitive or not when there are no items in the model.
comboBoxGetButtonSensitivity ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> m Gtk.Enums.SensitivityType
    -- ^ __Returns:__ 'GI.Gtk.Enums.SensitivityTypeOn' if the dropdown button
    --   is sensitive when the model is empty, 'GI.Gtk.Enums.SensitivityTypeOff'
    --   if the button is always insensitive or 'GI.Gtk.Enums.SensitivityTypeAuto'
    --   if it is only sensitive as long as the model has one item to
    --   be selected.
comboBoxGetButtonSensitivity comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_button_sensitivity comboBox'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr comboBox
    return result'

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetButtonSensitivityMethodInfo
instance (signature ~ (m Gtk.Enums.SensitivityType), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetButtonSensitivityMethodInfo a signature where
    overloadedMethod = comboBoxGetButtonSensitivity

instance O.OverloadedMethodInfo ComboBoxGetButtonSensitivityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetButtonSensitivity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetButtonSensitivity"
        })


#endif

-- method ComboBox::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_child" gtk_combo_box_get_child :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO (Ptr Gtk.Widget.Widget)

{-# DEPRECATED comboBoxGetChild ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Gets the child widget of /@comboBox@/.
comboBoxGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@comboBox@/
comboBoxGetChild comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_child comboBox'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr comboBox
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetChildMethodInfo a signature where
    overloadedMethod = comboBoxGetChild

instance O.OverloadedMethodInfo ComboBoxGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetChild"
        })


#endif

-- method ComboBox::get_entry_text_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_entry_text_column" gtk_combo_box_get_entry_text_column :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO Int32

{-# DEPRECATED comboBoxGetEntryTextColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns the column which /@comboBox@/ is using to get the strings
-- from to display in the internal entry.
comboBoxGetEntryTextColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> m Int32
    -- ^ __Returns:__ A column in the data source model of /@comboBox@/.
comboBoxGetEntryTextColumn comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_entry_text_column comboBox'
    touchManagedPtr comboBox
    return result

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetEntryTextColumnMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetEntryTextColumnMethodInfo a signature where
    overloadedMethod = comboBoxGetEntryTextColumn

instance O.OverloadedMethodInfo ComboBoxGetEntryTextColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetEntryTextColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetEntryTextColumn"
        })


#endif

-- method ComboBox::get_has_entry
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_has_entry" gtk_combo_box_get_has_entry :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO CInt

{-# DEPRECATED comboBoxGetHasEntry ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns whether the combo box has an entry.
comboBoxGetHasEntry ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> m Bool
    -- ^ __Returns:__ whether there is an entry in /@comboBox@/.
comboBoxGetHasEntry comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_has_entry comboBox'
    let result' = (/= 0) result
    touchManagedPtr comboBox
    return result'

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetHasEntryMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetHasEntryMethodInfo a signature where
    overloadedMethod = comboBoxGetHasEntry

instance O.OverloadedMethodInfo ComboBoxGetHasEntryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetHasEntry",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetHasEntry"
        })


#endif

-- method ComboBox::get_id_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_id_column" gtk_combo_box_get_id_column :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO Int32

{-# DEPRECATED comboBoxGetIdColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns the column which /@comboBox@/ is using to get string IDs
-- for values from.
comboBoxGetIdColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> m Int32
    -- ^ __Returns:__ A column in the data source model of /@comboBox@/.
comboBoxGetIdColumn comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_id_column comboBox'
    touchManagedPtr comboBox
    return result

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetIdColumnMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetIdColumnMethodInfo a signature where
    overloadedMethod = comboBoxGetIdColumn

instance O.OverloadedMethodInfo ComboBoxGetIdColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetIdColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetIdColumn"
        })


#endif

-- method ComboBox::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TreeModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_model" gtk_combo_box_get_model :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO (Ptr Gtk.TreeModel.TreeModel)

{-# DEPRECATED comboBoxGetModel ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns the @GtkTreeModel@ of /@comboBox@/.
comboBoxGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> m (Maybe Gtk.TreeModel.TreeModel)
    -- ^ __Returns:__ A @GtkTreeModel@ which was passed
    --   during construction.
comboBoxGetModel comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_model comboBox'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.TreeModel.TreeModel) result'
        return result''
    touchManagedPtr comboBox
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetModelMethodInfo
instance (signature ~ (m (Maybe Gtk.TreeModel.TreeModel)), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetModelMethodInfo a signature where
    overloadedMethod = comboBoxGetModel

instance O.OverloadedMethodInfo ComboBoxGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetModel"
        })


#endif

-- method ComboBox::get_popup_fixed_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_get_popup_fixed_width" gtk_combo_box_get_popup_fixed_width :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO CInt

{-# DEPRECATED comboBoxGetPopupFixedWidth ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Gets whether the popup uses a fixed width.
comboBoxGetPopupFixedWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the popup uses a fixed width
comboBoxGetPopupFixedWidth comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_get_popup_fixed_width comboBox'
    let result' = (/= 0) result
    touchManagedPtr comboBox
    return result'

#if defined(ENABLE_OVERLOADING)
data ComboBoxGetPopupFixedWidthMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxGetPopupFixedWidthMethodInfo a signature where
    overloadedMethod = comboBoxGetPopupFixedWidth

instance O.OverloadedMethodInfo ComboBoxGetPopupFixedWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxGetPopupFixedWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxGetPopupFixedWidth"
        })


#endif

-- method ComboBox::popdown
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_popdown" gtk_combo_box_popdown :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO ()

{-# DEPRECATED comboBoxPopdown ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Hides the menu or dropdown list of /@comboBox@/.
-- 
-- This function is mostly intended for use by accessibility technologies;
-- applications should have little use for it.
comboBoxPopdown ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> m ()
comboBoxPopdown comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    gtk_combo_box_popdown comboBox'
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxPopdownMethodInfo
instance (signature ~ (m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxPopdownMethodInfo a signature where
    overloadedMethod = comboBoxPopdown

instance O.OverloadedMethodInfo ComboBoxPopdownMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxPopdown",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxPopdown"
        })


#endif

-- method ComboBox::popup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_popup" gtk_combo_box_popup :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    IO ()

{-# DEPRECATED comboBoxPopup ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Pops up the menu or dropdown list of /@comboBox@/.
-- 
-- This function is mostly intended for use by accessibility technologies;
-- applications should have little use for it.
-- 
-- Before calling this, /@comboBox@/ must be mapped, or nothing will happen.
comboBoxPopup ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> m ()
comboBoxPopup comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    gtk_combo_box_popup comboBox'
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxPopupMethodInfo
instance (signature ~ (m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxPopupMethodInfo a signature where
    overloadedMethod = comboBoxPopup

instance O.OverloadedMethodInfo ComboBoxPopupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxPopup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxPopup"
        })


#endif

-- method ComboBox::popup_for_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_popup_for_device" gtk_combo_box_popup_for_device :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO ()

{-# DEPRECATED comboBoxPopupForDevice ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Pops up the menu of /@comboBox@/.
-- 
-- Note that currently this does not do anything with the device, as it was
-- previously only used for list-mode combo boxes, and those were removed
-- in GTK 4. However, it is retained in case similar functionality is added
-- back later.
comboBoxPopupForDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> b
    -- ^ /@device@/: a @GdkDevice@
    -> m ()
comboBoxPopupForDevice comboBox device = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    device' <- unsafeManagedPtrCastPtr device
    gtk_combo_box_popup_for_device comboBox' device'
    touchManagedPtr comboBox
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxPopupForDeviceMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsComboBox a, Gdk.Device.IsDevice b) => O.OverloadedMethod ComboBoxPopupForDeviceMethodInfo a signature where
    overloadedMethod = comboBoxPopupForDevice

instance O.OverloadedMethodInfo ComboBoxPopupForDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxPopupForDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxPopupForDevice"
        })


#endif

-- method ComboBox::set_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An index in the model passed during construction,\n  or -1 to have no active item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_active" gtk_combo_box_set_active :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Int32 ->                                -- index_ : TBasicType TInt
    IO ()

{-# DEPRECATED comboBoxSetActive ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets the active item of /@comboBox@/ to be the item at /@index@/.
comboBoxSetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> Int32
    -- ^ /@index_@/: An index in the model passed during construction,
    --   or -1 to have no active item
    -> m ()
comboBoxSetActive comboBox index_ = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    gtk_combo_box_set_active comboBox' index_
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetActiveMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetActiveMethodInfo a signature where
    overloadedMethod = comboBoxSetActive

instance O.OverloadedMethodInfo ComboBoxSetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetActive"
        })


#endif

-- method ComboBox::set_active_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "active_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID of the row to select"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_active_id" gtk_combo_box_set_active_id :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    CString ->                              -- active_id : TBasicType TUTF8
    IO CInt

{-# DEPRECATED comboBoxSetActiveId ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Changes the active row of /@comboBox@/ to the one that has an ID equal to
-- /@activeId@/.
-- 
-- If /@activeId@/ is 'P.Nothing', the active row is unset. Rows having
-- a 'P.Nothing' ID string cannot be made active by this function.
-- 
-- If the [ComboBox:idColumn]("GI.Gtk.Objects.ComboBox#g:attr:idColumn") property of /@comboBox@/ is
-- unset or if no row has the given ID then the function does nothing
-- and returns 'P.False'.
comboBoxSetActiveId ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> Maybe (T.Text)
    -- ^ /@activeId@/: the ID of the row to select
    -> m Bool
    -- ^ __Returns:__ 'P.True' if a row with a matching ID was found. If a 'P.Nothing'
    --   /@activeId@/ was given to unset the active row, the function
    --   always returns 'P.True'.
comboBoxSetActiveId comboBox activeId = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeActiveId <- case activeId of
        Nothing -> return FP.nullPtr
        Just jActiveId -> do
            jActiveId' <- textToCString jActiveId
            return jActiveId'
    result <- gtk_combo_box_set_active_id comboBox' maybeActiveId
    let result' = (/= 0) result
    touchManagedPtr comboBox
    freeMem maybeActiveId
    return result'

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetActiveIdMethodInfo
instance (signature ~ (Maybe (T.Text) -> m Bool), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetActiveIdMethodInfo a signature where
    overloadedMethod = comboBoxSetActiveId

instance O.OverloadedMethodInfo ComboBoxSetActiveIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetActiveId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetActiveId"
        })


#endif

-- method ComboBox::set_active_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreeIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_active_iter" gtk_combo_box_set_active_iter :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Ptr Gtk.TreeIter.TreeIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TreeIter"})
    IO ()

{-# DEPRECATED comboBoxSetActiveIter ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets the current active item to be the one referenced by /@iter@/.
-- 
-- If /@iter@/ is 'P.Nothing', the active item is unset.
comboBoxSetActiveIter ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> Maybe (Gtk.TreeIter.TreeIter)
    -- ^ /@iter@/: The @GtkTreeIter@
    -> m ()
comboBoxSetActiveIter comboBox iter = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeIter <- case iter of
        Nothing -> return FP.nullPtr
        Just jIter -> do
            jIter' <- unsafeManagedPtrGetPtr jIter
            return jIter'
    gtk_combo_box_set_active_iter comboBox' maybeIter
    touchManagedPtr comboBox
    whenJust iter touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetActiveIterMethodInfo
instance (signature ~ (Maybe (Gtk.TreeIter.TreeIter) -> m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetActiveIterMethodInfo a signature where
    overloadedMethod = comboBoxSetActiveIter

instance O.OverloadedMethodInfo ComboBoxSetActiveIterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetActiveIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetActiveIter"
        })


#endif

-- method ComboBox::set_button_sensitivity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sensitivity"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SensitivityType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "specify the sensitivity of the dropdown button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_button_sensitivity" gtk_combo_box_set_button_sensitivity :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    CUInt ->                                -- sensitivity : TInterface (Name {namespace = "Gtk", name = "SensitivityType"})
    IO ()

{-# DEPRECATED comboBoxSetButtonSensitivity ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets whether the dropdown button of the combo box should update
-- its sensitivity depending on the model contents.
comboBoxSetButtonSensitivity ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> Gtk.Enums.SensitivityType
    -- ^ /@sensitivity@/: specify the sensitivity of the dropdown button
    -> m ()
comboBoxSetButtonSensitivity comboBox sensitivity = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    let sensitivity' = (fromIntegral . fromEnum) sensitivity
    gtk_combo_box_set_button_sensitivity comboBox' sensitivity'
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetButtonSensitivityMethodInfo
instance (signature ~ (Gtk.Enums.SensitivityType -> m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetButtonSensitivityMethodInfo a signature where
    overloadedMethod = comboBoxSetButtonSensitivity

instance O.OverloadedMethodInfo ComboBoxSetButtonSensitivityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetButtonSensitivity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetButtonSensitivity"
        })


#endif

-- method ComboBox::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_child" gtk_combo_box_set_child :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

{-# DEPRECATED comboBoxSetChild ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets the child widget of /@comboBox@/.
comboBoxSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
comboBoxSetChild comboBox child = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_combo_box_set_child comboBox' maybeChild
    touchManagedPtr comboBox
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsComboBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ComboBoxSetChildMethodInfo a signature where
    overloadedMethod = comboBoxSetChild

instance O.OverloadedMethodInfo ComboBoxSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetChild"
        })


#endif

-- method ComboBox::set_entry_text_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text_column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A column in @model to get the strings from for\n  the internal entry"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_entry_text_column" gtk_combo_box_set_entry_text_column :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Int32 ->                                -- text_column : TBasicType TInt
    IO ()

{-# DEPRECATED comboBoxSetEntryTextColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets the model column which /@comboBox@/ should use to get strings
-- from to be /@textColumn@/.
-- 
-- For this column no separate
-- t'GI.Gtk.Objects.CellRenderer.CellRenderer' is needed.
-- 
-- The column /@textColumn@/ in the model of /@comboBox@/ must be of
-- type @/G_TYPE_STRING/@.
-- 
-- This is only relevant if /@comboBox@/ has been created with
-- [ComboBox:hasEntry]("GI.Gtk.Objects.ComboBox#g:attr:hasEntry") as 'P.True'.
comboBoxSetEntryTextColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> Int32
    -- ^ /@textColumn@/: A column in /@model@/ to get the strings from for
    --   the internal entry
    -> m ()
comboBoxSetEntryTextColumn comboBox textColumn = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    gtk_combo_box_set_entry_text_column comboBox' textColumn
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetEntryTextColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetEntryTextColumnMethodInfo a signature where
    overloadedMethod = comboBoxSetEntryTextColumn

instance O.OverloadedMethodInfo ComboBoxSetEntryTextColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetEntryTextColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetEntryTextColumn"
        })


#endif

-- method ComboBox::set_id_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id_column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A column in @model to get string IDs for values from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_id_column" gtk_combo_box_set_id_column :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Int32 ->                                -- id_column : TBasicType TInt
    IO ()

{-# DEPRECATED comboBoxSetIdColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets the model column which /@comboBox@/ should use to get string IDs
-- for values from.
-- 
-- The column /@idColumn@/ in the model of /@comboBox@/ must be of type
-- @/G_TYPE_STRING/@.
comboBoxSetIdColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> Int32
    -- ^ /@idColumn@/: A column in /@model@/ to get string IDs for values from
    -> m ()
comboBoxSetIdColumn comboBox idColumn = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    gtk_combo_box_set_id_column comboBox' idColumn
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetIdColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetIdColumnMethodInfo a signature where
    overloadedMethod = comboBoxSetIdColumn

instance O.OverloadedMethodInfo ComboBoxSetIdColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetIdColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetIdColumn"
        })


#endif

-- method ComboBox::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_model" gtk_combo_box_set_model :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    Ptr Gtk.TreeModel.TreeModel ->          -- model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    IO ()

{-# DEPRECATED comboBoxSetModel ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets the model used by /@comboBox@/ to be /@model@/.
-- 
-- Will unset a previously set model (if applicable). If model is 'P.Nothing',
-- then it will unset the model.
-- 
-- Note that this function does not clear the cell renderers, you have to
-- call 'GI.Gtk.Interfaces.CellLayout.cellLayoutClear' yourself if you need to set up different
-- cell renderers for the new model.
comboBoxSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a, Gtk.TreeModel.IsTreeModel b) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> Maybe (b)
    -- ^ /@model@/: A @GtkTreeModel@
    -> m ()
comboBoxSetModel comboBox model = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_combo_box_set_model comboBox' maybeModel
    touchManagedPtr comboBox
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsComboBox a, Gtk.TreeModel.IsTreeModel b) => O.OverloadedMethod ComboBoxSetModelMethodInfo a signature where
    overloadedMethod = comboBoxSetModel

instance O.OverloadedMethodInfo ComboBoxSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetModel"
        })


#endif

-- method ComboBox::set_popup_fixed_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fixed"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to use a fixed popup width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_popup_fixed_width" gtk_combo_box_set_popup_fixed_width :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    CInt ->                                 -- fixed : TBasicType TBoolean
    IO ()

{-# DEPRECATED comboBoxSetPopupFixedWidth ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Specifies whether the popup’s width should be a fixed width.
-- 
-- If /@fixed@/ is 'P.True', the popup\'s width is set to match the
-- allocated width of the combo box.
comboBoxSetPopupFixedWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> Bool
    -- ^ /@fixed@/: whether to use a fixed popup width
    -> m ()
comboBoxSetPopupFixedWidth comboBox fixed = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    let fixed' = (P.fromIntegral . P.fromEnum) fixed
    gtk_combo_box_set_popup_fixed_width comboBox' fixed'
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetPopupFixedWidthMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetPopupFixedWidthMethodInfo a signature where
    overloadedMethod = comboBoxSetPopupFixedWidth

instance O.OverloadedMethodInfo ComboBoxSetPopupFixedWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetPopupFixedWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetPopupFixedWidth"
        })


#endif

-- method ComboBox::set_row_separator_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "TreeViewRowSeparatorFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeViewRowSeparatorFunc`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notifier for @data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_set_row_separator_func" gtk_combo_box_set_row_separator_func :: 
    Ptr ComboBox ->                         -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBox"})
    FunPtr Gtk.Callbacks.C_TreeViewRowSeparatorFunc -> -- func : TInterface (Name {namespace = "Gtk", name = "TreeViewRowSeparatorFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

{-# DEPRECATED comboBoxSetRowSeparatorFunc ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Sets the row separator function, which is used to determine
-- whether a row should be drawn as a separator.
-- 
-- If the row separator function is 'P.Nothing', no separators are drawn.
-- This is the default value.
comboBoxSetRowSeparatorFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBox a) =>
    a
    -- ^ /@comboBox@/: a @GtkComboBox@
    -> Maybe (Gtk.Callbacks.TreeViewRowSeparatorFunc)
    -- ^ /@func@/: a @GtkTreeViewRowSeparatorFunc@
    -> m ()
comboBoxSetRowSeparatorFunc comboBox func = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeFunc <- case func of
        Nothing -> return FP.nullFunPtr
        Just jFunc -> do
            jFunc' <- Gtk.Callbacks.mk_TreeViewRowSeparatorFunc (Gtk.Callbacks.wrap_TreeViewRowSeparatorFunc Nothing (Gtk.Callbacks.drop_closures_TreeViewRowSeparatorFunc jFunc))
            return jFunc'
    let data_ = castFunPtrToPtr maybeFunc
    let destroy = SP.safeFreeFunPtrPtr
    gtk_combo_box_set_row_separator_func comboBox' maybeFunc data_ destroy
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxSetRowSeparatorFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.TreeViewRowSeparatorFunc) -> m ()), MonadIO m, IsComboBox a) => O.OverloadedMethod ComboBoxSetRowSeparatorFuncMethodInfo a signature where
    overloadedMethod = comboBoxSetRowSeparatorFunc

instance O.OverloadedMethodInfo ComboBoxSetRowSeparatorFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBox.comboBoxSetRowSeparatorFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ComboBox.html#v:comboBoxSetRowSeparatorFunc"
        })


#endif


