{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure that provides information to the type system which is
-- used specifically for managing fundamental types.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.TypeFundamentalInfo
    ( 

-- * Exported types
    TypeFundamentalInfo(..)                 ,
    newZeroTypeFundamentalInfo              ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTypeFundamentalInfoMethod        ,
#endif



 -- * Properties


-- ** typeFlags #attr:typeFlags#
-- | t'GI.GObject.Flags.TypeFundamentalFlags' describing the characteristics of the fundamental type

    getTypeFundamentalInfoTypeFlags         ,
    setTypeFundamentalInfoTypeFlags         ,
#if defined(ENABLE_OVERLOADING)
    typeFundamentalInfo_typeFlags           ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags

#else
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags

#endif

-- | Memory-managed wrapper type.
newtype TypeFundamentalInfo = TypeFundamentalInfo (SP.ManagedPtr TypeFundamentalInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype TypeFundamentalInfo where
    toManagedPtr (TypeFundamentalInfo p) = p

instance BoxedPtr TypeFundamentalInfo where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 4 >=> B.ManagedPtr.wrapPtr TypeFundamentalInfo)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TypeFundamentalInfo where
    boxedPtrCalloc = callocBytes 4


-- | Construct a t'TypeFundamentalInfo' struct initialized to zero.
newZeroTypeFundamentalInfo :: MonadIO m => m TypeFundamentalInfo
newZeroTypeFundamentalInfo = liftIO $ boxedPtrCalloc >>= wrapPtr TypeFundamentalInfo

instance tag ~ 'AttrSet => Constructible TypeFundamentalInfo tag where
    new _ attrs = do
        o <- newZeroTypeFundamentalInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' typeFundamentalInfo #typeFlags
-- @
getTypeFundamentalInfoTypeFlags :: MonadIO m => TypeFundamentalInfo -> m [GObject.Flags.TypeFundamentalFlags]
getTypeFundamentalInfoTypeFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@type_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' typeFundamentalInfo [ #typeFlags 'Data.GI.Base.Attributes.:=' value ]
-- @
setTypeFundamentalInfoTypeFlags :: MonadIO m => TypeFundamentalInfo -> [GObject.Flags.TypeFundamentalFlags] -> m ()
setTypeFundamentalInfoTypeFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 0) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data TypeFundamentalInfoTypeFlagsFieldInfo
instance AttrInfo TypeFundamentalInfoTypeFlagsFieldInfo where
    type AttrBaseTypeConstraint TypeFundamentalInfoTypeFlagsFieldInfo = (~) TypeFundamentalInfo
    type AttrAllowedOps TypeFundamentalInfoTypeFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TypeFundamentalInfoTypeFlagsFieldInfo = (~) [GObject.Flags.TypeFundamentalFlags]
    type AttrTransferTypeConstraint TypeFundamentalInfoTypeFlagsFieldInfo = (~)[GObject.Flags.TypeFundamentalFlags]
    type AttrTransferType TypeFundamentalInfoTypeFlagsFieldInfo = [GObject.Flags.TypeFundamentalFlags]
    type AttrGetType TypeFundamentalInfoTypeFlagsFieldInfo = [GObject.Flags.TypeFundamentalFlags]
    type AttrLabel TypeFundamentalInfoTypeFlagsFieldInfo = "type_flags"
    type AttrOrigin TypeFundamentalInfoTypeFlagsFieldInfo = TypeFundamentalInfo
    attrGet = getTypeFundamentalInfoTypeFlags
    attrSet = setTypeFundamentalInfoTypeFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeFundamentalInfo.typeFlags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-TypeFundamentalInfo.html#g:attr:typeFlags"
        })

typeFundamentalInfo_typeFlags :: AttrLabelProxy "typeFlags"
typeFundamentalInfo_typeFlags = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TypeFundamentalInfo
type instance O.AttributeList TypeFundamentalInfo = TypeFundamentalInfoAttributeList
type TypeFundamentalInfoAttributeList = ('[ '("typeFlags", TypeFundamentalInfoTypeFlagsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTypeFundamentalInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTypeFundamentalInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTypeFundamentalInfoMethod t TypeFundamentalInfo, O.OverloadedMethod info TypeFundamentalInfo p) => OL.IsLabel t (TypeFundamentalInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTypeFundamentalInfoMethod t TypeFundamentalInfo, O.OverloadedMethod info TypeFundamentalInfo p, R.HasField t TypeFundamentalInfo p) => R.HasField t TypeFundamentalInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTypeFundamentalInfoMethod t TypeFundamentalInfo, O.OverloadedMethodInfo info TypeFundamentalInfo) => OL.IsLabel t (O.MethodProxy info TypeFundamentalInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


