{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GSource@ struct is an opaque data type
-- representing an event source.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Source
    ( 

-- * Exported types
    Source(..)                              ,
    newZeroSource                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addChildSource]("GI.GLib.Structs.Source#g:method:addChildSource"), [addPoll]("GI.GLib.Structs.Source#g:method:addPoll"), [addUnixFd]("GI.GLib.Structs.Source#g:method:addUnixFd"), [attach]("GI.GLib.Structs.Source#g:method:attach"), [destroy]("GI.GLib.Structs.Source#g:method:destroy"), [dupContext]("GI.GLib.Structs.Source#g:method:dupContext"), [isDestroyed]("GI.GLib.Structs.Source#g:method:isDestroyed"), [modifyUnixFd]("GI.GLib.Structs.Source#g:method:modifyUnixFd"), [queryUnixFd]("GI.GLib.Structs.Source#g:method:queryUnixFd"), [ref]("GI.GLib.Structs.Source#g:method:ref"), [removeChildSource]("GI.GLib.Structs.Source#g:method:removeChildSource"), [removePoll]("GI.GLib.Structs.Source#g:method:removePoll"), [removeUnixFd]("GI.GLib.Structs.Source#g:method:removeUnixFd"), [unref]("GI.GLib.Structs.Source#g:method:unref").
-- 
-- ==== Getters
-- [getCanRecurse]("GI.GLib.Structs.Source#g:method:getCanRecurse"), [getContext]("GI.GLib.Structs.Source#g:method:getContext"), [getCurrentTime]("GI.GLib.Structs.Source#g:method:getCurrentTime"), [getId]("GI.GLib.Structs.Source#g:method:getId"), [getName]("GI.GLib.Structs.Source#g:method:getName"), [getPriority]("GI.GLib.Structs.Source#g:method:getPriority"), [getReadyTime]("GI.GLib.Structs.Source#g:method:getReadyTime"), [getTime]("GI.GLib.Structs.Source#g:method:getTime").
-- 
-- ==== Setters
-- [setCallback]("GI.GLib.Structs.Source#g:method:setCallback"), [setCallbackIndirect]("GI.GLib.Structs.Source#g:method:setCallbackIndirect"), [setCanRecurse]("GI.GLib.Structs.Source#g:method:setCanRecurse"), [setFuncs]("GI.GLib.Structs.Source#g:method:setFuncs"), [setName]("GI.GLib.Structs.Source#g:method:setName"), [setPriority]("GI.GLib.Structs.Source#g:method:setPriority"), [setReadyTime]("GI.GLib.Structs.Source#g:method:setReadyTime"), [setStaticName]("GI.GLib.Structs.Source#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveSourceMethod                     ,
#endif

-- ** addChildSource #method:addChildSource#

#if defined(ENABLE_OVERLOADING)
    SourceAddChildSourceMethodInfo          ,
#endif
    sourceAddChildSource                    ,


-- ** addPoll #method:addPoll#

#if defined(ENABLE_OVERLOADING)
    SourceAddPollMethodInfo                 ,
#endif
    sourceAddPoll                           ,


-- ** addUnixFd #method:addUnixFd#

#if defined(ENABLE_OVERLOADING)
    SourceAddUnixFdMethodInfo               ,
#endif
    sourceAddUnixFd                         ,


-- ** attach #method:attach#

#if defined(ENABLE_OVERLOADING)
    SourceAttachMethodInfo                  ,
#endif
    sourceAttach                            ,


-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    SourceDestroyMethodInfo                 ,
#endif
    sourceDestroy                           ,


-- ** dupContext #method:dupContext#

#if defined(ENABLE_OVERLOADING)
    SourceDupContextMethodInfo              ,
#endif
    sourceDupContext                        ,


-- ** getCanRecurse #method:getCanRecurse#

#if defined(ENABLE_OVERLOADING)
    SourceGetCanRecurseMethodInfo           ,
#endif
    sourceGetCanRecurse                     ,


-- ** getContext #method:getContext#

#if defined(ENABLE_OVERLOADING)
    SourceGetContextMethodInfo              ,
#endif
    sourceGetContext                        ,


-- ** getCurrentTime #method:getCurrentTime#

#if defined(ENABLE_OVERLOADING)
    SourceGetCurrentTimeMethodInfo          ,
#endif
    sourceGetCurrentTime                    ,


-- ** getId #method:getId#

#if defined(ENABLE_OVERLOADING)
    SourceGetIdMethodInfo                   ,
#endif
    sourceGetId                             ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    SourceGetNameMethodInfo                 ,
#endif
    sourceGetName                           ,


-- ** getPriority #method:getPriority#

#if defined(ENABLE_OVERLOADING)
    SourceGetPriorityMethodInfo             ,
#endif
    sourceGetPriority                       ,


-- ** getReadyTime #method:getReadyTime#

#if defined(ENABLE_OVERLOADING)
    SourceGetReadyTimeMethodInfo            ,
#endif
    sourceGetReadyTime                      ,


-- ** getTime #method:getTime#

#if defined(ENABLE_OVERLOADING)
    SourceGetTimeMethodInfo                 ,
#endif
    sourceGetTime                           ,


-- ** isDestroyed #method:isDestroyed#

#if defined(ENABLE_OVERLOADING)
    SourceIsDestroyedMethodInfo             ,
#endif
    sourceIsDestroyed                       ,


-- ** modifyUnixFd #method:modifyUnixFd#

#if defined(ENABLE_OVERLOADING)
    SourceModifyUnixFdMethodInfo            ,
#endif
    sourceModifyUnixFd                      ,


-- ** new #method:new#

    sourceNew                               ,


-- ** queryUnixFd #method:queryUnixFd#

#if defined(ENABLE_OVERLOADING)
    SourceQueryUnixFdMethodInfo             ,
#endif
    sourceQueryUnixFd                       ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    SourceRefMethodInfo                     ,
#endif
    sourceRef                               ,


-- ** remove #method:remove#

    sourceRemove                            ,


-- ** removeByFuncsUserData #method:removeByFuncsUserData#

    sourceRemoveByFuncsUserData             ,


-- ** removeByUserData #method:removeByUserData#

    sourceRemoveByUserData                  ,


-- ** removeChildSource #method:removeChildSource#

#if defined(ENABLE_OVERLOADING)
    SourceRemoveChildSourceMethodInfo       ,
#endif
    sourceRemoveChildSource                 ,


-- ** removePoll #method:removePoll#

#if defined(ENABLE_OVERLOADING)
    SourceRemovePollMethodInfo              ,
#endif
    sourceRemovePoll                        ,


-- ** removeUnixFd #method:removeUnixFd#

#if defined(ENABLE_OVERLOADING)
    SourceRemoveUnixFdMethodInfo            ,
#endif
    sourceRemoveUnixFd                      ,


-- ** setCallback #method:setCallback#

#if defined(ENABLE_OVERLOADING)
    SourceSetCallbackMethodInfo             ,
#endif
    sourceSetCallback                       ,


-- ** setCallbackIndirect #method:setCallbackIndirect#

#if defined(ENABLE_OVERLOADING)
    SourceSetCallbackIndirectMethodInfo     ,
#endif
    sourceSetCallbackIndirect               ,


-- ** setCanRecurse #method:setCanRecurse#

#if defined(ENABLE_OVERLOADING)
    SourceSetCanRecurseMethodInfo           ,
#endif
    sourceSetCanRecurse                     ,


-- ** setFuncs #method:setFuncs#

#if defined(ENABLE_OVERLOADING)
    SourceSetFuncsMethodInfo                ,
#endif
    sourceSetFuncs                          ,


-- ** setName #method:setName#

#if defined(ENABLE_OVERLOADING)
    SourceSetNameMethodInfo                 ,
#endif
    sourceSetName                           ,


-- ** setNameById #method:setNameById#

    sourceSetNameById                       ,


-- ** setPriority #method:setPriority#

#if defined(ENABLE_OVERLOADING)
    SourceSetPriorityMethodInfo             ,
#endif
    sourceSetPriority                       ,


-- ** setReadyTime #method:setReadyTime#

#if defined(ENABLE_OVERLOADING)
    SourceSetReadyTimeMethodInfo            ,
#endif
    sourceSetReadyTime                      ,


-- ** setStaticName #method:setStaticName#

#if defined(ENABLE_OVERLOADING)
    SourceSetStaticNameMethodInfo           ,
#endif
    sourceSetStaticName                     ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    SourceUnrefMethodInfo                   ,
#endif
    sourceUnref                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Cond as GLib.Cond
import {-# SOURCE #-} qualified GI.GLib.Structs.MainContext as GLib.MainContext
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceCallbackFuncs as GLib.SourceCallbackFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceFuncs as GLib.SourceFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import {-# SOURCE #-} qualified GI.GLib.Unions.Mutex as GLib.Mutex

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.MainContext as GLib.MainContext
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceCallbackFuncs as GLib.SourceCallbackFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceFuncs as GLib.SourceFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal

#endif

-- | Memory-managed wrapper type.
newtype Source = Source (SP.ManagedPtr Source)
    deriving (Eq)

instance SP.ManagedPtrNewtype Source where
    toManagedPtr (Source p) = p

foreign import ccall "g_source_get_type" c_g_source_get_type :: 
    IO GType

type instance O.ParentTypes Source = '[]
instance O.HasParentTypes Source

instance B.Types.TypedObject Source where
    glibType = c_g_source_get_type

instance B.Types.GBoxed Source

-- | Convert t'Source' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Source) where
    gvalueGType_ = c_g_source_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Source)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Source)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Source ptr
        else return P.Nothing
        
    

-- | Construct a t'Source' struct initialized to zero.
newZeroSource :: MonadIO m => m Source
newZeroSource = liftIO $ callocBoxedBytes 96 >>= wrapBoxed Source

instance tag ~ 'AttrSet => Constructible Source tag where
    new _ attrs = do
        o <- newZeroSource
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Source
type instance O.AttributeList Source = SourceAttributeList
type SourceAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Source::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "source_funcs"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFuncs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "structure containing functions that implement\n  the source\8216s behavior"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "struct_size"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "size of the [struct@GLib.Source] structure to create, in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_source_new" g_source_new :: 
    Ptr GLib.SourceFuncs.SourceFuncs ->     -- source_funcs : TInterface (Name {namespace = "GLib", name = "SourceFuncs"})
    Word32 ->                               -- struct_size : TBasicType TUInt
    IO (Ptr Source)

-- | Creates a new t'GI.GLib.Structs.Source.Source' structure.
-- 
-- The size is specified to
-- allow creating structures derived from t'GI.GLib.Structs.Source.Source' that contain
-- additional data. The size passed in must be at least
-- @sizeof (GSource)@.
-- 
-- The source will not initially be associated with any t'GI.GLib.Structs.MainContext.MainContext'
-- and must be added to one with 'GI.GLib.Structs.Source.sourceAttach' before it will be
-- executed.
sourceNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SourceFuncs.SourceFuncs
    -- ^ /@sourceFuncs@/: structure containing functions that implement
    --   the source‘s behavior
    -> Word32
    -- ^ /@structSize@/: size of the t'GI.GLib.Structs.Source.Source' structure to create, in bytes
    -> m Source
    -- ^ __Returns:__ the newly-created source
sourceNew sourceFuncs structSize = liftIO $ do
    sourceFuncs' <- unsafeManagedPtrGetPtr sourceFuncs
    result <- g_source_new sourceFuncs' structSize
    checkUnexpectedReturnNULL "sourceNew" result
    result' <- (wrapBoxed Source) result
    touchManagedPtr sourceFuncs
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Source::add_child_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a second source that @source should \8216poll\8217"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_add_child_source" g_source_add_child_source :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr Source ->                           -- child_source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO ()

-- | Adds /@childSource@/ to /@source@/ as a ‘polled’ source.
-- 
-- When /@source@/ is added to a t'GI.GLib.Structs.MainContext.MainContext', /@childSource@/ will be
-- automatically added with the same priority. When /@childSource@/ is triggered,
-- it will cause /@source@/ to dispatch (in addition to calling its own callback),
-- and when /@source@/ is destroyed, it will destroy /@childSource@/ as well.
-- 
-- The /@source@/ will also still be dispatched if its own prepare\/check functions
-- indicate that it is ready.
-- 
-- If you don’t need /@childSource@/ to do anything on its own when it
-- triggers, you can call @g_source_set_dummy_callback()@ on it to set a
-- callback that does nothing (except return true if appropriate).
-- 
-- The /@source@/ will hold a reference on /@childSource@/ while /@childSource@/
-- is attached to it.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- /Since: 2.28/
sourceAddChildSource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Source
    -- ^ /@childSource@/: a second source that /@source@/ should ‘poll’
    -> m ()
sourceAddChildSource source childSource = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    childSource' <- unsafeManagedPtrGetPtr childSource
    g_source_add_child_source source' childSource'
    touchManagedPtr source
    touchManagedPtr childSource
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceAddChildSourceMethodInfo
instance (signature ~ (Source -> m ()), MonadIO m) => O.OverloadedMethod SourceAddChildSourceMethodInfo Source signature where
    overloadedMethod = sourceAddChildSource

instance O.OverloadedMethodInfo SourceAddChildSourceMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceAddChildSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceAddChildSource"
        })


#endif

-- method Source::add_poll
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "PollFD" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [struct@GLib.PollFD] structure holding information about a file\n  descriptor to watch"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_add_poll" g_source_add_poll :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr GLib.PollFD.PollFD ->               -- fd : TInterface (Name {namespace = "GLib", name = "PollFD"})
    IO ()

-- | Adds a file descriptor to the set of file descriptors polled for
-- this source.
-- 
-- This is usually combined with 'GI.GLib.Structs.Source.sourceNew' to add an
-- event source. The event source’s check function will typically test
-- the /@revents@/ field in the t'GI.GLib.Structs.PollFD.PollFD' struct and return true if
-- events need to be processed.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- Using this API forces the linear scanning of event sources on each
-- main loop iteration.  Newly-written event sources should try to use
-- @g_source_add_unix_fd()@ instead of this API.
sourceAddPoll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> GLib.PollFD.PollFD
    -- ^ /@fd@/: a t'GI.GLib.Structs.PollFD.PollFD' structure holding information about a file
    --   descriptor to watch
    -> m ()
sourceAddPoll source fd = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    fd' <- unsafeManagedPtrGetPtr fd
    g_source_add_poll source' fd'
    touchManagedPtr source
    touchManagedPtr fd
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceAddPollMethodInfo
instance (signature ~ (GLib.PollFD.PollFD -> m ()), MonadIO m) => O.OverloadedMethod SourceAddPollMethodInfo Source signature where
    overloadedMethod = sourceAddPoll

instance O.OverloadedMethodInfo SourceAddPollMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceAddPoll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceAddPoll"
        })


#endif

-- method Source::add_unix_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the file descriptor to monitor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "events"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an event mask" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_add_unix_fd" g_source_add_unix_fd :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Int32 ->                                -- fd : TBasicType TInt
    CUInt ->                                -- events : TInterface (Name {namespace = "GLib", name = "IOCondition"})
    IO (Ptr ())

-- | Monitors /@fd@/ for the IO events in /@events@/.
-- 
-- The tag returned by this function can be used to remove or modify the
-- monitoring of the /@fd@/ using 'GI.GLib.Structs.Source.sourceRemoveUnixFd' or
-- 'GI.GLib.Structs.Source.sourceModifyUnixFd'.
-- 
-- It is not necessary to remove the file descriptor before destroying the
-- source; it will be cleaned up automatically.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- As the name suggests, this function is not available on Windows.
-- 
-- /Since: 2.36/
sourceAddUnixFd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Int32
    -- ^ /@fd@/: the file descriptor to monitor
    -> [GLib.Flags.IOCondition]
    -- ^ /@events@/: an event mask
    -> m (Ptr ())
    -- ^ __Returns:__ an opaque tag
sourceAddUnixFd source fd events = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    let events' = gflagsToWord events
    result <- g_source_add_unix_fd source' fd events'
    touchManagedPtr source
    return result

#if defined(ENABLE_OVERLOADING)
data SourceAddUnixFdMethodInfo
instance (signature ~ (Int32 -> [GLib.Flags.IOCondition] -> m (Ptr ())), MonadIO m) => O.OverloadedMethod SourceAddUnixFdMethodInfo Source signature where
    overloadedMethod = sourceAddUnixFd

instance O.OverloadedMethodInfo SourceAddUnixFdMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceAddUnixFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceAddUnixFd"
        })


#endif

-- method Source::attach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a main context (if `NULL`, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_attach" g_source_attach :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr GLib.MainContext.MainContext ->     -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO Word32

-- | Adds a t'GI.GLib.Structs.Source.Source' to a /@context@/ so that it will be executed within
-- that context.
-- 
-- Remove it by calling 'GI.GLib.Structs.Source.sourceDestroy'.
-- 
-- This function is safe to call from any thread, regardless of which thread
-- the /@context@/ is running in.
sourceAttach ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Maybe (GLib.MainContext.MainContext)
    -- ^ /@context@/: a main context (if @NULL@, the global-default
    --   main context will be used)
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) for the source within the
    --   t'GI.GLib.Structs.MainContext.MainContext'
sourceAttach source context = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    result <- g_source_attach source' maybeContext
    touchManagedPtr source
    whenJust context touchManagedPtr
    return result

#if defined(ENABLE_OVERLOADING)
data SourceAttachMethodInfo
instance (signature ~ (Maybe (GLib.MainContext.MainContext) -> m Word32), MonadIO m) => O.OverloadedMethod SourceAttachMethodInfo Source signature where
    overloadedMethod = sourceAttach

instance O.OverloadedMethodInfo SourceAttachMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceAttach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceAttach"
        })


#endif

-- method Source::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_destroy" g_source_destroy :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO ()

-- | Removes a source from its t'GI.GLib.Structs.MainContext.MainContext', if any, and marks it as
-- destroyed.
-- 
-- The source cannot be subsequently added to another
-- context. It is safe to call this on sources which have already been
-- removed from their context.
-- 
-- This does not unref the t'GI.GLib.Structs.Source.Source': if you still hold a reference,
-- use 'GI.GLib.Structs.Source.sourceUnref' to drop it.
-- 
-- This function is safe to call from any thread, regardless of which thread
-- the t'GI.GLib.Structs.MainContext.MainContext' is running in.
-- 
-- If the source is currently attached to a t'GI.GLib.Structs.MainContext.MainContext',
-- destroying it will effectively unset the callback similar to calling
-- 'GI.GLib.Structs.Source.sourceSetCallback'. This can mean, that the data’s
-- [callback/@gLib@/.DestroyNotify] gets called right away.
sourceDestroy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m ()
sourceDestroy source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    g_source_destroy source'
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod SourceDestroyMethodInfo Source signature where
    overloadedMethod = sourceDestroy

instance O.OverloadedMethodInfo SourceDestroyMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceDestroy"
        })


#endif

-- method Source::dup_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_source_dup_context" g_source_dup_context :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO (Ptr GLib.MainContext.MainContext)

-- | Gets a reference to the t'GI.GLib.Structs.MainContext.MainContext' with which the source is
-- associated.
-- 
-- You can call this on a source that has been destroyed. You can
-- always call this function on the source returned from
-- 'GI.GLib.Functions.mainCurrentSource'.
-- 
-- /Since: 2.86/
sourceDupContext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m (Maybe GLib.MainContext.MainContext)
    -- ^ __Returns:__ the t'GI.GLib.Structs.MainContext.MainContext' with which
    --   the source is associated, or @NULL@ if the context has not yet been added
    --   to a source
sourceDupContext source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_dup_context source'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed GLib.MainContext.MainContext) result'
        return result''
    touchManagedPtr source
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SourceDupContextMethodInfo
instance (signature ~ (m (Maybe GLib.MainContext.MainContext)), MonadIO m) => O.OverloadedMethod SourceDupContextMethodInfo Source signature where
    overloadedMethod = sourceDupContext

instance O.OverloadedMethodInfo SourceDupContextMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceDupContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceDupContext"
        })


#endif

-- method Source::get_can_recurse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_can_recurse" g_source_get_can_recurse :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO CInt

-- | Checks whether a source is allowed to be called recursively.
-- 
-- See 'GI.GLib.Structs.Source.sourceSetCanRecurse'.
sourceGetCanRecurse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m Bool
    -- ^ __Returns:__ whether recursion is allowed
sourceGetCanRecurse source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_get_can_recurse source'
    let result' = (/= 0) result
    touchManagedPtr source
    return result'

#if defined(ENABLE_OVERLOADING)
data SourceGetCanRecurseMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod SourceGetCanRecurseMethodInfo Source signature where
    overloadedMethod = sourceGetCanRecurse

instance O.OverloadedMethodInfo SourceGetCanRecurseMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetCanRecurse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetCanRecurse"
        })


#endif

-- method Source::get_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_context" g_source_get_context :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO (Ptr GLib.MainContext.MainContext)

-- | Gets the t'GI.GLib.Structs.MainContext.MainContext' with which the source is associated.
-- 
-- You can call this on a source that has been destroyed, provided
-- that the t'GI.GLib.Structs.MainContext.MainContext' it was attached to still exists (in which
-- case it will return that t'GI.GLib.Structs.MainContext.MainContext'). In particular, you can
-- always call this function on the source returned from
-- 'GI.GLib.Functions.mainCurrentSource'. But calling this function on a source
-- whose t'GI.GLib.Structs.MainContext.MainContext' has been destroyed is an error.
-- 
-- If the associated t'GI.GLib.Structs.MainContext.MainContext' could be destroy concurrently from
-- a different thread, then this function is not safe to call and
-- 'GI.GLib.Structs.Source.sourceDupContext' should be used instead.
sourceGetContext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m (Maybe GLib.MainContext.MainContext)
    -- ^ __Returns:__ the main context with which the
    --   source is associated, or @NULL@ if the context has not yet been added to a
    --   source
sourceGetContext source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_get_context source'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed GLib.MainContext.MainContext) result'
        return result''
    touchManagedPtr source
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SourceGetContextMethodInfo
instance (signature ~ (m (Maybe GLib.MainContext.MainContext)), MonadIO m) => O.OverloadedMethod SourceGetContextMethodInfo Source signature where
    overloadedMethod = sourceGetContext

instance O.OverloadedMethodInfo SourceGetContextMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetContext"
        })


#endif

-- method Source::get_current_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeval"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TimeVal" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "[struct@GLib.TimeVal] structure in which to store current time"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_current_time" g_source_get_current_time :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr GLib.TimeVal.TimeVal ->             -- timeval : TInterface (Name {namespace = "GLib", name = "TimeVal"})
    IO ()

{-# DEPRECATED sourceGetCurrentTime ["(Since version 2.28)","use 'GI.GLib.Structs.Source.sourceGetTime' instead"] #-}
-- | This function ignores /@source@/ and is otherwise the same as
-- 'GI.GLib.Functions.getCurrentTime'.
sourceGetCurrentTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> GLib.TimeVal.TimeVal
    -- ^ /@timeval@/: t'GI.GLib.Structs.TimeVal.TimeVal' structure in which to store current time
    -> m ()
sourceGetCurrentTime source timeval = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    timeval' <- unsafeManagedPtrGetPtr timeval
    g_source_get_current_time source' timeval'
    touchManagedPtr source
    touchManagedPtr timeval
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceGetCurrentTimeMethodInfo
instance (signature ~ (GLib.TimeVal.TimeVal -> m ()), MonadIO m) => O.OverloadedMethod SourceGetCurrentTimeMethodInfo Source signature where
    overloadedMethod = sourceGetCurrentTime

instance O.OverloadedMethodInfo SourceGetCurrentTimeMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetCurrentTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetCurrentTime"
        })


#endif

-- method Source::get_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_id" g_source_get_id :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO Word32

-- | Returns the numeric ID for a particular source.
-- 
-- The ID of a source
-- is a positive integer which is unique within a particular main loop
-- context. The reverse mapping from ID to source is done by
-- 'GI.GLib.Structs.MainContext.mainContextFindSourceById'.
-- 
-- You can only call this function while the source is associated to a
-- t'GI.GLib.Structs.MainContext.MainContext' instance; calling this function before
-- 'GI.GLib.Structs.Source.sourceAttach' or after 'GI.GLib.Structs.Source.sourceDestroy' yields
-- undefined behavior. The ID returned is unique within the
-- t'GI.GLib.Structs.MainContext.MainContext' instance passed to 'GI.GLib.Structs.Source.sourceAttach'.
sourceGetId ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) for the source
sourceGetId source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_get_id source'
    touchManagedPtr source
    return result

#if defined(ENABLE_OVERLOADING)
data SourceGetIdMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod SourceGetIdMethodInfo Source signature where
    overloadedMethod = sourceGetId

instance O.OverloadedMethodInfo SourceGetIdMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetId"
        })


#endif

-- method Source::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_name" g_source_get_name :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO CString

-- | Gets a name for the source, used in debugging and profiling.
-- 
-- The
-- name may be @NULL@ if it has never been set with 'GI.GLib.Structs.Source.sourceSetName'.
-- 
-- /Since: 2.26/
sourceGetName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the name of the source
sourceGetName source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_get_name source'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr source
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SourceGetNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod SourceGetNameMethodInfo Source signature where
    overloadedMethod = sourceGetName

instance O.OverloadedMethodInfo SourceGetNameMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetName"
        })


#endif

-- method Source::get_priority
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_priority" g_source_get_priority :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO Int32

-- | Gets the priority of a source.
sourceGetPriority ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m Int32
    -- ^ __Returns:__ the priority of the source
sourceGetPriority source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_get_priority source'
    touchManagedPtr source
    return result

#if defined(ENABLE_OVERLOADING)
data SourceGetPriorityMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod SourceGetPriorityMethodInfo Source signature where
    overloadedMethod = sourceGetPriority

instance O.OverloadedMethodInfo SourceGetPriorityMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetPriority",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetPriority"
        })


#endif

-- method Source::get_ready_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_ready_time" g_source_get_ready_time :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO Int64

-- | Gets the ‘ready time’ of /@source@/, as set by
-- 'GI.GLib.Structs.Source.sourceSetReadyTime'.
-- 
-- Any time before or equal to the current monotonic time (including zero)
-- is an indication that the source will fire immediately.
sourceGetReadyTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m Int64
    -- ^ __Returns:__ the monotonic ready time, @-1@ for ‘never’
sourceGetReadyTime source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_get_ready_time source'
    touchManagedPtr source
    return result

#if defined(ENABLE_OVERLOADING)
data SourceGetReadyTimeMethodInfo
instance (signature ~ (m Int64), MonadIO m) => O.OverloadedMethod SourceGetReadyTimeMethodInfo Source signature where
    overloadedMethod = sourceGetReadyTime

instance O.OverloadedMethodInfo SourceGetReadyTimeMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetReadyTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetReadyTime"
        })


#endif

-- method Source::get_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_get_time" g_source_get_time :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO Int64

-- | Gets the time to be used when checking this source.
-- 
-- The advantage of
-- calling this function over calling 'GI.GLib.Functions.getMonotonicTime' directly is
-- that when checking multiple sources, GLib can cache a single value
-- instead of having to repeatedly get the system monotonic time.
-- 
-- The time here is the system monotonic time, if available, or some
-- other reasonable alternative otherwise.  See 'GI.GLib.Functions.getMonotonicTime'.
-- 
-- /Since: 2.28/
sourceGetTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m Int64
    -- ^ __Returns:__ the monotonic time in microseconds
sourceGetTime source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_get_time source'
    touchManagedPtr source
    return result

#if defined(ENABLE_OVERLOADING)
data SourceGetTimeMethodInfo
instance (signature ~ (m Int64), MonadIO m) => O.OverloadedMethod SourceGetTimeMethodInfo Source signature where
    overloadedMethod = sourceGetTime

instance O.OverloadedMethodInfo SourceGetTimeMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceGetTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceGetTime"
        })


#endif

-- method Source::is_destroyed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_is_destroyed" g_source_is_destroyed :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO CInt

-- | Returns whether /@source@/ has been destroyed.
-- 
-- This is important when you operate upon your objects
-- from within idle handlers, but may have freed the object
-- before the dispatch of your idle handler.
-- 
-- 
-- === /c code/
-- >static gboolean
-- >idle_callback (gpointer data)
-- >{
-- >  SomeWidget *self = data;
-- >   
-- >  g_mutex_lock (&self->idle_id_mutex);
-- >  // do stuff with self
-- >  self->idle_id = 0;
-- >  g_mutex_unlock (&self->idle_id_mutex);
-- >   
-- >  return G_SOURCE_REMOVE;
-- >}
-- > 
-- >static void
-- >some_widget_do_stuff_later (SomeWidget *self)
-- >{
-- >  g_mutex_lock (&self->idle_id_mutex);
-- >  self->idle_id = g_idle_add (idle_callback, self);
-- >  g_mutex_unlock (&self->idle_id_mutex);
-- >}
-- > 
-- >static void
-- >some_widget_init (SomeWidget *self)
-- >{
-- >  g_mutex_init (&self->idle_id_mutex);
-- >
-- >  // ...
-- >}
-- >
-- >static void
-- >some_widget_finalize (GObject *object)
-- >{
-- >  SomeWidget *self = SOME_WIDGET (object);
-- >   
-- >  if (self->idle_id)
-- >    g_source_remove (self->idle_id);
-- >   
-- >  g_mutex_clear (&self->idle_id_mutex);
-- >
-- >  G_OBJECT_CLASS (parent_class)->finalize (object);
-- >}
-- 
-- 
-- This will fail in a multi-threaded application if the
-- widget is destroyed before the idle handler fires due
-- to the use after free in the callback. A solution, to
-- this particular problem, is to check to if the source
-- has already been destroy within the callback.
-- 
-- 
-- === /c code/
-- >static gboolean
-- >idle_callback (gpointer data)
-- >{
-- >  SomeWidget *self = data;
-- >  
-- >  g_mutex_lock (&self->idle_id_mutex);
-- >  if (!g_source_is_destroyed (g_main_current_source ()))
-- >    {
-- >      // do stuff with self
-- >    }
-- >  g_mutex_unlock (&self->idle_id_mutex);
-- >  
-- >  return FALSE;
-- >}
-- 
-- 
-- Calls to this function from a thread other than the one acquired by the
-- t'GI.GLib.Structs.MainContext.MainContext' the t'GI.GLib.Structs.Source.Source' is attached to are typically
-- redundant, as the source could be destroyed immediately after this function
-- returns. However, once a source is destroyed it cannot be un-destroyed, so
-- this function can be used for opportunistic checks from any thread.
-- 
-- /Since: 2.12/
sourceIsDestroyed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m Bool
    -- ^ __Returns:__ true if the source has been destroyed, false otherwise
sourceIsDestroyed source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_is_destroyed source'
    let result' = (/= 0) result
    touchManagedPtr source
    return result'

#if defined(ENABLE_OVERLOADING)
data SourceIsDestroyedMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod SourceIsDestroyedMethodInfo Source signature where
    overloadedMethod = sourceIsDestroyed

instance O.OverloadedMethodInfo SourceIsDestroyedMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceIsDestroyed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceIsDestroyed"
        })


#endif

-- method Source::modify_unix_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the tag from [method@GLib.Source.add_unix_fd]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_events"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new event mask to watch"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_modify_unix_fd" g_source_modify_unix_fd :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr () ->                               -- tag : TBasicType TPtr
    CUInt ->                                -- new_events : TInterface (Name {namespace = "GLib", name = "IOCondition"})
    IO ()

-- | Updates the event mask to watch for the file descriptor identified by /@tag@/.
-- 
-- The /@tag@/ is the tag returned from 'GI.GLib.Structs.Source.sourceAddUnixFd'.
-- 
-- If you want to remove a file descriptor, don’t set its event mask to zero.
-- Instead, call 'GI.GLib.Structs.Source.sourceRemoveUnixFd'.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- As the name suggests, this function is not available on Windows.
-- 
-- /Since: 2.36/
sourceModifyUnixFd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Ptr ()
    -- ^ /@tag@/: the tag from 'GI.GLib.Structs.Source.sourceAddUnixFd'
    -> [GLib.Flags.IOCondition]
    -- ^ /@newEvents@/: the new event mask to watch
    -> m ()
sourceModifyUnixFd source tag newEvents = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    let newEvents' = gflagsToWord newEvents
    g_source_modify_unix_fd source' tag newEvents'
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceModifyUnixFdMethodInfo
instance (signature ~ (Ptr () -> [GLib.Flags.IOCondition] -> m ()), MonadIO m) => O.OverloadedMethod SourceModifyUnixFdMethodInfo Source signature where
    overloadedMethod = sourceModifyUnixFd

instance O.OverloadedMethodInfo SourceModifyUnixFdMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceModifyUnixFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceModifyUnixFd"
        })


#endif

-- method Source::query_unix_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the tag from [method@GLib.Source.add_unix_fd]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "IOCondition" })
-- throws : False
-- Skip return : False

foreign import ccall "g_source_query_unix_fd" g_source_query_unix_fd :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr () ->                               -- tag : TBasicType TPtr
    IO CUInt

-- | Queries the events reported for the file descriptor corresponding to /@tag@/
-- on /@source@/ during the last poll.
-- 
-- The return value of this function is only defined when the function
-- is called from the check or dispatch functions for /@source@/.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- As the name suggests, this function is not available on Windows.
-- 
-- /Since: 2.36/
sourceQueryUnixFd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Ptr ()
    -- ^ /@tag@/: the tag from 'GI.GLib.Structs.Source.sourceAddUnixFd'
    -> m [GLib.Flags.IOCondition]
    -- ^ __Returns:__ the conditions reported on the file descriptor
sourceQueryUnixFd source tag = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_query_unix_fd source' tag
    let result' = wordToGFlags result
    touchManagedPtr source
    return result'

#if defined(ENABLE_OVERLOADING)
data SourceQueryUnixFdMethodInfo
instance (signature ~ (Ptr () -> m [GLib.Flags.IOCondition]), MonadIO m) => O.OverloadedMethod SourceQueryUnixFdMethodInfo Source signature where
    overloadedMethod = sourceQueryUnixFd

instance O.OverloadedMethodInfo SourceQueryUnixFdMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceQueryUnixFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceQueryUnixFd"
        })


#endif

-- method Source::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_source_ref" g_source_ref :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO (Ptr Source)

-- | Increases the reference count on a source by one.
sourceRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m Source
    -- ^ __Returns:__ /@source@/
sourceRef source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- g_source_ref source'
    checkUnexpectedReturnNULL "sourceRef" result
    result' <- (wrapBoxed Source) result
    touchManagedPtr source
    return result'

#if defined(ENABLE_OVERLOADING)
data SourceRefMethodInfo
instance (signature ~ (m Source), MonadIO m) => O.OverloadedMethod SourceRefMethodInfo Source signature where
    overloadedMethod = sourceRef

instance O.OverloadedMethodInfo SourceRefMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceRef"
        })


#endif

-- method Source::remove_child_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a source previously passed to\n  [method@GLib.Source.add_child_source]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_remove_child_source" g_source_remove_child_source :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr Source ->                           -- child_source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO ()

-- | Detaches /@childSource@/ from /@source@/ and destroys it.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- /Since: 2.28/
sourceRemoveChildSource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Source
    -- ^ /@childSource@/: a source previously passed to
    --   'GI.GLib.Structs.Source.sourceAddChildSource'
    -> m ()
sourceRemoveChildSource source childSource = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    childSource' <- unsafeManagedPtrGetPtr childSource
    g_source_remove_child_source source' childSource'
    touchManagedPtr source
    touchManagedPtr childSource
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceRemoveChildSourceMethodInfo
instance (signature ~ (Source -> m ()), MonadIO m) => O.OverloadedMethod SourceRemoveChildSourceMethodInfo Source signature where
    overloadedMethod = sourceRemoveChildSource

instance O.OverloadedMethodInfo SourceRemoveChildSourceMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceRemoveChildSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceRemoveChildSource"
        })


#endif

-- method Source::remove_poll
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "PollFD" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [struct@GLib.PollFD] structure previously passed to\n  [method@GLib.Source.add_poll]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_remove_poll" g_source_remove_poll :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr GLib.PollFD.PollFD ->               -- fd : TInterface (Name {namespace = "GLib", name = "PollFD"})
    IO ()

-- | Removes a file descriptor from the set of file descriptors polled for
-- this source.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
sourceRemovePoll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> GLib.PollFD.PollFD
    -- ^ /@fd@/: a t'GI.GLib.Structs.PollFD.PollFD' structure previously passed to
    --   'GI.GLib.Structs.Source.sourceAddPoll'
    -> m ()
sourceRemovePoll source fd = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    fd' <- unsafeManagedPtrGetPtr fd
    g_source_remove_poll source' fd'
    touchManagedPtr source
    touchManagedPtr fd
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceRemovePollMethodInfo
instance (signature ~ (GLib.PollFD.PollFD -> m ()), MonadIO m) => O.OverloadedMethod SourceRemovePollMethodInfo Source signature where
    overloadedMethod = sourceRemovePoll

instance O.OverloadedMethodInfo SourceRemovePollMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceRemovePoll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceRemovePoll"
        })


#endif

-- method Source::remove_unix_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the tag from [method@GLib.Source.add_unix_fd]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_remove_unix_fd" g_source_remove_unix_fd :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr () ->                               -- tag : TBasicType TPtr
    IO ()

-- | Reverses the effect of a previous call to 'GI.GLib.Structs.Source.sourceAddUnixFd'.
-- 
-- You only need to call this if you want to remove a file descriptor from being
-- watched while keeping the same source around.  In the normal case you
-- will just want to destroy the source.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- As the name suggests, this function is not available on Windows.
-- 
-- /Since: 2.36/
sourceRemoveUnixFd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Ptr ()
    -- ^ /@tag@/: the tag from 'GI.GLib.Structs.Source.sourceAddUnixFd'
    -> m ()
sourceRemoveUnixFd source tag = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    g_source_remove_unix_fd source' tag
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceRemoveUnixFdMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod SourceRemoveUnixFdMethodInfo Source signature where
    overloadedMethod = sourceRemoveUnixFd

instance O.OverloadedMethodInfo SourceRemoveUnixFdMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceRemoveUnixFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceRemoveUnixFd"
        })


#endif

-- method Source::set_callback
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a function to call when @data is no longer in use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_callback" g_source_set_callback :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- func : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets the callback function for a source. The callback for a source is
-- called from the source’s dispatch function.
-- 
-- The exact type of /@func@/ depends on the type of source; ie. you
-- should not count on /@func@/ being called with /@data@/ as its first
-- parameter. Cast /@func@/ with @/GLib.SOURCE_FUNC/@ to avoid warnings about
-- incompatible function types.
-- 
-- See <http://developer.gnome.org/glib/stable/main-loop.html#memory-management-of-sources main loop memory management> for details
-- on how to handle memory management of /@data@/.
-- 
-- Typically, you won’t use this function. Instead use functions specific
-- to the type of source you are using, such as 'GI.GLib.Functions.idleAdd' or
-- 'GI.GLib.Functions.timeoutAdd'.
-- 
-- It is safe to call this function multiple times on a source which has already
-- been attached to a context. The changes will take effect for the next time
-- the source is dispatched after this call returns.
-- 
-- Note that 'GI.GLib.Structs.Source.sourceDestroy' for a currently attached source has the effect
-- of also unsetting the callback.
sourceSetCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: the source
    -> GLib.Callbacks.SourceFunc
    -- ^ /@func@/: a callback function
    -> m ()
sourceSetCallback source func = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    func' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc func))
    let data_ = castFunPtrToPtr func'
    let notify = SP.safeFreeFunPtrPtr
    g_source_set_callback source' func' data_ notify
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetCallbackMethodInfo
instance (signature ~ (GLib.Callbacks.SourceFunc -> m ()), MonadIO m) => O.OverloadedMethod SourceSetCallbackMethodInfo Source signature where
    overloadedMethod = sourceSetCallback

instance O.OverloadedMethodInfo SourceSetCallbackMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetCallback",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetCallback"
        })


#endif

-- method Source::set_callback_indirect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer to callback data \8216object\8217"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback_funcs"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SourceCallbackFuncs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "functions for reference counting @callback_data\n  and getting the callback and data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_callback_indirect" g_source_set_callback_indirect :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr () ->                               -- callback_data : TBasicType TPtr
    Ptr GLib.SourceCallbackFuncs.SourceCallbackFuncs -> -- callback_funcs : TInterface (Name {namespace = "GLib", name = "SourceCallbackFuncs"})
    IO ()

-- | Sets the callback function storing the data as a reference counted callback
-- ‘object’.
-- 
-- This is used internally. Note that calling
-- 'GI.GLib.Structs.Source.sourceSetCallbackIndirect' assumes
-- an initial reference count on /@callbackData@/, and thus
-- @callback_funcs->unref@ will eventually be called once more than
-- @callback_funcs->ref@.
-- 
-- It is safe to call this function multiple times on a source which has already
-- been attached to a context. The changes will take effect for the next time
-- the source is dispatched after this call returns.
sourceSetCallbackIndirect ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: the source
    -> Ptr ()
    -- ^ /@callbackData@/: pointer to callback data ‘object’
    -> GLib.SourceCallbackFuncs.SourceCallbackFuncs
    -- ^ /@callbackFuncs@/: functions for reference counting /@callbackData@/
    --   and getting the callback and data
    -> m ()
sourceSetCallbackIndirect source callbackData callbackFuncs = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    callbackFuncs' <- unsafeManagedPtrGetPtr callbackFuncs
    g_source_set_callback_indirect source' callbackData callbackFuncs'
    touchManagedPtr source
    touchManagedPtr callbackFuncs
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetCallbackIndirectMethodInfo
instance (signature ~ (Ptr () -> GLib.SourceCallbackFuncs.SourceCallbackFuncs -> m ()), MonadIO m) => O.OverloadedMethod SourceSetCallbackIndirectMethodInfo Source signature where
    overloadedMethod = sourceSetCallbackIndirect

instance O.OverloadedMethodInfo SourceSetCallbackIndirectMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetCallbackIndirect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetCallbackIndirect"
        })


#endif

-- method Source::set_can_recurse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "can_recurse"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether recursion is allowed for this source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_can_recurse" g_source_set_can_recurse :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    CInt ->                                 -- can_recurse : TBasicType TBoolean
    IO ()

-- | Sets whether a source can be called recursively.
-- 
-- If /@canRecurse@/ is true, then while the source is being dispatched then this
-- source will be processed normally. Otherwise, all processing of this
-- source is blocked until the dispatch function returns.
sourceSetCanRecurse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Bool
    -- ^ /@canRecurse@/: whether recursion is allowed for this source
    -> m ()
sourceSetCanRecurse source canRecurse = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    let canRecurse' = (P.fromIntegral . P.fromEnum) canRecurse
    g_source_set_can_recurse source' canRecurse'
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetCanRecurseMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod SourceSetCanRecurseMethodInfo Source signature where
    overloadedMethod = sourceSetCanRecurse

instance O.OverloadedMethodInfo SourceSetCanRecurseMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetCanRecurse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetCanRecurse"
        })


#endif

-- method Source::set_funcs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFuncs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new source functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_funcs" g_source_set_funcs :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr GLib.SourceFuncs.SourceFuncs ->     -- funcs : TInterface (Name {namespace = "GLib", name = "SourceFuncs"})
    IO ()

-- | Sets the source functions of an unattached source.
-- 
-- These can be used to override the default implementations for the type
-- of /@source@/.
-- 
-- /Since: 2.12/
sourceSetFuncs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> GLib.SourceFuncs.SourceFuncs
    -- ^ /@funcs@/: the new source functions
    -> m ()
sourceSetFuncs source funcs = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    funcs' <- unsafeManagedPtrGetPtr funcs
    g_source_set_funcs source' funcs'
    touchManagedPtr source
    touchManagedPtr funcs
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetFuncsMethodInfo
instance (signature ~ (GLib.SourceFuncs.SourceFuncs -> m ()), MonadIO m) => O.OverloadedMethod SourceSetFuncsMethodInfo Source signature where
    overloadedMethod = sourceSetFuncs

instance O.OverloadedMethodInfo SourceSetFuncsMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetFuncs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetFuncs"
        })


#endif

-- method Source::set_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "debug name for the source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_name" g_source_set_name :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets a name for the source, used in debugging and profiling.
-- 
-- The name defaults to @NULL@.
-- 
-- The source name should describe in a human-readable way
-- what the source does. For example, ‘X11 event queue’
-- or ‘GTK repaint idle handler’.
-- 
-- It is permitted to call this function multiple times, but is not
-- recommended due to the potential performance impact.  For example,
-- one could change the name in the @check@ function of a
-- t'GI.GLib.Structs.SourceFuncs.SourceFuncs' to include details like the event type in the
-- source name.
-- 
-- Use caution if changing the name while another thread may be
-- accessing it with 'GI.GLib.Structs.Source.sourceGetName'; that function does not copy
-- the value, and changing the value will free it while the other thread
-- may be attempting to use it.
-- 
-- Also see 'GI.GLib.Structs.Source.sourceSetStaticName'.
-- 
-- /Since: 2.26/
sourceSetName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> T.Text
    -- ^ /@name@/: debug name for the source
    -> m ()
sourceSetName source name = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    name' <- textToCString name
    g_source_set_name source' name'
    touchManagedPtr source
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod SourceSetNameMethodInfo Source signature where
    overloadedMethod = sourceSetName

instance O.OverloadedMethodInfo SourceSetNameMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetName"
        })


#endif

-- method Source::set_priority
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new priority" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_priority" g_source_set_priority :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Int32 ->                                -- priority : TBasicType TInt
    IO ()

-- | Sets the priority of a source.
-- 
-- While the main loop is being run, a
-- source will be dispatched if it is ready to be dispatched and no
-- sources at a higher (numerically smaller) priority are ready to be
-- dispatched.
-- 
-- A child source always has the same priority as its parent.  It is not
-- permitted to change the priority of a source once it has been added
-- as a child of another source.
sourceSetPriority ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Int32
    -- ^ /@priority@/: the new priority
    -> m ()
sourceSetPriority source priority = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    g_source_set_priority source' priority
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetPriorityMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m) => O.OverloadedMethod SourceSetPriorityMethodInfo Source signature where
    overloadedMethod = sourceSetPriority

instance O.OverloadedMethodInfo SourceSetPriorityMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetPriority",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetPriority"
        })


#endif

-- method Source::set_ready_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ready_time"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the monotonic time at which the source will be ready;\n  `0` for \8216immediately\8217, `-1` for \8216never\8217"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_ready_time" g_source_set_ready_time :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    Int64 ->                                -- ready_time : TBasicType TInt64
    IO ()

-- | Sets a source to be dispatched when the given monotonic time is
-- reached (or passed).
-- 
-- If the monotonic time is in the past (as it
-- always will be if /@readyTime@/ is @0@) then the source will be
-- dispatched immediately.
-- 
-- If /@readyTime@/ is @-1@ then the source is never woken up on the basis
-- of the passage of time.
-- 
-- Dispatching the source does not reset the ready time.  You should do
-- so yourself, from the source dispatch function.
-- 
-- Note that if you have a pair of sources where the ready time of one
-- suggests that it will be delivered first but the priority for the
-- other suggests that it would be delivered first, and the ready time
-- for both sources is reached during the same main context iteration,
-- then the order of dispatch is undefined.
-- 
-- It is a no-op to call this function on a t'GI.GLib.Structs.Source.Source' which has
-- already been destroyed with 'GI.GLib.Structs.Source.sourceDestroy'.
-- 
-- This API is only intended to be used by implementations of t'GI.GLib.Structs.Source.Source'.
-- Do not call this API on a t'GI.GLib.Structs.Source.Source' that you did not create.
-- 
-- /Since: 2.36/
sourceSetReadyTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> Int64
    -- ^ /@readyTime@/: the monotonic time at which the source will be ready;
    --   @0@ for ‘immediately’, @-1@ for ‘never’
    -> m ()
sourceSetReadyTime source readyTime = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    g_source_set_ready_time source' readyTime
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetReadyTimeMethodInfo
instance (signature ~ (Int64 -> m ()), MonadIO m) => O.OverloadedMethod SourceSetReadyTimeMethodInfo Source signature where
    overloadedMethod = sourceSetReadyTime

instance O.OverloadedMethodInfo SourceSetReadyTimeMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetReadyTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetReadyTime"
        })


#endif

-- method Source::set_static_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "debug name for the source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_static_name" g_source_set_static_name :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | A variant of 'GI.GLib.Structs.Source.sourceSetName' that does not
-- duplicate the /@name@/, and can only be used with
-- string literals.
-- 
-- /Since: 2.70/
sourceSetStaticName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> T.Text
    -- ^ /@name@/: debug name for the source
    -> m ()
sourceSetStaticName source name = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    name' <- textToCString name
    g_source_set_static_name source' name'
    touchManagedPtr source
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceSetStaticNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod SourceSetStaticNameMethodInfo Source signature where
    overloadedMethod = sourceSetStaticName

instance O.OverloadedMethodInfo SourceSetStaticNameMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceSetStaticName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceSetStaticName"
        })


#endif

-- method Source::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_unref" g_source_unref :: 
    Ptr Source ->                           -- source : TInterface (Name {namespace = "GLib", name = "Source"})
    IO ()

-- | Decreases the reference count of a source by one.
-- 
-- If the resulting reference count is zero the source and associated
-- memory will be destroyed.
sourceUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Source
    -- ^ /@source@/: a source
    -> m ()
sourceUnref source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    g_source_unref source'
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data SourceUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod SourceUnrefMethodInfo Source signature where
    overloadedMethod = sourceUnref

instance O.OverloadedMethodInfo SourceUnrefMethodInfo Source where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Source.sourceUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Source.html#v:sourceUnref"
        })


#endif

-- method Source::remove
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "tag"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID of the source to remove."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_remove" g_source_remove :: 
    Word32 ->                               -- tag : TBasicType TUInt
    IO CInt

-- | Removes the source with the given ID from the default main context.
-- 
-- You must
-- use 'GI.GLib.Structs.Source.sourceDestroy' for sources added to a non-default main context.
-- 
-- The ID of a t'GI.GLib.Structs.Source.Source' is given by 'GI.GLib.Structs.Source.sourceGetId', or will be
-- returned by the functions 'GI.GLib.Structs.Source.sourceAttach', 'GI.GLib.Functions.idleAdd',
-- @/GLib.idle_add_full/@, 'GI.GLib.Functions.timeoutAdd',
-- @/GLib.timeout_add_full/@, 'GI.GLib.Functions.childWatchAdd',
-- @/GLib.child_watch_add_full/@, 'GI.GLib.Functions.ioAddWatch', and
-- @/GLib.io_add_watch_full/@.
-- 
-- It is a programmer error to attempt to remove a non-existent source.
-- 
-- More specifically: source IDs can be reissued after a source has been
-- destroyed and therefore it is never valid to use this function with a
-- source ID which may have already been removed.  An example is when
-- scheduling an idle to run in another thread with 'GI.GLib.Functions.idleAdd': the
-- idle may already have run and been removed by the time this function
-- is called on its (now invalid) source ID.  This source ID may have
-- been reissued, leading to the operation being performed against the
-- wrong source.
sourceRemove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@tag@/: the ID of the source to remove.
    -> m Bool
    -- ^ __Returns:__ true if the source was found and removed, false otherwise
sourceRemove tag = liftIO $ do
    result <- g_source_remove tag
    let result' = (/= 0) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Source::remove_by_funcs_user_data
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFuncs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the @source_funcs passed to [ctor@GLib.Source.new]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the user data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_remove_by_funcs_user_data" g_source_remove_by_funcs_user_data :: 
    Ptr GLib.SourceFuncs.SourceFuncs ->     -- funcs : TInterface (Name {namespace = "GLib", name = "SourceFuncs"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO CInt

-- | Removes a source from the default main loop context given the
-- source functions and user data.
-- 
-- If multiple sources exist with the same source functions and user data, only
-- one will be destroyed.
sourceRemoveByFuncsUserData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SourceFuncs.SourceFuncs
    -- ^ /@funcs@/: the /@sourceFuncs@/ passed to 'GI.GLib.Structs.Source.sourceNew'
    -> Ptr ()
    -- ^ /@userData@/: the user data for the callback
    -> m Bool
    -- ^ __Returns:__ true if a source was found and removed, false otherwise
sourceRemoveByFuncsUserData funcs userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    result <- g_source_remove_by_funcs_user_data funcs' userData
    let result' = (/= 0) result
    touchManagedPtr funcs
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Source::remove_by_user_data
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the user_data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_source_remove_by_user_data" g_source_remove_by_user_data :: 
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO CInt

-- | Removes a source from the default main loop context given the user
-- data for the callback.
-- 
-- If multiple sources exist with the same user data, only one will be destroyed.
sourceRemoveByUserData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@userData@/: the user_data for the callback
    -> m Bool
    -- ^ __Returns:__ true if a source was found and removed, false otherwise
sourceRemoveByUserData userData = liftIO $ do
    result <- g_source_remove_by_user_data userData
    let result' = (/= 0) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Source::set_name_by_id
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "tag"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a source ID" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "debug name for the source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_source_set_name_by_id" g_source_set_name_by_id :: 
    Word32 ->                               -- tag : TBasicType TUInt
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets the name of a source using its ID.
-- 
-- This is a convenience utility to set source names from the return
-- value of 'GI.GLib.Functions.idleAdd', 'GI.GLib.Functions.timeoutAdd', etc.
-- 
-- It is a programmer error to attempt to set the name of a non-existent
-- source.
-- 
-- More specifically: source IDs can be reissued after a source has been
-- destroyed and therefore it is never valid to use this function with a
-- source ID which may have already been removed.  An example is when
-- scheduling an idle to run in another thread with 'GI.GLib.Functions.idleAdd': the
-- idle may already have run and been removed by the time this function
-- is called on its (now invalid) source ID.  This source ID may have
-- been reissued, leading to the operation being performed against the
-- wrong source.
-- 
-- /Since: 2.26/
sourceSetNameById ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@tag@/: a source ID
    -> T.Text
    -- ^ /@name@/: debug name for the source
    -> m ()
sourceSetNameById tag name = liftIO $ do
    name' <- textToCString name
    g_source_set_name_by_id tag name'
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSourceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSourceMethod "addChildSource" o = SourceAddChildSourceMethodInfo
    ResolveSourceMethod "addPoll" o = SourceAddPollMethodInfo
    ResolveSourceMethod "addUnixFd" o = SourceAddUnixFdMethodInfo
    ResolveSourceMethod "attach" o = SourceAttachMethodInfo
    ResolveSourceMethod "destroy" o = SourceDestroyMethodInfo
    ResolveSourceMethod "dupContext" o = SourceDupContextMethodInfo
    ResolveSourceMethod "isDestroyed" o = SourceIsDestroyedMethodInfo
    ResolveSourceMethod "modifyUnixFd" o = SourceModifyUnixFdMethodInfo
    ResolveSourceMethod "queryUnixFd" o = SourceQueryUnixFdMethodInfo
    ResolveSourceMethod "ref" o = SourceRefMethodInfo
    ResolveSourceMethod "removeChildSource" o = SourceRemoveChildSourceMethodInfo
    ResolveSourceMethod "removePoll" o = SourceRemovePollMethodInfo
    ResolveSourceMethod "removeUnixFd" o = SourceRemoveUnixFdMethodInfo
    ResolveSourceMethod "unref" o = SourceUnrefMethodInfo
    ResolveSourceMethod "getCanRecurse" o = SourceGetCanRecurseMethodInfo
    ResolveSourceMethod "getContext" o = SourceGetContextMethodInfo
    ResolveSourceMethod "getCurrentTime" o = SourceGetCurrentTimeMethodInfo
    ResolveSourceMethod "getId" o = SourceGetIdMethodInfo
    ResolveSourceMethod "getName" o = SourceGetNameMethodInfo
    ResolveSourceMethod "getPriority" o = SourceGetPriorityMethodInfo
    ResolveSourceMethod "getReadyTime" o = SourceGetReadyTimeMethodInfo
    ResolveSourceMethod "getTime" o = SourceGetTimeMethodInfo
    ResolveSourceMethod "setCallback" o = SourceSetCallbackMethodInfo
    ResolveSourceMethod "setCallbackIndirect" o = SourceSetCallbackIndirectMethodInfo
    ResolveSourceMethod "setCanRecurse" o = SourceSetCanRecurseMethodInfo
    ResolveSourceMethod "setFuncs" o = SourceSetFuncsMethodInfo
    ResolveSourceMethod "setName" o = SourceSetNameMethodInfo
    ResolveSourceMethod "setPriority" o = SourceSetPriorityMethodInfo
    ResolveSourceMethod "setReadyTime" o = SourceSetReadyTimeMethodInfo
    ResolveSourceMethod "setStaticName" o = SourceSetStaticNameMethodInfo
    ResolveSourceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSourceMethod t Source, O.OverloadedMethod info Source p) => OL.IsLabel t (Source -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSourceMethod t Source, O.OverloadedMethod info Source p, R.HasField t Source p) => R.HasField t Source p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSourceMethod t Source, O.OverloadedMethodInfo info Source) => OL.IsLabel t (O.MethodProxy info Source) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


