{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GThemedIcon@ is an implementation of t'GI.Gio.Interfaces.Icon.Icon' that supports icon
-- themes.
-- 
-- @GThemedIcon@ contains a list of all of the icons present in an icon
-- theme, so that icons can be looked up quickly. @GThemedIcon@ does
-- not provide actual pixmaps for icons, just the icon names.
-- Ideally something like @/Gtk.IconTheme.choose_icon()/@ should be used to
-- resolve the list of names so that fallback icons work nicely with
-- themes that inherit other themes.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ThemedIcon
    ( 

-- * Exported types
    ThemedIcon(..)                          ,
    IsThemedIcon                            ,
    toThemedIcon                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [appendName]("GI.Gio.Objects.ThemedIcon#g:method:appendName"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [prependName]("GI.Gio.Objects.ThemedIcon#g:method:prependName"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getNames]("GI.Gio.Objects.ThemedIcon#g:method:getNames"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveThemedIconMethod                 ,
#endif

-- ** appendName #method:appendName#

#if defined(ENABLE_OVERLOADING)
    ThemedIconAppendNameMethodInfo          ,
#endif
    themedIconAppendName                    ,


-- ** getNames #method:getNames#

#if defined(ENABLE_OVERLOADING)
    ThemedIconGetNamesMethodInfo            ,
#endif
    themedIconGetNames                      ,


-- ** new #method:new#

    themedIconNew                           ,


-- ** newFromNames #method:newFromNames#

    themedIconNewFromNames                  ,


-- ** newWithDefaultFallbacks #method:newWithDefaultFallbacks#

    themedIconNewWithDefaultFallbacks       ,


-- ** prependName #method:prependName#

#if defined(ENABLE_OVERLOADING)
    ThemedIconPrependNameMethodInfo         ,
#endif
    themedIconPrependName                   ,




 -- * Properties


-- ** name #attr:name#
-- | The icon name.

#if defined(ENABLE_OVERLOADING)
    ThemedIconNamePropertyInfo              ,
#endif
    constructThemedIconName                 ,
#if defined(ENABLE_OVERLOADING)
    themedIconName                          ,
#endif


-- ** names #attr:names#
-- | A 'P.Nothing'-terminated array of icon names.

#if defined(ENABLE_OVERLOADING)
    ThemedIconNamesPropertyInfo             ,
#endif
    constructThemedIconNames                ,
    getThemedIconNames                      ,
#if defined(ENABLE_OVERLOADING)
    themedIconNames                         ,
#endif


-- ** useDefaultFallbacks #attr:useDefaultFallbacks#
-- | Whether to use the default fallbacks found by shortening the icon name
-- at \'-\' characters. If the \"names\" array has more than one element,
-- ignores any past the first.
-- 
-- For example, if the icon name was \"gnome-dev-cdrom-audio\", the array
-- would become
-- 
-- === /C code/
-- >
-- >{
-- >  "gnome-dev-cdrom-audio",
-- >  "gnome-dev-cdrom",
-- >  "gnome-dev",
-- >  "gnome",
-- >  NULL
-- >};

#if defined(ENABLE_OVERLOADING)
    ThemedIconUseDefaultFallbacksPropertyInfo,
#endif
    constructThemedIconUseDefaultFallbacks  ,
    getThemedIconUseDefaultFallbacks        ,
#if defined(ENABLE_OVERLOADING)
    themedIconUseDefaultFallbacks           ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon

#endif

-- | Memory-managed wrapper type.
newtype ThemedIcon = ThemedIcon (SP.ManagedPtr ThemedIcon)
    deriving (Eq)

instance SP.ManagedPtrNewtype ThemedIcon where
    toManagedPtr (ThemedIcon p) = p

foreign import ccall "g_themed_icon_get_type"
    c_g_themed_icon_get_type :: IO B.Types.GType

instance B.Types.TypedObject ThemedIcon where
    glibType = c_g_themed_icon_get_type

instance B.Types.GObject ThemedIcon

-- | Type class for types which can be safely cast to t'ThemedIcon', for instance with `toThemedIcon`.
class (SP.GObject o, O.IsDescendantOf ThemedIcon o) => IsThemedIcon o
instance (SP.GObject o, O.IsDescendantOf ThemedIcon o) => IsThemedIcon o

instance O.HasParentTypes ThemedIcon
type instance O.ParentTypes ThemedIcon = '[GObject.Object.Object, Gio.Icon.Icon]

-- | Cast to t'ThemedIcon', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toThemedIcon :: (MIO.MonadIO m, IsThemedIcon o) => o -> m ThemedIcon
toThemedIcon = MIO.liftIO . B.ManagedPtr.unsafeCastTo ThemedIcon

-- | Convert t'ThemedIcon' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ThemedIcon) where
    gvalueGType_ = c_g_themed_icon_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ThemedIcon)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ThemedIcon)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ThemedIcon ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveThemedIconMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveThemedIconMethod "appendName" o = ThemedIconAppendNameMethodInfo
    ResolveThemedIconMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveThemedIconMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveThemedIconMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveThemedIconMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveThemedIconMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveThemedIconMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveThemedIconMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveThemedIconMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveThemedIconMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveThemedIconMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveThemedIconMethod "prependName" o = ThemedIconPrependNameMethodInfo
    ResolveThemedIconMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveThemedIconMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveThemedIconMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveThemedIconMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveThemedIconMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveThemedIconMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveThemedIconMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveThemedIconMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveThemedIconMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveThemedIconMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveThemedIconMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveThemedIconMethod "getNames" o = ThemedIconGetNamesMethodInfo
    ResolveThemedIconMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveThemedIconMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveThemedIconMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveThemedIconMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveThemedIconMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveThemedIconMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveThemedIconMethod t ThemedIcon, O.OverloadedMethod info ThemedIcon p) => OL.IsLabel t (ThemedIcon -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveThemedIconMethod t ThemedIcon, O.OverloadedMethod info ThemedIcon p, R.HasField t ThemedIcon p) => R.HasField t ThemedIcon p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveThemedIconMethod t ThemedIcon, O.OverloadedMethodInfo info ThemedIcon) => OL.IsLabel t (O.MethodProxy info ThemedIcon) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Construct a t'GValueConstruct' with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructThemedIconName :: (IsThemedIcon o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructThemedIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ThemedIconNamePropertyInfo
instance AttrInfo ThemedIconNamePropertyInfo where
    type AttrAllowedOps ThemedIconNamePropertyInfo = '[ 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint ThemedIconNamePropertyInfo = IsThemedIcon
    type AttrSetTypeConstraint ThemedIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ThemedIconNamePropertyInfo = (~) T.Text
    type AttrTransferType ThemedIconNamePropertyInfo = T.Text
    type AttrGetType ThemedIconNamePropertyInfo = ()
    type AttrLabel ThemedIconNamePropertyInfo = "name"
    type AttrOrigin ThemedIconNamePropertyInfo = ThemedIcon
    attrGet = undefined
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructThemedIconName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThemedIcon.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ThemedIcon.html#g:attr:name"
        })
#endif

-- VVV Prop "names"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@names@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' themedIcon #names
-- @
getThemedIconNames :: (MonadIO m, IsThemedIcon o) => o -> m [T.Text]
getThemedIconNames obj = MIO.liftIO $ checkUnexpectedNothing "getThemedIconNames" $ B.Properties.getObjectPropertyStringArray obj "names"

-- | Construct a t'GValueConstruct' with valid value for the “@names@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructThemedIconNames :: (IsThemedIcon o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructThemedIconNames val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "names" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ThemedIconNamesPropertyInfo
instance AttrInfo ThemedIconNamesPropertyInfo where
    type AttrAllowedOps ThemedIconNamesPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ThemedIconNamesPropertyInfo = IsThemedIcon
    type AttrSetTypeConstraint ThemedIconNamesPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint ThemedIconNamesPropertyInfo = (~) [T.Text]
    type AttrTransferType ThemedIconNamesPropertyInfo = [T.Text]
    type AttrGetType ThemedIconNamesPropertyInfo = [T.Text]
    type AttrLabel ThemedIconNamesPropertyInfo = "names"
    type AttrOrigin ThemedIconNamesPropertyInfo = ThemedIcon
    attrGet = getThemedIconNames
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructThemedIconNames
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThemedIcon.names"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ThemedIcon.html#g:attr:names"
        })
#endif

-- VVV Prop "use-default-fallbacks"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@use-default-fallbacks@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' themedIcon #useDefaultFallbacks
-- @
getThemedIconUseDefaultFallbacks :: (MonadIO m, IsThemedIcon o) => o -> m Bool
getThemedIconUseDefaultFallbacks obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-default-fallbacks"

-- | Construct a t'GValueConstruct' with valid value for the “@use-default-fallbacks@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructThemedIconUseDefaultFallbacks :: (IsThemedIcon o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructThemedIconUseDefaultFallbacks val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-default-fallbacks" val

#if defined(ENABLE_OVERLOADING)
data ThemedIconUseDefaultFallbacksPropertyInfo
instance AttrInfo ThemedIconUseDefaultFallbacksPropertyInfo where
    type AttrAllowedOps ThemedIconUseDefaultFallbacksPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ThemedIconUseDefaultFallbacksPropertyInfo = IsThemedIcon
    type AttrSetTypeConstraint ThemedIconUseDefaultFallbacksPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ThemedIconUseDefaultFallbacksPropertyInfo = (~) Bool
    type AttrTransferType ThemedIconUseDefaultFallbacksPropertyInfo = Bool
    type AttrGetType ThemedIconUseDefaultFallbacksPropertyInfo = Bool
    type AttrLabel ThemedIconUseDefaultFallbacksPropertyInfo = "use-default-fallbacks"
    type AttrOrigin ThemedIconUseDefaultFallbacksPropertyInfo = ThemedIcon
    attrGet = getThemedIconUseDefaultFallbacks
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructThemedIconUseDefaultFallbacks
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThemedIcon.useDefaultFallbacks"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ThemedIcon.html#g:attr:useDefaultFallbacks"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ThemedIcon
type instance O.AttributeList ThemedIcon = ThemedIconAttributeList
type ThemedIconAttributeList = ('[ '("name", ThemedIconNamePropertyInfo), '("names", ThemedIconNamesPropertyInfo), '("useDefaultFallbacks", ThemedIconUseDefaultFallbacksPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
themedIconName :: AttrLabelProxy "name"
themedIconName = AttrLabelProxy

themedIconNames :: AttrLabelProxy "names"
themedIconNames = AttrLabelProxy

themedIconUseDefaultFallbacks :: AttrLabelProxy "useDefaultFallbacks"
themedIconUseDefaultFallbacks = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ThemedIcon = ThemedIconSignalList
type ThemedIconSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ThemedIcon::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "iconname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing an icon name."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ThemedIcon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_themed_icon_new" g_themed_icon_new :: 
    CString ->                              -- iconname : TBasicType TUTF8
    IO (Ptr ThemedIcon)

-- | Creates a new themed icon for /@iconname@/.
themedIconNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@iconname@/: a string containing an icon name.
    -> m ThemedIcon
    -- ^ __Returns:__ a new t'GI.Gio.Objects.ThemedIcon.ThemedIcon'.
themedIconNew iconname = liftIO $ do
    iconname' <- textToCString iconname
    result <- g_themed_icon_new iconname'
    checkUnexpectedReturnNULL "themedIconNew" result
    result' <- (wrapObject ThemedIcon) result
    freeMem iconname'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ThemedIcon::new_from_names
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "iconnames"
--           , argType = TCArray False (-1) 1 (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of strings containing icon names."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the length of the @iconnames array, or -1 if @iconnames is\n    %NULL-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the length of the @iconnames array, or -1 if @iconnames is\n    %NULL-terminated"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ThemedIcon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_themed_icon_new_from_names" g_themed_icon_new_from_names :: 
    Ptr CString ->                          -- iconnames : TCArray False (-1) 1 (TBasicType TUTF8)
    Int32 ->                                -- len : TBasicType TInt
    IO (Ptr ThemedIcon)

-- | Creates a new themed icon for /@iconnames@/.
themedIconNewFromNames ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@iconnames@/: an array of strings containing icon names.
    -> m ThemedIcon
    -- ^ __Returns:__ a new t'GI.Gio.Objects.ThemedIcon.ThemedIcon'
themedIconNewFromNames iconnames = liftIO $ do
    let len = fromIntegral $ P.length iconnames
    iconnames' <- packUTF8CArray iconnames
    result <- g_themed_icon_new_from_names iconnames' len
    checkUnexpectedReturnNULL "themedIconNewFromNames" result
    result' <- (wrapObject ThemedIcon) result
    (mapCArrayWithLength len) freeMem iconnames'
    freeMem iconnames'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ThemedIcon::new_with_default_fallbacks
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "iconname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing an icon name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ThemedIcon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_themed_icon_new_with_default_fallbacks" g_themed_icon_new_with_default_fallbacks :: 
    CString ->                              -- iconname : TBasicType TUTF8
    IO (Ptr ThemedIcon)

-- | Creates a new themed icon for /@iconname@/, and all the names
-- that can be created by shortening /@iconname@/ at \'-\' characters.
-- 
-- In the following example, /@icon1@/ and /@icon2@/ are equivalent:
-- 
-- === /C code/
-- >
-- >const char *names[] = {
-- >  "gnome-dev-cdrom-audio",
-- >  "gnome-dev-cdrom",
-- >  "gnome-dev",
-- >  "gnome"
-- >};
-- >
-- >icon1 = g_themed_icon_new_from_names (names, 4);
-- >icon2 = g_themed_icon_new_with_default_fallbacks ("gnome-dev-cdrom-audio");
themedIconNewWithDefaultFallbacks ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@iconname@/: a string containing an icon name
    -> m ThemedIcon
    -- ^ __Returns:__ a new t'GI.Gio.Objects.ThemedIcon.ThemedIcon'.
themedIconNewWithDefaultFallbacks iconname = liftIO $ do
    iconname' <- textToCString iconname
    result <- g_themed_icon_new_with_default_fallbacks iconname'
    checkUnexpectedReturnNULL "themedIconNewWithDefaultFallbacks" result
    result' <- (wrapObject ThemedIcon) result
    freeMem iconname'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ThemedIcon::append_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ThemedIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GThemedIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iconname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "name of icon to append to list of icons from within @icon."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_themed_icon_append_name" g_themed_icon_append_name :: 
    Ptr ThemedIcon ->                       -- icon : TInterface (Name {namespace = "Gio", name = "ThemedIcon"})
    CString ->                              -- iconname : TBasicType TUTF8
    IO ()

-- | Append a name to the list of icons from within /@icon@/.
-- 
-- Note that doing so invalidates the hash computed by prior calls
-- to 'GI.Gio.Interfaces.Icon.iconHash'.
themedIconAppendName ::
    (B.CallStack.HasCallStack, MonadIO m, IsThemedIcon a) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Objects.ThemedIcon.ThemedIcon'
    -> T.Text
    -- ^ /@iconname@/: name of icon to append to list of icons from within /@icon@/.
    -> m ()
themedIconAppendName icon iconname = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    iconname' <- textToCString iconname
    g_themed_icon_append_name icon' iconname'
    touchManagedPtr icon
    freeMem iconname'
    return ()

#if defined(ENABLE_OVERLOADING)
data ThemedIconAppendNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsThemedIcon a) => O.OverloadedMethod ThemedIconAppendNameMethodInfo a signature where
    overloadedMethod = themedIconAppendName

instance O.OverloadedMethodInfo ThemedIconAppendNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThemedIcon.themedIconAppendName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ThemedIcon.html#v:themedIconAppendName"
        })


#endif

-- method ThemedIcon::get_names
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ThemedIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GThemedIcon." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_themed_icon_get_names" g_themed_icon_get_names :: 
    Ptr ThemedIcon ->                       -- icon : TInterface (Name {namespace = "Gio", name = "ThemedIcon"})
    IO (Ptr CString)

-- | Gets the names of icons from within /@icon@/.
themedIconGetNames ::
    (B.CallStack.HasCallStack, MonadIO m, IsThemedIcon a) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Objects.ThemedIcon.ThemedIcon'.
    -> m [T.Text]
    -- ^ __Returns:__ a list of icon names.
themedIconGetNames icon = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    result <- g_themed_icon_get_names icon'
    checkUnexpectedReturnNULL "themedIconGetNames" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr icon
    return result'

#if defined(ENABLE_OVERLOADING)
data ThemedIconGetNamesMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsThemedIcon a) => O.OverloadedMethod ThemedIconGetNamesMethodInfo a signature where
    overloadedMethod = themedIconGetNames

instance O.OverloadedMethodInfo ThemedIconGetNamesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThemedIcon.themedIconGetNames",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ThemedIcon.html#v:themedIconGetNames"
        })


#endif

-- method ThemedIcon::prepend_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ThemedIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GThemedIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iconname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "name of icon to prepend to list of icons from within @icon."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_themed_icon_prepend_name" g_themed_icon_prepend_name :: 
    Ptr ThemedIcon ->                       -- icon : TInterface (Name {namespace = "Gio", name = "ThemedIcon"})
    CString ->                              -- iconname : TBasicType TUTF8
    IO ()

-- | Prepend a name to the list of icons from within /@icon@/.
-- 
-- Note that doing so invalidates the hash computed by prior calls
-- to 'GI.Gio.Interfaces.Icon.iconHash'.
-- 
-- /Since: 2.18/
themedIconPrependName ::
    (B.CallStack.HasCallStack, MonadIO m, IsThemedIcon a) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Objects.ThemedIcon.ThemedIcon'
    -> T.Text
    -- ^ /@iconname@/: name of icon to prepend to list of icons from within /@icon@/.
    -> m ()
themedIconPrependName icon iconname = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    iconname' <- textToCString iconname
    g_themed_icon_prepend_name icon' iconname'
    touchManagedPtr icon
    freeMem iconname'
    return ()

#if defined(ENABLE_OVERLOADING)
data ThemedIconPrependNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsThemedIcon a) => O.OverloadedMethod ThemedIconPrependNameMethodInfo a signature where
    overloadedMethod = themedIconPrependName

instance O.OverloadedMethodInfo ThemedIconPrependNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThemedIcon.themedIconPrependName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ThemedIcon.html#v:themedIconPrependName"
        })


#endif


