/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_catv_randomizer_bb = R"doc(Randomizer, x^3 + x + alpha^3, 7-bit symbols.

Input: Interleaved MPEG-2 + RS parity bitstream packets of 128 7-bit symbols.
Output: Scrambled FEC Frame packets of 60 * 128 (64QAM) or 88 * 128 (256QAM) 7-bit symbols.

Constructor Specific Documentation:

Create an ITU-T J.83B randomizer.

Args:
    constellation : 64QAM or 256QAM constellation.)doc";


static const char* __doc_gr_dtv_catv_randomizer_bb_catv_randomizer_bb = R"doc()doc";


static const char* __doc_gr_dtv_catv_randomizer_bb_make = R"doc(Randomizer, x^3 + x + alpha^3, 7-bit symbols.

Input: Interleaved MPEG-2 + RS parity bitstream packets of 128 7-bit symbols.
Output: Scrambled FEC Frame packets of 60 * 128 (64QAM) or 88 * 128 (256QAM) 7-bit symbols.

Constructor Specific Documentation:

Create an ITU-T J.83B randomizer.

Args:
    constellation : 64QAM or 256QAM constellation.)doc";
