/* libvirt-media.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from libvirt-media.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include "common.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <osinfo/osinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_VM_CREATOR (boxes_vm_creator_get_type ())
#define BOXES_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreator))
#define BOXES_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))
#define BOXES_IS_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CREATOR))
#define BOXES_IS_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CREATOR))
#define BOXES_VM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))

typedef struct _BoxesVMCreator BoxesVMCreator;
typedef struct _BoxesVMCreatorClass BoxesVMCreatorClass;

#define BOXES_TYPE_INSTALLED_MEDIA (boxes_installed_media_get_type ())
#define BOXES_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMedia))
#define BOXES_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))
#define BOXES_IS_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_IS_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_INSTALLED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))

typedef struct _BoxesInstalledMedia BoxesInstalledMedia;
typedef struct _BoxesInstalledMediaClass BoxesInstalledMediaClass;
typedef struct _BoxesInstalledMediaPrivate BoxesInstalledMediaPrivate;

#define BOXES_TYPE_LIBVIRT_MEDIA (boxes_libvirt_media_get_type ())
#define BOXES_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMedia))
#define BOXES_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))
#define BOXES_IS_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_IS_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_LIBVIRT_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))

typedef struct _BoxesLibvirtMedia BoxesLibvirtMedia;
typedef struct _BoxesLibvirtMediaClass BoxesLibvirtMediaClass;
typedef struct _BoxesLibvirtMediaPrivate BoxesLibvirtMediaPrivate;
enum  {
	BOXES_LIBVIRT_MEDIA_0_PROPERTY,
	BOXES_LIBVIRT_MEDIA_PREFERS_Q35_PROPERTY,
	BOXES_LIBVIRT_MEDIA_ARCHITECTURE_PROPERTY,
	BOXES_LIBVIRT_MEDIA_DOMAIN_CONFIG_PROPERTY,
	BOXES_LIBVIRT_MEDIA_NUM_PROPERTIES
};
static GParamSpec* boxes_libvirt_media_properties[BOXES_LIBVIRT_MEDIA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_TYPE_VM_IMPORTER (boxes_vm_importer_get_type ())
#define BOXES_VM_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_IMPORTER, BoxesVMImporter))
#define BOXES_VM_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_IMPORTER, BoxesVMImporterClass))
#define BOXES_IS_VM_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_IMPORTER))
#define BOXES_IS_VM_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_IMPORTER))
#define BOXES_VM_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_IMPORTER, BoxesVMImporterClass))

typedef struct _BoxesVMImporter BoxesVMImporter;
typedef struct _BoxesVMImporterClass BoxesVMImporterClass;

#define BOXES_TYPE_LIBVIRT_VM_IMPORTER (boxes_libvirt_vm_importer_get_type ())
#define BOXES_LIBVIRT_VM_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_VM_IMPORTER, BoxesLibvirtVMImporter))
#define BOXES_LIBVIRT_VM_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_VM_IMPORTER, BoxesLibvirtVMImporterClass))
#define BOXES_IS_LIBVIRT_VM_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_VM_IMPORTER))
#define BOXES_IS_LIBVIRT_VM_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_VM_IMPORTER))
#define BOXES_LIBVIRT_VM_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_VM_IMPORTER, BoxesLibvirtVMImporterClass))

typedef struct _BoxesLibvirtVMImporter BoxesLibvirtVMImporter;
typedef struct _BoxesLibvirtVMImporterClass BoxesLibvirtVMImporterClass;

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare) (BoxesInstallerMedia* self, BoxesActivityProgress* progress, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*prepare_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_to_continue_installation) (BoxesInstallerMedia* self, const gchar* vm_name);
	void (*clean_up) (BoxesInstallerMedia* self);
	void (*clean_up_preparation_cache) (BoxesInstallerMedia* self);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*setup_post_install_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	BoxesVMCreator* (*get_vm_creator) (BoxesInstallerMedia* self);
	OsinfoDeviceList* (*get_supported_devices) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_prefers_q35) (BoxesInstallerMedia* self);
	gboolean (*get_prefers_ich9) (BoxesInstallerMedia* self);
	gboolean (*get_live) (BoxesInstallerMedia* self);
	gboolean (*get_eject_after_install) (BoxesInstallerMedia* self);
	gchar* (*get_architecture) (BoxesInstallerMedia* self);
};

struct _BoxesInstalledMedia {
	BoxesInstallerMedia parent_instance;
	BoxesInstalledMediaPrivate * priv;
};

struct _BoxesInstalledMediaClass {
	BoxesInstallerMediaClass parent_class;
};

struct _BoxesLibvirtMedia {
	BoxesInstalledMedia parent_instance;
	BoxesLibvirtMediaPrivate * priv;
};

struct _BoxesLibvirtMediaClass {
	BoxesInstalledMediaClass parent_class;
};

struct _BoxesLibvirtMediaPrivate {
	GVirConfigDomain* _domain_config;
};

static gint BoxesLibvirtMedia_private_offset;
static gpointer boxes_libvirt_media_parent_class = NULL;

VALA_EXTERN GType boxes_installer_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesInstallerMedia, g_object_unref)
VALA_EXTERN GType boxes_vm_creator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesVMCreator, g_object_unref)
VALA_EXTERN GType boxes_installed_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesInstalledMedia, g_object_unref)
VALA_EXTERN GType boxes_libvirt_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtMedia, g_object_unref)
VALA_EXTERN BoxesVMCreator* boxes_installer_media_get_vm_creator (BoxesInstallerMedia* self);
VALA_EXTERN gboolean boxes_installer_media_get_prefers_q35 (BoxesInstallerMedia* self);
VALA_EXTERN gchar* boxes_installer_media_get_architecture (BoxesInstallerMedia* self);
VALA_EXTERN BoxesLibvirtMedia* boxes_libvirt_media_new (const gchar* path,
                                            GVirConfigDomain* domain_config,
                                            gboolean skip_import,
                                            GError** error);
VALA_EXTERN BoxesLibvirtMedia* boxes_libvirt_media_construct (GType object_type,
                                                  const gchar* path,
                                                  GVirConfigDomain* domain_config,
                                                  gboolean skip_import,
                                                  GError** error);
VALA_EXTERN BoxesInstalledMedia* boxes_installed_media_new (const gchar* path,
                                                gboolean skip_import);
VALA_EXTERN BoxesInstalledMedia* boxes_installed_media_construct (GType object_type,
                                                      const gchar* path,
                                                      gboolean skip_import);
static void boxes_libvirt_media_set_domain_config (BoxesLibvirtMedia* self,
                                            GVirConfigDomain* value);
VALA_EXTERN OsinfoResources* boxes_os_database_get_default_resources (void);
static BoxesVMCreator* boxes_libvirt_media_real_get_vm_creator (BoxesInstallerMedia* base);
VALA_EXTERN BoxesLibvirtVMImporter* boxes_libvirt_vm_importer_new (BoxesInstalledMedia* source_media);
VALA_EXTERN BoxesLibvirtVMImporter* boxes_libvirt_vm_importer_construct (GType object_type,
                                                             BoxesInstalledMedia* source_media);
VALA_EXTERN GType boxes_vm_importer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesVMImporter, g_object_unref)
VALA_EXTERN GType boxes_libvirt_vm_importer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtVMImporter, g_object_unref)
VALA_EXTERN GVirConfigDomain* boxes_libvirt_media_get_domain_config (BoxesLibvirtMedia* self);
static void boxes_libvirt_media_finalize (GObject * obj);
static GType boxes_libvirt_media_get_type_once (void);
static void _vala_boxes_libvirt_media_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_boxes_libvirt_media_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
boxes_libvirt_media_get_instance_private (BoxesLibvirtMedia* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesLibvirtMedia_private_offset);
}

BoxesLibvirtMedia*
boxes_libvirt_media_construct (GType object_type,
                               const gchar* path,
                               GVirConfigDomain* domain_config,
                               gboolean skip_import,
                               GError** error)
{
	BoxesLibvirtMedia * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp5_;
	OsinfoResources* _tmp6_;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (domain_config != NULL, NULL);
	self = (BoxesLibvirtMedia*) boxes_installed_media_construct (object_type, path, skip_import);
	boxes_libvirt_media_set_domain_config (self, domain_config);
	_tmp1_ = gvir_config_domain_get_title (domain_config);
	_tmp2_ = _tmp1_;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = gvir_config_domain_get_name (domain_config);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp0_);
	_g_free0 (((BoxesInstallerMedia*) self)->label);
	((BoxesInstallerMedia*) self)->label = _tmp5_;
	_tmp6_ = boxes_os_database_get_default_resources ();
	_g_object_unref0 (((BoxesInstallerMedia*) self)->resources);
	((BoxesInstallerMedia*) self)->resources = _tmp6_;
	return self;
}

BoxesLibvirtMedia*
boxes_libvirt_media_new (const gchar* path,
                         GVirConfigDomain* domain_config,
                         gboolean skip_import,
                         GError** error)
{
	return boxes_libvirt_media_construct (BOXES_TYPE_LIBVIRT_MEDIA, path, domain_config, skip_import, error);
}

static BoxesVMCreator*
boxes_libvirt_media_real_get_vm_creator (BoxesInstallerMedia* base)
{
	BoxesLibvirtMedia * self;
	BoxesLibvirtVMImporter* _tmp0_;
	BoxesVMCreator* result;
	self = (BoxesLibvirtMedia*) base;
	_tmp0_ = boxes_libvirt_vm_importer_new ((BoxesInstalledMedia*) self);
	result = (BoxesVMCreator*) _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
boxes_libvirt_media_real_get_prefers_q35 (BoxesInstallerMedia* base)
{
	gboolean result;
	BoxesLibvirtMedia* self;
	GVirConfigDomain* _tmp0_;
	GVirConfigDomainOs* _tmp1_;
	GVirConfigDomainOs* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	self = (BoxesLibvirtMedia*) base;
	_tmp0_ = self->priv->_domain_config;
	_tmp1_ = gvir_config_domain_get_os (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gvir_config_domain_os_get_machine (_tmp2_);
	_tmp4_ = string_contains (_tmp3_, "q35");
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gchar*
boxes_libvirt_media_real_get_architecture (BoxesInstallerMedia* base)
{
	gchar* result;
	BoxesLibvirtMedia* self;
	GVirConfigDomain* _tmp0_;
	GVirConfigDomainOs* _tmp1_;
	GVirConfigDomainOs* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (BoxesLibvirtMedia*) base;
	_tmp0_ = self->priv->_domain_config;
	_tmp1_ = gvir_config_domain_get_os (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gvir_config_domain_os_get_arch (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}

GVirConfigDomain*
boxes_libvirt_media_get_domain_config (BoxesLibvirtMedia* self)
{
	GVirConfigDomain* result;
	GVirConfigDomain* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_domain_config;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
boxes_libvirt_media_set_domain_config (BoxesLibvirtMedia* self,
                                       GVirConfigDomain* value)
{
	GVirConfigDomain* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_libvirt_media_get_domain_config (self);
	if (old_value != value) {
		GVirConfigDomain* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_domain_config);
		self->priv->_domain_config = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_libvirt_media_properties[BOXES_LIBVIRT_MEDIA_DOMAIN_CONFIG_PROPERTY]);
	}
}

static void
boxes_libvirt_media_class_init (BoxesLibvirtMediaClass * klass,
                                gpointer klass_data)
{
	boxes_libvirt_media_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesLibvirtMedia_private_offset);
	((BoxesInstallerMediaClass *) klass)->get_vm_creator = (BoxesVMCreator* (*) (BoxesInstallerMedia*)) boxes_libvirt_media_real_get_vm_creator;
	BOXES_INSTALLER_MEDIA_CLASS (klass)->get_prefers_q35 = (gboolean (*) (BoxesInstallerMedia*)) boxes_libvirt_media_real_get_prefers_q35;
	BOXES_INSTALLER_MEDIA_CLASS (klass)->get_architecture = (gchar* (*) (BoxesInstallerMedia*)) boxes_libvirt_media_real_get_architecture;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_libvirt_media_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_libvirt_media_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_libvirt_media_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_LIBVIRT_MEDIA_PREFERS_Q35_PROPERTY, boxes_libvirt_media_properties[BOXES_LIBVIRT_MEDIA_PREFERS_Q35_PROPERTY] = g_param_spec_boolean ("prefers-q35", "prefers-q35", "prefers-q35", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_LIBVIRT_MEDIA_ARCHITECTURE_PROPERTY, boxes_libvirt_media_properties[BOXES_LIBVIRT_MEDIA_ARCHITECTURE_PROPERTY] = g_param_spec_string ("architecture", "architecture", "architecture", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_LIBVIRT_MEDIA_DOMAIN_CONFIG_PROPERTY, boxes_libvirt_media_properties[BOXES_LIBVIRT_MEDIA_DOMAIN_CONFIG_PROPERTY] = g_param_spec_object ("domain-config", "domain-config", "domain-config", gvir_config_domain_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
boxes_libvirt_media_instance_init (BoxesLibvirtMedia * self,
                                   gpointer klass)
{
	self->priv = boxes_libvirt_media_get_instance_private (self);
}

static void
boxes_libvirt_media_finalize (GObject * obj)
{
	BoxesLibvirtMedia * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMedia);
	_g_object_unref0 (self->priv->_domain_config);
	G_OBJECT_CLASS (boxes_libvirt_media_parent_class)->finalize (obj);
}

static GType
boxes_libvirt_media_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesLibvirtMediaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_libvirt_media_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesLibvirtMedia), 0, (GInstanceInitFunc) boxes_libvirt_media_instance_init, NULL };
	GType boxes_libvirt_media_type_id;
	boxes_libvirt_media_type_id = g_type_register_static (BOXES_TYPE_INSTALLED_MEDIA, "BoxesLibvirtMedia", &g_define_type_info, 0);
	BoxesLibvirtMedia_private_offset = g_type_add_instance_private (boxes_libvirt_media_type_id, sizeof (BoxesLibvirtMediaPrivate));
	return boxes_libvirt_media_type_id;
}

GType
boxes_libvirt_media_get_type (void)
{
	static volatile gsize boxes_libvirt_media_type_id__once = 0;
	if (g_once_init_enter (&boxes_libvirt_media_type_id__once)) {
		GType boxes_libvirt_media_type_id;
		boxes_libvirt_media_type_id = boxes_libvirt_media_get_type_once ();
		g_once_init_leave (&boxes_libvirt_media_type_id__once, boxes_libvirt_media_type_id);
	}
	return boxes_libvirt_media_type_id__once;
}

static void
_vala_boxes_libvirt_media_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BoxesLibvirtMedia * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMedia);
	switch (property_id) {
		case BOXES_LIBVIRT_MEDIA_PREFERS_Q35_PROPERTY:
		g_value_set_boolean (value, boxes_installer_media_get_prefers_q35 ((BoxesInstallerMedia*) self));
		break;
		case BOXES_LIBVIRT_MEDIA_ARCHITECTURE_PROPERTY:
		g_value_take_string (value, boxes_installer_media_get_architecture ((BoxesInstallerMedia*) self));
		break;
		case BOXES_LIBVIRT_MEDIA_DOMAIN_CONFIG_PROPERTY:
		g_value_set_object (value, boxes_libvirt_media_get_domain_config (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_libvirt_media_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BoxesLibvirtMedia * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMedia);
	switch (property_id) {
		case BOXES_LIBVIRT_MEDIA_DOMAIN_CONFIG_PROPERTY:
		boxes_libvirt_media_set_domain_config (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

