/* display.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "common.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;
typedef gint (*BoxesDisplayOpenFDFunc) (gpointer user_data);
enum  {
	BOXES_DISPLAY_0_PROPERTY,
	BOXES_DISPLAY_PROTOCOL_PROPERTY,
	BOXES_DISPLAY_URI_PROPERTY,
	BOXES_DISPLAY_CAN_TRANSFER_FILES_PROPERTY,
	BOXES_DISPLAY_CONFIG_PROPERTY,
	BOXES_DISPLAY_CAN_GRAB_MOUSE_PROPERTY,
	BOXES_DISPLAY_MOUSE_GRABBED_PROPERTY,
	BOXES_DISPLAY_KEYBOARD_GRABBED_PROPERTY,
	BOXES_DISPLAY_IS_GUEST_AGENT_CONNECTED_PROPERTY,
	BOXES_DISPLAY_NEED_PASSWORD_PROPERTY,
	BOXES_DISPLAY_NEED_USERNAME_PROPERTY,
	BOXES_DISPLAY_PASSWORD_PROPERTY,
	BOXES_DISPLAY_USERNAME_PROPERTY,
	BOXES_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* boxes_display_properties[BOXES_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	BOXES_DISPLAY_SHOW_SIGNAL,
	BOXES_DISPLAY_HIDE_SIGNAL,
	BOXES_DISPLAY_DISCONNECTED_SIGNAL,
	BOXES_DISPLAY_GOT_ERROR_SIGNAL,
	BOXES_DISPLAY_NUM_SIGNALS
};
static guint boxes_display_signals[BOXES_DISPLAY_NUM_SIGNALS] = {0};

struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, BoxesDisplayOpenFDFunc open_fd, gpointer open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	void (*transfer_files) (BoxesDisplay* self, GList* uris);
	void (*send_keys) (BoxesDisplay* self, guint* keyvals, gint keyvals_length1);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
	gboolean (*get_can_transfer_files) (BoxesDisplay* self);
};

struct _BoxesDisplayPrivate {
	BoxesBoxConfig* _config;
	gboolean _can_grab_mouse;
	gboolean _mouse_grabbed;
	gboolean _keyboard_grabbed;
	gboolean _is_guest_agent_connected;
	gboolean _need_password;
	gboolean _need_username;
	gchar* _password;
	gchar* _username;
	gint64 started_time;
};

static gint BoxesDisplay_private_offset;
static gpointer boxes_display_parent_class = NULL;

VALA_EXTERN GType boxes_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplay, g_object_unref)
VALA_EXTERN GtkWidget* boxes_display_get_display (BoxesDisplay* self,
                                      gint n);
VALA_EXTERN GdkPixbuf* boxes_display_get_pixbuf (BoxesDisplay* self,
                                     gint n,
                                     GError** error);
VALA_EXTERN void boxes_display_set_enable_audio (BoxesDisplay* self,
                                     gboolean enable);
VALA_EXTERN gboolean boxes_display_should_keep_alive (BoxesDisplay* self);
VALA_EXTERN void boxes_display_connect_it (BoxesDisplay* self,
                               BoxesDisplayOpenFDFunc open_fd,
                               gpointer open_fd_target,
                               GDestroyNotify open_fd_target_destroy_notify,
                               GError** error);
VALA_EXTERN void boxes_display_disconnect_it (BoxesDisplay* self);
VALA_EXTERN void boxes_display_collect_logs (BoxesDisplay* self,
                                 GString* builder);
VALA_EXTERN void boxes_display_transfer_files (BoxesDisplay* self,
                                   GList* uris);
VALA_EXTERN void boxes_display_send_keys (BoxesDisplay* self,
                              guint* keyvals,
                              gint keyvals_length1);
VALA_EXTERN gboolean boxes_display_get_can_transfer_files (BoxesDisplay* self);
VALA_EXTERN void boxes_display_access_finish (BoxesDisplay* self);
static GtkWidget* boxes_display_real_get_display (BoxesDisplay* self,
                                           gint n);
static GdkPixbuf* boxes_display_real_get_pixbuf (BoxesDisplay* self,
                                          gint n,
                                          GError** error);
static void boxes_display_real_set_enable_audio (BoxesDisplay* self,
                                          gboolean enable);
static gboolean boxes_display_real_should_keep_alive (BoxesDisplay* self);
static void boxes_display_real_connect_it (BoxesDisplay* self,
                                    BoxesDisplayOpenFDFunc open_fd,
                                    gpointer open_fd_target,
                                    GDestroyNotify open_fd_target_destroy_notify,
                                    GError** error);
static void boxes_display_real_disconnect_it (BoxesDisplay* self);
static void boxes_display_real_collect_logs (BoxesDisplay* self,
                                      GString* builder);
static void boxes_display_real_transfer_files (BoxesDisplay* self,
                                        GList* uris);
static void boxes_display_real_send_keys (BoxesDisplay* self,
                                   guint* keyvals,
                                   gint keyvals_length1);
VALA_EXTERN void boxes_display_access_start (BoxesDisplay* self);
VALA_EXTERN BoxesBoxConfig* boxes_display_get_config (BoxesDisplay* self);
VALA_EXTERN BoxesDisplay* boxes_display_construct (GType object_type);
VALA_EXTERN const gchar* boxes_display_get_protocol (BoxesDisplay* self);
VALA_EXTERN gchar* boxes_display_get_uri (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_config (BoxesDisplay* self,
                               BoxesBoxConfig* value);
VALA_EXTERN gboolean boxes_display_get_can_grab_mouse (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_can_grab_mouse (BoxesDisplay* self,
                                       gboolean value);
VALA_EXTERN gboolean boxes_display_get_mouse_grabbed (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_mouse_grabbed (BoxesDisplay* self,
                                      gboolean value);
VALA_EXTERN gboolean boxes_display_get_keyboard_grabbed (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_keyboard_grabbed (BoxesDisplay* self,
                                         gboolean value);
VALA_EXTERN gboolean boxes_display_get_is_guest_agent_connected (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_is_guest_agent_connected (BoxesDisplay* self,
                                                 gboolean value);
VALA_EXTERN gboolean boxes_display_get_need_password (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_need_password (BoxesDisplay* self,
                                      gboolean value);
VALA_EXTERN gboolean boxes_display_get_need_username (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_need_username (BoxesDisplay* self,
                                      gboolean value);
VALA_EXTERN const gchar* boxes_display_get_password (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_password (BoxesDisplay* self,
                                 const gchar* value);
VALA_EXTERN const gchar* boxes_display_get_username (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_username (BoxesDisplay* self,
                                 const gchar* value);
static GObject * boxes_display_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void boxes_display_finalize (GObject * obj);
static GType boxes_display_get_type_once (void);
static void _vala_boxes_display_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_boxes_display_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
boxes_display_get_instance_private (BoxesDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesDisplay_private_offset);
}

static GtkWidget*
boxes_display_real_get_display (BoxesDisplay* self,
                                gint n)
{
	g_critical ("Type `%s' does not implement abstract method `boxes_display_get_display'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GtkWidget*
boxes_display_get_display (BoxesDisplay* self,
                           gint n)
{
	BoxesDisplayClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->get_display) {
		return _klass_->get_display (self, n);
	}
	return NULL;
}

static GdkPixbuf*
boxes_display_real_get_pixbuf (BoxesDisplay* self,
                               gint n,
                               GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `boxes_display_get_pixbuf'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GdkPixbuf*
boxes_display_get_pixbuf (BoxesDisplay* self,
                          gint n,
                          GError** error)
{
	BoxesDisplayClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->get_pixbuf) {
		return _klass_->get_pixbuf (self, n, error);
	}
	return NULL;
}

static void
boxes_display_real_set_enable_audio (BoxesDisplay* self,
                                     gboolean enable)
{
	g_critical ("Type `%s' does not implement abstract method `boxes_display_set_enable_audio'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
boxes_display_set_enable_audio (BoxesDisplay* self,
                                gboolean enable)
{
	BoxesDisplayClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->set_enable_audio) {
		_klass_->set_enable_audio (self, enable);
	}
}

static gboolean
boxes_display_real_should_keep_alive (BoxesDisplay* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
boxes_display_should_keep_alive (BoxesDisplay* self)
{
	BoxesDisplayClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->should_keep_alive) {
		return _klass_->should_keep_alive (self);
	}
	return FALSE;
}

static void
boxes_display_real_connect_it (BoxesDisplay* self,
                               BoxesDisplayOpenFDFunc open_fd,
                               gpointer open_fd_target,
                               GDestroyNotify open_fd_target_destroy_notify,
                               GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `boxes_display_connect_it'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
boxes_display_connect_it (BoxesDisplay* self,
                          BoxesDisplayOpenFDFunc open_fd,
                          gpointer open_fd_target,
                          GDestroyNotify open_fd_target_destroy_notify,
                          GError** error)
{
	BoxesDisplayClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->connect_it) {
		_klass_->connect_it (self, open_fd, open_fd_target, open_fd_target_destroy_notify, error);
	}
}

static void
boxes_display_real_disconnect_it (BoxesDisplay* self)
{
	g_critical ("Type `%s' does not implement abstract method `boxes_display_disconnect_it'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
boxes_display_disconnect_it (BoxesDisplay* self)
{
	BoxesDisplayClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->disconnect_it) {
		_klass_->disconnect_it (self);
	}
}

static void
boxes_display_real_collect_logs (BoxesDisplay* self,
                                 GString* builder)
{
	g_return_if_fail (builder != NULL);
}

void
boxes_display_collect_logs (BoxesDisplay* self,
                            GString* builder)
{
	BoxesDisplayClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->collect_logs) {
		_klass_->collect_logs (self, builder);
	}
}

static void
boxes_display_real_transfer_files (BoxesDisplay* self,
                                   GList* uris)
{
}

void
boxes_display_transfer_files (BoxesDisplay* self,
                              GList* uris)
{
	BoxesDisplayClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->transfer_files) {
		_klass_->transfer_files (self, uris);
	}
}

static void
boxes_display_real_send_keys (BoxesDisplay* self,
                              guint* keyvals,
                              gint keyvals_length1)
{
	g_critical ("Type `%s' does not implement abstract method `boxes_display_send_keys'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
boxes_display_send_keys (BoxesDisplay* self,
                         guint* keyvals,
                         gint keyvals_length1)
{
	BoxesDisplayClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->send_keys) {
		_klass_->send_keys (self, keyvals, keyvals_length1);
	}
}

void
boxes_display_access_start (BoxesDisplay* self)
{
	BoxesBoxConfig* _tmp0_;
	BoxesBoxConfig* _tmp1_;
	BoxesBoxConfig* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	BoxesBoxConfig* _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	g_return_if_fail (self != NULL);
	if (self->priv->started_time != ((gint64) 0)) {
		return;
	}
	self->priv->started_time = g_get_monotonic_time ();
	_tmp0_ = self->priv->_config;
	boxes_box_config_set_access_last_time (_tmp0_, g_get_real_time ());
	_tmp1_ = self->priv->_config;
	_tmp2_ = self->priv->_config;
	_tmp3_ = boxes_box_config_get_access_ntimes (_tmp2_);
	_tmp4_ = _tmp3_;
	boxes_box_config_set_access_ntimes (_tmp2_, _tmp4_ + 1);
	_tmp5_ = self->priv->_config;
	_tmp6_ = boxes_box_config_get_access_first_time (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == ((gint64) 0)) {
		BoxesBoxConfig* _tmp8_;
		BoxesBoxConfig* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
		_tmp8_ = self->priv->_config;
		_tmp9_ = self->priv->_config;
		_tmp10_ = boxes_box_config_get_access_last_time (_tmp9_);
		_tmp11_ = _tmp10_;
		boxes_box_config_set_access_first_time (_tmp8_, _tmp11_);
	}
}

void
boxes_display_access_finish (BoxesDisplay* self)
{
	gint64 duration = 0LL;
	BoxesBoxConfig* _tmp0_;
	BoxesBoxConfig* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->started_time == ((gint64) 0)) {
		return;
	}
	duration = g_get_monotonic_time () - self->priv->started_time;
	duration /= (gint64) 1000000;
	_tmp0_ = self->priv->_config;
	_tmp1_ = self->priv->_config;
	_tmp2_ = boxes_box_config_get_access_total_time (_tmp1_);
	_tmp3_ = _tmp2_;
	boxes_box_config_set_access_total_time (_tmp1_, _tmp3_ + duration);
	self->priv->started_time = (gint64) 0;
}

BoxesDisplay*
boxes_display_construct (GType object_type)
{
	BoxesDisplay * self = NULL;
	self = (BoxesDisplay*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
boxes_display_get_protocol (BoxesDisplay* self)
{
	BoxesDisplayClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->get_protocol) {
		return _klass_->get_protocol (self);
	}
	return NULL;
}

gchar*
boxes_display_get_uri (BoxesDisplay* self)
{
	BoxesDisplayClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->get_uri) {
		return _klass_->get_uri (self);
	}
	return NULL;
}

gboolean
boxes_display_get_can_transfer_files (BoxesDisplay* self)
{
	BoxesDisplayClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BOXES_DISPLAY_GET_CLASS (self);
	if (_klass_->get_can_transfer_files) {
		return _klass_->get_can_transfer_files (self);
	}
	return FALSE;
}

static gboolean
boxes_display_real_get_can_transfer_files (BoxesDisplay* base)
{
	gboolean result;
	BoxesDisplay* self;
	self = base;
	result = FALSE;
	return result;
}

BoxesBoxConfig*
boxes_display_get_config (BoxesDisplay* self)
{
	BoxesBoxConfig* result;
	BoxesBoxConfig* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_config;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
boxes_display_set_config (BoxesDisplay* self,
                          BoxesBoxConfig* value)
{
	BoxesBoxConfig* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_config (self);
	if (old_value != value) {
		BoxesBoxConfig* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_config);
		self->priv->_config = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_CONFIG_PROPERTY]);
	}
}

gboolean
boxes_display_get_can_grab_mouse (BoxesDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_grab_mouse;
	return result;
}

void
boxes_display_set_can_grab_mouse (BoxesDisplay* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_can_grab_mouse (self);
	if (old_value != value) {
		self->priv->_can_grab_mouse = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_CAN_GRAB_MOUSE_PROPERTY]);
	}
}

gboolean
boxes_display_get_mouse_grabbed (BoxesDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mouse_grabbed;
	return result;
}

void
boxes_display_set_mouse_grabbed (BoxesDisplay* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_mouse_grabbed (self);
	if (old_value != value) {
		self->priv->_mouse_grabbed = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_MOUSE_GRABBED_PROPERTY]);
	}
}

gboolean
boxes_display_get_keyboard_grabbed (BoxesDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_keyboard_grabbed;
	return result;
}

void
boxes_display_set_keyboard_grabbed (BoxesDisplay* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_keyboard_grabbed (self);
	if (old_value != value) {
		self->priv->_keyboard_grabbed = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_KEYBOARD_GRABBED_PROPERTY]);
	}
}

gboolean
boxes_display_get_is_guest_agent_connected (BoxesDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_guest_agent_connected;
	return result;
}

void
boxes_display_set_is_guest_agent_connected (BoxesDisplay* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_is_guest_agent_connected (self);
	if (old_value != value) {
		self->priv->_is_guest_agent_connected = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_IS_GUEST_AGENT_CONNECTED_PROPERTY]);
	}
}

gboolean
boxes_display_get_need_password (BoxesDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_need_password;
	return result;
}

void
boxes_display_set_need_password (BoxesDisplay* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_need_password (self);
	if (old_value != value) {
		self->priv->_need_password = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_NEED_PASSWORD_PROPERTY]);
	}
}

gboolean
boxes_display_get_need_username (BoxesDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_need_username;
	return result;
}

void
boxes_display_set_need_username (BoxesDisplay* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_need_username (self);
	if (old_value != value) {
		self->priv->_need_username = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_NEED_USERNAME_PROPERTY]);
	}
}

const gchar*
boxes_display_get_password (BoxesDisplay* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_password;
	result = _tmp0_;
	return result;
}

void
boxes_display_set_password (BoxesDisplay* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_password (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_password);
		self->priv->_password = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_PASSWORD_PROPERTY]);
	}
}

const gchar*
boxes_display_get_username (BoxesDisplay* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_username;
	result = _tmp0_;
	return result;
}

void
boxes_display_set_username (BoxesDisplay* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_get_username (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_username);
		self->priv->_username = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_properties[BOXES_DISPLAY_USERNAME_PROPERTY]);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
boxes_display_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesDisplay * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (boxes_display_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DISPLAY, BoxesDisplay);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->displays);
	self->displays = _tmp2_;
	return obj;
}

static void
boxes_display_class_init (BoxesDisplayClass * klass,
                          gpointer klass_data)
{
	boxes_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesDisplay_private_offset);
	((BoxesDisplayClass *) klass)->get_display = (GtkWidget* (*) (BoxesDisplay*, gint)) boxes_display_real_get_display;
	((BoxesDisplayClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (BoxesDisplay*, gint, GError**)) boxes_display_real_get_pixbuf;
	((BoxesDisplayClass *) klass)->set_enable_audio = (void (*) (BoxesDisplay*, gboolean)) boxes_display_real_set_enable_audio;
	((BoxesDisplayClass *) klass)->should_keep_alive = (gboolean (*) (BoxesDisplay*)) boxes_display_real_should_keep_alive;
	((BoxesDisplayClass *) klass)->connect_it = (void (*) (BoxesDisplay*, BoxesDisplayOpenFDFunc, gpointer, GDestroyNotify, GError**)) boxes_display_real_connect_it;
	((BoxesDisplayClass *) klass)->disconnect_it = (void (*) (BoxesDisplay*)) boxes_display_real_disconnect_it;
	((BoxesDisplayClass *) klass)->collect_logs = (void (*) (BoxesDisplay*, GString*)) boxes_display_real_collect_logs;
	((BoxesDisplayClass *) klass)->transfer_files = (void (*) (BoxesDisplay*, GList*)) boxes_display_real_transfer_files;
	((BoxesDisplayClass *) klass)->send_keys = (void (*) (BoxesDisplay*, guint*, gint)) boxes_display_real_send_keys;
	BOXES_DISPLAY_CLASS (klass)->get_can_transfer_files = (gboolean (*) (BoxesDisplay*)) boxes_display_real_get_can_transfer_files;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_display_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_display_set_property;
	G_OBJECT_CLASS (klass)->constructor = boxes_display_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_PROTOCOL_PROPERTY, boxes_display_properties[BOXES_DISPLAY_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_URI_PROPERTY, boxes_display_properties[BOXES_DISPLAY_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_CAN_TRANSFER_FILES_PROPERTY, boxes_display_properties[BOXES_DISPLAY_CAN_TRANSFER_FILES_PROPERTY] = g_param_spec_boolean ("can-transfer-files", "can-transfer-files", "can-transfer-files", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_CONFIG_PROPERTY, boxes_display_properties[BOXES_DISPLAY_CONFIG_PROPERTY] = g_param_spec_object ("config", "config", "config", BOXES_TYPE_BOX_CONFIG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_CAN_GRAB_MOUSE_PROPERTY, boxes_display_properties[BOXES_DISPLAY_CAN_GRAB_MOUSE_PROPERTY] = g_param_spec_boolean ("can-grab-mouse", "can-grab-mouse", "can-grab-mouse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_MOUSE_GRABBED_PROPERTY, boxes_display_properties[BOXES_DISPLAY_MOUSE_GRABBED_PROPERTY] = g_param_spec_boolean ("mouse-grabbed", "mouse-grabbed", "mouse-grabbed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_KEYBOARD_GRABBED_PROPERTY, boxes_display_properties[BOXES_DISPLAY_KEYBOARD_GRABBED_PROPERTY] = g_param_spec_boolean ("keyboard-grabbed", "keyboard-grabbed", "keyboard-grabbed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_IS_GUEST_AGENT_CONNECTED_PROPERTY, boxes_display_properties[BOXES_DISPLAY_IS_GUEST_AGENT_CONNECTED_PROPERTY] = g_param_spec_boolean ("is-guest-agent-connected", "is-guest-agent-connected", "is-guest-agent-connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_NEED_PASSWORD_PROPERTY, boxes_display_properties[BOXES_DISPLAY_NEED_PASSWORD_PROPERTY] = g_param_spec_boolean ("need-password", "need-password", "need-password", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_NEED_USERNAME_PROPERTY, boxes_display_properties[BOXES_DISPLAY_NEED_USERNAME_PROPERTY] = g_param_spec_boolean ("need-username", "need-username", "need-username", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_PASSWORD_PROPERTY, boxes_display_properties[BOXES_DISPLAY_PASSWORD_PROPERTY] = g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_USERNAME_PROPERTY, boxes_display_properties[BOXES_DISPLAY_USERNAME_PROPERTY] = g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	boxes_display_signals[BOXES_DISPLAY_SHOW_SIGNAL] = g_signal_new ("show", BOXES_TYPE_DISPLAY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	boxes_display_signals[BOXES_DISPLAY_HIDE_SIGNAL] = g_signal_new ("hide", BOXES_TYPE_DISPLAY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	boxes_display_signals[BOXES_DISPLAY_DISCONNECTED_SIGNAL] = g_signal_new ("disconnected", BOXES_TYPE_DISPLAY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	boxes_display_signals[BOXES_DISPLAY_GOT_ERROR_SIGNAL] = g_signal_new ("got-error", BOXES_TYPE_DISPLAY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
boxes_display_instance_init (BoxesDisplay * self,
                             gpointer klass)
{
	self->priv = boxes_display_get_instance_private (self);
}

static void
boxes_display_finalize (GObject * obj)
{
	BoxesDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DISPLAY, BoxesDisplay);
	boxes_display_access_finish (self);
	_g_object_unref0 (self->priv->_config);
	_g_free0 (self->priv->_password);
	_g_free0 (self->priv->_username);
	_g_hash_table_unref0 (self->displays);
	G_OBJECT_CLASS (boxes_display_parent_class)->finalize (obj);
}

static GType
boxes_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDisplay), 0, (GInstanceInitFunc) boxes_display_instance_init, NULL };
	GType boxes_display_type_id;
	boxes_display_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesDisplay", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BoxesDisplay_private_offset = g_type_add_instance_private (boxes_display_type_id, sizeof (BoxesDisplayPrivate));
	return boxes_display_type_id;
}

GType
boxes_display_get_type (void)
{
	static volatile gsize boxes_display_type_id__once = 0;
	if (g_once_init_enter (&boxes_display_type_id__once)) {
		GType boxes_display_type_id;
		boxes_display_type_id = boxes_display_get_type_once ();
		g_once_init_leave (&boxes_display_type_id__once, boxes_display_type_id);
	}
	return boxes_display_type_id__once;
}

static void
_vala_boxes_display_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	BoxesDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_DISPLAY, BoxesDisplay);
	switch (property_id) {
		case BOXES_DISPLAY_CAN_TRANSFER_FILES_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_can_transfer_files (self));
		break;
		case BOXES_DISPLAY_CONFIG_PROPERTY:
		g_value_set_object (value, boxes_display_get_config (self));
		break;
		case BOXES_DISPLAY_CAN_GRAB_MOUSE_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_can_grab_mouse (self));
		break;
		case BOXES_DISPLAY_MOUSE_GRABBED_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_mouse_grabbed (self));
		break;
		case BOXES_DISPLAY_KEYBOARD_GRABBED_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_keyboard_grabbed (self));
		break;
		case BOXES_DISPLAY_IS_GUEST_AGENT_CONNECTED_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_is_guest_agent_connected (self));
		break;
		case BOXES_DISPLAY_NEED_PASSWORD_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_need_password (self));
		break;
		case BOXES_DISPLAY_NEED_USERNAME_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_need_username (self));
		break;
		case BOXES_DISPLAY_PASSWORD_PROPERTY:
		g_value_set_string (value, boxes_display_get_password (self));
		break;
		case BOXES_DISPLAY_USERNAME_PROPERTY:
		g_value_set_string (value, boxes_display_get_username (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_display_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	BoxesDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_DISPLAY, BoxesDisplay);
	switch (property_id) {
		case BOXES_DISPLAY_CONFIG_PROPERTY:
		boxes_display_set_config (self, g_value_get_object (value));
		break;
		case BOXES_DISPLAY_CAN_GRAB_MOUSE_PROPERTY:
		boxes_display_set_can_grab_mouse (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_MOUSE_GRABBED_PROPERTY:
		boxes_display_set_mouse_grabbed (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_KEYBOARD_GRABBED_PROPERTY:
		boxes_display_set_keyboard_grabbed (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_IS_GUEST_AGENT_CONNECTED_PROPERTY:
		boxes_display_set_is_guest_agent_connected (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_NEED_PASSWORD_PROPERTY:
		boxes_display_set_need_password (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_NEED_USERNAME_PROPERTY:
		boxes_display_set_need_username (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_PASSWORD_PROPERTY:
		boxes_display_set_password (self, g_value_get_string (value));
		break;
		case BOXES_DISPLAY_USERNAME_PROPERTY:
		boxes_display_set_username (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

