/* do not edit automatically generated by mc from m2type.  */
/* m2type.def definition module for m2type.cc.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_m2type_H)
#   define _m2type_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "Ggcctypes.h"
#   include "GCDataTypes.h"

#   if defined (_m2type_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

typedef void *m2type_Constructor;


/*
   ValueInTypeRange - returns TRUE if the constant, value, lies in the range
                      of, type.
*/

EXTERN bool m2type_ValueInTypeRange (tree type, tree value);

/*
   ValueOutOfTypeRange - returns TRUE if the constant, value, exceed the range
                         of, type.
*/

EXTERN bool m2type_ValueOutOfTypeRange (tree type, tree value);

/*
   ExceedsTypeRange - return TRUE if low or high exceed the range of, type.
*/

EXTERN bool m2type_ExceedsTypeRange (tree type, tree low, tree high);

/*
   WithinTypeRange - return TRUE if low and high are within the range of, type.
*/

EXTERN bool m2type_WithinTypeRange (tree type, tree low, tree high);

/*
    BuildSubrangeType - creates a subrange of, type, with, lowval, highval.
*/

EXTERN tree m2type_BuildSubrangeType (location_t location, char * name, tree type, tree lowval, tree highval);

/*
    BuildCharConstant - creates a character constant given a, string.
*/

EXTERN tree m2type_BuildCharConstant (location_t location, const char * string);

/*
   BuildCharConstantChar - creates a character constant given a character, ch.
*/

EXTERN tree m2type_BuildCharConstantChar (location_t location, char ch);

/*
    BuildArrayConstructorElement - adds, value, to the constructor_element_list.
*/

EXTERN void m2type_BuildArrayConstructorElement (void * p, tree value, tree indice);

/*
    BuildEndArrayConstructor - returns a tree containing the array
                               compound literal.
*/

EXTERN tree m2type_BuildEndArrayConstructor (m2type_Constructor p);
EXTERN m2type_Constructor m2type_BuildStartArrayConstructor (tree type);

/*
    BuildRecordConstructorElement - adds, value, to the constructor_element_list.
*/

EXTERN void m2type_BuildRecordConstructorElement (m2type_Constructor p, tree value);

/*
    BuildEndRecordConstructor - returns a tree containing the record compound literal.
*/

EXTERN tree m2type_BuildEndRecordConstructor (m2type_Constructor p);

/*
   BuildStartRecordConstructor - initializes a record compound
                                 constructor frame.
*/

EXTERN m2type_Constructor m2type_BuildStartRecordConstructor (tree type);

/*
    BuildEndSetConstructor - finishes building a set constant.
*/

EXTERN tree m2type_BuildEndSetConstructor (m2type_Constructor p);

/*
    BuildSetConstructorElement - adds, value, to the constructor_element_list.
*/

EXTERN void m2type_BuildSetConstructorElement (m2type_Constructor p, tree value);

/*
   BuildStartSetConstructor - starts to create a set constant.
                              Remember that type is really a record type.
*/

EXTERN m2type_Constructor m2type_BuildStartSetConstructor (tree type);

/*
    BuildSetType - creates a SET OF [lowval..highval]
*/

EXTERN tree m2type_BuildSetType (location_t location, char * name, tree type, tree lowval, tree highval, bool ispacked);

/*
    BuildConstPointerType - returns a type which is a const pointer to, totype.
*/

EXTERN tree m2type_BuildConstPointerType (tree totype);

/*
    BuildPointerType - returns a type which is a pointer to, totype.
*/

EXTERN tree m2type_BuildPointerType (tree totype);

/*
    BuildEnumerator - build an enumerator and add it to the, enumvalues, list.
                      It returns a copy of the value.  --fixme-- why do this?
*/

EXTERN tree m2type_BuildEnumerator (location_t location, char * name, tree value, tree *enumvalues);

/*
    BuildEndEnumeration - finish building the enumeration, it uses the enum
                          list, enumvalues, and returns a enumeration type tree.
*/

EXTERN tree m2type_BuildEndEnumeration (location_t location, tree type, tree enumvalues);

/*
    BuildStartEnumeration - create an enumerated type in gcc.
*/

EXTERN tree m2type_BuildStartEnumeration (location_t location, char * name, bool ispacked);

/*
    BuildTypeDeclaration - adds the, type, to the current statement list.
*/

EXTERN void m2type_BuildTypeDeclaration (location_t location, tree type);

/*
    GetMaxFrom - given a, type, return a constant representing the maximum
                 legal value.
*/

EXTERN tree m2type_GetMaxFrom (location_t location, tree type);

/*
    GetMinFrom - given a, type, return a constant representing the minimum
                 legal value.
*/

EXTERN tree m2type_GetMinFrom (location_t location, tree type);

/*
    GetDefaultType - given a, type, with a, name, return a GCC declaration of this type.
                     Checks to see whether the type name has already been declared as a
                     default type and if so it returns this declaration. Otherwise it
                     declares the type. In Modula-2 this is equivalent to:

                     TYPE
                        name = type ;

                     We need this function as the initialization to gccgm2.c will
                     declare C default types and _some_ M2 default types.
*/

EXTERN tree m2type_GetDefaultType (location_t location, char * name, tree type);

/*
    BuildEndType - finish declaring, type, and return, type.
*/

EXTERN tree m2type_BuildEndType (location_t location, tree type);

/*
    BuildStartType - given a, type, with a, name, return a GCC declaration of this type.
                     TYPE
                        name = foo ;

                     the type, foo, maybe a partially created type (which has
                     yet to be 'gm2_finish_decl'ed.
*/

EXTERN tree m2type_BuildStartType (location_t location, char * name, tree type);

/*
   InitSystemTypes -
*/

EXTERN void m2type_InitSystemTypes (location_t location, int loc);

/*
   InitBaseTypes -
*/

EXTERN void m2type_InitBaseTypes (location_t location);

/*
    BuildVariableArrayAndDeclare - creates a variable length array.
                                   high is the maximum legal elements (which is a runtime variable).
                                   This creates and array index, array type and local variable.
*/

EXTERN tree m2type_BuildVariableArrayAndDeclare (location_t location, tree elementtype, tree high, char * name, tree scope);

/*
    InitFunctionTypeParameters - resets the current function type parameter list.
*/

EXTERN void m2type_InitFunctionTypeParameters (void);

/*
   BuildProcTypeParameterDeclaration - creates and returns one parameter from, name, and, type.
                                       It appends this parameter to the internal param_type_list.
*/

EXTERN tree m2type_BuildProcTypeParameterDeclaration (location_t location, tree type, bool isreference);

/*
    BuildStartFunctionType - creates a pointer type, necessary to
                             create a function type.
*/

EXTERN tree m2type_BuildStartFunctionType (location_t location, char * name);

/*
    BuildEndFunctionType - build a function type which would return a, value.
                           The arguments have been created by BuildParameterDeclaration.
*/

EXTERN tree m2type_BuildEndFunctionType (tree func, tree type, bool usesvarags);

/*
    GetTreeType - returns TREE_TYPE (t).
*/

EXTERN tree m2type_GetTreeType (tree type);

/*
    DeclareKnownType - given a, type, with a, name, return a GCC declaration of this type.
                       TYPE
                          name = foo ;
*/

EXTERN tree m2type_DeclareKnownType (location_t location, char * name, tree type);

/*
    GetM2ZType - return the ISO Z data type, the longest int datatype.
*/

EXTERN tree m2type_GetM2ZType (void);

/*
    GetM2RType - return the ISO R data type, the longest real datatype.
*/

EXTERN tree m2type_GetM2RType (void);

/*
    BuildSetTypeFromSubrange - constructs a set type from a subrangeType.
*/

EXTERN tree m2type_BuildSetTypeFromSubrange (location_t location, char * name, tree subrangeType, tree lowval, tree highval, bool ispacked);

/*
    BuildSmallestTypeRange - returns the smallest INTEGER_TYPE which is
                             sufficient to contain values: low..high.
*/

EXTERN tree m2type_BuildSmallestTypeRange (location_t location, tree low, tree high);

/*
    GetBooleanType -
*/

EXTERN tree m2type_GetBooleanType (void);

/*
    GetBooleanFalse -
*/

EXTERN tree m2type_GetBooleanFalse (void);

/*
    GetBooleanTrue -
*/

EXTERN tree m2type_GetBooleanTrue (void);

/*
    GetPackedBooleanType - return the packed boolean data type node.
*/

EXTERN tree m2type_GetPackedBooleanType (void);

/*
    GetCharType - return the char type node.
*/

EXTERN tree m2type_GetCharType (void);

/*
    GetByteType - return the byte type node.
*/

EXTERN tree m2type_GetByteType (void);

/*
    GetVoidType - return the C void type.
*/

EXTERN tree m2type_GetVoidType (void);

/*
    GetBitnumType - return the ISO bitnum type.
*/

EXTERN tree m2type_GetBitnumType (void);

/*
    GetRealType -
*/

EXTERN tree m2type_GetRealType (void);

/*
    GetLongRealType - return the C long double data type.
*/

EXTERN tree m2type_GetLongRealType (void);

/*
    GetShortRealType - return the C float data type.
*/

EXTERN tree m2type_GetShortRealType (void);

/*
    GetLongIntType - return the C long int data type.
*/

EXTERN tree m2type_GetLongIntType (void);

/*
    GetPointerType - return the GCC ptr type node.  Equivalent to (void * ).
*/

EXTERN tree m2type_GetPointerType (void);

/*
    GetCardinalType - return the cardinal type.
*/

EXTERN tree m2type_GetCardinalType (void);

/*
    GetIntegerType - return the integer type node.
*/

EXTERN tree m2type_GetIntegerType (void);

/*
    GetWordType - return the C unsigned data type.
*/

EXTERN tree m2type_GetWordType (void);

/*
    GetM2CardinalType - return the m2 cardinal data type.
*/

EXTERN tree m2type_GetM2CardinalType (void);

/*
    GetBitsetType - return the bitset type.
*/

EXTERN tree m2type_GetBitsetType (void);

/*
    GetM2CType - a test function.
*/

EXTERN tree m2type_GetM2CType (void);

/*
    GetProcType - return the m2 proc data type.
*/

EXTERN tree m2type_GetProcType (void);

/*
    GetM2ComplexType - return the complex type.
*/

EXTERN tree m2type_GetM2ComplexType (void);

/*
    GetM2LongComplexType - return the long complex type.
*/

EXTERN tree m2type_GetM2LongComplexType (void);

/*
    GetM2ShortComplexType - return the short complex type.
*/

EXTERN tree m2type_GetM2ShortComplexType (void);

/*
    GetM2Complex128Type - return the fixed size complex type.
*/

EXTERN tree m2type_GetM2Complex128 (void);

/*
    GetM2Complex96 - return the fixed size complex type.
*/

EXTERN tree m2type_GetM2Complex96 (void);

/*
    GetM2Complex64 - return the fixed size complex type.
*/

EXTERN tree m2type_GetM2Complex64 (void);

/*
    GetM2Complex32 - return the fixed size complex type.
*/

EXTERN tree m2type_GetM2Complex32 (void);

/*
    GetM2Real128 - return the real 128 bit type.
*/

EXTERN tree m2type_GetM2Real128 (void);

/*
    GetM2Real96 - return the real 96 bit type.
*/

EXTERN tree m2type_GetM2Real96 (void);

/*
    GetM2Real64 - return the real 64 bit type.
*/

EXTERN tree m2type_GetM2Real64 (void);

/*
    GetM2Real32 - return the real 32 bit type.
*/

EXTERN tree m2type_GetM2Real32 (void);

/*
    GetM2Bitset32 - return the bitset 32 bit type.
*/

EXTERN tree m2type_GetM2Bitset32 (void);

/*
    GetM2Bitset16 - return the bitset 16 bit type.
*/

EXTERN tree m2type_GetM2Bitset16 (void);

/*
    GetM2Bitset8 - return the bitset 8 bit type.
*/

EXTERN tree m2type_GetM2Bitset8 (void);

/*
    GetM2Word64 - return the word 64 bit type.
*/

EXTERN tree m2type_GetM2Word64 (void);

/*
    GetM2Word32 - return the word 32 bit type.
*/

EXTERN tree m2type_GetM2Word32 (void);

/*
    GetM2Word16 - return the word 16 bit type.
*/

EXTERN tree m2type_GetM2Word16 (void);

/*
    GetM2Cardinal64 - return the cardinal 64 bit type.
*/

EXTERN tree m2type_GetM2Cardinal64 (void);

/*
    GetM2Cardinal32 - return the cardinal 32 bit type.
*/

EXTERN tree m2type_GetM2Cardinal32 (void);

/*
    GetM2Cardinal16 - return the cardinal 16 bit type.
*/

EXTERN tree m2type_GetM2Cardinal16 (void);

/*
    GetM2Cardinal8 - return the cardinal 8 bit type.
*/

EXTERN tree m2type_GetM2Cardinal8 (void);

/*
    GetM2Integer64 - return the integer 64 bit type.
*/

EXTERN tree m2type_GetM2Integer64 (void);

/*
    GetM2Integer32 - return the integer 32 bit type.
*/

EXTERN tree m2type_GetM2Integer32 (void);

/*
    GetM2Integer16 - return the integer 16 bit type.
*/

EXTERN tree m2type_GetM2Integer16 (void);

/*
    GetM2Integer8 - return the integer 8 bit type.
*/

EXTERN tree m2type_GetM2Integer8 (void);

/*
    GetISOLocType - return the m2 loc word data type.
*/

EXTERN tree m2type_GetISOLocType (void);

/*
    GetISOByteType - return the m2 iso byte data type.
*/

EXTERN tree m2type_GetISOByteType (void);

/*
    GetISOWordType - return the m2 iso word data type.
*/

EXTERN tree m2type_GetISOWordType (void);

/*
    GetShortCardType - return the C short unsigned data type.
*/

EXTERN tree m2type_GetShortCardType (void);

/*
    GetM2ShortCardType - return the m2 short cardinal data type.
*/

EXTERN tree m2type_GetM2ShortCardType (void);

/*
    GetShortIntType - return the C short int data type.
*/

EXTERN tree m2type_GetShortIntType (void);

/*
    GetM2ShortIntType - return the m2 short integer data type.
*/

EXTERN tree m2type_GetM2ShortIntType (void);

/*
    GetM2LongCardType - return the m2 long cardinal data type.
*/

EXTERN tree m2type_GetM2LongCardType (void);

/*
    GetM2LongIntType - return the m2 long integer data type.
*/

EXTERN tree m2type_GetM2LongIntType (void);

/*
    GetM2LongRealType - return the m2 long real data type.
*/

EXTERN tree m2type_GetM2LongRealType (void);

/*
    GetM2RealType - return the m2 real data type.
*/

EXTERN tree m2type_GetM2RealType (void);

/*
    GetM2ShortRealType - return the m2 short real data type.
*/

EXTERN tree m2type_GetM2ShortRealType (void);

/*
    GetM2IntegerType - return the m2 integer data type.
*/

EXTERN tree m2type_GetM2IntegerType (void);

/*
    GetM2CharType - return the m2 char data type.
*/

EXTERN tree m2type_GetM2CharType (void);

/*
   GetCSizeTType - return a type representing size_t.
*/

EXTERN tree m2type_GetCSizeTType (void);

/*
   GetCSSizeTType - return a type representing ssize_t.
*/

EXTERN tree m2type_GetCSSizeTType (void);

/*
   GetCOffTType - return a type representing OFF_T.
*/

EXTERN tree m2type_GetCOffTType (void);

/*
    BuildArrayStringConstructor - creates an array constructor for, arrayType,
                                  consisting of the character elements
                                  defined by, str, of, length, characters.
*/

EXTERN tree m2type_BuildArrayStringConstructor (location_t location, tree arrayType, tree str, tree length);

/*
    RealToTree - convert a real number into a Tree.
*/

EXTERN tree m2type_RealToTree (char * name);

/*
    BuildStartRecord - return a RECORD tree.
*/

EXTERN tree m2type_BuildStartRecord (location_t location, char * name);

/*
    BuildStartUnion - return a union tree.
*/

EXTERN tree m2type_BuildStartUnion (location_t location, char * name);

/*
    BuildStartUnion - return a union tree.
*/

EXTERN tree m2type_BuildStartVarient (location_t location, char * name);

/*
    BuildStartUnion - return a union tree.
*/

EXTERN tree m2type_BuildEndVarient (location_t location, tree varientField, tree varientList, bool isPacked);

/*
    BuildStartUnion - return a union tree.
*/

EXTERN tree m2type_BuildStartFieldVarient (location_t location, char * name);

/*
    BuildStartUnion - return a union tree.
*/

EXTERN tree m2type_BuildEndFieldVarient (location_t location, tree varientField, tree varientList, bool isPacked);

/*
    BuildStartUnion - return a union tree.
*/

EXTERN tree m2type_BuildStartFieldRecord (location_t location, char * name, tree type);

/*
    BuildStartUnion - return a union tree.
*/

EXTERN tree m2type_BuildFieldRecord (location_t location, char * name, tree type);

/*
    ChainOn - interface so that Modula-2 can also create chains of
              declarations.
*/

EXTERN tree m2type_ChainOn (tree t1, tree t2);

/*
    ChainOnParamValue - adds a list node {{name, str}, value} into the tree list.
*/

EXTERN tree m2type_ChainOnParamValue (tree list, tree name, tree str, tree value);

/*
   AddStringToTreeList - adds, string, to list.
*/

EXTERN tree m2type_AddStringToTreeList (tree list, tree string);

/*
    BuildEndRecord - a heavily pruned finish_struct from c-decl.c.
                     It sets the context for each field to, t,
                     propagates isPacked throughout the fields in
                     the structure.
*/

EXTERN tree m2type_BuildEndRecord (location_t location, tree record, tree fieldlist, bool isPacked);

/*
    SetAlignment - sets the alignment of a, node, to, align.
                   It duplicates the, node, and sets the alignment
                   to prevent alignment effecting behaviour elsewhere.
*/

EXTERN tree m2type_SetAlignment (tree node, tree align);

/*
    SetDeclPacked - sets the packed bit in decl TREE, node.
                    It returns the node.
*/

EXTERN tree m2type_SetDeclPacked (tree node);

/*
    SetTypePacked - sets the packed bit in type TREE, node.
                    It returns the node.
*/

EXTERN tree m2type_SetTypePacked (tree node);

/*
    SetRecordFieldOffset - returns field after the byteOffset and bitOffset
                           has been applied to it.
*/

EXTERN tree m2type_SetRecordFieldOffset (tree field, tree byteOffset, tree bitOffset, tree fieldtype, tree nbits);

/*
    BuildPackedFieldRecord - builds a packed field record of,
                             name, and, fieldtype.
*/

EXTERN tree m2type_BuildPackedFieldRecord (location_t location, char * name, tree fieldtype);

/*
    BuildNumberOfArrayElements - returns the number of elements in an
                                 arrayType.
*/

EXTERN tree m2type_BuildNumberOfArrayElements (location_t location, tree arrayType);

/*
    AddStatement - maps onto add_stmt.
*/

EXTERN void m2type_AddStatement (location_t location, tree t);

/*
    MarkFunctionReferenced - marks a function as referenced.
*/

EXTERN void m2type_MarkFunctionReferenced (tree f);

/*
    GarbageCollect - force gcc to garbage collect.
*/

EXTERN void m2type_GarbageCollect (void);

/*
   BuildArrayIndexType - creates an integer index which accesses an array.
                         low and high are the min, max elements of the array.
*/

EXTERN tree m2type_BuildArrayIndexType (tree low, tree high);

/*
   GetArrayNoOfElements - returns the number of elements in, arraytype.
*/

EXTERN tree m2type_GetArrayNoOfElements (location_t location, tree arraytype);

/*
   BuildEndArrayType - returns a type which is an array indexed by IndexType
                       and which has ElementType elements.
*/

EXTERN tree m2type_BuildEndArrayType (tree arraytype, tree elementtype, tree indextype, int type);

/*
    PutArrayType -
*/

EXTERN void m2type_PutArrayType (tree array, tree type);

/*
    BuildStartArrayType - creates an array with an indextype and elttype.  The front end
                          symbol, type, is also passed to allow the gccgm2 to return the
                          canonical edition of the array type even if the GCC elttype is
                          NULL_TREE.
*/

EXTERN tree m2type_BuildStartArrayType (tree index_type, tree elt_type, int type);

/*
   IsAddress - return TRUE if the type is an ADDRESS.
*/

EXTERN bool m2type_IsAddress (tree type);

/*
   SameRealType - return true if real types a and b are the same.
*/

EXTERN bool m2type_SameRealType (tree a, tree b);

/*
   IsGccStrictTypeEquivalent - return true if left and right and
                               all their contents have the same type.
*/

EXTERN bool m2type_IsGccStrictTypeEquivalent (tree left, tree right);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
