// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package bgp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetBgpRoutePoliciesParams creates a new GetBgpRoutePoliciesParams object
//
// There are no default values defined in the spec.
func NewGetBgpRoutePoliciesParams() GetBgpRoutePoliciesParams {

	return GetBgpRoutePoliciesParams{}
}

// GetBgpRoutePoliciesParams contains all the bound params for the get bgp route policies operation
// typically these are obtained from a http.Request
//
// swagger:parameters GetBgpRoutePolicies
type GetBgpRoutePoliciesParams struct {
	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Autonomous System Number (ASN) identifying a BGP virtual router instance.
	If not specified, all virtual router instances are selected.

	  In: query
	*/
	RouterAsn *int64
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetBgpRoutePoliciesParams() beforehand.
func (o *GetBgpRoutePoliciesParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r
	qs := runtime.Values(r.URL.Query())

	qRouterAsn, qhkRouterAsn, _ := qs.GetOK("router_asn")
	if err := o.bindRouterAsn(qRouterAsn, qhkRouterAsn, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindRouterAsn binds and validates parameter RouterAsn from query.
func (o *GetBgpRoutePoliciesParams) bindRouterAsn(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("router_asn", "query", "int64", raw)
	}
	o.RouterAsn = &value

	return nil
}
