/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#pragma once

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libmalcontent/malcontent.h>

G_BEGIN_DECLS

/**
 * MctFilterUpdaterError:
 * @MCT_FILTER_UPDATER_ERROR_BUSY: Filters are already being updated.
 * @MCT_FILTER_UPDATER_ERROR_DISABLED: Web filtering is disabled for the
 *   specified user.
 * @MCT_FILTER_UPDATER_ERROR_QUERYING_POLICY: Web filtering policy for the
 *   given user was invalid or could not be retrieved.
 * @MCT_FILTER_UPDATER_ERROR_INVALID_FILTER_FORMAT: An input filter list was in
 *   an invalid format.
 * @MCT_FILTER_UPDATER_ERROR_FILE_SYSTEM: A local file operation failed.
 * @MCT_FILTER_UPDATER_ERROR_DOWNLOADING: Failed to download a filter list over
 *   the network.
 *
 * Errors which can be returned by [class@Malcontent.FilterUpdater].
 *
 * Since: 0.14.0
 */
typedef enum
{
  MCT_FILTER_UPDATER_ERROR_BUSY = 0,
  MCT_FILTER_UPDATER_ERROR_DISABLED,
  MCT_FILTER_UPDATER_ERROR_QUERYING_POLICY,
  MCT_FILTER_UPDATER_ERROR_INVALID_FILTER_FORMAT,
  MCT_FILTER_UPDATER_ERROR_FILE_SYSTEM,
  MCT_FILTER_UPDATER_ERROR_DOWNLOADING,
} MctFilterUpdaterError;
#define MCT_FILTER_UPDATER_N_ERRORS (MCT_FILTER_UPDATER_ERROR_DOWNLOADING + 1)

GQuark mct_filter_updater_error_quark (void);
#define MCT_FILTER_UPDATER_ERROR mct_filter_updater_error_quark ()

#define MCT_TYPE_FILTER_UPDATER mct_filter_updater_get_type ()
G_DECLARE_FINAL_TYPE (MctFilterUpdater, mct_filter_updater, MCT,
                      FILTER_UPDATER, GObject)

MctFilterUpdater *mct_filter_updater_new (MctManager     *policy_manager,
                                          MctUserManager *user_manager,
                                          GFile          *state_directory,
                                          GFile          *cache_directory);

void mct_filter_updater_update_filters_async (MctFilterUpdater    *self,
                                              uid_t                uid,
                                              GCancellable        *cancellable,
                                              GAsyncReadyCallback  callback,
                                              void                *user_data);
gboolean mct_filter_updater_update_filters_finish (MctFilterUpdater  *self,
                                                   GAsyncResult      *result,
                                                   GError           **error);

G_END_DECLS
