/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Extension;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.PerMessageDeflate;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationBuilder;

public class TransformationFactory {
    private static final StringManager sm = StringManager.getManager(TransformationFactory.class);
    private static final TransformationFactory factory = new TransformationFactory();
    private Map<String, TransformationBuilder> builders = new HashMap<String, TransformationBuilder>();

    private TransformationFactory() {
        this.builders.put("permessage-deflate", PerMessageDeflate.BUILDER);
    }

    public static TransformationFactory getInstance() {
        return factory;
    }

    public Transformation create(String string, List<List<Extension.Parameter>> list, boolean bl) {
        TransformationBuilder transformationBuilder = this.builders.get(string);
        if (transformationBuilder != null) {
            return transformationBuilder.build(list, bl);
        }
        if (Constants.ALLOW_UNSUPPORTED_EXTENSIONS) {
            return null;
        }
        throw new IllegalArgumentException(sm.getString("transformerFactory.unsupportedExtension", new Object[]{string}));
    }

    public void registerExtension(String string, TransformationBuilder transformationBuilder) {
        this.builders.put(string, transformationBuilder);
    }
}

