/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.mapper;

import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.lucene.search.Query;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.neuralsearch.sparse.mapper.SparseMethodContext;
import org.opensearch.search.lookup.SearchLookup;

public class SparseVectorFieldType
extends MappedFieldType {
    private final SparseMethodContext sparseMethodContext;

    public SparseVectorFieldType(String name, SparseMethodContext sparseMethodContext) {
        super(name, false, false, false, TextSearchInfo.NONE, Map.of());
        this.sparseMethodContext = sparseMethodContext;
    }

    public String typeName() {
        return "sparse_vector";
    }

    public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
        return SourceValueFetcher.identity((String)this.name(), (QueryShardContext)context, (String)format);
    }

    public Query termQuery(Object value, QueryShardContext context) {
        throw new IllegalArgumentException("Queries on [sparse_vector] fields are not supported");
    }

    public Query existsQuery(QueryShardContext context) {
        throw new IllegalArgumentException("[sparse_vector] fields do not support [exists] queries");
    }

    public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        throw new IllegalArgumentException("[sparse_vector] fields do not support sorting, scripting or aggregating");
    }

    public static boolean isSparseVectorType(String type) {
        return "sparse_vector".equals(type);
    }

    @Generated
    public SparseMethodContext getSparseMethodContext() {
        return this.sparseMethodContext;
    }
}

