/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.proc;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.proc.ProcDebugger;
import sun.jvm.hotspot.debugger.proc.ProcOopHandle;

class ProcAddress
implements Address {
    protected ProcDebugger debugger;
    protected long addr;

    ProcAddress(ProcDebugger debugger, long addr) {
        this.debugger = debugger;
        this.addr = addr;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof ProcAddress)) {
            return false;
        }
        return this.addr == ((ProcAddress)arg).addr;
    }

    @Override
    public int hashCode() {
        return (int)this.addr;
    }

    public String toString() {
        return this.debugger.addressValueToString(this.addr);
    }

    @Override
    public long getCIntegerAt(long offset, long numBytes, boolean isUnsigned) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCInteger(this.addr + offset, numBytes, isUnsigned);
    }

    @Override
    public Address getAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readAddress(this.addr + offset);
    }

    @Override
    public Address getCompOopAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCompOopAddress(this.addr + offset);
    }

    @Override
    public Address getCompKlassAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCompKlassAddress(this.addr + offset);
    }

    @Override
    public boolean getJBooleanAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJBoolean(this.addr + offset);
    }

    @Override
    public byte getJByteAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJByte(this.addr + offset);
    }

    @Override
    public char getJCharAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJChar(this.addr + offset);
    }

    @Override
    public double getJDoubleAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJDouble(this.addr + offset);
    }

    @Override
    public float getJFloatAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJFloat(this.addr + offset);
    }

    @Override
    public int getJIntAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJInt(this.addr + offset);
    }

    @Override
    public long getJLongAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJLong(this.addr + offset);
    }

    @Override
    public short getJShortAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJShort(this.addr + offset);
    }

    @Override
    public OopHandle getOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return this.debugger.readOopHandle(this.addr + offset);
    }

    @Override
    public OopHandle getCompOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return this.debugger.readCompOopHandle(this.addr + offset);
    }

    @Override
    public void setCIntegerAt(long offset, long numBytes, long value) {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setAddressAt(long offset, Address value) {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJBooleanAt(long offset, boolean value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJByteAt(long offset, byte value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJCharAt(long offset, char value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJDoubleAt(long offset, double value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJFloatAt(long offset, float value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJIntAt(long offset, int value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJLongAt(long offset, long value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJShortAt(long offset, short value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setOopHandleAt(long offset, OopHandle value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public Address addOffsetTo(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new ProcAddress(this.debugger, value);
    }

    @Override
    public OopHandle addOffsetToAsOopHandle(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new ProcOopHandle(this.debugger, value);
    }

    @Override
    public long minus(Address arg) {
        if (arg == null) {
            return this.addr;
        }
        return this.addr - ((ProcAddress)arg).addr;
    }

    @Override
    public boolean lessThan(Address arg) {
        if (arg == null) {
            return false;
        }
        ProcAddress dbxArg = (ProcAddress)arg;
        if (this.addr >= 0L && dbxArg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && dbxArg.addr >= 0L) {
            return false;
        }
        return this.addr < dbxArg.addr;
    }

    @Override
    public boolean lessThanOrEqual(Address arg) {
        if (arg == null) {
            return false;
        }
        ProcAddress dbxArg = (ProcAddress)arg;
        if (this.addr >= 0L && dbxArg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && dbxArg.addr >= 0L) {
            return false;
        }
        return this.addr <= dbxArg.addr;
    }

    @Override
    public boolean greaterThan(Address arg) {
        if (arg == null) {
            return true;
        }
        ProcAddress dbxArg = (ProcAddress)arg;
        if (this.addr >= 0L && dbxArg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && dbxArg.addr >= 0L) {
            return true;
        }
        return this.addr > dbxArg.addr;
    }

    @Override
    public boolean greaterThanOrEqual(Address arg) {
        if (arg == null) {
            return true;
        }
        ProcAddress dbxArg = (ProcAddress)arg;
        if (this.addr >= 0L && dbxArg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && dbxArg.addr >= 0L) {
            return true;
        }
        return this.addr >= dbxArg.addr;
    }

    @Override
    public Address andWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr & mask;
        if (value == 0L) {
            return null;
        }
        return new ProcAddress(this.debugger, value);
    }

    @Override
    public Address orWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr | mask;
        if (value == 0L) {
            return null;
        }
        return new ProcAddress(this.debugger, value);
    }

    @Override
    public Address xorWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr ^ mask;
        if (value == 0L) {
            return null;
        }
        return new ProcAddress(this.debugger, value);
    }

    long getValue() {
        return this.addr;
    }

    private static void check(boolean arg, String failMessage) {
        if (!arg) {
            System.err.println(failMessage + ": FAILED");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        ProcAddress p1 = new ProcAddress(null, 0x7FFFFFFFFFFFFFF0L);
        ProcAddress p2 = (ProcAddress)p1.addOffsetTo(10L);
        ProcAddress n1 = (ProcAddress)p2.addOffsetTo(10L);
        ProcAddress n2 = (ProcAddress)n1.addOffsetTo(10L);
        ProcAddress.check(p1.lessThan(p2), "lessThan 1");
        ProcAddress.check(p1.lessThan(n1), "lessThan 2");
        ProcAddress.check(p1.lessThan(n2), "lessThan 3");
        ProcAddress.check(p2.lessThan(n1), "lessThan 4");
        ProcAddress.check(p2.lessThan(n2), "lessThan 5");
        ProcAddress.check(n1.lessThan(n2), "lessThan 6");
        ProcAddress.check(!p1.lessThan(p1), "lessThan 7");
        ProcAddress.check(!p2.lessThan(p2), "lessThan 8");
        ProcAddress.check(!n1.lessThan(n1), "lessThan 9");
        ProcAddress.check(!n2.lessThan(n2), "lessThan 10");
        ProcAddress.check(!p2.lessThan(p1), "lessThan 11");
        ProcAddress.check(!n1.lessThan(p1), "lessThan 12");
        ProcAddress.check(!n2.lessThan(p1), "lessThan 13");
        ProcAddress.check(!n1.lessThan(p2), "lessThan 14");
        ProcAddress.check(!n2.lessThan(p2), "lessThan 15");
        ProcAddress.check(!n2.lessThan(n1), "lessThan 16");
        ProcAddress.check(p1.lessThanOrEqual(p1), "lessThanOrEqual 1");
        ProcAddress.check(p2.lessThanOrEqual(p2), "lessThanOrEqual 2");
        ProcAddress.check(n1.lessThanOrEqual(n1), "lessThanOrEqual 3");
        ProcAddress.check(n2.lessThanOrEqual(n2), "lessThanOrEqual 4");
        ProcAddress.check(p1.lessThanOrEqual(p2), "lessThanOrEqual 5");
        ProcAddress.check(p1.lessThanOrEqual(n1), "lessThanOrEqual 6");
        ProcAddress.check(p1.lessThanOrEqual(n2), "lessThanOrEqual 7");
        ProcAddress.check(p2.lessThanOrEqual(n1), "lessThanOrEqual 8");
        ProcAddress.check(p2.lessThanOrEqual(n2), "lessThanOrEqual 9");
        ProcAddress.check(n1.lessThanOrEqual(n2), "lessThanOrEqual 10");
        ProcAddress.check(!p2.lessThanOrEqual(p1), "lessThanOrEqual 11");
        ProcAddress.check(!n1.lessThanOrEqual(p1), "lessThanOrEqual 12");
        ProcAddress.check(!n2.lessThanOrEqual(p1), "lessThanOrEqual 13");
        ProcAddress.check(!n1.lessThanOrEqual(p2), "lessThanOrEqual 14");
        ProcAddress.check(!n2.lessThanOrEqual(p2), "lessThanOrEqual 15");
        ProcAddress.check(!n2.lessThanOrEqual(n1), "lessThanOrEqual 16");
        ProcAddress.check(n2.greaterThan(p1), "greaterThan 1");
        ProcAddress.check(n2.greaterThan(p2), "greaterThan 2");
        ProcAddress.check(n2.greaterThan(n1), "greaterThan 3");
        ProcAddress.check(n1.greaterThan(p1), "greaterThan 4");
        ProcAddress.check(n1.greaterThan(p2), "greaterThan 5");
        ProcAddress.check(p2.greaterThan(p1), "greaterThan 6");
        ProcAddress.check(!p1.greaterThan(p1), "greaterThan 7");
        ProcAddress.check(!p2.greaterThan(p2), "greaterThan 8");
        ProcAddress.check(!n1.greaterThan(n1), "greaterThan 9");
        ProcAddress.check(!n2.greaterThan(n2), "greaterThan 10");
        ProcAddress.check(!p1.greaterThan(n2), "greaterThan 11");
        ProcAddress.check(!p2.greaterThan(n2), "greaterThan 12");
        ProcAddress.check(!n1.greaterThan(n2), "greaterThan 13");
        ProcAddress.check(!p1.greaterThan(n1), "greaterThan 14");
        ProcAddress.check(!p2.greaterThan(n1), "greaterThan 15");
        ProcAddress.check(!p1.greaterThan(p2), "greaterThan 16");
        ProcAddress.check(p1.greaterThanOrEqual(p1), "greaterThanOrEqual 1");
        ProcAddress.check(p2.greaterThanOrEqual(p2), "greaterThanOrEqual 2");
        ProcAddress.check(n1.greaterThanOrEqual(n1), "greaterThanOrEqual 3");
        ProcAddress.check(n2.greaterThanOrEqual(n2), "greaterThanOrEqual 4");
        ProcAddress.check(n2.greaterThanOrEqual(p1), "greaterThanOrEqual 5");
        ProcAddress.check(n2.greaterThanOrEqual(p2), "greaterThanOrEqual 6");
        ProcAddress.check(n2.greaterThanOrEqual(n1), "greaterThanOrEqual 7");
        ProcAddress.check(n1.greaterThanOrEqual(p1), "greaterThanOrEqual 8");
        ProcAddress.check(n1.greaterThanOrEqual(p2), "greaterThanOrEqual 9");
        ProcAddress.check(p2.greaterThanOrEqual(p1), "greaterThanOrEqual 10");
        ProcAddress.check(!p1.greaterThanOrEqual(n2), "greaterThanOrEqual 11");
        ProcAddress.check(!p2.greaterThanOrEqual(n2), "greaterThanOrEqual 12");
        ProcAddress.check(!n1.greaterThanOrEqual(n2), "greaterThanOrEqual 13");
        ProcAddress.check(!p1.greaterThanOrEqual(n1), "greaterThanOrEqual 14");
        ProcAddress.check(!p2.greaterThanOrEqual(n1), "greaterThanOrEqual 15");
        ProcAddress.check(!p1.greaterThanOrEqual(p2), "greaterThanOrEqual 16");
        System.err.println("ProcAddress: all tests passed successfully.");
    }
}

