# frozen_string_literal: true

class ModifyUpdateVulnerabilityReadsTriggerFunction < Gitlab::Database::Migration[2.2]
  include Gitlab::Database::SchemaHelpers

  milestone '17.6'

  FUNCTION_NAME = 'update_vulnerability_reads_from_vulnerability'

  def up
    create_trigger_function(FUNCTION_NAME, replace: true) do
      <<~SQL
        UPDATE
          vulnerability_reads
        SET
          severity = NEW.severity,
          state = NEW.state,
          resolved_on_default_branch = NEW.resolved_on_default_branch,
          auto_resolved = NEW.auto_resolved
        WHERE vulnerability_id = NEW.id;
        RETURN NULL;
      SQL
    end
  end

  def down
    create_trigger_function(FUNCTION_NAME, replace: true) do
      <<~SQL
        UPDATE
          vulnerability_reads
        SET
          severity = NEW.severity,
          state = NEW.state,
          resolved_on_default_branch = NEW.resolved_on_default_branch
        WHERE vulnerability_id = NEW.id;
        RETURN NULL;
      SQL
    end
  end
end
